UNIT BLOCKS;


INTERFACE
TYPE
   Board_type=array[1..15,1..10] OF boolean;
   piece_type=array[1..4,1..4] OF boolean;
   piece_array=array[1..7] OF piece_type;

VAR board:board_type;
    piece:piece_array;
PROCEDURE define_pieces;
PROCEDURE draw_piece(piece_num:byte; posx,posy,color:word);
PROCEDURE erase_piece(piece_num:byte; posx,posy:word);
PROCEDURE rotate_piece(piece_num,numtimes:byte);
PROCEDURE draw_box(x,y,w,h,color:word; fill:boolean);
PROCEDURE write_board;
PROCEDURE Blit_String(x,y,color:INTEGER; word:string; trans_flag:boolean);

IMPLEMENTATION


PROCEDURE Blit_Char(xc,yc:INTEGER; c:CHAR; color:byte; trans_flag:BOOLEAN);

VAR offset,x,y:INTEGER;
    work_char:byte;
    bit_mask:byte;

BEGIN
work_char:=mem[$f000:$fa6e+ (ord(c) * 8-1)];
offset := (yc SHL 8) + (yc SHL 6) + xc;
for y:=0 to 8-1 DO
BEGIN
  bit_mask:=$80;
  for x:=0 to 8-1 DO
  BEGIN
    if (work_char AND bit_mask)<>0 THEN
    mem[$a000:offset+x]:=color
    ELSE IF (NOT trans_flag) THEN
          mem[$a000:offset+x]:=0;
    bit_mask:=(bit_mask SHR 1);
  END;
  offset := offset + 320;
  work_char:=mem[$f000:$fa6e+ (ord(c) * 8)+y];
END;
END;

PROCEDURE Blit_String(x,y,color:INTEGER; word:string; trans_flag:boolean);

VAR index:integer;

BEGIN
  FOR index:=1 TO length(word) DO
  BEGIN
    Blit_Char(x+(index SHL 3),y,word[index],color,trans_flag);
  END;
END;

PROCEDURE plot_pixel(x,y,color:word);
BEGIN
  mem[$a000:(y SHL 8)+(y SHL 6)+x]:=color;
END;

PROCEDURE draw_box(x,y,w,h,color:word; fill:boolean);

VAR row,column:word;

BEGIN
 FOR column:=y TO y+h DO
  FOR row:=x TO x+w DO
    IF fill THEN
     plot_pixel(row,column,color)
    ELSE IF (row=x) OR (row=x+w) OR (column=y) OR (column=y+h)
    THEN plot_pixel(row,column,color);
END;

PROCEDURE write_board;

VAR row,column:byte;

BEGIN
  draw_box(109,9,152,160,0,true);
  FOR row:=1 to 15 DO
  FOR column:=1 to 10 DO
   IF board[row,column] THEN
     blit_char(100+column*10,10+row*10,'1',15,true)
     ELSE  blit_char(100+column*10,10+row*10,'0',15,true);

END;

PROCEDURE define_pieces;
BEGIN
  piece[1,1,1]:=TRUE; piece[1,2,1]:=FALSE; piece[1,3,1]:=FALSE; piece[1,4,1]:=FALSE;
  piece[1,1,2]:=TRUE; piece[1,2,2]:=FALSE; piece[1,3,2]:=FALSE; piece[1,4,2]:=FALSE;
  piece[1,1,3]:=TRUE; piece[1,2,3]:=FALSE; piece[1,3,3]:=FALSE; piece[1,4,3]:=FALSE;
  piece[1,1,4]:=TRUE; piece[1,2,4]:=FALSE; piece[1,3,4]:=FALSE; piece[1,4,4]:=FALSE;

  piece[2,1,1]:=TRUE; piece[2,2,1]:=TRUE; piece[2,3,1]:=FALSE; piece[2,4,1]:=FALSE;
  piece[2,1,2]:=TRUE; piece[2,2,2]:=TRUE; piece[2,3,2]:=FALSE; piece[2,4,2]:=FALSE;
  piece[2,1,3]:=FALSE; piece[2,2,3]:=FALSE; piece[2,3,3]:=FALSE; piece[2,4,3]:=FALSE;
  piece[2,1,4]:=FALSE; piece[2,2,4]:=FALSE; piece[2,3,4]:=FALSE; piece[2,4,4]:=FALSE;

  piece[3,1,1]:=TRUE; piece[3,2,1]:=TRUE; piece[3,3,1]:=TRUE; piece[3,4,1]:=FALSE;
  piece[3,1,2]:=FALSE; piece[3,2,2]:=TRUE; piece[3,3,2]:=FALSE; piece[3,4,2]:=FALSE;
  piece[3,1,3]:=FALSE; piece[3,2,3]:=FALSE; piece[3,3,3]:=FALSE; piece[3,4,3]:=FALSE;
  piece[3,1,4]:=FALSE; piece[3,2,4]:=FALSE; piece[3,3,4]:=FALSE; piece[3,4,4]:=FALSE;

  piece[4,1,1]:=TRUE; piece[4,2,1]:=TRUE; piece[4,3,1]:=FALSE; piece[4,4,1]:=FALSE;
  piece[4,1,2]:=FALSE; piece[4,2,2]:=TRUE; piece[4,3,2]:=TRUE; piece[4,4,2]:=FALSE;
  piece[4,1,3]:=FALSE; piece[4,2,3]:=FALSE; piece[4,3,3]:=FALSE; piece[4,4,3]:=FALSE;
  piece[4,1,4]:=FALSE; piece[4,2,4]:=FALSE; piece[4,3,4]:=FALSE; piece[4,4,4]:=FALSE;

  piece[5,1,1]:=FALSE; piece[5,2,1]:=TRUE; piece[5,3,1]:=TRUE; piece[5,4,1]:=FALSE;
  piece[5,1,2]:=TRUE; piece[5,2,2]:=TRUE; piece[5,3,2]:=FALSE; piece[5,4,2]:=FALSE;
  piece[5,1,3]:=FALSE; piece[5,2,3]:=FALSE; piece[5,3,3]:=FALSE; piece[5,4,3]:=FALSE;
  piece[5,1,4]:=FALSE; piece[5,2,4]:=FALSE; piece[5,3,4]:=FALSE; piece[5,4,4]:=FALSE;

  piece[6,1,1]:=TRUE; piece[6,2,1]:=FALSE; piece[6,3,1]:=FALSE; piece[6,4,1]:=FALSE;
  piece[6,1,2]:=TRUE; piece[6,2,2]:=FALSE; piece[6,3,2]:=FALSE; piece[6,4,2]:=FALSE;
  piece[6,1,3]:=TRUE; piece[6,2,3]:=TRUE; piece[6,3,3]:=FALSE; piece[6,4,3]:=FALSE;
  piece[6,1,4]:=FALSE; piece[6,2,4]:=FALSE; piece[6,3,4]:=FALSE; piece[6,4,4]:=FALSE;

  piece[7,1,1]:=FALSE; piece[7,2,1]:=TRUE; piece[7,3,1]:=FALSE; piece[7,4,1]:=FALSE;
  piece[7,1,2]:=FALSE; piece[7,2,2]:=TRUE; piece[7,3,2]:=FALSE; piece[7,4,2]:=FALSE;
  piece[7,1,3]:=TRUE; piece[7,2,3]:=TRUE; piece[7,3,3]:=FALSE; piece[7,4,3]:=FALSE;
  piece[7,1,4]:=FALSE; piece[7,2,4]:=FALSE; piece[7,3,4]:=FALSE; piece[7,4,4]:=FALSE;
END;

PROCEDURE draw_piece(piece_num:byte; posx,posy,color:word);

VAR row,column:byte;

BEGIN
  FOR row:=1 TO 4 DO
  FOR column:=1 TO 4 DO
    IF piece[piece_num,row,column]=true THEN
    BEGIN
      draw_box(((posx-1)*10+(row-1)*10)+2,((posy-1)*10+(column-1)*10)+2
               ,10,10,color,true);
      draw_box(((posx-1)*10+(row-1)*10)+2,((posy-1)*10+(column-1)*10)+2
               ,10,10,255,false);
    END;
END;

PROCEDURE erase_piece(piece_num:byte; posx,posy:word);

VAR row,column:byte;

BEGIN
  FOR row:=1 TO 4 DO
  FOR column:=1 TO 4 DO
    IF piece[piece_num,row,column]=true THEN
      draw_box(((posx-1)*10+(row-1)*10)+2,((posy-1)*10+(column-1)*10)+2
               ,10,10,0,true);
END;

PROCEDURE rotate_piece(piece_num,numtimes:byte);

{----- Rotates a block matrix a certain number of times -----}

VAR tran_mat,temp:piece_type;
    c1,counter,row,column:byte;
    found:boolean;

BEGIN
FOR counter:=1 TO numtimes DO
BEGIN
  tran_mat[1,4]:=piece[piece_num,1,1];      {Rotate matrix}
  tran_mat[2,4]:=piece[piece_num,1,2];
  tran_mat[3,4]:=piece[piece_num,1,3];
  tran_mat[4,4]:=piece[piece_num,1,4];

  tran_mat[1,3]:=piece[piece_num,2,1];
  tran_mat[1,2]:=piece[piece_num,3,1];
  tran_mat[1,1]:=piece[piece_num,4,1];

  tran_mat[2,1]:=piece[piece_num,4,2];
  tran_mat[3,1]:=piece[piece_num,4,3];
  tran_mat[4,1]:=piece[piece_num,4,4];

  tran_mat[4,3]:=piece[piece_num,2,4];
  tran_mat[4,2]:=piece[piece_num,3,4];
  tran_mat[4,1]:=piece[piece_num,4,4];

  tran_mat[2,3]:=piece[piece_num,2,2];
  tran_mat[3,3]:=piece[piece_num,2,3];
  tran_mat[2,2]:=piece[piece_num,3,2];
  tran_mat[3,2]:=piece[piece_num,3,3];

  {------------ Move Block All The Way To The Left of Matrix -----------}

  FOR row:=1 to 4 DO
  FOR column:=1 TO 4 DO
      temp[row,column]:=false;  {Initialize temp block to empty}

  found:=false;
  column:=1;
  REPEAT                {Go through columns to see if a block is there}
    row:=1;
  REPEAT
    IF tran_mat[row,column] THEN found:=true;  {If block found exit}
    row:=row+1;
  UNTIL (row>4) OR (found);
    IF not(found) THEN column:=column+1;
  UNTIL found;

  IF column>1 THEN       {move everything to the left}
  BEGIN
    FOR c1:=column TO 4 DO
      FOR row:=1 TO 4 DO
             temp[row,c1-column+1]:=tran_mat[row,c1];
    tran_mat:=temp;
  END;

   piece[piece_num]:=tran_mat;  {return rotated block}
 END;
END;

BEGIN
END.