Program tetris;

USES pcx,blocks,detect,dos,crt;

VAR score:word;

PROCEDURE init_board;

VAR row,column:byte;

BEGIN
 FOR row:=1 TO 15 DO
 FOR column:=1 TO 10 DO
    board[row,column]:=false;
END;

PROCEDURE clear_board;
BEGIN
  draw_box(2,2,100,150,0,true);
END;

PROCEDURE redraw_board;

VAR row,column:byte;

BEGIN
  FOR row:=1 TO 15 DO
  FOR column:=1 TO 10 DO
     IF board[row,column] THEN
     BEGIN
      draw_box(((column-1)*10)+2,((row-1)*10)+2
               ,10,10,253,true);
      draw_box(((column-1)*10)+2,((row-1)*10)+2
               ,10,10,255,false);
     END;
END;

PROCEDURE check_row;

VAR numrow,row,column,r1,c1:byte;
    filled:boolean;
    temp1,temp2:string;

BEGIN
 numrow:=0;
  FOR row:=1 to 15 DO
  BEGIN
    filled:=true;
    column:=1;
  WHILE (filled) AND (column<11) DO
  BEGIN
    IF board[row,column]=false THEN filled:=false;
    IF filled THEN column:=column+1;
  END;
  IF filled THEN
  BEGIN
    FOR r1:=row-1 DOWNTO 1 DO
    FOR c1:=1 TO 10 DO
       board[r1+1,c1]:=board[r1,c1];
    FOR c1:=1 TO 10 DO
      board[1,c1]:=FALSE;
    clear_board;
    INC(numrow);
    redraw_board;
  END;
 END;
 IF numrow=4 THEN score:=score+800
 ELSE score:=score+numrow*100;
 IF numrow>0 THEN
 BEGIN
 draw_box(2,175,90,20,0,true);
 temp1:='SCORE: ';
 str(score,temp2);
 temp1:=temp1+temp2;
 blit_string(2,180,254,temp1,TRUE);
 END;
END;



PROCEDURE draw_board;
BEGIN
  draw_box(1,1,102,152,43,false);
END;

PROCEDURE putonboard(num,row,column:byte);

VAR xpos,ypos:byte;

BEGIN
  FOR xpos:=1 to 4 DO
  FOR ypos:=1 TO 4 DO
    IF (piece[num,xpos,ypos]=TRUE) THEN
    board[ypos+column-1,xpos+row-1]:=TRUE
END;


PROCEDURE drop_piece;

VAR counter,piecenum,lr,lc,row,column:byte;
    input:char;
    done,rotated:boolean;

BEGIN
REPEAT
  row:=4;
  column:=1;
  done:=false;
  piecenum:=RANDOM(7)+1;
  REPEAT
    rotated:=false;
    draw_piece(piecenum,row,column,254);
    delay(800);
    lr:=row;
    lc:=column;
    erase_piece(piecenum,row,column);
    IF check_bottom(piecenum,row,column+1) THEN column:=column+1
    ELSE
    BEGIN
     done:=true;
     IF rotated THEN rotate_piece(piecenum,3);
     draw_piece(piecenum,lr,lc,253);
     putonboard(piecenum,lr,lc);
     {write_board;}
     IF column=1 THEN input:='q';
    END;
    FOR counter:=1 TO 2 DO
    IF (input<>'q') AND keypressed THEN
    BEGIN
    input:=readkey;
    CASE input of
    char($04b):IF check_left(piecenum,row-1,column) THEN row:=row-1;
    char($04d):IF check_right(piecenum,row+1,column) THEN row:=row+1;
    char($20):BEGIN
          rotate_piece(piecenum,1);
          IF check_piece(row,column,piece[piecenum])
          THEN rotated:=true
          ELSE rotate_piece(piecenum,3);
        END;
    'q':done:=true;
    END;
    END;
 UNTIL done;
 check_row;
 define_pieces;
 UNTIL input='q';
END;

BEGIN
  randomize;
  define_pieces;
  init256graph;
  score:=0;
  viewpcxfile('bds.pcx');
  blit_string(2,180,254,'SCORE: 0',TRUE);
  draw_board;
  drop_piece;
  textmode(3);
END.
