;-----------------------------------------------------------------------------
;   TETRIS...A_PANTAL: Gestion de la pantalla: Rutinas de acceso directo a
;                         la pantalla.
;-----------------------------------------------------------------------------
;   Creado...........: 03/11/94
;   Ultima revision..: 04/11/94. CHEMA
;
;   Funciona perfectamente.
;-----------------------------------------------------------------------------

.MODEL LARGE

.DATA
        dir_buffer  DW  ?          ; Direccion de comienzo de la pantalla
                                   ; obtenida con el PROC detectar_modo

.CODE

        PUBLIC detectar_modo       ; Procedimientos publicos
        PUBLIC poner_caracter      ;


;------------------------------------------------------------------------------
; Function detectar_modo
;------------------------------------------------------------------------------

detectar_modo    PROC  NEAR        ; Es NEAR porque no lo pongo en el
                                   ; INTERFACE de una unidad
        ASSUME DS:@DATA, CS:@CODE

        xor  ax,ax                 ; Cargo en al
        mov  es,ax                 ; el modo de
        mov  al,es:[449h]          ; video: 2,3 o 7.
        cmp  al,7
        je   B0
        cmp  al,2
        je   B8
        cmp  al,3
        je   B8
        jmp  FIN
  B0:   mov  dir_buffer,0B000h     ; Si modo video=7 entonces dir_buffer:=
        jmp  FIN                   ;              B000h
  B8:   mov  dir_buffer,0B800h     ; Si modo video=2,3 entonces dir_buffer:=
                                   ;              B800h
  FIN:
        ret

detectar_modo    ENDP

;------------------------------------------------------------------------------
; Procedure poner_caracter(f,c:byte;car:byte;atr:byte)
;           -     -        => Nombres de las refs. P de poner y c de caracter
;------------------------------------------------------------------------------

Pcf   EQU   BYTE  PTR  [bp+10]     ; Es una ref. al parametro f
Pcc   EQU   BYTE  PTR  [bp+8]      ; Es una ref. al parametro c
Pccar EQU   BYTE  PTR  [bp+6]      ; Es una ref. al parametro car
Pcatr EQU   BYTE  PTR  [bp+4]      ; Es una ref. al parametro atr

poner_caracter  PROC  NEAR         ; Es NEAR porque no lo pongo en el
                                   ; INTERFACE de una unidad
        ASSUME DS:@DATA, CS:@CODE

        push bp
        mov  bp,sp

        mov  ax,dir_buffer
        mov  es,ax              ; base del buffer
        mov  al,Pcf
        mov  dl,80              ; fila * 80
        mul  dl
        add  al,Pcc             ; + columna
        adc  ah,0               ; (*)  y por qu no utilizas operandos de
        shl  ax,1               ;     16 bits ? De todas formas en la pila
        mov  bx,ax              ;     ocupan 2 bytes.
        mov  al,Pccar
        mov  ah,Pcatr
        mov  es:[bx],ax

        pop  bp

        ret  8
poner_caracter  ENDP

END
