;----------------------------------------------------------------------------
;   TETRIS...A_SONIDO: Gestin del sonido
;----------------------------------------------------------------------------
;   Creado...........: 14/01/95
;   Ultima Revisin..: 14/01/95. Chema.
;
;   Funciona perfectamente.
;
;----------------------------------------------------------------------------

.MODEL LARGE

.CODE
        PUBLIC sonido
        PUBLIC silencio


;----------------------------------------------------------------------------
;  procedure sonido(frecuencia,duracion:integer);external;
;----------------------------------------------------------------------------

frecuencia EQU WORD PTR [bp+6]
duracion   EQU WORD PTR [bp+4]

sonido  PROC  NEAR                 ; es NEAR porque no aparece en el INTERFACE
                                   ; de una unidad
        ASSUME CS:@CODE

        push bp
        mov  bp,sp

        mov bx,frecuencia;   ; valor para programar el TIMER=
        mov dx,0012h;        ;  1.19e6/frecuencia = 0012 34DCh / frec
        mov ax,34DCh;
        div bx
        mov bx,ax            ; resultado

        mov al,0B6h
        out 43h,al        ; programacin del TIMER2 en modo 3

        mov al,bl         ; parte baja del valor para TIMER
        out 42h,al
        mov al,bh         ; parte alta del valor para TIMER
        out 42h,al
        in al,61h
        push ax
        or al,3
        out 61h,al

        mov bx,duracion
bucle1: mov cx,08000h
espera1:loop espera1
        dec bx
        jnz bucle1

        pop ax
        out 61h,al

        pop bp

        ret 4

sonido  ENDP

;----------------------------------------------------------------------------
;       procedure silencio(duracion:integer);external;
;----------------------------------------------------------------------------

duracion EQU WORD PTR [bp+4]

silencio  PROC NEAR                ; es NEAR porque no aparece en el INTERFACE
                                   ; de una unidad
          ASSUME CS:@CODE

          push bp
          mov  bp,sp

          mov bx,duracion
bucle2:   mov cx,08000h
espera2:  loop espera2
          dec bx
          jnz bucle2

          pop bp

          ret 2

silencio  ENDP

END