;----------------------------------------------------------------------------
;   TETRIS...A_TECLAD: Gestin del teclado: Rutina de Interrupcin
;----------------------------------------------------------------------------
;   Creado...........: 01/11/94
;   Ultima Revisin..: 02/11/94. Javier.
;
;   Funciona perfectamente.
;
;----------------------------------------------------------------------------

.MODEL LARGE

.DATA
      EXTRN tcl_izquierda : BYTE       ; los booleanos son bytes
      EXTRN tcl_derecha   : BYTE
      EXTRN tcl_abajo     : BYTE
      EXTRN tcl_espacio   : BYTE
      EXTRN tcl_escape    : BYTE       ; Variables de PASCAL
      EXTRN tcl_pausa     : BYTE

      antigua_rutina_servicio DW ?     ; Espacio para salvar la direccin
                              DW ?     ; antigua

.CODE

      PUBLIC __instala_rutina_teclado
      PUBLIC __desinstala_rutina_teclado

      num_vector_teclado      EQU 9h
      vector_teclado_offset   EQU 4*num_vector_teclado
      vector_teclado_segmento EQU 4*num_vector_teclado+2

__instala_rutina_teclado PROC FAR  ; es FAR porque aparece en el INTERFACE
                                   ; de una unidad
        ASSUME DS:@DATA, CS:@CODE

        xor ax,ax
        mov es,ax
        mov ax,es:vector_teclado_offset
        mov word ptr antigua_rutina_servicio,ax
        mov ax,es:vector_teclado_segmento
        mov word ptr antigua_rutina_servicio[2],ax  ; salvamos la @ anterior

        cli
        mov ax,OFFSET rutina_servicio_teclado
        mov es:vector_teclado_offset,ax
        mov ax,SEG rutina_servicio_teclado
        mov es:vector_teclado_segmento,ax           ; ponemos nuestra rutina
        sti

        retcode

__instala_rutina_teclado ENDP

__desinstala_rutina_teclado PROC FAR ; es FAR porque aparece en el INTERFACE
                                   ; de una unidad

        ASSUME DS:@DATA, CS:@CODE

        xor ax,ax
        mov es,ax

        cli
        mov ax,word ptr antigua_rutina_servicio
        mov es:vector_teclado_offset,ax
        mov ax,word ptr antigua_rutina_servicio[2]
        mov es:vector_teclado_segmento,ax         ; restauramos lo que hubiera
        sti

        retcode

__desinstala_rutina_teclado ENDP


rutina_servicio_teclado PROC FAR

              ASSUME DS:@DATA

              push ax
              push bx
              push cx
              push dx
              push ds

              mov ax,@data
              mov ds,ax

              xor  cl,cl
              in   al,60h                ; Lectura del port de teclado
              test al,80h                ;
              jnz  es_un_break           ;
              inc  cl                    ; si make entonces cx=1 sino cx=0

es_un_break:  and  al,01111111b          ; eliminar el 1xxxxxxx si es break

empezamos:        cmp al,80                     ;
                  jne no_es_abajo               ;
                  mov tcl_abajo,cl              ;  ABAJO
                  jmp ya_esta_hecho             ;

no_es_abajo:      cmp al,77                     ;
                  jne tampoco_derecha           ;
                  mov tcl_derecha,cl            ;  DERECHA
                  jmp ya_esta_hecho             ;

tampoco_derecha:  cmp al,75                     ;
                  jne tampoco_izquierda         ;
                  mov tcl_izquierda,cl          ;  IZQUIERDA
                  jmp ya_esta_hecho             ;

tampoco_izquierda: cmp al,57                    ;
                   jne tampoco_espacio          ;
                   mov tcl_espacio,cl           ;  ESPACIO
                   jmp ya_esta_hecho            ;

tampoco_espacio:  cmp al,1                      ;
                  jne tampoco_escape            ;
                  mov tcl_escape,cl             ;  ESCAPE
                  jmp ya_esta_hecho             ;

tampoco_escape:   cmp al,25                     ;
                  jne ya_esta_hecho             ;  PAUSA = 'P'
                  mov tcl_pausa,cl              ;

ya_esta_hecho: in   al,61h   ;-------------------;
               or   al,80h   ;                   ;
               out  61h,al   ;      Strobe       ;
               and  al,7Fh   ;                   ;
               out  61h,al   ;-------------------;
               mov  al,20h   ; End Of Interrupt  ;
               out  20h,al   ;-------------------;

        pop ds
        pop dx
        pop cx
        pop bx
        pop ax
        iret
rutina_servicio_teclado ENDP

END