;---------------------------------------------------------------------------
;    TETRIS...A_UART: Gestion de la linea serie: Rutinas de programacion,
;                      transmision y recepcion de la linea serie.
;---------------------------------------------------------------------------
;    Creado..............: 22/11/94.
;    Ultima revision.....: 22/11/94. Chema.
;    Siguiente revision..: 06/12/94. Chema.
;---------------------------------------------------------------------------

.MODEL LARGE
.DATA


  numPuerto DB ?      ; Almacen permanente del puerto por el que se transmite

  dir_LCR    DW ?
  dir_DLLSB  DW ?
  dir_LSR    DW ?
  dir_THR    DW ?
  dir_IER    DW ?
  dir_MCR    DW ?
  dir_RBR    DW ?

  antigua_rutina_servicio DW ?     ; Espacio para salvar la direccin de la
                          DW ?     ; antigua rutina de la linea serie

  EXTRN contador : WORD

.CODE
        PUBLIC configurar_uart
        PUBLIC __instalar_rutina_uart
        PUBLIC __desinstalar_rutina_uart
        PUBLIC mandar_mensaje

        EXTRN  encolar_mensaje : FAR

;---------------------------------------------------------------------------
; Procedimiento configurar_uart(num_puerto,velocidad,bits_parada,
;                               paridad:byte);
;---------------------------------------------------------------------------
; Velocidades posibles:
;   50b    EQU   0900h
;  150b    EQU   0300h
;  300b    EQU   0180h
;  600b    EQU   00C0h
; 1200b    EQU   0060h
; 2400b    EQU   0030h
; 4800b    EQU   0018h
; 9600b    EQU   000Ch

; Direccion del LCR:
com1_LCR   EQU    3FBh
com2_LCR   EQU    2FBh

; Direccion del DLR
com1_DLLSB EQU    3F8h
                                ; com1_DLMSB EQU    3F9h
com2_DLLSB EQU    2F8h
                                ; com2_DLMSB EQU    2F9h

com1_LSR  EQU  3FDh
com2_LSR  EQU  2FDh
com1_THR  EQU  3F8h
com2_THR  EQU  2F8h
com1_IER  EQU  3F9h
com2_IER  EQU  2F9h
com1_MCR  EQU  3FCh
com2_MCR  EQU  2FCh
com1_RBR  EQU  3F8h
com2_RBR  EQU  2F8h

; Nombres referentes a los parametros que voy a pasar desde PASCAL:

num_puerto  EQU  BYTE PTR [bp+10]
velocidad   EQU  WORD PTR [bp+8]
bits_parada EQU  BYTE PTR [bp+6]
paridad     EQU  BYTE PTR [bp+4]


configurar_uart  PROC  NEAR     ; es NEAR porque no lo pongo en el INTERFACE
                                ; de una unidad

            ASSUME DS:@DATA,CS:@CODE

            push bp
            mov  bp,sp

            cmp  num_puerto,0
            jne  COM2

COM1:       mov  dir_LCR,com1_LCR
            mov  dir_DLLSB,com1_DLLSB
            mov  dir_LSR,com1_LSR
            mov  dir_THR,com1_THR
            mov  dir_IER,com1_IER
            mov  dir_MCR,com1_MCR
            mov  dir_RBR,com1_RBR
            jmp  SEGUIR

COM2:       mov  dir_LCR,com2_LCR
            mov  dir_DLLSB,com2_DLLSB
            mov  dir_LSR,com2_LSR
            mov  dir_THR,com2_THR
            mov  dir_IER,com2_IER
            mov  dir_MCR,com2_MCR
            mov  dir_RBR,com2_RBR

SEGUIR:     mov  al,80h
            mov  dx,dir_LCR     ; cargo en dx la direccion del LCR de COMX
            out  dx,al          ; pongo a 1 el bit 7 del LCR para acceder a
                                ; a DLLSB y a DLMSB

            mov  dx,dir_DLLSB
            mov  ax,velocidad
            out  dx,al
            inc  dx
            mov  al,ah
            out  dx,al

            mov  al,00000011b   ; Bit 7=0 para poder transmitir y
                                ; bits 1-0=11 para transm.con 8 caracteres
            or   al,bits_parada
            or   al,paridad
            mov  dx,dir_LCR
            out  dx,al

            mov  dx,dir_IER     ; programacin del IER
            mov  al,00000001b   ; interrupciones solo para recepcin
            out  dx,al

            mov  dx,dir_MCR     ; programacin del MCR
            mov  al,08h         ; bit 3 de MCR=1 (permitir interrupciones)
            out  dx,al

            pop bp
            ret 8
configurar_uart  ENDP

;---------------------------------------------------------------------------
;  Procedure instalar_rutina_uart; external;
;---------------------------------------------------------------------------

num_vector_uart      EQU 0Bh                  ; para COM2
vector_uart_offset   EQU 4*num_vector_uart
vector_uart_segmento EQU 4*num_vector_uart+2

__instalar_rutina_uart  PROC  FAR         ; FAR porque lo pongo en el interface
                                          ; de una unidad
        ASSUME DS:@DATA, CS:@CODE

        xor ax,ax
        mov es,ax
        mov ax,es:vector_uart_offset
        mov word ptr antigua_rutina_servicio,ax
        mov ax,es:vector_uart_segmento
        mov word ptr antigua_rutina_servicio[2],ax  ; salvamos la @ anterior

        cli
        mov ax,OFFSET rutina_servicio_uart
        mov es:vector_uart_offset,ax
        mov ax,SEG rutina_servicio_uart
        mov es:vector_uart_segmento,ax          ; ponemos nuestra rutina

        in al,21h        ; lectura del IMR;
        and al,11110111b ; habilitamos con un 0 el bit 3
        out 21h,al       ; escritura del IMR;

        sti

        retf


__instalar_rutina_uart  ENDP


;---------------------------------------------------------------------------
;  Procedure desinstalar_rutina_uart; external;
;---------------------------------------------------------------------------

__desinstalar_rutina_uart  PROC  FAR    ; FAR porque aparece en el interface
                                        ; de una unidad

        ASSUME DS:@DATA, CS:@CODE

        xor ax,ax
        mov es,ax

        cli
        in al,21h        ; lectura del IMR;
        or  al,00001000b ; inhabilitamos con un 1 el bit 3
        out 21h,al       ; escritura del IMR;

        mov ax,word ptr antigua_rutina_servicio
        mov es:vector_uart_offset,ax
        mov ax,word ptr antigua_rutina_servicio[2]
        mov es:vector_uart_segmento,ax         ; restauramos lo que hubiera
        sti

        retf
__desinstalar_rutina_uart  ENDP

;---------------------------------------------------------------------------
;  rutina_servicio_uart se encarga de manejar los datos recibidos por la
;  linea serie, asi como los errores posibles procedentes de la
;  transmision.
;---------------------------------------------------------------------------

rutina_servicio_uart PROC FAR
        ASSUME DS:@DATA, CS:@CODE

        push bp
        mov bp,sp

        push ax
        push dx
        push ds
        mov ax,@DATA
        mov ds,ax

        mov  dx,dir_LSR
        in   al,dx
        test al,01h     ; comprobacin de que existe caracter recibido
        jz   fin_de_int

        xor  ax,ax
        mov  dx,dir_RBR ; recibir mensaje
        in   al,dx

        push ax
        call encolar_mensaje

fin_de_int:
        mov al,20h      ; EOI
        out 20h,al

        inc contador

        pop ds
        pop dx
        pop ax
        pop bp

        iret
rutina_servicio_uart ENDP

;---------------------------------------------------------------------------
;  Procedure mandar_mensaje(m:mensaje); external;
;---------------------------------------------------------------------------

m          EQU  WORD PTR [bp+6]


mandar_mensaje  PROC  FAR

            ASSUME DS:@DATA,CS:@CODE

            push bp
            mov  bp,sp

ENVIAR:     mov  dx,dir_LSR
            in   al,dx
            test al,20h         ; Transmision posible?
            jz   ENVIAR
            mov  dx,dir_THR
            mov  ax,m
            out  dx,al

            pop  bp

            retf  2
mandar_mensaje  ENDP

END