{-----------------------------------------------------------------------}
{   TETRIS...Programa Principal                                         }
{-----------------------------------------------------------------------}
{   Creado...........: 31/10/94                                         }
{   Ultima Revisin..: 09/01/95.                                        }
{                                                                       }
{-----------------------------------------------------------------------}
program main;
uses u_var,                { parmetros globales                        }
     u_teclad,             { rutinas de teclado                         }
     u_pantal,             { rutinas de pantalla                        }
     u_fondo,              { diseo del fondo                           }
     u_pieza,              { definicin y tratamiento de piezas         }
     u_tabler,             { tratamiento del tablero de juego           }
     u_uart,               { rutinas de la linea serie                  }
     u_marcad,             { rutinas del marcador                       }
     u_aux,                { mensajes y efectos varios                  }
     u_sonido,             { sonido                                     }
     usertext;             { redefinicin de la tabla de caracteres     }

type movimiento=byte;

const mov_izquierda =  8;
      mov_derecha   =  9;
      mov_abajo     = 10;
      mov_rotacion  = 11;

procedure pausa;
begin
  tcl_pausa:=false;
  repeat
  until tcl_espacio=true;
  tcl_espacio:=false;
end;


function mueve_pieza(var p:pieza; var t:tablero; m:movimiento):boolean;
var p_sin_mover : pieza;
    quadros     : cuadros;
    i           : integer;
    fq,cq       : byte;
    posible     : boolean;
begin
  p_sin_mover:=p;
  case m of
    mov_abajo     :  p.f:=p.f+1;
    mov_izquierda :  p.c:=p.c-1;
    mov_derecha   :  p.c:=p.c+1;
    mov_rotacion  :  gira_pieza(p);
  end;
  dame_cuadros(p,quadros);

  i:=1; posible:=true;
  while posible and (i<=4) do
    begin
      fq:=p.f+quadros[i].f;
      cq:=p.c+quadros[i].c ;
      posible:=(fq<=altura_tablero) and (cq>=1) and (cq<=anchura_tablero)
               and (t.espacio_juego[fq,cq]=vacio);
      inc(i);
    end;
  if posible then
    begin
      borrar_pieza(p_sin_mover,t);
      dibujar_pieza(p,t);
    end
  else
    p:=p_sin_mover;
  mueve_pieza:=posible;
end;

function deposita_pieza(var p:pieza; var t:tablero):boolean;
var i:integer;
    quadros:cuadros;
begin
  deposita_pieza:=true;
  dame_cuadros(p,quadros);
  for i:=1 to 4 do
    if t.espacio_juego[p.f+quadros[i].f,p.c+quadros[i].c]=vacio then
      t.espacio_juego[p.f+quadros[i].f,p.c+quadros[i].c]:=CP[p.forma]
    else
      deposita_pieza:=false;
end;

label salir;

type datos_jugador=record
                     p:pieza;
                     t:tablero;
                     ha_llegado_abajo,ha_terminado_nivel,ha_perdido:boolean;
                   end;

var p_siguiente:pieza;
    local,remoto: datos_jugador;
    markador     : marcador;
    tiempo,
    Tmax,
    sensibilidad1,
    sensibilidad2: longint;
    conectado:boolean;
    mens:mensaje;
    num_jugadores:integer;

begin
  if cargar_fuente(tabla_caracteres,0)=utFileNotFound then
    error('No se encuentra el fichero '+tabla_caracteres);
  inicializar_pantalla;
  presentacion;
  instala_rutina_teclado;
  num_jugadores:=cuantos_jugadores;
  if num_jugadores=2 then
    begin
     desinstala_rutina_teclado;
     set_bios_table(bios8x16font,0);
     pedir_configuracion_uart;
     instalar_rutina_uart;
     vaciar_cola_mensajes;
     conectado:=establecer_comunicacion;
     if not conectado then
       begin
         error('No se ha establecido la comunicacin por medio de la linea serie');
       end;
     cargar_fuente(tabla_caracteres,0);
     instala_rutina_teclado;
     local.ha_perdido:=false;
     remoto.ha_perdido:=false;
    end
  else
    begin
     conectado:=false;
     local.ha_perdido:=false;
     remoto.ha_perdido:=true;
    end;

  inicializar_pantalla;
  cronometro;
  randomize;

  repeat
    dibuja_fondo;
    nuevo_tablero(local.t,0);
    situa_tablero(local.t,4,5);
    dibuja_marco_tablero(local.t);
    dibuja_tablero(local.t);

    nuevo_tablero(remoto.t,0);
    situa_tablero(remoto.t,4,55);
    dibuja_marco_tablero(remoto.t);
    dibuja_tablero(remoto.t);

    toca_cancion('cancion1.not');
    efecto_barrido(local.t);
    efecto_barrido(remoto.t);

   local.ha_perdido:=false;
   remoto.ha_perdido:=not conectado;
   nuevo_marcador(markador,3,30);
   ajusta_velocidad(markador,Tmax);
   sensibilidad1:=Tmax div 30;
   sensibilidad2:=Tmax div 42;
   nueva_pieza(local.p,random(7));
   if conectado then mandar_mensaje(local.p.forma);
   nueva_pieza(p_siguiente,random(7));
   cambia_pieza_en_marcador(markador,p_siguiente);
   dibujar_pieza(local.p,local.t);
   repeat
    local.ha_terminado_nivel:=local.ha_perdido;
    remoto.ha_terminado_nivel:=remoto.ha_perdido;
    escribir_puntos_en_marcador(markador);
    repeat
      inc(tiempo);

      {Atencion al jugador remoto: }
      if not remoto.ha_terminado_nivel then
         if hay_mensaje then
           Begin
             leer_mensaje(mens);
             Case mens Of
              0..6: Begin
                     nueva_pieza(remoto.p,mens);
                     dibujar_pieza(remoto.p,remoto.t);
                    End;
              mov_izquierda: mueve_pieza(remoto.p,remoto.t,mov_izquierda);
              mov_derecha  : mueve_pieza(remoto.p,remoto.t,mov_derecha);
              mov_rotacion : mueve_pieza(remoto.p,remoto.t,mov_rotacion);
              mov_abajo    :
                begin
                  remoto.ha_llegado_abajo:=not mueve_pieza(remoto.p,remoto.t,mov_abajo);
                  if remoto.ha_llegado_abajo then
                    begin
                      remoto.ha_llegado_abajo:=false;
                      remoto.ha_perdido:=not deposita_pieza(remoto.p,remoto.t);
                      if not remoto.ha_perdido then
                        begin
                          actualiza_marcador(markador,comprueba_y_baja_lineas(remoto.t),_remoto);
                          dibuja_tablero(remoto.t);
                          remoto.ha_terminado_nivel:=nivel_terminado(markador,_remoto);
                        end;
                    end;
                end;
             End;

           End;

      {Atencion al jugador local: }
      if not local.ha_terminado_nivel then
        begin
          if tiempo mod sensibilidad1=0 then
            begin
              if tcl_izquierda and not tcl_derecha then
                begin
                 mueve_pieza(local.p,local.t,mov_izquierda);
                 if conectado then mandar_mensaje(mov_izquierda);
                end;
              if tcl_derecha and not tcl_izquierda then
                begin
                 mueve_pieza(local.p,local.t,mov_derecha);
                 if conectado then mandar_mensaje(mov_derecha);
                end;
            end;
          if tiempo mod sensibilidad2=0 then
            begin
              if tcl_abajo then tiempo:=Tmax+1;
              if tcl_espacio then
                begin
                 mueve_pieza(local.p,local.t,mov_rotacion);
                 if conectado then mandar_mensaje(mov_rotacion);
                 tcl_espacio:=false;
               end;
            end;

          if tiempo>Tmax div 2 then
            begin
             tiempo:=0;
             local.ha_llegado_abajo:=not mueve_pieza(local.p,local.t,mov_abajo);
             if conectado then mandar_mensaje(mov_abajo);
            end;
          if local.ha_llegado_abajo then
            begin
             local.ha_llegado_abajo:=false;
             local.ha_perdido:=not deposita_pieza(local.p,local.t);
             if not local.ha_perdido then
               begin
                actualiza_marcador(markador,comprueba_y_baja_lineas(local.t),_local);
                dibuja_tablero(local.t);
                local.ha_terminado_nivel:=nivel_terminado(markador,_local);
                {*********Genera_nueva_pieza**********}
                local.p:=p_siguiente;
                if conectado then mandar_mensaje(local.p.forma);
                nueva_pieza(p_siguiente,random(7));
                cambia_pieza_en_marcador(markador,p_siguiente);
                dibujar_pieza(local.p,local.t);

               end
             else
               begin
                local.ha_terminado_nivel:=true;
                toca_cancion('cancionf.not');
               end;
            end;
        end;

      if tcl_escape then
        begin
          if conectado then mandar_mensaje(msj_escape);
          tcl_escape:=false;
          goto salir;
        end;
      if tcl_pausa  then pausa;
    until (local.ha_terminado_nivel or local.ha_perdido) and
         (remoto.ha_terminado_nivel or remoto.ha_perdido);
    sube_de_nivel(markador);
    ajusta_velocidad(markador,Tmax);
    nuevo_tablero(local.t,markador.nivel);
    nuevo_tablero(remoto.t,markador.nivel);
    dibuja_tablero(local.t);
    dibuja_tablero(remoto.t);
    if not local.ha_perdido then toca_cancion('cancion2.not');
    efecto_barrido(local.t);
    efecto_barrido(remoto.t);

   until local.ha_perdido and remoto.ha_perdido;
salir:
  until not otra_partida;

  if num_jugadores=2 then desinstalar_rutina_uart;
  desinstala_rutina_teclado;
  restaurar_pantalla;     { re-activamos el cursor y borramos la pantalla }
  set_bios_table(bios8x16font,0);     { vuelvo a poner la fuente original }
  write(#10);
  writeln('Gracias por jugar...');
  writeln;
end.