{----------------------------------------------------------------------------}
{   TETRIS...U_MARCAD: Gestion del marcador.                                 }
{----------------------------------------------------------------------------}
{   Creado...........: 06/11/94.                                             }
{   Ultima revision..: 09/01/95.                                             }
{                                                                            }
{----------------------------------------------------------------------------}


Unit u_marcad;
Interface
 Uses u_pieza,u_var;

 Const _local=true;
       _remoto=false;

 type tpnivel=0..9;

 Type marcador=record
                  f,c:byte;
                  p_sig:pieza;
                  puntos_locales,puntos_remotos:longint;
                  nivel:tpnivel;
                  lineas_acum_locales,lineas_acum_remotas:integer;
                  lineas_que_quedan_loc,lineas_que_quedan_rem:integer
               end;
 Procedure nuevo_marcador(var m:marcador;f,c:byte);
 Procedure sube_de_nivel(var m:marcador);
 Procedure escribir_puntos_en_marcador(var m:marcador);
 Procedure actualiza_marcador(var m:marcador;numero_lineas:byte;es_local:boolean);
 Procedure cambia_pieza_en_marcador(var m:marcador;p:pieza);
 Procedure ajusta_velocidad(var m:marcador; var Tmax:longint);
 Procedure cronometro;
 Function nivel_terminado(var m:marcador; es_local:boolean):boolean;
 

Implementation

 Uses u_pantal,u_tabler;  {  para qu necesitas nada de tablero ? }

type conj_lineas=0..4;

     tp_datos_nivel= record Tmax           : longint;
                            decorado       : byte;
                            puntos_linea   : array[conj_lineas] of byte;
                            numero_lineas  : byte;
                     end;

{$IFDEF debugueando}
const niveles:array[tpnivel] of tp_datos_nivel=
((Tmax:30000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:17500; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:15000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:12500; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:10000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:07500; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:05000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:04000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:04000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:2),
 (Tmax:04000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:40));
{$ELSE}
const niveles:array[tpnivel] of tp_datos_nivel=
((Tmax:20000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:5),
 (Tmax:17500; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:10),
 (Tmax:15000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:15),
 (Tmax:12500; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:20),
 (Tmax:10000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:20),
 (Tmax:07500; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:30),
 (Tmax:05000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:30),
 (Tmax:04000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:30),
 (Tmax:04000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:30),
 (Tmax:04000; decorado:0 ; puntos_linea:(1,2,10,25,50); numero_lineas:40));
{$ENDIF}

 Const anchura_marcador=18;
       altura_marcador=21;
       rojo_blanco=$4F;


 Procedure dibujar_marcador(var m:marcador);
 Begin
   rellenar_caja(m.f,m.c,m.f+altura_marcador,m.c+anchura_marcador,blanco,ord(' '));
   dibujar_caja(m.f,m.c,m.f+altura_marcador,m.c+anchura_marcador,blanco,simple);
   rellenar_caja(m.f+2,m.c+5,m.f+5,m.c+16,negro,ord(lleno));
   dibujar_linea_hor(m.f+5,m.c,m.c+anchura_marcador,blanco,true);
   mover_cursor(m.f+6,m.c+1);
   escribir_cad_hor(' NIVEL:',blanco);
   dibujar_linea_hor(m.f+7,m.c,m.c+anchura_marcador,blanco,true);
   mover_cursor(m.f+8,m.c+2);
   escribir_cad_hor('<<<       LOCAL',azulcl);
   mover_cursor(m.f+10,m.c+2);
   escribir_cad_hor('LINEAS....:',blanco);
   mover_cursor(m.f+11,m.c+2);
   escribir_cad_hor('TE QUEDAN.:',blanco);
   mover_cursor(m.f+12,m.c+2);
   escribir_cad_hor('PUNTOS....:',blanco);
   dibujar_linea_hor(m.f+13,m.c,m.c+anchura_marcador,blanco,true);
   mover_cursor(m.f+14,m.c+2);
   escribir_cad_hor('REMOTO      >>>',rojocl);
   mover_cursor(m.f+16,m.c+2);
   escribir_cad_hor('LINEAS....:',blanco);
   mover_cursor(m.f+17,m.c+2);
   escribir_cad_hor('LE QUEDAN.:',blanco);
   mover_cursor(m.f+18,m.c+2);
   escribir_cad_hor('PUNTOS....:',blanco);
   dibujar_linea_hor(m.f+19,m.c,m.c+anchura_marcador,blanco,true);
 End;

 Procedure escribir_puntos_en_marcador(var m:marcador);
 begin
   mover_cursor(m.f+6,m.c+15); escribir_cad_hor(num_a_cad(m.nivel),blancocl);

   mover_cursor(m.f+10,m.c+14); escribir_cad_hor(num_a_cad(m.lineas_acum_locales),azulcl);
   mover_cursor(m.f+11,m.c+14);
   if m.lineas_que_quedan_loc<0 then escribir_cad_hor('0 ',azulcl)
     else escribir_cad_hor(num_a_cad(m.lineas_que_quedan_loc)+' ',azulcl);
   mover_cursor(m.f+12,m.c+14);
   escribir_cad_hor(num_a_cad(m.puntos_locales),azulcl);

   mover_cursor(m.f+16,m.c+14); escribir_cad_hor(num_a_cad(m.lineas_acum_remotas)+' ',rojocl);
   mover_cursor(m.f+17,m.c+14);
   if m.lineas_que_quedan_rem<0 then escribir_cad_hor('0 ',rojocl)
    else escribir_cad_hor(num_a_cad(m.lineas_que_quedan_rem)+' ',rojocl);
   mover_cursor(m.f+18,m.c+14);
   escribir_cad_hor(num_a_cad(m.puntos_remotos),rojocl);

   mover_cursor(m.f+20,m.c+2);
   if m.lineas_que_quedan_loc<m.lineas_que_quedan_rem then
     escribir_cad_hor('<<< DELANTE <<<',azulcl)
   else if m.lineas_que_quedan_loc>m.lineas_que_quedan_rem then
          escribir_cad_hor('>>> DELANTE >>>',rojocl)
        else
          escribir_cad_hor('                ',rojocl);
end;

 Procedure nuevo_marcador(var m:marcador;f,c:byte);
 Begin
   m.f:=f; m.c:=c;
   m.puntos_locales:=0;
   m.puntos_remotos:=0;
   m.nivel:=0;
   m.lineas_acum_locales:=0;
   m.lineas_acum_remotas:=0;
   m.lineas_que_quedan_loc:=niveles[m.nivel].numero_lineas;
   m.lineas_que_quedan_rem:=niveles[m.nivel].numero_lineas;
   dibujar_marcador(m);
 End;

 Procedure sube_de_nivel(var m:marcador);
 Begin
   inc(m.nivel);
   m.lineas_que_quedan_loc:=niveles[m.nivel].numero_lineas;
   m.lineas_que_quedan_rem:=niveles[m.nivel].numero_lineas;
 End;

 procedure actualiza_marcador(var m:marcador;numero_lineas:byte;
                              es_local:boolean);
 begin
   if es_local Then
     begin
       m.lineas_acum_locales:=m.lineas_acum_locales+numero_lineas;
       m.lineas_que_quedan_loc:=m.lineas_que_quedan_loc-numero_lineas;
       m.puntos_locales:=m.puntos_locales+niveles[m.nivel].puntos_linea[numero_lineas];
     end
   else
     begin
       m.lineas_acum_remotas:=m.lineas_acum_remotas+numero_lineas;
       m.lineas_que_quedan_rem:=m.lineas_que_quedan_rem-numero_lineas;
       m.puntos_remotos:=m.puntos_remotos+niveles[m.nivel].puntos_linea[numero_lineas];
     end;
   escribir_puntos_en_marcador(m);
 End;

 procedure cambia_pieza_en_marcador(var m:marcador;p:pieza);
 var pseudo_t:tablero;
 Begin
   m.p_sig:=p;
   pseudo_t.f1:=m.f+1;
   if m.p_sig.forma in [0,4] then pseudo_t.c1:=m.c+2
                             else pseudo_t.c1:=m.c+3;
   rellenar_caja(m.f+1,m.c+5,m.f+4,m.c+16,negro,ord(lleno));
   dibujar_pieza(m.p_sig,pseudo_t);
 End;

 var factor_velocidad:integer;

 procedure ajusta_velocidad(var m:marcador; var Tmax:longint);
 begin
   Tmax:=niveles[m.nivel].Tmax*factor_velocidad;
 end;

 Procedure cronometro;
 begin
   factor_velocidad:=1;
 end;

 Function nivel_terminado(var m:marcador; es_local:boolean):boolean;
 Begin
   nivel_terminado:=(es_local and (m.lineas_que_quedan_loc<=0)) or
    (not es_local and (m.lineas_que_quedan_rem<=0));
 End;
End.