{----------------------------------------------------------------------------}
{   TETRIS...U_PANTAL: Gestion de la pantalla                                }
{----------------------------------------------------------------------------}
{   Creado...........: 03/11/94.                                             }
{   Ultima revision..: 09/11/94.  CHEMA                                      }
{   Es necesario el fichero a_pantal.OBJ para su funcionamiento.             }
{   Funciona perfectamente.                                                  }
{----------------------------------------------------------------------------}


Unit u_pantal;
Interface

 Const simple:byte=1;
       doble: byte=2;

 Var modo_video:integer;

 Procedure borrar_trozo(f1,c1,f2,c2:byte);
 Procedure borrar_fila(f:byte);
 Procedure borrar_columna(c:byte);
 Procedure limpiar_pantalla;

 Procedure escribir_cad_hor(s:string; color:byte);
 Procedure escribir_cad_vert(s:string; color:byte);
 Procedure escribir_cad_obl(s:string; color:byte);

 Procedure mover_cursor(f,c:byte);

 Procedure dibujar_caja(f1,c1,f2,c2:byte; color:byte; trazo:byte);
 Procedure dibujar_linea_hor(f,c1,c2:byte; color:byte; empalm:boolean);
 Procedure dibujar_linea_vert(c,f1,f2:byte; color:byte);
 Procedure rellenar_caja(f1,c1,f2,c2:byte; color:byte; car_relleno:byte);
 Procedure dibujar_cuadro(f,c:byte;color:byte);
 Procedure borrar_cuadro(f,c:byte);

 Procedure inicializar_pantalla;
 Procedure restaurar_pantalla;

Implementation

Uses dos,u_var;

{$L a_pantal.OBJ}

Const cuadro1='';
      cuadro2='';

Type trazos=(SupIzq,SupDer,InfIzq,InfDer,Hor,Ver,HorIzq,HorDer,VerSup,VerInf,
             cruz,CombIzq,CombDer,CombSup,CombInf);
Const
  LineChar:Array[1..2,Trazos] Of char=
  (('','','','','','','','','','','','','','','')
  ,('','','','','','','','','','','','','','',''));


Var cursor_f,
    cursor_c:byte;

function detectar_modo:integer; external;

Procedure poner_caracter(f,c:byte;car:byte;atr:byte);external;

Procedure borrar_trozo(f1,c1,f2,c2:byte);
Var i,j:byte;
Begin
  If (f1<0) or (f1>24) or (f2<0) or (f2>24) or (c1<0) or (c1>79) or
     (c2<0) or (c2>79) Then writeln('Error: Parametro/s fuera de rango.')
     Else
        For i:=f1 To f2 Do
            For j:=c1 To c2 Do
                poner_caracter(i,j,ord(' '),normal); {lleno?}
End;

Procedure borrar_fila(f:byte);
Begin
  If (f<0) or (f>24) Then writeln('Error: Linea no valida.')
    Else
      borrar_trozo(f,0,f+1,79);
End;

Procedure borrar_columna(c:byte);
Begin
  If (c<0) or (c>79) Then writeln('Error: Columna no valida.')
    Else
      borrar_trozo(0,c,24,c+1);
End;

Procedure limpiar_pantalla;
Begin
  borrar_trozo(0,0,24,79);
End;


Procedure escribir_cad_hor(s:string; color:byte);
Var i:integer;
Begin
  i:=0;
  While i<>Length(s) Do
   Begin
     i:=i+1;
     poner_caracter(cursor_f,cursor_c,ord(s[i]),color);
     cursor_c:=cursor_c+1
   End
End;

Procedure escribir_cad_vert(s:string; color:byte);
Var i:integer;
Begin
  i:=0;
  While i<>Length(s) Do
   Begin
     i:=i+1;
     poner_caracter(cursor_f,cursor_c,ord(s[i]),color);
     cursor_f:=cursor_f+1
   End
End;

Procedure escribir_cad_obl(s:string; color:byte);
Var i:integer;
Begin
  i:=0;
  While i<>Length(s) Do
   Begin
     i:=i+1;
     poner_caracter(cursor_f,cursor_c,ord(s[i]),color);
     cursor_c:=cursor_c+1; cursor_f:=cursor_f+1
   End
End;

Procedure mover_cursor(f,c:byte);
Begin
  If (f<0) or (f>24) or (c<0) or (c>79)
    Then writeln('Parametro/s erroneo/s.')
    Else
     Begin
      cursor_f:=f;
      cursor_c:=c
     End
End;


Procedure cambiar(Var a,b:byte);
Var aux:byte;
Begin
  If a>b
    Then
      Begin
        aux:=a;
        a:=b;
        b:=aux
      End
End;

Procedure dibujar_caja(f1,c1,f2,c2:byte; color:byte; trazo:byte);
Var i:byte;
Begin
  cambiar(f1,f2);
  cambiar(c1,c2);
  poner_caracter(f1,c1,ord(LineChar[trazo,SupIzq]),color);
  For i:=c1+1 To c2-1 Do
     poner_caracter(f1,i,ord(LineChar[trazo,Hor]),color);
  poner_caracter(f1,c2,ord(LineChar[trazo,SupDer]),color);
  For i:=f1+1 To f2-1 Do
   Begin
     poner_caracter(i,c1,ord(LineChar[trazo,Ver]),color);
     poner_caracter(i,c2,ord(LineChar[trazo,Ver]),color);
   End;
  poner_caracter(f2,c1,ord(LineChar[trazo,InfIzq]),color);
  For i:=c1+1 To c2-1 Do
     poner_caracter(f2,i,ord(LineChar[trazo,Hor]),color);
  poner_caracter(f2,c2,ord(LineChar[trazo,InfDer]),color);
end;

Procedure dibujar_linea_hor(f,c1,c2:byte; color:byte; empalm:boolean);
Var i:byte;
Begin
  if empalm then poner_caracter(f,c1,ord(linechar[simple,horizq]),color)
            else poner_caracter(f,c1,ord(linechar[simple,hor]),color);
  For i:=c1+1 To c2-1 Do
    poner_caracter(f,i,ord(LineChar[simple,Hor]),color);
  if empalm then poner_caracter(f,c2,ord(linechar[simple,horder]),color)
            else poner_caracter(f,c2,ord(linechar[simple,hor]),color)
End;

Procedure dibujar_linea_vert(c,f1,f2:byte; color:byte);
Var i:byte;
Begin
  For i:=f1 To f2 Do
    poner_caracter(i,c,ord(LineChar[simple,Ver]),color);
End;

Procedure rellenar_caja(f1,c1,f2,c2:byte; color:byte; car_relleno:byte);
Var i,j:byte;
Begin
  cambiar(f1,f2);
  cambiar(c1,c2);
  For i:=f1 to f2 do
    For j:=c1 to c2 do
      poner_caracter(i,j,ord(car_relleno),color);
End;

Procedure dibujar_cuadro(f,c:byte;color:byte);
Var f_ant,c_ant:byte;
Begin
  poner_caracter(f,c,ord(cuadro1),color);
  poner_caracter(f,c+1,ord(cuadro2),color);
End;

Procedure borrar_cuadro(f,c:byte);
Begin
  poner_caracter(f,c,ord(' '),negro);
  poner_caracter(f,c+1,ord(' '),negro);
End;

Procedure restaurar_pantalla;
Begin
  cursor_on;
  limpiar_pantalla;
End;

Procedure inicializar_pantalla;
Begin
  modo_video:=detectar_modo;
  if not modo_video IN [2,3,7] then
    error('Modo de video incorrecto o adaptador no reconocido.');
  cursor_Off;
  cursor_f:=0;
  cursor_c:=0;
End;

End.