{----------------------------------------------------------------------------}
{   TETRIS...U_PIEZA: Gestion de las piezas.                                 }
{----------------------------------------------------------------------------}
{   Creado...........: 06/11/94.                                             }
{   Ultima revision..: 09/11/94.  CHEMA                                      }
{   Es necesario la unidad u_pantal.TPU para su funcionamiento.              }
{----------------------------------------------------------------------------}

Unit u_pieza;

Interface
uses u_var,u_tabler;


 Type tpForma=0..6;
      tpGiro =0..3;

 Type pieza=record
               forma:tpForma;
               giro:tpGiro;
               f,c:byte
            end;

 Type cuadros=array[1..4] of record f,c:shortint end;

 procedure nueva_pieza(var p:pieza;forma:tpforma);
 procedure dibujar_pieza(p:pieza; var t:tablero);
 procedure borrar_pieza(p:pieza; var t:tablero);
 procedure gira_pieza(var p:pieza);
 procedure dame_cuadros(p:pieza; var c:cuadros);

 Const CP:array[tpForma] of byte=
       (rojo,verde,celeste,naranja,azul,morado,amarillo);

Implementation
Uses u_pantal;

 Const giroA=0;
       giroB=1;
       giroC=2;
       giroD=3;

const piezas:array[tpforma,tpgiro] of cuadros=
         ((((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f: 0;c: 2)),  {          }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f: 2;c: 0)),  {  }
           ((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f: 0;c: 2)),  {          }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f: 2;c: 0))),

          (((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 0)),  {      }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f: 0;c:-1)),  {    }
           ((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f:-1;c: 0)),  {      }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f: 0;c: 1))),

          (((f: 0;c:-1),(f: 0;c: 0),(f: 1;c: 1),(f: 1;c: 0)),  {      }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c:-1),(f: 0;c:-1)),  {    }
           ((f: 0;c:-1),(f: 0;c: 0),(f: 1;c: 0),(f: 1;c: 1)),  {      }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 0;c:-1),(f: 1;c:-1))),

          (((f: 1;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 0)),  {      }
           ((f:-1;c:-1),(f: 0;c: 0),(f: 1;c: 0),(f: 0;c:-1)),  {    }
           ((f: 1;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 0)),  {      }
           ((f:-1;c:-1),(f: 0;c: 0),(f: 1;c: 0),(f: 0;c:-1))),

          (((f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 0),(f: 1;c: 1)),  {    }
           ((f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 0),(f: 1;c: 1)),  {    }
           ((f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 0),(f: 1;c: 1)),  {        }
           ((f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 0),(f: 1;c: 1))),

          (((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f: 1;c: 1)),  {      }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f: 1;c:-1)),  {      }
           ((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f:-1;c:-1)),  {    }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f:-1;c: 1))),

          (((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f:-1;c: 1)),  {      }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f: 1;c: 1)),  {      }
           ((f: 0;c:-1),(f: 0;c: 0),(f: 0;c: 1),(f: 1;c:-1)),  {    }
           ((f:-1;c: 0),(f: 0;c: 0),(f: 1;c: 0),(f:-1;c:-1))));

Procedure nueva_pieza(var p:pieza;forma:tpforma);
Begin
  p.forma:=forma;
  p.giro:=giroA;
  p.f:=2;
  p.c:=4;
End;

Procedure dibujar_pieza(p:pieza; var t:tablero);
Begin
  p.f:=t.f1 + p.f-1;
  p.c:=t.c1 + p.c*2 -2;
  dibujar_cuadro(p.f+piezas[p.forma,p.giro][1].f,p.c+2*piezas[p.forma,p.giro][1].c,CP[p.forma]);
  dibujar_cuadro(p.f+piezas[p.forma,p.giro][2].f,p.c+2*piezas[p.forma,p.giro][2].c,CP[p.forma]);
  dibujar_cuadro(p.f+piezas[p.forma,p.giro][3].f,p.c+2*piezas[p.forma,p.giro][3].c,CP[p.forma]);
  dibujar_cuadro(p.f+piezas[p.forma,p.giro][4].f,p.c+2*piezas[p.forma,p.giro][4].c,CP[p.forma]);
End;

Procedure borrar_pieza(p:pieza; var t:tablero);
Begin
  p.f:=t.f1 + p.f -1;
  p.c:=t.c1 + p.c*2 -2;
  borrar_cuadro(p.f+piezas[p.forma,p.giro][1].f,p.c+2*piezas[p.forma,p.giro][1].c);
  borrar_cuadro(p.f+piezas[p.forma,p.giro][2].f,p.c+2*piezas[p.forma,p.giro][2].c);
  borrar_cuadro(p.f+piezas[p.forma,p.giro][3].f,p.c+2*piezas[p.forma,p.giro][3].c);
  borrar_cuadro(p.f+piezas[p.forma,p.giro][4].f,p.c+2*piezas[p.forma,p.giro][4].c);
End;

procedure gira_pieza(var p:pieza);
begin
  p.giro:=succ(p.giro) mod 4;
end;

 procedure dame_cuadros(p:pieza; var c:cuadros);
 begin
   c:=piezas[p.forma,p.giro];
 end;

End.