unit u_sonido;

interface

const  do7=2093;    do6=do7 div 2;    do5=do6 div 2;    do4=do5 div 2;
      dos7=2221;  dos6=dos7 div 2;  dos5=dos6 div 2;  dos4=dos5 div 2;
       re7=2349;    re6=re7 div 2;    re5=re6 div 2;    re4=re5 div 2;
      res7=2493;  res6=res7 div 2;  res5=res6 div 2;  res4=res5 div 2;
       mi7=2637;    mi6=mi7 div 2;    mi5=mi6 div 2;    mi4=mi5 div 2;
       fa7=2794;    fa6=fa7 div 2;    fa5=fa6 div 2;    fa4=fa5 div 2;
      fas7=2965;  fas6=fas7 div 2;  fas5=fas6 div 2;  fas4=fas5 div 2;
      sol7=3136;  sol6=sol7 div 2;  sol5=sol6 div 2;  sol4=sol5 div 2;
     sols7=3328;sols6=sols7 div 2;sols5=sols6 div 2;sols4=sols5 div 2;
       la7=3520;    la6=la7 div 2;    la5=la6 div 2;    la4=la5 div 2;
      las7=3753;  las6=las7 div 2;  las5=las6 div 2;  las4=las5 div 2;
       si7=3951;    si6=si7 div 2;    si5=si6 div 2;    si4=si5 div 2;

       silence=0;

const dur_predefinida=40;

var   durC,
      durN,
      durB,
      durR,
      durS,
      durF,
      durE: integer;
      div_son:integer;


type tpNota=record
            nombre_nota,duracion_nota:integer
          end;

procedure beep;
procedure cancion_1;
procedure cancion_2;
procedure cancion_tetris;
procedure cancion_presentacion;
procedure cancion_fin;
procedure toca_cancion(fichero_cancion:string);

implementation

uses crt,dos;

{$L a_sonido.OBJ}


procedure sonido(frecuencia,duracion:integer);external;
procedure silencio(duracion:integer);external;


procedure toca_cancion(fichero_cancion:string);
var f:file of tpNota;
    nota:tpNota;
begin
  assign(f,fichero_cancion);
  reset(f);
  while not eof(f) do
  begin
   read(f,nota);
   if nota.nombre_nota=silence then silencio(nota.duracion_nota div div_son)
   else sonido(nota.nombre_nota,nota.duracion_nota div div_son);
  end;
end;

procedure beep;
const d=3;
begin
  sonido(2000,d);
  sonido(1000,d);
  sonido(2000,d);
end;

procedure cancion_1;
begin
  sonido(la5,durN);
  sonido(la5,durN);
  sonido(sol5,durN);
  sonido(mi5,durC);
  sonido(fa5,durC);
  sonido(sol5,durN);
  sonido(mi5,durC);
  sonido(fa5,durC);
  sonido(sol5,durN);
  sonido(fa5,durC);
  sonido(mi5,durC);
  sonido(re5,durC);

end;

procedure cancion_2;
begin
  sonido(sol5,durN);
  sonido(re5,durC);
  sonido(mi5,durC);
  sonido(do5,durN);
  sonido(sol4,durN);

  sonido(re5,durC);
  sonido(mi5,durC);
  sonido(re5,durC);
  sonido(mi5,durC);
  sonido(do5,durN);
  sonido(sol4,durN);

  sonido(la4,durB);
  sonido(si4,durC);
  sonido(re5,durC);
  sonido(do5,durC);
  sonido(si4,durC);
  sonido(la4,durC);
  sonido(sol4,durN);
end;

procedure cancion_tetris;
begin
  sonido(do5,durC);sonido(mi5,durC);   sonido(re5,durC);sonido(fa5,durC);
  sonido(mi5,durC);sonido(sol5,durC);  sonido(fa5,durC);sonido(la5,durC);
  sonido(do6,durC div 2);
  sonido(si5,durC div 2);
  sonido(la5,durC div 2);
  sonido(sol5,durC div 2);
  sonido(fa5,durC div 2);
  sonido(mi5,durC div 2);
  sonido(re5,durC div 2);
  sonido(do5,durN );
end;
procedure cancion_presentacion;
begin
  sonido(re5,durN);sonido(fa5,durC);sonido(re5,durN);
  sonido(fa5,durC);sonido(re5,durC);sonido(fa5,durC);sonido(re5,durC);
  sonido(fa5,durC);sonido(la5,durN);silencio(durC div 5 );sonido(la5,durN);
  sonido(sol5,durN);sonido(las5,durC);sonido(sol5,durN);
  sonido(las5,durC);sonido(sol5,durC);sonido(las5,durC);sonido(sol5,durC);
  sonido(las5,durC);sonido(re6,durN);silencio(durC div 5);sonido(re6,durN);
  sonido(re5,durN);sonido(fa5,durC);sonido(re5,durN);
  sonido(fa5,durC);sonido(re5,durC);sonido(fa5,durC);sonido(re5,durC);
  sonido(fa5,durC);sonido(la5,durN);silencio(durC div 5);sonido(la5,durN);
  sonido(la4,durN);sonido(mi5,durC);sonido(la4,durN);sonido(mi5,durC);
  sonido(la5,durC);sonido(sol5,durC);sonido(fa5,durC);sonido(mi5,durC);
  if keypressed then
   begin
     sonido(re5,durN);sonido(dos5,durN); sonido(re5,durB);
   end;
  silencio(durC);

end;


procedure cancion_fin;
begin
  sonido(do5,durB*3 div 4);
  sonido(do5,durB*3 div 4);
  sonido(do5,durC);
  sonido(do5,durB*3 div 4);
  sonido(res5,durB*3 div 4);
  sonido(re5,durC);
  sonido(re5,durC);
  sonido(do5,durC);
  sonido(do5,durB*3 div 4);
  sonido(si4,durC);
  sonido(do5,durB*3 div 4);

end;

var entorno : string;
    codigo  : integer;

begin
  entorno:=GetEnv('TETRIS_DUR');
  if entorno<>'' then
    begin
      val(entorno,durC,codigo);
      if codigo<>0 then durC:=dur_predefinida;
    end
  else
      durC := dur_predefinida;    {Corchea}

  if (dur_predefinida<=durC) OR (durC<4) then div_son:=1
  else div_son:=dur_predefinida div durC;

      durN := durC*2; {Negra}
      durB := durC*4; {Blanca}
      durR := durC*8;
      durS := durC div 2;
      durF := durC div 4;
      durE := durC div 8;
end.