{---------------------------------------------------}
{   TETRIS...U_TABLER: TAD Tablero y mtodos asoc.  }
{---------------------------------------------------}
{   Creado...........: 31/10/94                     }
{   Ultima Revisin..: 09/11/94.  Javier.           }
{---------------------------------------------------}

Unit u_tabler;
Interface

 Const anchura_tablero=10;
       altura_tablero=20;

 Type  espacio=array[1..altura_tablero,1..anchura_tablero] of byte;
       tablero=record
                 f1,c1:byte;
                 espacio_juego: espacio;
              end;

 Procedure situa_tablero(var t:tablero; f,c:byte);
 Procedure nuevo_tablero(var t:tablero; decorado:byte);
 Procedure dibuja_marco_tablero(var t:tablero);
 Procedure dibuja_tablero(var t:tablero);
 Function comprueba_y_baja_lineas(var t:tablero):integer;
 Procedure efecto_barrido(var t:tablero);

Implementation
uses u_var,u_pantal,u_sonido;

 const borde=$07;

 procedure situa_tablero(var t:tablero; f,c:byte);
 begin
   t.f1:=f;
   t.c1:=c;
 end;

 procedure nuevo_tablero(var t:tablero;decorado:byte);
 var i,j:integer;
 begin
   for i:=1 to altura_tablero do
     for j:=1 to anchura_tablero do
       t.espacio_juego[i,j]:=vacio;
 end;

 procedure dibuja_marco_tablero(var t:tablero);
 begin
   with t do
     dibujar_caja(f1,c1-1,f1+altura_tablero,c1+anchura_tablero*2,borde,doble);
 end;

 procedure dibuja_tablero(var t:tablero);
 var i,j:integer;
 begin
   for i:=1 to altura_tablero do
     for j:=1 to anchura_tablero do
       dibujar_cuadro(t.f1+i-1,t.c1+j*2-2,t.espacio_juego[i,j]);
 end;

procedure mueve_lineas(var t:espacio; i:integer);
var k:integer;
begin
  for k:=i downto 2 do
    t[k]:=t[k-1];
  for k:=1 to anchura_tablero do
    t[1,k]:=vacio;
end;

function linea_llena(var t:espacio; i:integer):boolean;
var j:integer;
    llena:boolean;
begin
  llena:=true;
  for j:=1 to anchura_tablero do
    llena:=llena and (t[i,j]<>vacio);
  linea_llena:=llena;
end;

Procedure retardo(t:longint);
var i:longint;
    a:real;
begin
  a:=0.2;
  for i:=1 to t do
    a:=a*a;
end;

procedure efecto_linea_llena(var t:tablero;i:integer);
var j:integer;
begin
  for j:=1 to anchura_tablero do
    dibujar_cuadro(t.f1+i-1,t.c1+j*2-2,gris);
  beep;
  for j:=1 to anchura_tablero do
    dibujar_cuadro(t.f1+i-1,t.c1+j*2-2,normal);
  beep;
  for j:=1 to anchura_tablero do
    dibujar_cuadro(t.f1+i-1,t.c1+j*2-2,gris);
  beep;
end;

function comprueba_y_baja_lineas(var t:tablero):integer;
var i,lineas:integer;
begin
  lineas:=0;
  for i:=altura_tablero downto 1 do
    if linea_llena(t.espacio_juego,i) then
      efecto_linea_llena(t,i);
  for i:=altura_tablero downto 1 do
    while linea_llena(t.espacio_juego,i) do
      begin
        mueve_lineas(t.espacio_juego,i);
        inc(lineas);
        {beep;}
      end;
  if lineas=4 then cancion_tetris;
  comprueba_y_baja_lineas:=lineas;
end;

Procedure efecto_barrido(var t:tablero);
var i,j:integer;
begin
  for i:=1 to altura_tablero do
    begin
      for j:=1 to anchura_tablero do
        dibujar_cuadro(t.f1+i-1,t.c1+j*2-2,gris);
      retardo(6000);
    end;
  for i:=altura_tablero downto 1 do
    begin
      for j:=1 to anchura_tablero do
        dibujar_cuadro(t.f1+i-1,t.c1+j*2-2,negro);
      retardo(6000);
    end;
end;

End.