{----------------------------------------------------------------------------}
{   TETRIS...U_UART: Gestin de la Linea Serie                               }
{----------------------------------------------------------------------------}
{   Creado............: 31/10/94                                              }
{   Ultima Revisin...: 09/11/94. Javier.                                     }
{   Ultisima revision.: 22/11/94. Chema.                                      }
{   Siguiente revision: 6/12/94. Chema.
{                                                                            }
{   Aadido procedimiento encolar_mensaje(m:mensaje) para usarlo desde ASM   }
{                                                                            }
{----------------------------------------------------------------------------}

Unit u_uart;
Interface

 var contador:word;

 type mensaje=word;

 const COM1=0;
       COM2=1;

 const  v_50 =$0900;
        v_150=$0300;
        v_300=$0180;
        v_600=$00C0;
       v_1200=$0060;
       v_2400=$0030;
       v_4800=$0018;
       v_9600=$000C;

 const bits_parada_1=$00;
       bits_parada_2=$04;

 const paridad_par=$18;
       paridad_impar=$08;
       paridad_ninguna=$00;

 const msj_llamando = ord('C');
       msj_recibido = ord('R');
       msj_escape   = 27;

 Procedure pedir_configuracion_uart;
 Procedure instalar_rutina_uart;
 Procedure desinstalar_rutina_uart;
 Procedure mandar_mensaje(m:mensaje);
 Function hay_mensaje:boolean;
 Procedure leer_mensaje(var m:mensaje);
 Function establecer_comunicacion:boolean;
 Procedure vaciar_cola_mensajes;

Implementation
Uses crt,u_var ;

{$L a_uart.OBJ}

 Const LONGCOLA=100;
 type cola_de_mensajes=
          record
            mensajes:array[0..LONGCOLA-1] of mensaje;
            i:0..LONGCOLA; {i apunta al primer mensaje que se recibio}
            j:0..LONGCOLA; {j apunta a la siguiente posicion libre de la cola}
          end;

 var recibidos:cola_de_mensajes;
     rutina_uart_instalada:boolean;

 Procedure configurar_uart(num_puerto:byte;velocidad:word;bits_parada:byte;
                           paridad:byte); external;
 {$F+}
 Procedure __instalar_rutina_uart; external;
 Procedure __desinstalar_rutina_uart; external;
 {$F-}

 Procedure mandar_mensaje(m:mensaje); external;

 Procedure instalar_rutina_uart;
 begin
   if rutina_uart_instalada then
     error('Intento de instalar la rutina uart dos veces')
   else
     begin
       rutina_uart_instalada:=true;
       __instalar_rutina_uart;
     end;
 end;

 Procedure desinstalar_rutina_uart; 
 begin
   if rutina_uart_instalada then
     begin
       rutina_uart_instalada:=false;
       __desinstalar_rutina_uart;
     end
   else
     error('Intento de desinstalar la rutina uart cuando no estaba puesta');
 end;

 Function hay_mensaje:boolean;
 Begin
   hay_mensaje:=(recibidos.i<>recibidos.j);

   {Observacion: voy a suponer la longitud de la cola suficientemente grande
    como para que nunca coincidan i y j quedando mensajes por leer, ie, que
    nunca le puede llevar una, ni dos, ... vueltas completas j a i.}
 End;

 Procedure leer_mensaje(var m:mensaje);
 Begin
   m:=recibidos.mensajes[recibidos.i];
   recibidos.i:=(recibidos.i+1) MOD LONGCOLA;
 End;

 Function cola_llena:boolean;
 Begin
   cola_llena:=(recibidos.j+1) MOD LONGCOLA = recibidos.i;
 End;

 {$F+}
 Procedure encolar_mensaje(m:mensaje); { para llamarlo desde ensamblador }
 Begin
   if cola_llena then error('La cola de mensajes recibidos est llena.');
   recibidos.mensajes[recibidos.j]:=m;
   recibidos.j:=(recibidos.j+1) MOD LONGCOLA;

   { Observacion: aqui deberiamos controlar con un if si se puede almacenar
     o no el mensaje recibido debido a que la cola puede estar llena de men-
     sajes sin recoger pero voy a suponer que la cola es tan grande que nunca
     la vamos a desbordar. En el caso real de desbordarmiento perderiamos
     informacion colocando el if o sin colocarlo, solo que si lo colocamos
     o no la informacion perdida es distinta.}
 End;
 {$F-}

 Procedure pedir_configuracion_uart;
 var tecla:char;
     puerto,stop_bits,paridad:byte;
     velocidad:word;
 const resaltado = $17;
       normal    = $07;
 Begin
   puerto    := COM2;           { configuracin por defecto }
   velocidad := v_9600;
   stop_bits := bits_parada_1;
   paridad   := paridad_par;
   textattr:=normal; clrscr;
   cursor_off; textattr:=normal;
   gotoxy(1,3); write(centra('TETRIS v'+version,79));
   gotoxy(1,5); write(centra('Comunicacin por medio de la linea serie.',79));
   gotoxy(1,16); write(centra('[ENTER] para aceptar',79));
   gotoxy(4,6); write(repite('',74));
   gotoxy(4,15); write(repite('',74));
   repeat
     if puerto=COM1 then textattr:=resaltado else textattr:=normal;
     gotoxy(4,7); write(' 1. COM1 ');
     if puerto=COM2 then textattr:=resaltado else textattr:=normal;
     gotoxy(4,8); write(' 2. COM2 ');
     if velocidad=v_50 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,7); write(' A.   50 baudios ');
     if velocidad=v_150 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,8); write(' B.  150 baudios ');
     if velocidad=v_300 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,9); write(' C.  300 baudios ');
     if velocidad=v_600 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,10); write(' D.  600 baudios ');
     if velocidad=v_1200 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,11); write(' E. 1200 baudios ');
     if velocidad=v_2400 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,12); write(' F. 2400 baudios ');
     if velocidad=v_4800 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,13); write(' G. 4800 baudios ');
     if velocidad=v_9600 then textattr:=resaltado else textattr:=normal;
     gotoxy(16,14); write(' H. 9600 baudios ');

     if stop_bits=bits_parada_1 then textattr:=resaltado else textattr:=normal;
     gotoxy(35,7); write(' S. 1 bit de parada ');
     if stop_bits=bits_parada_2 then textattr:=resaltado else textattr:=normal;
     gotoxy(35,8); write(' T. 2 bits de parada ');

     if paridad=paridad_par then textattr:=resaltado else textattr:=normal;
     gotoxy(59,7); write(' P. Paridad par   ');
     if paridad=paridad_impar then textattr:=resaltado else textattr:=normal;
     gotoxy(59,8); write(' I. Paridad impar ');
     if paridad=paridad_ninguna then textattr:=resaltado else textattr:=normal;
     gotoxy(59,9); write(' N. Sin paridad   ');

     tecla:=upcase(readkey);
     case tecla of
       '1': puerto:=COM1;
       '2': puerto:=COM2;
       'A': velocidad:=v_50;
       'B': velocidad:=v_150;
       'C': velocidad:=v_300;
       'D': velocidad:=v_600;
       'E': velocidad:=v_1200;
       'F': velocidad:=v_2400;
       'G': velocidad:=v_4800;
       'H': velocidad:=v_9600;
       'S': stop_bits:=bits_parada_1;
       'T': stop_bits:=bits_parada_2;
       'P': paridad:=paridad_par;
       'I': paridad:=paridad_impar;
       'N': paridad:=paridad_ninguna;
     end;
   until (tecla=#13);
   gotoxy(1,16); write(centra('                    ',79));
   gotoxy(1,17); write('Buscando compaero de juego: ');
   cursor_on;
   configurar_uart(puerto,velocidad,stop_bits,paridad);
 End;

 procedure retardo;
 var i:longint;     a:real;
 begin   for i:=1 to 1000 do begin a:=3352535; a:=sqrt(a); end;  end;

 Function establecer_comunicacion:boolean;
 var intentos:longint;
     msj:mensaje;
 Begin
   intentos:=100;
   repeat
     mandar_mensaje(msj_llamando);
     retardo;
     dec(intentos); write('.');
   until hay_mensaje or (intentos<=0);
   if hay_mensaje then
       begin
         write(': ');
         mandar_mensaje(msj_recibido);
         repeat
           if hay_mensaje then leer_mensaje(msj);
         until msj=msj_recibido;
         write('-- conexin realizada --');
         retardo; retardo; retardo;
         retardo; retardo; retardo;
         retardo; retardo; retardo;
         retardo; retardo; retardo;
         establecer_comunicacion:=true;
       end
   else
      establecer_comunicacion:=false
 End;

 procedure vaciar_cola_mensajes;
 var m:mensaje;
 begin
   while hay_mensaje do
     leer_mensaje(m);
 end;

 var ultimo_exitproc:pointer;

 procedure salida_uart;
 begin
   if rutina_uart_instalada then
     begin
       desinstalar_rutina_uart;
       writeln('atencin: Intento de salir sin desinstalar_rutina_uart');
     end
   else
     writeln('Rutina uart desinstalada correctamente.');
   exitproc:=ultimo_exitproc;
   halt(0);
 end;

Begin
  ultimo_exitproc:=exitproc;
  exitproc:=addr(salida_uart);
  rutina_uart_instalada:=false;
  recibidos.i:=0;
  recibidos.j:=0;
End.