{----------------------------------------------------------------------------}
{   TETRIS...Datos globales                                                  }
{----------------------------------------------------------------------------}
{   Creado...........: 31/10/94                                              }
{   Ultima Revisin..: 14/12/94. Javier                                      }
{                                                                            }
{   He aadido los procedimientos cursor_on, cursor_off                      }
{----------------------------------------------------------------------------}

Unit u_var;

Interface

 Const lleno=chr(219);

 Const negro  = $00;  gris     = $08;
       azul   = $01;  azulcl   = $09;
       verde  = $02;  verdecl  = $0A;
       celeste= $03;  celestecl= $0B;
       rojo   = $04;  rojocl   = $0C;
       morado = $05;  moradocl = $0D;
       naranja= $06;  amarillo = $0E;
       blanco = $07;  blancocl = $0F;
       blancop= $8F;

       normal = $07;  normalI  = $0F;

const vacio = $00;

const version='3.00';

const tabla_caracteres='tetris6.fnt';

function existe_fichero(fname:String):Boolean;
procedure error(s:string);
function num_a_cad(n:integer):string;
function repite(letra:string;veces:byte):string;
function centra(cadena:string;long:integer):string;
procedure cursor_on;
procedure cursor_off;

implementation
uses dos,u_teclad,usertext;

function existe_fichero(fname:string):boolean;
var s:searchrec;
begin
  findfirst(fname,anyfile,s);
  existe_fichero:=(doserror=0);
end;

procedure error(s:string);
begin
  set_bios_table(bios8x16font,0);
  writeln(#7);
  writeln('error: ',s);
  writeln;
  halt(1);
end;

function num_a_cad(n:integer):string;
var cad:string;
begin
  str(n,cad);
  num_a_cad:=cad;
end;

Function num_a_cad2(n:integer):string;
Var s1,s2:string;
     i:integer;
Begin
  If n=0 Then num_a_cad2:='0'
    Else
     Begin
       s1:='';
       i:=0;
       While n<>0 do
       Begin
         s1:=s1+chr((n mod 10) + ord('0'));
         n:=n div 10;
         i:=i+1
       End;
       s2:='';
       While i<>0 do
       Begin
         s2:=s2+s1[i];
         i:=i-1
       End;
       num_a_cad2:=s2;
    End
End;

function repite(letra:string;veces:byte):string;
var i:byte;
    temp:string;
begin
  temp:='';
  for i:=1 to veces do temp:=temp+letra;
  repite:=temp;
end;

function centra(cadena:string;long:integer):string;
var espacios:string;
    i:byte;
begin
  espacios:='';
  if length(cadena)>long then cadena:=copy(cadena,1,long);
  if (long-length(cadena)) mod 2=1 then cadena:=cadena+' ';
  espacios:=repite(' ',(long-length(cadena))div 2);
  centra:=espacios+cadena+espacios;
end;

Procedure cursor_on;
Type result=registers;
Var parms:result;
    line_set:integer;
    modo_video:byte;
Begin
  modo_video:=3;
  Case modo_video Of
    0..3:Line_set:=$0607;
    7   :Line_set:=$0C0D;
  End;
  parms.Ax:=$100;
  parms.Cx:=line_set;
  Intr(16,parms);
End;

Procedure cursor_off;
Type result=registers;
Var parms:result;
    line_set:integer;
    modo_video:byte;
Begin
  modo_video:=3;
  Case modo_video Of
    0..3:Line_set:=$0100;
    7   :Line_set:=$0100;
  End;
  parms.Ax:=$100;
  parms.Cx:=line_set;
  Intr(16,parms);
End;

end.