/*
 * SOUNDLIB.C
 *
 * To compile this file you will need the MIKMOD 2.03
 * sound library!!!
 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include "mtypes.h"
#include "wildfile.h"
#include "mloader.h"
#include "mdriver.h"
#include "mplayer.h"
#include "vtimer.h"

extern LOADER 	uniload;
extern DRIVER 	gusdriver, sbdriver, nosnddriver;

#define INTRO	242653
#define	SFX1	 18440
#define SFX2	  9318
#define SFX3	 12576
#define SFX4	 15816
#define SFX5	 19072
#define SFX6	   882
#define SFX7	  7884
#define SFX8	 21626
#define SFX9	   882
#define SFX10	  4508
#define SFX11	 34906

UNIMOD 	*mf;
SAMPLE	*s[11];
char	sch[11];

char	i;

WORD 	playertimer;
WORD 	sfxtimer;
char	MOD;
char	modchn;

char	sfx_vol;

long	fp;
FILE	*sound_data;


void tickhandler(void)
{
	if (MOD) {
		MP_HandleTick();    // play 1 tick of the module
		VT_SetBPM(playertimer,mp_bpm);
	}
	MD_Update();
}

void SOUND_preinit(void)
{
	md_mixfreq      = 22050;                   
	md_dmabufsize   = 2000;                   
	md_mode         = DMODE_16BITS|DMODE_STEREO; 
	md_mode		&= ~DMODE_STEREO;
	md_device       = 0;                                                     // standard device: autodetect

	ML_RegisterLoader(&uniload);
	MD_RegisterDriver(&nosnddriver);
	MD_RegisterDriver(&sbdriver);
	MD_RegisterDriver(&gusdriver);

	VT_Init();
	playertimer=VT_Alloc();
	VT_SetHandler(playertimer,tickhandler);

	if(!MD_Init()){
		fprintf(stderr, "ERROR: Initialise Sound Driver .. failed\n");
		exit(0);
	}

	fp = 0;
	sound_data = fopen("sound.dat", "rb");

	mf = ML_LoadFP(sound_data);
	fp += INTRO;

	fseek(sound_data, fp, 0);
	s[0] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX1;

	fseek(sound_data, fp, 0);
	s[1] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX2;

	fseek(sound_data, fp, 0);
	s[2] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX3;

	fseek(sound_data, fp, 0);
	s[3] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX4;

	fseek(sound_data, fp, 0);
	s[4] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX5;

	fseek(sound_data, fp, 0);
	s[5] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX6;

	fseek(sound_data, fp, 0);
	s[6] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX7;

	fseek(sound_data, fp, 0);
	s[7] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX8;

	fseek(sound_data, fp, 0);
	s[8] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX9;

	fseek(sound_data, fp, 0);
	s[9] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX10;

	fseek(sound_data, fp, 0);
	s[10] = (SAMPLE *) MW_LoadWavFP(sound_data);
	fp += SFX11;
}

void SOUND_init(char volume)
{
	MP_Init(mf);
	mp_loop = 1;
	modchn = mf->numchn;
	md_numchn=mf->numchn;

	sch[0] = 0;
	sch[1] = 1;
	sch[2] = 1;
	sch[3] = 1;
	sch[4] = 1;
	sch[5] = 2;
	sch[6] = 3;
	sch[7] = 2;
	sch[8] = 2;
	sch[9] = 0;
	sch[10] = 0;

	mp_volume = volume;

	MD_PlayStart();
	VT_SetBPM(playertimer,125);
	VT_Start(playertimer);
	MOD = 1;
}

void SOUND_end(void)
{
	VT_Stop(playertimer);
	MD_PlayStop();          // stop playing
	ML_Free(mf);            // and free the module
	MW_FreeWav(s[0]);
	MW_FreeWav(s[1]);
	MW_FreeWav(s[2]);
	MW_FreeWav(s[3]);
	MW_FreeWav(s[4]);
	MD_Exit();
	VT_Exit();
}

void SOUND_modvol(char v)
{
	mp_volume = v;
}

void SOUND_modsfx(char volume)
{
	unsigned short v;

	v = (volume << 6) / 100;
	sfx_vol = v;

	MOD = 0;
	MD_PlayStop();
	MD_PlayStart();
	for (i = 0; i < 8; i++) {
		MD_VoiceSetVolume(sch[i], v);
		MD_VoiceSetPanning(sch[i], 128);
		MD_VoiceSetFrequency(sch[i], 11025);
	}
}

void SOUND_sfxmod(char volume)
{
	MD_PlayStop();
	MP_Init(mf);
	mp_volume = volume;
	MD_PlayStart();
	MOD = 1;
}


void SOUND_sfx(char i)
{
	MD_VoiceSetVolume(sch[i], sfx_vol);
	MD_VoiceSetPanning(sch[i], 128);
	MD_VoiceSetFrequency(sch[i], 11025);
	MD_VoicePlay(sch[i], s[i]->handle, 0, s[i]->length, 0, 0, s[i]->flags);
}

void SOUND_enhsfx(char i, short f, char c)
{
	MD_VoiceSetVolume(c, sfx_vol);
	MD_VoiceSetPanning(c, 128);
	MD_VoiceSetFrequency(c, f);
	MD_VoicePlay(c, s[i]->handle, 0, s[i]->length, 0, 0, s[i]->flags);
}

