
#define MAX_ACTIVE_PLAYERS		50
#define MAX_INACTIVE_PLAYERS	50
#define MAX_LEAGUE_TEAMS		30
#define MAX_GAMES_PER_WEEK		(MAX_LEAGUE_TEAMS/2)
#define MAX_WEEKS_IN_LEAGUE		24
#define MAX_SCREEN_TEAMS		8
#define MAX_LEAGUE_DESC			15
#define MAX_EXTERN_DESC			MAX_LEAGUE_DESC + 34
#define NO_TEAM					MAX_LEAGUE_TEAMS
#define MAX_CUSTOM_TEAMS      16

#define WILDCARD_PLAYOFFS	19
#define DIVISION_PLAYOFFS	20
#define CHAMPIONSHIP_GAMES	21
#define SUPER_BOWL			22



#define TRADE_SCREEN_TEAM1	0
#define TRADE_SCREEN_TEAM2	1
#define TEAM_EDIT_SCREEN		2
#define OWNER_TRADE_SCREEN	3


#define NEW_LEAGUE_DRAFT	1
#define OFFSEASON_DRAFT		2

#define COM_TRADE		1
#define OWNER_TRADE	2

#define SEASON88 88
#define SEASON89 89
#define SEASON90 90
#define SEASON91 91
#define SEASON92 92
#define SEASON93 93
#define SEASON94 94
#define SEASON95 95
#define RAND16	 116
#define RAND17  117
#define RAND_SEASON 118
#define STRAIGHT 99

// naming convention is all files end with .LG1 (with the # being the league
// so there can be up to 10 leagues on a machine



// Injury Types
#define PULLED_HAMSTRING 	1
#define CONCUSSION			2
#define SPRAINED_ANKLE		3
#define TURF_TOE			4
#define BROKEN_HAND			5
#define BROKEN_FOOT         6
#define BROKEN_TIBIA		7
#define BROKEN_FIBULA       8
#define KNEE_TENDONITIS     9
#define SHOULDER_TENDONITIS 10
#define BROKEN_ULNA         11
#define BROKEN_CLAVICLE		12
#define BRUISED_RIB			13
#define BROKEN_RIB			14

#define TORN_KNEE_TENDONS	15
#define RUPTURED_KNEE_TENDONS	16
#define	ACHILLES_TENDON		17

#define UNKNOWN_INJURY		18
#define CAREER_INJURY		19





struct OpponentStats
	{
	short RushYards;
	short PassYards;
	UWORD Rushes;
	UWORD RushTDs;
	UWORD PassTDs;
	UWORD Fumbles;
	UWORD PointsAgainst;
	};


struct TeamLeagueStats
	{
	UBYTE TeamNum;
	UBYTE Wins;
	UBYTE Losses;
	UBYTE Ties;
	struct GameStats     TeamStats;
	struct OpponentStats OpponentStats;
	};


struct LeagueTeamInfo
{
	char Description[MAX_DESCRIPTION];
	UBYTE Uniform;
	UBYTE Status;  // 0 is no team, 1 is active team
	char TeamName[MAX_TEAMNAME];
	char CityName[MAX_CITYNAME];
	char CoachName[MAX_COACHNAME];
	UBYTE Year;
	char Playbook[9];					// name of the default playbook for this team
	char Starters[MAX_STARTERS]; // not that this is a word while regular team file is a BYTE
	UBYTE CoachRatings[MAX_COACH_RATINGS];
	UBYTE TeamRatings[MAX_TEAM_RATINGS];
	char FileName[_MAX_PATH];
	UWORD Active_Players[MAX_INACTIVE_PLAYERS];	 // array of player id numbers
	UWORD Inactive_Players[MAX_INACTIVE_PLAYERS];	 // array of player id numbers
	struct TeamLeagueStats SeasonStats;     // stats for the current season
};

struct LeagueScheduleGameInfo
{
	BYTE Status;
	BYTE Team[2];  // 0 is home 1 is visitors
	BYTE Score[2];
};

// defines for the LeagueScheduleGameInfo status
#define GAME_STATUS_NO_GAME			0
#define GAME_STATUS_TO_BE_PLAYED	1
#define GAME_STATUS_PLAYED			2
#define GAME_STATUS_EXTERN			3
#define GAME_STATUS_SAVED			4
#define GAME_STATUS_HOLD			5

struct LeagueScheduleWeekInfo
{
	struct LeagueScheduleGameInfo Game[MAX_GAMES_PER_WEEK];
};

struct LeagueScheduleInfo
{
	BYTE weeks;			// how many weeks in this season
	struct LeagueScheduleWeekInfo Week[MAX_WEEKS_IN_LEAGUE];
};


struct LeagueInfo
{
	BYTE organization;  // 0 is NFL   1 is straight(no divs or confs)
	char description[ MAX_LEAGUE_DESC ];
	BYTE start_year;
	BYTE current_year;
	BYTE current_week;  // this also represents playoffs and offseason
	BYTE current_team;
	BYTE number_of_teams;
	BYTE team_last_used[ MAX_SCREEN_TEAMS ];  // lousy name for an array of teams most recently used by a particular screen
	struct LeagueTeamInfo Team[MAX_LEAGUE_TEAMS];
	struct LeagueScheduleInfo Schedule;
};


/*struct LeagueExternGame {
	char description[ MAX_EXTERN_DESC ];
	short league_num;
	BYTE current_week;
	BYTE game_num;
	struct TeamSpec Team[ 2 ];
};
*/


struct LeagueInterceptStats
{
	UWORD Intercepts;
	UWORD Touchdowns;
	UBYTE Long;
	short Yards;
};

struct LeagueQBStats
{
	short Yards;
	short SackYards;
	UWORD Attempts;
	UWORD Completions;
	UWORD Sacks;
	UWORD Intercepts;
	UWORD Touchdowns;
	UWORD Long;
};

struct LeagueReceiverStats
{
	UBYTE Long;
	UWORD Touchdowns;
	UWORD Catches;
	short Yards;
};

struct LeagueRunnerStats
{
	UBYTE Long;
	UWORD Touchdowns;
	UWORD Attempts;
	short Yards;
};

struct LeaguePunterStats
{
	UBYTE Long;
	UWORD Blocks;
	UWORD Touchbacks;
	UWORD Punts;
	short Yards;
};

struct LeagueKickerStats
{
	UWORD FG10_Att;
	UWORD FG20_Att;
	UWORD FG30_Att;
	UWORD FG40_Att;
	UWORD FG50_Att;
	UWORD FG10_Made;
	UWORD FG20_Made;
	UWORD FG30_Made;
	UWORD FG40_Made;
	UWORD FG50_Made;
	UWORD EP_Made;
	UWORD EP_Att;
	UWORD Long;
};

struct LeagueTackleStats
{
	UWORD Sacks;
	UWORD Tackles;
};



struct LeaguePlayerStats
{
	struct LeagueQBStats        QBStats;
	struct LeagueRunnerStats    RunStats;
	struct LeagueReceiverStats  RcvrStats;
	struct LeaguePunterStats    PuntStats;
	struct LeagueRunnerStats    KRStats;
	struct LeagueRunnerStats    PRStats;
	struct LeagueKickerStats    KickStats;
	struct LeagueInterceptStats IntStats;
	struct LeagueTackleStats    TackleStats;
};

struct LeaguePlayerInfo
{
	UWORD ID;
	BYTE Team;
	BYTE Status;
	BYTE Injury;
	BYTE Injury_type;
	BYTE Injury_week;
	BYTE Timer;
	BYTE Seasons;
	BYTE filler[5];
	struct RosterInfo Player;
	struct LeaguePlayerStats Career_Stats;
};


struct TempLeaguePlayer
{
	UWORD ID;
	BYTE Team;
	BYTE Status;
	BYTE Injury;
	BYTE Timer;
	BYTE Seasons;
	BYTE filler[5];
	struct RosterInfo Player;
	struct LeaguePlayerStats Career_Stats;

};



struct CareerSearchInfo
{
   char search_criteria[MAX_PLAYER_LNAME];
};



#define PLAYER_ACTIVE	0
#define PLAYER_INJURED  1
#define PLAYER_INACTIVE 2
#define PLAYER_FREE_AGENT 3
#define PLAYER_DRAFTEE  4
#define PLAYER_RETIRED  5




extern struct LeagueInfo far *NFL;
extern UWORD NFL_handle;
extern short current_league,current_week,current_league_team;

short main_create_league_menu(void);
short read_league_player(short fd, long id, struct LeaguePlayerInfo *lplayer_ptr);
short read_temp_player(short fd, long id, struct TempLeaguePlayer *player);
short write_league_player(short fd, struct LeaguePlayerInfo *lplayer_ptr);






/**
***  Include File: DEFLEAGU.H
*** Creation Date: Mon May 23 12:14:02 1994
**/

#define TEAMNAME_00                     0
#define TEAMNAME_01                     1
#define TEAMNAME_02                     2
#define TEAMNAME_03                     3
#define TEAMNAME_04                     4
#define TEAMNAME_05                     5
#define TEAMNAME_06                     6
#define TEAMNAME_07                     7
#define TEAMNAME_08                     8
#define TEAMNAME_09                     9
#define TEAMNAME_10                    10
#define TEAMNAME_11                    11
#define TEAMNAME_12                    12
#define TEAMNAME_13                    13
#define TEAMNAME_14                    14
#define TEAMNAME_15                    15
#define TEAMNAME_16                    16
#define TEAMNAME_17                    17
#define TEAMNAME_18                    18
#define TEAMNAME_19                    19
#define TEAMNAME_20                    20
#define TEAMNAME_21                    21
#define TEAMNAME_22                    22
#define TEAMNAME_23                    23
#define TEAMNAME_24                    24
#define TEAMNAME_25                    25
#define TEAMNAME_26                    26
#define TEAMNAME_27                    27
#define TEAMNAME_28                    28
#define TEAMNAME_29                    29

#define CITYNAME_00                    30
#define CITYNAME_01                    31
#define CITYNAME_02                    32
#define CITYNAME_03                    33
#define CITYNAME_04                    34
#define CITYNAME_05                    35
#define CITYNAME_06                    36
#define CITYNAME_07                    37
#define CITYNAME_08                    38
#define CITYNAME_09                    49
#define CITYNAME_10                    40
#define CITYNAME_11                    41
#define CITYNAME_12                    42
#define CITYNAME_13                    43
#define CITYNAME_14                    44
#define CITYNAME_15                    45
#define CITYNAME_16                    46
#define CITYNAME_17                    47
#define CITYNAME_18                    48
#define CITYNAME_19                    59
#define CITYNAME_20                    50
#define CITYNAME_21                    51
#define CITYNAME_22                    52
#define CITYNAME_23                    53
#define CITYNAME_24                    54
#define CITYNAME_25                    55
#define CITYNAME_26                    56
#define CITYNAME_27                    57
#define CITYNAME_28                    58
#define CITYNAME_29                    59
