/*
    monsdata.c - monster data initializer
   
    UltraRogue: The Ultimate Adventure in the Dungeons of Doom
    Copyright (C) 1985, 1986, 1992, 1993, 1995 Herb Chong
    All rights reserved.

    Based on "Advanced Rogue"
    Copyright (C) 1984, 1985 Michael Morgan, Ken Dalka
    All rights reserved.

    Based on "Rogue: Exploring the Dungeons of Doom"
    Copyright (C) 1980, 1981 Michael Toy, Ken Arnold and Glenn Wichman
    All rights reserved.

    See the file LICENSE.TXT for full copyright and licensing information.
*/

#include "rogue.h"

#define HPT(x) x

/* {"Name",
        CARRY_PROB, NORMAL, WANDER, SYMBOL, INTELLIGENCE,
        {ATTRIBUTE_FLAGS},
        CREATURE_SUMMONED, NUMBER_SUMMONED,
        ADDED_EXPERIENCE_PER_HIT_POINT,
        {str,   exp_pts, exp_level, armor_class, hit_points,
        "damage"}
},
*/

struct monster monsters[] =
{
{"the player",
        0,  FALSE,  FALSE,  '\0',   "",
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
        0, 0,
        0,
        {10,    0,  0,  0,  HPT(""), ""}
},
{"bat",
        0,  TRUE,   FALSE,  'B',    "2-4",
        {ISMEAN, CANFLY, ISHUH, CANDISEASE, ISFLOCK, ISSMALL},
        0, 0,
        0,
        {10,    5,  2,  1,  HPT("1d4"), "1d2"}
},
{"xvart",
        0,  TRUE,   TRUE,   'x',    "8-12",
        {ISMEAN, ISSWARM, ISSMALL, CANWIELD},
        0, 0,
        1,
        {8, 5,  1,  7,  HPT("1d4"), "1d4+1"}
},
{"giant rat",
        0,  TRUE,   TRUE,   'R',    "2-4",
        {ISMEAN, CANDISEASE, ISFLOCK, ISSMALL},
        0, 0,
        1,
        {10,    7,  1,  7,  HPT("1d4"), "1d3"}
},
{"jackal",
        0,  TRUE,   TRUE,   'J',    "2-5",
        {ISMEAN, ISSMALL},
        0, 0,
        1,
        {8, 5,  1,  7,  HPT("1d4"), "1d2"}
},
{"snake",
        0,  TRUE,   FALSE,   'S',    "2-5",
        {ISMEAN, ISSMALL},
        0, 0,
        1,
        {8, 5,  1,  5,  HPT("1d4"), "1d3"}
},
{"kobold",
        0,  TRUE,   TRUE,   'K',    "8-8",
        {ISMEAN, CANSHOOT, CANWIELD, ISSWARM, ISSMALL},
        0, 0,
        1,
        {9, 5,  1,  7,  HPT("1d4"), "1d4"}
},
{"vilstrak",
        5,  TRUE,   FALSE,  'V',    "5-8",
        {ISMEAN, CANINWALL},
        0, 0,
        1,
        {10,    7,  1,  2,  HPT("1d6"), "1d4+1/1d4+1"}
},
{"gnome",
        10, TRUE,   TRUE,   'G',    "11-12",
        {CANSHOOT, CANWIELD, ISSWARM, ISSMALL, MEDFRIENDLY},
        0, 0,
        1,
        {10,    8,  1,  5,  HPT("1d6"), "1d6"}
},
{"halfling",
        10, TRUE,   TRUE,   'H',    "11-12",
        {CANSHOOT, CANWIELD, ISSWARM, ISSMALL, HIGHFRIENDLY},
        0, 0,
        1,
        {8, 9,  1,  4,  HPT("1d6"), "1d6"}
},
{"dwarf",
        15, TRUE,   TRUE,   'D',    "11-12",
        {CANSHOOT, CANWIELD, ISSMALL, ISSWARM, MEDFRIENDLY},
        0, 0,
        1,
        {14,    10, 1,  4,  HPT("1d8"), "1d8"}
},
{"orc",
        15, TRUE,   TRUE,   'O',    "8-8",
        {ISMEAN, CANSHOOT, CANWIELD, ISSWARM},
        0, 0,
        1,
        {12,    10, 1,  6,  HPT("1d8"), "1d8"}
},
{"larva",
        0,  TRUE,   TRUE,   'l',    "5-8",
        {ISMEAN, ISFLOCK},
        0, 0,
        1,
        {6, 10, 1,  7,  HPT("1d8"), "1d4+1"}
},
{"skeleton",
        0,  TRUE,   TRUE,   's',    "0-0",
        {ISMEAN, ISSWARM, ISUNDEAD},
        0, 0,
        1,
        {6, 14, 1,  7,  HPT("1d8"), "1d6"}
},
{"carrion crawler",
        0,  TRUE,   TRUE,   'c',    "2-4",
        {ISMEAN, CANPARALYZE, ISLARGE},
        0, 0,
        1,
        {8, 20, 1,  7,  HPT("1d8+1"), "1d2"}
},
{"manes",
        0,  TRUE,   TRUE,   'M',    "2-4",
        {ISMEAN, MAGICHIT, ISUNDEAD, ISSMALL},
        0, 0,
        1,
        {10,    18, 1,  7,  HPT("1d8"), "1d2/1d2/1d4"}
},
{"elf",
        50, TRUE,   TRUE,   'E',    "13-20",
        {CANSHOOT, CANWIELD, CANBARGAIN, ISSWARM, HIGHFRIENDLY},
        0, 0,
        2,
        {12,    20, 1,  5,  HPT("1d8+1"), "1d10"}
},
{"hobgoblin",
        0,  TRUE,   TRUE,   'H',    "8-10",
        {ISMEAN, CANSHOOT, CANWIELD, ISSWARM},
        0, 0,
        2,
        {14,    20, 1,  5,  HPT("1d8+1"), "1d8"}
},
{"wild dog",
        0,  TRUE,   TRUE,   'w',    "2-5",
        {ISMEAN, ISFAST, ISSMALL, ISFLOCK},
        0, 0,
        2,
        {10,    20, 1,  7,  HPT("1d8+1"), "1d4"}
},
{"baboon",
        0,  TRUE,   TRUE,   'b',    "4-7",
        {ISMEAN, ISSMALL, ISSWARM},
        0, 0,
        2,
        {10,    20, 1,  7,  HPT("1d8+1"), "1d4"}
},
{"fire beetle",
        0,  TRUE,   TRUE,   'B',    "0-0",
        {ISMEAN, HASFIRE, ISFLOCK, ISSMALL},
        0, 0,
        2,
        {10,    20, 1,  4,  HPT("1d8+2"), "2d4"}
},
{"badger",
        0,  TRUE,   TRUE,   'k',    "4-6",
        {CANSURPRISE, ISSMALL},
        0, 0,
        3,
        {10,    30, 2,  4,  HPT("1d8+2"), "2d2/1d3"}
},
{"giant ant",
        0,  TRUE,   TRUE,   'A',    "1-1",
        {ISMEAN, CANPOISON, ISSMALL, ISSWARM},
        0, 0,
        3,
        {10,    40, 2,  3,  HPT("2d8"), "1d6"}
},
{"war dog",
        0,  TRUE,   TRUE,   'D',    "3-5",
        {ISMEAN, ISFAST},
        0, 0,
        3,
        {10,    35, 2,  6,  HPT("2d8+2"), "2d4"}
},
{"zombie",
        0,  TRUE,   TRUE,   'Z',    "0-0",
        {ISMEAN, ISUNDEAD, ISFLOCK},
        0, 0,
        2,
        {10,    20, 2,  8,  HPT("2d8"), "1d8"}
},
{"wuccubi",
        0,  TRUE,   TRUE,   'w',    "0-0",
        {ISMEAN},
        0, 0,
        2,
        {10,    20, 2,  8,  HPT("2d8"), "1d4/1d10"}
},
{"aarakocra",
        5,  TRUE,   TRUE,   'a',    "8-12",
        {CANFLY, CANWIELD, ISFLOCK, LOWFRIENDLY},
        0, 0,
        2,
        {11,    28, 2,  7,  "1d8+2", "1d3/1d3"}
},
{"gnoll",
        0,  TRUE,   TRUE,   'g',    "7-11",
        {ISMEAN, CANWIELD, CANSHOOT, ISLARGE, ISSWARM},
        0, 0,
        2,
        {10,    28, 2,  5,  HPT("2d8"), "2d4"}
},
{"warthog",
        0,  TRUE,   TRUE,   'w',    "3-5",
        {ISMEAN},
        0, 0,
        3,
        {14,    35, 2,  7,  HPT("3d8"), "2d8/2d8"}
},
{"black bear",
        0,  TRUE,   FALSE,  'U',    "5-8",
        {CANHUG},
        0, 0,
        3,
        {10,    30, 3,  7,  HPT("2d8+3"), "2d3"}
},
{"ear seeker",
        0,  TRUE,   TRUE,   'e',    "0-0",
        {ISMEAN, CANINFEST, ISSMALL},
        0, 0,
        0,
        {10,    0,  1,  9,  HPT("1d1"), "0d0"}
},
{"floating eye",
        0,  TRUE,   TRUE,   'E',    "0-0",
        {CANHUH, ISSMALL},
        0, 0,
        1,
        {7, 30, 1,  9,  HPT("1d4"), "0d0"}
},
{"brownie",
        0,  TRUE,   TRUE,   'B',    "12-15",
        {LOWCAST, CANSHOOT, CANWIELD, CANSURPRISE, STEALGOLD, CANBARGAIN, ISSMALL, ISFLOCK, HIGHFRIENDLY},
        0, 0,
        0,
        {6, 31, 10, 3,  HPT("1d4"), "1d3"}
},
{"shrieker",
        0,  TRUE,   FALSE,  'S',    "0-0",
        {CANSHRIEK, NOMOVE, ISFLOCK},
        0, 0,
        1,
        {10,    5,  3,  7,  HPT("3d8"), "0d0"}
},
{"gas spore",
        0,  TRUE,   FALSE,  'g',    "0-0",
        {CANSPORE, NOMOVE, ISLARGE},
        0, 0,
        0,
        {8, 33, 2,  9,  HPT("1d1"), "0d0"}
},
{"hyena",
        0,  TRUE,   TRUE,   'h',    "3-5",
        {ISMEAN},
        0, 0,
        3,
        {10,    35, 2,  7,  HPT("3d8"), "2d4"}
},
{"mind maggot",
        0,  TRUE,   TRUE,   'm',    "1-1",
        {ISMEAN, NOMOVE, DRAINBRAIN, ISFLOCK, CANSURPRISE, ISSMALL},
        0, 0,
        3,
        {10,    40, 4,  8,  HPT("1d8+1"), "1d3"}
},
{"giant beetle",
        0,  TRUE,   FALSE,  'b',    "0-0",
        {ISFLOCK},
        0, 0,
        4,
        {10,    40, 3,  4,  HPT("2d8"), "4d4"}
},
{"bombadier beetle",
        0,  TRUE,   FALSE,  'B',    "0-0",
        {CANBACID, ISFLOCK},
        0, 0,
        4,
        {10,    40, 2,  4,  HPT("2d8+2"), "2d6"}
},
{"stirge",
        0,  TRUE,   TRUE,   's',    "1-1",
        {ISMEAN, CANFLY, CANDRAW, ISSMALL},
        0, 0,
        2,
        {10,    36, 4,  8,  HPT("1d8+1"), "1d3"}
},
{"wild camel",
        0,  TRUE,   TRUE,   'w',    "3-7",
        {ISMEAN, CANTRAMPLE, ISLARGE, ISFLOCK},
        0, 0,
        3,
        {12,    35, 2,  7,  HPT("3d8"), "1d4"}
},
{"wolf",
        0,  TRUE,   TRUE,   'W',    "3-7",
        {ISMEAN, ISLARGE, ISSWARM, ISFAST},
        0, 0,
        3,
        {12,    35, 2,  7,  HPT("2d8+2"), "1d4+1"}
},
{"troglodyte",
        5,  TRUE,   TRUE,   'T',    "5-7",
        {ISMEAN, CANSMELL, CANSHOOT, CANWIELD, ISSWARM},
        0, 0,
        2,
        {10,    36, 2,  5,  HPT("2d8"), "1d3/1d3/2d5"}
},
{"killer frog",
        0,  TRUE,   FALSE,  'f',    "2-4",
        {ISMEAN},
        0, 0,
        4,
        {10,    40, 3,  6,  HPT("3d8"), "2d3/1d4"}
},
{"axe beak",
        0,  TRUE,   FALSE,  'a',    "2-4",
        {ISMEAN, ISLARGE},
        0, 0,
        4,
        {10,    40, 3,  6,  HPT("3d8"), "2d3/2d4"}
},
{"spinning tick",  
        0,  TRUE,   TRUE,   't',    "2-6",
        {ISMEAN, CANFRIGHTEN, ISSMALL, ISFAST, ISFLOCK},
        0, 0,
        5,
        {10,    50, 2,  3,  HPT("2d8+2"), "1d2/1d2/1d4"}
},
{"giant centipede",
        0,  TRUE,   TRUE,   'c',    "1-2",
        {ISMEAN, CANPOISON, ISLARGE, ISFLOCK},
        0, 0,
        1,
        {6, 40, 2,  9,  HPT("2d2"), "2d3"}
},
{"pegasus",
        0,  TRUE,   TRUE,   'p',    "9-12",
        {CANFLY, ISFAST, ISLARGE, LOWFRIENDLY},
        0, 0,
        4,
        {15,    50, 3,  6,  HPT("4d8"), "1d3/1d8/1d8"}
},
{"lemure",
        0,  TRUE,   FALSE,  'L',    "2-4",
        {ISMEAN, ISREGEN, MAGICHIT, ISUNDEAD, ISFLOCK},
        0, 0,
        3,
        {10,    65, 3,  7,  HPT("3d8"), "1d3"}
},
{"zemure",
        0,  TRUE,   FALSE,  'z',    "2-4",
        {ISMEAN, ISREGEN, MAGICHIT, ISUNDEAD, ISFLOCK},
        0, 0,
        3,
        {10,    65, 4,  7,  HPT("3d8"), "1d4"}
},
{"giant beaver",
        0,  TRUE,   TRUE,   'B',    "6-9",
        {ISMEAN, CANSWIM, ISSWARM},
        0, 0,
        4,
        {10,    60, 1,  6,  HPT("4d8"), "4d4"}
},
{"crocodile",
        0,  TRUE,   TRUE,   'c',    "2-5",
        {ISMEAN, CANSWIM, CANSURPRISE, ISFLOCK, ISLARGE},
        0, 0,
        4,
        {15,    60, 3,  5,  HPT("3d8"), "1d3/2d4"}
},
{"hipogriff",
        0,  TRUE,   TRUE,   'h',    "3-6",
        {CANFLY, ISMEAN},
        0, 0,
        4,
        {12,    60, 3,  5,  HPT("3d8+3"), "1d6/1d6/1d10"}
},
{"giant goat",
        0,  TRUE,   TRUE,   'G',    "3-5",
        {ISMEAN, ISFAST, ISLARGE},
        0, 0,
        4,
        {10,    85, 3,  7,  HPT("3d8+1"), "2d8"}
},
{"wererat",
        20, TRUE,   TRUE,   'r',    "11-12",
        {ISMEAN, CANSUMMON, MAGICHIT, ISFLOCK},
        "giant rat", 4,
        4,
        {10,    90, 3,  6,  HPT("3d8+1"), "1d8"}
},
{"ulodyte",
        0,  TRUE,   TRUE,   'u',    "5-8",
        {ISLARGE},
        0, 0,
        3,
        {10,    80, 3,  6,  HPT("3d8"), "1d3/1d3"}
},
{"brown bear",
        0,  TRUE,   TRUE,   'U',    "5-8",
        {CANHUG, ISLARGE},
        0, 0,
        3,
        {10,    80, 3,  6,  HPT("4d8+5"), "2d6/1d8"}
},
{"ghoul",
        0,  TRUE,   TRUE,   'g',    "5-7",
        {ISMEAN, CANPARALYZE, ISUNDEAD, ISFLOCK},
        0, 0,
        2,
        {10,    65, 2,  6,  HPT("2d8"), "1d3/1d3/1d6"}
},
{"giant hyena",
        0,  TRUE,   TRUE,   'H',    "3-5",
        {ISMEAN, ISLARGE},
        0, 0,
        5,
        {10,    90, 2,  7,  HPT("3d8"), "3d4"}
},
{"huorn",
        0,  TRUE,   TRUE,   'h',    "6-10",
        {CANBBURN, ISSHADOW, CANHUG},
        0, 0,
        3,
        {18,    60, 3,  7,  HPT("5d6"), "3d3"}
},
{"piercer",
        0,  TRUE,   FALSE,  'P',    "0-0",
        {NOMOVE, CANSURPRISE, ISSWARM},
        0, 0,
        4,
        {10,    60, 3,  3,  HPT("4d8"), "4d6"}
},
{"ape",
        0,  TRUE,   FALSE,  'A',    "4-6",
        {CANHUG},
        0, 0,
        1,
        {10,    50, 3,  6,  HPT("4d8+1"), "2d3"}
},
{"homonculous",
        0,  TRUE,   TRUE,   'H',    "9-15",
        {CANFLY, ISSMALL, LOWFRIENDLY},
        0, 0,
        2,
        {10,    81, 3,  6,  HPT("2d8"), "1d3"}
},
{"leprechaun",
        0,  TRUE,   FALSE,  'L',    "15-16",
        {ISMEAN, CARRYGOLD, STEALGOLD, CANBARGAIN, MEDFRIENDLY},
        0, 0,
        1,
        {10,    80, 8,  -6, HPT("4d8+1"), "1d1"}
},
{"ogre",
        50, TRUE,   TRUE,   'o',    "5-7",
        {ISMEAN, ISGREED, ISLARGE, ISFLOCK},
        0, 0,
        5,
        {18,    90, 4,  5,  HPT("4d8+1"), "2d6"}
},
{"bull",
        0,  TRUE,   TRUE,   'B',    "3-5",
        {ISMEAN, CANTRAMPLE, ISFLOCK, ISLARGE},
        0, 0,
        4,
        {14,    85, 2,  7,  HPT("4d8"), "1d6"}
},
{"wild boar",
        0,  TRUE,   TRUE,   'w',    "3-5",
        {ISMEAN, ISFLOCK},
        0, 0,
        4,
        {15,    85, 3,  7,  HPT("3d8+3"), "3d4"}
},
{"centaur",
        15, TRUE,   TRUE,   'C',    "5-10",
        {CANSHOOT, CANWIELD, ISFLOCK, ISLARGE, LOWFRIENDLY},
        0, 0,
        4,
        {10,    85, 4,  4,  HPT("4d8"), "1d6/1d6"}
},
{"pseudo dragon",
        10, TRUE,   FALSE,  'p',    "15-16",
        {ISMEAN, ISGREED},
        0, 0,
        9,
        {10,    100,    3,  -1, HPT("3d9"), "2d3/1d6"}
},
{"very young dragon",
        10, TRUE,   FALSE,  'd',    "15-16",
        {ISMEAN, CANBRANDOM, ISGREED},
        0, 0,
        9,
        {10,    100,    3,  -1, HPT("3d9"), "1d8/1d8/3d10"}
},
{"batarang",
        20, TRUE,   TRUE,   'B',    "4-6",
        {ISMEAN, CANFRIGHTEN, CANFLY, CANSUMMON, ISFLOCK, ISSMALL},
        "bat", 4,
        5,
        {10,    100,    3,  1,  HPT("3d8"), "1d4/1d4"}
},
{"carnivorous ape",
        5,  TRUE,   FALSE,  'A',    "7-10",
        {CANHUG, ISMEAN, ISLARGE},
        0, 0,
        4,
        {12,    120,    4,  6,  HPT("5d8"), "2d4"}
},
{"pixie",
        0,  TRUE,   TRUE,   'p',    "12-15",
        {LOWCAST, CANSHOOT, CANWIELD, ISINVIS, ISSMALL, ISFLOCK, LOWFRIENDLY},
        0, 0,
        1,
        {6, 105,    3,  3,  HPT("1d4"), "1d2"}
},
{"mountain lion",
        0,  TRUE,   TRUE,   'L',    "3-5",
        {ISMEAN, ISFAST},
        0, 0,
        6,
        {12,    110,    3,  6,  HPT("3d8+1"), "1d3/1d3/1d6"}
},
{"bugbear",
        5,  TRUE,   TRUE,   'U',    "5-8",
        {ISMEAN, CANSHOOT, CANWIELD, CANSURPRISE, ISFLOCK, ISLARGE},
        "black bear", 2,
        6,
        {16,    135,    3,  5,  HPT("3d8+1"), "2d4"}
},
{"giant lizard",
        0,  TRUE,   TRUE,   'G',    "2-4",
        {ISFAST, ISLARGE},
        0, 0,
        4,
        {13,    125,    4,  5,  HPT("3d8+1"), "1d8"}
},
{"harpy",
        0,  TRUE,   TRUE,   'H',    "6-9",
        {CANFLY, CANWIELD},
        0, 0,
        3,
        {10,    145,    4,  7,  HPT("3d8"), "1d3/1d3/1d6"}
},
{"iguanadon",
        0,  TRUE,   TRUE,   'i',    "0-0",
        {ISMEAN, ISLARGE, ISFLOCK},
        0, 0,
        6,
        {12,    150,    4,  4,  HPT("6d8"), "1d3/1d3/2d4"}
},
{"leopard",
        0,  TRUE,   TRUE,   'L',    "3-5",
        {ISMEAN, ISFAST, CANSURPRISE},
        0, 0,
        4,
        {10,    150,    4,  6,  HPT("3d8+2"), "1d3/1d3/1d6"}
},
{"nymph",
        100,    TRUE,   FALSE,  'N',    "15-16",
        {STEALMAGIC, MEDCAST, LOWFRIENDLY},
        0, 0,
        3,
        {10,    350,    8,  -5, HPT("3d8"), "0d0"}
},
{"giant ram",
        0,  TRUE,   TRUE,   'R',    "3-5",
        {ISFLOCK, CANSUMMON, ISFAST},
        "giant goat", 1,
        4,
        {10,    285,    3,  6,  HPT("4d8"), "2d6"}
},
{"rot grub",
        0,  TRUE,   TRUE,   'r',    "0-0",
        {ISMEAN, CANINFEST, ISSWARM, ISSMALL, ISSLOW},
        0, 0,
        0,
        {10,    0,  1,  9,  HPT("1d1"), "0d0"}
},
{"triffid",
        0,  TRUE,   FALSE,  'T',    "12-18",
        {ISMEAN, CANHOLD, ISSLOW, CANBBURN, CANPOISON},
        "huorn", 1,
        4,
        {10,    135,    10, 7,  HPT("2d8"), "1d6"}
},
{"violet fungi",
        0,  TRUE,   FALSE,  'F',    "0-0",
        {ISMEAN, CANHOLD, NOMOVE, CANROT, CANINFEST, CANPOISON},
        0, 0,
        4,
        {10,    135,    3,  7,  HPT("3d8"), "5d1"}
},
{"giant tick",
        0,  TRUE,   TRUE,   't',    "0-0",
        {ISMEAN, CANDRAW, CANDISEASE, ISSMALL},
        0, 0,
        2,
        {10,    105,    3,  3,  HPT("3d8"), "1d4"}
},
{"giant eagle",
        0,  TRUE,   TRUE,   'e',    "0-0",
        {ISMEAN, CANFLY, CANSPEAK, ISFLOCK, MEDFRIENDLY},
        0, 0,
        4,
        {10,    150,    3,  7,  HPT("4d8"), "1d6/1d6/2d6"}
},
{"peryton",
        0,  TRUE,   TRUE,   'P',    "0-0",
        {ISMEAN, CANFLY, CANSPEAK, ISFLOCK},
        0, 0,
        4,
        {10,    150,    3,  7,  HPT("4d8"), "4d4"}
},
{"gelatinous cube",
        90, TRUE,   TRUE,   'c',    "0-0",
        {ISSLOW, ISMEAN, ISSCAVENGE, CANPARALYZE, ISLARGE},
        0, 0,
        4,
        {10,    150,    4,  8,  HPT("4d8"), "2d4"}
},
{"giant owl",
        0,  TRUE,   TRUE,   'O',    "0-0",
        {ISMEAN, CANFLY},
        0, 0,
        4,
        {10,    150,    4,  6,  HPT("4d8"), "2d4/2d4/1d4+1"}
},
{"giant skunk",
        0,  TRUE,   TRUE,   's',    "3-5",
        {CANSTINK, ISFLEE},
        0, 0,
        5,
        {10,    165,    4,  7,  HPT("5d8"), "1d6"}
},
{"blink dog",
        0,  TRUE,   TRUE,   'B',    "8-10",
        {ISMEAN, CANBLINK, ISFLOCK, HIGHFRIENDLY},
        0, 0,
        5,
        {10,    170,    4,  5,  HPT("4d8"), "1d6"}
},
{"rust monster",
        0,  TRUE,   TRUE,   'R',    "1-1",
        {ISMEAN, CANRUST},
        0, 0,
        4,
        {10,    185,    5,  2,  HPT("3d8"), "0d0/0d0"}
},
{"ghast",
        0,  TRUE,   TRUE,   'G',    "11-12",
        {CANPARALYZE, CANSTINK, ISMEAN, ISUNDEAD},
        0, 0,
        4,
        {10,    190,    4,  4,  HPT("4d8"), "1d4/1d4/1d8"}
},
{"blindheim",
        0,  TRUE,   FALSE,  'b',    "1",
        {ISMEAN, CANBLIND},
        0, 0,
        4,
        {8, 200,    2,  1,  HPT("4d8+2"), "1d8"}
},
{"jaguar",
        0,  TRUE,   TRUE,   'j',    "3-5",
        {ISMEAN, CANSURPRISE, ISLARGE},
        0, 0,
        5,
        {12,    205,    2,  7,  HPT("4d8+1"), "2d3/2d5"}
},
{"dryad",
        100,    TRUE,   FALSE,  'D',    "15-16",
        {STEALMAGIC, LOWFRIENDLY},
        0, 0,
        3,
        {8, 325,    8,  -2, HPT("2d8"), "1d1"}
},
{"anhkheg",
        5,  TRUE,   FALSE,  'a',    "2-4",
        {ISMEAN,CANSURPRISE, ISLARGE},
        0, 0,
        2,
        {10,    300,    3,  2,  HPT("1d6+2"), "3d6"}
},
{"shadow",
        0,  TRUE,   TRUE,   's',    "5-7",
        {ISSHADOW, ISMEAN, CANCHILL, ISUNDEAD, ISFLOCK},
        0, 0,
        4,
        {10,    255,    3,  7,  HPT("3d8+3"), "1d6"}
},
{"gargoyle",
        5,  TRUE,   TRUE,   'g',    "5-7",
        {ISMEAN, MAGICHIT, ISFLOCK},
        0, 0,
        5,
        {10,    165,    4,  5,  HPT("4d8+4"), "1d3/1d3/1d6/1d4"}
},
{"su-monster",
        10, TRUE,   TRUE,   's',    "8-10",
        {ISMEAN},
        0, 0,
        6,
        {10,    225,    5,  6,  HPT("5d8+5"), "4d4/2d4"}
},
{"gray ooze",
        50, TRUE,   FALSE,  'o',    "1-1",
        {ISMEAN, NOMOVE, CANRUST, ISSCAVENGE, BOLTDIVIDE, BLOWDIVIDE, NOFIRE, NOCOLD},
        0, 0,
        5,
        {10,    200,    3,  8,  HPT("3d8+3"), "2d8"}
},
{"psuedo-dragon",
        0,  TRUE,   TRUE,   'P',    "8-12",
        {CANSURPRISE, CANSEE, CANFLY, CANPOISON, LOWFRIENDLY},
        0, 0,
        2,
        {10,    200,    3,  2,  HPT("2d8"), "1d3"}
},
{"lava child",
        0,  TRUE,   TRUE,   'l',    "8-12",
        {NOMETAL, NOFIRE, LOWFRIENDLY},
        0, 0,
        5,
        {11,    205,    4,  4,  HPT("5d8"), "1d6/1d6/2d6"}
},
{"hell hound",
        0,  TRUE,   TRUE,   'h',    "5-8",
        {ISMEAN, NOFIRE, CANBFIRE, CANSURPRISE, CANSEE},
        0, 0,
        8,
        {10,    250,    4,  4,  HPT("5d8+4"), "1d10"}
},
{"pech",
        60, TRUE,   FALSE,  'p',    "8-14",
        {CANINWALL, LOWFRIENDLY},
        0, 0,
        4,
        {10,    240,    4,  3,  HPT("4d8"), "1d6"}
},
{"winter wolf",
        0,  TRUE,   TRUE,   'w',    "8-12",
        {ISMEAN, ISFAST, CANBICE, NOCOLD, ISFLOCK},
        "wolf", 6,
        5,
        {10,    245,    4,  5,  HPT("6d8"), "2d4"}
},
{"sylph",
        100,    TRUE,   FALSE,  's',    "15-16",
        {STEALMAGIC, LOWFRIENDLY},
        0, 0,
        3,
        {8, 325,    8,  -2, HPT("2d8"), "1d1"}
},
{"lion",
        0,  TRUE,   TRUE,   'L',    "3-5",
        {ISMEAN, ISLARGE},
        0, 0,
        6,
        {12,    300,    4,  6,  HPT("5d8+2"), "1d4/1d4/1d10"}
},
{"undine",
        30, TRUE,   TRUE,   'u',    "12-18",
        {ISMEAN, MAGICHIT, NOBOLT, NOCOLD, CANSUMMON, CANSEE, CANSWIM, ISFAST},
        "crocodile", 3,
        10,
        {10,    200,    9,  7,  HPT("7d8+3"), "1d6/1d6/1d6/1d4"}
},
{"ochre jelly",
        0,  TRUE,   FALSE,  'O',    "1-1",
        {ISMEAN, ISSLOW, BOLTDIVIDE, CANROT},
        "gelatinous cube", 2,
        10,
        {10,    250,    4,  8,  HPT("6d8"), "3d4"}
},
{"phoenix",
        5,  TRUE,   FALSE,  'X',    "5-7",
        {NOFIRE, NOBOLT, CANSPEAK, CANBFIRE, ISLARGE, MEDFRIENDLY},
        0, 0,
        8,
        {10,    200,    4,  2,  HPT("4d8"), "1d4/1d8"}
},
{"owlbear",
        5,  TRUE,   TRUE,   'U',    "5-7",
        {ISMEAN, CANHUG, CANSUMMON, ISLARGE},
        "giant owl", 2,
        12,
        {10,    225,    5,  5,  HPT("5d8+2"), "1d6/1d6/2d6"}
},
{"phycomid",
        3,  TRUE,   FALSE,  'P',    "0-0",
        {CANPOISON, CANINFEST, CANBACID},
        0, 0,
        5,
        {10,    280,    5,  5,  HPT("4d8"), "3d2/3d2"}
},
{"slithering tracker",
        90, TRUE,   TRUE,   't',    "0-0",
        {ISMEAN, ISSCAVENGE, CANPARALYZE, ISSMALL, ISSHADOW, CANDRAW},
        0, 0,
        5,
        {10,    280,    5,  5,  HPT("5d8"), "2d4"}
},
{"satyr",
        0,  TRUE,   TRUE,   's',    "10-14",
        {CANSURPRISE, LOWFRIENDLY},
        0, 0,
        5,
        {10,    280,    5,  5,  HPT("5d8"), "2d4"}
},
{"imp",
        25, TRUE,   TRUE,   'i',    "8-10",
        {ISMEAN, ISREGEN, MAGICHIT, CANPOISON, CANSURPRISE, ISSMALL, ISUNDEAD},
        0, 0,
        3,
        {10,    275,    2,  2,  HPT("2d8+2"), "1d4"}
},
{"quellit",
        30, TRUE,   TRUE,   'q',    "7-11",
        {ISMEAN, ISREGEN, MAGICHIT },
        0, 0,
        3,
        {10,    400,    7,  2,  HPT("4d8"), "2d10/2d6"}
},
{"quasit",
        30, TRUE,   TRUE,   'Q',    "5-7",
        {ISMEAN, ISREGEN, MAGICHIT, CANSURPRISE, CANITCH, ISSMALL, ISUNDEAD},
        0, 0,
        3,
        {10,    325,    7,  2,  HPT("3d8"), "1d2/1d2/1d4"}
},
{"doppleganger",
        0,  TRUE,   TRUE,   'D',    "11-12",
        {ISMEAN, CANSURPRISE},
        0, 0,
        4,
        {10,    330,    10, 5,  HPT("4d8"), "1d12"}
},
{"subterranean lizard",
        0,  TRUE,   TRUE,   's',    "0-0",
        {ISFAST, ISLARGE},
        0, 0,
        6,
        {14,    350,    6,  5,  HPT("6d8"), "2d6"}
},
{"giant porcupine",
        0,  TRUE,   FALSE,  'p',    "0-0",
        {ISFLEE, CANSTICK},
        0, 0,
        6,
        {10,    350,    6,  5,  HPT("6d8"), "2d4"}
},
{"plateosaurus",
        0,  TRUE,   TRUE,   'P',    "0-0",
        {ISFLEE, CANTRAMPLE, ISLARGE},
        0, 0,
        10,
        {18,    375,    9,  5,  HPT("8d8"), "0d0"}
},
{"buffalo",
        0,  TRUE,   TRUE,   'b',    "3-5",
        {ISMEAN, CANTRAMPLE, ISSWARM, ISLARGE},
        0, 0,
        8,
        {16,    350,    2,  7,  HPT("5d8"), "1d8"}
},
{"cockatrice",
        0,  TRUE,   TRUE,   'c',    "1-1",
        {ISMEAN, CANFLY, TOUCHSTONE, ISSMALL},
        0, 0,
        5,
        {10,    315,    5,  6,  HPT("5d8"), "1d3"}
},
{"yeti",
        30, TRUE,   TRUE,   'Y',    "8-10",
        {ISMEAN, CANPARALYZE,CANHUG, NOCOLD, CANSURPRISE, ISLARGE, LOWFRIENDLY},
        "winter wolf", 2,
        12,
        {13,    500,    6,  6,  HPT("4d8+4"), "1d6/1d6"}
},
{"lonchu",
        0,  TRUE,   FALSE,  'l',    "8-10",
        {ISMEAN},
        0, 0,
        8,
        {10,    475,    6,  4,  HPT("6d8+1"), "1d4/1d4"}
},
{"leucrotta",
        0,  TRUE,   FALSE,  'L',    "8-10",
        {ISMEAN, ISLARGE},
        0, 0,
        8,
        {10,    475,    6,  4,  HPT("6d8+1"), "3d6/1d6/1d6"}
},
{"giant crocodile",
        0,  TRUE,   TRUE,   'g',    "2-4",
        {CANSWIM, CANSUMMON, CANSURPRISE, ISLARGE},
        "undine", 1,
        8,
        {18,    400,    5,  4,  HPT("7d8"), "3d6/2d10"}
},
{"griffon",
        0,  TRUE,   TRUE,   'g',    "0-0",
        {CANFLY, ISMEAN, ISLARGE},
        0, 0,
        10,
        {12,    375,    4,  3,  HPT("7d8"), "1d4/1d4/2d8"}
},
{"warg",
        10, TRUE,   TRUE,   'W',    "5-9",
        {ISFAST, CANSUMMON, ISFLOCK},
        "wolf", 3,
        8,
        {12,    400,    6,  4,  HPT("3d8+3"), "1d4+4"}
},
{"unicorn",
        10, TRUE,   TRUE,   'u',    "8-12",
        {ISFAST, CANSURPRISE, CANBLINK, ISLARGE, MEDFRIENDLY},
        0, 0,
        5,
        {12,    400,    6,  2,  HPT("4d8+4"), "1d6/1d6/1d12"}
},
{"entwife",
        35, TRUE,   FALSE,  'w',    "13-15",
        {CANSUMMON, CANBBURN, ISSWARM, ISLARGE, HIGHFRIENDLY},
        "ent", 1,
        8,
        {16,    400,    6,  4,  HPT("3d8+3"), "1d4+4"}
},
{"minotaur",
        0,  TRUE,   TRUE,   'm',    "7-9",
        {ISMEAN, CANWIELD, ISLARGE},
        0, 0,
        8,
        {14,    400,    5,  6,  HPT("6d8+3"), "1d3/2d4"}
},
{"displacer beast",
        0,  TRUE,   TRUE,   'D',    "3-5",
        {CANBLINK, ISSHADOW, ISLARGE},
        0, 0,
        8,
        {12,    475,    6,  4,  HPT("6d8"), "2d4/2d4"}
},
{"giant lynx",
        0,  TRUE,   TRUE,   'L',    "9-13",
        {ISMEAN, CANSURPRISE},
        0, 0,
        3,
        {10,    420,    4,  2,  HPT("2d8+2"), "1d2/1d2/1d4"}
},
{"young dragon",
        25, TRUE,   FALSE,  'd',    "12-15",
        {ISMEAN, CANBRANDOM, ISGREED, ISLARGE, LOWFRIENDLY},
        0, 0,
        9,
        {10,    800,    6,  1,  HPT("30d1"), "1d4/1d4/3d8"}
},
{"ceratosaurus",
        0,  TRUE,   TRUE,   'c',    "0-0",
        {ISMEAN, ISFAST, ISLARGE},
        0, 0,
        12,
        {18,    600,    4,  5,  HPT("8d8"), "1d6/1d6/4d4"}
},
{"wight",
        35, TRUE,   TRUE,   'W',    "8-10",
        {ISMEAN, CANSUMMON, CANDRAIN, MAGICHIT, ISUNDEAD, ISFLOCK},
        "skeleton", 2,
        7,
        {10,    540,    4,  5,  HPT("4d8+3"), "1d4"}
},
{"monoclonius",
        0,  TRUE,   TRUE,   'M',    "0-0",
        {ISMEAN, ISFAST, CANTRAMPLE, ISLARGE},
        0, 0,
        18,
        {18,    550,    4,  3,  HPT("8d8"), "2d8"}
},
{"olog-hai troll",
        45, TRUE,   TRUE,   'T',    "12-18",
        {ISMEAN, ISFLOCK, NOCOLD, CANWIELD, ISREGEN,  CANSUMMON},
        "troll", 2,
        6,
        {15,    640,    5,  3,  HPT("5d6"), "2d8+4"}
},
{"manticore",
        20, TRUE,   TRUE,   'm',    "7-9",
        {ISMEAN, CANFLY},
        0, 0,
        6,
        {12,    525,    4,  4,  HPT("6d8+3"), "1d3/1d3/1d8"}
},
{"uruk-hai orc",
        45, TRUE,   TRUE,   'O',    "12-18",
        {ISMEAN, ISSWARM, CANWIELD, CANSHOOT, CANSUMMON},
        "orc", 3,
        6,
        {15,    540,    3,  5,  HPT("5d4+3"), "3d4"}
},
{"kazad dwarf",
        75, TRUE,   FALSE,  'D',    "12-18",
        {ISFLOCK, CANWIELD, CANSHOOT, CANSUMMON, LOWFRIENDLY},
        "dwarf", 3,
        6,
        {17,    540,    5,  3,  HPT("5d8+3"), "3d4"}
},
{"noldor elf",
        75, TRUE,   FALSE,  'E',    "18-20",
        {ISFLOCK, CANWIELD, MEDCAST, CANSHOOT, CANSUMMON, LOWFRIENDLY},
        "elf", 3,
        6,
        {14,    600,    6,  2,  HPT("5d8+3"), "3d4"}
},
{"ent",
        80, TRUE,   FALSE,  'e',    "15-17",
        {ISREGEN, CANSUMMON, CANBBURN, HIGHCAST, ISLARGE, HIGHFRIENDLY},
        "huorn", 3,
        10,
        {22,    600,    6,  4,  HPT("6d8+6"), "1d4+4/1d4+4/2d6"}
},
{"nightmare",
        0,  TRUE,   FALSE,  'n',    "11-13",
        {ISMEAN, ISFAST, NOFIRE, ISLARGE, ISUNDEAD},
        0, 0,
        8,
        {14,    600,    6,  -4, HPT("6d8+6"), "2d4/1d6+4/1d6+4"}
},
{"troll",
        50, TRUE,   FALSE,  'T',    "5-7",
        {ISMEAN, ISREGEN, ISLARGE},
        0, 0,
        8,
        {18,    600,    6,  4,  HPT("6d8+6"), "1d8/1d8/2d6"}
},
{"wraith",
        0,  TRUE,   TRUE,   'W',    "11-12",
        {ISMEAN, CANDRAIN, CANSUMMON, MAGICHIT, ISUNDEAD},
        "zombie", 2,
        8,
        {10,    575,    5,  4,  HPT("5d8+3"), "1d6"}
},
{"archer bush",
        50, TRUE,   FALSE,  'a',    "0-0",
        {ISMEAN, CANPOISON, CANSUMMON, ISFLOCK, NOMOVE, CANBBURN, ISLARGE},
        "dryad", 2,
        20,
        {10,    600,    8,  8,  HPT("2d8"), "1d10"}
},
{"green slime",
        0,  TRUE,   TRUE,   's',    "0-0",
        {NOMOVE, ISSCAVENGE, BOLTDIVIDE, BLOWDIVIDE, CANRUST, NOMOVE, CANINFEST, CANROT, ISSMALL},
        0, 0,
        2,
        {8, 610,    5,  9,  HPT("2d8"), "1d1"}
},
{"blink saber tooth tiger",
        0,  TRUE,   TRUE,   'T',    "8-10",
        {ISMEAN, CANSUMMON, CANBLINK, ISLARGE},
        "blink dog", 2,
        10,
        {10,    670,    8,  3,  HPT("8d8+6"), "1d10/1d10/1d8/1d8"}
},
{"djinni",
        0,  TRUE,   TRUE,   'd',    "10-15",
        {CANCAST, ISFAST, CANSPEAK, ISLARGE, MEDFRIENDLY},
        0, 0,
        5,
        {12,    725,    6,  4,  HPT("7d8+3"), "2d8"}
},
{"stag beetle",
        0,  TRUE,   TRUE,   'B',    "0-0",
        {ISMEAN, ISFLOCK},
        0, 0,
        8,
        {10,    700,    5,  3,  HPT("7d8"), "4d4/2d10"}
},
{"gibbering ghoul",
        15, TRUE,   TRUE,   'g',    "3-15",
        {ISMEAN, CANPARALYZE, CANDRAIN, ISUNDEAD, CANSUMMON},
        "ghoul", 2,
        10,
        {10,    750,    6,  4,  HPT("6d10"), "1d6+2/1d4+1/1d4+1/1d8"}
},
{"catoblepas",
        10, TRUE,   TRUE,   'c',    "3-5",
        {ISMEAN, LOOKSTONE, CANSTINK, ISLARGE},
        0, 0,
        8,
        {16,    700,    6,  7,  HPT("6d8+2"), "1d6/1d8"}
},
{"jackalwere",
        50, TRUE,   TRUE,   'J',    "11-12",
        {ISMEAN, CANSHOOT, CANWIELD, CANSNORE, MAGICHIT, CANSUMMON},
        "jackal", 2,
        4,
        {10,    800,    4,  4,  HPT("4d8"), "2d4"}
},
{"werebear",
        10, TRUE,   TRUE,   'U',    "14-16",
        {ISMEAN, CANHUG, ISLARGE, MAGICHIT, CANSUMMON},
        "brown bear", 2,
        10,
        {16,    825,    6,  2,  HPT("7d8+3"), "1d3/1d3/2d8"}
},
{"salamander",
        50, TRUE,   TRUE,   's',    "14-16",
        {ISMEAN, NOFIRE, CANHUG, MAGICHIT, CANWIELD},
        "fire beetle", 2,
        14,
        {13,    825,    6,  4,  HPT("7d8+7"), "2d6/1d6"}
},
{"ankylosaurus",
        0,  TRUE,   TRUE,   'a',    "0-0",
        {ISMEAN, CANTRAMPLE, ISLARGE},
        0, 0,
        12,
        {18,    900,    9,  0,  HPT("9d8"), "3d6"}
},
{"yeenoghu",
        0,  TRUE,   TRUE,   'y',    "5-10",
        {ISMEAN, CANTRAMPLE, ISLARGE},
        0, 0,
        12,
        {18,    900,    11,  0,  HPT("9d8"), "3d6"}
},
{"erinyes",
        25, TRUE,   TRUE,   'E',    "8-10",
        {ISMEAN, CANFRIGHTEN, CANSUMMON, ISUNDEAD},
        "lemure", 3,
        8,
        {10,    875,    7,  2,  HPT("6d8+6"), "2d4"}
},
{"spotted lion",
        0,  TRUE,   TRUE,   'L',    "3-5",
        {ISMEAN, ISLARGE},
        "lion", 2,
        10,
        {12,    700,    6,  5,  HPT("6d8+2"), "1d4/1d4/1d12"}
},
{"killer bee",
        0,  TRUE,   TRUE,   'z',    "2-4",
        {ISMEAN, CANPOISON, CANFLY, ISMANY, ISSMALL},
        0, 0,
        20,
        {6, 800,    4,  0,  HPT("3d8"), "1d10"}
},
{"minotaur lizard",
        40, TRUE,   TRUE,   'm',    "0-0",
        {ISMEAN, ISLARGE},
        0, 0,
        10,
        {14,    875,    7,  5,  HPT("8d8"), "2d6/2d6/3d6"}
},
{"lammasu",
        0,  TRUE,   TRUE,   'l',    "14-18",
        {CANFLY, MEDCAST, CANSPEAK, CANBARGAIN, ISLARGE, HIGHFRIENDLY},
        0, 0,
        10,
        {10,    850,    7,  6,  HPT("7d8+7"), "1d6/1d6"}
},
{"teratosaurus",
        0,  TRUE,   TRUE,   'T',    "0-0",
        {ISMEAN, ISFAST, ISLARGE},
        0, 0,
        14,
        {18,    900,    8,  5,  HPT("10d8"), "1d3/1d3/3d6"}
},
{"rhynosphinx",
        0,  TRUE,   TRUE,   'r',    "3-5",
        {ISMEAN, ISFAST, CANTRAMPLE, ISLARGE},
        0, 0,
        12,
        {18,    925,    8,  6,  HPT("9d8"), "2d10/2d8"}
},
{"rhinoceros",
        0,  TRUE,   TRUE,   'R',    "3-5",
        {ISMEAN, ISFAST, CANTRAMPLE, ISLARGE},
        0, 0,
        12,
        {18,    900,    8,  6,  HPT("8d8"), "2d4/2d6"}
},
{"slyph",
        30, TRUE,   TRUE,   'S',    "12-18",
        {ISMEAN, HALFDAMAGE, MAGICHIT, CANSUMMON, NOBOLT, NOCOLD, CANSEE, CANFLY, ISSHADOW},
        "giant crocodile", 3,
        10,
        {10,    800,    9,  7,  HPT("6d8+3"), "1d6/1d6/1d6/1d4"}
},
{"rakshasa",
        20, TRUE,   TRUE,   'r',    "12-14",
        {ISMEAN, MEDCAST, BMAGICHIT},
        0, 0,
        8,
        {13,    925,    8,  -4, HPT("7d8"), "1d3/1d3/1d4+1"}
},
{"wyvern",
        5,  TRUE,   TRUE,   'w',    "6-8",
        {ISMEAN, CANSURPRISE, CANSEE, CANFLY, CANPOISON},
        0, 0,
        10,
        {14,    925,    8,  3,  HPT("7d8+7"), "1d6/2d8"}
},
{"mummy",
        20, TRUE,   FALSE,  'm',    "5-7",
        {ISMEAN, CANINFEST, CANSUMMON, MAGICHIT, CANFRIGHTEN, HALFDAMAGE, CANBBURN, ISUNDEAD},
        "ghast", 2,
        8,
        {10,    1150,   6,  3,  HPT("6d8+3"), "1d12"}
},
{"basilisk",
        0,  TRUE,   TRUE,   'B',    "1-1",
        {ISMEAN, LOOKSTONE},
        0, 0,
        8,
        {10,    1000,   6,  4,  HPT("6d8+1"), "1d10"}
},
{"medusa",
        0,  TRUE,   FALSE,  'M',    "11-14",
        {LOOKSTONE, CANPOISON},
        0, 0,
        10,
        {10,    1000,   7,  5,  HPT("6d8"), "1d4"}
},
{"polar bear",
        0,  TRUE,   TRUE,   'U',    "5-8",
        {ISMEAN, CANSUMMON, CANHUG, ISLARGE},
        "winter wolf", 2,
        12,
        {10,    900,    6,  6,  HPT("8d8"), "2d6/2d10"}
},
{"otyugh",
        0,  TRUE,   TRUE,   'o',    "5-10",
        {ISMEAN, CANDISEASE},
        0, 0,
        8,
        {10,    700,    7,  3,  HPT("7d8"), "1d8/1d8/1d4+1"}
},
{"adult dragon",
        30, TRUE,   FALSE,  'd',    "15-16",
        {ISMEAN, CANBRANDOM, ISGREED, CANFRIGHTEN, ISLARGE, MEDFRIENDLY},
        0, 0,
        9,
        {10,    1000,   8,  -1, HPT("45d1"), "1d8/1d8/3d10"}
},
{"invisible stalker",
        0,  TRUE,   TRUE,   'I',    "13-14",
        {ISMEAN, ISINVIS, ISLARGE},
        0, 0,
        10,
        {10,    1090,   8,  3,  HPT("8d8"), "4d4"}
},
{"xorn",
        0,  TRUE,   TRUE,   'X',    "8-10",
        {ISMEAN, CANINWALL, CANSUMMON, NOCOLD, NOFIRE, CANSURPRISE},
        "vilstrak", 2,
        10,
        {10,    1275,   7,  -2, HPT("7d8+7"), "1d3/1d3/1d3/4d6"}
},
{"will-o-wisp",
        100,    TRUE,   FALSE,  'W',    "15-16",
        {ISMEAN, BMAGICHIT, CANSURPRISE, ISSMALL},
        0, 0,
        12,
        {10,    1200,   9,  -8, HPT("9d8"), "2d8"}
},
{"chimera",
        0,  TRUE,   FALSE,  'c',    "2-4",
        {ISMEAN, CANFLY, NOFIRE, CANBFIRE, ISLARGE},
        0, 0,
        12,
        {10,    1000,   9,  6,  HPT("9d8"), "1d3/1d3/1d4/1d4/2d4/3d4"}
},
{"barrow wight",
        100,    TRUE,   FALSE,  'W',    "14-18",
        {ISMEAN, CANPARALYZE, CANSUMMON, CANDRAIN, BMAGICHIT, ISUNDEAD},
        "wight", 2,
        10,
        {10,    975,    10, 0,  HPT("10d6"), "3d6/1d8"}
},
{"anatosaurus",
        0,  TRUE,   FALSE,  'a',    "0-0",
        {ISFLEE, CANTRAMPLE, ISLARGE},
        0, 0,
        16,
        {18,    1300,   9,  5,  HPT("12d8"), "1d4"}
},
{"wooly rhinoceros",
        0,  TRUE,   TRUE,   'R',    "3-5",
        {ISMEAN, ISFAST, CANSUMMON, CANTRAMPLE, ISLARGE},
        "rhinoceros", 2,
        14,
        {18,    1350,   9,  5,  HPT("10d8"), "2d6"}
},
{"air squid",
        40, TRUE,   TRUE,   'S',    "2-8",
        {ISMEAN, CANHUG, CANFLY, CANBBURN, ISLARGE, LOWFRIENDLY},
        0, 0,
        16,
        {10,    1400,   9,  7,  HPT("12d8"), "1d8/1d8/1d8/1d8/1d8/1d8/1d8/1d8/1d10"}
},
{"octorilla (snake ape)",
        80, TRUE,   TRUE,   'o',    "2-8",
        {ISMEAN, CANSUMMON, CANHUG, ISFLOCK},
        "carnivorous ape", 2,
        20,
        {14,    1500,   6,  6,  HPT("6d8"), "1d10/1d10/1d10/1d10/2d6"}
},
{"cave bear",
        0,  TRUE,   TRUE,   'U',    "5-8",
        {ISMEAN, CANSUMMON, CANHUG, ISLARGE},
        "bugbear", 2,
        14,
        {10,    850,    6,  6,  HPT("6d8+6"), "2d8/1d12"}
},
{"elasmosaurus",
        0,  TRUE,   TRUE,   'e',    "4-6",
        {ISMEAN},
        0, 0,
        10,
        {10,    1700,   4,  -4, HPT("4d7"), "4d6"}
},
{"electric eel",
        0,  TRUE,   TRUE,   'E',    "4-6",
        {ISMEAN, CANBBOLT, NOBOLT, NOFIRE, CANSWIM},
        0, 0,
        10,
        {10,    1700,   4,  -4, HPT("4d8"), "4d6"}
},
{"remorhaz",
        0,  TRUE,   TRUE,   'r',    "4-6",
        {ISMEAN, CANBFIRE, CANSUMMON, NOFIRE, ISFAST, ISLARGE},
        "winter wolf", 2,
        16,
        {18,    1700,   6,  0,  HPT("9d8"), "6d6"}
},
{"airfang",
        0,  TRUE,   TRUE,   'S',    "2-8",
        {ISMEAN, CANFLY, ISMANY, ISSMALL},
        0, 0,
        10,
        {10,    1200,   3,  -4, HPT("8d6"), "3d4/3d4"}
},
{"megalosaurus",
        0,  TRUE,   TRUE,   'M',    "0-0",
        {ISMEAN, ISFAST, ISLARGE},
        0, 0,
        16,
        {18,    1300,   9,  5,  HPT("12d8"), "3d6"}
},
{"lambeosaurus",
        0,  TRUE,   FALSE,  'l',    "0-0",
        {ISFLEE, CANTRAMPLE, ISFLOCK, ISLARGE},
        0, 0,
        16,
        {18,    1300,   9,  5,  HPT("12d8"), "2d6"}
},
{"dragonne",
        15, TRUE,   TRUE,   'd',    "6-8",
        {ISMEAN, CANFLY, CANSHRIEK, ISLARGE},
        0, 0,
        14,
        {13,    1400,   9,  4,  HPT("9d8"), "1d8/1d8/3d6"}
},
{"giant slug",
        0,  TRUE,   TRUE,   's',    "0-0",
        {ISMEAN, CANPOISON},
        0, 0,
        15,
        {10,    1500,   9,  8,  HPT("10d8"), "1d12"}
},
{"fire lizard",
        25, TRUE,   TRUE,   'F',    "2-4",
        {NOFIRE, CANBFIRE, ISLARGE},
        0, 0,
        14,
        {13,    1350,   9,  3,  HPT("10d8"), "1d8/1d8/2d8"}
},
{"paleoscincus",
        0,  TRUE,   TRUE,   'p',    "0-0",
        {ISMEAN, CANTRAMPLE, ISLARGE},
        0, 0,
        12,
        {18,    1300,   9,  -3, HPT("9d8"), "2d6"}
},
{"bulette",
        0,  TRUE,   TRUE,   'u',    "2-4",
        {ISMEAN, CANSURPRISE, ISLARGE},
        0, 0,
        10,
        {10,    1300,   5,  -2, HPT("9d8"), "4d12/6d6"}
},
{"mimic",
        30, TRUE,   FALSE,  'M',    "2-10",
        {ISDISGUISE, CANHOLD, ISLARGE},
        0, 0,
        12,
        {10,    1300,   9,  7,  HPT("9d8"), "3d4"}
},
{"xonoclon",
        30, TRUE,   FALSE,  'x',    "2-10",
        {ISDISGUISE, ISLARGE},
        0, 0,
        12,
        {10,    1300,   15,  7,  HPT("9d8"), "3d8"}
},
{"achaierai",
        0,  TRUE,   TRUE,   'A',    "8-12",
        {ISLARGE},
        0, 0,
        14,
        {15,    1300,   7,  8,  HPT("0d8+100"), "1d8/1d8/1d10"}
},
{"succubus (Servant of Errtu)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Errtu)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"horned devil",
        5,  TRUE,   TRUE,   'H',    "13-14",
        {ISMEAN, CANFLY, CANFRIGHTEN, CANINFEST, CANPOISON, MAGICHIT, CANSUMMON, ISLARGE, ISUNDEAD},
        "imp", 3,
        6,
        {10,    1320,   7,  -3, HPT("5d8+5"), "1d4/1d4/1d4+1/1d3"}
},
{"pentacerotops",
        0,  TRUE,   TRUE,   'P',    "0-0",
        {ISMEAN, CANTRAMPLE, ISLARGE},
        0, 0,
        18,
        {18,    1300,   9,  4,  HPT("12d8"), "1d6/1d10/1d10"}
},
{"spectre",
        0,  TRUE,   TRUE,   'S',    "13-14",
        {ISMEAN, CANSUMMON, DOUBLEDRAIN, ISUNDEAD, ISSHADOW},
        "shadow", 2,
        10,
        {10,    1650,   7,  2,  HPT("7d8+3"), "1d8"}
},
{"neotyugh",
        0,  TRUE,   TRUE,   'n',    "10-12",
        {ISMEAN, CANDISEASE, ISLARGE},
        0, 0,
        10,
        {12,    1500,   10, 0,  HPT("12d8"), "1d8/1d8/2d3"}
},
{"intellect devourer",
        0,  TRUE,   TRUE,   'r',    "11-13",
        {ISMEAN, DRAINBRAIN, CANSURPRISE, ISFAST},
        0, 0,
        8,
        {14,    1510,   10, 4,  HPT("6d8+6"), "1d4/1d4/1d4/1d4"}
},
{"heffalump",
        0,  TRUE,   TRUE,   'h',    "4-6",
        {ISMEAN, CANTRAMPLE, NOBOLT, NOFIRE, CANHUG, ISFLOCK, ISLARGE},
        0, 0,
        14,
        {18,    1500,   9,  1,  HPT("10d8"), "3d10/3d10/2d8"}
},
{"elephant",
        0,  TRUE,   TRUE,   'e',    "4-6",
        {ISMEAN, CANTRAMPLE, CANHUG, ISFLOCK, ISLARGE},
        0, 0,
        14,
        {18,    1500,   9,  6,  HPT("10d8"), "2d6/2d6/2d6/2d6/2d6"}
},
{"succubus (Servant of Ndulu)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Ndulu)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"barbed devil",
        0,  TRUE,   TRUE,   'B',    "11-12",
        {ISMEAN, CANFLY, TOUCHFEAR, CANSUMMON, CANHOLD, ISUNDEAD},
        "quasit", 3,
        10,
        {10,    1425,   8,  0,  HPT("8d8"), "2d4/2d4/3d4"}
},
{"vrock",
        10, TRUE,   TRUE,   'v',    "5-7",
        {ISMEAN, CANSUMMON, CANSEE, ISLARGE},
        "vilstrak", 2,
        10,
        {10,    1500,   8,  0,  HPT("8d8"), "1d4/1d6"}
},
{"lamia",
        20, TRUE,   TRUE,   'L',    "11-14",
        {CANFLY, MEDCAST, DRAINWISDOM, CANSPEAK, CANBARGAIN},
        0, 0,
        12,
        {12,    1700,   8,  3,  HPT("9d8"), "1d4"}
},
{"shambling mound",
        25, TRUE,   TRUE,   's',    "5-7",
        {ISSLOW, ISMEAN, CANSUFFOCATE, NOCOLD, NOFIRE, CANHOLD, ISLARGE},
        0, 0,
        10,
        {10,    1800,   9,  0,  HPT("9d8"), "2d8/2d8"}
},
{"succubus (Servant of Bilwhr)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Bilwhr)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"mind flayer",
        25, TRUE,   TRUE,   'M',    "15-17",
        {ISMEAN, DRAINBRAIN},
        0, 0,
        12,
        {10,    1800,   9,  5,  HPT("8d8+4"), "2d2/2d2"}
},
{"gorgon",
        5,  TRUE,   TRUE,   'g',    "3-5",
        {ISMEAN, CANTRAMPLE, NOFIRE, CANBFIRE, ISLARGE},
        0, 0,
        10,
        {14,    1750,   9,  2,  HPT("8d8"), "2d6"}
},
{"night hag",
        5,  TRUE,   TRUE,   'n',    "13-15",
        {ISMEAN, CANSNORE, CANSUMMON, ISINVIS, BMAGICHIT, NOFIRE, NOCOLD, ISUNDEAD},
        "nightmare", 2,
        12,
        {14,    1750,   9,  9,  HPT("8d8"), "2d6"}
},
{"umber hulk",
        40, TRUE,   TRUE,   'U',    "8-10",
        {ISSLOW, ISMEAN, CANHUH, ISLARGE},
        0, 0,
        12,
        {10,    1700,   8,  2,  HPT("8d8+8"), "3d4/3d4/2d5"}
},
{"old dragon",
        30, TRUE,   FALSE,  'd',    "15-16",
        {ISMEAN, CANBRANDOM, CANSUMMON, ISGREED, CANFRIGHTEN, ISLARGE, LOWFRIENDLY},
        "very young dragon", 1,
        11,
        {10,    1800,   8,  2,  HPT("55d1"), "1d10/1d10/3d12"}
},
{"succubus (Servant of Nalfeshnee)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Nalfeshnee)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"gorgosaurus",
        0,  TRUE,   TRUE,   'G',    "0-0",
        {ISMEAN, ISFAST, ISLARGE},
        0, 0,
        18,
        {18,    1800,   9,  5,  HPT("13d8"), "1d3/1d3/7d4"}
},
{"efreeti",
        10, TRUE,   TRUE,   'E',    "0-0",
        {NOFIRE, ISMEAN, CANBFIRE, CANFLY, CANSPEAK, ISLARGE},
        0, 0,
        14,
        {18,    1950,   9,  2,  HPT("10d8"), "3d8"}
},
{"succubus (Servant of Johud)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Johud)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"treant",
        0,  TRUE,   TRUE,   'T',    "10-13",
        {CANBBURN, CANSUMMON, CANSPEAK, ISLARGE, LOWFRIENDLY},
        "ent", 3,
        14,
        {18,    1950,   9,  0,  HPT("10d8"), "2d8/3d6/4d6"}
},
{"giant toad",
        0,  TRUE,   TRUE,   't',    "1-4",
        {ISMEAN, CANPOISON, ISLARGE},
        0, 0,
        14,
        {10,    3950,   15, 6,  HPT("15d8"), "15d4"}
},
{"ettin",
        0,  TRUE,   TRUE,   'e',    "0-0",
        {ISMEAN, CANSHOOT, CANWIELD, ISLARGE},
        0, 0,
        14,
        {10,    1950,   10, 3,  HPT("10d8"), "2d8/3d6"}
},
{"succubus (Servant of Alzoll)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Alzoll)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"hero-mage (Keoghtom)",
        100,    TRUE,   TRUE,   'k',    "19",
        {CANCAST, ISUNIQUE, CANBARGAIN, CANWIELD, CANSHOOT, CANSUMMON, ISFAST, HIGHFRIENDLY},
        "lesser god (Celestian the Far Wanderer)", 1,
        45,
        {12,    42000L, 25, -8, HPT("0d8+77"), "3d4"}
},
{"arch-mage (Heward)",
        100,    TRUE,   TRUE,   'H',    "20",
        {CANCAST, ISUNIQUE, CANBARGAIN, CANWIELD, CANSHOOT, CANSUMMON, ISFAST, HIGHFRIENDLY},
        "arch-mage (Mordenkainen)", 1,
        50,
        {18,    50000L, 25, -3, HPT("0d8+96"), "3d4"}
},
{"arch-mage (Mordenkainen)",
        100,    TRUE,   TRUE,   'M',    "20",
        {CANCAST, ISUNIQUE, CANBARGAIN, CANWIELD, CANSHOOT, CANSUMMON, ISFAST, HIGHFRIENDLY},
        "hero-mage (Murlynd)", 1,
        50,
        {18,    50000L, 25, -3, HPT("0d8+96"), "3d4"}
},
{"hero-mage (Murlynd)",
        100,    TRUE,   TRUE,   'm',    "20",
        {CANCAST, ISUNIQUE, CANBARGAIN, CANWIELD, CANSHOOT, CANSUMMON, ISFAST, HIGHFRIENDLY},
        "hero-mage (Keoghtom)", 1,
        50,
        {19,    56000L, 25, -2, HPT("0d8+135"), "3d4"}
},
{"hero (Kelanen, Prince of Swords)",
        100,    TRUE,   TRUE,   'k',    "17",
        {ISUNIQUE, CANBARGAIN, CANWIELD, CANSHOOT, CANSUMMON, ISFAST, HIGHFRIENDLY},
        "lesser goddess (Xan Yae, Lady of Perfection)", 1,
        50,
        {19,    53000L, 25, -5, HPT("0d8+159"), "3d4"}
},
{"styracosaurus",
        0,  TRUE,   TRUE,   'S',    "0-0",
        {ISMEAN, CANTRAMPLE, ISLARGE},
        0, 0,
        14,
        {18,    1950,   9,  3,  HPT("10d8"), "2d8"}
},
{"shedu",
        0,  TRUE,   TRUE,   's',    "13-18",
        {CANFLY, MEDCAST, CANBARGAIN, ISFRIENDLY},
        0, 0,
        14,
        {13,    1950,   9,  4,  HPT("9d8+9"), "1d6/1d6"}
},
{"black pudding",
        70, TRUE,   FALSE,  'P',    "0-0",
        {ISSLOW, ISMEAN, CANRUST, NOCOLD, BOLTDIVIDE, BLOWDIVIDE, ISSCAVENGE},
        0, 0,
        14,
        {10,    2000,   10, 6,  HPT("10d8"), "3d8"}
},
{"mastadon",
        0,  TRUE,   TRUE,   'm',    "4-6",
        {ISMEAN, CANTRAMPLE, CANHUG, ISFLOCK, ISLARGE},
        0, 0,
        16,
        {19,    2000,   9,  6,  HPT("12d8"), "2d8/2d8/2d6/2d6/2d6"}
},
{"succubus (Servant of Aishapra)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Aishapra)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"giant scorpion",
        30, TRUE,   FALSE,  'S',    "0-0",
        {ISFAST, CANPOISON, ISLARGE},
        0, 0,
        10,
        {12,    2000,   8,  4,  HPT("8d8"), "1d10/1d10/1d4"}
},
{"genii",
        30, TRUE,   TRUE,   'g',    "12-18",
        {HIGHCAST, CANSUMMON, ISFAST, CANSPEAK, MAGICHIT, ISLARGE, LOWFRIENDLY},
        "djinni", 2,
        10,
        {12,    3000,   7,  3,  HPT("7d8+3"), "2d6/2d6"}
},
{"mammoth",
        0,  TRUE,   TRUE,   'M',    "4-6",
        {ISMEAN, CANTRAMPLE, CANHUG, ISFLOCK, ISLARGE},
        0, 0,
        18,
        {20,    3000,   8,  5,  HPT("13d8"), "3d6/3d6/2d8/2d6/2d6"}
},
{"gelatinous blue horror",
        100,    TRUE,   TRUE,   'g',    "0-0",
        {ISMEAN, CANBACID, NOSHARP, HALFDAMAGE, NOBOLT, ISLARGE},
        0, 0,
        55,
        {10,    7000,   10, 6,  HPT("10d8"), "1d5+4"}
},
{"stone gargoyle",
        25, TRUE,   TRUE,   'g',    "6-12",
        {ISMEAN, CANSUMMON, MAGICHIT, NOBOLT, NOCOLD, NOFIRE},
        "gargoyle", 3,
        10,
        {18,    2500,   7,  1,  HPT("4d8+4"), "1d6/1d6/2d6/2d4"}
},
{"succubus (Servant of Kevokulli)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Kevokulli)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"koppleganger",
        10, TRUE,   TRUE,   'k',    "5-8",
        {ISMEAN, CANSURPRISE, CANSEE},
        0, 0,
        10,
        {7, 2000,   15, 2,  HPT("4d4"), "1d12"}
},
{"kittyhawk",
        10, TRUE,   TRUE,   'K',    "5-8",
        {ISMEAN, CANFLY, CANSURPRISE, ISSMALL, ISMANY, CANSEE},
        0, 0,
        10,
        {7, 2000,   15, 2,  HPT("4d4"), "1d2/1d2/1d2/1d3/1d3/1d3"}
},
{"rock hound",
        0,  TRUE,   TRUE,   'R',    "5-8",
        {ISMEAN, CANINWALL, CANSUMMON, TOUCHSTONE, CANSURPRISE, CANSEE},
        "vilstrak", 1,
        20,
        {10,    2250,   5,  3,  HPT("7d8"), "3d10"}
},
{"succubus (Servant of Balor)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Balor)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"kodiac bear",
        0,  TRUE,   TRUE,   'U',    "5-8",
        {ISMEAN, CANSUMMON, CANHUG, ISLARGE},
        "cave bear", 2,
        20,
        {18,    2000,   10, -1, HPT("12d8"), "3d8/2d6/2d6"}
},
{"very old dragon",
        30, TRUE,   FALSE,  'd',    "15-16",
        {ISMEAN, CANBRANDOM, CANSUMMON, ISGREED, CANFRIGHTEN, ISLARGE, LOWFRIENDLY},
        "young dragon", 1,
        11,
        {10,    2000,   8,  2,  HPT("55d1"), "1d10/1d10/3d12"}
},
{"hezrou",
        15, TRUE,   TRUE,   'h',    "5-7",
        {ISMEAN, CANFRIGHTEN, CANSEE, CANSUMMON, ISUNDEAD, ISLARGE},
        "horned devil", 2,
        12,
        {10,    2000,   9,  -2, HPT("9d8"), "1d3/1d3/4d4"}
},
{"loxodant",
        0,  TRUE,   TRUE,   'L',    "4-6",
        {ISMEAN, CANTRAMPLE, CANHUG, ISFAST},
        0, 0,
        16,
        {18,    2150,   9,  6,  HPT("11d8"), "2d8/2d8/2d6/2d6/2d6"}
},
{"flesh golem",
        0,  TRUE,   TRUE,   'f',    "0-0",
        {ISMEAN, MAGICHIT, ISLARGE},
        0, 0,
        0,
        {18,    2380,   9,  9,  HPT("0d0+40"), "2d8/2d8"}
},
{"glabrezu",
        25, TRUE,   FALSE,  'G',    "8-10",
        {ISMEAN, CANFRIGHTEN, CANSEE, CANSUMMON, ISUNDEAD, ISLARGE},
        "barbed devil", 2,
        14,
        {10,    2400,   10, -4, HPT("10d8"), "2d6/2d6/1d3/1d3/1d4+1"}
},
{"succubus (Servant of Ter-soth)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Ter-soth)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"allosaurus",
        0,  TRUE,   TRUE,   'a',    "0-0",
        {ISMEAN, CANTRAMPLE, ISFAST, ISLARGE},
        0, 0,
        20,
        {18,    2400,   10, 5,  HPT("15d8"), "1d4/1d4/6d4"}
},
{"couatl",
        15, TRUE,   FALSE,  'c',    "15-18",
        {ISMEAN, HIGHCAST, CANHUG, CANPOISON, HIGHFRIENDLY},
        0, 0,
        12,
        {16,    2400,   10, 5,  HPT("9d8"), "2d4/1d3"}
},
{"succubus (Servant of Rehnaremme)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Rehnaremme)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"banshee",
        0,  TRUE,   FALSE,  'B',    "15-20",
        {ISSHADOW, CANSUMMON, CANSHRIEK, CANSURPRISE, CANFRIGHTEN, NOCOLD, NOBOLT, MAGICHIT, ISUNDEAD},
        "shrieker", 10,
        10,
        {10,    2450,   10, 0,  HPT("7d8"), "1d8"}
},
{"spirit naga",
        25, TRUE,   FALSE,  's',    "13-16",
        {ISMEAN, CANPOISON, CANSNORE, HIGHCAST, ISUNDEAD},
        0, 0,
        14,
        {10,    2700,   10, 4,  HPT("9d8"), "1d3"}
},
{"dire wolf",
        10, TRUE,   TRUE,   'w',    "3-9",
        {ISMEAN, CANSUMMON, ISLARGE},
        "warg", 3,
        5,
        {10,    1440,   8,  0,  HPT("8d8"), "1d8"}
},
{"succubus (Servant of Wendonai)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Wendonai)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"roper",
        80, TRUE,   FALSE,  'r',    "13-16",
        {ISMEAN, ISSLOW, CANHUG, CANHOLD, NOBOLT, CANBBURN, ISLARGE},
        0, 0,
        16,
        {19,    2750,   10, 0,  HPT("11d8"), "5d4"}
},
{"bone devil",
        0,  TRUE,   TRUE,   'd',    "11-12",
        {ISMEAN, CANFLY, CANFRIGHTEN, CANSEE, CANSUMMON, CANSURPRISE, CANCHILL, ISUNDEAD, ISLARGE},
        "hezrou", 2,
        12,
        {10,    2800,   9,  -1, HPT("9d8"), "5d4"}
},
{"air elemental",
        0,  TRUE,   TRUE,   'a',    "3-5",
        {ISMEAN, CANFLY, ISSHADOW, BMAGICHIT, ISLARGE},
        0, 0,
        15,
        {18,    2850,   9,  2,  HPT("12d8"), "2d10"}
},
{"earth elemental",
        0,  TRUE,   TRUE,   'e',    "3-5",
        {ISMEAN, CANINWALL, CANSURPRISE, ISSLOW, BMAGICHIT, ISLARGE},
        0, 0,
        15,
        {18,    2850,   9,  2,  HPT("12d8"), "4d8"}
},
{"fire elemental",
        0,  TRUE,   TRUE,   'f',    "3-5",
        {ISMEAN, NOFIRE, CANBFIRE, BMAGICHIT, ISLARGE},
        0, 0,
        15,
        {18,    2850,   9,  2,  HPT("12d8"), "3d8"}
},
{"cold elemental",
        0,  TRUE,   TRUE,   'c',    "3-5",
        {ISMEAN, NOCOLD, CANBICE, BMAGICHIT, ISLARGE},
        0, 0,
        15,
        {18,    2850,   9,  2,  HPT("12d8"), "3d8"}
},
{"succubus (Servant of Marilith)",
        10, TRUE,   TRUE,   's',    "15-18",
        {ISMEAN, HIGHCAST, CANSUMMON, BMAGICHIT, CANDARKEN, CANBARGAIN},
        "lesser demon (Marilith)", 1,
        6,
        {11,    2100,   13, 0,  HPT("6d8"), "1d3/1d3"}
},
{"tarry demodand (farastu)",
        0,  TRUE,   TRUE,   'T',    "18",
        {ISMEAN, MAGICHIT, CANSTICK},
        0, 0,
        16,
        {19,    2850,   9,  -1,     HPT("11d8"), "1d6+1/1d6+1/3d4"}
},
{"wood elemental",
        0,  TRUE,   TRUE,   'w',    "3-5",
        {ISMEAN, CANBBURN, CANSUMMON, BMAGICHIT, ISLARGE},
        "entwife", 1,
        15,
        {18,    2850,   9,  2,  HPT("12d8"), "3d8"}
},
{"greater basilisk",
        70, TRUE,   FALSE,  'B',    "5-8",
        {ISGREED, CANSUMMON, LOOKSTONE, CANPOISON, LOOKSTONE},
        "basilisk", 2,
        16,
        {10,    3000,   7,  2,  HPT("10d8"), "2d6/2d8"}
},
{"lesser demon (Bilwhr)",
        0,  TRUE,   TRUE,   'b',    "12-14",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "hezrou", 3,
        16,
        {14,    3000,   8,  -1, HPT("11d8"), "1d4/1d4/2d4"}
},
{"lesser demon (Johud)",
        0,  TRUE,   TRUE,   'j',    "12-14",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "hezrou", 3,
        16,
        {14,    3000,   8,  -1, HPT("11d8"), "1d4/1d4/2d4"}
},
{"lesser demon (Nalfeshnee)",
        0,  TRUE,   TRUE,   'b',    "12-14",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "hezrou", 3,
        16,
        {14,    3000,   8,  -1, HPT("11d8"), "1d4/1d4/2d4"}
},
{"stegosaurus",
        0,  TRUE,   TRUE,   'S',    "0-0",
        {ISMEAN, ISLARGE},
        0, 0,
        25,
        {18,    3000,   9,  3,  HPT("18d8"), "5d4"}
},
{"lesser demon (Aishapra)",
        0,  TRUE,   TRUE,   'a',    "12-14",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANSEE, BMAGICHIT, CANSUMMON, ISLARGE},
        "hezrou", 3,
        12,
        {12,    3000,   8,  -7, HPT("7d8+7"), "2d4"}
},
{"lesser demon (Kevokulli)",
        0,  TRUE,   TRUE,   'k',    "12-14",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANSEE, BMAGICHIT, CANSUMMON, ISLARGE},
        "hezrou", 3,
        12,
        {12,    3000,   8,  -7, HPT("7d8+7"), "2d4"}
},
{"lesser demon (Marilith)",
        0,  TRUE,   TRUE,   'm',    "12-14",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANSEE, BMAGICHIT, CANSUMMON, ISLARGE},
        "hezrou", 3,
        12,
        {12,    3000,   8,  -7, HPT("7d8+7"), "2d4"}
},
{"lesser demon (Rehnaremme)",
        0,  TRUE,   TRUE,   'r',    "12-14",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANSEE, BMAGICHIT, CANSUMMON, ISLARGE},
        "hezrou", 3,
        12,
        {12,    3000,   8,  -7, HPT("7d8+7"), "2d4"}
},
{"guardian naga",
        100,    TRUE,   FALSE,  'G',    "16-18",
        {CANPOISON, NOMOVE, HIGHCAST, HIGHFRIENDLY},
        0, 0,
        16,
        {10,    3550,   8,  3,  HPT("11d8+4"), "1d6/2d4"}
},
{"lesser demon (Alzoll)",
        0,  TRUE,   TRUE,   'A',    "14-16",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "glabrezu", 3,
        12,
        {16,    3600,   8,  -2, HPT("8d8+8"), "1d12+1"}
},
{"clay golem",
        0,  TRUE,   TRUE,   'C',    "0-0",
        {NOSHARP, ISMEAN, ISLARGE},
        0, 0,
        0,
        {18,    3600,   8,  7,  HPT("0d0+50"), "3d10"}
},
{"shade",
        0,  TRUE,   TRUE,   's',    "15-20",
        {ISSHADOW, CANSUMMON, ISUNDEAD, ISMEAN, CANDRAIN, MAGICHIT},
        "night hag", 2,
        15,
        {10,    4250,   4,  4,  HPT("4d10"), "1d6"}
},
{"lesser demon (Balor)",
        0,  TRUE,   TRUE,   'B',    "14-16",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "glabrezu", 3,
        12,
        {16,    3600,   8,  -2, HPT("8d8+8"), "1d12+1"}
},
{"lesser demon (Errtu)",
        0,  TRUE,   TRUE,   'E',    "14-16",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "glabrezu", 3,
        12,
        {16,    3600,   8,  -2, HPT("8d8+8"), "1d12+1"}
},
{"wyvergon",
        5,  TRUE,   TRUE,   'w',    "3-10",
        {ISMEAN, CANPOISON, LOOKSTONE, NOFIRE, ISLARGE},
        0, 0,
        10,
        {14,    1750,   9,  2,  HPT("8d8+1"), "2d8/2d6/1d6"}
},
{"lesser demon (Ndulu)",
        0,  TRUE,   TRUE,   'N',    "14-16",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "glabrezu", 3,
        12,
        {16,    3600,   8,  -2, HPT("8d8+8"), "1d12+1"}
},
{"lesser demon (Ter-soth)",
        0,  TRUE,   TRUE,   'T',    "14-16",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "glabrezu", 3,
        12,
        {16,    3600,   8,  -2, HPT("8d8+8"), "1d12+1"}
},
{"lesser demon (Wendonai)",
        0,  TRUE,   TRUE,   'T',    "14-16",
        {ISUNIQUE, CANFLY, ISMEAN, CANWIELD, CANCAST, CANFRIGHTEN, BMAGICHIT, CANSUMMON, CANDARKEN, ISLARGE},
        "glabrezu", 3,
        12,
        {16,    3600,   8,  -2, HPT("8d8+8"), "1d12+1"}
},
{"lesser demon (Cerberus)",     /* Three heads - fire, clorine, acid */
        0,  TRUE,   TRUE,   'T',    "14-16",
        {ISUNIQUE, ISMEAN, MAGICHIT, CANSUMMON, CANBPGAS, CANBACID, CANBFIRE, CANSEE, NOFIRE, ISLARGE, HASOXYGEN},
        "hell hound", 6,
        15,
        {16,    3600,   9,  1,  HPT("8d8+8"), "2d4/2d4/2d4"}
},
{"slime demodand (kelubar)",
        0,  TRUE,   TRUE,   'S',    "14-20",
        {MAGICHIT, CANPOISON, CANWIELD, CANBARGAIN},
        0, 0,
        18,
        {20,    3959,   9,  -2,     HPT("13d8"), "2d4/2d4/4d4"}
},
{"nazgul (Ringwraith)",
        0,  TRUE,   TRUE,   'z',    "14-16",
        {ISMEAN, CANPOISON, ISSHADOW, CANRUST, CANHUH, CANFRIGHTEN, CANDRAIN, MAGICHIT, ISFLOCK, CANSUMMON},
        "dire wolf", 2,
        15,
        {16,    4000,   10, 0,  HPT("8d8+8"), "1d10"}
},
{"vampire",
        20, TRUE,   TRUE,   'V',    "15-16",
        {ISMEAN, CANFLY, CANSUMMON, ISREGEN, CANSUCK, ISUNDEAD},
        "barrow wight", 2,
        16,
        {20,    3800,   8,  1,  HPT("8d8+3"), "1d10"}
},
{"camarasaurus",
        0,  TRUE,   FALSE,  'c',    "0-0",
        {ISFLEE, CANTRAMPLE, ISLARGE},
        0, 0,
        30,
        {24,    4000,   9,  6,  HPT("20d8"), "3d4"}
},
{"triceratops",
        0,  TRUE,   TRUE,   'T',    "0-0",
        {ISMEAN, CANTRAMPLE, ISLARGE},
        0, 0,
        20,
        {18,    4000,   9,  3,  HPT("16d8"), "1d8/1d12/1d12"}
},
{"ghost",
        0,  TRUE,   TRUE,   'g',    "12-14",
        {ISSHADOW, CANSUMMON, ISMEAN, CANFRIGHTEN, MAGICHIT, ISUNDEAD},
        "spectre", 2,
        14,
        {10,    4050,   9,  0,  HPT("10d8"), "1d4"}
},
{"baluchitherium",
        0,  TRUE,   TRUE,   'B',    "3-5",
        {ISMEAN, CANTRAMPLE, ISLARGE},
        0, 0,
        18,
        {18,    4200,   9,  5,  HPT("14d8"), "4d5"}
},
{"nazgul (Witch-King of Angmar)",
        0,  TRUE,   FALSE,  'z',    "19",
        {ISUNIQUE, ISMEAN, CANINFEST, ISSHADOW, CANRUST, CANHUH, CANFRIGHTEN, DOUBLEDRAIN, BMAGICHIT, CANCAST, CANBARGAIN, CANSUMMON},
        "nazgul (Ringwraith)", 8,
        30,
        {18,    50000L, 30, -2, HPT("0d8+100"), "2d10"}
},
{"maiar (Melian, wife of Thingol)",
        0,  TRUE,   FALSE,  'M',    "19",
        {ISUNIQUE, BMAGICHIT, CANSEE, CANSUMMON, MEDFRIENDLY},
        "noldor elf", 10,
        30,
        {10,    55000L, 45, 4,  HPT("0d8+60"), "1d10"}
},
{"maiar (Eonwe, Herald of Manwe)",
        0,  TRUE,   FALSE,  'E',    "19",
        {ISUNIQUE, BMAGICHIT, CANSEE, CANSUMMON, MEDFRIENDLY},
        "valar (Manwe, Lord of Arda)", 1,
        0,
        {20,    55000L, 45, 4,  HPT("0d8+120"), "2d10"}
},
{"maiar (Sauron, Lord of the Rings)",
        0,  TRUE,   FALSE,  'S',    "19",
        {ISUNIQUE, ISMEAN, ISSHADOW, BMAGICHIT, CANSEE, CANSUMMON},
        "nazgul (Witch-King of Angmar)", 1,
        0,
        {20,    55000L, 35, -1, HPT("0d8+120"), "2d10"}
},
{"maiar (Irmo, Master of Spirit)",
        0,  TRUE,   FALSE,  'I',    "19",
        {ISUNIQUE, ISMEAN, BMAGICHIT, CANSEE, CANSUMMON, MEDFRIENDLY},
        "spectre", 3,
        0,
        {20,    55000L, 35, 5,  HPT("0d8+120"), "2d10"}
},
{"maiar (Namo, Master of Spirit)",
        0,  TRUE,   FALSE,  'N',    "19",
        {ISUNIQUE, ISMEAN, BMAGICHIT, CANSEE, CANSUMMON, MEDFRIENDLY},
        "ghost", 3,
        0,
        {20,    55000L, 35, 5,  HPT("0d8+120"), "2d10"}
},
{"maiar (Uinen, Lady of the Seas)",
        0,  TRUE,   FALSE,  'U',    "19",
        {ISUNIQUE, BMAGICHIT, CANSEE, CANSUMMON, MEDFRIENDLY},
        "valar (Ulmo, God of Waters)", 1,
        0,
        {10,    55000L, 35, 5,  HPT("0d8+120"), "2d10"}
},
{"maiar (Ilmare, Handmaiden of Varda)",
        0,  TRUE,   FALSE,  'I',    "19",
        {ISUNIQUE, BMAGICHIT, CANSEE, CANSUMMON, MEDFRIENDLY},
        "valar (Varda, Elbereth Gilthoniel)", 1,
        0,
        {10,    55000L, 35, 5,  HPT("0d8+60"), "1d10"}
},
{"maiar (Balrog)",
        100,    TRUE,   TRUE,   'B',    "20",
        {ISMEAN,  BMAGICHIT, CANWIELD, CANCAST, HASFIRE, ISUNDEAD},
        "pit fiend", 3,
        50,
        {22,    39000L, 20, 0,  HPT("16d8"), "4d8"}
},
{"ice devil",
        30, TRUE,   FALSE,  'I',    "13-14",
        {CANFLY, ISMEAN, CANSEE, ISREGEN, CANFRIGHTEN, CANSUMMON, CANBICE, NOCOLD, ISLARGE, ISUNDEAD},
        "glabrezu", 2,
        16,
        {20,    4400,   11, -4, HPT("11d8"), "1d4/1d4/2d4/3d4"}
},
{"purple worm",
        70, TRUE,   FALSE,  'P',    "0-0",
        {ISMEAN, ISLARGE},
        0, 0,
        20,
        {10,    4900,   15, 6,  HPT("15d8"), "2d12/2d4"}
},
{"diplodocus",
        0,  TRUE,   TRUE,   'd',    "0-0",
        {CANTRAMPLE, ISLARGE},
        0, 0,
        35,
        {23,    5000,   15, 5,  HPT("24d8"), "3d6"}
},
{"brontosaurus",
        0,  TRUE,   TRUE,   'b',    "0-0",
        {CANTRAMPLE, ISLARGE},
        0, 0,
        35,
        {23,    5000,   15, 5,  HPT("30d8"), "3d6"}
},
{"roc",
        0,  TRUE,   TRUE,   'r',    "3-5",
        {ISMEAN, CANFLY, ISLARGE},
        0, 0,
        25,
        {23,    5000,   15, 4,  HPT("18d8"), "3d6/3d6/4d6"}
},
{"silver cloud",
        100,    TRUE,   TRUE,   'c',    "0-0",
        {CANFLY, HALFDAMAGE, CANBBOLT, NOBOLT, ISLARGE},
        0, 0,
        10,
        {10,    4000,   13, 9,  HPT("6d8"), "1d4"}
},
{"coachman of death",
        100,    TRUE,   TRUE,   'C',    "12-22",
        {ISMEAN, ISUNDEAD, CANFRIGHTEN, MAGICHIT },
        0, 0,
        50,
        {10,    4000,   10, -2, HPT("10d8"), "1d8+2"}
},
{"blue pool horror",
        100,    TRUE,   FALSE,  'b',    "0-0",
        {ISMEAN, CANBACID, NOMETAL, NOSHARP, HALFDAMAGE, NOBOLT, ISLARGE},
        0, 0,
        35,
        {10,    5000,   8,  8,  HPT("8d8"), "1d5+4"}
},
{"cetiosaurus",
        0,  TRUE,   TRUE,   'c',    "0-0",
        {CANTRAMPLE, ISLARGE},
        0, 0,
        35,
        {23,    5000,   15, 6,  HPT("24d8"), "3d6"}
},
{"brachiosaurus",
        0,  TRUE,   TRUE,   'B',    "0-0",
        {CANTRAMPLE, ISLARGE},
        0, 0,
        35,
        {23,    5000,   15, 5,  HPT("36d8"), "5d4"}
},
{"shaggy demodand (shator)",
        0,  TRUE,   TRUE,   's',    "14-25",
        {CANSUMMON, BMAGICHIT, LOWCAST, CANWIELD, CANSEE, CANSTINK},
        "tarry demodand (farastu)", 8,
        20,
        {21,    5250,   13, -3,     HPT("15d8"), "1d8+1/1d8+1/5d4"}
},
{"tyranosaurus rex",
        0,  TRUE,   TRUE,   'T',    "0-0",
        {ISMEAN, ISFAST, ISLARGE},
        0, 0,
        25,
        {18,    6550,   12, 5,  HPT("18d8"), "1d6/1d6/5d8"}
},
{"pit fiend",
        100,    TRUE,   TRUE,   'f',    "15-16",
        {ISMEAN, CANSEE, BMAGICHIT, CANFRIGHTEN, CANHOLD, CANSUMMON, CANBFIRE, NOFIRE, ISLARGE, ISUNDEAD},
        "erinyes", 6,
        18,
        {22,    7900,   13, -3, HPT("13d8"), "1d4+4/1d6+6"}
},
{"hound (Nemoud, Servant of Trithereon)",
        0,  TRUE,   TRUE,   'N',    "5",
        {ISFAST, MAGICHIT, ISUNIQUE, ISLARGE, ISFRIENDLY},
        "lesser god (Trithereon the Summoner)", 1,
        16,
        {18,    8100,   13, 0,  HPT("0d8+64"), "4d4"}
},
{"ki-rin",
        25, TRUE,   TRUE,   'k',    "16-22",
        {CANFLY, MEDCAST, CANSPEAK, DRAINBRAIN, CANBARGAIN, ISLARGE, ISFRIENDLY},
        0, 0,
        16,
        {13,    8500,   13, -5, HPT("12d8"), "2d4/2d4/3d6"}
},
{"stone golem",
        0,  TRUE,   TRUE,   'S',    "0-0",
        {ISMEAN, CANBSGAS, BMAGICHIT, ISLARGE, HASOXYGEN},
        0, 0,
        0,
        {22,    8950,   13, 5,  HPT("0d0+60"), "3d8"}
},
{"titanothere",
        100,    TRUE,   FALSE,  't',    "17-20",
        {ISLARGE},
        0, 0,
        30,
        {10,    9000,   19, 0,  HPT("9d8"), "2d8/1d6"}
},
{"titan",
        100,    TRUE,   FALSE,  't',    "17-20",
        {ISSHADOW, ISLARGE, LOWFRIENDLY},
        0, 0,
        30,
        {10,    9000,   19, 0,  HPT("19d8"), "7d6"}
},
{"diamond golem",
        0,  TRUE,   TRUE,   'D',    "0-0",
        {ISMEAN, NOBOLT, CANBLIND, BMAGICHIT, ISLARGE},
        0, 0,
        0,
        {22,    9500,   13, -2, HPT("0d0+80"), "3d8"}
},
{"lich",
        100,    TRUE,   TRUE,   'l',    "19-20",
        {ISMEAN, CANSUMMON, CANPARALYZE, CANFRIGHTEN, MAGICHIT, ISUNDEAD, NOBOLT, CANCAST},
        "vampire", 4,
        16,
        {10,    10500,  11, 0,  HPT("11d8"), "1d10"}
},
{"falcon (Harrus, Servant of Trithereon)",
        0,  TRUE,   TRUE,   'H',    "6",
        {CANFLY, MAGICHIT, ISUNIQUE, ISLARGE, ISFRIENDLY},
        "lesser god (Trithereon the Summoner)", 1,
        16,
        {18,    11000,  12, 2,  HPT("0d8+72"), "1d4+4/1d4+4"}
},
{"beholder",
        0,  TRUE,   FALSE,  'b',    "14-16",
        {ISMEAN, ISSLOW, LOOKSTONE, CANFRIGHTEN, LOOKSLOW, CANSNORE, ISLARGE},
        0, 0,
        20,
        {6, 12900,  18, 1,  HPT("5d8+35"), "2d4"}
},
{"hill giant",
        30, TRUE,   TRUE,   'h',    "6-8",
        {ISMEAN, CANSUMMON, ISLARGE},
        "ogre", 4,
        30,
        {25,    13000,  10, 4,  HPT("8d8+2"), "2d8"}
},
{"cyclops",
        50, TRUE,   TRUE,   'c',    "9-18",
        {ISMEAN, LOWCAST, CANWIELD, CANSUMMON, ISLARGE},
        "cave bear", 3,
        45,
        {28,    15000,  14, 3,  HPT("12d8"), "2d8"}
},
{"stone giant",
        50, TRUE,   TRUE,   's',    "9-13",
        {ISMEAN, CANSURPRISE, CANSUMMON, ISLARGE, LOWFRIENDLY},
        "werebear", 3,
        35,
        {28,    14000,  13, 4,  HPT("9d8+3"), "2d8"}
},
{"iron golem",
        0,  TRUE,   TRUE,   'i',    "0-0",
        {ISMEAN, BMAGICHIT, CANBPGAS, ISLARGE, HASOXYGEN},
        0, 0,
        0,
        {25,    14550,  13, 3,  HPT("0d0+80"), "4d10"}
},
{"ancient brass dragon",
        100,    TRUE,   FALSE,  'r',    "13-14",
        {CANBSGAS, CANBFGAS, ISGREED, CANBARGAIN, CANFLY, ISLARGE, LOWFRIENDLY, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  13, 2,  HPT("0d8+64"), "1d4/1d4/4d4"}
},
{"ancient chrome dragon",
        100,    TRUE,   TRUE,   'C',    "8-20",
        {CANCAST, CANBPGAS, CANBARGAIN, NOBOLT, NOCOLD, NOFIRE, CANFLY, ISLARGE, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  13, 0,  HPT("0d8+75"), "4d8/1d6/1d6"}
},
{"ancient crystal dragon",
        100,    TRUE,   TRUE,   'C',    "6-12",
        {ISMEAN, ISGREED, CANCAST, CANBBOLT, NOBOLT, CANFLY, ISLARGE},
        0, 0,
        50,
        {10,    20000,  13, 0,  HPT("0d8+75"), "4d8/1d6/1d6"}
},
{"ancient white dragon",
        100,    TRUE,   TRUE,   'W',    "8-9",
        {ISMEAN, CANBICE, ISGREED, CANBARGAIN, NOCOLD, CANFLY, ISLARGE},
        0, 0,
        50,
        {10,    20000,  13, 3,  HPT("0d8+56"), "1d4/1d4/2d8"}
},
{"ancient black dragon",
        100,    TRUE,   TRUE,   'a',    "8-10",
        {ISMEAN, CANBACID, ISGREED, CANBARGAIN, CANFLY, ISLARGE},
        0, 0,
        50,
        {10,    20000,  14, 3,  HPT("0d8+64"), "1d4/1d4/3d6"}
},
{"ancient copper dragon",
        100,    TRUE,   FALSE,  'c',    "13-14",
        {CANBACID, CANBSLGAS, ISGREED, CANBARGAIN, CANFLY, ISLARGE, MEDFRIENDLY, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  15, 1,  HPT("0d8+72"), "1d4/1d4/5d4"}
},
{"ancient green dragon",
        100,    TRUE,   TRUE,   'g',    "8-12",
        {ISMEAN, CANBGAS, ISGREED, CANBARGAIN, CANFLY, ISLARGE, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  15, 2,  HPT("0d8+72"), "1d6/1d6/2d10"}
},
{"ancient bronze dragon",
        100,    TRUE,   FALSE,  'L',    "15-16",
        {CANBBOLT, CANBFGAS, ISGREED, CANBARGAIN, NOBOLT, CANFLY, ISLARGE, MEDFRIENDLY, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  16, 0,  HPT("0d8+80"), "1d6/1d6/4d6"}
},
{"ancient blue dragon",
        100,    TRUE,   TRUE,   'u',    "11-12",
        {ISMEAN, CANBBOLT, ISGREED, CANBARGAIN, NOBOLT, CANFLY, ISLARGE},
        0, 0,
        50,
        {10,    20000,  16, 2,  HPT("0d8+80"), "1d6/1d6/3d8"}
},
{"ancient silver dragon",
        100,    TRUE,   FALSE,  'S',    "15-16",
        {CANBICE, NOCOLD, CANBPGAS, ISGREED, CANBARGAIN, CANFLY, ISLARGE, MEDFRIENDLY, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  17, -1, HPT("0d8+88"), "1d6/1d6/5d6"}
},
{"frost giant",
        50, TRUE,   TRUE,   'F',    "5-10",
        {ISMEAN, CARRYGOLD, NOCOLD, ISLARGE},
        0, 0,
        40,
        {25,    20000,  15, 4,  HPT("10d8+4"), "4d6"}
},
{"ancient red dragon",
        100,    TRUE,   TRUE,   'D',    "15-16",
        {ISMEAN, CANBFIRE, ISGREED, CANBARGAIN, NOFIRE, CANFLY, ISLARGE},
        0, 0,
        50,
        {10,    20000,  17, -1, HPT("0d8+88"), "1d8/1d8/3d10"}
},
{"ancient gold dragon",
        100,    TRUE,   FALSE,  'G',    "17-18",
        {CANBFIRE, CANBGAS, ISGREED, CANBARGAIN, NOFIRE, CANFLY, ISLARGE, HIGHFRIENDLY, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  18, -2, HPT("0d8+96"), "1d8/1d8/6d6"}
},
{"ancient night dragon",  /* Dragon #74 */
        100,    TRUE,   TRUE,   'N',    "13-15",
        {CANBRANDOM, CANBLIND, ISLARGE, ISGREED, CANFLY, CANCAST, CANBARGAIN},
        0, 0,
        50,
        {10,    20000,  18, 2,  HPT("8d8"), "4d8"}
},
{"ancient electrum dragon",  /* Dragon #74 */
        100,    TRUE,   TRUE,   'E',    "17-18",
        {CANBPGAS, CANHUH, ISLARGE, CANFLY, CANCAST, CANBARGAIN, HASOXYGEN},
        0, 0,
        50,
        {10,    20000,  18, 2,  HPT("9d8"), "1d4/1d4/3d8"}
},
{"fire giant",
        50, TRUE,   TRUE,   'f',    "6-10",
        {ISMEAN, CARRYGOLD, NOFIRE, ISLARGE},
        0, 0,
        45,
        {27,    26000,  15, 3,  HPT("11d8+5"), "5d6"}
},
{"cloud giant",
        30, TRUE,   TRUE,   'c',    "8-14",
        {ISMEAN,  NOBOLT, CANBBOLT, CANBARGAIN, ISLARGE, MEDFRIENDLY},
        0, 0,
        45,
        {30,    27000,  15, 2,  HPT("12d8+8"), "6d6"}
},
{"aerial servant",
        0,  TRUE,   TRUE,   'a',    "3-5",
        {ISMEAN, BMAGICHIT, ISSHADOW, LOWFRIENDLY},
        0, 0,
        50,
        {22,    29000,  10, 3,  HPT("16d8"), "4d8"}
},
{"storm giant",
        50, TRUE,   TRUE,   's',    "8-10",
        {ISMEAN,  NOBOLT, CANBBOLT, CANCAST, CANBARGAIN, ISLARGE, MEDFRIENDLY},
        0, 0,
        50,
        {30,    30000,  15, 1,  HPT("15d8+8"), "7d6"}
},
{"valkyrie",
        0,  TRUE,   FALSE,  'v',    "14-16",
        {CANFLY, CANSHOOT, CANWIELD, CANFRIGHTEN, MAGICHIT, ISFLOCK, CANSUMMON},
        "greater god (Odin, All Father)", 1,
        50,
        {21,    27000,  25, -2, HPT("0d8+100"), "3d6+3"}
},
{"evil sorceress",
        95, TRUE,   TRUE,   'z',    "17-19",
        {ISMEAN, STEALGOLD, STEALMAGIC, ISREGEN, CARRYGOLD, ISSCAVENGE, CANSUMMON, CANCAST, CANBARGAIN},
        "nymph", 4,
        60,
        {10,    42000L, 25, -10,    HPT("10d8+50"), "3d8"}
},
{"evil sorcerer",
        95, TRUE,   TRUE,   'Z',    "17-19",
        {ISMEAN, ISREGEN, CARRYGOLD, ISSCAVENGE, CANSUMMON, CANCAST, CANBARGAIN, STEALGOLD, STEALMAGIC},
        "evil sorceress", 1,
        40,
        {10,    44000L, 25, -10,    HPT("10d9+50"), "3d10"}
},
{"time elemental",  /* Dragon #69  - a recursive monster... */
        50, TRUE,   TRUE,   'T',    "10-30",
        {ISMEAN, BMAGICHIT, ISFAST, CANBSLGAS, ISSMALL, HALFDAMAGE, NOBOLT, NOFIRE, NOCOLD, NOSHARP, NOMETAL, HASOXYGEN},
        "time elemental", 2,
        100,
        {10,    62000L, 21, 2,  HPT("15d8"), "4d8"}
},
{"demon prince (Jubilex)",
        100,    TRUE,   FALSE,  'J',    "17-18",
        {ISMEAN, ISUNIQUE, ISREGEN, ISSHADOW, CANHOLD, CANDISEASE, CANSUMMON, ISGOD},
        "black pudding", 3,
        0,
        {10,    47280L, 20, -7, HPT("0d8+88"), "4d10"}
},
{"demon prince (Yeenoghu)",
        100,    TRUE,   FALSE,  'Y',    "15-16",
        {ISMEAN, ISREGEN, ISUNIQUE, ISSHADOW, CANHOLD, CANPARALYZE, CANSUMMON, ISGOD},
        "ghoul", 10,
        0,
        {10,    54500L, 23, -5, HPT("0d8+100"), "3d6/3d6"}
},
{"demon prince (Orcus)",
        100,    TRUE,   FALSE,  'O',    "19-20",
        {ISMEAN, ISUNIQUE, CANPOISON, CANBBOLT, CANSUMMON, ISGOD},
        "vampire", 4,
        0,
        {13,    63900L, 27, -6, HPT("0d8+120"), "1d10+3/2d4"}
},
{"demi-god (Zagyg the Unpredictable)",  /* Dragon #70 */
        100,    TRUE,   TRUE,   'Z',    "23",
        {ISUNIQUE, CANBRANDOM, CANSUMMON, CANWIELD, HIGHFRIENDLY, ISGOD},
        "greater god (Boccob)", 1,
        110,
        {23,    59000L, 26, -2,     HPT("0d8+121"), "4d8"}
},
{"demi-god (Wastri, the Hopping Prophet)",  /* Dragon # 71 */
        100,    TRUE,   TRUE,   'W',    "10",
        {ISUNIQUE, CANSWIM, CANSUMMON, CANPOISON, CANWIELD, LOWFRIENDLY, ISGOD},
        "giant toad", 4,
        100,
        {18,    61000L, 20, -3,     HPT("0d8+121"), "2d6/1d6/3d8"}
},
{"chromatic dragon (Tiamat)",
        100,    TRUE,   FALSE,  'T',    "17-18",
        {ISMEAN, ISUNIQUE, CANBFIRE, CANBACID, CANBBOLT, CANBICE, CANBGAS, ISGREED, CANSUMMON, ISGOD, HASOXYGEN},
        "adult dragon", 5,
        0,
        {10,    63580L, 29, 0,  HPT("0d8+128"), "2d8/3d6/2d10/3d8/3d10/1d6"}
},
{"arch devil (Geryon)",
        100,    TRUE,   FALSE,  'g',    "15-16",
        {ISMEAN, ISUNIQUE, ISSHADOW, CANHUH, CANPOISON, CANSUMMON, ISGOD},
        "ice devil", 2,
        0,
        {13,    61500L, 30, -3, HPT("0d8+133"), "3d6/3d6/2d4"}
},
{"lesser god (Ralishaz the Unlooked For)",  /* Dragon # 71 */
        100,    TRUE,   TRUE,   'R',    "20",
        {ISUNIQUE, CANSNORE, CANWIELD, ISFAST, LOWFRIENDLY, ISGOD},
        0, 0,
        100,
        {18,    65000L, 22, -6,     HPT("5d10+140"), "1d20/1d20/1d20/1d20"}
},
{"lesser god (Obad-hai the Shalm)",  /* Dragon #69 */
        100,    TRUE,   TRUE,   'O',    "17",
        {ISUNIQUE, ISREGEN, CANSUMMON, LOWFRIENDLY, ISGOD},
        "centaur", 10,
        100,
        {18,    62000L, 18, -2,     HPT("0d8+144"), "4d8"}
},
{"arch devil (Dispater)",
        100,    TRUE,   FALSE,  'd',    "17-18",
        {ISMEAN, ISUNIQUE, CANHUH, CANSUMMON, ISGOD},
        "pit fiend", 2,
        0,
        {10,    48040L, 36, -2, HPT("0d8+144"), "4d6"}
},
{"lesser god (Trithereon the Summoner)",
        100,    TRUE,   TRUE,   'T',    "18",
        {ISUNIQUE, CANWIELD, CANSUMMON, ISFRIENDLY, ISGOD},
        "hound (Nemoud, Servant of Trithereon)", 1,
        0,
        {19,    55000L, 35, -4, HPT("0d8+163"), "1d8+12"}
},
{"demi-god (Iuz the Old)",  /* Dragon #67 - enemy of St Cuthbert */
        100,    TRUE,   TRUE,   'I',    "18",
        {ISMEAN, CANHUH, CANBPGAS, ISUNIQUE, CANSUMMON, ISGOD, HASOXYGEN},
        "shade", 2,
        0,
        {21,    55000L, 35, -8, HPT("0d8+165"), "1d8+12"}
},
{"arch devil (Baalzebul)",
        100,    TRUE,   FALSE,  'B',    "17-18",
        {ISMEAN, ISSHADOW, ISUNIQUE, CANHOLD, CANPOISON, CANHUH, CANSUMMON, ISGOD},
        "horned devil", 4,
        0,
        {10,    61410L, 37, -5, HPT("0d8+166"), "2d6"}
},
{"platinum dragon (Bahamut)",
        100,    TRUE,   FALSE,  'B',    "19-20",
        {ISUNIQUE, CANBICE, CANBGAS, CANBBOLT, ISGREED, CANSUMMON, ISFRIENDLY, ISGOD, HASOXYGEN},
        "ancient gold dragon", 7,
        0,
        {10,    58080L, 38, -3, HPT("0d8+168"), "2d6/2d6/6d8"}
},
{"lesser goddess (Xan Yae, Lady of Perfection)",    /* Dragon #68 */
        100,    TRUE,   FALSE,  'X',    "19",
        {CANSHOOT, ISUNIQUE, ISGOD, LOWFRIENDLY},
        0, 0,
        0,
        {22,    55000L, 35, -4, HPT("0d8+172"), "6d6"}
},
{"lesser goddess (Ehlonna of the Forests)",     /* Dragon #68 */
        100,    TRUE,   FALSE,  'E',    "19",
        {CANHUH, CANSHOOT, ISUNIQUE, CANSUMMON, ISGOD, HIGHFRIENDLY},
        "noldor elf", 30,
        0,
        {22,    65000L, 35, -6, HPT("0d8+180"), "3d6+6/1d10"}
},
{"lesser god (Pholtus of the Blinding Light)",  /* Dragon #68 */
        100,    TRUE,   FALSE,  'P',    "19",
        {HASFIRE, CANBLIND, CANSHOOT, ISUNIQUE, CANWIELD, CANSUMMON, ISGOD, ISFRIENDLY},
        "phoenix", 2,
        0,
        {22,    65000L, 35, -6, HPT("0d8+180"), "3d6+6/1d10"}
},
{"demi-god (Vaprak \"The Destroyer\")",
        0,  TRUE,   TRUE,   'v',    "18",
        {ISMEAN, ISUNIQUE, ISREGEN, CANSUMMON, ISGOD},
        "troll", 5,
        0,
        {16,    56000L, 26, 0,  HPT("0d8+198"), "2d10/2d10/1d12"}
},
{"lesser god (Olidammara the Laughing Rogue)",  /* Dragon #70 */
        100,    TRUE,   TRUE,   'O',    "18",
        {ISUNIQUE, CANINWALL, CANSUMMON, ISGOD, LOWFRIENDLY},
        "halfling", 10,
        110,
        {21,    59000L, 30, -9,     HPT("0d8+199"), "4d8"}
},
{"devil Asmodeus",
        100,    TRUE,   FALSE,  'A',    "19-20",
        {ISMEAN, ISUNIQUE, ISSHADOW, CANHOLD, CANHUH, CANCHILL, CANSUMMON, ISGOD},
        "pit fiend", 3,
        0,
        {10,    80965L, 45, -7, HPT("0d8+199"), "4d10/4d10"}
},
{"valar (Yavanna, Giver of Fruits)",
        100,    TRUE,   FALSE,  'Y',    "20",
        {ISUNIQUE, CANSUMMON, ISGOD, ISFRIENDLY},
        "entwife", 10,
        0,
        {15,    64000L, 45, -8, HPT("0d8+200"), "1d8+4"}
},
{"valar (Varda, Elbereth Gilthoniel)",
        100,    TRUE,   FALSE,  'V',    "30",
        {ISUNIQUE, HASFIRE, CANSUMMON, ISGOD, ISFRIENDLY},
        "noldor elf", 20,
        0,
        {15,    64000L, 45, -8, HPT("0d8+200"), "1d8+4"}
},
{"lesser god (Hextor, Champion of Evil)",
        100,    TRUE,   FALSE,  'H',    "18",
        {ISMEAN, CANHUH, ISUNIQUE, CANWIELD, CANSUMMON, ISGOD},
        "zombie", 5,
        0,
        {25,    64000L, 45, -8, HPT("0d8+200"), "2d6/2d6"}
},
{"demon prince (Demogorgon)",
        100,    TRUE,   FALSE,  'D',    "19-20",
        {ISMEAN, CANHUH, DOUBLEDRAIN, CANINFEST, ISUNIQUE, CANSUMMON, ISGOD},
        "glabrezu", 3,
        0,
        {10,    74000L, 45, -8, HPT("0d8+200"), "1d6/1d6"}
},
{"lesser god (Heironeous the Invincible)",  /* Dragon #67 - enemy of Hextor */
        100,    TRUE,   FALSE,  'H',    "18",
        {CANHUH, ISUNIQUE, CANWIELD, CANSUMMON, NOBOLT, CANBBOLT, ISGOD, ISFRIENDLY},
        "ki-rin", 2,
        0,
        {21,    64000L, 45, -9, HPT("0d8+217"), "1d4+8/1d4+8"}
},
{"lesser god (Kurtulmak)",
        50, TRUE,   TRUE,   'K',    "19",
        {ISMEAN, CANPOISON, ISUNIQUE, ISGOD},
        0, 0,
        0,
        {16,    55000L, 27, 0,  HPT("0d8+219"), "2d12/1d6"}
},
{"lesser god (Hruggek)",
        50, TRUE,   FALSE,  'H',    "17",
        {ISMEAN, ISUNIQUE, CANSUMMON, ISGOD},
        "bugbear", 9,
        0,
        {13,    55000L, 25, 0,  HPT("0d8+221"), "2d8/2d8"}
},
{"lesser god (St Cuthbert of the Cudgel)",  /* Dragon #67 */
        100,    TRUE,   FALSE,  'C',    "10",
        {CANHUH, ISUNIQUE, CANWIELD, CANSUMMON, ISGOD, ISFRIENDLY},
        "lammasu", 2,
        0,
        {20,    65000L, 45, -8, HPT("0d8+224"), "2d6+5/1d10+5"}
},
{"lesser god (Celestian the Far Wanderer)",     /* Dragon #68 */
        100,    TRUE,   FALSE,  'c',    "20",
        {CANHUH, CANSHOOT, CANBFIRE, CANBBOLT, CANBICE, ISUNIQUE, CANSUMMON, ISGOD, ISFRIENDLY},
        "air squid", 2,
        0,
        {23,    65000L, 45, -5, HPT("0d8+242"), "1d6+20"}
},
{"lesser god (Raxivort, Night Flutterer)",
        100,    TRUE,   TRUE,   'R',    "18",
        {CANSHOOT, ISUNIQUE, CANBACID, CANWIELD, CANSUMMON, LOWFRIENDLY, ISGOD},
        "xvart", 50,
        0,
        {18,    65000L, 45, -1, HPT("0d8+246"), "3d6+6"}
},
{"lesser god (Fharlanghn, Dweller on the Horizon)", /* Dragon #68 - brother to Celestian */
        100,    TRUE,   FALSE,  'f',    "18",
        {CANHUH, CANBLINK, HASFIRE, ISUNIQUE, CANWIELD, CANSUMMON, ISGOD, ISFRIENDLY},
        "earth elemental", 1,
        0,
        {18,    65000L, 45, -6, HPT("0d8+262"), "3d6+6"}
},
{"lesser god (Nyarlathotep)",
        50, TRUE,   FALSE,  'N',    "25",
        {ISMEAN, ISUNIQUE, ISGOD},
        "kodiac bear", 9,
        0,
        {15,    49000L, 25, -5, HPT("0d8+284"), "2d8/2d8"}
},
{"lesser god (Erythnul the Many)",  /* Dragon # 71 */
        100,    TRUE,   TRUE,   'E',    "16",
        {ISMEAN, ISUNIQUE, CANSUMMON, ISGOD},
        "troll", 4,
        100,
        {22,    62000L, 45, -3,     HPT("0d8+320"), "4d6+10"}
},
{"greater goddess (Ulaa, Mistress of the Mountains)",
        100,    TRUE,   FALSE,  'U',    "18",
        {ISUNIQUE, CANSUMMON, CANWIELD, ISREGEN, ISGOD, HIGHFRIENDLY},
        "kazad dwarf", 15,
        110,
        {24,    85000L, 45, -7,     HPT("0d8+321"), "4d8"}
},
{"greater god (Maglubiyet)",
        0,  TRUE,   FALSE,  'M',    "19",
        {ISMEAN, ISUNIQUE, ISGOD},
        0, 0,
        0,
        {10,    80000L, 45, -1, HPT("0d8+350"), "4d10"}
},
{"greater god (Gruumsh)",
        100,    TRUE,   FALSE,  'G',    "19",
        {ISMEAN, ISUNIQUE, ISGOD},
        0, 0,
        0,
        {22,    82000L, 45, -1, HPT("0d8+350"), "4d10"}
},
{"greater god (Boccob the Uncaring)",
        100,    TRUE,   FALSE,  'B',    "26",
        {ISUNIQUE, CANWIELD, ISGOD, LOWFRIENDLY},
        0, 0,
        0,
        {18,    95000L, 45, -8, HPT("0d8+354"), "4d10"}
},
{"greater goddess (Istus, Lady of Fate)",  /* Dragon #69 */
        100,    TRUE,   FALSE,  'I',    "23",
        {ISUNIQUE, CANSUMMON, CANWIELD, CANHOLD, ISGOD, LOWFRIENDLY},
        "time elemental", 3,
        110,
        {15,    88000L, 45, -8,     HPT("0d8+377"), "4d8"}
},
{"lesser god (Skoraeus Stonebones)",
        0,  TRUE,   FALSE,  'S',    "19",
        {ISUNIQUE, ISREGEN, ISGOD, LOWFRIENDLY},
        0, 0,
        0,
        {10,    85000L, 45, -1, HPT("0d8+380"), "6d10"}
},
{"greater god (Incabulos, God of Evil Sendings)",  /* Dragon # 71 */
        100,    TRUE,   TRUE,   'I',    "20",
        {ISMEAN, ISUNIQUE, CANSUMMON, CANWIELD, CANSNORE, ISGOD},
        "night hag", 4,
        100,
        {18,    92000L, 25, -9,     HPT("0d8+383"), "5d6"}
},
{"greater god (Nerull the Grim Reaper)",  /* Dragon # 71 */
        100,    TRUE,   TRUE,   'N',    "21",
        {ISMEAN, ISUNIQUE, CANBACID, CANSUMMON, ISGOD},
        "shaggy demodand (shator)", 2,
        100,
        {14,    92000L, 30, -6,     HPT("0d8+400"), "10d6"}
},
{"greater god (Odin, All Father)",
        100,    TRUE,   TRUE,   'O',    "25",
        {ISUNIQUE, CANSUMMON, CANWIELD, ISGOD, LOWFRIENDLY},
        "valkyrie", 50,
        100,
        {25,    105000L,    30, -6,     HPT("0d8+400"), "5d8"}
},
{"valar (Orome, Lord of Forests)",
        100,    TRUE,   FALSE,  'o',    "36",
        {ISUNIQUE, CANSUMMON, ISGOD, LOWFRIENDLY},
        "elephant", 10,
        0,
        {18,    95000L, 45, -5, HPT("0d8+460"), "4d8+10"}
},
{"valar (Aule, Lord of Smithing)",
        100,    TRUE,   FALSE,  'A',    "36",
        {ISUNIQUE, CANSUMMON, ISGOD, LOWFRIENDLY},
        "kazad dwarf", 15,
        0,
        {20,    95000L, 45, -5, HPT("0d8+460"), "4d8+10"}
},
{"valar (Ulmo, God of Waters)",
        100,    TRUE,   FALSE,  'U',    "36",
        {ISUNIQUE, CANSUMMON, CANWIELD, ISGOD, LOWFRIENDLY},
        "giant crocodile", 15,
        0,
        {18,    95000L, 45, -5, HPT("0d8+460"), "4d8+10"}
},
{"valar (Melkor, the Dark Lord)",
        100,    TRUE,   FALSE,  'M',    "36",
        {ISMEAN, ISUNIQUE, CANHUH, CANSUMMON, ISGOD},
        "maiar (Balrog)", 15,
        0,
        {18,    95000L, 45, -10,    HPT("0d8+460"), "4d8+10"}
},
{"valar (Manwe, Lord of Arda)",
        100,    TRUE,   FALSE,  'M',    "36",
        {ISUNIQUE, CANSUMMON, CANWIELD, ISGOD, LOWFRIENDLY},
        "aerial servant", 15,
        0,
        {18,    95000L, 45, -10,    HPT("0d8+460"), "4d8+10"}
},
{"valar (Tulkas the Valiant)",
        100,    TRUE,   FALSE,  'T',    "36",
        {ISUNIQUE, CANSUMMON, ISGOD, LOWFRIENDLY},
        "noone, haste anyway", 1,
        0,
        {28,    145000L,    65, -15,    HPT("0d8+800"), "10d4/4d10"}
},
{"quartermaster",
        0, FALSE, TRUE, 'q', "18-20",
        {CANSELL},
        0, 0,
        2,
        {12,    20, 100,    -11,    HPT("1d8+1"), "1d10"}
},
{"Lord of All Darkness (Lucifer)",
        100, TRUE, TRUE, 'L', "40-60",
        {ISMEAN, ISUNIQUE, CANSUMMON, ISGOD},
        "evil sorcerer", 15,
        225,
        {45,    1465000L,   100,    -13,    HPT("18d60+700"), "3d8/3d8/3d8"}}
};

int nummonst = NUMMONST;
