'| Program name:    Ani-Life
'| Version     :    1.0
'| Purpose     :    An animated version of the Life simulation
'| Updated     :    December 8, 1996

'----------------------------------------------------------------------------

'| Define common variables and subroutines

COMMON SHARED MouseButton AS INTEGER, MouseX AS INTEGER, MouseY AS INTEGER
DECLARE SUB Dead ()
DECLARE SUB Life ()
DECLARE SUB MoveEm ()
DECLARE SUB Mouse (Status%)
DECLARE SUB PingMouse ()
DECLARE SUB FillCells ()
DECLARE SUB PutSprite (X%, Y%)
DECLARE SUB CheckCell (CellX%, CellY%)
DECLARE SUB LoadSprites ()
'$INCLUDE: 'QB.BI'
	DEFINT A-Z
   
	DIM SHARED Inregs AS RegType, Outregs AS RegType        'Interrupt
	DIM SHARED Regs AS RegTypeX                             'InterruptX
   
	CONST Target = 41       '| Change this to a higher or lower number to
							'| increase or decrease the amount of animation

	SCREEN 12

	Mouse 0                 '| Initialize the mouse
   
	TreeSize = 404          '| Set the size of the sprite being used.

	DIM SHARED Tree1(1 TO TreeSize) '| Dimension arrays to hold the five
	DIM SHARED Tree2(1 TO TreeSize) '| different sprites.
	DIM SHARED Tree3(1 TO TreeSize)
	DIM SHARED Tree4(1 TO TreeSize)
	DIM SHARED Tree5(1 TO TreeSize)

	DIM SHARED World(26, 18), Growth(26, 18)    '| Dimension the arrays used
												'| to keep track of the
												'| exisiting generation, and
												'| any deaths and births.
   
	RANDOMIZE TIMER '| Seed the random number generator
	 
	Generation = 1

	LoadSprites     '| Load the sprites into their arrays
   
	FillCells       '| Let the user create an initial life pattern
   
	CLS

	FOR Y = 1 TO 17                         '| Draw the initial life
		FOR X = 1 TO 25                     '| pattern on the screen.
			IF World(X, Y) = -1 THEN        '|
				Sx = (X - 1) * 25           '|
				Sy = (Y - 1) * 25           '|
				PutSprite Sx, Sy            '|
				Population = Population + 1 '|
			END IF                          '|
		NEXT X                              '|
	NEXT Y                                  '|
   
   
	'| Display the inital generation information

	LINE (0, 455)-(640, 455), 1
	LOCATE 30, 1, 0
	COLOR 15
	PRINT USING "Generation #####: Population ###"; Generation; Population;

	'| Loop until the user presses the "E" key

	DO UNTIL G$ = "E"
	   
		MoveEm    '| Animate the life forms on screen


		FOR CellY = 1 TO 17             '| Check each cell to see if it
			FOR CellX = 1 TO 25         '| has enough neighbors to stay
				CheckCell CellX, CellY  '| alive or to have a new life form
			NEXT CellX                  '| born.
		NEXT CellY                      '|
			   
		Dead                            '| Erase the dead life forms
		Life                            '| Show the births

		G$ = INKEY$                     '| Check to see if the user has
		G$ = UCASE$(G$)                 '| pressed a key.
		IF G$ = "R" THEN RUN            '| if it's the 'R' key run the
										'| program again
	   
	LOOP
	'| The user pressed the 'E' key, so exit the program
	CLS
'----------------------------------------------------------------------------
' Notes:

' A population is considered stable when the number of life forms does not
' change over several generations.

' If there are no life forms on the screen, then the population has died.

'----------------------------------------------------------------------------
' Patterns to try:

' Drifter:  ***  This is a stable population that will drift across the
'             *  screen.
'            * 

' Blinker: ***   This is a stable population that will appear to blink.

' Line   : ***** A straight line of five or more life forms.

' Box    : ***** Try to use an odd number of rows, and an old number of
'          ***** life forms per row.
'          *****

SUB CheckCell (CellX, CellY)
   
'| Check all the cells around the current cell, to see if there is a life 
'| form there. Start with the cell directly above, and to the left, and end
'| with the cell directly below and to the right. A -1 in the cell indicates
'| a life form is present.

	FOR Y = CellY - 1 TO CellY + 1
		FOR X = CellX - 1 TO CellX + 1
			Test = (CellX = X) AND (CellY = Y)
		   
			'| Be sure to skip the current cell         

			IF NOT (Test) AND (World(X, Y) = -1) THEN Neighbor = Neighbor + 1
		NEXT X
	NEXT Y

	Live = World(CellX, CellY)          '| -1 if there is a live form in the
										'| current cell
   
	Birth = (Live = 0) AND (Neighbor = 3)   '| If there is no current life
											'| form and there are exactly
											'| three neighbors, then Birth
											'| = -1

	'| If there is a life form in the current cell, and less than 2, or more
	'| than 3 neighbors, then Death = -1

	Death = ((Live = -1) AND ((Neighbor < 2) OR Neighbor > 3))
   
	IF Birth THEN                   '| If Birth is -1 then put a 2 in the
		Growth(CellX, CellY) = 2    '| Growth array.
	END IF

	IF Death THEN                   '| If Death is a -1 then put a 3 in the
		Growth(CellX, CellY) = 3    '| Growth array.
	END IF
	  
END SUB

SUB Dead

	'| Find all the dead life forms, and erase them by drawing a black box
	'| at their screen coordinates.  Screen coordinates are calculated by
	'| taking the array X and Y values, subtracting one, and multiplying by
	'| the width and height of the sprite.  The sprites used in this program
	'| are 25 X 25 pixels.

		FOR CellY = 1 TO 17
			FOR CellX = 1 TO 25
				IF Growth(CellX, CellY) = 3 THEN
					World(CellX, CellY) = 0
					Sx = (CellX - 1) * 25: Sy = (CellY - 1) * 25
					LINE (Sx, Sy)-(Sx + 25, Sy + 25), 0, BF
				END IF
			NEXT CellX
		NEXT CellY
END SUB

SUB FillCells
	CLS
   
	'| Draw a 25 X 17 gird. Each square of the grid is 25 X 25 pixels.

	FOR X = 0 TO 624 STEP 25
		FOR Y = 0 TO 424 STEP 25
			LINE (X, Y)-(X + 25, Y + 25), 8, B
		NEXT Y
	NEXT X
   
	LINE (0, 455)-(640, 455), 1

	'| Turn on the mouse cursor, and get the mouse X,Y coordinates, and the
	'| status of any buttons.

	Mouse 1
	Mouse 3

	'| Loop until the right mouse button is clicked.

	DO WHILE MouseButton <> 2

		Mouse 3     '| Check the X,Y coordinates and button status.

		'| Convert the mouse coordinates into an X value of 1 to 25, and
		'| a Y value of 1 to 17. The values are calculated by doing an
		'| integer divide on the coordinates, and adding one.

		X = (MouseX \ 25) + 1: Y = (MouseY \ 25) + 1

		'| Calculate the graphic coordinates of the upper left hand corner
		'| of the grid square being pointed at.

		Sx = (X - 1) * 25: Sy = (Y - 1) * 25
	   
		COLOR 15
		LOCATE 30, 1, 0
		PRINT USING "Cell ## : ##"; X; Y;
		COLOR 7
		PRINT "       ["; : COLOR 10: PRINT "L";
		COLOR 7: PRINT "]eft click to place or remove   [";
		COLOR 12: PRINT "R"; : COLOR 7: PRINT "]ight click to start Life";

		'| Test = -1 if the mouse is inside the grid

		Test = (X > 0) AND (X < 26) AND (Y > 0) AND (Y < 18)
	   
		'| If the left mouse button has been pressed, and the mouse is
		'| inside the grid, then place or erase a life form.
	   
		IF (MouseButton = 1) AND (Test = -1) THEN

			'| Turn off the mouse cursor before drawing on the screen,
			'| so it doesn't leave behind any nasty mouse droppings.

			Mouse 2

			SELECT CASE World(X, Y)
				CASE -1
					World(X, Y) = 0
					LINE (Sx, Sy)-(Sx + 25, Sy + 25), 0, BF
					LINE (Sx, Sy)-(Sx + 25, Sy + 25), 8, B

					'| Wait for the left mouse button to be released

					PingMouse

				CASE 0
					PutSprite Sx, Sy
					World(X, Y) = -1
					PingMouse
			END SELECT

			'| Turn the mouse cursor back on and continue to loop until
			'| the right mouse button is clicked.

			Mouse 1

	   END IF
	LOOP

	'| The right mouse button has been clicked, so turn the mouse cursor
	'| off, and return to the main program.

	Mouse 2
END SUB

SUB Life
		STATIC Generation           '| Define Generation as static, so
									'| the routine doesn't reset it to
									'| zero each time it's called.

'| Go through the Growth array looking for 2.  If the element contains a
'| 2 then a new life form is placed on the screen.  The graphics coordinates
'| for the life form are calculated by subtracting 1 from CellX/CellY, and
'| then multiplying by the width and heigth of the sprite.

		FOR CellY = 1 TO 17
			FOR CellX = 1 TO 25
				IF Growth(CellX, CellY) = 2 THEN
					World(CellX, CellY) = -1
					Sx = (CellX - 1) * 25: Sy = (CellY - 1) * 25
					PutSprite Sx, Sy
				END IF
			   
				'| Count how many life forms are in this generation

				IF World(CellX, CellY) = -1 THEN Population = Population + 1

			NEXT CellX
		NEXT CellY
	   
		'| Increment the Generation counter.      

		Generation = Generation + 1

		LOCATE 30, 1, 0
		COLOR 15
		PRINT USING "Generation #####: Population ###"; Generation; Population;
		COLOR 7
		PRINT "          [";
		COLOR 10
		PRINT "R"; : COLOR 7: PRINT "]un another pattern  [";
		COLOR 12: PRINT "E"; : COLOR 7: PRINT "]xit program.";
END SUB

SUB LoadSprites
   
	'| Bload the sprites to be used in the program.
	'| See the QuickBasic 4.5 help file for details on using BLOAD
   
	DEF SEG = VARSEG(Tree1(1))
		BLOAD "Tree1.Icn", VARPTR(Tree1(1))
	DEF SEG

	DEF SEG = VARSEG(Tree2(1))
		BLOAD "Tree2.Icn", VARPTR(Tree2(1))
	DEF SEG

	DEF SEG = VARSEG(Tree3(1))
		BLOAD "Tree3.Icn", VARPTR(Tree3(1))
	DEF SEG

	DEF SEG = VARSEG(Tree4(1))
		BLOAD "Tree4.Icn", VARPTR(Tree4(1))
	DEF SEG

	DEF SEG = VARSEG(Tree5(1))
		BLOAD "Tree5.Icn", VARPTR(Tree5(1))
	DEF SEG

END SUB

SUB Mouse (Status)

'| Purpose:   Mouse functions.

'| 0 = Initialize Mouse - This must be done before the mouse can be used.
'| 1 = Show Mouse
'| 2 = Hide Mouse
'| 3 = Mouse information - Will return the mouse X,Y coordinates, and the
'|                         status of any buttons.

Inregs.ax = Status
CALL INTERRUPT(&H33, Inregs, Outregs)
MouseButton = Outregs.bx                '| button 0 = no buttons clicked
										'| 1 = left button clicked
										'| 2 = right button clicked

MouseX = Outregs.cx                     '| x coordinate
MouseY = Outregs.dx                     '| y coordinate
MouseInit = Outregs.ax                  '| init (dummy variable)

END SUB

SUB MoveEm
	  
'| This routine will randomly animate any of the life forms on the screen.
'| You can change the chance the particular life form will be animated by
'| changing the Target variable to a higher or lower number.

		FOR Move = 1 TO 25
			FOR CellX = 1 TO 25
				FOR CellY = 1 TO 17
				   
					R = INT(RND * 200) + 1      '| Pick a number from 1 to
												'| 200.
					IF R < Target THEN          '| If it's below Target then
												'| animate the lifeform
										   
						X = (CellX - 1) * 25    '| Calculate the graphic
												'| coordinates
						Y = (CellY - 1) * 25    '| .

						IF World(CellX, CellY) = -1 THEN    '| Make sure
							PutSprite X, Y                  '| there's a
						END IF                              '| life there.
					END IF
				NEXT CellY
			NEXT CellX
		NEXT Move
END SUB

SUB PingMouse
   
'| Purpose:   Test to see if the mouse button that has been pressed, has
'|            been released.
	Mouse 3
	DO WHILE MouseButton > 0
		Mouse 3
	LOOP
END SUB

SUB PutSprite (X, Y)
		  
'| Put one of the five sprite images at the X,Y graphic coordinates.

	Image = INT(RND * 5) + 1
	SELECT CASE Image
		CASE 1
			PUT (X, Y), Tree1, PSET
		CASE 2
			PUT (X, Y), Tree2, PSET
		CASE 3
			PUT (X, Y), Tree3, PSET
		CASE 4
			PUT (X, Y), Tree4, PSET
		CASE 5
			PUT (X, Y), Tree5, PSET
	END SELECT
END SUB

