DEFINT A-Z

DECLARE SUB Center (x, Text$)
DECLARE SUB ChangeSpeed ()
DECLARE SUB Choose (x, y, Prompt$, Choice$, Choices$)
DECLARE SUB DisplayMenu ()
DECLARE SUB DisplayTitle ()
DECLARE SUB DisplayYouLost ()
DECLARE SUB DisplayYouWon ()
DECLARE SUB DrawBox (x, y, Wdth, Height)
DECLARE SUB DropBlock ()
DECLARE SUB GoToNextLevel ()
DECLARE SUB Main ()
DECLARE SUB MakeNewBlock ()
DECLARE SUB MakeEffect (EffectNr)
DECLARE SUB Menu ()
DECLARE SUB StartNewGame ()
COMMON SHARED DelayStart AS SINGLE, DlyDrtn AS SINGLE
COMMON SHARED BlckClr, BlckX, BlckY, EndOfGame, PlayAgain, PrvLvlScr, Score, SoundOn
ON ERROR GOTO ErrorTrap
DlyDrtn = .5
SoundOn = -1
PLAY "MB L4 T120"
SCREEN 12: WIDTH 80, 30: COLOR 15: CLS
DisplayTitle
CALL Menu

ErrorTrap:
COLOR 7
e = ERR
 IF e = 53 THEN
  Msg$ = "Cannot find Title.dat."
 ELSEIF e = 62 THEN
  Msg$ = "Error reading Title.dat."
 ELSEIF e = 71 THEN
  Msg$ = "No disk in drive."
 ELSE
  Msg$ = "Unexpected error."
 END IF
l = (LEN(Msg$) / 2) * 2
 IF l < 14 THEN l = 14
y = INT(40 - (l / 2))
DrawBox 6, y - 2, l + 2, 2
LOCATE 7, y: PRINT Msg$
LOCATE , y: PRINT "Error Code:" + STR$(ERR)
Center 10, " 1 = Retry   2 = Ignore   3 = Quit  "
 DO
  Key$ = INPUT$(1)
   IF INSTR("123", Key$) THEN LOCATE 6, 1: PRINT SPACE$(400);
   IF Key$ = "1" THEN RESUME
   IF Key$ = "2" THEN RESUME NEXT
   IF Key$ = "3" THEN SCREEN 0: COLOR 7, 0: CLS : SYSTEM
 LOOP

SUB Center (x, Text$)
 IF x > 0 THEN LOCATE x
LOCATE , INT(40 - (LEN(Text$) / 2))
PRINT Text$
END SUB

SUB ChangeSpeed
DrawBox 5, 31, 16, 2
 DO
  LOCATE 6, 33: PRINT USING "Speed: ####"; 100 - (DlyDrtn * 100)
  LOCATE , 33: PRINT "Escape = Back"
  Key$ = INPUT$(1)
   IF Key$ = "+" THEN IF DlyDrtn >= .01 THEN DlyDrtn = DlyDrtn - .01
   IF Key$ = "-" THEN IF DlyDrtn <= .99 THEN DlyDrtn = DlyDrtn + .01
   IF Key$ = CHR$(27) THEN DisplayMenu: EXIT DO
 LOOP
END SUB

SUB Choose (x, y, Prompt$, Choice$, Choices$)
LOCATE x, y: PRINT Prompt$
 DO
  Choice$ = UCASE$(INPUT$(1))
   IF INSTR(Choices$, Choice$) THEN EXIT DO
 LOOP
LOCATE x, y: PRINT SPACE$(LEN(Prompt$))
END SUB

SUB DisplayMenu
CLS : COLOR 7
LINE (0, 0)-(639, 479), 1, BF
LINE (5, 5)-(630, 450), 14, B
LINE (64, 54)-(290, 185), 2, B
PAINT (70, 70), 2
LINE (64, 54)-(290, 185), 14, B
LOCATE 6, 12: PRINT " Start Game   "
LOCATE 8, 12: PRINT " Quit Blocks  "
LOCATE 27, 5: PRINT " F1 = Change Speed "
END SUB

SUB DisplayTitle
COLOR 7
 FOR l = 0 TO 7 STEP 7
  OPEN "Title.dat" FOR INPUT AS 1: CLOSE 1
  OPEN "Title.dat" FOR BINARY AS 1
   IF LOF(1) = 0 THEN CLOSE 1: KILL "Title.dat": EXIT FOR
   DO UNTIL LOC(1) = LOF(1)
    x = (ASC(INPUT$(1, 1)) + 2) * 8
    y = ASC(INPUT$(1, 1)) * 16
    LINE (x + (l - l / 2), y + l - 7)-(x + (l - l / 2) + 8, y + l + 8), , BF
   LOOP
  CLOSE 1
  COLOR 15
 NEXT l

COLOR 3
LOCATE 2, 50: PRINT "By: Peter Swinkels"
LOCATE , 54: PRINT "***1996***"
COLOR 1
LOCATE 10, 18: PRINT "Press any key to continue..."
Key$ = INPUT$(1)
END SUB

SUB DisplayYouLost
MakeEffect 5
PlayAgain = -1
DrawBox 5, 25, 28, 1
Choose 6, 27, "You lost! Play again Y/N?", Choice$, "YN"
 IF Choice$ = "Y" THEN StartNewGame: EXIT SUB
 IF Choice$ = "N" THEN PlayAgain = 0: EXIT SUB
END SUB

SUB DisplayYouWon
MakeEffect 6
PlayAgain = -1
DrawBox 5, 26, 26, 1
Choose 6, 28, "You won! Play again Y/N?", Choice$, "YN"
 IF Choice$ = "Y" THEN StartNewGame: EXIT SUB
 IF Choice$ = "N" THEN PlayAgain = 0: EXIT SUB
END SUB

SUB DrawBox (x, y, Wdth, Height)
LOCATE x, y: PRINT ""; STRING$(Wdth, ""); ""
 FOR BoxRow = 1 TO Height
  LOCATE , y: PRINT ""; SPC(Wdth); ""
 NEXT BoxRow
LOCATE , y: PRINT ""; STRING$(Wdth, ""); ""
END SUB

SUB DropBlock
 FOR Column = 60 TO 320 STEP 20
  IF POINT(Column, 51) > 0 AND POINT(Column, 81) > 0 THEN
   EndOfGame = -1
   DisplayYouLost
  END IF
 NEXT Column
 IF TIMER >= DelayStart + DlyDrtn THEN
   IF BlckY = 330 OR NOT POINT(BlckX + 1, BlckY + 21) = 0 THEN
    MakeEffect 1
    MakeNewBlock
   ELSE
    LINE (BlckX, BlckY)-(BlckX + 19, BlckY + 19), 0, BF
    BlckY = BlckY + 20
    LINE (BlckX, BlckY)-(BlckX + 19, BlckY + 19), BlckClr, BF
   END IF
  DelayStart = TIMER
 ELSE
  IF TIMER < 3 THEN DelayStart = TIMER
 END IF
END SUB

SUB GoToNextLevel
MakeEffect 4
PrvLvlScr = Score
Score = Score + 20
DlyDrtn = DlyDrtn - .01
 IF DlyDrtn <= 0 THEN
  EndOfGame = -1
  DisplayYouWon
 END IF
END SUB

SUB Main
StartNewGame
 DO
   DO
    DropBlock
     IF EndOfGame AND NOT PlayAgain THEN EXIT SUB
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  LINE (BlckX, BlckY)-(BlckX + 19, BlckY + 19), 0, BF
  SELECT CASE Key$
   CASE CHR$(0) + "K"
    IF BlckX > 79 AND POINT(BlckX - 20, BlckY) = 0 THEN BlckX = BlckX - 20
   CASE CHR$(0) + "M"
    IF BlckX < 301 AND POINT(BlckX + 20, BlckY) = 0 THEN BlckX = BlckX + 20
   CASE CHR$(0) + ";"
    SoundOn = NOT SoundOn
   CASE " "
    MakeEffect 3
   CASE CHR$(27)
    EXIT SUB
  END SELECT
  LINE (BlckX, BlckY)-(BlckX + 19, BlckY + 19), BlckClr, BF
 LOOP
END SUB

SUB MakeEffect (EffectNr)
DIM Speed AS DOUBLE
 IF NOT SoundOn AND NOT EffectNr = 3 THEN EXIT SUB
 IF EffectNr = 1 THEN
  PLAY "L32 N1 N5"
 ELSEIF EffectNr = 2 THEN
  PLAY "L32 N10 N14"
 ELSEIF EffectNr = 3 THEN
   IF BlckY = 330 OR NOT POINT(BlckX + 1, BlckY + 30) = 0 THEN EXIT SUB
  Speed = 5
   FOR Frequency = 37 TO 337 STEP Speed
     IF SoundOn THEN SOUND Frequency, .04 ELSE SOUND 0, .04
    LINE (BlckX, BlckY)-(BlckX + 19, BlckY + 19), 0, BF
     IF BlckY + 5 >= 330 OR NOT POINT(BlckX + 1, BlckY + 30) = 0 THEN
      BlckY = (((BlckY - 30) \ 20) * 20) + 30
      EXIT FOR
     ELSE
      BlckY = BlckY + 5
     END IF
    LINE (BlckX, BlckY)-(BlckX + 19, BlckY + 19), BlckClr, BF
    Speed = Speed * 1.5
   NEXT Frequency
 ELSEIF EffectNr = 4 THEN
  FOR Repeat = 1 TO 3
   Speed = 30
    FOR Frequency = 37 TO 1737 STEP Speed
     SOUND Frequency, .04
     Speed = Speed * 1.5
    NEXT Frequency
  NEXT Repeat
 ELSEIF EffectNr = 5 THEN
  FOR Repeat = 1 TO 50
   SOUND (RND * 150) + 50, .1
  NEXT Repeat
  FOR Frequency = 100 TO 37 STEP -1
   SOUND Frequency, .15
  NEXT Frequency
 ELSEIF EffectNr = 6 THEN
  PLAY "L32"
   FOR Tone = 10 TO 20
    PLAY "N" + STR$(Tone)
    PLAY "N" + STR$(Tone + 4)
   NEXT Tone
 END IF
END SUB

SUB MakeNewBlock
 IF POINT(BlckX + 1, BlckY + 21) = BlckClr THEN
  MakeEffect 2
  LINE (BlckX, BlckY)-(BlckX + 19, BlckY + 39), 0, BF
  Score = Score + 10
   IF Score = PrvLvlScr + 100 THEN GoToNextLevel
 END IF
LOCATE 5, 50: PRINT USING "Score: #####"; Score
RANDOMIZE TIMER
BlckX = ((INT(RND * 14)) * 20) + 60
BlckY = 30
BlckClr = INT(RND * 14) + 1
END SUB

SUB Menu
CursorY = 80
DisplayMenu
 DO
  LINE (86, CursorY)-(200, CursorY + 16), 15, B
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  LINE (86, CursorY)-(200, CursorY + 16), 2, B
  SELECT CASE Key$
   CASE CHR$(0) + "H"
    IF NOT CursorY = 80 THEN CursorY = CursorY - 32
   CASE CHR$(0) + "P"
    IF NOT CursorY = 112 THEN CursorY = CursorY + 32
   CASE CHR$(13)
     IF CursorY = 80 THEN CALL Main
     IF CursorY = 112 THEN SCREEN 0: SYSTEM
    CursorY = 80: DisplayMenu
   CASE CHR$(0) + ";"
    ChangeSpeed
  END SELECT
 LOOP
END SUB

SUB StartNewGame
CLS
BlckClr = INT(RND * 14) + 1
PlayAgain = 0
Score = 0
EndOfGame = 0
PrvLvlScr = 0
 IF DlyDrtn <= 0 THEN DlyDrtn = .01
BlckX = 0
BlckY = 0
DrawBox 5, 31, 16, 2
LOCATE 6, 33:  PRINT "Press any key"
LOCATE , 33:  PRINT "to begin..."
Key$ = INPUT$(1)
CLS
LINE (382, 60)-(500, 80), 7, B
LINE (50, 50)-(350, 350), 0, BF
LINE (50, 50)-(350, 350), 7, B
LINE (50, 50)-(350, 50), 0
LOCATE 28, 50: PRINT "F1 = Turn sound on/off."
MakeNewBlock
END SUB

