/* this is the definition of Boboli and all of the monsters in the entire
   game.
*/

/* creature kinds */
#define numtypes 6

#define boboli   0
#define bonehead 1
#define glob     2
#define golem    3
#define orc      4
#define mage     5
#define nobody 255

typedef struct {
  byte  move[nummoves][numsteps];
  short maxhp;
  char  name[16];
  byte  numframes;
  byte  movspd;
  byte  xpvalue;
  byte  active_frame[nummoves]; /*what frame of each move is important */
  byte  range; /* how close should he be to begin melee attacking */
} creature_def;

creature_def cd[numtypes]={
 {{
 /* move 0: standing still. */
 {0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 1: walking. */
 {1,1,2,2,3,2,2,1,0,0,4,4,5,5,6,5,5,4,4,255,0,0,0,0,0},
 /* move 2: melee attack. */
 {7,8,9,10,11,12,13,14,15,16,17,18,255,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 3: ouch. */
 {22,23,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 4: cast spell. */
 {19,20,21,20,19,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 5: fire projectile. */
 {31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,31,255,0,0,0,0,0,0,0},
 /* move 6: get item. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 7: big ouch. */
 {22,23,24,25,26,26,27,27,28,28,28,29,30,255,0,0,0,0,0,0,0,0,0,0,0},
 /* move 8: death. */
 {28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,255},
 /* move 9: ???????? */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
 /* maxhp */ 200,
 /* name */  "BOBOLI",
 /* numframes */ 47,
 /* move speed */ 2,
 /* xpvalue */ 40,
 /* hitframe */ {0,0,7,0,2,11,0,9,0,0},
 /* range */ 40},
 {{
 /* move 0: standing still. */
 {0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 1: walking. */
 {1,2,3,4,3,2,1,0,5,6,7,8,7,6,5,0,255,0,0,0,0,0,0,0,0},
 /* move 2: melee attack. */
 {9,10,11,12,13,13,14,15,16,17,18,19,255,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 3: ouch. */
 {20,20,21,22,21,20,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 4: cast spell. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 5: fire projectile. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 6: get item. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 7: big ouch. */
 {20,21,22,23,24,25,26,27,28,28,28,28,26,24,22,20,255,0,0,0,0,0,0,0,0},
 /* move 8: death. */
 {28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,255},
 /* move 9: ???????? */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
 /* maxhp */ 20,
 /* name */  "BONEHEAD",
 /* numframes */ 29,
 /* move speed */ 3,
 /* xpvalue */ 10,
 /* hitframe */ {0,0,7,0,0,0,0,9,0,0},
 /* range */ 15},
 {{
 /* move 0: standing still. */
 {0,0,0,0,1,1,1,1,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 1: walking. */
 {0,1,1,2,2,3,3,4,4,3,3,2,2,1,1,0,255,0,0,0,0,0,0,0,0},
 /* move 2: melee attack. */
 {5,6,7,8,9,10,10,11,11,12,12,255,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 3: ouch. */
 {13,14,15,16,15,14,13,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 4: cast spell. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 5: fire projectile. */
 {5,6,7,8,9,10,10,11,11,12,12,255,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 6: get item. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 7: big ouch. */
 {13,14,15,16,17,18,19,19,19,19,19,19,19,19,20,20,21,21,255,0,0,0,0,0,0},
 /* move 8: death. */
 {19,19,19,19,19,19,19,19,19,22,22,23,23,24,24,25,25,26,255,0,0,0,0,0,0},
 /* move 9: ???????? */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
 /* maxhp */ 10,
 /* name */  "GLOB",
 /* numframes */ 27,
 /* move speed */ 1,
 /* xpvalue */ 5,
 /* hitframe */ {0,0,6,0,0,7,0,6,0,0},
 /* range */  15},
 {{
 /* move 0: standing still. */
 {0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 1: walking. */
 {0,1,1,2,2,3,3,2,2,1,1,0,0,4,4,5,5,6,6,5,5,4,4,0,255},
 /* move 2: melee attack. */
 {7,8,9,10,11,12,13,14,15,16,17,18,255,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 3: ouch. */
 {19,20,20,19,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 4: cast spell. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 5: fire projectile. */
 {5,6,7,8,9,10,10,11,11,12,12,255,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 6: get item. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 7: big ouch. */
 {19,20,21,22,23,24,25,26,27,27,27,27,27,28,28,29,29,29,29,29,30,31,32,33,255},
 /* move 8: death. */
 {29,29,29,29,29,29,29,29,29,29,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 9: ???????? */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
 /* maxhp */ 100,
 /* name */  "GOLEM",
 /* numframes */ 34,
 /* move speed */ 1,
 /* xpvalue */ 50,
 /* hitframe */ {0,0,7,0,0,7,0,15,0,0},
 /* range */  15},
 {{
 /* move 0: standing still. */
 {0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 1: walking. */
 {0,1,2,3,3,2,1,0,0,4,5,6,6,5,4,0,255,0,0,0,0,0,0,0,0},
 /* move 2: melee attack. */
 {7,8,9,10,11,12,13,14,15,16,17,18,19,255,0,0,0,0,0,0,0,0,0,0,0},
 /* move 3: ouch. */
 {20,21,21,20,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 4: cast spell. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 5: fire projectile. */
 {5,6,7,8,9,10,10,11,11,12,12,255,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 6: get item. */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 7: big ouch. */
 {20,21,22,23,23,23,23,23,24,25,26,26,26,26,26,26,26,26,26,26,25,24,23,21,255},
 /* move 8: death. */
 {27,28,29,30,31,32,33,34,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 9: ???????? */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
 /* maxhp */ 50,
 /* name */  "MEAN ORC",
 /* numframes */ 35,
 /* move speed */ 2,
 /* xpvalue */ 50,
 /* hitframe */ {0,0,7,0,0,7,0,10,0,0},
 /* range */  15},
 {{
 /* move 0: standing still. */
 {0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 1: walking. */
 {0,1,2,3,4,3,2,1,0,5,6,7,8,7,6,5,255,0,0,0,0,0,0,0,0},
 /* move 2: melee attack. */
 {9,10,11,11,12,13,13,13,12,11,10,9,255,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 3: ouch. */
 {18,19,18,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 4: cast spell. */
 {14,14,15,15,16,16,17,17,17,17,17,17,17,16,15,14,255,0,0,0,0,0,0,0,0},
 /* move 5: fire projectile. */
 {14,15,16,17,17,17,17,16,15,14,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 6: get item. */
 {27,28,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 /* move 7: big ouch. */
 {18,19,20,20,20,20,20,21,22,23,24,24,24,24,24,24,24,24,24,24,25,25,26,26,255},
 /* move 8: death. */
 {24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,26,26,26,26,26,26,26,26,255},
 /* move 9: ???????? */
 {0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}},
 /* maxhp */ 400,
 /* name */  "SYLABULUS",
 /* numframes */ 29,
 /* move speed */ 2,
 /* xpvalue */ 200,
 /* hitframe */ {0,0,5,0,8,5,0,10,0,0},
 /* range */  20}
 };
