/* Header file for MGRAPH-C */

#ifndef __mgraph_gogo
#define __mgraph_gogo

typedef unsigned char byte;
typedef unsigned short word;
typedef byte paltype[256][3];
typedef struct {
  short x,y,x2,y2;
  } rect;

typedef byte *scrntype;
extern scrntype screen;

void gmode(byte mode);
void scrcpy(scrntype src,scrntype dst);
void near_scrcpy(scrntype src,scrntype dst);
void initmg();
void getpal(paltype p);
void loadpal(char *name,paltype p);
void fade_in(byte r, byte g, byte b, paltype p1);
void fade_out(byte r, byte g, byte b, paltype p1);
void waitretrace();
void setcol(byte c, byte r, byte g,byte b);
void setpal(paltype pal);
void line(short x,short y,short x2,short y2,byte col,scrntype scrn);
void scale_xfer(rect s,rect d,scrntype src,scrntype dst);
void clear(byte col,scrntype scrn);
void xfer(short x,short y,short x2,short y2,scrntype src,scrntype dst);
byte loadPCX(char *name,paltype pal,scrntype scrn);
void box(short x,short y,short x2,short y2,byte col, scrntype dst);

/* LAMEASS BIOS PRINTING */
void lame_gotoxy(byte x,byte y);
void lame_printchar(char c, byte col);
void lame_print(char *s, byte col);
void lame_printat(byte x,byte y, char *s, byte col);
/* END LAMEASS BIOS PRINTING */

#endif
