
#include <stdio.h>
#include <malloc.h>
#include <i86.h>
#include <fcntl.h>
#include <io.h>
#include <bios.h>
#include <conio.h>
//#include <iostream.h>

#define PALETTE_MASK 0X3C6
#define PALETTE_REGISTER_RD 0X3C7
#define PALETTE_REGISTER_WR 0X3C8
#define PALETTE_DATA 0X3C9

char __far *data_loc;
char filename[14]="common.c\n";
char __far *video_buffer=(char __far)0xa0000;

void alloc_mem(long);
void dealloc_mem();
void set_video_mode();
int read_filename(void __far*);
void set_full_palette();
unsigned char get_key();
void pcx_load(char __far *,int);

unsigned char red[256];
unsigned char green[256];
unsigned char blue[256];

void main()
{
    
        long count;
        unsigned char keyp;
        int x;
        alloc_mem(70000L);
        
        if (data_loc==NULL)
           printf("Unable to allocate memory\n");
        else
           printf("memory allocated \n");

        set_video_mode(0x13);
        printf("video mode set\n");

        pcx_load(video_buffer,1);
        printf("pcx load complete\n");
        
        count=0;
  
        while (keyp==0)
        {
        keyp=get_key();
        x=(int)keyp;
        printf("key==", x);
        if (count++>400L)
            goto theend;
        }
theend:;        
        if (data_loc!=NULL)
            dealloc_mem();

}

void alloc_mem(long memsize)
{
        data_loc=(char __far *)malloc(memsize);

}

void dealloc_mem()
{
        free(data_loc);
}

void set_video_mode(int mode)
{
    union REGS inregs,outregs;

    inregs.h.ah=0;
    inregs.h.al=(unsigned char)mode;

    int386(0x10,&inregs,&outregs);
}

int read_file(char *file_buffer)
{
    int handle;
    int size_read;

    handle=open(filename,O_RDONLY | O_BINARY);

    if (handle==-1)
    {
        printf("Error opening file\n");
        return 1;
    }
    else
    {    
        size_read=read(handle,file_buffer,65500);

        if (size_read==-1)
        {
            printf("Error reading file\n");
            return 1;
        };

        close(handle);
        return 0;
    };
}        
    
void set_palette_register(int index)
{
    outp(PALETTE_MASK,0XFF);
    
    outp(PALETTE_REGISTER_WR, index);
    
    outp(PALETTE_DATA,red[index]);
    outp(PALETTE_DATA,green[index]);
    outp(PALETTE_DATA,blue[index]);
}

void pcx_load(char __far *load_loc,int palette_fg)
{
    FILE *fp;
    unsigned char data;
    unsigned int index,count,num_bytes;

    

    fp=fopen(filename,"rb");

    for (index=0;index<128;index++)
    
        data=(char)getc(fp);
    
    count=0;

    goto skip_crash;

    while(count<=64000)
    {
        data=(unsigned char)getc(fp);
        if (data>=192)
        {
            num_bytes=data-192;
            data=(unsigned char)getc(fp);
            while(num_bytes-->0)
            {
                load_loc[count++]=data;
            };
       }
        else
            load_loc[count++]=data;
    };

skip_crash:;    
    if (palette_fg==0)
    {
        fclose(fp);
        return;
    };
    fseek(fp,-768L,SEEK_END);
    for (index=0;index<256;index++)
    {
        red[index]=(unsigned char)(getc(fp)>>2);
        green[index]=(unsigned char)(getc(fp)>>2);
        blue[index]=(unsigned char)(getc(fp)>>2);
    };
    fclose(fp);
    set_full_palette();
}
void set_full_palette()
{
    int index;
    for (index=0;index<256;index++)
    {
        set_palette_register(index);
    };
}
unsigned char get_key()
{
    unsigned char key_pressed;

    key_pressed=(_bios_keybrd(_KEYBRD_READY)&255);
    if (key_pressed)
        _bios_keybrd(_KEYBRD_READ);
    if (key_pressed==0)
        printf("still zero");  
    else
    {        
        printf("key pressed");
        if (key_pressed==65)
            printf("\n\n\n\n\n\n\n\n\n\n\n\n");           
    };
    return key_pressed;    
}
