~sCAVALRY TACTICS~

The tactical and strategic use of cavalry in the Civil War
often differed from its use in Europe both before and after
the American conflict.

America's leading pre-war military influence was Dennis
Mahan, Professor of Engineering and the Science of War
at the U.S. Military Academy, West Point. Somewhat ahead
of his time, he dismissed the capabilities of cavalry. "The arm
of cavalry by itself can effect but little; and in many
circumstances, does not suffice even for its own safety.
The smallest obstacles are sufficient to render it powerless;
it can neither attack nor hold a post without the aid of infantry,
and at night is alarmed, and justly so, at every phantom."

Mahan, whose classes were described as both terrifying and
memorable, helped produce a generation of officers which
tended to discount the use of cavalry.  Consequently, it was
not considered a major force on the battlefield, and not much
was expected of it. "Ten thousand dollars for a dead cavalryman," was
a common taunt from Union infantry when their cavalry rode by.

And so, at least in the first few years of the
war, cavalry was used mainly for scouting and raiding.
Whenever cavalry was actually deployed on the battlefield, it was in
such tiny numbers that they were easily beaten off. This lent
support to the idea that the days of such attacks were gone,
and the cavalry was obsolete in the face of armies equipped
with modern weapons.

However, well-trained battlefield cavalry, used en masse, and
with a proper respect for the siting of enemy artillery,
was still a potent force. European battles continued to
demonstrate the effective use of cavalry, as well as the disasters
caused by its misuse. Besides cavalry-on-cavalry clashes, the
cavalry could also batter or break an infantry line, especially where
it was already weakened by artillery or infantry assaults. The lack of
cavalry on, or even near, many of the American battlefields, was an
important reason why battles frequently ended in stalemate.

By 1864, however, the Union's General @Sheridan@ was
showing what could be done with cavalry. @Sheridan@
exploited the tactic developed by the Confederacy's
General @Morgan@, who saw that his men could be more
effective dismounted, and firing guns, than launching a
sabre-wielding charge. As "mounted infantry", the cavalry
became a light, mobile force equipped with modern weapons
and often fighting dismounted, but still capable of charging
en masse. This gave the cavalry a new and powerful role, and
by 1865 Sheridan had turned cavalry into a war-winning weapon.
The cavalry had received a reprieve, and even as late as the
First World War, mounted infantry would still be fighting decisive
campaigns in Palestine.

A Prussian observer with the Confederates identified four
classes of cavalry.

Regular cavalry were organized into regiments, brigades and
divisions. These were used for skirmishing, battles and raids in
force. The cavalries led by @Stuart@, van Dorn and @Morgan@
belong to this category.

Partisan Rangers were a kind of free corps. Their job was to raid;
their pay was in the form of loot. Mosby and the Quantrill gang
were the best (or worst) examples. Sometimes akin to bandits,
they were responsible for the massacre of civilians at Lawrence,
Kansas in 1863 and for many other atrocities. The James brothers
"learnt their trade" while riding with Quantrill.

Scouts ranged far and wide, seeking information about enemy
movements and dispositions. They rode in small groups, or
sometimes alone. Because scouts wore uniform they weren't
classed as spies.

Couriers were attached to a general's staff, and carried his
messages and orders both on the battlefield and off it. Typically,
they were exceptionally skillful horsemen, with the best mounts.

~sCavalry as the Eyes of the General~
A commander's major source of information was cavalry pickets
and patrols.

Most basically, cavalrymen relayed information about the
physical landscape. Maps tended to be either crude or
nonexistent, and so terrain sketches and route strip-maps
had to be drawn.

Reconnaissance was a vital function of the cavalry.
A reconnaissance group of perhaps four riders, out probing
for enemy positions, would have a larger mounted force further
back, in support. These would be ready to move forward, if the
way was clear, or to defend the returning outriders, if pursued.
The whole group would also sometimes provide an advance screen
for infantry and artillery, coming up behind.

Around the battlefield itself, if the cavalry were not going to be
used on the field, the commander would send cavalry to find
the enemy's flanks, and to try to discover his intentions. The
cavalrymen would probably be escorted by a staff officer, who
would send back reconnaissance reports. This optimal use of
cavalry was sometimes overlooked, with disastrous results. If
the cavalry had been detached and sent off raiding or feinting
somewhere, then the battlefield commander might be left quite blind
just when he needed the cavalry the most. Worst examples of
this mistake were when Stoneman was missing at Chancellorsville,
and @Stuart@ was missing at the outset of @Gettysburg@.

~sCavalry Raids~
Often, raids captured or destroyed military supply dumps, tied up
large numbers of enemy troops in garrisons, and severed road and
rail links. A campaign might be held up while communications were
restored and the raiders driven away.

Raiding in the "debatable lands" between the hostile armies tended
to be relatively safe, enjoyable, and profitable. Bulging saddle-bags
were often won at the expense of unarmed civilians, and fueled the
dislike of under-provisioned infantrymen.

The moral effect of raiding was sometimes significant. In his
heyday, @Stuart@'s dashing raids behind enemy lines boosted
Confederate spirits, dealt a blow to Union prestige, and set
a new fashion for cavalry operations.

But not infrequently, the results of raids were out of all proportion
to the extravagant praise (or dire humiliation) meted out at the time.
The bravura of such actions helped to reinforce a belief among
commanders that raiding was what cavalry were really for. This
belief sometimes undermined the cavalry's ultimate effectiveness
during the opening moves of battle, and then on the field itself.

~sCavalry as Mounted Infantry~
The Confederate General @Morgan@'s men, when on raids,
seldom fought on horseback. Typically, they would fight as
infantry with a skirmish line in front and the main body behind.
The horses and horse-holders (one out of every four riders) would
find cover close behind their comrades, with mounted companies
deployed on the flanks and as a reserve.

But it was the Union's General @Sheridan@ who, building
on @Morgan@'s example, changed the mounted infantryman
from a tactical, fast-moving battlefield force into a strategic,
war-winning weapon.

@Sheridan@ had come to the Army of the Potomac as its
cavalry commander in 1864. Young, energetic and resourceful,
he believed that concentrated mounted infantry could overcome
almost any opposition.

First he proved it against @Early@ in the Valley campaign,
and again in the Appomatox campaign. He used his
cavalry as a fast-moving spearhead, which would aim to
drive into the enemy's flank, also scattering any hastily
assembled forces which could be thrown in their way. Up
to two-thirds of the cavalry would then dismount and act
as skirmishing infantry to drive the enemy away, in the same
manner as @Morgan@ had.

Because much of the Union cavalry was by now armed with
new repeating carbines, these tactics had considerable shock
value. Supporting infantry would be marching hard in the
meantime, to hold the ground won or to provide heavy back-up
if the cavalry was encountering difficulties. Even if the initial
clash was not particularly successful (as at Dinwiddie Courthouse),
the cavalry could use their mobility to disengage and then strike
from a fresh direction soon afterwards.

And so the enemy would be faced with a bewildering succession
of unexpected blows, stretching his resources and staffwork to the
limit. The army would have to march and counter-march, eroding its
cohesion. Isolated detachments could be surprised and overwhelmed,
as at Sayler's Creek. Finally, the attacking cavalry would cut off the
retreat of the main enemy body, allowing their supporting infantry to
complete the encirclement, as at Appomattox.
@@@
