~HA Brief History of the Civil War
Written by Prof. David Muzzey, New York, 1917~

~sTHE OPPOSING FORCES~
So the men of the North and of the South were mustering to arms in the spring
of 1861.  Each side doubted whether the other really meant to fight; each
believed that, if they fought, its own victory would be short and decisive.
Each was absolutely convinced of the righteousness of its own cause.  `War has
been forced upon us by the folly and fanaticism of the Northern abolitionists,'
said an Atlanta paper; `Surely 8,000,000 people armed in the holy cause of
liberty . . . are invincible by any force the North can send against them.'
On the other side of Mason and Dixon's line Northern mass meetings resolved
that `this infamous, hell-born rebellion against the mildest, the most
beneficent government ever vouchsafed to men' should be speedily put down,
and `our glorious Constitution restored in every part of our country.'

Thirty years of gathering bitterness had made it absolutely impossible for the
men of the North and of the South to understand each other.  As early even as
1832 our distinguished French visitor and critic De Tocqueville had prophesied
the `inevitable separation' of the two sections.

North and South were unequally matched for the great struggle that was before
them.  Although the seceding and the loyal states were about equal in
territory, the resources of the North far exceeded those of the South.  Of the
31,000,000 inhabitants of the United States by the census of 1860, there were
19,000,000 in the eighteen free states of the North, 3,000,000 in the four
loyal slave states of Delaware, Maryland, Kentucky, and Missouri, and 9,000,000
in the eleven states of the Southern Confederacy.  But of the last 9,000,000
nearly one half (3,600,00) were negro slaves.

For military service the North could furnish 5,000,000 men between the ages of
18 and 60, to about 1,500,000 in the South.  Furthermore the population of the
North was increasing very rapidly (41 per cent in the decade 1850-1860),
whereas in most of the states of the South it was almost stationary.  During
the decade 1850-1860 immigrants (mostly Irish and Germans) had come into the
United States in numbers equal to the entire slave population of the seceding
states, and had all gone into the free North to increase the wealth produced by
the mills, the forges, and the wheat fields.

~sINDUSTRIES~
Because cotton formed two thirds of the exports of the United States in 1860
the South was deceived into thinking that it was the most prosperous part of
the country, and that its slave labor was making New England rich.  But the
South overlooked the fact that a country's wealth consists not in the amount of
its exports, but in its ability to distribute the necessities and comforts and
luxuries of life to a growing population.

Measured by this standard of wealth, the South was poor in 1860, in spite of
its crop of cotton.  For while a few thousand rich planters were selling this
crop, and investing their profits in more negroes and more land, a majority of
the white inhabitants of the South were in comparative poverty and idleness,
seeing the land absorbed by the cotton plantations and the labor market filled
with negro slaves.

~sSOCIAL PROGRESS~
Manufacturers, railroad mileage, the growth of cities, the diffusion of
knowledge, progress in art and letters, are all signs of a country's
prosperity.  The South had hardly any manufacturing in 1860.  She spun and wove
but two per cent of the cotton she raised, and only one fourth of the 31,000
miles of railroad track in the United States was laid on her soil.

While the free states of the North abounded in thriving cities, equipped with
gas and water systems, tramways, public schools and libraries, hospitals,
banks, and churches, the census of 1860 found only six `cities' in Alabama with
a population of 1000 or over, four in Louisiana, and none in Arkansas.  Not a
single Southern state had a free public-school system before the war.  Fifteen
per cent of the adult male white population of Virginia (in addition of course
to practically all the negroes) were unable to read or write while less than
one per cent of the adult males of Massachusetts were illiterate.

The cause of this sad social and industrial condition in the South was the
plantation system founded on negro slavery, which developed a `caste' of some
380,000 aristocratic planters at the expense of over 5,000,000 `poor whites'
and nearly as many even poorer negro slaves. The growing generations of the
slaveholding South had always before their eyes certain ugly features of the
system.  The existence of the coarse slave driver and the callous slave trader
testified to its cruelty.  That the men of the South, in defending what they
believed to be their rights under a government of `liberty and equality', were
pledged to defend and perpetuate such an institution as slavery was a
misfortune.

~sHELPER'S `IMPENDING CRISIS'~
We may wonder, too, why the millions of `poor whites' in the South, who had no
slaves and no interest in slavery, should have fought through four years with
desperate gallantry for the maintenance of a system which meant for them only
wretchedness.  One of their number, Hinton R. Helper of North Carolina, had
published a book in 1857, entitled `The Impending Crisis,' in which he showed
with a merciless array of figures the economic burden which slavery entailed
upon the South.

Helper called the slaveholding aristocracy no better than the basest `ruffians,
outlaws, and criminals', and advised `no co-operation with them in religion, no
affiliation with them in society'.  Had the `poor whites' been able to read and
understand the figures and arguments of Helper's book, it is probable that they
would not have fought the war which meant the perpetuation of slavery.

But the `poor whites' of the South were not educated to think.  They believed
that the `Black Republicans' of the North meant to subjugate them and turn
their land over to the negro.  They rose in a mass to defend a civilization
which, had they but realized it, was the worst enemy of their interests.  The
leaders of the South knew, of course, that the North was superior in resources,
but they counted on several real advantages and several anticipated
developments to give them the victory.

~sTHE SOUTHERN ADVANTAGE~
First, and most important of all, they would be fighting on their own soil,
whereas the North, in order `to repossess the forts and other seized property
of the United States,' and to put down the rebellious `combinations,' would
have to `invade' Southern territory.  The men who fight on the defensive are
always at an advantage.  They know the lay of the land; they have their base of
supplies close at hand; they are inspired by the thought that they are
defending their homes.  Then, too, the Southerners, by nature and training,
were better fitted for war than the mechanics, clerks, and farmers of the
North.  The Southern temper was more ardent.  The men of the South commonly
carried firearms.  They were accustomed from boyhood to the saddle.  In the
Mexican War many more Southern officers than Northern ones had been trained for
the great civil contest.

Besides these actual advantages the South counted on help in three directions.
She expected that foreign nations, especially Great Britain and France,
dependent on her for their supply of raw cotton, would lend their aid to
establish an independent cotton-raising South, which would levy no duties on
their manufactures.  She thought, too, that the first move in behalf of a new
republic whose cornerstone was slavery would bring all the other slaveholding
states into the Confederacy.  And she looked to the Democrats of the North, who
had cast 1,370,000 votes against Abraham Lincoln, and whose leaders had
repeatedly shown signs of Southern leanings, to defeat any attempt of the
Republicans to `subjugate the South.'

We have seen how completely deceived the South was in the last expectation,
when the shot fired on Fort Sumter roused the North as one man to pledge
President Lincoln its aid in defending the Union.  We have seen also how only
four of the eight slaveholding states north of the cotton states joined the
Confederacy on Lincoln's call for troops.

The South was equally disappointed in the hope of foreign intervention and aid.
 Queen Victoria issued a proclamation of strict neutrality a month after the
fall of Fort Sumter (May 12, 1861); and Emperor Napoleon III, although
expressing to the Confederate envoy to France his personal sympathy for the
South, was careful to avoid any official breach with the government at
Washington.

Moreover, large portions even of some of the seceding states remained faithful
to the Union, especially the mountain districts in western Virginia and North
Carolina, and in eastern Tennessee.  Forty-eight counties in western Virginia
broke away from the state and formed a loyal government, which was recognized
by President Lincoln, and later received into the Union (1863) as the state of
West Virginia.  A striking proof of the divergent views of loyalty in North and
South is the fact that the wise and moderate Robert E. Lee called the people of
West Virginia `traitors' for leaving their state to adhere to the Union.

So the men of the North and the sons of Dixie were arrayed against each other,
in the spring of 1861, for a contest which none dreamed would be the most
prolonged and bloody since Napoleon's rash attempt, at the beginning of the
century, to subjugate the continent of Europe.

~sFROM BULL RUN TO GETTYSBURG~
`The Official Records of the Union and Confederate Armies and Navies in the War
of the Rebellion,' published by the government in Washington, fills more than
130 bulky volumes, and chronicles over 2000 engagements, of which about 150 are
important enough to be called `battles'. This immense mass of literature
pertaining to the Civil War is a proof of the significance of that event to
American history.  Except for the critical years in which our nation was
formed, no other period in our history can compare in importance with the great
Civil War of 1861-1865.

We need not go into the military details of the Civil War in order to
appreciate its importance. Two things we must constantly bear in mind: first,
the superior resources of the North in men and wealth, which told with
increasing emphasis as the war progressed; and secondly, the advantage that the
South had in fighting on her own soil against the invading armies of the North.
 Had the South possessed the resources of the North, she could never have been
beaten; had she attempted to invade the North, her armies would have been
repulsed at the borders.

~s`ON TO RICHMOND!'~
We turn now to the field of battle.  When Virginia seceded, the capital of the
Confederacy was changed from Montgomery, Alabama, to Richmond, and the
Confederate Congress was called to meet at the new capital, on July 20, 1861.
The North, in the first flush of its enthusiastic response to Lincoln's call
for troops, was determined that the Confederate Congress should not meet.
`On to Richmond!' was the cry that rang through the North.
The raw troops were not properly organized or drilled, and the supply
departments were not prepared for a campaign.
But President Lincoln and General Scott yielded to the popular
demand for a move on Richmond, especially as the three months term of the
militia called for in April was about to expire.

~sTHE BATTLE OF BULL RUN~
General Beauregard, with 22,000 troops, was at Manassas Junction, a town near
the little stream called Bull Run, about thirty-five miles southwest of
Washington.  In the Shenandoah valley, across the Blue Ridge, were 9,000 more
men under General Joseph E. Johnston, who was to become, next to Lee, the
greatest commander of the South.  General Patterson, a veteran of the War of
1812, was to hold Johnston in the valley, while General McDowell, with an army
of 30,000, attacked General Beauregard at Manassas.  McDowell's `grand army'
set out in high spirits, July 16, accompanied by many of the congressmen and
officials in Washington, who went to see the `rebellion crushed by a single
blow'.

The battle (on the 21st) was well planned and bravely fought.  Up to early
afternoon the advantage was with the Union troops, but at the critical moment
Johnston's army, which had eluded Patterson and hastened eastward at the sound
of the firing, appeared on the field and turned the Union victory into a rout.
The undisciplined soldiers of McDowell, wearied with the day's fighting, threw
down their muskets and fled to the Potomac.  For two days they straggled into
Washington, and the capital was in a panic for fear Beauregard and Johnston
would come on their heels.

The disaster at Bull Run (or Manassas, as the Confederates called the
battle) sobered the overconfident enthusiasm of the Northerners, but
did not destroy their determination.  They set to work in earnest to
prepare for the long, severe struggle that was before them.  George
B. McClellan, a young general who had done brilliant work in holding
West Virginia for the Union in May and June, was now put in command
of the army of the Potomac.  McClellan was a magnificent organizer
and drillmaster.  By the autumn of 1861 he had the 180,000 men who
poured into his camp in response to Lincoln's call, organized into a
splendid army nearly three times the size of the opposing forces
under Lee and Johnston.

The aged General Scott resigned on the last day of October, and
McClellan was made general in chief of the forces of the United
States.

~sTHE PENINSULA CAMPAIGN, March-July, 1862~
McClellan could and should have taken Richmond in the autumn of 1861, but he
was cautious to the point of timidity.  Personally brave, he feared for the
magnificent army under his command.  He magnified the enemy's forces to three
times their actual number, and looked on the loss of a brigade from his own
army as a great calamity. He berated Lincoln and Stanton for not sending him
more reinforcements.

It was not until well into the spring of 1862 that McClellan, after repeated
orders from Washington to advance, began to move up the peninsula between the
York and James rivers toward Richmond.  Even then the Peninsula campaign, which
should have been a steady triumphal march to the Confederate capital, was a
slow guarded approach of many weeks duration.  Once, within four miles of
Richmond, McClellan retreated because Lincoln detained McDowell`s division of
90,000 men to protect Washington.

Lee and Johnston were quick to seize the moment of the deliverance of Richmond
to turn in pursuit of the Army of the Potomac.  McClellan, always masterly on
the defensive, won several engagements from his pursuers, finally routing them
decisively at Malvern Hill (July 1, 1862) in one of the severest battles of the
war.  Richmond again seemed to lay within his grasp, but instead of advancing,
he led his army back to Harrisons Landing on the James River within reach of
the Union gunboats.  The famous Peninsula campaign was ended.  Richmond was
still undisturbed.  President Lincoln removed McClellan from the command of the
armies of the United States, July 11, 1862.

~sTHE SOUTHERN BLOCKADE~
A year had passed since the battle of Bull Run, yet the Union arms had made no
progress in Virginia.  But the United States navy, under the efficient
management of Secretary Welles, had accomplished important results.  First, it
had established so effective a blockade along the 3000 miles of the Confederate
coast that the exports of cotton dropped in value from $202,000,000 in 1860 to
$4,000,000 in 1862.

The Southerners, especially after their victory at Bull Run, could not believe
that Great Britain would stand by quietly and allow the North to shut off her
cotton supply by a blockade.  Their expectations of British intervention were
heightened almost to a certainty when, in November, 1861, Captain Wilkes of the
Union war sloop San Jacinto stopped the British mail steamer Trent as she was
sailing from Havana.  She forcibly removed from her deck the Confederate
commissioners to Great Britain and took them as prisoners to Fort Warren in
Boston harbor.

The deed was hailed with rejoicing in the North.  The Navy Department
congratulated Wilkes, and the House of Representatives gave him a formal vote
of thanks.  The South was in high hopes that this insult to the British flag
would involve the administration at Washington in a war with England, and the
Queen's government began, in fact, to send troops to Canada.  But Lincoln,
Seward, and Sumner realized that Wilkes's was a high-handed outrage of the
principle of the inviolability of vessels of neutral nations.  Consequently,
Seward informed the British minister, Lord Lyons, on December 26, that the
prisoners in Fort Warren would be `cheerfully liberated'.  Mason and Slidell
were given up, the British government was satisfied, and the blockade of the
Southern ports continued undisturbed.

~sTHE VIRGINIA AND THE MONITOR~
The Northern navy won a notable victory in a strange kind of battle that took
place in Hampton Roads, Virginia, March 9, 1862.  The Confederates had raised
the sunken hull of the Merrimac at the Norfolk navy yards, and, covering her
with a sloping roof of iron rails smeared with plumbago and tallow, had made of
her the first `ironclad' in the history of naval warfare.  This formidable
craft, re-christened the Virginia, easily destroyed two of the finest ships of
the Union navy in Hampton Roads, on March 8.

But that same night there arrived at Hampton Roads from New York a stranger war
vessel even than the Virginia.  This was the Monitor, a small iron craft shaped
like a torpedo boat, and having amidships a revolving gun turret rising only a
few feet.  A witty observer called the boat `a cheese box on a raft'.  The
Monitor placed herself between the Virginia and the wooden ships of the federal
navy, and after an all day fight the dreaded Confederate ram steamed back to
the Virginia shore.  The wooden ships were saved, but at the same time they
were made forever obsolete.  This first battle in history between ironclads
announced that henceforth the world's navies were to be ships of steel.

While the wearisome and futile Peninsula campaign was dragging through the
spring months of 1862, relieved only by the victory of the Monitor, the Union
arms were making progress in the West.

~sTHE CAMPAIGN ON THE MISSISSIPPI~
Of equal importance to the Union cause with the blockade of the Southern ports,
was the opening of the Mississippi River, which the Confederates held from its
junction with the Ohio down to its mouth.  The possession of the river would
bring the Unionists the double advantage of freeing an outlet for the commerce
of the northwestern states, and cutting off the states of Arkansas, Louisiana,
and Texas from the rest of the Confederacy.  The credit for this work belongs
to General Ulysses S. Grant and Captain David G. Farragut.

Grant was a graduate of West Point. He had served creditably in the Mexican
War, but since its close had led a thriftless and rather intemperate life.  The
outbreak of the Civil War found him, at the age of thirty-nine, working in a
leather and hardware store in Galena, Illinois, and dependent on his father for
the support of wife and family. But the call to war transformed the poor
businessman into a military genius of the highest order.

In February, 1862, Grant seized the very important forts, Henry and Donelson,
and carried his victorious army up the Tennessee River, a hundred miles across
the state of Tennessee, to Pittsburg Landing.  While waiting there for the
arrival of General Buell's army, Grant was attacked by a superior force under
General Albert S. Johnston, the best Confederate general in the West.  The
terrific battle of Shiloh (or Pittsburg Landing) lasted two days (April 6-7,
1862).

At nightfall of the first day the Union troops had been driven back to the
bluffs along the river; but before morning Buell's army arrived, and the second
day's fighting was a triumph for the Union side.  The Confederates fell back to
Corinth, Mississippi.  They had lost 10,000 men, and lost General Johnston, who
was killed on the field.  The capture of Forts Henry and Donelson and the
victory of Shiloh cleared western Tennessee of Confederate troops, while
General John Pope and Commodore Foote in a parallel campaign brought their
gunboats down the Mississippi and secured the river as far south as the high
bluffs of Vicksburg, Mississippi.

Meanwhile the great river was being opened from the southern end.  New Orleans,
125 miles up river, was protected by the strong forts, Jack son and St. Philip,
and by a heavy `boom' of chained and anchored hulks stretching a quarter of a
mile across the current between the forts.  On the night of the April 23, 1862,
Captain Farragut, broke the boom and ran the gauntlet of the fire of the forts.
 New Orleans was left defenseless.  The small Confederate army withdrew, and
General Butler entered the city, which he ruled for over six months under
military regime.

The capture of New Orleans opened the river as far north as Port Hudson.  Thus,
by midsummer of 1862, only the high bluffs of Vicksburg and Port Hudson, and
125 defenseless miles of river bank between, were left to the Confederacy.
These successes in the West contrasted strikingly with the delays and
disappointments of the army in the East; and when McClellan was relieved of his
command in July, it was natural that a Western general should succeed him.
Halleck, under whose command the brilliant operations in Tennessee had been
conducted, was called to Washington, July 11, 1862, to advise the President.
Meanwhile General Pope was given command of a new `Army of Virginia',
independent of McClellan's diminished Army of the Potomac.

~sTEN MONTHS OF FAILURE~
The ten months that followed, from August, 1862, to June, 1863, present a
record of defeat for the Union cause in Virginia.  General Lee, with his
magnificent lieutenants, `Stonewall' Jackson, Longstreet, Ewell, the Hills, and
Stuart, outwitted and outfought the Union commanders at every turn.  Pope was
beaten at a second battle of Bull Run (August, 1862), and his entire army
forced to retreat on Washington.

McClellan was restored to command ,and hailed with joy by his old soldiers.  He
stopped Lee's invasion of Maryland in the bloodiest single day's battle of the
war, at Sharpsburg on the Antietam Creek (September 16, 1862); but with his old
reluctance to follow up a victory by crushing the foe, he let the shattered
Confederate army get back across the Potomac to Virginia soil.  He was removed
again by the distressed administration at Washington, and General Burnside was
put in his place, only to suffer an awful repulse in his reckless assault on
the heights of Fredericksburg (December 13, 1862).

Then General Joseph Hooker, `Fighting Joe,' who succeeded Burnside, was routed
in the three days' fight at Chancellorsville (May 1-4, 1863).  The early months
of 1863 marked the lowest ebb of the fortunes of the Union cause.  For nearly
two years the superior Federal forces in Virginia had been trying to take
Richmond, but they had not been able even to hold their own position.  General
Lee was planning another invasion of the North.  Union soldiers were deserting
at the rate of a thousands a week ,and hundreds of officers were finding
excuses to leave the army for `vacations'.

The attempts to draft new recruits into the army were met with serious
resistance in many states.  In New York City the draft riots of July, 1863,
resulted in the destruction of $1,500,00 worth of property and the loss of 1000
lives.  The cost of the war was enormous; the debt was increasing at the rate
of $2,500,000 a day.  The Secretary of the Treasury was having difficulty in
borrowing enough money to keep the army in the field.  Conviction that
Lincoln's administration was a failure was shown by the triumph of the
Democrats in the elections of 1862 in such important states as New York, New
Jersey, Pennsylvania, Ohio, Indiana, Illinois, and Wisconsin.

In June, 1863, the Southern hopes were high.  In the West the great fortress of
Vicksburg, which Grant and Sherman had been manoeuvering against for months,
still blockaded the lower Mississippi to the Union fleets.  In the East,
General Lee, at the height of his power and popularity, was crossing the
Potomac northward with a magnificent army of 75,000 veterans.  But on the
fourth of July, Lee was leading his defeated army back to the Potomac after the
tremendous fight at Gettysburg, while General Grant was entering Vicksburg in
triumph.

~sTHE BATTLE OF GETTYSBURG~
The battle of Gettysburg (July 1-3, 1863) was the most important battle of the
war, and the only one fought on the free soil of the North.  Knowing the
widespread discouragement in the Northern States and the dissatisfaction in
many quarters with Lincoln's conduct of the war, Lee hoped that a brilliant
stroke as near New York as he could get might terrify the Northern bankers, and
lead them to compel the administration to stop the war.  General George G.
Meade, who had just succeeded Hooker in the command of the Army of the Potomac,
met Lee's attack with his fine army of over 80,000 men securely posted on the
heights of Round Top and Cemetery Ridge, south of the town of Gettysburg.

The first and second days' fighting (July 1, 2) were favorable to the
Confederates, but reinforcements kept pouring in for the Army of the Potomac,
and, in spite of heavy losses, the Federal position was being strengthened from
hour to hour. At the beginning of the third day of the fight General Meade had
over 90,000 men posted on the heights above and around Gettysburg.  Lee, tired
and desperate in his demand for victory, now failed for once in generalship.
Disregarding the almost tearful remonstrances of General Longstreet, he sent
General Pickett with 15,000 men, the flower of the Confederate infantry, to
carry by storm the impregnable position of the Union troops on Cemetery Ridge.

It was the most dramatic moment of the war, as Pickett's splendid column, in
perfect order, swept across the wide plain which separated the two armies and
dashed up the opposite slope in the face of the withering fire of the Union
guns.  The men went down like grain before a hailstorm, but still there was no
pause.

A hundred led by Armistead pierced the Union line and planted the flag of the
Confederacy on the ridge, - the `high-water mark of the Rebellion'.  But no
human bravery could stand against the blasting wall of fire that closed in upon
Pickett's gallant men.  The line wavered, then stopped, then bent slowly
backward, and broke.  The day, the battle, and the Southern cause were lost.

~sTHE FALL OF VICKSBURG~
The next day, the `glorious fourth' of July, at evening, while the North was
celebrating the great victory of Gettysburg, General Lee began his slow retreat
to the Potomac through a heavy, dismal storm of rain.  Lee's grief and chagrin
would have been doubled had he known that, on that same dismal fourth of July,
General Pemberton, after a valiant defense of six months, had surrendered the
stronghold of Vicksburg , and had delivered over his starving garrison of
30,000 men as prisoners of war.

Five days after the fall of Vicksburg, Port Hudson yielded, and the Mississippi
was again a Union stream from source to mouth. `The Father of Waters,' wrote
Lincoln exultantly, `goes again unvexed to the sea.'

~sTHE TRIUMPH OF THE NORTH~
The victories at Gettysburg and Vicksburg were the turning point of the war.
Not that the South as yet acknowledged defeat or even distress.  On the
contrary, the tone of her press and the utterances of her public men were more
confident than ever.  Newspapers in Richmond and Charleston actually hailed
Gettysburg as a Confederate victory, presumably because Lee had been allowed to
withdraw his shattered army across the Potomac without molestation.  But to men
who did not let their zeal blind them to facts, the disasters which overtook
the Confederacy at Gettysburg and Vicksburg appeared to be almost beyond
repair.

It was not alone the loss of 60,000 soldiers from armies in which every man was
sorely needed that made those summer days of 1863 so calamitous to the South.
It was even more the change which they brought in the public sentiment of the
North, in the attitude of Great Britain toward the Confederacy, and in the plan
of campaign of the Union commanders.  In the North the bankers, whose cash
vaults Lee hoped to close tightly by his invasion of Pennsylvania, now lent to
the government freely; and private individuals bought millions of dollars worth
war coupons.

President Lincoln, in his annual message to Congress, December, 1863, could
say: `All the demands on the Treasury, including the pay of the army and navy,
have been promptly met and fully satisfied, . . . By no people were the burdens
incident to a great war ever more cheerfully borne.'

~sTHE UNION PLAN OF CAMPAIGN~
The effect of the victories at Gettysburg and Vicksburg on the conduct of the
war was also important.  Up to the middle of the year 1863 there had been no
cooperation between the Union armies.  The Army of the Potomac, in Virginia,
had been battling in vain to break through Lee's defense of Richmond.  The army
on the Mississippi had been slowly accomplishing its great task of opening the
river.  The fall of Vicksburg left the troops of Grant and Sherman free to move
eastward across Mississippi and Alabama, driving Johnston's inferior forces
before them, and to join with Rosecrans at Chattanooga and push the Confederate
armies across the lower end of the Appalachian range into Georgia.

While this great flanking movement was going on from the West, the Army of the
Potomac was to press down on Lee from northern Virginia.  So the forces of the
Confederacy would be crushed between the two great Union armies in Virginia and
Georgia.  This plan of wrapping the Union armies about the Confederacy and
squeezing the life out of it was called the `Anaconda policy.'  Next to
Richmond and Vicksburg, the most important military position in the Confederacy
was Chattanooga.  This city guarded the passes into the rich state of Georgia,
the `keystone of the Confederacy.'

Rosecrans confronted Bragg at Chattanooga in the autumn of 1863.  Bragg retired
before his opponent across the Tennessee River into the mountains of the
northeastern comer of Georgia, then suddenly turned on him at Chickamauga
Creek, where Rosecrans had hastily concentrated his forces.

~sTHE BATTLE OF CHICKAMAUGA~
The battle of Chickamauga, which followed Rosecrans's frantic effort to get his
army together (September 19-20, 1863), would have been as complete a disaster
for the Union cause as Bull Run, had it not been for the intrepid conduct of
one man, General George H. Thomas.  Rosecrans had given a blundering order
which left a wide gap in the Union lines.  Into this gap the Confederate
regiments poured, driving the entire right wing of Rosecrans's army off the
field in a panic, and sweeping Rosecrans with his men back to Chattanooga.
There he telegraphed Halleck that his army was `overwhelmed by the enemy'.

But General Thomas on the left, with only 25,000 men, refused to leave the
field.  Forming his men into a horseshoe, he stood firm against the furious
onslaught of 60,000 Confederate troops, from half past three in the afternoon
till the deep twilight four hours later.  It was the most magnificent defensive
fighting of the war.  It almost turned defeat into victory.  It earned for
General Thomas the proud title of `the Rock of Chickamauga', and justified his
promotion by Grant to the command of the Army of the Cumberland.

~sTHE BATTLES AROUND CHATTANOOGA~
After his dearly bought victory at Chickamauga, General Bragg proceeded to lay
siege to Chattanooga.  General Grant, who had been put in command of the armies
of West now dispatched the Army of Tennessee, under General Sherman, to join
Thomas at Chattanooga.  By the middle of November, he was ready with the
combined armies to begin operations against Bragg and Johnston.  The three days
battle around Chattanooga (November 23-25) was a fitting climax to Grant's
splendid achievements of the year 1863.

On the twenty-fourth of November Hooker seized the top of Lookout Mountain in
`the Battle above the Clouds'.  On the twenty-fifth General Thomas's troops
were ordered to seize the Confederate rifle pits at the foot of Missionary
Ridge.  They seized the pits, and then, without waiting for further orders,
stormed up the steep sides of the mountain in the face of a deadly fire from
thirty cannon, and drove the astounded Bragg, with his staff and his choicest
infantry, from the crest of the hill.  The Confederate general fled southward
into Georgia, burning his depots and bridges behind him

~sGRANT RAISED TO COMMAND~
On the first day of Congress, which assembled a fortnight after the battle of
Chattanooga, a bill was introduced to revive the rank of lieutenant general,
which had not been held by any general in the field since George Washington.
Everybody knew that the new honor was intended for General Grant.  The bill was
passed February 29, 1864, and immediately Grant was summoned to Washington by
the President.  In the presence of the cabinet he was formally invested with
the rank of lieutenant general and the command, under the President, of all the
armies of the United States (March 9, 1864).

Grant made his companion in arms, General William T. Sherman his successor in
the command of the armies of the West, while he established his own
headquarters with the Army of the Potomac.  The plan of campaign was now very
simple.  Sherman, with the armies of the Ohio, the Cumberland and the Tennessee
100,000 strong, was to advance from Chattanooga to Atlanta against Joseph E.
Johnston, who had succeeded Bragg.  Grant, with the Army of the Potomac, was to
resume the campaign against Richmond, in which McClellan, Pope, Burnside, and
Hooker had all failed.

Both Grant and Sherman outnumbered their opponents, Lee and Johnston, two to
one ; but the advantage was not so great as the size of their armies would
indicate.  Sherman was to move through a hostile country, with his base of
supplies at Louisville, Kentucky, hundreds of miles away.  Thus leaving an
ever-lengthening line of posts to be guarded in his rear; while Grant was
assuming the offensive on soil which he had never trodden before, but every
inch of which was familiar to Lee's veterans.

~sTHE WILDERNESS CAMPAIGN~
On the fourth of May, 1864, Grant's army crossed the Rapidan, and began to
fight its way through the Wilderness, where Hooker had been defeated in the
battle of Chancellorsville just a year earlier.  Though his losses were heavy
(17,500 men in the Wilderness fights), Grant turned his face steadily toward
Richmond.  `I propose to fight it out on this line,' he wrote Halleck, `if it
takes all summer.'

At Cold Harbor (June 3) he attacked Lee's strongly fortified position in front,
and lost 7000 men in an hour, in an assault almost as rash as Burnside's at
Fredericksburg.  After this awful battle, Grant led the Army of the Potomac
down to the James River to renew the attack on Richmond from the south.  In the
Wilderness campaign of forty days, from the Rapidan to the James, Grant had
lost 55,000 men (almost as many as Lee had in his entire army), but he had at
least shown Lee the novel sight of a Union commander who did not retreat when
he was repulsed or rest when he was victorious.

Sherman left Chattanooga two days after Grant crossed the Rapidan (May 6).
Mile by mile he forced Johnston back, until by the middle of July he was in
sight of Atlanta.  Jefferson Davis replaced Johnston by Hood, but it was of no
avail.  Sherman beat Hood in several engagements before Atlanta, and entered
the city on the third of September, 1864.

~sTHE PRESIDENTIAL CAMPAIGN OF 1864~
While Grant was fighting his way through the Wilderness, and Sherman was slowly
advancing on Atlanta, the national conventions met to nominate candidates for
the presidential election of 1864.  Secretary Chase was ambitious for the
Republican nomination, and when one of his friends in Congress published a
circular in his behalf, he confessed his ambition to Lincoln, who generously
refused to consider it a reason for removing Chase from the head of the
Treasury Department.  Chase was able, but he was also very pompous and
conceited, and needed little persuasion to believe that he was indispensable to
the country's salvation.  His surprise and chagrin were, therefore, great when
his canvass fell flat.  He withdrew in February, and on June 7 Lincoln was
nominated by the convention at Baltimore.  The Democrats met at Chicago (August
29) and nominated General McClellan.

All through the summer of 1864 there was doubt and discouragement in the
Republican ranks. Grant's Wilderness campaign brought no comfort to the
administration.  Lincoln himself at one period had no hope of being re-elected.
 But the autumn brought changes in the Unionist fortunes.  In August, Admiral
Farragut sailed into the harbor of Mobile, Alabama, by an exploit as daring as
the running of the New Orleans forts, and deprived the Confederacy of its last
stronghold on the Gulf of Mexico.  In September, Sherman entered Atlanta after
a four months campaign against Johnston and Hood.  And in October, Sheridan, by
his wonderful ride up the Shenandoah valley literally turned defeat into
victory and saved Washington from the raid of General Early's cavalry.

These Union victories were the most powerful campaign arguments for the
Republican cause.  `Sherman and Farragut,' cried Seward, `have knocked the
bottom out of the Chicago platform.'  Lincoln was re-elected in November by an
electoral vote of 212 to 21, and a popular majority of nearly 500,000.  The
election meant the endorsement by the people of the North of Lincoln's policy
of continuing the war until the South recognized the supremacy of the national
government in Washington.

~sSHERMAN'S MARCH TO THE SEA~
Before the year 1864 ended, more good news came from the seat of war.  When
Atlanta fell, Hood, thinking to draw Sherman back from further invasion of
Georgia, and at the same time to regain Tennessee, made a dash northward
against Thomas.  Sherman trusted the reliable Thomas to take care of Tennessee,
and, boldly severing all connection with his base of supplies, started on his
famous march `from Atlanta to the sea', 300 miles across the state of Georgia.

He met with no resistance.  His troops lived on the fat of the land.  The newly
gathered harvests of corn and grain, abundance of chickens, turkeys, ducks,
pigs, and sweet potatoes.  Sherman entered on the march with a grim
determination to make the state of Georgia `an example to rebels,' and he
carried out his threat.  Railroads were torn up, public buildings, depots, and
machine shops burned, stores of cotton destroyed, 10,000 mules and horses
taken, and the military resources of the state damaged beyond repair

Reaching the coast in December, Sherman easily broke through the weak defenses
of Savannah, and on Christmas eve President Lincoln read a telegram from him
announcing `as, a Christmas gift the city of Savannah, with 150 heavy guns,
plenty of ammunition, and about 25,000 bales of cotton.'

~sTHOMAS'S VICTORY AT NASHVILLE~
Meanwhile the complete success of Sherman's campaign was ensured by the failure
of Hood's plan to dislodge Thomas from Nashville.  On the fifteenth of
December, before Nashville, he almost annihilated Hood's army and drove the
remnants out of Tennessee.  The battle of Nashville was the deathblow of the
Confederacy west of the Alleghenies.  Virginia and the Carolinas alone were
left to subdue.

Before the campaign of 1865 opened, there was an attempt to close the war by
diplomacy.  On February 3, 1865, Vice President Stephens of the Confederacy,
with two other commissioners, met President Lincoln and Secretary Seward on
board a United States vessel, at Hampton Roads, to discuss terms of peace.  But
as Lincoln would listen to no terms whatever except on the basis of a re-united
country, the conference came to naught.  The Southern commissioners were
pleased to interpret Lincoln's terms as nothing less than `unconditional
submission to the mercy of the conquerors.'

~sTHE FALL OF RICHMOND~
The next month the Army of the Potomac renewed its operations against Richmond.
 The stronghold of Petersburg, to the south, fell on Sunday, April 2.
Jefferson Davis was at worship in St. Paul's church in Richmond, when news was
brought that the city could no longer be held.  Hastily collecting his papers,
he fled with his cabinet southward.  On the third of April the Union troops
entered the city, followed the next day by President Lincoln, who spoke only
words of conciliation and kindness in `the enemy's capital'.  Lee, with his
dwindling army, moved westward toward the mountains, but Grant followed him
hard, while Sheridan's cavalry encircled his forces.  Brought to a standstill,
Lee consented to listen to Grant's terms for surrender.

~sLEE'S SURRENDER~
The two great generals met in a farmhouse at Appomattox, on the ninth of April,
1865.  Lee, the vanquished, in full uniform, with a jeweled sword at his side;
Grant, the victor, in the dusty fatigue coat of a common soldier, with only the
lieutenant general's stars on his shoulders.  After a few minutes of courteous
conversation recalling the days of their old comradeship in arms in the Mexican
War, Grant wrote out the terms of surrender.  They were generous, as befitted
the reconciliation of brother Americans.

The Army of Northern Virginia was to lay down its arms, but the officers were
to retain their horses and side arms, and even the cavalrymen and artillerymen
were to be allowed to keep their horses.  `They will need them for the spring
plowing,' said Grant, with his wonderful simplicity.  Lee accepted the terms
with sorrowing gratitude, and surrendered his army of 26,765 men.  When the
Union soldiers heard the good news they began to fire salutes, but Grant
stopped them, saying, `The war is over; the rebels are our countrymen again.'
Lee had hinted that his men were hungry, and Grant immediately ordered the
distribution of 25,000 rations to the Confederate army.

~sTHE COLLAPSE OF THE CONFEDERACY~
With the fall of Richmond and the surrender of Lee's army the Confederacy
collapsed.  It is a marvel that it fought through the last year of the war.
For the South was brought to the point of actual destitution.  The paper money
which the Confederacy issued had depreciated so much that it took $1000 to buy
a barrel of flour and $30 to buy a pound of tea.  Its credit was dead in Europe
and its bonds were worthless.  When the blockade of their ports stopped the
export of cotton, the Southerners planted their fields with corn and grain.
But the lack of means of transportation made it almost impossible to distribute
the products of the farms to the soldiers at the front.

While Sherman's army was reveling in the abundance of the farms and harvests of
central Georgia, the knapsacks found on the poor fellows who fell in the
defense of Richmond contained only scanty rations of corn bread and bacon

Friday, the fourteenth of April, 1865, was the fourth anniversary of the
surrender of Fort Sumter.  A great celebration was held at Charleston, and
General Robert Anderson raised above the fort the same tattered flag which he
had hauled down after Beauregard's bombardment in 1861. Flowers were strewn in
his path by the liberated slaves.  He spoke at the banquet held that evening in
Charleston, and the echoes of his voice reached a grave over which stood a
marble stone engraved with the single word `Calhoun.'

~sTHE ASSASSINATION OF THE PRESIDENT~
On the evening of the same day President Lincoln was sitting in a box at Ford's
theater in Washington when an actor named Booth stepped into the box and shot
the President in the back of the head.  Lincoln was carried unconscious to a
private house across the street and medical aid was summoned.  Early in the
morning of the fifteenth of April surrounded by his prostrated family and
official friends, Abraham Lincoln died.  Stanton, the great Secretary of War,
pronounced Abraham Lincoln's best eulogy when he stood with streaming eyes by
the bedside of the martyred President and murmured with choking voice, `Now he
belongs to the ages.'
@@@
