'===========================================================================
' Subject: BOXES W/MOUSE CONTROL              Date: 10-16-96 (09:02)       
'  Author: Brian Flanagan                     Code: PB                     
'  Origin: comp.lang.basic.misc             Packet: GAMES.ABC
'===========================================================================
'I wrote this game last night in about an hour in PowerBasic.  The code is
'Public Domain.  Enjoy!

'Brianster

' The object of DemonBox is to turn all of the yellow boxes into blue boxes.
' You change a box's color by left-clicking on it.  If it is yellow, it
' blue and vice versa.  When you change on box's color, you change the color
' of the box directly above, below, to the right, and to the left of it as
' well. You win the game when all of the boxes are blue.

' Right-clicking exits the game.

' Initialize mouse.
ms% = MouseInitialize%
IF NOT ms% THEN
  PRINT "No Mouse, pal."
  END
END IF


randomize timer

boxoff?=9
boxon?=14

' Set up the grid.
type gridtype
   litup as byte
   xloc as integer
   yloc as integer
end type

dim grid(9,9) as shared gridtype
for x%=0 to 9
   for y%=0 to 9
      grid(x%,y%).xloc=(x%+1)*20+40
      grid(x%,y%).yloc=(y%)*20
      grid(x%,y%).litup=int(rnd*2)
   next y%
next x%

reg 1,&h13
call interrupt &h10
def seg=&ha000

' Display grid.
for x%=0 to 9
   for y%=0 to 9
      if grid(x%,y%).litup=1 then
         for x2%=0 to 18
           for y2%=0 to 18
              poke (grid(x%,y%).yloc+y2%)*320+grid(x%,y%).xloc+x2%,boxon?
           next y2%
         next x2%
      else
         for x2%=0 to 18
           for y2%=0 to 18
              poke (grid(x%,y%).yloc+y2%)*320+grid(x%,y%).xloc+x2%,boxoff?
           next y2%
         next x2%
      end if
   next y%
next x%

' Begin game loop.

MouseShowCursor
gameover%=0

do

   ' Get user input.
      MouseInformation rb%, lb%, mxloc%, myloc%
      mxloc%=mxloc%/2

   ' Validate input.
      if lb%=1 then
         row%=int((mxloc%-60)/20)
         column%=int(myloc%/20)

      MouseHideCursor

      ' Change the lit status of selected box and surrounding boxes.
         ChangeBox row%,column%
         ChangeBox row%+1,column%
         ChangeBox row%-1,column%
         ChangeBox row%,column%+1
         ChangeBox row%,column%-1

      MouseShowCursor

      ' Check to see if player has cleared the board.
      flag%=0
      for x%=0 to 9
         for y%=0 to 9
            if grid(x%,y%).litup=1 then flag%=1
         next y%
      next x%
      if flag%=0 then gameover%=1

      ' Loop until the left button is released.
      do
         lb%=0
         MouseInformation dummy1%, lb%, dummy2%, dummy3%
      loop until lb%=0

   end if

   if rb%=1 then gameover%=1

loop while gameover%=0

reg 1,&h03
call interrupt &h10
def seg
end

SUB ChangeBox(r%,c%)

shared boxoff?,boxon?

   ' Change the lit status of one of the boxes.
      if c%>=0 and c%<=9 and r%>=0 and r%<=9 then
         if grid(r%,c%).litup=1 then
            grid(r%,c%).litup=0
            for x2%=0 to 18
              for y2%=0 to 18
                 poke (grid(r%,c%).yloc+y2%)*320+grid(r%,c%).xloc+x2%,boxoff?
              next y2%
            next x2%
         else
            grid(r%,c%).litup=1
            for x2%=0 to 18
              for y2%=0 to 18
                 poke (grid(r%,c%).yloc+y2%)*320+grid(r%,c%).xloc+x2%,boxon?
              next y2%
            next x2%
         end if
      end if

END SUB


SUB MouseInformation (Rgt%, lft%, Rw%, Col%)

   reg 1, 3
   call interrupt &h33
   SELECT CASE reg(2)
      CASE 1
         lft% = 1
      CASE 2
         Rgt% = 1
      CASE 3
         lft% = 1
         Rgt% = 1
   END SELECT

   Rw% = reg(3)
   Col% = reg(4)

END SUB

FUNCTION MouseInitialize%

   reg 1, 0
   CALL interrupt &h33
   MouseInitialize% = reg(1)

END FUNCTION

SUB MouseShowCursor

   reg 1, 1
   call interrupt &h33

END SUB

SUB MouseHideCursor

   reg 1, 2
   call interrupt &h33

END SUB
