DECLARE SUB MoveEx (Movement$, X, Y)
DECLARE SUB Move (SP, Movement$, X, Y)
DECLARE SUB MapS (SP, map(), Movement$, X, Y)
DECLARE SUB MovementEx (Movement$, X, Y)
DECLARE SUB SSetup ()
DECLARE SUB Scroll (Movement$, SP)
DECLARE SUB DC (X, Y, SP)
DECLARE SUB Save (map())
DECLARE SUB Load (map())
DECLARE SUB DLF (map())
DIM map(28, 24)

'A Kevin Kohler Preduction
'Last revised 12/7/96 By:Kevin B. Kohler

SP = 0
X = 90
Y = 90
SCREEN 12

LINE (X + 9, Y + 9)-(X + 9, Y - 10)
LINE -(X - 10, Y - 10)
LINE -(X - 10, Y + 9)
LINE -(X + 9, Y + 9)
CALL SSetup

LINE (79, 0)-(79, 479)
'LINE (0, 340)-(20, 360), 6, BF
'LINE (20, 355)-(10, 355), 7
'LINE (10, 355)-(10, 360), 7
'LINE (0, 350)-(10, 350), 7
'LINE (10, 355)-(10, 340), 7
'LINE (10, 345)-(20, 345), 7
'LINE (0, 340)-(10, 340), 7


DO
  CALL Move(SP, Movement$, X, Y)
 
  IF Movement$ = " " THEN
    CALL MapS(SP, map(), Movement$, X, Y)
  END IF
 
  IF Movement$ = "s" THEN
    CALL Save(map())
  END IF

  IF Movement$ = "l" THEN
    CALL Load(map())
  END IF

LOOP UNTIL Movement$ = CHR$(27)
SCREEN 12

SUB DC (X, Y, SP)
  LINE (X - 10, Y - 10)-(X + 10, Y + 10), 0, BF
  IF SP = 3 THEN
    LINE (X - 10, Y - 10)-(X + 10, Y + 10), 6, BF
    LINE (X + 10, Y + 5)-(X, Y + 5), 7
    LINE (X, Y + 5)-(X, Y + 10), 7
    LINE (X - 10, Y)-(X, Y), 7
    LINE (X, Y + 5)-(X, Y - 10), 7
    LINE (X, Y - 5)-(X + 10, Y - 5), 7
    LINE (X - 10, Y - 10)-(X, Y - 10), 7
  END IF
  IF SP = 1 THEN
    LINE (X - 10, Y - 10)-(X - 5, Y - 5), 7
    LINE (X - 5, Y - 5)-(X + 5, Y - 5), 7
    LINE (X + 5, Y - 5)-(X + 10, Y - 10), 7
    LINE (X + 10, Y - 10)-(X - 10, Y - 10), 7
    LINE (X - 10, Y - 10)-(X - 10, Y + 10), 7
    LINE (X - 10, Y + 10)-(X - 5, Y + 5), 7
    LINE (X - 5, Y + 5)-(X - 5, Y - 5), 7
    LINE (X - 5, Y + 5)-(X + 5, Y + 5), 7
    LINE (X + 5, Y + 5)-(X + 5, Y - 5), 7
    LINE (X + 5, Y + 5)-(X + 10, Y + 10), 7
    LINE (X + 10, Y + 10)-(X + 10, Y - 10), 7
    LINE (X + 10, Y + 10)-(X - 10, Y + 10), 7
  END IF
  IF SP = 2 THEN
    LINE (X - 10, Y - 10)-(X + 10, Y + 10), 2, BF
    LINE (X + 10, Y + 10)-(X - 10, Y - 10), 4
    LINE (X - 10, Y)-(X + 10, Y), 4
    LINE (X, Y - 10)-(X, Y + 10), 4
    LINE (X - 10, Y + 10)-(X + 10, Y - 10), 4
  END IF
  IF SP = 4 THEN
    LINE (X - 10, Y - 10)-(X + 10, Y + 10), 14, BF
    LINE (X - 6, Y - 10)-(X + 6, Y - 6), 6, BF
    LINE (X + 6, Y - 8)-(X + 2, Y - 6), 1, BF
    LINE (X, Y - 6)-(X - 4, Y - 8), 1, BF
  END IF
  IF SP = 6 THEN
    LINE (X - 10, Y - 10)-(X + 10, Y + 10), 7, BF
    LINE (X - 6, Y - 10)-(X + 6, Y - 6), 11, BF
    LINE (X + 6, Y - 8)-(X + 2, Y - 6), 1, BF
    LINE (X, Y - 6)-(X - 4, Y - 8), 1, BF
  END IF

END SUB

SUB DLF (map())
  FOR Times2 = 1 TO 24
    FOR Times = 1 TO 28
      Place = ((Times + 4) * 20) - 10
      Place2 = ((Times2) * 20) - 10
      IF map(Times, Times2) = 3 THEN
        LINE (Place - 9, Place2 - 9)-(Place + 9, Place2 + 9), 6, BF
        LINE (Place + 9, Place2 + 5)-(Place, Place2 + 5), 7
        LINE (Place, Place2 + 5)-(Place, Place2 + 9), 7
        LINE (Place - 9, Place2)-(Place, Place2), 7
        LINE (Place, Place2 + 5)-(Place, Place2 - 9), 7
        LINE (Place, Place2 - 5)-(Place + 9, Place2 - 5), 7
        LINE (Place - 9, Place2 - 9)-(Place, Place2 - 9), 7
      END IF
      IF map(Times, Times2) = 1 THEN
        LINE (Place - 10, Place2 - 10)-(Place - 5, Place2 - 5), 7
        LINE (Place - 5, Place2 - 5)-(Place + 5, Place2 - 5), 7
        LINE (Place + 5, Place2 - 5)-(Place + 10, Place2 - 10), 7
        LINE (Place + 10, Place2 - 10)-(Place - 10, Place2 - 10), 7
        LINE (Place - 10, Place2 - 10)-(Place - 10, Place2 + 10), 7
        LINE (Place - 10, Place2 + 10)-(Place - 5, Place2 + 5), 7
        LINE (Place - 5, Place2 + 5)-(Place - 5, Place2 - 5), 7
        LINE (Place - 5, Place2 + 5)-(Place + 5, Place2 + 5), 7
        LINE (Place + 5, Place2 + 5)-(Place + 5, Place2 - 5), 7
        LINE (Place + 5, Place2 + 5)-(Place + 10, Place2 + 10), 7
        LINE (Place + 10, Place2 + 10)-(Place + 10, Place2 - 10), 7
        LINE (Place + 10, Place2 + 10)-(Place - 10, Place2 + 10), 7
      END IF
      IF map(Times, Times2) = 2 THEN
        LINE (Place - 10, Place2 - 10)-(Place + 10, Place2 + 10), 2, BF
        LINE (Place + 10, Place2 + 10)-(Place - 10, Place2 - 10), 4
        LINE (Place - 10, Place2)-(Place + 10, Place2), 4
        LINE (Place, Place2 - 10)-(Place, Place2 + 10), 4
        LINE (Place - 10, Place2 + 10)-(Place + 10, Place2 - 10), 4
      END IF
      IF map(Times, Times2) = 4 THEN
        X = Place
        Y = Place2
        LINE (Place - 9, Place2 - 9)-(Place + 9, Place2 + 9), 14, BF
        LINE (Place - 6, Place2 - 9)-(Place + 6, Place2 - 6), 6, BF
        LINE (Place + 6, Place2 - 8)-(Place + 2, Place2 - 6), 1, BF
        LINE (Place, Place2 - 6)-(Place - 4, Place2 - 8), 1, BF
      END IF
      IF map(Times, Times2) = 5 THEN
        LINE (Place - 9, Place2 - 9)-(Place + 9, Place2 + 9), 1, BF
      END IF
    NEXT Times
  NEXT Times2
END SUB

SUB Load (map())
  PRINT "Input the name of the file to load";
  INPUT LoadFile$
  OPEN LoadFile$ FOR INPUT AS #1
  FOR Times2 = 1 TO 24
    FOR Times = 1 TO 28
      INPUT #1, map(Times, Times2)
    NEXT Times
  NEXT Times2
  CLOSE #1
  CALL DLF(map())
END SUB

SUB MapS (SP, map(), Movement$, X, Y)
  YR = ((X - 10) / 20) - 3
  XR = ((Y - 10) / 20) + 1
  map(YR, XR) = SP
  CALL DC(X, Y, SP)
END SUB

SUB Move (SP, Movement$, X, Y)
  DO
  Movement$ = INKEY$
  IF LEN(Movement$) = 2 THEN
    Movement$ = MID$(Movement$, 2, 1)
  END IF
  LOOP UNTIL Movement$ = CHR$(77) OR Movement$ = CHR$(75) OR Movement$ = CHR$(80) OR Movement$ = CHR$(72) OR Movement$ = "]" OR Movement$ = "[" OR Movement$ = CHR$(27) OR Movement$ = "s" OR Movement$ = " " OR Movement$ = "l"
  IF Movement$ = CHR$(77) OR Movement$ = CHR$(75) OR Movement$ = CHR$(80) OR Movement$ = CHR$(72) THEN
    CALL MoveEx(Movement$, X, Y)
  END IF
  IF Movement$ = "[" OR Movement$ = "]" THEN
    CALL Scroll(Movement$, SP)
  END IF
END SUB

SUB MoveEx (Movement$, X, Y)
  LINE (X + 9, Y + 9)-(X + 9, Y - 10), 0
  LINE -(X - 10, Y - 10), 0
  LINE -(X - 10, Y + 9), 0
  LINE -(X + 9, Y + 9), 0
  IF Movement$ = CHR$(77) AND X < 630 THEN X = X + 20
  IF Movement$ = CHR$(75) AND X > 90 THEN X = X - 20
  IF Movement$ = CHR$(80) AND Y < 470 THEN Y = Y + 20
  IF Movement$ = CHR$(72) AND Y > 10 THEN Y = Y - 20
  LINE (X + 9, Y + 9)-(X + 9, Y - 10)
  LINE -(X - 10, Y - 10)
  LINE -(X - 10, Y + 9)
  LINE -(X + 9, Y + 9)
END SUB

SUB Save (map())
  PRINT "Input the name of the save file";
  INPUT SaveFile$
  OPEN SaveFile$ FOR OUTPUT AS #1
  FOR Times2 = 1 TO 24
    FOR Times = 1 TO 28
      WRITE #1, map(Times, Times2)
    NEXT Times
  NEXT Times2
  CLOSE #1
END SUB

SUB Scroll (Movement$, SP)
  IF Movement$ = "]" THEN
    SP = SP + 1
  END IF
  IF Movement$ = "[" THEN
    SP = SP - 1
  END IF
  IF SP < 0 THEN SP = 9
  IF SP > 9 THEN SP = 0
  'LOCATE 28, 1
  'PRINT SP
  LINE (0, 340)-(20, 360), 0, BF
  IF SP = 3 THEN
    LINE (0, 340)-(20, 360), 6, BF
    LINE (20, 355)-(10, 355), 7
    LINE (10, 355)-(10, 360), 7
    LINE (0, 350)-(10, 350), 7
    LINE (10, 355)-(10, 340), 7
    LINE (10, 345)-(20, 345), 7
    LINE (0, 340)-(10, 340), 7
  END IF
  IF SP = 1 THEN
    LINE (0, 340)-(5, 345), 7
    LINE (5, 345)-(15, 345), 7
    LINE (15, 345)-(20, 340), 7
    LINE (20, 340)-(0, 340), 7
    LINE (0, 340)-(0, 360), 7
    LINE (0, 360)-(5, 355), 7
    LINE (5, 355)-(5, 345), 7
    LINE (5, 355)-(15, 355), 7
    LINE (15, 355)-(15, 345), 7
    LINE (15, 355)-(20, 360), 7
    LINE (20, 360)-(20, 340), 7
    LINE (20, 360)-(0, 360), 7
  END IF
  IF SP = 2 THEN
    LINE (0, 340)-(20, 360), 2, BF
    LINE (20, 360)-(0, 340), 4
    LINE (0, 350)-(20, 350), 4
    LINE (10, 340)-(10, 360), 4
    LINE (0, 360)-(20, 340), 4
  END IF
  IF SP = 4 THEN
    LINE (0, 340)-(20, 360), 14, BF
    LINE (4, 340)-(16, 344), 6, BF
    LINE (16, 342)-(12, 344), 1, BF
    LINE (10, 344)-(6, 342), 1, BF
  END IF
  IF SP = 6 THEN
    LINE (0, 340)-(20, 360), 7, BF
    LINE (4, 340)-(16, 344), 11, BF
    LINE (16, 342)-(12, 344), 1, BF
    LINE (10, 344)-(6, 342), 1, BF
  END IF

END SUB

SUB SSetup
  PRINT "(s)ave"
  PRINT
  PRINT "(l)oad"
  PRINT
  PRINT "([) Scroll"
  PRINT "Left"
  PRINT
  PRINT "(]) Scroll"
  PRINT "Right"
  PRINT
  PRINT "Space"
  PRINT "Place"
  PRINT
  PRINT "Direction"
  PRINT "Arrows"
  PRINT "Move"
  PRINT
  PRINT
  PRINT "Selected"
END SUB

