'  Helter Skelter - The Game
'
'  Version 1.02
'
'  Programmed by - Matt Zuchowski
'  (c) 1996 Dark Dreams Software
'
'
'  #######################################################################
'  #                                                                     #
'  #               Dark Dreams Software is now on the web!               #
'  #     http://www.geocities.com/SiliconValley/Pines/1732/index.html    #
'  #                  E-mail: liphilli@flemingc.on.ca                    #
'  #                           Visit us today!                           #
'  #                                                                     #
'  #######################################################################
'
'  Started - Monday, November 11, 1996
'  Finished - Version 1.00: Sunday, December 1, 1996
'           - Version 1.01: Monday, December 2, 1996
'           - Version 1.02: Wednesday, December 4, 1996
'  Credits -
'    Keyboard ISR - Steven Sensarn
'    DOS Delay - Kurt Kuzba
'    Sounds - Merlin R. Null
'
'  Object of the game -
'
'  You are an investigator for the LAPD.  It is 1969 and you have been
'  assigned to  collect evidence for the Charles  Manson trial.  It is
'  your duty to search the house of Sharon  Tate, picking up scraps of
'  evidence as you  go along.  But beware, there are lots of reporters
'  around  who  will ask  you questions  about  the  case.  Should you
'  answer incorrectly  to any of  their questions  your ranking  as an
'  investigator will decrease.  Once you have answered too many of the
'  questions incorrectly you will be  taken off  the case.  Good luck!
'
'  NOTE: In order to win  you must have collected  at least 75% of all
'  the evidence in the house.  You must also have found  the gun.  You
'  will not win the game correctly without doing these two things.
'

'  The following are the sub declarations.
DECLARE SUB LoadData ()
DECLARE SUB Load.Level ()
DECLARE SUB LoadGraphics ()
DECLARE SUB Check.Event ()
DECLARE SUB Get.Visible ()
DECLARE SUB Show.Visible ()
DECLARE SUB ShowCaption ()
DECLARE SUB Show.Logo ()
DECLARE SUB Show.Title ()
DECLARE SUB Get.PlayerPos ()
DECLARE SUB Title.Menu ()
DECLARE SUB Quick.Title ()
DECLARE SUB Tile.Back ()
DECLARE SUB Animate.Sprites ()
DECLARE SUB Options ()
DECLARE SUB Get.Screen ()
DECLARE SUB Show.Enemy ()
DECLARE SUB Move.Enemy ()
DECLARE SUB Erase.Enemy ()
DECLARE SUB Get.Reporter ()
DECLARE SUB New.Game ()
DECLARE SUB Intro ()
DECLARE SUB High.Scores ()
DECLARE SUB Game.Over ()
DECLARE SUB Get.Level ()
DECLARE SUB Get.NewLevel ()
DECLARE SUB Finish ()
DECLARE SUB Show.Rank ()
DECLARE SUB Put.Credit (Text$, XPos%, YPos%, Colour%)
DECLARE SUB SetVect (S AS INTEGER, O AS INTEGER, I AS INTEGER)
DECLARE SUB GetVect (S AS INTEGER, O AS INTEGER, I AS INTEGER)
DECLARE SUB Keyboard.In (OldSeg AS INTEGER, OldOff AS INTEGER)
DECLARE SUB Keyboard.Out (OldSeg AS INTEGER, OldOff AS INTEGER)
DECLARE SUB Delay (seconds!)

'$DYNAMIC

DEFINT A-Z                              ' For faster game play.

'  The following are data arrays.
DIM SHARED Level1(50, 50)               ' Holds level data.
DIM SHARED Level2(50, 50)
DIM SHARED Level.Old(50, 50)            ' Holds inactive level data.
DIM SHARED Level.Temp(50, 50)           ' Holds temporary data.
DIM SHARED Level(50, 50)                ' Holds active level data.
DIM SHARED Visible(8, 8)                ' Array to hold visible level data.
DIM SHARED PlayerPos(1, 2)              ' Array for player position.
DIM SHARED EnemyPos(20, 2)              ' Holds enemy position data.
DIM SHARED EnemyDir(20)                 ' Holds enemy direction data.
DIM SHARED EnemyMove(20)                ' Array to hold enemy animation type.
DIM SHARED IntroText(9) AS STRING       ' Text for intro.
DIM SHARED EndText(6) AS STRING         ' Text for ending.
DIM SHARED BadEndText(8) AS STRING      ' Text for bad ending.
DIM SHARED Tune1(15) AS STRING          ' Small intro tune.
DIM SHARED Question$(0 TO 100)          ' Array to hold all of the possible
                                        ' questions.
DIM SHARED Answers(0 TO 12)             ' Array to hold all of the correct
                                        ' answers to the questions.

'  The following are graphic arrays.
DIM SHARED Tile(150)                    ' Array for background tile patterns.
DIM SHARED PlayerUp(150)                ' The four possible player positions
DIM SHARED PlayerDown(150)              ' are held in these arrays.
DIM SHARED PlayerLeft(150)
DIM SHARED PlayerRight(150)
DIM SHARED PlayerUp2(150)               ' Player animations.
DIM SHARED PlayerDown2(150)
DIM SHARED PlayerLeft2(150)
DIM SHARED PlayerRight2(150)
DIM SHARED PressUp(150)                 ' The four possible reporter
DIM SHARED PressDown(150)               ' positions are held in these arrays.
DIM SHARED PressLeft(150)
DIM SHARED PressRight(150)
DIM SHARED PressUp2(150)                ' Reporter animations.
DIM SHARED PressDown2(150)
DIM SHARED PressLeft2(150)
DIM SHARED PressRight2(150)
DIM SHARED GhostUp(150)                 ' The four possible ghost positions
DIM SHARED GhostDown(150)               ' are held in these arrays.
DIM SHARED GhostLeft(150)
DIM SHARED GhostRight(150)
DIM SHARED GhostUp2(150)                ' Ghost animations.
DIM SHARED GhostDown2(150)
DIM SHARED GhostLeft2(150)
DIM SHARED GhostRight2(150)
DIM SHARED Loot1(150)                   ' The four types of evidence to
DIM SHARED Loot2(150)                   ' collect are held in these arrays.
DIM SHARED Loot3(150)
DIM SHARED Loot4(150)
DIM SHARED Candle(150)                  ' Another graphic.
DIM SHARED Wall1(150)                   ' All the types of impassable walls
DIM SHARED Wall2(150)                   ' are held in these arrays.
DIM SHARED Wall1B(150)
DIM SHARED Wall2B(150)
DIM SHARED Door1(150)                   ' All the types of doors are held in
DIM SHARED Door2(150)                   ' these arrays.
DIM SHARED SilverKey(150)               ' The types of keys are held in these
DIM SHARED GoldKey(150)                 ' arrays.
DIM SHARED Stair(150)                   ' Graphic for stairs.
DIM SHARED Pointer1(35)                 ' These arrays hold pointer graphics.
DIM SHARED Pointer2(35)
DIM SHARED Heart(35)                    ' Holds rank point graphic.
DIM SHARED Press(4800)                  ' Holds reporter picture.
DIM SHARED GameOver(3400)               ' Holds game over picture.
DIM SHARED Logo(7400)                   ' Hold company logo.
DIM SHARED Title(16000)                 ' Hold game title.
DIM SHARED Pic(16000)                   ' Used for loading spare graphics.

'  The following are global variables.
DIM SHARED RawKey AS INTEGER            ' Used for keyboard ISR.
DIM SHARED Old.Isr.Seg AS INTEGER
DIM SHARED Old.Isr.Off AS INTEGER
DIM SHARED Turn AS INTEGER              ' Holds data to find what enemy to
                                        ' move.
DIM SHARED DoIt AS INTEGER              ' Slows down enemy movement.
DIM SHARED No.Enemies AS INTEGER        ' Number of enemies in a level.
DIM SHARED Tile.Type AS INTEGER         ' Type of tile to use for background.
DIM SHARED Start.Game AS INTEGER        ' These variables check to see if
DIM SHARED Quit.Game AS INTEGER         ' user is quiting or starting.
DIM SHARED Score AS INTEGER             ' Variable to keep score.
DIM SHARED Rank AS INTEGER              ' Used to track no. of questions that
                                        ' the player has answered incorrectly.
DIM SHARED Stairs AS INTEGER            ' Checks if player has encountered
                                        ' stairs.
DIM SHARED Press.Hit AS INTEGER         ' Variable to check if reporter has
                                        ' been encountered.
DIM SHARED Silver.Key AS INTEGER        ' These variables hold the data for
DIM SHARED Gold.Key AS INTEGER          ' the amount of keys.
DIM SHARED Current.Level AS INTEGER     ' Used to check what level player is
                                        ' on.
DIM SHARED Done AS INTEGER              ' Variable to check if player has
                                        ' exited house.
DIM SHARED Percent AS INTEGER
DIM SHARED Items AS INTEGER             ' Evidence player has collected.
DIM SHARED PlayerDir AS INTEGER         ' This holds data which shows the
                                        ' direction the player is facing.
                                        ' 1 = N, 2 = E, 3 = S, 4 = W.
DIM SHARED GunFound AS INTEGER          ' Used to check if gun was found.
DIM SHARED Noise AS STRING              ' Used to play sounds.
DIM SHARED HiScore AS STRING            ' Variable to hold high score data.

'  The following variables hold PLAY data.
DIM SHARED Item$
DIM SHARED Item2$
DIM SHARED Door$
DIM SHARED Reporter$
DIM SHARED Correct$
DIM SHARED Wrong$
DIM SHARED Over$
DIM SHARED Ghost$

CONST Total.Items = 189                 ' Total amount of collectable
                                        ' evidence.

CLS                                     ' Clears the screen.

CALL LoadData                           ' Sub to load data into arrays.
CALL Load.Level                         ' Sub to load level data.
CALL LoadGraphics                       ' Sub to load graphics into arrays.
CALL ShowCaption                        ' Sub to show caption.

SCREEN 7, , 0, 1                        ' Switches to 320x200x16 mode.

CALL Show.Logo                          ' This sub shows the Dark Dreams
                                        ' Software logo.
CALL Show.Title                         ' This sub shows the game title.
CALL Title.Menu                         ' This sub initiates the main menu
                                        ' screen.

IF Quit.Game = 1 THEN                   ' Exits if player has chosen to quit.
  CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)
  SYSTEM
END IF

'  These lines initialize the menu and levels.
Turn = 1: Current.Level = 1
CALL Get.Level                          ' Sub to load current level data into
                                        ' level variable.
CALL Get.PlayerPos                      ' This sub gets the initial player
                                        ' position.
FOR X = 5 TO 46
  FOR Y = 5 TO 46
    Level.Old(X, Y) = Level2(X, Y)
  NEXT Y
NEXT X
CALL Intro                              ' Runs short intro.
CALL Tile.Back                          ' Creates a backround tile pattern.
CALL Get.Screen                         ' Creates side view.
CALL Get.Visible                        ' These lines get and display the
CALL Show.Visible                       ' part of the level that is visible
                                        ' on the screen.

Start.Game = 0
RANDOMIZE TIMER

'  These lines are control keys.
DO
  Press.Hit = 0
  CALL Move.Enemy
  IF Current.Level = 2 THEN CALL Move.Enemy
  SELECT CASE RawKey
  CASE IS = 72
    IF PlayerPos(1, 2) > 5 THEN
      PlayerDir = 1
      CALL Check.Event
      IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) <> 11 THEN
        IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) <> 3 THEN
          IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) <> 1 THEN
            IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) <> 9 THEN
              IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) <> 14 THEN
                IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) <> 15 THEN
                  IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) <> 12 THEN
                    IF Press.Hit = 0 THEN
                      Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 0
                      PlayerPos(1, 2) = PlayerPos(1, 2) - 1
                      Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 4
                      CALL Get.Visible
                      CALL Show.Visible
                      CALL Animate.Sprites
                    END IF
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END IF
  CASE IS = 80
    IF PlayerPos(1, 2) < 45 THEN
      PlayerDir = 3
      CALL Check.Event
      IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) <> 11 THEN
        IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) <> 3 THEN
          IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) <> 1 THEN
            IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) <> 9 THEN
              IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) <> 14 THEN
                IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) <> 15 THEN
                  IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) <> 12 THEN
                    IF Press.Hit = 0 THEN
                      Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 0
                      PlayerPos(1, 2) = PlayerPos(1, 2) + 1
                      Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 4
                      CALL Get.Visible
                      CALL Show.Visible
                      CALL Animate.Sprites
                    END IF
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END IF
  CASE IS = 75
    IF PlayerPos(1, 1) > 5 THEN
      PlayerDir = 2
      CALL Check.Event
      IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) <> 11 THEN
        IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) <> 3 THEN
          IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) <> 1 THEN
            IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) <> 9 THEN
              IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) <> 14 THEN
                IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) <> 15 THEN
                  IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) <> 12 THEN
                    IF Press.Hit = 0 THEN
                       Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 0
                       PlayerPos(1, 1) = PlayerPos(1, 1) - 1
                       Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 4
                       CALL Get.Visible
                       CALL Show.Visible
                       CALL Animate.Sprites
                    END IF
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END IF
  CASE IS = 77
    IF PlayerPos(1, 1) < 45 THEN
      PlayerDir = 4
      CALL Check.Event
      IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) <> 11 THEN
        IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) <> 3 THEN
          IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) <> 1 THEN
            IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) <> 9 THEN
              IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) <> 14 THEN
                IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) <> 15 THEN
                  IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) <> 12 THEN
                    IF Press.Hit = 0 THEN
                      Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 0
                      PlayerPos(1, 1) = PlayerPos(1, 1) + 1
                      Level(PlayerPos(1, 1), PlayerPos(1, 2)) = 4
                      CALL Get.Visible
                      CALL Show.Visible
                      CALL Animate.Sprites
                    END IF
                  END IF
                END IF
              END IF
            END IF
          END IF
        END IF
      END IF
    END IF
  CASE IS = 1
    CALL New.Game
  END SELECT
  IF Quit.Game = 1 THEN EXIT DO
  IF Rank <= 0 THEN
      CALL New.Game
    ELSEIF Stairs = 1 THEN
      Stairs = 0
      IF Current.Level = 1 THEN
          Current.Level = 2
        ELSEIF Current.Level = 2 THEN
          Current.Level = 1
      END IF
      CALL Get.NewLevel
      CALL Get.Visible
      CALL Show.Visible
    ELSEIF Done = 1 THEN
      CALL Finish
      CALL New.Game
  END IF
  Delay .001
LOOP

CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)  ' This sub turns keyboard ISR off.
SYSTEM

DATA "You  are an  investigator for the  LAPD."
DATA "It is 1969 and you have been assigned to"
DATA "collect evidence for the  Charles Manson"
DATA "trial.  It is  your  duty to  search the"
DATA "house  of  Sharon Tate,  picking  up any"
DATA "evidence that you can find.  Be ready to"
DATA "answer  questions  from  pesky reporters"
DATA "searching the house as well.  Good  luck"
DATA "detective!                              "

DATA "Congratulations! With  the evidence that"
DATA "you have  collected, Charles  Manson and"
DATA "his  followers  are   convicted   of the"
DATA "crimes  which they  have  commited.  For"
DATA "this,  you are  given a  promotion! Good"
DATA "work detective!                         "

DATA "Unfortunately, you  were unable to  find"
DATA "enough  evidence to  convict Manson  and"
DATA "his  followers.  The case is  declared a"
DATA "mistrial.  Looks  like you  will have to"
DATA "let  someone with more  experience  take"
DATA "over the case...                        "
DATA "                                        "
DATA "                The End                 "

REM $STATIC
SUB Animate.Sprites STATIC
  IF Player.Animate = 0 THEN
      IF PlayerDir = 1 THEN
          PUT (80, 80), PlayerUp2, PSET
        ELSEIF PlayerDir = 2 THEN
          PUT (80, 80), PlayerLeft2, PSET
        ELSEIF PlayerDir = 3 THEN
          PUT (80, 80), PlayerDown2, PSET
        ELSEIF PlayerDir = 4 THEN
          PUT (80, 80), PlayerRight2, PSET
      END IF
      Player.Animate = 1
    ELSEIF Player.Animate = 1 THEN
      IF PlayerDir = 1 THEN
          PUT (80, 80), PlayerUp, PSET
        ELSEIF PlayerDir = 2 THEN
          PUT (80, 80), PlayerLeft, PSET
        ELSEIF PlayerDir = 3 THEN
          PUT (80, 80), PlayerDown, PSET
        ELSEIF PlayerDir = 4 THEN
          PUT (80, 80), PlayerRight, PSET
      END IF
      Player.Animate = 0
  END IF
  PCOPY 0, 1
END SUB

SUB Check.Event
  '  This sub checks what type of block is in front of the player before the
  '  player can step on it.  Depending on the type of block, the sub acts
  '  accordingly.
  IF PlayerDir = 1 THEN
      IF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 2 THEN
          Score = Score + 10
          Items = Items + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 10 THEN
          Score = Score + 25
          Items = Items + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 5 THEN
          Score = Score + 50
          Items = Items + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 13 THEN
          Score = Score + 100
          Items = Items + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 7 THEN
          Silver.Key = Silver.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 8 THEN
          Gold.Key = Gold.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 1 THEN
          IF Silver.Key > 0 THEN
            Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 0
            Silver.Key = Silver.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
          END IF
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 9 THEN
          IF Gold.Key > 0 THEN
            Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 0
            Gold.Key = Gold.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
            Done = 1
          END IF
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 12 THEN
          IF Current.Level = 1 THEN
              Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
              CALL Show.Rank
              PCOPY 0, 1
          END IF
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) - 1) = 15 THEN
          Stairs = 1
      END IF
    ELSEIF PlayerDir = 2 THEN
      IF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 2 THEN
          Score = Score + 10
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 10 THEN
          Score = Score + 25
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 5 THEN
          Score = Score + 50
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 13 THEN
          GunFound = 1
          Score = Score + 100
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 7 THEN
          Silver.Key = Silver.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 8 THEN
          Gold.Key = Gold.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 1 THEN
          IF Silver.Key > 0 THEN
            Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 0
            Silver.Key = Silver.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
          END IF
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 9 THEN
          IF Gold.Key > 0 THEN
            Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 0
            Gold.Key = Gold.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
            Done = 1
          END IF
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 12 THEN
          IF Current.Level = 1 THEN
              Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
              CALL Show.Rank
              PCOPY 0, 1
          END IF
        ELSEIF Level(PlayerPos(1, 1) - 1, PlayerPos(1, 2)) = 15 THEN
          Stairs = 1
      END IF
    ELSEIF PlayerDir = 3 THEN
      IF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 2 THEN
          Score = Score + 10
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 10 THEN
          Score = Score + 25
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 5 THEN
          Score = Score + 50
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 13 THEN
          Score = Score + 100
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 7 THEN
          Silver.Key = Silver.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 8 THEN
          Gold.Key = Gold.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 1 THEN
          IF Silver.Key > 0 THEN
            Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 0
            Silver.Key = Silver.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
          END IF
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 9 THEN
          IF Gold.Key > 0 THEN
            Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 0
            Gold.Key = Gold.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
            Done = 1
          END IF
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 12 THEN
          IF Current.Level = 1 THEN
              Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
              CALL Show.Rank
              PCOPY 0, 1
          END IF
        ELSEIF Level(PlayerPos(1, 1), PlayerPos(1, 2) + 1) = 15 THEN
          Stairs = 1
      END IF
    ELSEIF PlayerDir = 4 THEN
      IF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 2 THEN
          Score = Score + 10
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 10 THEN
          Score = Score + 25
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 5 THEN
          Score = Score + 50
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 13 THEN
          Score = Score + 100
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item$)
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 7 THEN
          Silver.Key = Silver.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 8 THEN
          Gold.Key = Gold.Key + 1
          IF Noise = "ON " THEN PLAY "X" + VARPTR$(Item2$)
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 1 THEN
          IF Silver.Key > 0 THEN
            Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 0
            Silver.Key = Silver.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
          END IF
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 9 THEN
          IF Gold.Key > 0 THEN
            Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 0
            Gold.Key = Gold.Key - 1
            IF Noise = "ON " THEN PLAY "X" + VARPTR$(Door$)
            Done = 1
          END IF
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 12 THEN
          IF Current.Level = 1 THEN
              Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
              CALL Show.Rank
              PCOPY 0, 1
          END IF
        ELSEIF Level(PlayerPos(1, 1) + 1, PlayerPos(1, 2)) = 15 THEN
          Stairs = 1
    END IF
  END IF
END SUB

DEFSNG A-Z
SUB Delay (seconds!)
   DEF SEG = 0
   d& = FIX(seconds! * 18.20444444#)
   FOR t& = t& TO d&
     d% = PEEK(&H46C) AND 255
     WHILE d% = (PEEK(&H46C) AND 255): WEND
   NEXT
END SUB

DEFINT A-Z
SUB Erase.Enemy
  IF EnemyPos(Turn, 1) > PlayerPos(1, 1) - 4 AND EnemyPos(Turn, 1) < PlayerPos(1, 1) + 5 THEN
    IF EnemyPos(Turn, 2) > PlayerPos(1, 2) - 4 AND EnemyPos(Turn, 2) < PlayerPos(1, 2) + 5 THEN
      X = EnemyPos(Turn, 1) - (PlayerPos(1, 1) - 4)
      Y = EnemyPos(Turn, 2) - (PlayerPos(1, 2) - 4)
      LINE (X * 20, Y * 20)-((X * 20) + 20, (Y * 20) + 20), 0, BF
      LINE (20, 20)-(179, 179), 8, B
      LINE (21, 21)-(178, 178), 7, B
      LINE (22, 22)-(177, 177), 15, B
      LINE (23, 23)-(176, 176), 7, B
      PCOPY 0, 1
    END IF
  END IF
END SUB

SUB Finish
  CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)
  CLS
  IF Percent > 74 AND GunFound = 1 THEN
      DEF SEG = VARSEG(Pic(0))
      BLOAD "END.16", VARPTR(Pic(0))
      PUT (0, 0), Pic, PSET
      PCOPY 0, 1
      FOR I = 1 TO 6
        COLOR 8
        IF I + 19 < 24 THEN LOCATE I + 19 ELSE LOCATE 24
        PRINT EndText(I)
        PCOPY 0, 1
        Delay .5
        COLOR 7
        IF I + 19 < 24 THEN LOCATE I + 19 ELSE LOCATE 23
        PRINT EndText(I)
        PCOPY 0, 1
        Delay .5
        COLOR 15
        IF I + 19 < 24 THEN LOCATE I + 19 ELSE LOCATE 23
        PRINT EndText(I)
        PCOPY 0, 1
        Delay .5
        IF INKEY$ <> "" THEN EXIT FOR
      NEXT I
      WHILE INKEY$ = "": WEND
      CLS
      '  These are the credits.
        Put.Credit "CREDITS", 17, 12, 8
        Put.Credit "CREDITS", 17, 12, 7
        Put.Credit "CREDITS", 17, 12, 15
        Put.Credit "CREDITS", 17, 12, 7
        Put.Credit "CREDITS", 17, 12, 8
        Put.Credit "CREDITS", 17, 12, 0
        Put.Credit "PROGRAMMER", 16, 11, 8
        Put.Credit "PROGRAMMER", 16, 11, 7
        Put.Credit "PROGRAMMER", 16, 11, 15
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 8
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 7
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 15
        Put.Credit "PROGRAMMER", 16, 11, 7
        Put.Credit "PROGRAMMER", 16, 11, 8
        Put.Credit "PROGRAMMER", 16, 11, 0
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 7
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 8
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 0
        Put.Credit "GRAPHICS", 17, 11, 8
        Put.Credit "GRAPHICS", 17, 11, 7
        Put.Credit "GRAPHICS", 17, 11, 15
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 8
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 7
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 15
        Put.Credit "GRAPHICS", 17, 11, 7
        Put.Credit "GRAPHICS", 17, 11, 8
        Put.Credit "GRAPHICS", 17, 11, 0
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 7
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 8
        Put.Credit "MATT ZUCHOWSKI", 14, 13, 0
        Put.Credit "KEYBOARD ISR", 15, 11, 8
        Put.Credit "KEYBOARD ISR", 15, 11, 7
        Put.Credit "KEYBOARD ISR", 15, 11, 15
        Put.Credit "STEVEN SENSARN", 14, 13, 8
        Put.Credit "STEVEN SENSARN", 14, 13, 7
        Put.Credit "STEVEN SENSARN", 14, 13, 15
        Put.Credit "KEYBOARD ISR", 15, 11, 7
        Put.Credit "KEYBOARD ISR", 15, 11, 8
        Put.Credit "KEYBOARD ISR", 15, 11, 0
        Put.Credit "STEVEN SENSARN", 14, 13, 7
        Put.Credit "STEVEN SENSARN", 14, 13, 8
        Put.Credit "STEVEN SENSARN", 14, 13, 0
        Put.Credit "DOS DELAY", 16, 11, 8
        Put.Credit "DOS DELAY", 16, 11, 7
        Put.Credit "DOS DELAY", 16, 11, 15
        Put.Credit "KURT KUZBA", 16, 13, 8
        Put.Credit "KURT KUZBA", 16, 13, 7
        Put.Credit "KURT KUZBA", 16, 13, 15
        Put.Credit "DOS DELAY", 16, 11, 7
        Put.Credit "DOS DELAY", 16, 11, 8
        Put.Credit "DOS DELAY", 16, 11, 0
        Put.Credit "KURT KUZBA", 16, 13, 7
        Put.Credit "KURT KUZBA", 16, 13, 8
        Put.Credit "KURT KUZBA", 16, 13, 0
        Put.Credit "SOUNDS", 18, 11, 8
        Put.Credit "SOUNDS", 18, 11, 7
        Put.Credit "SOUNDS", 18, 11, 15
        Put.Credit "MERLIN R. NULL", 14, 13, 8
        Put.Credit "MERLIN R. NULL", 14, 13, 7
        Put.Credit "MERLIN R. NULL", 14, 13, 15
        Put.Credit "SOUNDS", 18, 11, 7
        Put.Credit "SOUNDS", 18, 11, 8
        Put.Credit "SOUNDS", 18, 11, 0
        Put.Credit "MERLIN R. NULL", 14, 13, 7
        Put.Credit "MERLIN R. NULL", 14, 13, 8
        Put.Credit "MERLIN R. NULL", 14, 13, 0
        Put.Credit "(C) 1996 DARK DREAMS", 11, 12, 8
        Put.Credit "(C) 1996 DARK DREAMS", 11, 12, 7
        Put.Credit "(C) 1996 DARK DREAMS", 11, 12, 15
        Put.Credit "(C) 1996 DARK DREAMS", 11, 12, 7
        Put.Credit "(C) 1996 DARK DREAMS", 11, 12, 8
        Put.Credit "(C) 1996 DARK DREAMS", 11, 12, 0
        Put.Credit "THANKS FOR PLAYING", 12, 12, 8
        Put.Credit "THANKS FOR PLAYING", 12, 12, 7
        Put.Credit "THANKS FOR PLAYING", 12, 12, 15
        Put.Credit "THANKS FOR PLAYING", 12, 12, 7
        Put.Credit "THANKS FOR PLAYING", 12, 12, 8
        Put.Credit "THANKS FOR PLAYING", 12, 12, 0
        Put.Credit "THE END", 17, 12, 8
        Put.Credit "THE END", 17, 12, 7
        Put.Credit "THE END", 17, 12, 15
        WHILE INKEY$ = "": WEND
    ELSE
      FOR I = 1 TO 8
        COLOR 8
        LOCATE I
        PRINT BadEndText(I)
        PCOPY 0, 1
        Delay .5
        COLOR 7
        LOCATE I
        PRINT BadEndText(I)
        PCOPY 0, 1
        Delay .5
        COLOR 15
        LOCATE I
        PRINT BadEndText(I)
        PCOPY 0, 1
        Delay .5
        IF INKEY$ <> "" THEN EXIT FOR
      NEXT I
      IF I = 8 THEN
        WHILE INKEY$ = "": WEND
      END IF
  END IF
  CALL Keyboard.In(Old.Isr.Seg, Old.Isr.Off)
END SUB

SUB Game.Over
  CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)
  IF Noise = "ON " THEN PLAY "X" + VARPTR$(Over$)
  LINE (20, 20)-(179, 179), 0, BF
  PUT (20, 20), GameOver, PSET
  LOCATE 15, 4
  PRINT "You're not doin'   "
  LOCATE 16, 4
  PRINT "too well.  Better  "
  LOCATE 17, 4
  PRINT "let someone else   "
  LOCATE 18, 4
  PRINT "take over rookie!  "
  LOCATE 20, 4
  PRINT "     GAME OVER     "
  LINE (20, 20)-(179, 179), 8, B
  LINE (21, 21)-(178, 178), 7, B
  LINE (22, 22)-(177, 177), 15, B
  LINE (23, 23)-(176, 176), 7, B
  PCOPY 0, 1
  WHILE INKEY$ = "": WEND
  CALL Keyboard.In(Old.Isr.Seg, Old.Isr.Off)
END SUB

SUB Get.Level
  FOR X = 5 TO 46
    FOR Y = 5 TO 46
      Level(X, Y) = Level1(X, Y)
      Level.Old(X, Y) = Level2(X, Y)
      IF Level(X, Y) = 12 THEN
        No = No + 1
        EnemyPos(No, 1) = X
        EnemyPos(No, 2) = Y
        EnemyDir(No) = 1
      END IF
    NEXT Y
  NEXT X
  No.Enemies = No
END SUB

SUB Get.NewLevel
  FOR X = 5 TO 46
    FOR Y = 5 TO 46
      Level.Temp(X, Y) = Level(X, Y)
    NEXT Y
  NEXT X
  FOR X = 5 TO 46
    FOR Y = 5 TO 46
      Level(X, Y) = Level.Old(X, Y)
      IF Level(X, Y) = 12 THEN
        No = No + 1
        EnemyPos(No, 1) = X
        EnemyPos(No, 2) = Y
        EnemyDir(No) = 1
      END IF
    NEXT Y
  NEXT X
  FOR X = 5 TO 46
    FOR Y = 5 TO 46
      Level.Old(X, Y) = Level.Temp(X, Y)
    NEXT Y
  NEXT X
  No.Enemies = No
END SUB

SUB Get.PlayerPos
  FOR X = 4 TO 46                       ' These lines read the level data to
    FOR Y = 4 TO 46                     ' find the inital player position.
      IF Level(X, Y) = 4 THEN
        PlayerPos(1, 1) = X
        PlayerPos(1, 2) = Y
      END IF
    NEXT Y
  NEXT X
  PlayerDir = 3                         ' This line creates the intital
                                        ' direction which the player faces.
  Score = 0                             ' These lines change the stats to
  Gold.Key = 0                          ' their default values.
  Silver.Key = 0
  Rank = 9
END SUB

SUB Get.Reporter
  CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)
  Press.Hit = 1
  IF Noise = "ON " THEN PLAY "X" + VARPTR$(Reporter$)
  LINE (20, 20)-(179, 179), 0, BF
  PUT (20, 20), Press, PSET
  LOCATE 15, 4
  PRINT "Oh-oh, it's a      "
  LOCATE 16, 4
  PRINT "reporter.  He wants"
  LOCATE 17, 4
  PRINT "to know:           "
  LINE (20, 20)-(179, 179), 8, B
  LINE (21, 21)-(178, 178), 7, B
  LINE (22, 22)-(177, 177), 15, B
  LINE (23, 23)-(176, 176), 7, B
  PCOPY 0, 1
  WHILE INKEY$ = "": WEND
  Question = INT(RND * 11)
  FOR I = 15 TO 21
    LOCATE I, 4
    PRINT Question$(Question * 8 + A)
    A = A + 1
  NEXT I
  LINE (20, 20)-(179, 179), 8, B
  LINE (21, 21)-(178, 178), 7, B
  LINE (22, 22)-(177, 177), 15, B
  LINE (23, 23)-(176, 176), 7, B
  PCOPY 0, 1
  DO UNTIL Choice$ = "Made"
    SELECT CASE INKEY$
      CASE IS = "1"
        Ans = 1: Choice$ = "Made"
      CASE IS = "2"
        Ans = 2: Choice$ = "Made"
      CASE IS = "3"
        Ans = 3: Choice$ = "Made"
    END SELECT
  LOOP
  FOR I = 15 TO 22
    LOCATE I, 4: PRINT SPACE$(19)
  NEXT I
  IF Ans = Answers(Question) THEN
      IF Noise = "ON " THEN PLAY "X" + VARPTR$(Correct$)
      Score = Score + 10
      LOCATE 15, 4
      PRINT "Correct.  The      "
      LOCATE 16, 4
      PRINT "reporter wanders   "
      LOCATE 17, 4
      PRINT "off satisfied.     "
    ELSE
      IF Noise = "ON " THEN PLAY "X" + VARPTR$(Wrong$)
      Rank = Rank - 1
      LOCATE 15, 4
      PRINT "Incorrect.  The    "
      LOCATE 16, 4
      PRINT "reporter is not    "
      LOCATE 17, 4
      PRINT "very happy.        "
  END IF
  LINE (20, 20)-(179, 179), 8, B
  LINE (21, 21)-(178, 178), 7, B
  LINE (22, 22)-(177, 177), 15, B
  LINE (23, 23)-(176, 176), 7, B
  PCOPY 0, 1
  WHILE INKEY$ = "": WEND
  Show.Visible
  CALL Keyboard.In(Old.Isr.Seg, Old.Isr.Off)
  RawKey = 0
END SUB

SUB Get.Screen
  LINE (218, 3)-(317, 27), 8, B
  LINE (219, 4)-(316, 26), 7, B
  LINE (220, 5)-(315, 25), 15, B
  LINE (221, 6)-(314, 24), 7, B
  LINE (222, 7)-(313, 23), 0, BF
 
  LINE (218, 38)-(302, 67), 8, B
  LINE (219, 39)-(301, 66), 7, B
  LINE (220, 40)-(300, 65), 15, B
  LINE (221, 41)-(299, 64), 7, B
  LINE (222, 42)-(298, 63), 0, BF
 
  LINE (218, 78)-(302, 107), 8, B
  LINE (219, 79)-(301, 106), 7, B
  LINE (220, 80)-(300, 105), 15, B
  LINE (221, 81)-(299, 104), 7, B
  LINE (222, 82)-(298, 103), 0, BF

  LINE (218, 115)-(317, 139), 8, B
  LINE (219, 116)-(316, 138), 7, B
  LINE (220, 117)-(315, 137), 15, B
  LINE (221, 118)-(314, 136), 7, B
  LINE (222, 119)-(313, 135), 0, BF
 
  LINE (218, 155)-(302, 179), 8, B
  LINE (219, 156)-(301, 178), 7, B
  LINE (220, 157)-(300, 177), 15, B
  LINE (221, 158)-(299, 176), 7, B
  LINE (222, 159)-(298, 175), 0, BF
 
  FOR I = 223 TO 308 STEP 10
    PUT (I, 128), Heart, PSET
    A = A + 1
    IF A = Rank THEN EXIT FOR
  NEXT I

  PUT (230, 44), GoldKey, PSET
  PUT (230, 84), SilverKey, PSET
END SUB

SUB Get.Visible
  '  This sub gets the parts of the level that are visible on the screen and
  '  stores them in the Visible array.
  FOR Y = PlayerPos(1, 2) - 3 TO PlayerPos(1, 2) + 4
    Y1 = Y1 + 1
    X1 = 0
    FOR X = PlayerPos(1, 1) - 3 TO PlayerPos(1, 1) + 4
      X1 = X1 + 1
      Visible(X1, Y1) = Level(X, Y)
    NEXT X
  NEXT Y
END SUB

SUB GetVect (S AS INTEGER, O AS INTEGER, I AS INTEGER)

    'GETVECT RETURNS THE ADDRESS OF A FUNCTION POINTED TO IN THE
    'INTERRUPT VECTOR TABLE (STARTS AT 0000:0000H)

    STATIC ASM AS STRING 'THE CODE FOR GETVECT

    STATIC INI AS INTEGER 'USED TO DETECT WHETHER GETVECT HAS PREVIOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN
       
        'CREATE ML FUNCTION IF NOT ALREADY CREATED

        ASM = ASM + CHR$(&H55)                          'PUSH    BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV     BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV     BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV     AL,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H35)             'MOV     AH,35
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT     21
        ASM = ASM + CHR$(&H53)                          'PUSH    BX
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV     BX,[BP+0A]
        ASM = ASM + CHR$(&H8C) + CHR$(&H7)              'MOV     [BX],ES
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV     BX,[BP+08]
        ASM = ASM + CHR$(&H58)                          'POP     AX
        ASM = ASM + CHR$(&H89) + CHR$(&H7)              'MOV     [BX],AX
        ASM = ASM + CHR$(&H5D)                          'POP     BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF    0006
        INI = 1 'FLAG CREATION
    END IF

    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(S, O, I, SADD(ASM)) 'RUN FUNCTION
END SUB

SUB High.Scores
  CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)
  CLS
  DIM Scores(11), Names$(11)
  OPEN "hiscores.dat" FOR INPUT AS #1
    FOR I = 1 TO 10
      INPUT #1, Scores(I), Names$(I)
    NEXT I
  CLOSE #1
  FOR I = 1 TO 10
    IF Score > Scores(I) AND Done = 0 THEN
      FOR J = 10 TO I STEP -1
        Scores(J + 1) = Scores(J)
        Names$(J + 1) = Names$(J)
      NEXT J
      PRINT "Congratulations! You got a high score!"
      PRINT "Enter your name: ............"
      PCOPY 0, 1
      DO
        N$ = INPUT$(1)
        IF N$ = CHR$(8) THEN
          IF Length = 13 THEN Length = 12
          IF Length <> 0 THEN Length = Length - 1
          Name$ = LEFT$(Name$, Length)
          LOCATE 2, 18: PRINT Name$ + "."
          PCOPY 0, 1
        END IF
        IF Length < 13 AND N$ <> CHR$(8) THEN Length = Length + 1
        IF N$ = CHR$(13) THEN EXIT DO
        IF N$ <> CHR$(8) THEN Name$ = Name$ + N$
        IF Length = 13 THEN Name$ = LEFT$(Name$, 12)
        LOCATE 2, 18: PRINT Name$
        PCOPY 0, 1
      LOOP
      Scores(I) = Score
      Names$(I) = Name$
      Done = 1
    END IF
  NEXT I
  CLS
  LOCATE 1, 15: PRINT "High Scores"
  LOCATE 3: PRINT "NAME"
  LOCATE 3, 30: PRINT "SCORE"
  OPEN "hiscores.dat" FOR OUTPUT AS #1
    FOR I = 1 TO 10
      LOCATE I + 4: PRINT Names$(I)
      LOCATE I + 4, 30: PRINT USING "#####"; Scores(I)
      WRITE #1, Scores(I), Names$(I)
    NEXT I
  CLOSE #1
  PCOPY 0, 1
  WHILE INKEY$ = "": WEND
  CALL Keyboard.In(Old.Isr.Seg, Old.Isr.Off)
END SUB

SUB Intro
  CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)
  DEF SEG = VARSEG(Pic(0))
  BLOAD "INTRO.16", VARPTR(Pic(0))
  PUT (0, 0), Pic, PSET
  PCOPY 0, 1
  FOR I = 1 TO 9
    COLOR 8
    IF I + 19 < 24 THEN LOCATE I + 19 ELSE LOCATE 24
    PRINT IntroText(I)
    PCOPY 0, 1
    Delay .5
    COLOR 7
    IF I + 19 < 24 THEN LOCATE I + 19 ELSE LOCATE 23
    PRINT IntroText(I)
    PCOPY 0, 1
    Delay .5
    COLOR 15
    IF I + 19 < 24 THEN LOCATE I + 19 ELSE LOCATE 23
    PRINT IntroText(I)
    PCOPY 0, 1
    Delay .5
    IF INKEY$ <> "" THEN EXIT FOR
  NEXT I
  IF I = 9 THEN
    WHILE INKEY$ = "": WEND
  END IF
  CALL Keyboard.In(Old.Isr.Seg, Old.Isr.Off)
END SUB

SUB Keyboard.In (OldSeg AS INTEGER, OldOff AS INTEGER)
   
    DIM SGL AS INTEGER, SGH AS INTEGER 'SEGMENT OF RAWKEY
    DIM OFL AS INTEGER, OFH AS INTEGER 'OFFSET OF RAWKEY

    DIM BYTE AS STRING * 1 'USED TO ACTIVATE IRQ 1 IN PIC

    STATIC ASM AS STRING 'HOLDS ISR

    SGL = VARSEG(RawKey) AND &HFF 'LOAD LOW "BYTE" SEGMENT
    SGH = INT(VARSEG(RawKey) / 256) AND &HFF 'LOAD HIGH "BYTE" SEGMENT

    OFL = VARPTR(RawKey) AND &HFF 'LOAD LOW "BYTE" OFFSET
    OFH = INT(VARPTR(RawKey) / 256) AND &HFF 'LOAD HIGH "BYTE" OFFSET

    'THIS IS THE ISR.  IT READS A SCANCODE FROM THE KEYBOARD BUFFER
    'AND RESETS IT.  THE BEST PART IS, BIOS CAN'T TOUCH IT!

    ASM = ""
    ASM = ASM + CHR$(&H52)                          'PUSH DX
    ASM = ASM + CHR$(&H51)                          'PUSH CX
    ASM = ASM + CHR$(&H53)                          'PUSH BX
    ASM = ASM + CHR$(&H50)                          'PUSH AX
    ASM = ASM + CHR$(&H6)                           'PUSH ES
    ASM = ASM + CHR$(&H57)                          'PUSH DI
    ASM = ASM + CHR$(&H1E)                          'PUSH DS
    ASM = ASM + CHR$(&H56)                          'PUSH SI
    ASM = ASM + CHR$(&HFB)                          'STI
    ASM = ASM + CHR$(&HBA) + CHR$(&H60) + CHR$(&H0) 'MOV DX,0060
    ASM = ASM + CHR$(&HEC)                          'IN AL,DX
    ASM = ASM + CHR$(&H30) + CHR$(&HE4)             'XOR AH,AH
    ASM = ASM + CHR$(&HBA) + CHR$(SGL) + CHR$(SGH)  'MOV DX,SEG RAWKEY
    ASM = ASM + CHR$(&H8E) + CHR$(&HDA)             'MOV DS,DX
    ASM = ASM + CHR$(&HBE) + CHR$(OFL) + CHR$(OFH)  'MOV SI,OFFSET RAWKEY
    ASM = ASM + CHR$(&H88) + CHR$(&H4)              'MOV [SI],AL
    ASM = ASM + CHR$(&HBA) + CHR$(&H61) + CHR$(&H0) 'MOV DX,0061
    ASM = ASM + CHR$(&HEC)                          'IN AL,DX
    ASM = ASM + CHR$(&HC) + CHR$(&H82)              'OR AL,82
    ASM = ASM + CHR$(&HEE)                          'OUT DX,AL
    ASM = ASM + CHR$(&H24) + CHR$(&H7F)             'AND AL,7F
    ASM = ASM + CHR$(&HEE)                          'OUT DX,AL
    ASM = ASM + CHR$(&HB0) + CHR$(&H20)             'MOV AL,20
    ASM = ASM + CHR$(&HBA) + CHR$(&H20) + CHR$(&H0) 'MOV DX,0020
    ASM = ASM + CHR$(&HEE)                          'OUT DX,AL
    ASM = ASM + CHR$(&H5E)                          'POP SI
    ASM = ASM + CHR$(&H1F)                          'POP DS
    ASM = ASM + CHR$(&H5F)                          'POP DI
    ASM = ASM + CHR$(&H7)                           'POP ES
    ASM = ASM + CHR$(&H58)                          'POP AX
    ASM = ASM + CHR$(&H5B)                          'POP BX
    ASM = ASM + CHR$(&H59)                          'POP CX
    ASM = ASM + CHR$(&H5A)                          'POP DX
    ASM = ASM + CHR$(&HCF)                          'IRET

    BYTE = CHR$(INP(&H21)) 'LOAD IRQ ENABLE REGISTER IN PIC

    OUT &H21, (ASC(BYTE) AND (255 XOR 2)) 'CLEAR BIT 2 (IRQ 1)

    CALL GetVect(OldSeg, OldOff, &H9) 'LOAD OLD ISR
    CALL SetVect(VARSEG(ASM), SADD(ASM), &H9) 'STORE NEW ISR
END SUB

DEFSNG A-Z
SUB Keyboard.Out (OldSeg AS INTEGER, OldOff AS INTEGER)
    CALL SetVect(OldSeg, OldOff, &H9) 'RESTORE OLD ISR
END SUB

DEFINT A-Z
SUB Load.Level
  COLOR 7, 0
  LOCATE 5, 1
  PRINT "Loading levels:   ";
  COLOR 4
  FOR X = 1 TO 42
    PRINT CHR$(219);
  NEXT X
  COLOR 14
  LOCATE 5, 19
  OPEN "LEVEL1.DAT" FOR INPUT AS #1     ' These lines open the level data
  FOR Y = 5 TO 46                       ' file and input the values into the
    FOR X = 5 TO 46                     ' level array.
      INPUT #1, Level1(X, Y)
    NEXT X
    IF Y / 2 = INT(Y / 2) THEN PRINT CHR$(219);
  NEXT Y
  CLOSE #1
  OPEN "LEVEL2.DAT" FOR INPUT AS #1     ' These lines open the level data
  FOR Y = 5 TO 46                       ' file and input the values into the
    FOR X = 5 TO 46                     ' level array.
      INPUT #1, Level2(X, Y)
    NEXT X
    IF Y / 2 = INT(Y / 2) THEN PRINT CHR$(219);
  NEXT Y
  CLOSE #1
END SUB

SUB LoadData
  ' This sub loads all game data into arrays at the beginning of program
  ' execution.
  COLOR 15, 4                           ' These lines create a status bar to
  PRINT SPACE$(80)                      ' show how much data has been loaded.
  LOCATE 1, 29
  PRINT "HELTER SKELTER - V1.02"
  COLOR 7, 0
  LOCATE 3
  PRINT "Loading data:     ";
  COLOR 4
  FOR X = 1 TO 24
    PRINT CHR$(219);
  NEXT X
  COLOR 14
  LOCATE 3, 19
  FOR I = 1 TO 9
    READ IntroText(I)
    PRINT CHR$(219);
  NEXT I
  FOR I = 1 TO 6
    READ EndText(I)
    PRINT CHR$(219);
  NEXT I
  FOR I = 1 TO 8
    READ BadEndText(I)
    PRINT CHR$(219);
  NEXT I
  Reporter$ = "MBT255L64MLO2CDEFGAB>CDEFGABP16<BAGFEDC<BAGFEDCP32"
  Item$ = "MBT150L64MSO0F>CG>DA>EB."
  Item2$ = "MBT150L64MSO3DFA>CEGL16B"
  Door$ = "MBT150L64MSO4BE<AD<GC<L32F"
  Correct$ = "T120L64MSO2E.A.>D.G.>C.F.B."
  Wrong$ = "T255L64O4CDEFGABO3CDEFGABO2CDEFGAB"
  Over$ = "T255L64MLO1CDEFGAB>CDEFGABP16<BAGFEDC<BAGFEDCP32"
  Ghost$ = "T255L64MsO4C#DD#EFF#GG#AA#B>CC#DD#EF"
  PRINT CHR$(219);
  OPEN "Q&A.DAT" FOR INPUT AS #1
  DO UNTIL (EOF(1))                     ' These lines read in the questions
    INPUT #1, Question$(A)              ' and answers from a file.
    IF Question$(A) = "End Record" THEN
      INPUT #1, Answers(B)
      B = B + 1
      PRINT CHR$(219);
    END IF
    A = A + 1
  LOOP
  CLOSE #1
END SUB

SUB LoadGraphics
  '  This sub loads all graphics into arrays at the beginning of program
  '  execution.
  COLOR 7
  LOCATE 7, 1                           ' These lines create a status bar
  PRINT "Loading graphics: ";           ' which shows how much of the
  COLOR 4                               ' graphics have been loaded.
  FOR I = 1 TO 46
    PRINT CHR$(219);
  NEXT I

  '  These lines load the graphics into arrays and display how many of the
  '  graphics have been loaded so far.
  COLOR 14
  LOCATE 7, 19
  DEF SEG = VARSEG(Title(0))
  BLOAD Path$ + "HS.16", VARPTR(Title(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Logo(0))
  BLOAD Path$ + "LOGO.16", VARPTR(Logo(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Press(0))
  BLOAD Path$ + "PRESS.16", VARPTR(Press(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GameOver(0))
  BLOAD Path$ + "GAMEOVER.16", VARPTR(GameOver(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Pointer1(0))
  BLOAD Path$ + "POINTER1.TIL", VARPTR(Pointer1(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Pointer2(0))
  BLOAD Path$ + "POINTER2.TIL", VARPTR(Pointer2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Heart(0))
  BLOAD Path$ + "HEART.TIL", VARPTR(Heart(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Tile(0))
  BLOAD Path$ + "TILE.TIL", VARPTR(Tile(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerDown(0))
  BLOAD Path$ + "PI1.TIL", VARPTR(PlayerDown(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerDown2(0))
  BLOAD Path$ + "PI1B.TIL", VARPTR(PlayerDown2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerUp(0))
  BLOAD Path$ + "PI2.TIL", VARPTR(PlayerUp(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerUp2(0))
  BLOAD Path$ + "PI2B.TIL", VARPTR(PlayerUp2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerLeft(0))
  BLOAD Path$ + "PI4.TIL", VARPTR(PlayerLeft(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerLeft2(0))
  BLOAD Path$ + "PI4B.TIL", VARPTR(PlayerLeft2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerRight(0))
  BLOAD Path$ + "PI3.TIL", VARPTR(PlayerRight(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PlayerRight2(0))
  BLOAD Path$ + "PI3B.TIL", VARPTR(PlayerRight2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressDown(0))
  BLOAD Path$ + "PRESS1.TIL", VARPTR(PressDown(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressDown2(0))
  BLOAD Path$ + "PRESS1B.TIL", VARPTR(PressDown2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressUp(0))
  BLOAD Path$ + "PRESS2.TIL", VARPTR(PressUp(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressUp2(0))
  BLOAD Path$ + "PRESS2B.TIL", VARPTR(PressUp2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressLeft(0))
  BLOAD Path$ + "PRESS4.TIL", VARPTR(PressLeft(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressLeft2(0))
  BLOAD Path$ + "PRESS4B.TIL", VARPTR(PressLeft2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressRight(0))
  BLOAD Path$ + "PRESS3.TIL", VARPTR(PressRight(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(PressRight2(0))
  BLOAD Path$ + "PRESS3B.TIL", VARPTR(PressRight2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostDown(0))
  BLOAD Path$ + "GHOST1.TIL", VARPTR(GhostDown(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostDown2(0))
  BLOAD Path$ + "GHOST1B.TIL", VARPTR(GhostDown2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostUp(0))
  BLOAD Path$ + "GHOST2.TIL", VARPTR(GhostUp(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostUp2(0))
  BLOAD Path$ + "GHOST2B.TIL", VARPTR(GhostUp2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostLeft(0))
  BLOAD Path$ + "GHOST4.TIL", VARPTR(GhostLeft(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostLeft2(0))
  BLOAD Path$ + "GHOST4B.TIL", VARPTR(GhostLeft2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostRight(0))
  BLOAD Path$ + "GHOST3.TIL", VARPTR(GhostRight(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GhostRight2(0))
  BLOAD Path$ + "GHOST3B.TIL", VARPTR(GhostRight2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Candle(0))
  BLOAD Path$ + "CANDLE.TIL", VARPTR(Candle(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Wall1(0))
  BLOAD Path$ + "WALL1.TIL", VARPTR(Wall1(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Wall2(0))
  BLOAD Path$ + "WALL2.TIL", VARPTR(Wall2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Wall1B(0))
  BLOAD Path$ + "BWALL1.TIL", VARPTR(Wall1B(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Wall2B(0))
  BLOAD Path$ + "BWALL2.TIL", VARPTR(Wall2B(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Loot1(0))
  BLOAD Path$ + "LOOT1.TIL", VARPTR(Loot1(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Loot2(0))
  BLOAD Path$ + "LOOT2.TIL", VARPTR(Loot2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Loot3(0))
  BLOAD Path$ + "LOOT3.TIL", VARPTR(Loot3(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Loot4(0))
  BLOAD Path$ + "LOOT4.TIL", VARPTR(Loot4(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Door1(0))
  BLOAD Path$ + "DOOR1.TIL", VARPTR(Door1(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Door2(0))
  BLOAD Path$ + "DOOR2.TIL", VARPTR(Door2(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(SilverKey(0))
  BLOAD Path$ + "KEY1.TIL", VARPTR(SilverKey(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(GoldKey(0))
  BLOAD Path$ + "KEY2.TIL", VARPTR(GoldKey(0))
  PRINT CHR$(219);
  DEF SEG = VARSEG(Stair(0))
  BLOAD Path$ + "STAIRS.TIL", VARPTR(Stair(0))
  PRINT CHR$(219);
  COLOR 7
END SUB

SUB Move.Enemy
  Turn = Turn + 1
  IF Turn > No.Enemies THEN Turn = 1
  Dir = INT(RND * 60) + 1
  IF Dir < 21 THEN
      IF EnemyPos(Turn, 2) > 5 THEN
        EnemyDir(Turn) = 1
        IF Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2) - 1) = 0 THEN
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 0
          CALL Erase.Enemy
          EnemyPos(Turn, 2) = EnemyPos(Turn, 2) - 1
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 12
          CALL Show.Enemy
        END IF
        IF Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2) - 1) = 4 THEN
          IF Current.Level = 1 THEN
              CALL Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
          END IF
        END IF
      END IF
    ELSEIF Dir > 20 AND Dir < 41 THEN
      IF EnemyPos(Turn, 2) < 45 THEN
        EnemyDir(Turn) = 3
        IF Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2) + 1) = 0 THEN
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 0
          CALL Erase.Enemy
          EnemyPos(Turn, 2) = EnemyPos(Turn, 2) + 1
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 12
          CALL Show.Enemy
        END IF
        IF Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2) + 1) = 4 THEN
          IF Current.Level = 1 THEN
              CALL Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
          END IF
        END IF
      END IF
    ELSEIF Dir > 40 AND Dir < 51 THEN
      IF EnemyPos(Turn, 1) > 5 THEN
        EnemyDir(Turn) = 2
        IF Level(EnemyPos(Turn, 1) - 1, EnemyPos(Turn, 2)) = 0 THEN
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 0
          CALL Erase.Enemy
          EnemyPos(Turn, 1) = EnemyPos(Turn, 1) - 1
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 12
          CALL Show.Enemy
        END IF
        IF Level(EnemyPos(Turn, 1) - 1, EnemyPos(Turn, 2)) = 4 THEN
          IF Current.Level = 1 THEN
              CALL Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
          END IF
        END IF
      END IF
    ELSEIF Dir > 50 THEN
      IF EnemyPos(Turn, 1) < 45 THEN
        EnemyDir(Turn) = 4
        IF Level(EnemyPos(Turn, 1) + 1, EnemyPos(Turn, 2)) = 0 THEN
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 0
          CALL Erase.Enemy
          EnemyPos(Turn, 1) = EnemyPos(Turn, 1) + 1
          Level(EnemyPos(Turn, 1), EnemyPos(Turn, 2)) = 12
          CALL Show.Enemy
        END IF
        IF Level(EnemyPos(Turn, 1) + 1, EnemyPos(Turn, 2)) = 4 THEN
          IF Current.Level = 1 THEN
              CALL Get.Reporter
            ELSE
              IF Noise$ = "ON " THEN PLAY "X" + VARPTR$(Ghost$)
              Rank = Rank - 1
          END IF
        END IF
      END IF
  END IF
END SUB

SUB New.Game
  Press.Hit = 0
  Current.Level = 1
  Items = 0
  Done = 0
  GunFound = 0
  IF Rank <= 0 THEN CALL Game.Over
  CALL High.Scores
  CALL Quick.Title
  CALL Title.Menu
  IF Start.Game = 1 THEN
    CALL Get.Level
    CALL Get.PlayerPos
    CALL Intro
    CALL Tile.Back
    CALL Get.Screen
    CALL Get.Visible
    CALL Show.Visible
    Start.Game = 0
  END IF
END SUB

SUB Options
  Pointer = 1: Choice = 0
  COLOR 15
  LOCATE 17, 20
  PRINT "SOUND "; Noise
  COLOR 7
  LOCATE 19, 20
  PRINT "DIFFICULTY NA"
  LOCATE 21, 20
  PRINT "QUIT OPTIONS"
  PUT (127, 127), Pointer1, PSET
  PUT (127, 143), Pointer1, PSET
  PUT (127, 159), Pointer1, PSET
  PUT (127, 127), Pointer2, PSET
  PCOPY 0, 1
  DO UNTIL Quit.Options = 1
    SELECT CASE INKEY$
    CASE CHR$(0) + CHR$(72)
      IF Pointer = 1 THEN
          Pointer = 3
          PUT (127, 127), Pointer1, PSET
          PUT (127, 159), Pointer2, PSET
          COLOR 7
          LOCATE 17, 20
          PRINT "SOUND "; Noise
          COLOR 15
          LOCATE 21, 20
          PRINT "QUIT OPTIONS"
        ELSEIF Pointer = 2 THEN
          Pointer = 1
          PUT (127, 143), Pointer1, PSET
          PUT (127, 127), Pointer2, PSET
          COLOR 15
          LOCATE 17, 20
          PRINT "SOUND "; Noise
          COLOR 7
          LOCATE 19, 20
          PRINT "DIFFICULTY NA"
        ELSEIF Pointer = 3 THEN
          Pointer = 2
          PUT (127, 159), Pointer1, PSET
          PUT (127, 143), Pointer2, PSET
          COLOR 15
          LOCATE 19, 20
          PRINT "DIFFICULTY NA"
          COLOR 7
          LOCATE 21, 20
          PRINT "QUIT OPTIONS"
      END IF
    CASE CHR$(0) + CHR$(80)
      IF Pointer = 1 THEN
          Pointer = 2
          PUT (127, 127), Pointer1, PSET
          PUT (127, 143), Pointer2, PSET
          COLOR 7
          LOCATE 17, 20
          PRINT "SOUND "; Noise
          COLOR 15
          LOCATE 19, 20
          PRINT "DIFFICULTY NA"
        ELSEIF Pointer = 2 THEN
          Pointer = 3
          PUT (127, 143), Pointer1, PSET
          PUT (127, 159), Pointer2, PSET
          COLOR 7
          LOCATE 19, 20
          PRINT "DIFFICULTY NA"
          COLOR 15
          LOCATE 21, 20
          PRINT "QUIT OPTIONS"
        ELSEIF Pointer = 3 THEN
          Pointer = 1
          PUT (127, 159), Pointer1, PSET
          PUT (127, 127), Pointer2, PSET
          COLOR 15
          LOCATE 17, 20
          PRINT "SOUND "; Noise
          COLOR 7
          LOCATE 21, 20
          PRINT "QUIT OPTIONS"
      END IF
    CASE CHR$(13)
      Choice = Pointer
      IF Noise = "ON " THEN PLAY "X" + VARPTR$(Correct$)
    END SELECT
    PCOPY 0, 1
    IF Choice = 1 THEN
        IF Noise = "OFF" THEN
            Noise = "ON "
          ELSE Noise = "OFF"
        END IF
        COLOR 15
        LOCATE 17, 26
        PRINT Noise
        Choice = 0
        PCOPY 0, 1
      ELSEIF Choice = 2 THEN
      ELSEIF Choice = 3 THEN
        Quit.Options = 1
    END IF
  LOOP
  LINE (54, 124)-(264, 175), 0, BF
  COLOR 7
  LOCATE 17, 20
  PRINT "START"
  LOCATE 19, 20
  PRINT "OPTIONS"
  LOCATE 21, 20
  PRINT "QUIT"
  PUT (127, 127), Pointer1, PSET
  PUT (127, 143), Pointer1, PSET
  PUT (127, 159), Pointer1, PSET
  PUT (127, 127), Pointer2, PSET
  PCOPY 0, 1
END SUB

SUB Put.Credit (Text$, XPos, YPos, Colour)
  COLOR Colour
  LOCATE YPos, XPos
  PRINT Text$
  PCOPY 0, 1
  Delay .6
END SUB

SUB Quick.Title
  PCOPY 1, 2
  FOR r = 205 TO 1 STEP -15
    PCOPY 2, 0
    CIRCLE (159, 99), r, 5
    IF r < 201 THEN
      PAINT (0, 0), 5, 5
      PAINT (319, 0), 5, 5
      PAINT (0, 199), 5, 5
      PAINT (319, 199), 5, 5
    END IF
    PCOPY 0, 1
  NEXT r
  FOR r = 1 TO 225 STEP 15
    PUT (0, 0), Title, PSET
    CIRCLE (159, 99), r, 5
    IF r < 201 THEN
      PAINT (0, 0), 5, 5
      PAINT (319, 0), 5, 5
      PAINT (0, 199), 5, 5
      PAINT (319, 199), 5, 5
    END IF
    PCOPY 0, 1
  NEXT r
  LINE (50, 120)-(268, 180), 8, B
  LINE (51, 121)-(267, 179), 7, B
  LINE (52, 122)-(266, 178), 15, B
  LINE (53, 123)-(265, 177), 7, B
  PUT (127, 127), Pointer1, PSET
  PUT (127, 143), Pointer1, PSET
  PUT (127, 159), Pointer1, PSET
  LOCATE 14, 25
  PRINT "Version 0.99"
  LOCATE 17, 20
  PRINT "START"
  LOCATE 19, 20
  PRINT "OPTIONS"
  LOCATE 21, 20
  PRINT "QUIT"
  PCOPY 0, 1
END SUB

SUB SetVect (S AS INTEGER, O AS INTEGER, I AS INTEGER)

    'SETVECT CHANGES THE ADDRESSES IN THE INTERRUPT VECTOR TABLE
    'TO POINT TO NEW FUNCTIONS

    STATIC ASM AS STRING 'HOLDS THE SETVECT FUNCTION
    STATIC INI AS INTEGER 'USED TO TEST WHETHER OR NOT FUNCTION HAS PREVOUSLY
                          'BEEN CALLED
    IF INI = 0 THEN

        'CREATE FUNCTION IF NOT ALREADY CREATED

        ASM = ""
        ASM = ASM + CHR$(&H55)                          'PUSH BP
        ASM = ASM + CHR$(&H89) + CHR$(&HE5)             'MOV BP,SP
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) 'MOV BX,[BP+08]
        ASM = ASM + CHR$(&H8B) + CHR$(&H17)             'MOV DX,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) 'MOV BX,[BP+06]
        ASM = ASM + CHR$(&H8A) + CHR$(&H7)              'MOV AL,[BX]
        ASM = ASM + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) 'MOV BX,[BP+0A]
        ASM = ASM + CHR$(&H1E)                          'PUSH DS
        ASM = ASM + CHR$(&H8E) + CHR$(&H1F)             'MOV DS,[BX]
        ASM = ASM + CHR$(&HB4) + CHR$(&H25)             'MOV AH,25
        ASM = ASM + CHR$(&HCD) + CHR$(&H21)             'INT 21
        ASM = ASM + CHR$(&H1F)                          'POP DS
        ASM = ASM + CHR$(&H5D)                          'POP BP
        ASM = ASM + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)  'RETF 0006
        INI = 1 'FLAG CREATION
    END IF
    DEF SEG = VARSEG(ASM)
    CALL ABSOLUTE(S, O, I, SADD(ASM)) 'RUN SETVECT
END SUB

SUB Show.Enemy
  IF EnemyPos(Turn, 1) > PlayerPos(1, 1) - 4 AND EnemyPos(Turn, 1) < PlayerPos(1, 1) + 5 THEN
    IF EnemyPos(Turn, 2) > PlayerPos(1, 2) - 4 AND EnemyPos(Turn, 2) < PlayerPos(1, 2) + 5 THEN
      X = EnemyPos(Turn, 1) - (PlayerPos(1, 1) - 4)
      Y = EnemyPos(Turn, 2) - (PlayerPos(1, 2) - 4)
      IF EnemyMove(Turn) = 0 THEN
        IF EnemyDir(Turn) = 1 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressUp, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostUp, PSET
              END IF
            ELSEIF EnemyDir(Turn) = 2 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressLeft, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostLeft, PSET
              END IF
            ELSEIF EnemyDir(Turn) = 3 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressDown, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostDown, PSET
              END IF
            ELSEIF EnemyDir(Turn) = 4 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressRight, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostRight, PSET
              END IF
        END IF
        EnemyMove(Turn) = 1
      ELSE
        IF EnemyDir(Turn) = 1 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressUp2, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostUp2, PSET
              END IF
            ELSEIF EnemyDir(Turn) = 2 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressLeft2, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostLeft2, PSET
              END IF
            ELSEIF EnemyDir(Turn) = 3 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressDown2, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostDown2, PSET
              END IF
            ELSEIF EnemyDir(Turn) = 4 THEN
              IF Current.Level = 1 THEN
                  PUT (X * 20, Y * 20), PressRight2, PSET
                ELSE
                  PUT (X * 20, Y * 20), GhostRight2, PSET
              END IF
        END IF
        EnemyMove(Turn) = 0
      END IF
      LINE (20, 20)-(179, 179), 8, B
      LINE (21, 21)-(178, 178), 7, B
      LINE (22, 22)-(177, 177), 15, B
      LINE (23, 23)-(176, 176), 7, B
      PCOPY 0, 1
    END IF
  END IF
END SUB

SUB Show.Logo
  FOR r = 1 TO 110 STEP 4
    LINE (0, 0)-(319, 199), 0, BF
    PUT (63, 64), Logo, PSET
    CIRCLE (159, 99), r, 5
    PAINT (0, 0), 5, 5
    PCOPY 0, 1
  NEXT r
  Delay 3
  FOR r = 110 TO 1 STEP -4
    LINE (0, 0)-(319, 199), 0, BF
    PUT (63, 64), Logo, PSET
    CIRCLE (159, 99), r - 1, 5
    PAINT (0, 0), 5, 5
    PCOPY 0, 1
  NEXT r
  LINE (0, 0)-(319, 199), 5, BF
  PCOPY 0, 1
END SUB

SUB Show.Rank
  LINE (222, 119)-(313, 135), 0, BF
  FOR I = 223 TO 308 STEP 10
    PUT (I, 128), Heart, PSET
    A = A + 1
    IF A = Rank THEN EXIT FOR
  NEXT I
END SUB

SUB Show.Title
  FOR r = 1 TO 205 STEP 5
    PUT (0, 0), Title, PSET
    CIRCLE (159, 99), r, 5
    IF r < 201 THEN
      PAINT (0, 0), 5, 5
      PAINT (319, 0), 5, 5
      PAINT (0, 199), 5, 5
      PAINT (319, 199), 5, 5
    END IF
    PCOPY 0, 1
  NEXT r
  LINE (50, 120)-(268, 180), 8, B
  LINE (51, 121)-(267, 179), 7, B
  LINE (52, 122)-(266, 178), 15, B
  LINE (53, 123)-(265, 177), 7, B
  PUT (127, 127), Pointer1, PSET
  PUT (127, 143), Pointer1, PSET
  PUT (127, 159), Pointer1, PSET
  LOCATE 14, 25
  PRINT "Version 1.02"
  PCOPY 0, 1
END SUB

SUB Show.Visible
  ' This sub displays the visible part of the level on the screen.
  LINE (20, 20)-(179, 179), 0, BF
  FOR Y = 1 TO 8
    FOR X = 1 TO 8
      IF Visible(X, Y) = 1 THEN
          PUT (X * 20, Y * 20), Door1, PSET
        ELSEIF Visible(X, Y) = 2 THEN
          PUT (X * 20, Y * 20), Loot1, PSET
        ELSEIF Visible(X, Y) = 3 THEN
          IF Current.Level = 1 THEN
              PUT (X * 20, Y * 20), Wall2, PSET
            ELSE
              PUT (X * 20, Y * 20), Wall2B, PSET
          END IF
        ELSEIF Visible(X, Y) = 4 THEN
          IF PlayerDir = 1 THEN
              PUT (X * 20, Y * 20), PlayerUp, PSET
            ELSEIF PlayerDir = 2 THEN
              PUT (X * 20, Y * 20), PlayerLeft, PSET
            ELSEIF PlayerDir = 3 THEN
              PUT (X * 20, Y * 20), PlayerDown, PSET
            ELSEIF PlayerDir = 4 THEN
              PUT (X * 20, Y * 20), PlayerRight, PSET
          END IF
        ELSEIF Visible(X, Y) = 5 THEN
          PUT (X * 20, Y * 20), Loot3, PSET
        ELSEIF Visible(X, Y) = 6 THEN
        ELSEIF Visible(X, Y) = 7 THEN
          PUT (X * 20, Y * 20), SilverKey, PSET
        ELSEIF Visible(X, Y) = 8 THEN
          PUT (X * 20, Y * 20), GoldKey, PSET
        ELSEIF Visible(X, Y) = 9 THEN
          PUT (X * 20, Y * 20), Door2, PSET
        ELSEIF Visible(X, Y) = 10 THEN
          PUT (X * 20, Y * 20), Loot2, PSET
        ELSEIF Visible(X, Y) = 11 THEN
          IF Current.Level = 1 THEN
              PUT (X * 20, Y * 20), Wall1, PSET
            ELSE
              PUT (X * 20, Y * 20), Wall1B, PSET
          END IF
        ELSEIF Visible(X, Y) = 12 THEN
          FOR I = 1 TO No.Enemies
            IF EnemyPos(I, 1) > PlayerPos(1, 1) - 4 AND EnemyPos(I, 1) < PlayerPos(1, 1) + 5 THEN
              IF EnemyPos(I, 2) > PlayerPos(1, 2) - 4 AND EnemyPos(I, 2) < PlayerPos(1, 2) + 5 THEN
                IF EnemyMove(I) = 0 THEN
                  IF EnemyDir(I) = 1 THEN
                       IF Current.Level = 1 THEN
                          PUT (X * 20, Y * 20), PressUp, PSET
                         ELSE
                          PUT (X * 20, Y * 20), GhostUp, PSET
                       END IF
                     ELSEIF EnemyDir(I) = 2 THEN
                        IF Current.Level = 1 THEN
                            PUT (X * 20, Y * 20), PressLeft, PSET
                          ELSE
                            PUT (X * 20, Y * 20), GhostLeft, PSET
                        END IF
                      ELSEIF EnemyDir(I) = 3 THEN
                        IF Current.Level = 1 THEN
                            PUT (X * 20, Y * 20), PressDown, PSET
                          ELSE
                            PUT (X * 20, Y * 20), GhostDown, PSET
                        END IF
                      ELSEIF EnemyDir(I) = 4 THEN
                        IF Current.Level = 1 THEN
                            PUT (X * 20, Y * 20), PressRight, PSET
                          ELSE
                            PUT (X * 20, Y * 20), GhostRight, PSET
                        END IF
                  END IF
                  ELSEIF EnemyMove(I) = 1 THEN
                  IF EnemyDir(I) = 1 THEN
                       IF Current.Level = 1 THEN
                          PUT (X * 20, Y * 20), PressUp2, PSET
                         ELSE
                          PUT (X * 20, Y * 20), GhostUp2, PSET
                       END IF
                     ELSEIF EnemyDir(I) = 2 THEN
                        IF Current.Level = 1 THEN
                            PUT (X * 20, Y * 20), PressLeft2, PSET
                          ELSE
                            PUT (X * 20, Y * 20), GhostLeft2, PSET
                        END IF
                      ELSEIF EnemyDir(I) = 3 THEN
                        IF Current.Level = 1 THEN
                            PUT (X * 20, Y * 20), PressDown2, PSET
                          ELSE
                            PUT (X * 20, Y * 20), GhostDown2, PSET
                        END IF
                      ELSEIF EnemyDir(I) = 4 THEN
                        IF Current.Level = 1 THEN
                            PUT (X * 20, Y * 20), PressRight2, PSET
                          ELSE
                            PUT (X * 20, Y * 20), GhostRight2, PSET
                        END IF
                  END IF
                END IF
              END IF
            END IF
          NEXT I
        ELSEIF Visible(X, Y) = 13 THEN
          PUT (X * 20, Y * 20), Loot4, PSET
        ELSEIF Visible(X, Y) = 14 THEN
          PUT (X * 20, Y * 20), Candle, PSET
        ELSEIF Visible(X, Y) = 15 THEN
          PUT (X * 20, Y * 20), Stair, PSET
      END IF
    NEXT X
  NEXT Y
  CALL Show.Rank
  LOCATE 2, 29
    PRINT "Score"
  LOCATE 3, 35
    PRINT USING "#####"; Score
  LOCATE 7, 35
    PRINT USING "##"; Gold.Key
  LOCATE 12, 35
    PRINT USING "##"; Silver.Key
  LOCATE 16, 29
    PRINT "Ranking"
  LOCATE 21, 29
    PRINT "Collected"
  IF Items > 0 THEN
    Percent = INT((Items / Total.Items) * 100)
  END IF
  LOCATE 22, 34
    PRINT USING "###"; Percent
  LOCATE 22, 37
    PRINT "%"
  LINE (20, 20)-(179, 179), 8, B
  LINE (21, 21)-(178, 178), 7, B
  LINE (22, 22)-(177, 177), 15, B
  LINE (23, 23)-(176, 176), 7, B
  PCOPY 0, 1
END SUB

SUB ShowCaption
  ' This sub displays a small caption and halts the program so that the user
  ' will be able to read it.
  LOCATE , 1
  PRINT : PRINT
  PRINT "Free array memory:"; FRE(-1)
  PRINT "Stack space remaining:"; FRE(-2)
  PRINT "String space remaining:"; FRE("")
  LOCATE , 1
  PRINT
  PRINT "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-="
  PRINT "= This game is freeware.  It may be distributed freely as long  as nothing is ="
  PRINT "= modified.  You may use this program  for as long as you wish.  The facts in ="
  PRINT "= this  program are real.  All  sources come from the  movie, Helter Skelter, ="
  PRINT "= and the actual  Charles Manson trial.  This  game was created  for  a class ="
  PRINT "= project and is intended  for entertainment and  educational purposes  only. ="
  PRINT "= E-mail:   Liphili@Fleming.on.ca                                             ="
  PRINT "= Web site: http://www.geocites.com/SiliconValley/Pines/1732/index.html       ="
  PRINT "=                                                                             ="
  PRINT "= Programmed by Matt Zuchowski, (c) 1996 Dark Dreams Software.  Hit <ENTER>.. ="
  PRINT "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-="
  INPUT "", Dummy$
END SUB

SUB Tile.Back
  FOR Y = 1 TO 181 STEP 20
    FOR X = 0 TO 300 STEP 20
      PUT (X, Y - 1), Tile, PSET
    NEXT X
  NEXT Y
END SUB

SUB Title.Menu
  IF Turn <> 0 THEN CALL Keyboard.Out(Old.Isr.Seg, Old.Isr.Off)
  Pointer = 1: Choice = 0
  COLOR 15
  LOCATE 17, 20
  PRINT "START"
  COLOR 7
  LOCATE 19, 20
  PRINT "OPTIONS"
  LOCATE 21, 20
  PRINT "QUIT"
  PUT (127, 127), Pointer2, PSET
  PCOPY 0, 1
  DO UNTIL Choice <> 0
    SELECT CASE INKEY$
    CASE CHR$(0) + CHR$(72)
      IF Pointer = 1 THEN
          Pointer = 3
          PUT (127, 127), Pointer1, PSET
          PUT (127, 159), Pointer2, PSET
          COLOR 7
          LOCATE 17, 20
          PRINT "START"
          COLOR 15
          LOCATE 21, 20
          PRINT "QUIT"
        ELSEIF Pointer = 2 THEN
          Pointer = 1
          PUT (127, 143), Pointer1, PSET
          PUT (127, 127), Pointer2, PSET
          COLOR 15
          LOCATE 17, 20
          PRINT "START"
          COLOR 7
          LOCATE 19, 20
          PRINT "OPTIONS"
        ELSEIF Pointer = 3 THEN
          Pointer = 2
          PUT (127, 159), Pointer1, PSET
          PUT (127, 143), Pointer2, PSET
          COLOR 15
          LOCATE 19, 20
          PRINT "OPTIONS"
          COLOR 7
          LOCATE 21, 20
          PRINT "QUIT"
      END IF
    CASE CHR$(0) + CHR$(80)
      IF Pointer = 1 THEN
          Pointer = 2
          PUT (127, 127), Pointer1, PSET
          PUT (127, 143), Pointer2, PSET
          COLOR 7
          LOCATE 17, 20
          PRINT "START"
          COLOR 15
          LOCATE 19, 20
          PRINT "OPTIONS"
        ELSEIF Pointer = 2 THEN
          Pointer = 3
          PUT (127, 143), Pointer1, PSET
          PUT (127, 159), Pointer2, PSET
          COLOR 7
          LOCATE 19, 20
          PRINT "OPTIONS"
          COLOR 15
          LOCATE 21, 20
          PRINT "QUIT"
        ELSEIF Pointer = 3 THEN
          Pointer = 1
          PUT (127, 159), Pointer1, PSET
          PUT (127, 127), Pointer2, PSET
          COLOR 15
          LOCATE 17, 20
          PRINT "START"
          COLOR 7
          LOCATE 21, 20
          PRINT "QUIT"
      END IF
    CASE CHR$(13)
      Choice = Pointer
      IF Noise = "ON " THEN PLAY "X" + VARPTR$(Correct$)
    END SELECT
    PCOPY 0, 1
    IF Choice = 1 THEN
        Start.Game = 1
      ELSEIF Choice = 2 THEN
        CALL Options
        Choice = 0
      ELSEIF Choice = 3 THEN
        Quit.Game = 1
    END IF
  LOOP
  CALL Keyboard.In(Old.Isr.Seg, Old.Isr.Off)
END SUB

