REM $DYNAMIC
TYPE PaletteType
Red AS INTEGER
Green AS INTEGER
Blue AS INTEGER
END TYPE
DECLARE SUB Palette.Set (nColor%, pInfo AS PaletteType)
DECLARE SUB Palette.Get (nColor%, pInfo AS PaletteType)
DECLARE SUB Palette.Fadeout ()
DECLARE SUB Palette.FadeIn ()
DECLARE SUB Blood ()
DECLARE SUB DisplayIce ()
DECLARE SUB DisplayFire ()
COMMON SHARED sound1$, sound2$, sound3$, sound4$, Sound5$, Sound6$, Sound7$, sound8$, sound9$, Sound10$, sound11$, Sound12$, Sound13$, tune1$
COMMON SHARED Delay%, sound$, speed$
COMMON SHARED Heal%, maxmp%, MaxHP%, HP%, MP%, G#, ST%, DF%, EX#, AG%, AR%, LVL%, nextlvl#, MG%
COMMON SHARED chest1%, chest2%, SilverKey%, goldenkey%
COMMON SHARED Name$, Race$, alignment$, position$, weapon$, armor$, shield$
COMMON SHARED Magic1$, Magic2$, Magic3$, Magic4$, Magic5$
COMMON SHARED arm1$, arm2$, arm3$, arm4$, arm5$
COMMON SHARED Item1$, item2$, item3$, item4$, item5$
COMMON SHARED level$, dc1c1%, dc1c2%, dc1c3%, dc1c4%
COMMON SHARED Wallpaper%, Game%
DEFINT A-Z
DIM SHARED Pal AS PaletteType
DIM SHARED pData(0 TO 255, 1 TO 3)
SCREEN 13
DIM SHARED Image(1 TO 9000), Enemy(1 TO 3000), Mask(1 TO 3000)
RANDOMIZE TIMER
DEF SEG = VARSEG(Image(1)): BLOAD "back.dgi", VARPTR(Image(1))
PUT (17, 7), Image, PSET
FightEnemy:
  Game% = 2
  WHILE INKEY$ <> "": WEND
  Fi = 1
  Dream = 0
  Poison = 0
  PLAY "X" + VARPTR$(sound4$)
  Q = INT(RND * 5) + 1
    IF SilverKey% = 2 THEN Q = 6
    IF Q = 1 THEN GOSUB GreenSlime
    IF Q = 2 THEN GOSUB RedSlime
    IF Q = 3 THEN GOSUB BlueSlime
    IF Q = 4 THEN GOSUB DarkSlime
    IF Q = 5 THEN GOSUB Skull
    IF Q = 6 THEN GOSUB Shade
EnemyAnnouncment:
  GOSUB CD
  LOCATE 17, 3
    PRINT "Look out! "; Enemy$
  LOCATE 18, 3
    PRINT "attacks!                     "
FightChoice:
  GOSUB RestoreStatus
  Order = 0
  Ae = 0
  Ea = 0
  Dis = 0
  Cur = 0
  Elm = 0
  Healing = 0
  LOCATE 22, 3
    PRINT "        (F)ight/(R)un        "
    AG2 = INT(RND * (AG% * 10)) + AG%
    EAG2 = INT(RND * (EAG * 10)) + EAG
    IF AG2 > EAG2 THEN Order = 1
    IF EAG2 > AG2 THEN Order = 2
  Choice$ = LCASE$(INPUT$(1))
    IF Choice$ = "f" THEN GOTO ChooseAttack
    IF Choice$ = "r" THEN GOTO TryRun
  GOTO FightChoice
TryRun:
  Runner = 1
  IF Order = 2 THEN GOTO EnemysAttack
TryRun2:
  IF Enemy$ = "Lysia" THEN GOTO CantRun
  GOSUB CD
  Runn = INT(RND * 5) + 1
  IF Runn = 2 THEN GOTO CantRun
  GOTO EndFight
CantRun:
  GOSUB CD
  Runner = 0
  LOCATE 17, 3
    PRINT Name$; " tried to run but     "
  LOCATE 18, 3
    PRINT "failed.                      "
  WHILE INKEY$ = "": WEND
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
ChooseAttack:
  GOSUB CD
  LOCATE 17, 3
    PRINT "Choose your course of action:"
  LOCATE 22, 3
    PRINT "(A)ttack/(M)agic/(H)eal"
  Choice$ = LCASE$(INPUT$(1))
    IF Choice$ = "a" THEN GOTO AttackEnemy
    IF Choice$ = "m" THEN GOTO ChooseMagic
    IF Choice$ = "h" THEN GOTO HealPotion
  GOTO ChooseAttack
HealPotion:
  IF Heal% = 0 THEN
    GOSUB CD
    LOCATE 17, 3
      PRINT "No healing potions left!"
    WHILE INKEY$ = "": WEND
    GOTO ChooseAttack
  END IF
  Healing = 1
  IF Order = 2 AND Ea = 0 THEN GOTO EnemysAttack
  GOTO AttackEnemy
ChooseMagic:
  GOSUB CD
  GOSUB ShowMagic
  LOCATE 17, 3
    PRINT "What magic do you wish to use"
  LOCATE 18, 3
    PRINT "Press 0 to cancel.           "
  Magic$ = LCASE$(INPUT$(1))
    IF Magic$ = "1" AND Magic1$ = "Fire" THEN GOTO Element
    IF Magic$ = "2" AND Magic2$ = "Cure" THEN GOTO Cure
    IF Magic$ = "3" AND Magic3$ = "Ice" THEN GOTO Element
    IF Magic$ = "4" AND Magic4$ = "Poison" THEN GOTO Disable
    IF Magic$ = "5" AND Magic5$ = "Thunder" THEN GOTO Element
    IF Magic$ = "0" THEN
      GOSUB RestoreStatus
      GOTO ChooseAttack
    END IF
  GOTO ChooseMagic
Cure:
  LINE (135, 7)-(308, 104), 0, BF
  GOSUB RestoreStatus
  Cur = 1
  IF Order = 2 THEN GOTO EnemysAttack
Cure2:
  GOSUB CD
  Ae = 1
  IF MP% < 10 THEN GOTO NotEnough
  MP% = MP% - 10
  Magic$ = "cure"
  IF Race$ = "Elf" THEN Magic = 8
  IF Race$ = "Human" THEN Magic = 6
  IF Race$ = "Lilith" THEN Magic = 7
  IF Race$ = "Dwarf" THEN Magic = 5
  IF Race$ = "Demon" THEN Magic = 7
  IF Race$ = "Sprite" THEN Magic = 10
  D = INT(RND * 3) + 1
  Power = INT(RND * 5) + Magic
  MagicStrength = INT(RND * MG%) + (INT(MG% / 2))
  Cured = Power * (MagicStrength)
  PLAY "X" + VARPTR$(Sound6$)
  HP% = HP% + Cured
  IF HP% > MaxHP% THEN HP% = MaxHP%
  FOR Pause = 1 TO 2000: NEXT Pause
  LOCATE 7, 33
    PRINT USING "######"; MP%
  LOCATE 6, 33
    PRINT USING "######"; HP%
  LOCATE 13, 11
    PRINT USING "####"; HP%
  LOCATE 17, 3
    PRINT Name$; " casts "; Magic$
  LOCATE 18, 3
    PRINT "curing"; Cured; "HP."
  WHILE INKEY$ = "": WEND
  Cur = 0
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
Disable:
  LINE (135, 7)-(308, 104), 0, BF
  GOSUB RestoreStatus
  Dis = 1
  IF Order = 2 THEN GOTO EnemysAttack
Disable2:
  GOSUB CD
  Ae = 1
  IF MP% < 10 THEN GOTO NotEnough
  RANDOMIZE TIMER
    'IF Magic$ = "" THEN Dream = INT(RND * 6) + 1
    IF Magic$ = "4" THEN Poison = INT(RND * 6) + 1
  IF Dream > 3 THEN GOTO MissedEnemy
  IF Poison > 3 THEN GOTO MissedEnemy
  IF Magic$ = "4" THEN
    MP% = MP% - 10
    Magic$ = "poison"
    PLAY "X" + VARPTR$(Sound5$)
    FOR Pause = 1 TO 2000: NEXT Pause
  END IF
  'IF Magic$ = "4" THEN
  '  MP% = MP% - 10
  '  Magic$ = "sleep"
  '  PLAY "X" + VARPTR$(Sound5$)
  '  FOR Pause = 1 TO 2000: NEXT Pause
  'END IF
  LOCATE 7, 33
    PRINT USING "######"; MP%
  LOCATE 17, 3
    PRINT Name$; " casts "; Magic$
  LOCATE 18, 3
    PRINT "on the "; Enemy$; "."
  WHILE INKEY$ = "": WEND
  IF Magic$ = "poison" THEN GOTO EnemyPoisoned
  IF Magic$ = "sleep" THEN GOTO EnemySleeping
  Dis = 0
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
Element:
  LINE (135, 7)-(308, 104), 0, BF
  GOSUB RestoreStatus
  Elm = 1
  IF Order = 2 THEN GOTO EnemysAttack
Element2:
  GOSUB CD
  Ae = 1
  IF MP% < 5 THEN GOTO NotEnough
  IF Magic$ = "5" AND MP% <= 15 THEN GOTO NotEnough
  MP% = MP% - 5
  IF Magic$ = "5" THEN
    IF Race$ = "Elf" THEN Magic = 8
    IF Race$ = "Human" THEN Magic = 6
    IF Race$ = "Lilith" THEN Magic = 7
    IF Race$ = "Dwarf" THEN Magic = 5
    IF Race$ = "Demon" THEN Magic = 7
    IF Race$ = "Sprite" THEN Magic = 10
    Magic$ = "thunder"
    MP% = MP% - 10
  END IF
  IF Magic$ = "1" THEN
    IF Race$ = "Elf" THEN Magic = 8
    IF Race$ = "Human" THEN Magic = 6
    IF Race$ = "Lilith" THEN Magic = 7
    IF Race$ = "Dwarf" THEN Magic = 5
    IF Race$ = "Demon" THEN Magic = 7
    IF Race$ = "Sprite" THEN Magic = 10
    Magic$ = "fire"
  END IF
  IF Magic$ = "3" THEN
    IF Race$ = "Elf" THEN Magic = 8
    IF Race$ = "Human" THEN Magic = 6
    IF Race$ = "Lilith" THEN Magic = 7
    IF Race$ = "Dwarf" THEN Magic = 5
    IF Race$ = "Demon" THEN Magic = 7
    IF Race$ = "Sprite" THEN Magic = 10
    Magic$ = "ice"
  END IF
  LOCATE 7, 33
    PRINT USING "######"; MP%
  D = INT(RND * 3) + 1
  Power = INT(RND * 15) + Magic
  MagicStrength = INT(RND * MG%) + (INT(MG% / 2))
  Damage = Power * (MagicStrength + 1) - (EDEF * D)
  IF Magic$ = "ice" THEN
    PLAY "X" + VARPTR$(Sound6$)
    CALL DisplayIce
    PUT (17, 7), Image, PSET
  END IF
  IF Magic$ = "fire" THEN
    PLAY "X" + VARPTR$(Sound7$)
    CALL DisplayFire
    PUT (17, 7), Image, PSET
  END IF
  IF Magic$ = "thunder" THEN
    PLAY "X" + VARPTR$(sound8$)
    COLOR , 15
    FOR Pause = 1 TO 2000: NEXT Pause
    COLOR , 0
  END IF
  IF Damage <= 0 THEN GOTO EnemyResisted
  LOCATE 17, 3
    PRINT Enemy$; " gets hit with "
  LOCATE 18, 3
    PRINT Magic$; " for"; Damage; "damage!"
  WHILE INKEY$ = "": WEND
  EHP = EHP - Damage
  IF EHP <= 0 THEN GOTO WonFight
  Elm = 0
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
NotEnough:
  GOSUB CD
  LOCATE 17, 3
    PRINT "Your magic strength is to    "
  LOCATE 18, 3
    PRINT "low to use that magic.       "
  WHILE INKEY$ = "": WEND
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
UsedHealPotion:
  GOSUB CD
  LOCATE 17, 3
    PRINT Name$; " uses a heal potion."
  Heal% = Heal% - 1
  HP% = HP% + 10
  IF HP% > MaxHP% THEN HP% = MaxHP%
  LOCATE 22, 37
    PRINT USING "##"; Heal%
  LOCATE 6, 33
    PRINT USING "######"; HP%
  LOCATE 13, 11
    PRINT USING "####"; HP%
  WHILE INKEY$ = "": WEND
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
AttackEnemy:
  IF Order = 2 AND Ea = 0 THEN GOTO EnemysAttack
  Ae = 1
  IF Healing = 1 THEN GOTO UsedHealPotion
  GOSUB CD
  RANDOMIZE TIMER
  D = INT(RND * 6) + 1
  A = INT(RND * 6) + 1
    IF A = 6 THEN GOTO MissedEnemy
  PLAY "X" + VARPTR$(sound9$)
  C = (A * ST%) - (EDEF + EAR * D)
  IF C < 1 THEN C = A
  IF C <= 0 THEN GOTO EnemyResisted
  LOCATE 17, 3
    PRINT Name$; " attacks "; Enemy$
  LOCATE 18, 3
    PRINT "doing"; C; "damage!"
  CALL Blood
  PUT (17, 7), Image, PSET
  WHILE INKEY$ = "": WEND
  EHP = EHP - C
  IF EHP <= 0 THEN GOTO WonFight
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
MissedEnemy:
  LOCATE 17, 3
    PRINT Name$; " attacks "; Enemy$
  LOCATE 18, 3
    PRINT "and misses!"
  WHILE INKEY$ = "": WEND
  IF Order = 2 THEN GOTO FightChoice
  GOTO EnemysAttack
EnemysAttack:
  IF Ae = 1 AND Ea = 1 THEN GOTO FightChoice
  Ea = 1
  IF Dream > 0 THEN GOTO EnemySleeping
  GOSUB CD
  D = INT(RND * 6) + 1
  A = INT(RND * 6) + 1
    IF A > 3 AND A < 6 AND Enemy$ = "Lysia" THEN GOTO EnemyThunder
    IF A = 6 THEN GOTO EnemyMissed
  PLAY "X" + VARPTR$(Sound10$)
  C = (A * EST) - (DF% + AR% * D)
  IF C < 1 THEN
    C = A
  END IF
  LOCATE 17, 3
    PRINT Enemy$; " attacks "; Name$
  LOCATE 18, 3
    PRINT "doing"; C; "damage!"
  HP% = HP% - C
  LOCATE 6, 33
    PRINT USING "######"; HP%
  LOCATE 13, 11
    PRINT USING "####"; HP%
  WHILE INKEY$ = "": WEND
  IF HP% <= 0 THEN GOTO GameOver
  IF Poison > 0 THEN GOTO EnemyPoisoned
  IF Order = 2 AND Runner = 1 THEN GOTO TryRun2
  IF Order = 2 AND Elm = 1 THEN GOTO Element2
  IF Order = 2 AND Dis = 1 THEN GOTO Disable2
  IF Order = 2 AND Cur = 1 THEN GOTO Cure2
  IF Order = 2 THEN GOTO AttackEnemy
  GOTO FightChoice
EnemyThunder:
  GOSUB CD
  RANDOMIZE TIMER
    D = INT(RND * 3) + 1
    Power = INT(RND * 15) + 1
    MagicStrength = INT(RND * EMG) + (INT(EMG / 2))
  Damage = Power * (MagicStrength) - (DF% * D)
  IF Damage < 1 THEN Damage = 0
  GOSUB EraseEnemy
  DEF SEG = VARSEG(Mask(1)): BLOAD "lysia_l1.dgi", VARPTR(Mask(1))
  DEF SEG = VARSEG(Enemy(1)): BLOAD "lysia_l.dgi", VARPTR(Enemy(1))
  PUT (37, 7), Mask, AND
  PUT (37, 7), Enemy, XOR
  PLAY "X" + VARPTR$(Sound12$)
  SLEEP 1
  GOSUB EraseEnemy
  DEF SEG = VARSEG(Mask(1)): BLOAD "lysia1.dgi", VARPTR(Mask(1))
  DEF SEG = VARSEG(Enemy(1)): BLOAD "lysia.dgi", VARPTR(Enemy(1))
  PUT (49, 22), Mask, AND
  PUT (49, 22), Enemy, XOR
  GET (17, 7)-(150, 95), Image
  LOCATE 17, 3
    PRINT Name$; " gets hit with,"
  LOCATE 18, 3
    PRINT "thunder for"; Damage; "damage."
  HP% = HP% - Damage
  LOCATE 6, 33
    PRINT USING "######"; HP%
  LOCATE 13, 11
    PRINT USING "####"; HP%
  WHILE INKEY$ = "": WEND
  IF HP% <= 0 THEN GOTO GameOver
  IF Poison = 1 THEN GOTO EnemyPoisoned
  IF Order = 2 AND Dis = 1 THEN GOTO Disable2
  IF Order = 2 AND Elm = 1 THEN GOTO Element2
  IF Order = 2 AND Cur = 1 THEN GOTO Cure2
  IF Order = 2 AND Go = 1 THEN GOTO TryRun2
  IF Order = 2 THEN GOTO AttackEnemy
  IF Ae = 1 AND Ea = 1 THEN GOTO FightChoice
  GOTO FightChoice
EnemyResisted:
  GOSUB CD
  LOCATE 17, 3
    PRINT Enemy$; " resists the"
  LOCATE 18, 3
    PRINT "attack.                      "
  WHILE INKEY$ = "": WEND
  IF Order = 2 AND Runner = 1 THEN GOTO TryRun2
  IF Order = 2 AND Elm = 1 THEN GOTO Element2
  IF Order = 2 AND Dis = 1 THEN GOTO Disable2
  IF Order = 2 AND Cur = 1 THEN GOTO Cure2
  IF Order = 2 THEN GOTO AttackEnemy
  GOTO FightChoice
EnemySleeping:
  GOSUB CD
  Dream = Dream - 1
  LOCATE 17, 3
    PRINT Enemy$; " is sleeping."
  WHILE INKEY$ = "": WEND
  IF Order = 2 AND Runner = 1 THEN GOTO TryRun2
  IF Order = 2 AND Elm = 1 THEN GOTO Element2
  IF Order = 2 AND Dis = 1 THEN GOTO Disable2
  IF Order = 2 AND Cur = 1 THEN GOTO Cure2
  IF Order = 2 THEN GOTO AttackEnemy
  GOTO FightChoice
EnemyPoisoned:
  GOSUB CD
  RANDOMIZE TIMER
  Poison2 = INT(RND * MG%) + (INT(MG% / 2))
  Poison = Poison - 1
  LOCATE 17, 3
    PRINT Enemy$; " is poisoned. "
  LOCATE 18, 3
    PRINT Poison2; "damage."
  WHILE INKEY$ = "": WEND
  EHP = EHP - Poison2
  IF EHP <= 0 THEN GOTO WonFight
  IF Order = 2 AND Runner = 1 THEN GOTO TryRun2
  IF Order = 2 AND Elm = 1 THEN GOTO Element2
  IF Order = 2 AND Dis = 1 THEN GOTO Disable2
  IF Order = 2 AND Cur = 1 THEN GOTO Cure2
  IF Order = 2 THEN GOTO AttackEnemy
  GOTO FightChoice
EnemyMissed:
  LOCATE 17, 3
    PRINT Enemy$; " attacks "; Name$
  LOCATE 18, 3
    PRINT "and misses!"
  WHILE INKEY$ = "": WEND
  IF Order = 2 AND Runner = 1 THEN GOTO TryRun2
  IF Order = 2 AND Elm = 1 THEN GOTO Element2
  IF Order = 2 AND Dis = 1 THEN GOTO Disable2
  IF Order = 2 AND Cur = 1 THEN GOTO Cure2
  IF Order = 2 THEN GOTO AttackEnemy
  GOTO FightChoice
WonFight:
  GOSUB CD
  GOSUB EraseEnemy
  PLAY "X" + VARPTR$(sound11$)
  LOCATE 17, 3
    PRINT "Congratulations! You have    "
  LOCATE 18, 3
    PRINT "defeated "; Enemy$; ","
  LOCATE 19, 3
    PRINT "gaining"; EGP; "gold and"; EEXP
  LOCATE 20, 3
    PRINT "experience."
  G# = G# + EGP
  EX# = EX# + EEXP
  LOCATE 8, 33
    PRINT USING "######"; EX#
  LOCATE 9, 33
    PRINT USING "######"; G#
  RANDOMIZE TIMER
  J = INT(RND * 100) + 1
  I = INT(RND * 25) + 1
  H = INT(RND * 4) + 1
    IF J = 44 THEN GOTO GetElixir
    IF I = 1 THEN GOTO GetVital
    IF I = 15 THEN GOTO GetHPRing
    IF H = 3 THEN GOTO GetHealPotion
  GOTO ExperienceChart
GetVital:
  IF Item1$ <> "" AND item2$ <> "" AND item3$ <> "" AND item4$ <> "" AND item5$ <> "" THEN GOTO ExperienceChart
  WHILE INKEY$ = "": WEND
  GOSUB CD
  IF EAG > 1 THEN Stuff$ = "Red Vital" ELSE Stuff$ = "Green Vital"
  LOCATE 17, 3
    PRINT "What luck! The enemy dropped "
  LOCATE 18, 3
    PRINT "a vital!                     "
  WHILE INKEY$ = "": WEND
  GOTO GotItem
GetElixir:
  IF Item1$ <> "" AND item2$ <> "" AND item3$ <> "" AND item4$ <> "" AND item5$ <> "" THEN GOTO ExperienceChart
  WHILE INKEY$ = "": WEND
  GOSUB CD
  Stuff$ = "Elixir"
  LOCATE 17, 3
    PRINT "What luck! The enemy dropped "
  LOCATE 18, 3
    PRINT "an elixir!                   "
  WHILE INKEY$ = "": WEND
  GOTO GotItem
GetHPRing:
  IF Item1$ <> "" AND item2$ <> "" AND item3$ <> "" AND item4$ <> "" AND item5$ <> "" THEN GOTO ExperienceChart
  WHILE INKEY$ = "": WEND
  GOSUB CD
  Stuff$ = "Hit Point Ring"
  LOCATE 17, 3
    PRINT "What luck! The enemy dropped "
  LOCATE 18, 3
    PRINT "a ring of hit point!         "
  WHILE INKEY$ = "": WEND
  GOTO GotItem
GotItem:
  IF Item1$ = "" THEN
    Item1$ = Stuff$
    GOTO ExperienceChart
  END IF
  IF item2$ = "" THEN
    item2$ = Stuff$
    GOTO ExperienceChart
  END IF
  IF item3$ = "" THEN
    item3$ = Stuff$
    GOTO ExperienceChart
  END IF
  IF item4$ = "" THEN
    item4$ = Stuff$
    GOTO ExperienceChart
  END IF
  IF item5$ = "" THEN
    item5$ = Stuff$
    GOTO ExperienceChart
  END IF
  GOTO ExperienceChart
GetHealPotion:
  IF Heal% = 25 THEN GOTO ExperienceChart
  WHILE INKEY$ = "": WEND
  GOSUB CD
  LOCATE 17, 3
    PRINT "What luck! The enemy dropped "
  LOCATE 18, 3
    PRINT "a heal potion!               "
  Heal% = Heal% + 1
  LOCATE 22, 37
    PRINT USING "##"; Heal%
ExperienceChart:
  IF EX# >= 10 AND LVL% = 1 THEN GOTO Level2
  IF EX# >= 50 AND LVL% = 2 THEN GOTO Level3
  IF EX# >= 110 AND LVL% = 3 THEN GOTO Level4
  IF EX# >= 200 AND LVL% = 4 THEN GOTO Level5
  IF EX# >= 320 AND LVL% = 5 THEN GOTO Level6
  IF EX# >= 450 AND LVL% = 6 THEN GOTO Level7
  IF EX# >= 600 AND LVL% = 7 THEN GOTO Level8
  IF EX# >= 790 AND LVL% = 8 THEN GOTO Level9
  IF EX# >= 970 AND LVL% = 9 THEN GOTO Level10
  IF EX# >= 1750 AND LVL% = 10 THEN GOTO Level11
  IF EX# >= 2300 AND LVL% = 11 THEN GOTO Level12
  IF EX# >= 2890 AND LVL% = 12 THEN GOTO Level13
  IF EX# >= 3530 AND LVL% = 13 THEN GOTO Level14
  IF EX# >= 4220 AND LVL% = 14 THEN GOTO Level15
  IF EX# >= 4870 AND LVL% = 15 THEN GOTO Level16
  IF EX# >= 5620 AND LVL% = 16 THEN GOTO Level17
  IF EX# >= 6120 AND LVL% = 17 THEN GOTO Level18
  IF EX# >= 6900 AND LVL% = 18 THEN GOTO Level19
  IF EX# >= 7720 AND LVL% = 19 THEN GOTO Level20
  IF EX# >= 12000 AND LVL% = 20 THEN GOTO Level21
  IF EX# >= 15500 AND LVL% = 21 THEN GOTO Level22
  IF EX# >= 18530 AND LVL% = 22 THEN GOTO Level23
  IF EX# >= 22250 AND LVL% = 23 THEN GOTO Level24
  IF EX# >= 27510 AND LVL% = 24 THEN GOTO Level25
  IF EX# >= 34400 AND LVL% = 25 THEN GOTO Level26
  IF EX# >= 41250 AND LVL% = 26 THEN GOTO Level27
  IF EX# >= 50720 AND LVL% = 27 THEN GOTO Level28
  IF EX# >= 66210 AND LVL% = 28 THEN GOTO Level29
  IF EX# >= 79350 AND LVL% > 28 THEN GOTO LevelXX
EndFight:
  IF Runner = 1 THEN
    Runner = 0
    LOCATE 17, 3
      PRINT Name$; " runs away!         "
    Enemy$ = ""
  END IF
  IF Enemy$ = "Lysia" THEN SilverKey% = 3
  Enemy$ = "": Game% = 1
  IF speed$ = "MED" THEN SLEEP 1
  IF speed$ = "LOW" THEN SLEEP 3
  CHAIN "darah1.bas"
Level2:
  LevelX = 2
  nextlvl# = 50
  GOTO LevelUp
Level3:
  LevelX = 3
  nextlvl# = 110
  GOTO LevelUp
Level4:
  nextlvl# = 200
  LevelX = 4
  Spell$ = "Fire"
  GOTO LevelUp
Level5:
  nextlvl# = 320
  LevelX = 5
  GOTO LevelUp
Level6:
  nextlvl# = 450
  LevelX = 6
  GOTO LevelUp
Level7:
  nextlvl# = 600
  LevelX = 7
  GOTO LevelUp
Level8:
  nextlvl# = 790
  LevelX = 8
  GOTO LevelUp
Level9:
  nextlvl# = 970
  LevelX = 9
  GOTO LevelUp
Level10:
  nextlvl# = 1750
  LevelX = 10
  Spell$ = "Cure"
  GOTO LevelUp
Level11:
  LevelX = 11
  nextlvl# = 2300
  GOTO LevelUp
Level12:
  LevelX = 12
  nextlvl# = 2890
  GOTO LevelUp
Level13:
  LevelX = 13
  nextlvl# = 3530
  GOTO LevelUp
Level14:
  LevelX = 14
  nextlvl# = 4220
  GOTO LevelUp
Level15:
  LevelX = 15
  nextlvl# = 4870
  GOTO LevelUp
Level16:
  LevelX = 16
  nextlvl# = 5620
  Spell$ = "Ice"
  GOTO LevelUp
Level17:
  LevelX = 17
  nextlvl# = 6120
  GOTO LevelUp
Level18:
  LevelX = 18
  nextlvl# = 6900
  GOTO LevelUp
Level19:
  LevelX = 19
  nextlvl# = 7720
  GOTO LevelUp
Level20:
  LevelX = 20
  nextlvl# = 12000
  GOTO LevelUp
Level21:
  LevelX = 21
  nextlvl# = 15500
  GOTO LevelUp
Level22:
  LevelX = 22
  nextlvl# = 18530
  GOTO LevelUp
Level23:
  LevelX = 23
  nextlvl# = 22250
  Spell$ = "Poison"
  GOTO LevelUp
Level24:
  LevelX = 24
  nextlvl# = 27510
  GOTO LevelUp
Level25:
  LevelX = 25
  nextlvl# = 34400
  GOTO LevelUp
Level26:
  LevelX = 26
  nextlvl# = 41250
  GOTO LevelUp
Level27:
  LevelX = 27
  nextlvl# = 50720
  GOTO LevelUp
Level28:
  LevelX = 28
  nextlvl# = 66210
  GOTO LevelUp
Level29:
  LevelX = 29
  nextlvl# = 79350
  Spell$ = "Thunder"
  GOTO LevelUp
LevelXX:
  LevelX = LVL% + 1
  nextlvl# = EX# + 15000
  IF LevelX > 44 THEN nextlvl# = EX# + 30000
  IF LevelX > 54 THEN nextlvl# = EX# + 50000
  IF LevelX > 64 THEN nextlvl# = EX# + 100000
  GOTO LevelUp
LevelUp:
  WHILE INKEY$ = "": WEND
  GOSUB CD
  GOSUB AU
  PLAY "X" + VARPTR$(Sound13$)
  LOCATE 17, 3
    PRINT "You have advanced to the next"
  LOCATE 18, 3
    PRINT "level.                       "
  IF Spell$ <> "" THEN
    LOCATE 19, 3
      PRINT "You learned the spell of     "
    LOCATE 20, 3
      PRINT Spell$; "!"
      IF Spell$ = "Fire" THEN Magic1$ = "Fire"
      IF Spell$ = "Cure" THEN Magic2$ = "Cure"
      IF Spell$ = "Ice" THEN Magic3$ = "Ice"
      IF Spell$ = "Poison" THEN Magic4$ = "Poison"
      IF Spell$ = "Thunder" THEN Magic5$ = "Thunder"
    Spell$ = ""
  END IF
  LVL% = LevelX
  LOCATE 6, 33
    PRINT USING "######"; HP%
  LOCATE 13, 11
    PRINT USING "####"; HP%
  LOCATE 10, 33
    PRINT USING "######"; LVL%
  LOCATE 7, 33
    PRINT USING "######"; MP%
  IF nextlvl# - EX# < 1 THEN GOTO ExperienceChart
  IF Enemy$ = "Lysia" THEN SilverKey% = 3
  Enemy$ = "": Game% = 1
  IF speed$ = "MED" THEN SLEEP 1
  IF speed$ = "LOW" THEN SLEEP 3
  CHAIN "darah1.bas"
AU:
  IF Race$ = "Human" THEN
    RANDOMIZE TIMER
    A = INT(RND * 100) + 1
      IF A <= 35 THEN ST% = ST% + 1
      IF A >= 36 AND A <= 60 THEN AG% = AG% + 1
      IF A >= 61 AND A <= 85 THEN DF% = DF% + 1
      IF A >= 86 THEN MG% = MG% + 1
    B = INT(RND * 15) + 5: MaxHP% = MaxHP% + B: HP% = MaxHP%
    B = INT(RND * 10) + 5: maxmp% = maxmp% + B: MP% = maxmp%
  END IF
  IF Race$ = "Demon" THEN
    RANDOMIZE TIMER
    A = INT(RND * 100) + 1
      IF A <= 35 THEN ST% = ST% + 1
      IF A >= 36 AND A <= 55 THEN AG% = AG% + 1
      IF A >= 56 AND A <= 80 THEN DF% = DF% + 1
      IF A >= 81 THEN MG% = MG% + 1
    B = INT(RND * 15) + 5: MaxHP% = MaxHP% + B: HP% = MaxHP%
    B = INT(RND * 15) + 5: maxmp% = maxmp% + B: MP% = maxmp%
  END IF
  IF Race$ = "Elf" THEN
    RANDOMIZE TIMER
    A = INT(RND * 100) + 1
      IF A <= 35 THEN MG% = MG% + 1
      IF A >= 36 AND A <= 70 THEN AG% = AG% + 1
      IF A >= 71 AND A <= 85 THEN DF% = DF% + 1
      IF A >= 86 THEN ST% = ST% + 1
    B = INT(RND * 10) + 5: MaxHP% = MaxHP% + B: HP% = MaxHP%
    B = INT(RND * 20) + 5: maxmp% = maxmp% + B: MP% = maxmp%
  END IF
  IF Race$ = "Dwarf" THEN
    RANDOMIZE TIMER
    A = INT(RND * 100) + 1
      IF A <= 40 THEN ST% = ST% + 1
      IF A >= 41 AND A <= 70 THEN DF% = DF% + 1
      IF A >= 71 AND A <= 85 THEN AG% = AG% + 1
      IF A >= 86 THEN MG% = MG% + 1
    B = INT(RND * 20) + 5: MaxHP% = MaxHP% + B: HP% = MaxHP%
    B = INT(RND * 5) + 5: maxmp% = maxmp% + B: MP% = maxmp%
  END IF
  IF Race$ = "Lilith" THEN
    RANDOMIZE TIMER
    A = INT(RND * 100) + 1
      IF A <= 40 THEN DF% = DF% + 1
      IF A >= 41 AND A <= 60 THEN AG% = AG% + 1
      IF A >= 61 AND A <= 80 THEN DF% = DF% + 1
      IF A >= 81 THEN MG% = MG% + 1
    B = INT(RND * 10) + 5: MaxHP% = MaxHP% + B: HP% = MaxHP%
    B = INT(RND * 10) + 5: maxmp% = maxmp% + B: MP% = maxmp%
  END IF
  IF Race$ = "Sprite" THEN
    RANDOMIZE TIMER
    A = INT(RND * 100) + 1
      IF A <= 50 THEN MG% = MG% + 1
      IF A >= 51 AND A <= 80 THEN AG% = AG% + 1
      IF A >= 81 AND A <= 90 THEN DF% = DF% + 1
      IF A >= 91 THEN ST% = ST% + 1
    B = INT(RND * 10) + 5: MaxHP% = MaxHP% + B: HP% = MaxHP%
    B = INT(RND * 20) + 5: maxmp% = maxmp% + B: MP% = maxmp%
  END IF
  RETURN
GameOver:
  IF HP% < 0 THEN HP% = 0
  WHILE INKEY$ <> "": WEND
  LOCATE 6, 33
    PRINT USING "######"; HP%
  LOCATE 13, 11
    PRINT USING "####"; HP%
  Palette.Fadeout
  CLS : LOCATE 13, 12: PRINT "You have died..."
  Palette.FadeIn
  Enemy$ = ""
  WHILE INKEY$ = "": WEND
  CHAIN "title.bas"
EraseEnemy:
  DEF SEG = VARSEG(Image(1)): BLOAD "back.dgi", VARPTR(Image(1))
  PUT (17, 7), Image, PSET
  RETURN
GreenSlime:
  Enemy$ = "Green Slime"
  EHP = 2
  EGP = 1
  EEXP = 2
  EST = 1
  EAG = 1
  DEF SEG = VARSEG(Mask(1)): BLOAD "slime1.dgi", VARPTR(Mask(1))
  DEF SEG = VARSEG(Enemy(1)): BLOAD "gslime.dgi", VARPTR(Enemy(1))
  PUT (48, 61), Mask, AND
  PUT (48, 61), Enemy, XOR
  GET (17, 7)-(150, 95), Image
  RETURN
RedSlime:
  Enemy$ = "Red Slime"
  EHP = 4
  EGP = 2
  EEXP = 2
  EST = 1
  EAG = 1
  DEF SEG = VARSEG(Mask(1)): BLOAD "slime1.dgi", VARPTR(Mask(1))
  DEF SEG = VARSEG(Enemy(1)): BLOAD "rslime.dgi", VARPTR(Enemy(1))
  PUT (48, 61), Mask, AND
  PUT (48, 61), Enemy, XOR
  GET (17, 7)-(150, 95), Image
  RETURN
BlueSlime:
  Enemy$ = "Blue Slime"
  EHP = 8
  EGP = 4
  EEXP = 4
  EST = 1
  EAG = 1
  DEF SEG = VARSEG(Mask(1)): BLOAD "slime1.dgi", VARPTR(Mask(1))
  DEF SEG = VARSEG(Enemy(1)): BLOAD "bslime.dgi", VARPTR(Enemy(1))
  PUT (48, 61), Mask, AND
  PUT (48, 61), Enemy, XOR
  GET (17, 7)-(150, 95), Image
  RETURN
DarkSlime:
  Enemy$ = "Dark Slime"
  EHP = 10
  EGP = 6
  EEXP = 4
  EST = 1
  EDEF = 1
  EAG = 2
  DEF SEG = VARSEG(Mask(1)): BLOAD "slime1.dgi", VARPTR(Mask(1))
  DEF SEG = VARSEG(Enemy(1)): BLOAD "dslime.dgi", VARPTR(Enemy(1))
  PUT (48, 61), Mask, AND
  PUT (48, 61), Enemy, XOR
  GET (17, 7)-(150, 95), Image
  RETURN
Skull:
  Enemy$ = "Skull"
  EHP = 12
  EGP = 11
  EEXP = 9
  EST = 2
  EDEF = 1
  EAG = 2
  DEF SEG = VARSEG(Image(1)): BLOAD "skull.dgi", VARPTR(Image(1))
  PUT (17, 7), Image, PSET
  GET (17, 7)-(150, 95), Image
  RETURN
Shade:
  Enemy$ = "Lysia"
  EHP = 492
  EGP = 485
  EEXP = 481
  EST = 8
  EDEF = 8
  EAG = 5
  EMG = 5
  GOSUB EmpressLysia
  RETURN
EmpressLysia:
  GOSUB CD
  LOCATE 17, 3
    PRINT UCASE$(Name$); ": What? Who said"
  LOCATE 18, 3
    PRINT "that?                        "
  WHILE INKEY$ = "": WEND
  DEF SEG = VARSEG(Mask(1)): BLOAD "lysia1.dgi", VARPTR(Mask(1))
  DEF SEG = VARSEG(Enemy(1)): BLOAD "lysia.dgi", VARPTR(Enemy(1))
  PUT (49, 22), Mask, AND
  PUT (49, 22), Enemy, XOR
  GET (17, 7)-(150, 95), Image
  LOCATE 19, 3
    PRINT "... I did.  You may address  "
  LOCATE 20, 3
    PRINT "me as Empress Lysia.  That   "
  LOCATE 21, 3
    PRINT "book belongs to me.  By      "
  LOCATE 22, 3
    PRINT "taking it, you have thusly   "
  LOCATE 23, 3
    PRINT "forfieted your life...       "
  WHILE INKEY$ = "": WEND
  RETURN
ShowMagic:
  LINE (135, 7)-(308, 104), 0, BF
  GOSUB CD
  LOCATE 2, 23
    PRINT "MAGIC"
  LOCATE 4, 18
    PRINT "1 "; Magic1$
  LOCATE 5, 18
    PRINT "2 "; Magic2$
  LOCATE 6, 18
    PRINT "3 "; Magic3$
  LOCATE 7, 18
    PRINT "4 "; Magic4$
  LOCATE 8, 18
    PRINT "5 "; Magic5$
  RETURN
RestoreStatus:
  LOCATE 2, 18
    PRINT LEFT$(Name$, 8)
  LOCATE 2, 33
    PRINT Race$
  LOCATE 4, 18
    PRINT "Compass:"
  LOCATE 6, 18
    PRINT "HP:"
  LOCATE 6, 33
    PRINT USING "######"; HP%
  LOCATE 13, 11
    PRINT USING "####"; HP%
  LOCATE 7, 18
    PRINT "MP:"
  LOCATE 7, 33
    PRINT USING "######"; MP%
  LOCATE 8, 18
    PRINT "EXP:"
  LOCATE 8, 33
    PRINT USING "######"; EX#
  LOCATE 9, 18
    PRINT "GP:"
  LOCATE 9, 33
    PRINT USING "######"; G#
  LOCATE 10, 18
    PRINT "LVL:"
  LOCATE 10, 33
    PRINT USING "######"; LVL%
  LOCATE 13, 18
    PRINT "Press 'F1' for help."
  RETURN
CD:
  FOR cleared = 17 TO 23
    LOCATE cleared, 3
      PRINT SPACE$(29)
  NEXT cleared
  RETURN

REM $STATIC
DEFSNG A-Z
SUB Blood
  CIRCLE (63, 40), 4, 40: PAINT (63, 40), 40, 40
  CIRCLE (57, 35), 1, 40: PAINT (57, 35), 40, 40
  CIRCLE (65, 46), 1, 40: PAINT (65, 46), 40, 40
  CIRCLE (69, 32), 1, 40: PAINT (69, 32), 40, 40
  CIRCLE (58, 44), 0, 40
  CIRCLE (67, 37), 0, 40
  CIRCLE (64, 34), 0, 40
  SLEEP 1
END SUB

SUB DisplayFire
DEFINT A-Z
  FOR radius = 0 TO 12
    CIRCLE (66, 50), radius, 43
    FOR Pause = 1 TO 500: NEXT Pause
  NEXT radius
  FOR radius = 13 TO 19
    CIRCLE (66, 50), radius, 42
    FOR Pause = 1 TO 500: NEXT Pause
  NEXT radius
  FOR radius = 20 TO 35
    CIRCLE (66, 50), radius, 41
    FOR Pause = 1 TO 500: NEXT Pause
  NEXT radius
END SUB

DEFSNG A-Z
SUB DisplayIce
DEFINT A-Z
  FOR radius = 0 TO 12
    CIRCLE (66, 50), radius, 9
    FOR Pause = 1 TO 500: NEXT Pause
  NEXT radius
  FOR radius = 13 TO 19
    CIRCLE (66, 50), radius, 1
    FOR Pause = 1 TO 500: NEXT Pause
  NEXT radius
  FOR radius = 20 TO 35
    CIRCLE (66, 50), radius, 201
    FOR Pause = 1 TO 500: NEXT Pause
  NEXT radius
END SUB

SUB Palette.FadeIn
DIM tT(1 TO 3)
FOR I = 1 TO 64
WAIT &H3DA, 8
  FOR O = 0 TO 255
    Palette.Get O, Pal
    tT(1) = Pal.Red
    tT(2) = Pal.Green
    tT(3) = Pal.Blue
    IF tT(1) < pData(O, 1) THEN tT(1) = tT(1) + 1
    IF tT(2) < pData(O, 2) THEN tT(2) = tT(2) + 1
    IF tT(3) < pData(O, 3) THEN tT(3) = tT(3) + 1
    Pal.Red = tT(1)
    Pal.Green = tT(2)
    Pal.Blue = tT(3)
    Palette.Set O, Pal
  NEXT O
NEXT I

END SUB

SUB Palette.Fadeout
DIM tT(1 TO 3)
FOR I = 0 TO 255
  Palette.Get I, Pal
  pData(I, 1) = Pal.Red
  pData(I, 2) = Pal.Green
  pData(I, 3) = Pal.Blue
NEXT I
FOR I = 1 TO 64
WAIT &H3DA, 8
  FOR O = 0 TO 255
    Palette.Get O, Pal
    tT(1) = Pal.Red
    tT(2) = Pal.Green
    tT(3) = Pal.Blue
    IF tT(1) > 0 THEN tT(1) = tT(1) - 1
    IF tT(2) > 0 THEN tT(2) = tT(2) - 1
    IF tT(3) > 0 THEN tT(3) = tT(3) - 1
    Pal.Red = tT(1)
    Pal.Green = tT(2)
    Pal.Blue = tT(3)
    Palette.Set O, Pal
  NEXT O
NEXT I
END SUB

SUB Palette.Get (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C7, nColor%
pInfo.Red = INP(&H3C9)
pInfo.Green = INP(&H3C9)
pInfo.Blue = INP(&H3C9)
END SUB

SUB Palette.Set (nColor%, pInfo AS PaletteType)
OUT &H3C6, &HFF
OUT &H3C8, nColor%
OUT &H3C9, pInfo.Red
OUT &H3C9, pInfo.Green
OUT &H3C9, pInfo.Blue
END SUB

