'This file, TITLE.BAS is the main menu file for Lith 2.01.  It allows the
'user to select begin game, restore game, options, and quit commands.
'
'If "begin" is selected, control of the program is transferred to the
'SELECT.BAS file.
'
'If "continue" is selected, control of the program is transferred to the
'RESTORE.BAS file.
'
'If "options" is selected, control of the program is transferred to the
'OPTIONS.BAS file.
'
'if "quit" is selected, control of the program is transferred to the
'COPYRITE.BAS file.

'if F1 is pressed, then a help file is displayed.

'These lines declare the SUB functions used in this file.
  DECLARE SUB DrawBack ()
  DECLARE SUB DrawMenu ()

'The lines below determine the variable values which are to be shared between
'chained files.
  COMMON SHARED sound1$, sound2$, sound3$, sound4$, sound5$, sound6$, sound7$, sound8$, sound9$, sound10$, sound11$, sound12$, sound13$, tune1$
  COMMON SHARED Delay%, sound$, speed$
  COMMON SHARED heal%, maxmp%, maxhp%, hp%, mp%, g#, st%, df%, ex#, ag%, ar%, lvl%, nextlvl#, mg%
  COMMON SHARED chest1%, chest2%, silverkey%, goldenkey%
  COMMON SHARED name$, race$, alignment$, position$, weapon$, armor$, shield$
  COMMON SHARED magic1$, magic2$, magic3$, magic4$, magic5$
  COMMON SHARED arm1$, arm2$, arm3$, arm4$, arm5$
  COMMON SHARED item1$, item2$, item3$, item4$, item5$
  COMMON SHARED level$, dc1c1%, dc1c2%, dc1c3%, dc1c4%
  COMMON SHARED Wallpaper%, Game%

SCREEN 13                               'Keeps the current screen mode
Game% = 0                               'and returns the value of the
                                        'game% variable to null.

CONST True = -1                         'Declares constants.
CONST False = 0

OPEN "options.gam" FOR INPUT AS #1      'Opens the file OPTIONS.GAM and
                                        'inputs the game's saved settings.
 
  INPUT #1, sound1$, sound2$, sound3$, sound4$, sound5$, sound6$, sound7$, sound8$, sound9$, sound10$, sound11$, sound12$, sound13$, tune1$
  INPUT #1, Delay%, sound$, speed$, Wallpaper%
CLOSE #1

DIM cursor(1 TO 300)                    'Sets up array variables for graphic
DEF SEG = VARSEG(cursor(1))             'image and loads image into the
BLOAD "cursor.dgi", VARPTR(cursor(1))   'variable.

CALL DrawBack                           'Calls subs to draw the backround and
CALL DrawMenu                           'menu.

Area = 1                                'Displays the cursor in its starting
PUT (110, 87), cursor, PSET             'position.

LOCATE 12, 18: COLOR 31: PRINT "BEGIN"  'Prints "begin" in brighter letters
COLOR 27                                'than the other menu choices.

DO WHILE Quit <> True                   'Main LOOP which loops until one of
  task = 0                              'the activated keys is pressed.
                                        'Note: Pressing the Esc key is the
                                        '      same as selecting quit.
 
  SELECT CASE INKEY$                    'This SELECT CASE statement is used
  CASE CHR$(0) + CHR$(72)               'to trap the arrow keys and the F1
    GOSUB CursorUp                      'key.
  CASE CHR$(0) + CHR$(80)
    GOSUB CursorDown
  CASE CHR$(0) + CHR$(59)
    GOSUB Help
  CASE CHR$(13)
    GOSUB Selection
  CASE CHR$(27)
    Quit = True
  END SELECT

LOOP

CHAIN "copyrite.bas"                    'Transfers program control to the
                                        'file COPYRITE.BAS

CursorUp:                               'Moves the cursor up one selection if
  IF task = 1 THEN RETURN               'the up arrow key has been pressed.
  task = 1
  PLAY "X" + VARPTR$(sound1$)
  IF Area = 1 THEN
    Area = 4
    COLOR 31: LOCATE 18, 18: PRINT "QUIT"
    COLOR 27: LOCATE 12, 18: PRINT "BEGIN"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 135), cursor, PSET
    RETURN
  END IF
  IF Area = 2 THEN
    Area = 1
    COLOR 31: LOCATE 12, 18: PRINT "BEGIN"
    COLOR 27: LOCATE 14, 18: PRINT "CONTINUE"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 87), cursor, PSET
    RETURN
  END IF
  IF Area = 3 THEN
    Area = 2
    COLOR 31: LOCATE 14, 18: PRINT "CONTINUE"
    COLOR 27: LOCATE 16, 18: PRINT "OPTIONS"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 103), cursor, PSET
    RETURN
  END IF
  IF Area = 4 THEN
    Area = 3
    COLOR 31: LOCATE 16, 18: PRINT "OPTIONS"
    COLOR 27: LOCATE 18, 18: PRINT "QUIT"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 119), cursor, PSET
    RETURN
  END IF

CursorDown:                             'Moves the cursor down one selection
  IF task = 1 THEN RETURN               'if the down arrow key is pressed.
  task = 1
  PLAY "X" + VARPTR$(sound1$)
  IF Area = 1 THEN
    Area = 2
    COLOR 31: LOCATE 14, 18: PRINT "CONTINUE"
    COLOR 27: LOCATE 12, 18: PRINT "BEGIN"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 103), cursor, PSET
    RETURN
  END IF
  IF Area = 2 THEN
    Area = 3
    COLOR 31: LOCATE 16, 18: PRINT "OPTIONS"
    COLOR 27: LOCATE 14, 18: PRINT "CONTINUE"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 119), cursor, PSET
    RETURN
  END IF
  IF Area = 3 THEN
    Area = 4
    COLOR 31: LOCATE 18, 18: PRINT "QUIT"
    COLOR 27: LOCATE 16, 18: PRINT "OPTIONS"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 135), cursor, PSET
    RETURN
  END IF
  IF Area = 4 THEN
    Area = 1
    COLOR 31: LOCATE 12, 18: PRINT "BEGIN"
    COLOR 27: LOCATE 18, 18: PRINT "QUIT"
    LINE (110, 87)-(125, 145), 0, BF
    PUT (110, 87), cursor, PSET
    RETURN
  END IF

Selection:                              'Checks where the cursor is if the      
  IF task = 1 THEN RETURN               'enter key has been pressed.
  task = 1
  IF Area = 1 THEN CHAIN "cinema1.bas"
  IF Area = 2 THEN CHAIN "restore.bas"
  IF Area = 3 THEN CHAIN "options.bas"
  IF Area = 4 THEN
    CHAIN "copyrite.bas"
    SYSTEM
  END IF
  RETURN

Help:
  IF task = 1 THEN RETURN
  WHILE INKEY$ <> "": WEND              'Empty the keyboard buffer.
  CHAIN "help.bas"

SUB DrawBack STATIC
 
  DIM Logo(1 TO 13000), Help(1 TO 1600)   'Sets up array variable for graphic
  DEF SEG = VARSEG(Logo(1))               'image and loads the image into the
  BLOAD "lith.dgi", VARPTR(Logo(1))       'variable.
  DEF SEG = VARSEG(Help(1))
  BLOAD "help.dgi", VARPTR(Help(1))

  LINE (0, 0)-(319, 44), 201, BF          'This SUB draws the backround
  LINE (0, 45)-(319, 74), 104, BF         'of the main menu screen.
  LINE (0, 75)-(319, 94), 1, BF
  LINE (0, 95)-(319, 109), 9, BF
  LINE (0, 110)-(319, 119), 80, BF
  LINE (0, 120)-(319, 129), 191, BF
  LINE (0, 130)-(319, 144), 120, BF
  LINE (0, 145)-(319, 164), 2, BF
  LINE (0, 165)-(319, 194), 47, BF
  LINE (0, 195)-(319, 199), 70, BF
  PUT (85, 0), Logo, PSET
  PUT (200, 170), Help, PSET
END SUB

SUB DrawMenu STATIC
 
  LINE (50, 82)-(269, 150), 185, B              'This SUB draws the border of
  LINE (51, 83)-(268, 149), 113, B              'the menu box and prints the
  LINE (52, 84)-(267, 148), 6, B                'menu commands on the screen.
  LINE (53, 85)-(266, 147), 113, B
  LINE (54, 86)-(265, 146), 0, BF
  COLOR 27
  LOCATE 12, 18
    PRINT "BEGIN"
  LOCATE 14, 18
    PRINT "CONTINUE"
  LOCATE 16, 18
    PRINT "OPTIONS"
  LOCATE 18, 18
    PRINT "QUIT"
  COLOR 15

END SUB

