'
'         Light Airplane Computer-Based Trainer
'                  by Guy Leblanc
'
'                    F5 to run
'
'
CONST Cycles = 7!         ' Refresh rate
'
CONST Pi = 3.141592654#
SCREEN 8: COLOR 15, 7     ' SVGA monitor,  640 x 200 graphics
CLS 0: RANDOMIZE TIMER
'
10 GOSUB Initialization
20 GOSUB Performance
30 Start = TIMER: CLS 0
'
50 GOSUB Display
GOSUB Instruments
'
X = X + V * SIN(Hdg * Pi / 180) * 1.47 / Cycles         ' Position change
Y = Y + V * COS(Hdg * Pi / 180) * 1.47 / Cycles
IF ABS(Y) > 0 THEN Brg = ATN(X / Y) * 180 / Pi          ' Bearing
IF Y = 0 AND X >= 0 THEN Brg = 90
IF Y = 0 AND X < 0 THEN Brg = 270
IF Y < 0 AND X >= 0 THEN Brg = 180 + Brg
IF Y < 0 AND X < 0 THEN Brg = Brg + 180
IF Brg < 0 THEN Brg = Brg + 360
IF Brg > 360 THEN Brg = Brg - 360
DME = SQR(X * X + Y * Y) / 608                          ' Distance
'
Kbd$ = ""
55 Temp$ = INKEY$: IF Temp$ <> "" THEN Kbd$ = Temp$     ' New input
dLong = STICK(1): dLat = STICK(0)
IF TIMER < Start + (1 / Cycles) THEN 55
Start = TIMER
'                        ' Joystick Inputs
' Longitudinal -15 to +15, Lateral -45 to +45
IF V < 1.1 * (Vs - Flap / 5) THEN Pitch = PitRf + (dLong * mLong + bLong) * COS(AoB * Pi / 180) * 15: GOTO 57
Pitch = PitRf + (dLong * mLong + bLong) * COS(AoB * Pi / 180) * 15 - ABS(AoB / 9)
57 IF V > Vs - Flap / 5 THEN AoB = AoB + (dLat * mLat + bLat) * 5
'
SELECT CASE Kbd$       ' Keyboard Inputs
   CASE CHR$(0) + "H":
' ************** ADJUSTMENT PifRf .5
   RPM = RPM + 100: IF RPM < 2600 AND Z > 5 THEN PitRf = PitRf + .5
   CASE CHR$(0) + "P": RPM = RPM - 100: IF RPM > 500 AND Z > 5 THEN PitRf = PitRf - .5
   CASE CHR$(0) + "K": Ped = Ped - 1        ' Left arrow
   CASE CHR$(0) + "M": Ped = Ped + 1        ' Right arrow
   CASE ELSE
END SELECT
IF Kbd$ = "x" OR Kbd$ = "X" THEN PitRf = PitRf - (RPM - 500) / 200: RPM = 500
'  Trim Inputs
IF Kbd$ = "-" AND TrimPos > -9 THEN TrimPos = TrimPos - 1: PitRf = PitRf - .7:
IF Kbd$ = "+" AND TrimPos < 9 THEN TrimPos = TrimPos + 1: PitRf = PitRf + .7

' Flap Inputs
IF Kbd$ = "2" AND Flap < 40 THEN Flap = Flap + 10: PitRf = PitRf - 1.5
IF Kbd$ = "8" AND Flap > 0 THEN Flap = Flap - 10: PitRf = PitRf + 1.5
'
61 IF Kbd$ = "s" OR Kbd$ = "S" THEN GOSUB Settings
IF Kbd$ = "q" OR Kbd$ = "Q" OR Kbd$ = CHR$(27) THEN 9999
IF Kbd$ <> "c" AND Kbd$ <> "C" THEN 62
IF Carb = 0 THEN Carb = 1: RPM = RPM - 200: GOTO 62
IF Carb = 1 THEN Carb = 0: RPM = RPM + 200: IF RPM < 300 THEN RPM = 0
'
62 IF V < 1 THEN Ped = 0
IF Ped < -7 THEN Ped = -7
IF Ped > 7 THEN Ped = 7
IF RPM < 0 THEN RPM = 0
IF RPM > 0 AND RPM < 500 THEN RPM = 500
IF RPM > 2700 THEN RPM = 2700
'
'                         ' AERO ROUTINE
'                ''' Ground / Low Altitude Model '''
IF Z >= 5 THEN 70
IF ABS(AoB) < 20 AND Vv > -600 THEN 66
CLS 0: COLOR 15, 4: LOCATE 12, 35: PRINT "C R A S H"
LOCATE 22, 27: PRINT "AoB = "; INT(AoB), "Vv = "; INT(Vv)
64 Kbd$ = INKEY$: IF Kbd$ = "" THEN 64
PitRf = 0: AoB = 0: V = 0: RPM = 0: Flap = 0: TrimPos = 0: : GOSUB Settings
66 IF Z < 1 THEN Z = 0: IF Vv < 0 THEN Vv = 0   ' No flight below ground!
IF V < 1 AND RPM < 1300 THEN V = 0: DelHdg = 0: GOTO 68  ' To get moving (Static Friction)
IF V = 0 AND RPM > 1300 THEN V = 1: GOTO 68
V = V + (RPM - 1300) / 250 / Cycles
IF V > Vs THEN 70
DelHdg = (Ped - RPM / 150 / (V / 70 + 5)) / Cycles
Hdg = Hdg + DelHdg
IF Hdg > 360 THEN Hdg = Hdg - 360
IF Hdg < 0 THEN Hdg = Hdg + 360
68 Z = 0: Pitch = 0: AoB = 0: Vv = 0: GOTO 50
'                  ''' Flight Model'''
70 Pitch = Pitch + INT(.5 + Turb * (RND * 2 - 1) / Cycles)
IF Pitch > MaxPitch THEN Pitch = MaxPitch       ' Max Pitch Angle
IF Pitch < -MaxPitch THEN Pitch = -MaxPitch
AoB = AoB + INT(.5 + Turb * (RND * 6 - 3) / Cycles)
IF AoB > MaxAoB THEN AoB = MaxAoB               ' Max Bank Angle
IF AoB < -MaxAoB THEN AoB = -MaxAoB
IF ABS(AoB) < 5 AND V > Vs AND V < Vne THEN AoB = AoB * ((Cycles - 2) / Cycles)' Help level off
VT = Vne / 15 * INT(4 - Pitch - Flap / 5) + RPM / Vne * 6 - 20
V = V + (VT - V) / 7 / Cycles + Turb * (RND * 6 - 3) / Cycles
IF V < .9 * (Vs - Flap / 5) THEN V = .9 * (Vs - Flap / 5)
80 IF V > Vne * 1.14 THEN V = Vne * 1.14
IF AoB < 0 THEN DelHdg = -1250 / V / Cycles * ((1 / COS(AoB * Pi / 180)) ^ 2 - 1) ^ .5
IF AoB >= 0 THEN DelHdg = 1250 / V / Cycles * ((1 / COS(AoB * Pi / 180)) ^ 2 - 1) ^ .5
DelHdg = DelHdg + (Ped / 7 - (RPM - 1300) / 2000) / Cycles / 2
Hdg = Hdg + DelHdg + INT(.5 + Turb * (RND * 4 - 2) / Cycles)
IF Hdg > 360 THEN Hdg = Hdg - 360               ' Hdg 0 to 360 degrees
IF Hdg < 0 THEN Hdg = Hdg + 360
IF V >= Vmax THEN Vv = (V - Vmax) / (Vne - Vmax) * (VVne - VVmax) + VVmax:
GOTO 90
IF V >= Vmin THEN Vv = (V - Vmin) / (Vmax - Vmin) * (VVmax - VVmin) + VVmin:
GOTO 90
Vv = (Vmin - V) / (Vmin - Vs) * (VVs - VVmin) + VVmin
90 Vv = Vv / COS(AoB * Pi / 180) + RPM ^ 1.7 / 500 + (V - VT) * V / 5 - Flap * 30
Z = Z + Vv / 60 / Cycles: IF Z > 13000 THEN Z = 13000    'Max Height
IF Z < .1 AND Vv < 0 THEN Z = 0: Vv = 0: GOTO 50
'
'                       Stall, Spin & Spiral Modes
IF V < 1.1 * (Vs - Flap / 5) THEN SOUND 850, .3    ' Stall Tone
IF V < Vs - Flap / 5 AND Z > 0 THEN AoB = AoB * (Cycles + 2) / Cycles + (RND * 2) - 1: Vv = Vv + VVs
IF V > .8 * Vne THEN AoB = AoB * (Cycles + .5) / Cycles + (RND * 2) - 1
'
GOTO 50
END
'
'
100 Initialization:

OPEN "GLEBCBT.DAT" FOR APPEND AS #1
PRINT #1, 999: RESET                    ' Adds a code at end of file
''
OPEN "GLEBCBT.DAT" FOR INPUT AS #1
INPUT #1, Temp
IF Temp <> 999 THEN 110                 ' If file exists, get data
RESET: GOSUB StikCal
Rwy = 360: Elev = 0: Ident$ = "C-GLEB"
GOTO 120
''
110 INPUT #1, mLong, bLong, mLat, bLat, Rwy, Elev, Ident$
RESET

'' mLong = .026: mLat = .026       ' Joystick Calibration
'' bLong = -1.316: bLat = -1.12
'
120 Z = 0!                       ' Altitude
V = 0: Hdg = Rwy + 10
IF Hdg > 360 THEN Hdg = Hdg - 360
Pitch = 0!: AoB = 0!: PitRf = 0! ' Wings level
TrimPos = 0                      ' Trim Setting
Turb = 1                         ' Turbulence Level
RPM = 0                          ' Initial Engine RPM
FOV = 1                          ' Outside View ON
Map = 1                          ' Map Mode ON
Cct = 0                          ' Circuit Mode OFF
X = 2400                         ' Initial position
Y = 700
RETURN
'
200 Performance:         ' Aircraft performance characteristics
Vs = 50!                 ' Stall in mph
VVs = -1200!             ' Sink rate in fpm
Vmin = 70!               ' Min Sink
VVmin = -585!
Vmax = 80!               ' Max Glide
VVmax = -610!
Vne = 174!               ' Never Exceed
VVne = -3500!
MaxPitch = 15: MaxAoB = 51
RETURN
'
'
3000 Display:                   ''' FORWARD DISPLAY '''
IF FOV = 0 THEN RETURN
IF FOV = 2 AND Cct = 1 THEN 3100
IF FOV = 2 AND Map = 1 THEN 3500
LINE (1, 8)-(639, 65), 3, BF
LINE (320 - 2.8 * Hx * 1.5, 36 - 2.8 * (Hy * 1.5 - Pitch / 2))-(320 + 2.8 * Hx * 1.5, 36 + 2.8 * (Hy * 1.5 + Pitch / 2)), 7: PAINT (320, 60), 6, 7
LINE (5, 65)-(35, 43), 7: LINE STEP(0, 0)-STEP(570, 0), 7   ' Shroud
LINE STEP(0, 0)-(635, 65), 7: PAINT (300, 65), 7, 7
PAINT (35, 44), 7, 7: PAINT (603, 44), 7, 7
PSET (320, 37), 8: PSET (320, 31), 8    ' Windshield marks
3050 RETURN
'
'        '''''''''''' CIRCUIT & VASIS DISPLAY '''''''''''''''
3100 LINE (280, 20)-(315, 60), 7, BF: PSET (Rx, Ry), 7  'Erase VASIS & Point
'      ''' VASIS '''
IF DME > 100 OR DME < 2 OR Brg > 195 OR Brg < 175 THEN 3200   ' Hide VASIS
Size = 1
IF DME <= 35 THEN Size = 2
IF DME < 15 THEN Size = 7
GS = (Z / (DME - 2)) / 608
IF GS <= .0612 THEN LINE (295, 42)-(295 - Size, 42 - Size / 3), 4, BF
IF GS > .0612 THEN LINE (295, 42)-(295 - Size, 42 - Size / 3), 15, BF
IF GS <= .0437 THEN LINE (295, 44)-(295 - Size, 44 + Size / 3), 4, BF
IF GS > .0437 THEN LINE (295, 44)-(295 - Size, 44 + Size / 3), 15, BF
'       ''' Circuit '''
3200 IF DME < 15 THEN Rx = 310 + X / 120: Ry = 40 - Y / 120 / 2.4: LINE (305, 25)-(315, 55), 8, BF: PSET (Rx, Ry), 15: RETURN
IF DME <= 35 THEN Rx = 310 + X / 310: Ry = 40 - Y / 310 / 2.4: LINE (307, 33)-(311, 45), 8, BF: PSET (Rx, Ry), 15: RETURN
IF DME > 35 THEN Rx = 310 + X / 800: Ry = 40 - Y / 800 / 2.4: LINE (308, 38)-(309, 42), 8, BF: PSET (Rx, Ry), 15: RETURN
3500 '  ''' Map '''
PSET (Rx, Ry), 7                 ' Erase aircraft
CIRCLE (310, 40), 5, 8           ' Aerodrome
IF DME < 150 THEN Rx = 310 + X / 1250: Ry = 40 - Y / 1250 / 2.4: PSET (Rx, Ry), 15: RETURN
IF DME < 500 THEN Rx = 310 + X / 4200: Ry = 40 - Y / 4200 / 2.4: PSET (Rx, Ry), 15: RETURN
IF DME < 1500 THEN Rx = 310 + X / 12500: Ry = 40 - Y / 12500 / 2.4: PSET (Rx, Ry), 15: RETURN
Rx = 310 + X / 99000: Ry = 40 - Y / 99000 / 2.4: PSET (Rx, Ry), 15: RETURN
RETURN
'
'
4000 Instruments:               ''' INSTRUMENT PANEL '''
''      Row1 = 105: R2 = 167
''      Column1 = 82: C2 = 244: C3 = 406
''      RowText1 = 13: RT2 = 19
''      ColumnText1 = 13: CT2 = 38: CT3 = 62
Size = 70
LOCATE 1, 8: PRINT INT(Rwy / 10 + .5),
IF Rwy < 95 THEN LOCATE 1, 6: PRINT INT(Rwy / 10 + .5) + 1000,
LOCATE 1, 1: PRINT " Runway "
LOCATE 1, 14: PRINT Ident$, , , ,
LOCATE 1, 57: PRINT "S - Settings, Q  - Quit "
'
'       Airspeed
Cx = 82: Cy = 105
LINE (10, 72)-(154, 135), 7, BF                       ' Eraser
CIRCLE (Cx, Cy), Size, 8
LINE (80, 77)-(84, 78), 15, BF                        ' Ref Marks
PSET (136, 89), 15: PSET (148, 102), 15: PSET (143, 115), 15
PSET (125, 126), 15: PSET (36, 125), 15
PSET (97, 132), 15
CIRCLE (Cx, Cy), Size - 8, 15, 5.7, .7                 ' White Arc
CIRCLE (Cx, Cy), Size - 8, 10, 5.34, 5.7               ' Green Arc
CIRCLE (Cx, Cy), Size - 8, 14, 4.5, 5.34               ' Yellow Arc
LINE (64, 132)-(66, 131), 4, BF
Temp = (90 - (1.4 * V)) * Pi / 180
ASx = Cx + Size * COS(Temp) * .85
ASy = Cy - Size / 2.4 * SIN(Temp) * .85
LINE (Cx + 1, Cy)-(ASx + 1, ASy), 15: LINE (Cx - 1, Cy)-(ASx, ASy), 15
LOCATE 14, 9: PRINT INT(V + .5)
'
'       Altimeter
Cx = 406: Cy = 105
LINE (333, 72)-(479, 135), 7, BF                ' Eraser
CIRCLE (Cx, Cy), Size, 8
PSET (Cx, Cy - Size / 2.4 + 1), 15              ' Ref Marks
PSET (445, 83), 15: PSET (468, 97), 15
PSET (468, 113), 15: PSET (445, 127), 15
PSET (Cx, Cy + Size / 2.4 - 1), 15
PSET (367, 127), 15: PSET (343, 113), 15
PSET (343, 97), 15: PSET (367, 83), 15
Temp = (90 - ((Elev + Z) / 2.779)) * Pi / 180
ALx = Cx + Size * COS(Temp) * .85
ALy = Cy - Size / 2.4 * SIN(Temp) * .85
LINE (Cx - 1, Cy)-(ALx, ALy), 15: LINE (Cx + 1, Cy)-(ALx + 1, ALy), 15
LOCATE 13, 49: PRINT 10 * INT(.5 + (Elev + Z) / 10)
LOCATE 14, 50: PRINT "feet"
'
'       Vertical Speed
Cx = 406: Cy = 167
LINE (325, 136)-(479, 197), 7, BF                   ' Eraser
CIRCLE (Cx, Cy), Size, 8
LINE (337, 166)-(339, 168), 15, BF                  ' Ref Marks
LINE (354, 150)-(356, 149), 15, BF: LINE (393, 139)-(395, 140), 15, BF
LINE (354, 184)-(356, 185), 15, BF: LINE (393, 194)-(395, 195), 15, BF
Temp = (-.08 * Vv + 180) * Pi / 180
VX = Cx + Size * COS(Temp) * .85
VY = Cy - Size / 2.4 * SIN(Temp) * .85
LINE (Cx - 1, Cy)-(VX, VY), 15: LINE (Cx + 1, Cy)-(VX, VY), 15
LOCATE 21, 49: PRINT 50 * INT(Vv / 50)
LOCATE 22, 50: PRINT "fpm"
'
'       Attitude Display
Cx = 244: Cy = 105
LINE (155, 72)-(333, 135), 7, BF        ' Eraser
Hx = 1.27 * Size * COS(-AoB * Pi / 180)
Hy = 1.27 * Size / 2.4 * SIN(-AoB * Pi / 180)
LINE (Cx - Hx, Cy - Hy + Pitch)-(Cx + Hx, Cy + Hy + Pitch), 8
CIRCLE (Cx, Cy), Size, 8
PAINT (Cx, Cy + 25), 8, 8
LINE (Cx - Hx, Cy - Hy + Pitch)-(Cx + Hx, Cy + Hy + Pitch), 7
CIRCLE (Cx, Cy), 2, 15                                     ' Airplane
LINE (Cx - Size / 1.8, Cy)-(Cx - 10, Cy), 15, BF
LINE (Cx + Size / 1.8, Cy)-(Cx + 10, Cy), 15, BF
LINE (Cx - 1, Cy - 28)-(Cx + 1, Cy - 28), 15, BF           ' Ref Marks
PSET (Cx - 13, Cy - 27), 15: PSET (Cx + 13, Cy - 27), 15
PSET (Cx - 24, Cy - 26), 15: PSET (Cx + 24, Cy - 26), 15
PSET (Cx - 35, Cy - 24), 15: PSET (Cx + 35, Cy - 24), 15
PSET (Cx - 47, Cy - 19), 15: PSET (Cx + 47, Cy - 19), 15
CIRCLE (Cx + Hy * 1.6, Cy - Hx / 5.76 * 1.6), 2, 15        ' AoB Pointer
'
'       Turn & Slip Display
4700 Cx = 82: Cy = 167
LINE (10, 135)-(163, 197), 7, BF                       ' Eraser
CIRCLE (Cx, Cy), Size, 8                               ' Frame
LINE (81, 150)-(84, 148), 15, BF
Temp = DelHdg * 50: IF Temp > 15 THEN Temp = 15
IF Temp < -15 THEN Temp = -15
LINE (Cx - 1, Cy + 5)-(Cx + Temp, Cy - 15), 15         ' Turn pointer
LINE (Cx + 1, Cy + 5)-(Cx + Temp + 1, Cy - 15), 15
LINE (Cx - 33, Cy + 14)-(Cx + 33, Cy + 22), 8, B       ' Ball Race
Ball = AoB * 5 - DelHdg * 100
IF Ball > 27 THEN Ball = 27
IF Ball < -27 THEN Ball = -27
CIRCLE (Cx + Ball, Cy + 18), 5, 15: PAINT (Cx + Ball, Cy + 18), 15, 15
LINE (Cx - 8, Cy + 14)-(Cx + 8, Cy + 22), 8, B
'
'       Heading Display
Cx = 244: Cy = 167
IF Cct = 1 THEN Hdg = Hdg + Rwy: IF Hdg > 359 THEN Hdg = Hdg - 360
LINE (164, 135)-(324, 197), 7, BF                     ' Eraser
CIRCLE (Cx, Cy), Size, 8
LINE (Cx - Size, Cy)-(Cx - Size + 6, Cy), 8, BF    ' Ref Marks
LINE (Cx + Size, Cy)-(Cx + Size - 6, Cy), 8, BF
LINE (Cx - 1, Cy + Size / 2.4)-(Cx + 1, Cy + Size / 2.4 - 2), 8, BF
LINE (Cx - 1, Cy - Size / 2.4)-(Cx + 1, Cy - Size / 2.4 + 2), 8, BF
Dx = Size / 2.7 * SIN(-Hdg * Pi / 180)
Dy = Size / 2.7 * COS(-Hdg * Pi / 180)
CIRCLE (Cx + Dx * 2.4, Cy - Dy), 4, 15    ' North
CIRCLE (Cx - Dx * 2.4, Cy + Dy), 2, 15    ' South
CIRCLE (Cx + Dy * 2.4, Cy + Dx), 2, 15    ' East
CIRCLE (Cx - Dy * 2.4, Cy - Dx), 2, 15    ' West
Dx = Size / 2.7 * SIN((30 - Hdg) * Pi / 180)
Dy = Size / 2.7 * COS((30 - Hdg) * Pi / 180)
PSET (Cx + Dx * 2.4, Cy - Dy), 15         ' 030 Mark
PSET (Cx - Dx * 2.4, Cy + Dy), 15         ' 120 Mark
PSET (Cx + Dy * 2.4, Cy + Dx), 15         ' 210 Mark
PSET (Cx - Dy * 2.4, Cy - Dx), 15         ' 300 Mark
Dx = Size / 2.7 * SIN((60 - Hdg) * Pi / 180)
Dy = Size / 2.7 * COS((60 - Hdg) * Pi / 180)
PSET (Cx + Dx * 2.4, Cy - Dy), 15         ' 060 Mark
PSET (Cx - Dx * 2.4, Cy + Dy), 15         ' 150 Mark
PSET (Cx + Dy * 2.4, Cy + Dx), 15         ' 240 Mark
PSET (Cx - Dy * 2.4, Cy - Dx), 15         ' 330 Mark
'                              ' Runway Bug
Dx = Size / 2.7 * 2.4 * SIN((Rwy - Hdg) * Pi / 180)
Dy = Size / 2.7 * COS((Rwy - Hdg) * Pi / 180)
LINE (Cx - 1 + Dx, Cy - Dy - 1)-(Cx + 2 + Dx, Cy - Dy + 1), 1, B
IF Hdg < 10 THEN LOCATE 19, 31: PRINT INT(Hdg): LOCATE 19, 30: PRINT "00":
GOTO 4500
IF Hdg < 100 THEN LOCATE 19, 30: PRINT INT(Hdg): LOCATE 19, 30: PRINT "0":
GOTO 4500
LOCATE 19, 29: PRINT INT(Hdg)
4500 LINE (Cx - 1, Cy - 5)-(Cx + 1, Cy + 5), 8, BF    ' Airplane Symbol
LINE (Cx - 15, Cy - 3)-(Cx + 15, Cy - 2), 8, BF
LINE (Cx - 5, Cy + 5)-(Cx + 5, Cy + 5), 8, BF
IF Cct = 1 THEN Hdg = Hdg - Rwy: IF Hdg < 0 THEN Hdg = Hdg + 360
'
'       ADF Display
IF NAids = 0 THEN 4750
Cx = 244: Cy = 167
Temp = Brg - Hdg
AX = Size / 2.7 * 2.4 * SIN(Temp * Pi / 180)
AY = Size / 2.7 * COS(Temp * Pi / 180)
LINE (Cx + AX, Cy - AY)-(Cx - AX, Cy + AY), 15
CIRCLE (Cx - AX, Cy + AY), 3, 15
'
'       DME Display
LOCATE 19, 20: PRINT "000.0"
IF DME > 9999 THEN LOCATE 19, 20: PRINT "999.9": GOTO 4600
IF DME < 1 THEN LOCATE 19, 20: PRINT "000.0": GOTO 4600
IF DME < 10 THEN LOCATE 19, 22: PRINT INT(DME) / 10: LOCATE 19, 20: PRINT "000": GOTO 4600
IF DME < 100 THEN LOCATE 19, 21: PRINT INT(DME) / 10: LOCATE 19, 20: PRINT "00": GOTO 4600
IF DME < 1000 THEN LOCATE 19, 20: PRINT INT(DME) / 10: LOCATE 19, 20: PRINT "0": GOTO 4600
LOCATE 19, 19: PRINT INT(DME + .5) / 10
4600 LINE (178, 149)-(181, 150), 15, BF
'
'       Engine RPM
4750 Cx = 555: Cy = 105: Temp = Size / 1.5
LINE (480, 72)-(627, 127), 7, BF                ' Eraser
CIRCLE (Cx, Cy), Temp, 8: CIRCLE (Cx, Cy), Temp - 5, 10, .5, 1.6
LINE (593, 98)-(596, 99), 4, BF                 ' Red Line
LINE (Cx - 2, Cy + Temp / 2.4)-(Cx + 2, Cy + Temp / 2.4), 15, BF
Temp = (-RPM / 11 - 90) * Pi / 180
RPx = Cx + Size * COS(Temp) / 1.75
RPy = Cy - Size / 2.4 * SIN(Temp) / 1.75
LINE (Cx - 1, Cy)-(RPx - 1, RPy), 15
LINE (Cx, Cy)-(RPx, RPy), 15
LOCATE 13, 69: PRINT 0
IF RPM > 0 THEN LOCATE 13, 68: PRINT INT(RPM)
LOCATE 14, 69: PRINT "RPM"
'
'       ILS Display
IF NAids = 0 THEN 4900
4775 Cx = 244: Cy = 105
LINE (Cx - 80, Cy + 30)-(Cx + 80, Cy + 32), 7, BF  'Localizer Eraser
LINE (Cx + 75, Cy - 30)-(Cx + 80, Cy + 30), 7, BF  'Glide Slope Eraser
CIRCLE (Cx + 77, Cy), 1, 8: CIRCLE (Cx, Cy + 31), 1, 8
Temp = Brg: IF Map = 1 THEN Temp = Brg - Rwy: IF Temp < 0 THEN Temp = Temp + 360
IF Temp > 177.5 AND Temp < 182.5 THEN CIRCLE (Cx - (180 - Temp) * 25, Cy + 31), 2, 15: GOTO 4800
'       Backcourse
IF Temp < 2.5 THEN CIRCLE (Cx - Temp * 25, Cy + 31), 2, 15: GOTO 4900
IF Temp > 357.5 THEN CIRCLE (Cx + (360 - Temp) * 25, Cy + 31), 2, 15: GOTO 4900
'       Glide Slope
4800 IF DME > 2 THEN GS = (Z / (DME - 2)) / 608
IF GS < .04 OR GS > .065 THEN 4900
CIRCLE (Cx + 77, Cy + 2000 * (GS - .0525)), 2, 15
'
'       Flaps Display
4900 Cx = 615: Cy = 160
LINE (570, 125)-(627, 197), 7, BF               ' Eraser
LINE (Cx, Cy - 15)-(Cx + 1, Cy + 21), 8, BF
Fpos = Flap - 16
CIRCLE (Cx, Cy + Fpos * .8), 3, 15: PAINT (Cx, Cy + Fpos * .8), 15, 15
LOCATE 19, 73: PRINT "  0-"
LOCATE 20, 73: PRINT " 10-"
LOCATE 21, 73: PRINT " 20-"
LOCATE 22, 73: PRINT " 30-"
LOCATE 23, 73: PRINT " 40-"
'
'       Trim Display
Cx = 545: Cy = 170
LINE (480, 126)-(570, 197), 7, BF           ' Eraser
LINE (Cx, Cy - 25)-(Cx + 1, Cy + 25), 8, BF
LINE (Cx - 10, Cy)-(Cx - 5, Cy + 1), 15, BF
CIRCLE (Cx, Cy + TrimPos * 2.5), 3, 15: PAINT (Cx, Cy + TrimPos * 2.5), 15, 15
'
'       Carburator Heat Display
IF Carb = 0 THEN LINE (490, 180)-(515, 190), 1, BF
IF Carb = 1 THEN LINE (490, 180)-(515, 190), 4, BF
'
RETURN
'
'
5000 Conversion:
IF Cct = 1 AND Map = 0 THEN 5010
IF Cct = 0 AND Map = 1 THEN Rwy = -Rwy: GOTO 5010
RETURN
5010 Hdg = Hdg + Rwy: IF Hdg > 360 THEN Hdg = Hdg - 360
IF Hdg < 0 THEN Hdg = Hdg + 360
Temp = Brg + Rwy: IF Temp > 360 THEN Temp = Temp - 360
IF Temp < 0 THEN Temp = Temp + 360
X = DME * 608 * SIN(Temp * Pi / 180)
Y = DME * 608 * COS(Temp * Pi / 180)
IF Cct = 0 AND Map = 1 THEN Rwy = -Rwy
RETURN
'
'
6000 StikCal: COLOR 15, 7          'Joystik Calibration
CLS 0: LOCATE 2, 30: PRINT "JOYSTICK CALIBRATION"
LOCATE 6, 5: INPUT "Move the joystick FORWARD, then press enter", Temp$
Fwd = STICK(1): CLS
LOCATE 8, 5: INPUT "Move the joystick AFT, then press enter", Temp$
Aft = STICK(1): CLS
LOCATE 10, 5: INPUT "Move the joystick LEFT, then press enter", Temp$
Left = STICK(0): CLS
LOCATE 12, 5: INPUT "Move the joystick RIGHT, then press enter", Temp$
Right = STICK(0): CLS
LOCATE 15, 15: INPUT "CENTER the joystick, then press enter", Temp$
cLong = STICK(1): cLat = STICK(0): CLS : GOTO 6020
6010 Fwd = 11: Aft = 87: Left = 5: Right = 81: cLong = 50: cLat = 43
6020 mLong = 2 / (Aft - Fwd): bLong = -2 * cLong / (Aft - Fwd)
mLat = 2 / (Right - Left): bLat = -2 * cLat / (Right - Left)
RETURN
'
'
7000 KeyLst: COLOR 15, 7          ' List of Controls
CLS 0: LOCATE 2, 28: PRINT "List of Keyboard Controls"
LOCATE 5, 10: PRINT "Throttle: Up & Down Arrows"
LOCATE 8, 10: PRINT "Pedals: Left & Right Arrows"
LOCATE 11, 10: PRINT "Nose Down Trim:  -        < Use numerical keypad >"
LOCATE 12, 10: PRINT "Nose  Up  Trim:  + "
LOCATE 15, 10: PRINT "Raise Flaps:  8           < Use numerical keypad >"
LOCATE 16, 10: PRINT "Lower Flaps:  2"
LOCATE 19, 10: PRINT "Carburetor Heat: C"
7010 LOCATE 22, 30: PRINT "Hit any key to Exit"
IF INKEY$ <> "" THEN RETURN
GOTO 7010
'
'
9000 Settings: COLOR 15, 7
CLS 0: LOCATE 2, 35: PRINT "SETTINGS"
LOCATE 4, 5: PRINT "Display Modes:"
LOCATE 6, 9: PRINT "W - Window", : IF FOV = 1 THEN PRINT "*"
LOCATE 7, 9: PRINT "M - Map", : IF Map = 1 THEN PRINT "*"
LOCATE 8, 9: PRINT "C - Circuit", : IF Cct = 1 THEN PRINT "*"
LOCATE 9, 9: PRINT "O - OFF", : IF FOV = 0 THEN PRINT "*"
LOCATE 10, 9: PRINT "N - NavAids", : IF NAids = 1 THEN PRINT "*"
'
LOCATE 6, 45: PRINT "L - LIST of Keyboard Controls"
LOCATE 12, 5: PRINT "I - Aircraft IDENTIFICATION [ "; Ident$; " ]"
LOCATE 14, 5: PRINT "R - RUNWAY Heading ["; Rwy; "]"
LOCATE 14, 45: PRINT "E - ELEVATION ["; Elev; "]"
LOCATE 16, 5: PRINT "P - POSITION (Relative Bearing, DME, Heading) ["; INT(Brg);
Temp = INT(Hdg + .5): IF Cct = 1 THEN Temp = Temp + Rwy: IF Temp > 360 THEN Temp = Temp - 360
PRINT INT(DME) / 10; Temp; "]"; ""
LOCATE 18, 45: PRINT "T - TURBULENCE Level ["; Turb; "]"
LOCATE 18, 5: PRINT "A - ALTITUDE  ["; INT(Elev + Z); "]"
LOCATE 20, 5: PRINT "F - Practice FINAL Approach"
LOCATE 20, 45: PRINT "J - JOYSTICK Calibration"
'
Kbd$ = ""
9010 Kbd$ = INKEY$             ''' New input
IF Kbd$ = "" THEN GOTO 9010
IF Kbd$ = "w" OR Kbd$ = "W" THEN FOV = 1:  GOTO 9020
IF (Kbd$ = "m" OR Kbd$ = "M") THEN FOV = 2: IF Map = 0 THEN GOSUB Conversion: Map = 1: Cct = 0: GOTO 9020
IF (Kbd$ = "c" OR Kbd$ = "C") THEN FOV = 2: IF Cct = 0 THEN GOSUB Conversion: Cct = 1: Map = 0: GOTO 9020
IF Kbd$ = "o" OR Kbd$ = "O" THEN FOV = 0:  GOTO 9020
IF Kbd$ = "l" OR Kbd$ = "L" THEN GOSUB KeyLst: GOTO 9020
IF Kbd$ = "e" OR Kbd$ = "E" THEN LOCATE 23, 5: INPUT "New ELEVATION"; Elev:
Elev = ABS(Elev): GOTO 9020
IF Kbd$ = "t" OR Kbd$ = "T" THEN LOCATE 23, 5: INPUT "Turbulence Level"; Turb
IF Kbd$ = "p" OR Kbd$ = "P" THEN LOCATE 23, 5: INPUT "Relative Bearing,Distance & Heading"; Temp, DME, Hdg: X = DME * 6080 * SIN(Temp * Pi / 180):
Y = DME * 6080 * COS(Temp * Pi / 180): IF Cct = 1 THEN Hdg = Hdg - Rwy
IF Kbd$ = "r" OR Kbd$ = "R" THEN LOCATE 23, 5: INPUT "Runway Heading"; Rwy:
IF Rwy < 5 OR Rwy > 354 THEN Rwy = 360: GOTO 9020
IF Kbd$ = "i" OR Kbd$ = "I" THEN LOCATE 23, 5: INPUT "Aircraft Identification "; Ident$: GOTO 9020
IF (Kbd$ = "n" OR Kbd$ = "N") AND NAids = 0 THEN NAids = 1: GOTO 9020
IF (Kbd$ = "n" OR Kbd$ = "N") AND NAids = 1 THEN NAids = 0: GOTO 9020
IF Kbd$ = "j" OR Kbd$ = "J" THEN GOSUB StikCal
IF Kbd$ <> "f" AND Kbd$ <> "F" THEN 9012
Z = 550: Hdg = Rwy + 10
IF Cct = 1 THEN Hdg = 10: X = -350: Y = -12200
IF Cct = 0 THEN Temp = Rwy: X = 2 * 6080 * SIN((Temp + 182) * Pi / 180): Y = 2 * 6080 * COS((Temp + 182) * Pi / 180): IF Cct = 1 THEN Hdg = Hdg - Rwy
V = Vmin: RPM = 1500: PitRf = -2.6: Flap = 10: Ped = 0
9012 IF Kbd$ = "a" OR Kbd$ = "A" THEN LOCATE 23, 5: INPUT "New ALTITUDE"; Temp: Z = (1000 * Temp) - Elev: IF Z <= 0 THEN Z = 0: V = 0: RPM = 0: GOTO 9020
IF Kbd$ <> "a" AND Kbd$ <> "A" THEN GOTO 9020
9015 IF V < Vs THEN V = 100: RPM = 2300: PitRf = .6: Ped = 3: TrimPos = 0
9020 Kbd$ = "": COLOR 15, 7: CLS 0: RETURN
'
'
9999 'QUITTING
CLS 0:  COLOR 15, 7: LOCATE 13, 36: PRINT "QUITTING"
OPEN "GLEBCBT.DAT" FOR OUTPUT AS #1
PRINT #1, 0, mLong, bLong, mLat, bLat, Rwy, Elev, Ident$
RESET: END


