'PROGRAM = The Locked Door Conundrum

DEFINT A-Z

DECLARE SUB Delay (factor%)                     'Time delay
DECLARE SUB DoorLock (doornum%)                 'Set lock flags
DECLARE SUB DoorStat (locknum%)                 'Display status of doors
DECLARE SUB DrawListBox ()                      'Display lock combinations
DECLARE SUB Logo (mode%)                        'Program Title
DECLARE SUB Instructions ()                     'Puzzle intructions
DECLARE SUB Menu (menusel%)                     'Menu selection routine
DECLARE SUB PastMoves (cursorpos%)              'Display previous selections
DECLARE SUB SelectCode (poscursor%, doneflag%)  'Do selected lock combination
DECLARE SUB Success ()                          'The final screen

'Global variables
DIM SHARED gWord$(0 TO 9)                        'Letters on doors
DIM SHARED gLockStat(0 TO 9)                     'lock status
DIM SHARED gLockCode$(0 TO 9)                    'lock combinations
DIM SHARED gPast$(0 TO 10)                       'Past moves
DIM SHARED gPastStat(0 TO 10, 0 TO 9)            'Past status of doors
DIM SHARED gCount                                'number of ticks

CONST LOCKED = 1
CONST UNLOCKED = -1

CONST TRUE = 1
CONST FALSE = 0
CONST QUIT = 2

CONST CR = 13                                  'Return key
CONST ESC = 27                                 'Escape key

'Colours
CONST BLUE = 1
CONST GREEN = 2
CONST CYAN = 3
CONST RED = 4
CONST WHITE = 7
CONST HIBLACK = 8
CONST HIYELLOW = 14
CONST HIWHITE = 15

'-----------------------------------------------------------------------------
WIDTH 80, 25
COLOR HIBLACK, CYAN
CLS
Logo 0
'door letters
text$ = "SUPERGIANT"
FOR index = 0 TO 9
   gWord$(index) = MID$(text$, index + 1, 1)
NEXT index

'combinations
FOR index = 0 TO 9
   READ gLockCode$(index)
NEXT index
DATA "Great","Genius","Gets","Gripes","Eating"
DATA "Gaunt","Unripe","Priest","At","Repast"

t& = TIMER
gCount = 0
DO
  gCount = gCount + 1
LOOP UNTIL TIMER > t& + 3

DO
   finish = FALSE
   Menu menusel
   SELECT CASE menusel
     CASE 0                        'Instructions
         Instructions
      CASE 1                        'Puzzle
         COLOR HIWHITE, BLUE
         CLS
         'load and display door status
         FOR index = 0 TO 9
            gLockStat(index) = LOCKED
            FOR index2 = 0 TO 9
               gPastStat(index + 1, index2) = 0
            NEXT index2
            gPast$(index + 1) = ""
            DoorStat index
         NEXT index
        
         'start puzzle
         DrawListBox
      CASE 2                        'Solution
         CLS
         Logo 1
         SLEEP 5
      CASE 3                        'Exit
         finish = TRUE
   END SELECT

LOOP UNTIL finish = TRUE


CLS
Logo 0
COLOR WHITE, BLUE
SYSTEM

'-----------------------------------------------------------------------------

SUB Delay (factor)

IF factor <= 0 THEN factor = 1
dtime = gCount / factor
tcount = 0
DO
   tcount = tcount + 1
LOOP WHILE tcount < dtime

END SUB

SUB DoorLock (doornum)
'doornum = selected lock combination

lock$ = UCASE$(gLockCode$(doornum))

'Update lock status
FOR index = 1 TO LEN(lock$)
  
   'match door
   FOR index1 = 0 TO 9
      IF MID$(lock$, index, 1) = gWord$(index1) THEN
         locknum = index1
         EXIT FOR
      END IF
   NEXT index1
  
   'lock/unlock door
   IF gLockStat(locknum) = LOCKED THEN
      gLockStat(locknum) = UNLOCKED
   ELSE
      gLockStat(locknum) = LOCKED
   END IF
  
   'display doors
   DoorStat locknum

NEXT index

END SUB

SUB DoorStat (locknum)
'Displays Status of doors

DIM outline$(0 TO 4), lock$(1 TO 3)
DIM ltext$(0 TO 1)

ltext$(0) = "Locked"
ltext$(1) = " Open "

outline$(0) = CHR$(218) + STRING$(4, 196) + CHR$(191)
outline$(1) = CHR$(179) + SPACE$(4) + CHR$(179)
outline$(2) = outline$(1)
outline$(3) = outline$(1)
outline$(4) = CHR$(192) + STRING$(4, 196) + CHR$(217)

lock$(1) = CHR$(218) + STRING$(2, 196) + CHR$(191)
lock$(2) = CHR$(179) + " " + gWord$(locknum) + CHR$(179)
lock$(3) = CHR$(192) + STRING$(2, 196) + CHR$(217)

COLOR HIWHITE, CYAN
'Start position of doors
ypos = 2: xpos = 2 + (locknum * 8)

'Outer box
FOR index = 0 TO 4
   LOCATE ypos + index, xpos
   PRINT outline$(index);
   COLOR HIBLACK, BLUE
   IF index = 0 THEN
      PRINT CHR$(220);
   ELSE
      PRINT CHR$(219);
   END IF
   COLOR HIWHITE, CYAN
NEXT
LOCATE ypos + 5, xpos + 1
COLOR HIBLACK, BLUE: PRINT STRING$(6, 223); : COLOR HIWHITE, CYAN

IF gLockStat(locknum) = LOCKED THEN
   fcolor = HIWHITE
   bcolor = RED
   text$ = ltext$(0)
ELSE
   fcolor = HIYELLOW
   bcolor = GREEN
   text$ = ltext$(1)
END IF
COLOR HIWHITE, BLUE
LOCATE ypos - 1, xpos: PRINT text$;

COLOR fcolor, bcolor
'Inner box
FOR index = 1 TO 3
   LOCATE ypos + index, xpos + 1
   PRINT lock$(index);
NEXT index

END SUB

SUB DrawListBox
'Display lock combination's and call selection routine

STATIC cursorpos
attempts = 0
DO
   COLOR HIBLACK, CYAN
   'Display list box
   ypos = 12: xpos = 25
   LOCATE ypos, xpos
   PRINT CHR$(218); CHR$(196); CHR$(194); STRING$(6, 196); CHR$(191);
  
   FOR index = 0 TO 9
      LOCATE ypos + 1 + index, xpos
      IF cursorpos = index THEN fcolor = HIYELLOW ELSE fcolor = HIBLACK
      PRINT CHR$(179);
      COLOR fcolor
      PRINT CHR$(48 + index);
      COLOR HIBLACK
      PRINT CHR$(179);
      COLOR fcolor
      text$ = gLockCode$(index): l = LEN(text$)
      IF l < 6 THEN text$ = text$ + SPACE$(6 - l)
      PRINT text$;
      COLOR HIBLACK
      PRINT CHR$(179); CHR$(219);
   NEXT index
  
   LOCATE ypos + 11, xpos
   PRINT CHR$(192); CHR$(196); CHR$(193); STRING$(6, 196); CHR$(217); CHR$(219);
   COLOR , BLUE
   LOCATE ypos + 12, xpos + 1: PRINT STRING$(10, 223);
  
   poscursor = cursorpos
   SelectCode poscursor, doneflag
   cursorpos = poscursor
  
   IF doneflag = TRUE THEN
      attempts = attempts + 1
      COLOR HIWHITE, BLUE
      LOCATE 10, 53: PRINT "Attempts "; attempts;
     
     'Update Display
      DoorLock poscursor
      PastMoves poscursor
   END IF

   'Test ALL doors
   lockflag = FALSE
   FOR index = 0 TO 9
      IF gLockStat(index) = LOCKED THEN lockflag = TRUE: EXIT FOR
   NEXT
   IF lockflag = FALSE THEN               'all doors are open
      Success
      LOCATE 20, 32: PRINT " Attempts = "; attempts;
      IF attempts > 5 THEN
         LOCATE 23, 27: PRINT " It can be done in less ! ";
      END IF
      SLEEP 10
      doneflag = QUIT
   END IF

LOOP UNTIL doneflag = QUIT

END SUB

SUB Instructions

DIM t$(0 TO 10)
t$(0) = "The Locked Doors Conundrum"
t$(1) = "The object of the puzzle is to unlock all the doors."
t$(2) = "This is acheived by selecting a code combination."
t$(3) = "The combinations are in the form of words."
t$(4) = "The words contain the letters of the doors that will be worked on."
t$(5) = "If the selected door is locked it will be unlocked and vice versa."
t$(6) = "To select a combination use the cursor keys or the numbered keys."
t$(7) = "Then action by pressing the ENTER key."
t$(8) = "You can end or restart the puzzle by pressing the ESCAPE key."
t$(10) = "Press any key to continue."

COLOR HIWHITE, BLUE
CLS
FOR index = 0 TO 10
   IF (index = 0 OR index = 10) THEN COLOR HIYELLOW ELSE COLOR HIWHITE
   l = LEN(t$(index)) / 2
   LOCATE 5 + index, 40 - l
   PRINT t$(index);
NEXT index

DO
LOOP WHILE INKEY$ = ""

END SUB

SUB Logo (mode)

COLOR HIYELLOW, BLUE
IF mode = 0 THEN
   ltext$ = " The Locked Door Conundrum "
ELSE
   ltext$ = " Email me !"
END IF
l = LEN(ltext$)
x = 40 - ((l + 2) / 2): y = 10
LOCATE y, x: PRINT CHR$(218) + STRING$(l, 196) + CHR$(191);
LOCATE y + 1, x: PRINT CHR$(179) + ltext$ + CHR$(179);
COLOR HIBLACK: PRINT CHR$(219); : COLOR HIYELLOW
LOCATE y + 2, x: PRINT CHR$(192) + STRING$(l, 196) + CHR$(217);
COLOR HIBLACK: PRINT CHR$(219);
LOCATE y + 3, x + 1: PRINT STRING$(l + 2, 219);

END SUB

SUB Menu (menusel)

COLOR HIBLACK, CYAN
CLS
lenmenu = 3: lmenufg = HIWHITE: lmenubg = BLUE: lmenuselfg = HIYELLOW
DIM lmenu$(0 TO lenmenu)
lmenu$(0) = "Instructions"
lmenu$(1) = "Puzzle"
lmenu$(2) = "Solution"
lmenu$(3) = "Exit"

'centerlise menu box
lmenu = 0: rowm = 7
FOR index = 0 TO lenmenu
        IF LEN(lmenu$(index)) > lmenu THEN lmenu = LEN(lmenu$(index))
NEXT index
menucol = 40 - (lmenu / 2)

'Display menu
COLOR lmenufg, lmenubg
LOCATE rowm, menucol: PRINT CHR$(218) + STRING$(lmenu, 196) + CHR$(191);
DO
   FOR index = 0 TO lenmenu
      COLOR lmenufg, lmenubg
      LOCATE rowm + index + 1, menucol: PRINT CHR$(179);
      IF menusel = index THEN COLOR lmenuselfg, lmenubg  'selected item
      PRINT lmenu$(index); TAB(menucol + 1 + lmenu);
      COLOR lmenufg, lmenubg: PRINT CHR$(179);
      COLOR black, BLUE: PRINT CHR$(219)
   NEXT index
   COLOR lmenufg, lmenubg
   LOCATE rowm + lenmenu + 2, menucol
   PRINT CHR$(192) + STRING$(lmenu, 196) + CHR$(217);
   COLOR black, BLUE: PRINT CHR$(219)
   LOCATE rowm + lenmenu + 3, menucol + 1: PRINT STRING$(lmenu + 2, 219)
   COLOR HIBLACK, CYAN
  
   validkey = FALSE
   DO
      kyb$ = UCASE$(INKEY$)
   LOOP WHILE kyb$ = ""
  
   'test for intial letters of menu items
   FOR index = 0 TO lenmenu
      IF kyb$ = MID$(lmenu$(index), 1, 1) THEN menusel = index
   NEXT index
  
   SELECT CASE kyb$
      CASE CHR$(0) + "H"                      'Up arrow
         menusel = menusel - 1
         IF menusel < 0 THEN menusel = lenmenu
      CASE CHR$(0) + "P"                      'Down arrow
         menusel = menusel + 1
         IF menusel > lenmenu THEN menusel = 0
      CASE CHR$(CR)                           'Return  do selected item
         validkey = TRUE
      CASE CHR$(ESC)                          'Escape
         menusel = 3
         validkey = TRUE
   END SELECT

LOOP UNTIL validkey = TRUE

END SUB

SUB PastMoves (cursorpos)
'Displays a list box showing previous selections an status of doors

'Find first free location in display box
loadedflag = FALSE
FOR index = 1 TO 10
   IF gPast$(index) = "" THEN
      gPast$(index) = gLockCode$(cursorpos)
      FOR index2 = 0 TO 9
         gPastStat(index, index2) = gLockStat(index2)
      NEXT index2
      loadedflag = TRUE             'found it !
      EXIT FOR
   END IF
NEXT index

IF loadedflag = FALSE THEN
   'index last 10 moves for the next one
   FOR index = 0 TO 9
      gPast$(index) = gPast$(index + 1)
      FOR index2 = 0 TO 9
         gPastStat(index, index2) = gPastStat(index + 1, index2)
      NEXT index2
   NEXT index
   gPast$(10) = gLockCode$(cursorpos)
   FOR index2 = 0 TO 9
      gPastStat(10, index2) = gLockStat(index2)
   NEXT index2
END IF
        
'Display list box
COLOR HIBLACK, CYAN
ypos = 12: xpos = 50
LOCATE ypos, xpos
PRINT CHR$(218); STRING$(6, 196); CHR$(194); "SUPERGIANT"; CHR$(191);
 
FOR index = 0 TO 9
   LOCATE ypos + 1 + index, xpos
   PRINT CHR$(179);
   text$ = gPast$(index + 1): l = LEN(text$)
   IF l < 6 THEN text$ = text$ + SPACE$(6 - l)
   PRINT text$;
   COLOR HIBLACK
   PRINT CHR$(179);
   'door status
   FOR index2 = 0 TO 9
      SELECT CASE gPastStat(index + 1, index2)
         CASE 0
            fcolor = CYAN
         CASE LOCKED
            fcolor = RED
         CASE UNLOCKED
            fcolor = GREEN
      END SELECT
      COLOR fcolor, HIBLACK
      IF text$ = SPACE$(6) THEN PRINT CHR$(219);  ELSE PRINT CHR$(178);
   NEXT index2
   COLOR HIBLACK, CYAN: PRINT CHR$(179); CHR$(219)
NEXT index
LOCATE ypos + 11, xpos
PRINT CHR$(192); STRING$(6, 196); CHR$(193); STRING$(10, 196); CHR$(217); CHR$(219);
COLOR , BLUE
LOCATE ypos + 12, xpos + 1: PRINT STRING$(19, 223);

END SUB

SUB SelectCode (poscursor, doneflag)
'Select combinations from list box

DO
   validkey = FALSE
   doneflag = FALSE
   keyval = 0
  
   DO
      kyb$ = UCASE$(INKEY$)
   LOOP WHILE kyb$ = ""
  
   'test for 0-9 keys
   keyval = ASC(kyb$) - 48
   IF (keyval >= 0 AND keyval <= 9) THEN
      poscursor = keyval
      validkey = TRUE
   END IF
  
   'cursor keys etc
   SELECT CASE kyb$
      CASE CHR$(0) + "H"                      'Up arrow
         poscursor = poscursor - 1
         IF poscursor < 0 THEN poscursor = 9
         validkey = TRUE
      CASE CHR$(0) + "P"                      'Down arrow
         poscursor = poscursor + 1
         IF poscursor > 9 THEN poscursor = 0
         validkey = TRUE
      CASE CHR$(CR)                           'Return key
         doneflag = TRUE
         validkey = TRUE
      CASE CHR$(ESC)                          'Escape key
         doneflag = QUIT
         validkey = TRUE
   END SELECT

LOOP UNTIL validkey = TRUE

END SUB

SUB Success
'Display's final screen if successful

COLOR HIWHITE, CYAN

fc = 177
fc$ = STRING$(2, fc)
ymax = 25

FOR ypos = 5 TO ymax
   FOR locknum = 0 TO 9
      xpos = 4 + (locknum * 8)
      LOCATE ypos, xpos
      PRINT fc$;
   NEXT locknum
   Delay 2
NEXT ypos

fc$ = CHR$(fc)
FOR ypos = ymax TO 1 STEP -1
   FOR offset = 0 TO 3
      FOR locknum = 0 TO 9
         xpos = 4 + (locknum * 8)
         LOCATE ypos, xpos - offset
         PRINT fc$;
         LOCATE ypos, xpos + offset
         PRINT fc$; fc$;
      NEXT locknum
      Delay 4
   NEXT offset
NEXT ypos

LOCATE 12, 33: PRINT " Well Done ! "

END SUB

