unit kbuff;

{ Unit zur direkten Manipulation des Tastaturpuffers }

interface

procedure kbuffwrite(str: string); { Schreibt string direkt in Tastaturpuffer }
procedure kbuffclear;    { Lschen des Tastaturpuffers zur Vorbeugung gegen
                           ungewollte Tastatureingaben }

implementation

var first : word absolute $40:$1a;
    last  : word absolute $40:$1c;
    kbuffer : array[30..61] of char absolute $40:$1e;

  procedure kbuffwrite(str:string);
  var next, len, i : word;
  begin
    next:=last;
    len:=word(str[0]);
    if len > 15 then len := 15;
    for i:=1 to len do
    begin
      if next<>60 then
       inc(next,2)
      else
       next:=30;
      if next = first then exit;
      kbuffer[last] := str[i];
      last:=next;
    end;
  end;

  Procedure kbuffclear;
  begin
  first:=last;
  end;
end.
