UNIT Mouse256;

INTERFACE

USES DOS;

CONST
   { Auswahl der Mausknpfe }
   leftbutton   = 1;
   rightbutton  = 2;
   middlebutton = 4;

TYPE regs = registers;

PROCEDURE ResetMouse(VAR state:regs);
          { Initialisierung und Prfung, ob und welche Maus vorhanden ist. }
PROCEDURE SetCursorDisplay(on:BOOLEAN);
          { Schaltet Cursor ein oder aus }
PROCEDURE ReadMouse(VAR x,y:INTEGER; VAR leftbutton,rightbutton,middlebutton:BOOLEAN);
          { Liefert die Mausposition, sowie den Zustand der Knpfe }
PROCEDURE SetCursorLocation(x,y:INTEGER);
          { Setzt den Mauszeiger an eine bestimmte Position }
PROCEDURE DefineHorizontalRange(x1,x2:INTEGER);
          { Erlaubten, horizontalen Bereich eingeben, damit kann die Maus in
            einem Teil des Bildschirms "gefangen" werden }
PROCEDURE DefineVerticalRange(y1,y2:INTEGER);
          { Erlaubten, vertikalen Bereich eingeben. }


IMPLEMENTATION

  CONST
     MouseInterrupt = $33;

  VAR
     reg:regs;



  PROCEDURE ResetMouse(VAR state:regs);
  BEGIN
    state.ax:=0;
    INTR(MouseInterrupt,state);
  END;



  PROCEDURE SetCursorDisplay(on:BOOLEAN);
  BEGIN
    IF on
      THEN reg.ax:=1
      ELSE reg.ax:=2;
    Intr(MouseInterrupt,reg);
  END;

  PROCEDURE ReadMouse(VAR x,y:INTEGER; VAR leftbutton,rightbutton,middlebutton:BOOLEAN);
  BEGIN
    reg.ax:=3;
    Intr(MouseInterrupt,reg);
    WITH reg DO BEGIN
      leftbutton:=(bx AND 1)=1;
      rightbutton:=(bx AND 2)=2;
      middlebutton:=(bx AND 4)=4;
      x:= cx div 2;
      y:= dx;
    END;
  END;


  PROCEDURE SetCursorLocation(x,y:INTEGER);
  BEGIN
    reg.ax:=4;
    reg.cx:=x;
    reg.dx:=y;
    INTR(MouseInterrupt,reg);
  END;


  PROCEDURE DefineHorizontalRange(x1,x2:INTEGER);
  BEGIN
    reg.ax:=7;
    reg.cx:=x1;
    reg.dx:=x2;
    Intr(MouseInterrupt,reg);
  END;


  PROCEDURE DefineVerticalRange(y1,y2:INTEGER);
  BEGIN
    reg.ax:=8;
    reg.cx:=y1;
    reg.dx:=y2;
    Intr(MouseInterrupt,reg);
  END;

END.
