unit PCX_256;

       { UNIT ZUM LADEN UND BEARBEITEN VON PCX-GRAFIKEN IM

       320x200 FORMAT MIT 256 FARBEN.

       1994 by Mad Man Software }



INTERFACE
uses dos,crt;

type
        col_16 = array[1..48] of byte;
          fill = array[1..58] of byte;
        dactyp = array[0..255,0..2] of byte;
   egapalstyle = array[0..16] of byte;

    pcx_Kopf = record
                  identifikation : byte;
                         version : byte;
                   komprimierung : byte;
                  bits_pro_pixel : byte;
                              x1 : word;
                              y1 : word;
                              x2 : word;
                              y2 : word;
                           dpl_x : word;
                           dpl_y : word;
                           Pal16 : col_16;
                        reserved : byte;
                           ebene : byte;
                 bytes_pro_zeile : word;
                    paletten_art : word;
                         fueller : fill;
             end;
var
            header : ^pcx_kopf;
             datei :  file;
              cpu  : registers;
              dacs : dactyp;
                bk : byte;  { BACKGROUND-COLOR }

PROCEDURE SET_EGA_PAL(pal : egapalstyle);
PROCEDURE SETZEMODUS(modus:integer);
PROCEDURE DATEI_EINLESEN(dateiname : string);
PROCEDURE SETZE_DACREGISTER(var dacs:dactyp; ANFANG,ANZAHL : byte );
PROCEDURE WARTEAUFKATHODENSTRAHL;
PROCEDURE FARBROLLEN(var dacs : dactyp;ANFANG,ENDE : byte);
PROCEDURE SAVE_EGA_PAL(var pal : egapalstyle);
PROCEDURE SETZEALLEDACREGISTER(var dacs:dactyp);
PROCEDURE KILL_HEADER;
PROCEDURE PUT_PIC(x,y,x1,y1,x2,y2 : integer;var pic : pointer);
PROCEDURE GET_PIC(x1,y1,x2,y2:integer;var pic: pointer);
PROCEDURE BLENDEFARBENAUS(dacs:dactyp);
PROCEDURE BLENDEFARBENEIN(dacs:dactyp);
PROCEDURE LESEALLEDACREGISTER(var dacs:dactyp);
PROCEDURE LEEREDACREGISTER(var dacs : dactyp);
FUNCTION GET_PIC_SIZE(x1,y1,x2,y2 : integer) : word;


IMPLEMENTATION

PROCEDURE SETZEMODUS(modus:integer);
begin
cpu.ah:=0;
cpu.al:=modus;
intr($10,cpu);
end;

PROCEDURE DATEI_EINLESEN(dateiname : string);
var        bwert : byte;
   iwiederholung : word;
          offset : word;
             i,j : word;
            fill : byte;
           VPage : pointer;
     Dateilaenge : word;
     Datenlaenge : word;

begin
  assign(datei,dateiname);
  reset(datei,1);
  Dateilaenge:=filesize(datei);
  Datenlaenge:=Dateilaenge - (128+769);
  new(header);
  getmem(VPage,Datenlaenge);
  blockread(datei,header^,128);  {HEADER AUSLESEN}
  blockread(datei,VPage^,Datenlaenge);
  i:=0;
  offset:=0;

  repeat
    bwert:=mem[Seg(VPage^):Ofs(VPage^)+i];
    inc(i);
    if bwert and $C0=$C0 then
    begin
      iwiederholung:=bwert and $3F;
      bwert:=mem[Seg(VPage^):Ofs(VPage^)+i];
      inc(i);
      for j:=1 to iwiederholung do
      begin
        mem[$A000:offset]:=bwert;  
        inc(offset);
      end;
    end                                                        
    else                                                      
    begin                                                       
      mem[$A000:offset]:=bwert;                                
      inc(offset);                                              
    end;
  until i=datenlaenge;
  

  blockread(datei,fill,1);        { BYTE ZWISCHEN DATEN UND PALETTE }

  for i:=0 to 255 do
  begin
    blockread(datei,dacs[i,0],1);  {roter farbanteil}          { P }
    blockread(datei,dacs[i,1],1);  {grner farbanteil}         { A }
    blockread(datei,dacs[i,2],1);  {blauer farbanteil}         { L }
    dacs[i,0]:=dacs[i,0] div 4;                                { E }
    dacs[i,1]:=dacs[i,1] div 4;                                { T }
    dacs[i,2]:=dacs[i,2] div 4;                                { T }
  end;                                                         { E }
  close(datei);
  freemem(VPage,Datenlaenge);
end;

PROCEDURE KILL_HEADER;
begin
  dispose(header);
end;

procedure blendefarbenaus(dacs:dactyp);
var
ende : boolean;
register,farbe : byte;
begin
repeat
ende:=true;
for register:=0 to 255 do
for farbe:=0 to 2 do
if dacs[register,farbe]>0
then
begin
ende:=false;
dec(dacs[register,farbe]);
end;
warteaufkathodenstrahl;
setzealledacregister(dacs);
until (ende=true);
end;

procedure lesealledacregister(var dacs:dactyp);
begin
cpu.ax:=$1017;
cpu.bx:=0;
cpu.cx:=255;
cpu.es:=seg(dacs[0]);
cpu.dx:=ofs(dacs[0]);
intr($10,cpu);
end;


procedure blendefarbenein(dacs:dactyp);
var
ende : boolean;
register,farbe : byte;  
aktuelledacs:dactyp;
begin
lesealledacregister(aktuelledacs);
repeat
ende:=true;
for register:=0 to 255 do
for farbe:=0 to 2 do
if aktuelledacs[register,farbe]<dacs[register,farbe]
then
begin
ende:=false;
inc(aktuelledacs[register,farbe]);
end;
warteaufkathodenstrahl;
setzealledacregister(aktuelledacs);
until (ende=true);
end;

PROCEDURE SETZE_DACREGISTER(var dacs:dactyp; ANFANG,ANZAHL : byte );
begin
  cpu.ax:=$1012;
  cpu.bx:=ANFANG;
  cpu.cx:=ANZAHL;
  cpu.es:=seg(dacs[anfang,0]);
  cpu.dx:=ofs(dacs[anfang,0]);
  intr($10,cpu);
end;

PROCEDURE SETZEALLEDACREGISTER(var dacs:dactyp);
begin
cpu.ax:=$1012;
cpu.bx:=0;
cpu.cx:=255;
cpu.es:=seg(dacs[0]);
cpu.dx:=ofs(dacs[0]);
intr($10,cpu);
end;

PROCEDURE WARTEAUFKATHODENSTRAHL;
const
vgastatus:word=$3da;
begin
repeat
until (port[vgastatus] and 8)<>8;
repeat
until (port[vgastatus] and 8)=8;
end;

Procedure FARBROLLEN(var dacs : dactyp;ANFANG,ENDE : byte);
var hilfr,hilfg,hilfb,zaehler : byte;
               
begin
  hilfr:=dacs[ende,0];
  hilfg:=dacs[ende,1];
  hilfb:=dacs[ende,2];
  for zaehler:=ende downto anfang+1 do
  begin
    dacs[zaehler,0]:=dacs[zaehler-1,0];
    dacs[zaehler,1]:=dacs[zaehler-1,1];
    dacs[zaehler,2]:=dacs[zaehler-1,2];
  end;
  dacs[anfang,0]:=hilfr;
  dacs[anfang,1]:=hilfg;
  dacs[anfang,2]:=hilfb;
  warteaufkathodenstrahl;
  setze_dacregister(dacs,anfang,ende-anfang);
end;

PROCEDURE SAVE_EGA_PAL(var pal : egapalstyle);
begin
cpu.al:=$9;
cpu.ah:=$10;
cpu.es:=seg(pal[0]);
cpu.dx:=ofs(pal[0]);
intr($10,cpu);
end;

PROCEDURE SET_EGA_PAL(pal : egapalstyle);
begin
cpu.al:=$2;
cpu.ah:=$10;
cpu.es:=seg(pal[0]);
cpu.dx:=ofs(pal[0]);
intr($10,cpu);
end;

Procedure LeereDACRegister(var dacs : dactyp);
var j,i : byte;
begin
 for i:=0 to 255 do
   begin
     for j:=0 to 2 do dacs[i,j]:=0;
   end;
end;


PROCEDURE PUT_PIC(x,y,x1,y1,x2,y2 : integer;var pic : pointer);
var        i,j,k : integer;
          offset : longint;
begin
  j:=0;
  offset:=0;
  for i:=y1 to y2 do
  begin
    {  inc(j); }
    for k:=x1 to x2 do
    begin
      if mem[seg(pic^):ofs(pic^)+offset]<>bk then 
      move(mem[seg(pic^):ofs(pic^)+offset],mem[$A000:(j+y)*320+x+k-x1],1);
      inc(offset);                                       
    end;
    inc(j);
  end;
end;

Procedure GET_PIC(x1,y1,x2,y2:integer;var pic: pointer);
var       i : integer;
     offset : longint;
begin
  offset:=0;
  for i:=y1 to y2 do
  begin
    move(mem[$A000:i*320+x1],mem[seg(pic^):ofs(pic^)+offset],x2+1-x1);
    offset:=offset+x2+1-x1;                                    {***}
  end;
end;

Function GET_PIC_SIZE(x1,y1,x2,y2 : integer) : word;

begin
  GET_PIC_SIZE:=(y2+1-y1)*(x2+1-x1);
end;

end.
