UNIT TpSB1_4;
{$X+}

{ TurboSB ver. 1.4 (c) 1995/96 by Mad Man Software }

{ TurboSB ist eine Unit zum Abspielen von Raw-Samples auf Soundblaster oder
  Soundblaster-kompatiblen SoundKarten. Da ich nicht diese Unit nur mit
  wenigen verschiedenen Karteneinstellungen ausprobieren konnte, wei ich
  nicht ob sie mit exotischen Karten(konfigurationen) luft. Vor allem
  die Function SBAutoDetect lief nur auf meiner orginal Soundblaster 2.0.
  Falls Bugs auftreten oder jemand einen Tip fr mich hat ...

                            Martin Braun
                            Zelterstrae 9
                            89601 Schelklingen
                            Deutschland
 Anwendung der Unit:
 1.  Ermitteln der SB-Konfiguration mit SBAbfrage

 2a. Abspielen von groen Samples mit HardDiskPlay (liet direkt von Festplatte )
 2b. Laden der Sampledaten mit Loadsample
     Abspielen mit Playsample
     Sample aus dem Speicher entfernen mit Freesample

}





INTERFACE
Uses Crt,Dos;

type
     smallsample = record
                    adresse : pointer; { Zeiger auf Anfangsadresse des Samples }
                     offset : word;    { abgespalteter Offset-Teil der Adresse }
                       page : byte;    { abgespalteter Page-Teil der Adresse }
                     laenge : word;    { Laenge des Samples in bytes }
                   frequenz : word;    { Abspielfrequenz fr Sample }
                   end;

var
              BasisAdresse  :   word;
                  IRQKanal  :   byte;
                  DMAKanal  :   byte;


Function SBAbfrage : boolean;
Procedure HarddiskPlay(Dateiname : string;frequenz : word;dma_buffer_laenge : word);
Procedure PlaySample(var Sample : smallsample);
Procedure FreeSample(var Sample : smallsample);
Procedure LoadSample(Dateiname : string; Frequenz : word; var Sample : smallsample);
Function HexStr(d : word): string;

IMPLEMENTATION

const
     HEX_CHAR : array[0..15] of char
     = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

     { Interrupt-Vektoren der IRQ's }

     IRQ  : array[0..15] of byte = ($08,$09,$0A,$0B,$0C,$0D,$0E,$0F,
                                    $70,$71,$72,$73,$74,$75,$76,$77);

     EOI        : byte = $20;  { End of Interrupt }
     MASTER_PIC : byte = $20;  { irq 0-7  }
     SLAVE_PIC  : byte = $A0;  { irq 8-15 }
     IRQ_MASK   : byte = $01;  { Offset zum IRQ-Mask Register }

     DMA_STATUS   : byte = $08;
     DMA_MASK     : byte = $0A;
     DMA_MODUS    : byte = $0B;
     DMA_FLIPFLOP : byte = $0C;
     DMA_RESET    : byte = $0D;
     DMA_ADRESS   : array[0..3] of Integer = (0 , 2, 4, 6);
     DMA_PAGE     : array[0..3] of Integer = ($87,$83,$81,$82);
     DMA_COUNTER  : array[0..3] of Integer = (1 , 3, 5, 7);

var
         DSP_Reset,
         DSP_Read_Data,
         DSP_Write_Data,
         DSP_Write_Status,
         DSP_Read_Status    :   word;

                        ok  : boolean; { Wird von INT-Procedure auf true ge-
                                         setzt wenn diese erfolgreich aus-
                                         gefhrt wurde }

{ Zeiger auf Blcke in Procedure HardDiskPlay}
PlayingBuffer,ReadingBuffer : pointer;
                  Buf1,Buf2 : pointer;



{                       PROCEDURES + FUNCTIONS                   }

procedure SetDSPVars(Basis : word);
begin
    DSP_Reset        := Basis + $06;
    DSP_Read_Data    := Basis + $0A;
    DSP_Write_Data   := Basis + $0C;
    DSP_Write_Status := Basis + $0C;
    DSP_Read_Status  := Basis + $0E;
end;

function ResetDSP(var base : word) : boolean;
var      Basis_Gefunden : boolean;
                      b : byte;
begin
  Basis_Gefunden:=false;
  b:=1;

  while (Basis_Gefunden = false) and (b<=8) do
  begin
    base := $200+(b * $10);

    { Ports fr die aktuelle Basisadresse berechnen }

    SetDspVars(base);

    { DSP-Chip Reset }
    Port[DSP_Reset] := 1;
    Delay(10);
    Port[DSP_Reset] := 0;
    Delay(10);
    if (Port[DSP_Read_Status] And $80 = $80) And
       (Port[DSP_Read_Data] = $AA) then
    Basis_Gefunden:=true;
    inc(b);
    end;
    if Basis_Gefunden=true then ResetDSP:=true
    else
    begin
      ResetDSP := false;
      base:=0;
    end;
end;

procedure ResetDspAgain;
{ DSP-Chip Reset }
    begin
    Port[DSP_Reset] := 1;
    Delay(10);
    Port[DSP_Reset] := 0;
    Delay(10);
end;

procedure WriteDSP(value : byte);
begin
  while Port[DSP_Write_Status] and $80 <> 0 do;
  Port[DSP_Write_Data] := value;
end;

function ReadDSP : byte;
begin
  while Port[DSP_Read_Status] and $80 = 0 do;
   ReadDSP := Port[DSP_Read_Data];
end;

function SpeakerOn: byte;
begin
  WriteDSP($D1);
end;

function SpeakerOff: byte;
begin
  WriteDSP($D3);
end;

procedure DMAReset;
begin
  port[$0D]:=0;
end;


Procedure HardDiskPlayHandler;Interrupt;    { Interrupt-Handler fr HardDiskPlay }
var    dummy  :  byte;
begin
     dummy:=port[DSP_Read_Status];     { Byte aus ReadStatus lesen -->
                                         signalisiert SB das INT entgegen-
                                         genommen wurde }

     { Der alte ReadingBuffer in dem die neuen abzuspielenden Daten sind
       wird jetzt zum PlayingBuffer ....                                 }

     if PlayingBuffer=Buf1 then PlayingBuffer:=Buf2
     else PlayingBuffer:=Buf1;

     { Der alte PlayingBuffer der zuende gespielt wurde wird jetzt zum
       neuen ReadingBuffer                                               }

     if ReadingBuffer=Buf1 then ReadingBuffer:=Buf2
     else ReadingBuffer:=Buf1;

     port[SLAVE_PIC]:=EOI;  { an Slave- und MasterPIC ein              }
     port[MASTER_PIC]:=EOI; { "End of Interrupt" schicken              }

     ok:=true; { <-- signalisiert HardDiskPlay das Interrupt
                 erfolgreich aus gewertet wurde }
end;

Procedure DetectionHandler;
var     dummy  :  byte;
          ISR  :  byte;
begin
     dummy:=port[DSP_Read_Status];

     IRQKanal:=0;
     port[SLAVE_PIC]:=$0B;
     dummy:=port[SLAVE_PIC];
     ISR:=dummy;
     if (dummy or dummy)<>0 then
     begin
        repeat
          inc(IRQKanal);
          ISR:=ISR shr 1;
        until ISR=0;
        dec(IRQKanal);
        IRQKanal:=IRQKanal+8;
     end;
     if (dummy or dummy)=0 then
     begin
       port[MASTER_PIC]:=$0B;
       dummy:=port[MASTER_PIC];
       ISR:=dummy;
       repeat
         inc(IRQKanal);
         ISR:=ISR shr 1;
       until ISR=0;
       dec(IRQKanal);
     end;
     OK:=true;

     port[SLAVE_PIC]:=EOI;
     port[MASTER_PIC]:=EOI;
end;

Procedure SetupDMA(channel : byte;buf_offset : word;buf_page : byte;
                   buf_laenge : word);
begin
  
   port[DMA_MASK] := channel+4;
   port[DMA_FLIPFLOP] := 0;
   port[DMA_MODUS] := channel+$48;
   port[DMA_ADRESS[channel]] := Lo(buf_offset);
   port[DMA_ADRESS[channel]] := Hi(buf_offset);
   port[DMA_PAGE[channel]] := buf_page;
   port[DMA_COUNTER[channel]] := lo(buf_laenge-1);      
   port[DMA_COUNTER[channel]] := hi(buf_laenge-1);      
   port[DMA_MASK] := channel;

end;

Procedure PlayBuf(laenge,frequenz : word);
var b : word;
begin
  b := 256 - 1000000 div frequenz;
  writedsp($40);
  writedsp(b);

  { 8-bit Playback }
  writedsp($14);
  writedsp(lo(laenge-1));
  writedsp(hi(laenge-1));
end;

Procedure DemaskiereInterrupt;
var MaskPort : Integer;
        mask : byte;

Begin
  if IRQKanal<=7 then MaskPort:=MASTER_PIC+IRQ_MASK
  else MaskPort:=SLAVE_PIC+IRQ_MASK;
  mask:=IRQKanal and $7;
  port[MaskPort]:=port[MaskPort] and not (1 shl mask);
End;


Function SbAutoDetect(base:word;SBHandler : pointer) : boolean;
var       OldInt2,
          OldInt3,
          OldInt5,
          OldInt7,
          OldInt10,
          OldInt11,
          OldInt12,
          OldInt15  :  pointer;
                 b  :  byte;
          dma_test  :  pointer;
       offset,page  :  word;
             dummy  :  word;


begin
    DMAKanal:=0;
     asm cli end;
     { alte IRQ-Handler sichern }
     GetIntVec(IRQ[2],OldInt2);
     GetIntVec(IRQ[3],OldInt3);
     GetIntVec(IRQ[5],OldInt5);
     GetIntVec(IRQ[7],OldInt7);
     GetIntVec(IRQ[10],OldInt10);
     GetIntVec(IRQ[11],OldInt11);
     GetIntVec(IRQ[12],OldInt12);
     GetIntVec(IRQ[15],OldInt15);

     { umlenken der IRQs auf neuen IRQHandler }

     SetIntVec(IRQ[2],SBHandler);
     SetIntVec(IRQ[3],SBHandler);
     SetIntVec(IRQ[5],SBHandler);
     SetIntVec(IRQ[7],SBHandler);
     SetIntVec(IRQ[10],SBHandler);
     SetIntVec(IRQ[11],SBHandler);
     SetIntVec(IRQ[12],SBHandler);
     SetIntVec(IRQ[15],SBHandler);
     asm sti end;

     { IRQ 2,3,5,7 demaskieren }

     b:=port[MASTER_PIC+IRQ_MASK];
     b:=(b and (not(4+8+32+128)));
     port[MASTER_PIC+IRQ_MASK]:=b;

     { IRQ 10,11,12,15 demaskieren }

     b:=port[SLAVE_PIC+IRQ_MASK];
     b:=(b and (not(4+8+16+128)));
     port[SLAVE_PIC+IRQ_MASK]:=b;

     { DMA-Chip initialisieren und kurz Daten bertragen }
     { wenn der DMA-Kanal stimmt wird SbInterruptHandler }
     { ausgefhrt                                        }

     dma_test:=addr(DMA_COUNTER[1]);
     { dma_test zeigt auf beliebigen DatenBlock fr DMA-Testbertragung }

     SpeakerOn;

     offset := Seg(dma_test^) Shl 4 + Ofs(dma_test^);
     page := (Seg(dma_test^) + Ofs(dma_test^) shr 4) shr 12;

     repeat
       ResetDSPAgain;
       DMAReset;
       dummy:=0;
       ok:=false;
       SetupDMA(DMAKanal,offset,page,200);
       PlayBuf(200,10000);

       repeat
        dummy:=dummy+1;
        dummy:=dummy-1;
        dummy:=dummy+1;
        until (ok=true) or (dummy=10000);
     DMAReset;
     if dummy>=10000 then DMAKanal:=DMAKanal+1;

     until (ok=true) or (DMAKanal=4);

     if DMAKanal = 4 then SBAutoDetect:=false
     else SBAutoDetect:=true;

     asm cli end;
     SetIntVec(IRQ[2],OldInt2);
     SetIntVec(IRQ[3],Oldint3);
     SetIntVec(IRQ[5],Oldint5);
     SetIntVec(IRQ[7],Oldint7);
     SetIntVec(IRQ[10],Oldint10);
     SetIntVec(IRQ[11],Oldint11);
     SetIntVec(IRQ[12],Oldint12);
     SetIntVec(IRQ[15],Oldint15);
     asm sti end;

      { IRQ 2,3,5,7 maskieren }

     b:=port[MASTER_PIC+IRQ_MASK];
     b:=(b or (4+8+32+128));
     port[MASTER_PIC+IRQ_MASK]:=b;

     { IRQ 10,11,12,15 maskieren }

     b:=port[SLAVE_PIC+IRQ_MASK];
     b:=(b or (4+8+16+128));
     port[SLAVE_PIC+IRQ_MASK]:=b;

end;

Function HexStr(d : word): string;
Var
	HexString : string[4];

begin
	HexString := '    ';

	HexString[4] := HEX_CHAR[d mod 16];
	HexString[3] := HEX_CHAR[(d div 16) mod 16];
	HexString[2] := HEX_CHAR[(d div 256) mod 16];
	HexString[1] := HEX_CHAR[(d div 4096) mod 16];

	while (HexString[1] = '0') and (length(HexString) > 1) do
	begin
		Delete(HexString,1,1);
	end;

	HexStr := HexString;
end;

Function SBEnvironmentVar : boolean;
var Blaster : string;
          i : integer;
      error : integer;
begin
   Blaster:=getenv('BLASTER');
   if Blaster<>'' then
   begin
     if (pos('A',Blaster)=0) or (pos('D',Blaster)=0) or (pos('I',Blaster)=0) then
     begin
       SBEnvironmentVar:=false;
       writeln('Fehler im Aufbau der BLASTER Environment Variable !');
       exit;
     end;
     Val(Copy(Blaster,pos('A',Blaster)+1,1),i,error);
     BasisAdresse:=i*256;
     Val(Copy(Blaster,pos('A',Blaster)+2,1),i,error);
     BasisAdresse:=BasisAdresse+(i*16);
     Val(Copy(Blaster,pos('A',Blaster)+3,1),i,error);
     BasisAdresse:=BasisAdresse+i;

     VAL(Copy(Blaster,pos('I',Blaster)+1,1),IRQKanal,error);
     VAL(Copy(Blaster,pos('D',Blaster)+1,1),DMAKanal,error);
     writeln('BLASTER Environment Variable OK ... ');
     SBEnvironmentVar:=true;

  end
  else
  begin
    writeln('BLASTER Environment Variable NICHT gefunden !');
    SBEnvironmentVar:=false;
  end;
end;

procedure LoadSample(Dateiname : string; Frequenz : word; var Sample : smallsample);
var        Sounddatei : file;
          DateiLaenge : word;
begin
  assign(SoundDatei,Dateiname);
  reset(SoundDatei,1);
  DateiLaenge:=filesize(SoundDatei);
  getmem(Sample.adresse,DateiLaenge);
  Blockread(Sounddatei,Sample.adresse^,Dateilaenge);
  close(SoundDatei);
  { offset + page fr abzuspielenden Block berechnen ... }
  Sample.offset := Seg(sample.adresse^) Shl 4 + Ofs(sample.adresse^);
  Sample.page := (Seg(sample.adresse^) + Ofs(sample.adresse^) shr 4) shr 12;
  Sample.frequenz:=Frequenz;
  Sample.laenge:=Dateilaenge;
end;

procedure FreeSample(var Sample : smallsample);
begin
  freemem(Sample.adresse,Sample.laenge);
  Sample.frequenz  :=0;
  Sample.laenge    :=0;
  Sample.offset    :=0;
  Sample.page      :=0;
end;

procedure PlaySample(var Sample : smallsample);
var OldInt : pointer;
     dummy : byte;
begin
  ok:=false;
  PlayBuf(1,8000);   { Keine Ahnung warum das hier stehen mu, aber ohne
                          spielt meine Soundkarte ( keine orginal SB ) bei
                          erneutem Aufruf der Procedure den Sound nicht
                          sauber ab }
  ResetDSPAgain;            { zur sicherheit noch einen DSPReset }
  SpeakerOn;                { Lautsprecher wieder an }
  DMAReset;                 { noch ein DMA-Reset }

  { Alte Interruptroutine des SB-IRQKanals sichern...}
  GetIntVec(IRQ[IRQKanal],OldInt);

  asm cli end;
  SetIntVec(IRQ[IRQKanal],addr(HardDiskPlayHandler));
  asm sti end;

  { DMA-Controller auf folgende Daten vorbereiten ... }
  SetupDMA(DMAKanal,Sample.offset,Sample.page,Sample.laenge);

  { Frequenz einstellen und endlich abspielen ... }
  PlayBuf(Sample.laenge,Sample.frequenz);

  Repeat dummy:=100; until ok=true;

  asm cli end;
  SetIntVec(IRQ[IRQKanal],OldInt);
  asm sti end;
  ok:=false;
end;



{ Abspielprocedure fr Sounddateien die grer als 65535 Bytes sind }

procedure HarddiskPlay(Dateiname : string;frequenz : word;dma_buffer_laenge : word);
var                SoundDatei : file;
                  DateiLaenge : longint;
                 Bloecke,Rest : integer;
                      Zaehler : integer;
                       offset : word;
       dma_buffer_laenge_save : word;
                   page,dummy : byte;
                       Oldint : pointer;


begin

     PlayBuf(1,8000);   { Keine Ahnung warum das hier stehen mu, aber ohne
                          spielt meine Soundkarte ( keine orginal SB ) bei
                          erneutem Aufruf der Procedure den Sound nicht
                          sauber ab }

     ResetDSPAgain;            { zur sicherheit noch einen DSPReset }
     SpeakerOn;                { Lautsprecher wieder an }
     DMAReset;                 { noch ein DMA-Reset }
     ok:=false;

     assign(SoundDatei,Dateiname);
     reset(SoundDatei,1);
     DateiLaenge:=filesize(SoundDatei);

     { Anzahl der Blcke fr den DMA-transfer berechnen...}
     Bloecke:=Dateilaenge DIV dma_buffer_laenge;

     { Gre des brigen Blocks berechnen ... }
     Rest:=Dateilaenge MOD dma_buffer_laenge;

     { Zwei gleichgroe Speicherblcke reservieren }
     getmem(Buf1,dma_buffer_laenge);
     getmem(Buf2,dma_buffer_laenge);
     dma_buffer_laenge_save:=dma_buffer_laenge;


     { Aktuelle funktion des jeweiligen Blocks setzen }
     PlayingBuffer:=Buf1;  { momentan abzuspielender Block }
     ReadingBuffer:=Buf2;  { momentan zu lesender Block }


     { Erste Ladung Daten einlesen ... } 
     blockread(SoundDatei,PlayingBuffer^,dma_buffer_laenge);

     { Alte Interruptroutine des SB-IRQKanals sichern...}
     GetIntVec(IRQ[IRQKanal],OldInt);

     { Hauptschleife zum abspielen aller Blcke }
     for Zaehler:=1 to Bloecke+1 do
     begin

       { Neuen Handler fr SB-IRQKanal installieren ... }
       asm cli end;
       SetIntVec(IRQ[IRQKanal],addr(HardDiskPlayHandler));
       asm sti end;


       { offset + page fr abzuspielenden Block berechnen ... }
       offset := Seg(PlayingBuffer^) Shl 4 + Ofs(PlayingBuffer^);
       page := (Seg(PlayingBuffer^) + Ofs(PlayingBuffer^) shr 4) shr 12;

       { DMA-Controller auf nchsten Block vorbereiten ... }
       SetupDMA(DMAKanal,offset,page,dma_buffer_laenge);

       { Frequenz einstellen und endlich abspielen ... }
       PlayBuf(dma_buffer_laenge,frequenz);

       
       if Zaehler=Bloecke then
       dma_buffer_laenge:=Rest;

       { Whrend der DMA-Controller dem DSP Daten bertrgt laden wir
         ganz unbemerkt schon den nchsten Block ... }
       if Zaehler<Bloecke+1 then
       blockread(SoundDatei,ReadingBuffer^,dma_buffer_laenge);

       { Und jetzt warten wir noch kurz bis die SB den Interrupt aus-
         gefhrt hat und somit die Daten vollstndig ausgegeben sind.
         Auerdem wurde im Interrupthandler noch der Block mit den neuen
         Daten zum nchsten abzuspielenden Block gemacht ... }
         
       repeat dummy:=100; until (ok=true);
       ok:=false;
     end;

     { Alten Interrupt-Handler wieder installieren }
     asm cli end;
     SetIntVec(IRQ[IRQKanal],OldInt);
     asm sti end;

     { Speicher wieder freigeben ... }

     freemem(Buf1,dma_buffer_laenge_save);
     freemem(Buf2,dma_buffer_laenge_save);
     close(soundDatei);
     ok:=false;
end;

Function SBAbfrage : boolean;
var       c : char;

begin
     clrscr;
     Writeln('             Soundblaster Einstellungen           ');
     Writeln;Writeln;
     writeln('(1) Manuelle Eingabe der SB-Einstellungen');
     writeln('(2) Auto-Detect ');
     writeln('(3) BLASTER Environment Variable');
     writeln('(4) Beenden');
     writeln;
     write('Wahl:');
     repeat
       c:=readkey;
     until (c='1') or (c='2') or (c='3') or (c='4');
     write(c);
     writeln;
     case c of

          '1' : begin
                  repeat
                   clrscr;
                   c:='X';
                   writeln(' Basisadresse ');
                   writeln;
                   writeln('(1) 210h');
                   writeln('(2) 220h');
                   writeln('(3) 230h');
                   writeln('(4) 240h');
                   writeln('(5) 250h');
                   writeln('(6) 260h');
                   writeln('(7) 270h');
                   writeln('(8) 280h');writeln;
                   write('Wahl:');
                   repeat
                    c:=readkey
                   until (c='1') or (c='2') or (c='3') or(c='4') or(c='5') or
                   (c='6') or (c='7') or(c='8');
                   write(c);

                   case c of '1' : BasisAdresse := $210;
                             '2' : BasisAdresse := $220;
                             '3' : BasisAdresse := $230;
                             '4' : BasisAdresse := $240;
                             '5' : BasisAdresse := $250;
                             '6' : BasisAdresse := $260;
                             '7' : BasisAdresse := $270;
                             '8' : BasisAdresse := $280;
                   end;
                   writeln;
                   c:='X';

                   clrscr;
                   writeln(' IRQ Kanal ');
                   writeln;
                   writeln('(1) IRQ 2');
                   writeln('(2) IRQ 3');
                   writeln('(3) IRQ 5');
                   writeln('(4) IRQ 7');
                   writeln('(5) IRQ 10');
                   writeln('(6) IRQ 11');
                   writeln('(7) IRQ 12');
                   writeln('(8) IRQ 13');
                   writeln('(9) IRQ 15');writeln;
                   write('Wahl:');
                   repeat
                    c:=readkey
                   until (c='1') or (c='2') or (c='3') or(c='4') or(c='5') or
                   (c='6') or (c='7') or (c='8') or (c='9');
                   write(c);

                   case c of '1' : IRQKanal := 2;
                             '2' : IRQKanal := 3;
                             '3' : IRQKanal := 5;
                             '4' : IRQKanal := 7;
                             '5' : IRQKanal := 10;
                             '6' : IRQKanal := 11;
                             '7' : IRQKanal := 12;
                             '8' : IRQKanal := 13;
                             '9' : IRQKanal := 15;
                   end;
                   c:='X';
                   clrscr;
                   writeln(' DMA Kanal ');
                   writeln;
                   writeln('(0) DMA 0');
                   writeln('(1) DMA 1');
                   writeln('(2) DMA 2');
                   writeln('(3) DMA 3');writeln;
                   write('Wahl:');
                   repeat
                    c:=readkey
                   until (c='0') or (c='1') or (c='2') or(c='3');
                   write(c);
                   case c of '0' : DMAKanal := 0;
                             '1' : DMAKanal := 1;
                             '2' : DMAKanal := 2;
                             '3' : DMAKanal := 3;
                   end;
                   c:='X';
                   writeln;
                   writeln;
                   writeln(hexstr(BasisAdresse),'h DMA',DMAKanal,' IRQ',IRQKanal);
                   writeln('Sind diese Einstellungen korrekt ? (j/n)');
                   repeat
                     c:=readkey;
                   until (c='j') or (c='n');
                  until c='j';

                  SetDSPVars(BasisAdresse); { Register des DSP zur Basis berechnen }
                  DemaskiereInterrupt;
                  SBAbfrage:=true;
                end;

     '2'      : begin
                clrscr;
                writeln('Suche nach Soundblaster ...');
                if ResetDSP(BasisAdresse)=true then
                begin
                  writeln('Soundblaster gefunden ! ');
                  writeln('Port: ',HexStr(BasisAdresse),'h');
                  writeln('Suche nach weiteren Einstellungen ...');
                  if SBAutoDetect(BasisAdresse,@DetectionHandler) = true then
                  begin
                    writeln('IRQ = ',IRQKanal);
                    writeln('DMA = ',DMAKanal);
                    writeln('Hardwareerkennung erfolgreich !');
                    writeln;
                    writeln('------ Eingabetaste -----');
                    readln;
                    SBAbfrage:=true;
                    SetDSPVars(BasisAdresse); { Register des DSP zur Basis berechnen }
                    DemaskiereInterrupt;
                  end
                  else
                  begin
                    writeln('Weitere Erkennung fehlgeschlagen !');
                    writeln('Bitte manuelle Eingabe der Einstellungen !');
                    SBAbfrage:=false;
                  end;
                end
                else
                begin
                  writeln('Keine Soundblaster gefunden !');
                  SBAbfrage:=false;
                end;
                end;

       '3'    : begin
                  writeln('Suche nach BLASTER Environment Variable...');
                  if SBEnvironmentVar=true then
                  begin
                    writeln('Basisadresse: ',HexStr(BasisAdresse),' IRQ: ',IRQKanal,' DMA: ',DMAKanal);
                    SetDSPVars(BasisAdresse); { Register des DSP zur Basis berechnen }
                    DemaskiereInterrupt;
                    SBAbfrage:=true;
                  end
                  else SBAbfrage:=false;
                end;

       '4'    : begin
                SBAbfrage:=false;
                end;
     end;
end;

{ Initialisation }

begin
  ok:=false;
end.