/* Mintris.c                                                          */
/* Programmed by Min S. Kwon                                          */
/* March 3, 1996                                                      */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <malloc.h>
#include <dos.h>
#include <conio.h>
#include <math.h>
#include <bios.h>

#define BLOCKSIZE 11
#define DIGITOFFSET0 (190 << 8) + (190 << 6) + 280
#define DIGITOFFSET1 (190 << 8) + (190 << 6) + 290
#define DIGITOFFSET2 (190 << 8) + (190 << 6) + 300
#define LEN 165
#define NUMBLOCKS 4
#define BLOCKBUFF 100
#define SCREENWIDTH 320
#define DEAD 0
#define CENTERX 7
#define CENTERY 16
#define TIMER_KEEPER_INT 0x01C     /* Interrupt for internal timer */
#define PALETTE_MASK 0x3c6
#define PALETTE_REGISTER 0x3c8
#define PALETTE_DATA 0x3c9
#define VGA_INPUT_STATUS_1 0x3da
#define VGA_VSYNC_MASK 0x08        /* VGA retrace */

typedef struct {                   /* RGB palette type */
   unsigned char red;
   unsigned char green;
   unsigned char blue;
} rgb_color, *rgb_color_ptr;

typedef struct {                   /* PCX picture type */
   rgb_color palette[256];
   char far *buffer;
} pcx_picture, *pcx_picture_ptr;
                                   /* Sprite type */
typedef struct {
   int x, y, xold, yold;
   int type, pos, yhigh, xhigh, xlow;
   char far *frame;
   char far *background[10];
} sprite, *sprite_ptr;
                                   /* 2-D represendation of board */
struct {
   int taken;
   int type;
} filled[20][20];

void quit_program(char *, ...);
void load_blocks(unsigned char far *[], pcx_picture_ptr);
void fill_board(sprite_ptr);
void pcx_show_buffer(pcx_picture_ptr);
void pcx_init(pcx_picture_ptr);
void refresh_background();
void pcx_load(char *, pcx_picture_ptr, short int);
void pcx_delete(pcx_picture_ptr);
void pcx_grab_bitmap(pcx_picture_ptr, sprite_ptr);
void set_palette_register(int, rgb_color_ptr);
void setmode(int);
void sprite_init(sprite_ptr sprite, int x, int y, int);
void draw_sprite(sprite_ptr sprite);
void behind_sprite(sprite_ptr sprite);
void erase_sprite(sprite_ptr sprite);
void retrace();
void shift_down();
void do_bound(sprite_ptr);
void do_check(sprite_ptr);
void correct();
void save_background();
void move_right(sprite_ptr);
void draw_block(unsigned int, unsigned int, int);
void move_down(sprite_ptr);
void move_left(sprite_ptr);
void rotate_block(sprite_ptr);
void (interrupt far *old_isr)();
void interrupt far timer();
void clear_filled();
void init_downbuff();
void free_memory(sprite_ptr);
void load_number(pcx_picture_ptr);
void display_number(int, int);
void change_bk();
void game_over();
void print_score(int);
void get_palette_register(int, rgb_color_ptr);
void fade_out();
int move_below();
int check_down(sprite_ptr);
int check_left(sprite_ptr);
int check_right(sprite_ptr);
int pos(int, int);
int rotate_correct();

unsigned char get_scan_code();
unsigned char far *vga = (char far *) 0xA0000000L;  /* Pointer to VGA RAM */
unsigned char far *blocks[NUMBLOCKS];
unsigned char far *downbuff;
unsigned char far number[11][70];
/* unsigned char far num_back[510]; */
float timed = 0.0, accumulator = 0.05;
int state = 0, minx, miny, maxy, maxx, row = CENTERY, col = CENTERX;
unsigned int lines = 0, amnt, voffset, numlines = 10, bground;
char stacked = 2, rotate, buf[20];
pcx_picture background, block;
sprite square;

int main(int argc, char **argv)
{
   old_isr = _dos_getvect(TIMER_KEEPER_INT);    /* Internal timer */
   _dos_setvect(TIMER_KEEPER_INT, timer);
   srand(time(NULL));
   rotate = rand() % 3;
   bground = (rand() % 7) + 1;
   sprintf(buf, "%d.dat", bground++);
   setmode(0x13);
   clear_filled();
   init_downbuff();
   pcx_init(&background);
   pcx_load(buf, (pcx_picture_ptr) &background, 1);
   pcx_show_buffer(&background);
   load_number(&background);
   load_blocks(&blocks, &background);
   save_background();
   pcx_delete(&background);
   print_score(000);
   sprite_init(&square, 77, 13, rand() % 7);
   square.frame = blocks[rotate++];
   behind_sprite(&square);
   draw_sprite(&square);
   while(1) {
      if(state) {
         square.type = rand() % 7;
         square.pos = 0;
         stacked = 2;
         timed = 0.0;
         if(rotate > 3) rotate = 0;
         square.frame = blocks[rotate++];
         behind_sprite(&square);
         draw_sprite(&square);
         state = 0;
         do_check(&square);
      }
      switch(get_scan_code()) {
         case 77: move_right(&square);
                  break;
         case 75: move_left(&square);
                  break;
         case 57: stacked = 0;
                  while(!stacked) {
                     move_down(&square);
                     delay(20);
                  }
                  break;
         case 80: move_down(&square);
                  break;
         case 72: rotate_block(&square);
                  break;
         case 01: game_over();
                  break;
         default: break;
      }
      retrace();
      if(timed >= 1) {
         if(stacked == 2) move_down(&square);
         timed=0.0;
      }
   }
   setmode(0x03);
   return 0;
}

void print_score(int num)
{
   char buf[5], one[5], ten[5], hun[5];
   if(num < 10) {
      display_number(0, DIGITOFFSET0);
      display_number(0, DIGITOFFSET1);
      display_number(num, DIGITOFFSET2);
      return;
   }
   sprintf(buf, "%d", num);
   if(num >= 10 && num < 100) {
      sprintf(ten, "%c", buf[0]);
      sprintf(one, "%c", buf[1]);
      display_number(0, DIGITOFFSET0);
      display_number(atoi(ten), DIGITOFFSET1);
      display_number(atoi(one), DIGITOFFSET2);
      return;
   }
   else {
      sprintf(hun, "%c", buf[0]);
      sprintf(ten, "%c", buf[1]);
      sprintf(one, "%c", buf[2]);
      display_number(atoi(hun), DIGITOFFSET0);
      display_number(atoi(ten), DIGITOFFSET1);
      display_number(atoi(one), DIGITOFFSET2);
   }
}

void get_palette_register(int index, rgb_color_ptr color)
{
   outp(PALETTE_MASK, 0xff);
   outp(PALETTE_REGISTER, index);
   color->red = inp(PALETTE_DATA);
   color->green = inp(PALETTE_DATA);
   color->blue = inp(PALETTE_DATA);
}

void game_over()
{
   int i;
   pcx_picture gameover;
   pcx_init(&gameover);
   fade_out();
   _fmemcpy(vga, 0, 64000);
   pcx_load("over.dat", &gameover, 0);
   pcx_show_buffer(&gameover);
   for(i = 0; i < 256; i++)
      set_palette_register(i, &gameover.palette[i]);
   getch();
   quit_program("Game Over");
}

void fade_out()
{
   int loop1, loop2;
   rgb_color color;
   for(loop1=0; loop1<64; loop1++) {
      retrace();
      for(loop2=0; loop2<256; loop2++) {
         get_palette_register(loop2, &color);
         get_palette_register(loop2, &color);
         if (color.red > 0) color.red--;
         if (color.green > 0) color.green--;
         if (color.blue > 0) color.blue--;
         set_palette_register(loop2, &color);
      }
      retrace();
   }
}

void display_number(int num, int off)
{
   unsigned noffset = 0, y, x;
   unsigned char data, len;
   for(y = 0; y < 9; y++) {
      for(x = 0; x < 7; x++) {
         if((data=number[num][noffset+x]))
            vga[off+x] = data;
      }
      off += 320;
      noffset += 7;
   }
}

/*
void copy_numback()
{
   int i, off = 0;
   for(i = 190; i <= 200; i++) {
      _fmemcpy(&num_back[off], &vga[320*i+270], 50);
      off+=50;
   }
}

void replace_numback()
{
   int i, off = 0;
   for(i = 190; i <= 200; i++) {
      _fmemcpy(&vga[320*i+270], &num_back[off], 50);
      off+=50;
   }
}
*/
void load_number(pcx_picture_ptr image)
{
   int i, j;
   for(i = 0; i < 9; i++) {
      j = (i << 8) + (i << 6);
      _fmemcpy(&number[0][i*7], &image->buffer[250+j], 7);
      _fmemcpy(&number[1][i*7], &image->buffer[250+j+7], 7);
      _fmemcpy(&number[2][i*7], &image->buffer[250+j+14], 7);
      _fmemcpy(&number[3][i*7], &image->buffer[250+j+21], 7);
      _fmemcpy(&number[4][i*7], &image->buffer[250+j+28], 7);
      _fmemcpy(&number[5][i*7], &image->buffer[250+j+35], 7);
      _fmemcpy(&number[6][i*7], &image->buffer[250+j+42], 7);
      _fmemcpy(&number[7][i*7], &image->buffer[250+j+49], 7);
      _fmemcpy(&number[8][i*7], &image->buffer[250+j+56], 7);
      _fmemcpy(&number[9][i*7], &image->buffer[250+j+63], 7);
   }
}

void refresh_background()
{
   _fmemcpy(vga, downbuff, 64000);
}

int rotate_correct()
{
   if(rotate > 3) return (rotate-1);
   return rotate;
}

void init_downbuff()
{
   if((downbuff = (char far *) _fmalloc(64000)) == NULL)
      quit_program("Insufficient memory");
}

void correct() {
   if(minx<0) minx = 0;
   if(maxy<0) maxy = 0;
}

int move_below()         /* Any way to speed this up? */
{
   int i, j, k, x, y, taken, takenonce = 0, allclear;
   for(i = 0; i < 18; i++) {    /* Should use While, not much overhead */
      taken = 1;
      for(j = 0; j < 15; j++)
         if(!filled[i][j].taken) {
            taken = 0;
            break;
         }
      if(taken) {
         for(y = 0; y < 5; y++) {
            for(j = i; j < 18; j++) {
               for(k = 0; k < 15; k++) {
                  filled[j][k] = filled[j+1][k];
                  filled[j+1][k].taken = 0;
               }
            }
            if(++lines >= numlines) {
               accumulator += 0.01;
               numlines += 10;
            }
            allclear = 1;
            for(x = 0; x < 15; x++) if(!filled[i][x].taken) allclear = 0;
            if(!allclear) break;
         }
         takenonce = 1;
      }
   }
   return takenonce;
}

void shift_down()
{
   int x, y, xoff;
   if(!move_below()) return;
   refresh_background();
   for(y = 0; y < 18; y++)
      for(x = 0, xoff = 0; x < 15; x++, xoff+=11)
         if(filled[y][x].taken) draw_block(200-((y+1)*11),xoff,filled[y][x].type);
   print_score(lines);
   printf("\a\n");
}

void draw_block(unsigned int yoffset, unsigned int xoffset, int type)
{
   int i;
   for(i = 0; i < 11; i++)
      _fmemcpy(&vga[(yoffset*320)+xoffset+320*i],&blocks[type][11*i],11);
}

void do_check(sprite_ptr sprite)   /* Tedious bit */
{
   switch(sprite->type) {
      case 0: switch(sprite->pos) {
                 case 0: minx = col-1;
                         maxx = col+1;
                         miny = row+1;
                         maxy = row;
                         break;
                 case 1: minx = col;
                         maxx = col+1;
                         miny = row+1;
                         maxy = row-1;
                         break;
                 case 2: minx = col-1;
                         maxx = col+1;
                         miny = row;
                         maxy = row-1;
                         break;
                 case 3: minx = col-1;
                         maxx = col;
                         miny = row+1;
                         maxy = row-1;
                         break;
               }
               break;
       case 1: switch(sprite->pos) {
                  case 0: minx = col-1;
                          maxx = col+2;
                          miny = row;
                          maxy = row;
                          break;
                  case 1: minx = col;
                          maxx = col;
                          miny = row+2;
                          maxy = row-1;
                          break;
               }
               break;
       case 2: switch(sprite->pos) {
                  case 0: minx = col-1;
                          maxx = col+1;
                          miny = row+1;
                          maxy = row;
                          break;
                  case 1: minx = col;
                          maxx = col+1;
                          miny = row+1;
                          maxy = row-1;
                          break;
                  case 2: minx = col-1;
                          maxx = col+1;
                          miny = row;
                          maxy = row-1;
                          break;
                  case 3: minx = col-1;
                          maxx = col;
                          miny = row+1;
                          maxy = row-1;
                          break;
               }
               break;
       case 3: switch(sprite->pos) {
                  case 0: minx = col-1;
                          maxx = col+1;
                          miny = row+1;
                          maxy = row;
                          break;
                  case 1: minx = col;
                          maxx = col+1;
                          miny = row+1;
                          maxy = row-1;
                          break;
               }
               break;
       case 4: switch(sprite->pos) {
                  case 0: minx = col-1;
                          maxx = col+1;
                          miny = row+1;
                          maxy = row;
                          break;
                  case 1: minx = col-1;
                          maxx = col;
                          miny = row+1;
                          maxy = row-1;
                          break;
               }
               break;
       case 5: switch(sprite->pos) {
                  case 0: minx = col-1;
                          maxx = col+1;
                          miny = row+1;
                          maxy = row;
                          break;
                  case 1: minx = col;
                          maxx = col+1;
                          miny = row+1;
                          maxy = row-1;
                          break;
                  case 2: minx = col-1;
                          maxx = col+1;
                          miny = row;
                          maxy = row-1;
                          break;
                  case 3: minx = col-1;
                          maxx = col;
                          miny = row+1;
                          maxy = row-1;
                          break;
               }
               break;
       case 6: minx = col;
               maxx = col+1;
               miny = row+1;
               maxy = row;
               break;
    }
    correct();
}

void rotate_block(sprite_ptr sprite)
{
   int old_pos;
   old_pos = sprite->pos;
   switch(sprite->type) {
       case 2:
       case 5:
       case 0: if(++sprite->pos > 3) sprite->pos = 0;
               break;
       case 3:
       case 4:
       case 1: if(++sprite->pos > 1) sprite->pos = 0;
               break;

   }
   do_check(sprite);
   do_bound(sprite);
   if((sprite->xlow < 0)||(sprite->xhigh > 155)||
      (sprite->yhigh > 198)||filled[row][minx].taken||filled[row][maxx].taken||
      filled[miny][minx].taken||filled[miny][maxx].taken||filled[maxy][minx].taken||
      filled[maxy][maxx].taken||filled[row][col].taken||filled[miny][col].taken||
      filled[maxy][col].taken) {
      sprite->pos = old_pos;
      return;
   }
   erase_sprite(sprite);
   behind_sprite(sprite);
   draw_sprite(sprite);
}


void interrupt far timer()
{
   timed = timed + accumulator;
}

void clear_filled()
{
   int i, j;
   for(i = 0; i < 20; i++)
      for(j = 0; j < 20; j++) {
         filled[i][j].taken = 0;
         filled[i][j].type = 0;
      }
}

void move_left(sprite_ptr sprite)
{
   int old;
   do_bound(sprite);
   if(check_left(sprite)) return;
   if(sprite->xlow < 8) return;
   col--;
   do_check(sprite);
   erase_sprite(sprite);
   sprite->x-=11;
   behind_sprite(sprite);
   draw_sprite(sprite);
}

void move_right(sprite_ptr sprite)
{
   do_bound(sprite);
   if(check_right(sprite)) return;
   if(sprite->xhigh > 153) return;
   erase_sprite(sprite);
   col++;
   do_check(sprite);
   sprite->x+=11;
   behind_sprite(sprite);
   draw_sprite(sprite);
}

int pos(int a, int b)
{
   if((a - b) < 0)
      return 0;
   else return(a-b);
}

int check_right(sprite_ptr sprite)
{
   switch(sprite->type) {
      case 0: switch(sprite->pos) {
                 case 0: if(filled[miny][col+1].taken||filled[row][maxx+1].taken) return 1;
                         break;
                 case 1: if(filled[miny][col+1].taken||filled[maxy][col+1].taken||filled[row][maxx+1].taken) return 1;
                         break;
                 case 2: if(filled[row][maxx+1].taken||filled[maxy][col+1].taken) return 1;
                         break;
                 case 3: if(filled[miny][col+1].taken||filled[row][col+1].taken||filled[maxy][col+1].taken) return 1;
                         break;
              }
              break;
      case 1: switch(sprite->pos) {
                 case 0: if(filled[row][maxx+1].taken) return 1;
                         break;
                 case 1: if(filled[maxy][col+1].taken||filled[row][col+1].taken||filled[miny-1][col+1].taken||filled[miny][col+1].taken) return 1;
                         break;
              }
              break;
      case 2: switch(sprite->pos) {
                 case 0: if(filled[row][maxx+1].taken||filled[miny][minx+1].taken) return 1;
                         break;
                 case 1: if(filled[row][col+1].taken||filled[maxy][col+1].taken||filled[miny][maxx+1].taken) return 1;
                         break;
                 case 2: if(filled[row][maxx+1].taken||filled[maxy][maxx+1].taken) return 1;
                         break;
                 case 3: if(filled[row][col+1].taken||filled[maxy][col+1].taken||filled[miny][col+1].taken) return 1;
                         break;
              }
              break;
      case 3: switch(sprite->pos) {
                 case 0: if(filled[miny][col+1].taken||filled[row][maxx+1].taken) return 1;
                         break;
                 case 1: if(filled[miny][maxx+1].taken||filled[row][maxx+1].taken||filled[maxy][col+1].taken) return 1;
                         break;
              }
              break;
      case 4: switch(sprite->pos) {
                 case 0: if(filled[miny][maxx+1].taken||filled[row][col+1].taken) return 1;
                         break;
                 case 1: if(filled[row][col+1].taken||filled[miny][minx+1].taken||filled[maxy][col+1].taken) return 1;
                         break;
              }
              break;
      case 5: switch(sprite->pos) {
                 case 0: if(filled[row][maxx+1].taken||filled[miny][maxx+1].taken) return 1;
                         break;
                 case 1: if(filled[row][col+1].taken||filled[miny][col+1].taken||filled[maxy][maxx+1].taken) return 1;
                         break;
                 case 2: if(filled[row][maxx+1].taken||filled[maxy][minx+1].taken) return 1;
                         break;
                 case 3: if(filled[row][col+1].taken||filled[miny][col+1].taken||filled[maxy][col+1].taken) return 1;
                         break;
              }
              break;
      case 6: if(filled[miny][maxx+1].taken||filled[row][maxx+1].taken) return 1;
              break;
   }

   return 0;
}
int check_left(sprite_ptr sprite)
{
   switch(sprite->type) {
      case 0: switch(sprite->pos) {
                 case 0: if(filled[row][minx-1].taken||filled[miny][col-1].taken) return 1;
                         break;
                 case 1: if(filled[miny][col-1].taken||filled[row][col-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
                 case 2: if(filled[row][minx-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
                 case 3: if(filled[row][minx-1].taken||filled[miny][col-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
              }
              break;
      case 1: switch(sprite->pos) {
                 case 0: if(filled[row][minx-1].taken) return 1;
                         break;
                 case 1: if(filled[maxy][col-1].taken||filled[row][col-1].taken||filled[miny-1][col-1].taken||filled[miny][col-1].taken) return 1;
                         break;
              }
              break;
      case 2: switch(sprite->pos) {
                 case 0: if(filled[row][minx-1].taken||filled[miny][minx-1].taken) return 1;
                         break;
                 case 1: if(filled[miny][col-1].taken||filled[row][col-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
                 case 2: if(filled[row][minx-1].taken||filled[maxy][maxx-1].taken) return 1;
                         break;
                 case 3: if(filled[miny][col-1].taken||filled[row][col-1].taken||filled[maxy][minx-1].taken) return 1;
                         break;
              }
              break;
      case 3: switch(sprite->pos) {
                 case 0: if(filled[miny][minx-1].taken||filled[row][col-1].taken) return 1;
                         break;
                 case 1: if(filled[row][col-1].taken||filled[miny][maxx-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
              }
              break;
      case 4: switch(sprite->pos) {
                 case 0: if(filled[miny][col-1].taken||filled[row][minx-1].taken) return 1;
                         break;
                 case 1: if(filled[row][minx-1].taken||filled[miny][minx-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
              }
              break;
      case 5: switch(sprite->pos) {
                 case 0: if(filled[row][minx-1].taken||filled[miny][maxx-1].taken) return 1;
                         break;
                 case 1: if(filled[row][col-1].taken||filled[miny][col-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
                 case 2: if(filled[row][minx-1].taken||filled[maxy][minx-1].taken) return 1;
                         break;
                 case 3: if(filled[miny][minx-1].taken||filled[row][col-1].taken||filled[maxy][col-1].taken) return 1;
                         break;
              }
              break;
      case 6: if(filled[row][col-1].taken||filled[miny][col-1].taken) return 1;
              break;
   }
   return 0;
}

int check_down(sprite_ptr sprite)
{
   int i;
   switch(sprite->type) {
      case 0: switch(sprite->pos) {
                 case 0: i = pos(row, 1);
                         if(filled[i][minx].taken||filled[i][maxx].taken||filled[i][col].taken)
                            return 1;
                         break;
                 case 1: if(filled[pos(maxy,1)][col].taken||filled[pos(row,1)][maxx].taken) return 1;
                         break;
                 case 2: i = pos(row, 1);
                         if(filled[i][minx].taken||filled[i][maxx].taken||filled[pos(maxy,1)][col].taken) return 1;
                         break;
                 case 3: if(filled[pos(maxy,1)][col].taken||filled[pos(row,1)][minx].taken) return 1;
                         break;
              }
              break;
      case 1: switch(sprite->pos) {
                 case 0: i = pos(row, 1);
                         if(filled[i][minx].taken||filled[i][col].taken||filled[i][col+1].taken||filled[i][maxx].taken) return 1;
                         break;
                 case 1: if(filled[pos(maxy,1)][col].taken) return 1;
                         break;
              }
              break;
      case 2: switch(sprite->pos) {
                 case 0: i = pos(row, 1);
                         if(filled[i][minx].taken||filled[i][maxx].taken||filled[i][col].taken) return 1;
                         break;
                 case 1: if(filled[pos(maxy,1)][col].taken||filled[pos(miny,1)][maxx].taken) return 1;
                         break;
                 case 2: i = pos(row, 1);
                         if(filled[i][minx].taken||filled[i][col].taken||filled[pos(maxy,1)][maxx].taken) return 1;
                         break;
                 case 3: i = pos(maxy, 1);
                         if(filled[i][minx].taken||filled[i][col].taken) return 1;
                         break;
              }
              break;
      case 3: switch(sprite->pos) {
                 case 0: i = pos(row, 1);
                         if(filled[i][col].taken||filled[i][maxx].taken||filled[miny][minx].taken) return 1;
                         break;
                 case 1: if(filled[pos(row,1)][maxx].taken||filled[pos(maxy,1)][col].taken) return 1;
                         break;
              }
              break;
      case 4: switch(sprite->pos) {
                 case 0: i = pos(row, 1);
                         if(filled[i][col].taken||filled[i][minx].taken||filled[miny][maxx].taken) return 1;
                         break;
                 case 1: if(filled[pos(row,1)][minx].taken||filled[pos(maxy,1)][col].taken) return 1;
                         break;
              }
              break;
      case 5: switch(sprite->pos) {
                 case 0: i = pos(row, 1);
                         if(filled[i][minx].taken||filled[i][col].taken||filled[i][maxx].taken) return 1;
                         break;
                 case 1: i = pos(maxy, 1);
                         if(filled[i][col].taken||filled[i][maxx].taken) return 1;
                         break;
                 case 2: i = pos(row, 1);
                         if(filled[i][col].taken||filled[i][maxx].taken||filled[pos(maxy,1)][minx].taken) return 1;
                         break;
                 case 3: if(filled[pos(miny,1)][minx].taken||filled[pos(maxy,1)][col].taken) return 1;
                         break;
              }
              break;
      case 6: i = pos(row, 1);
              if(filled[i][col].taken||filled[i][maxx].taken) return 1;
              break;
   }
   return 0;
}

void fill_board(sprite_ptr sprite)
{
   int corrected;
   corrected = rotate_correct();
   switch(sprite->type) {
      case 0: switch(sprite->pos) {
                 case 0: filled[row][minx].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[row][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[row][minx].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[row][col].type = corrected;
                         filled[miny][col].type = corrected;
                         break;
                 case 1: filled[maxy][col].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[row][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[maxy][col].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[row][col].type = corrected;
                         filled[miny][col].type = corrected;
                         break;
                 case 2: filled[row][col].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[maxy][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[row][maxx].type = corrected;
                         break;
                 case 3: filled[row][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[maxy][col].type = corrected;
                         filled[miny][col].type = corrected;
                         break;
              }
              break;
      case 1: switch(sprite->pos) {
                 case 0: filled[row][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[row][maxx-1].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[row][maxx-1].type = corrected;
                         filled[row][maxx].type = corrected;
                         break;
                 case 1: filled[row][col].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[miny-1][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[row][col].type = corrected;
                         filled[maxy][col].type = corrected;
                         filled[miny-1][col].type = corrected;
                         filled[miny][col].type = corrected;
                         break;
              }
              break;
      case 2: switch(sprite->pos) {
                 case 0: filled[row][minx].taken = 1;
                         filled[row][col].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[miny][minx].taken = 1;
                         filled[row][minx].type = corrected;
                         filled[row][col].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[miny][minx].type = corrected;
                         break;
                 case 1: filled[row][col].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[miny][maxx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[maxy][col].type = corrected;
                         filled[miny][col].type = corrected;
                         filled[miny][maxx].type = corrected;
                         break;
                 case 2: filled[row][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[maxy][maxx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[maxy][maxx].type = corrected;
                         break;
                 case 3: filled[row][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[maxy][minx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[miny][col].type = corrected;
                         filled[maxy][col].type = corrected;
                         filled[maxy][minx].type = corrected;
                         break;
              }
              break;
      case 3: switch(sprite->pos) {
                 case 0: filled[row][col].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[miny][minx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[miny][col].taken = corrected;
                         filled[miny][minx].taken = corrected;
                         break;
                 case 1: filled[row][col].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[miny][maxx].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[miny][maxx].type = corrected;
                         filled[maxy][col].type = corrected;
                         break;
              }
              break;
      case 4: switch(sprite->pos) {
                 case 0: filled[row][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[miny][maxx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[miny][col].type = corrected;
                         filled[miny][maxx].type = corrected;
                         break;
                 case 1: filled[row][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[miny][minx].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[miny][minx].type = corrected;
                         filled[maxy][col].type = corrected;
                         break;
              }
              break;
      case 5: switch(sprite->pos) {
                 case 0: filled[row][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[miny][maxx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[miny][maxx].type = corrected;
                         break;
                 case 1: filled[row][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[maxy][maxx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[miny][col].type = corrected;
                         filled[maxy][col].type = corrected;
                         filled[maxy][maxx].type = corrected;
                         break;
                 case 2: filled[row][col].taken = 1;
                         filled[row][minx].taken = 1;
                         filled[row][maxx].taken = 1;
                         filled[maxy][minx].taken = 1;
                         filled[row][col].type = corrected;
                         filled[row][minx].type = corrected;
                         filled[row][maxx].type = corrected;
                         filled[maxy][minx].type = corrected;
                         break;
                 case 3: filled[row][col].taken = 1;
                         filled[miny][col].taken = 1;
                         filled[miny][minx].taken = 1;
                         filled[maxy][col].taken = 1;
                         filled[row][col].type = corrected;
                         filled[miny][col].type = corrected;
                         filled[miny][minx].type = corrected;
                         filled[maxy][col].type = corrected;
                         break;
              }
              break;
      case 6: filled[row][col].taken = 1;
              filled[row][maxx].taken = 1;
              filled[miny][col].taken = 1;
              filled[miny][maxx].taken = 1;
              filled[row][col].type = corrected;
              filled[row][maxx].type = corrected;
              filled[miny][col].type = corrected;
              filled[miny][maxx].type = corrected;
              break;
   }
}

void move_down(sprite_ptr sprite)
{
   int i;
   do_bound(sprite);
   do_check(sprite);
   if(check_down(sprite)) {
      fill_board(sprite);
      state = 1;
      sprite->y = 13;
      sprite->x = 77;
      col = CENTERX;
      row = CENTERY;
      shift_down();
      stacked = 1;
      for(i = 0; i < 15; i++) if(filled[17][i].taken) game_over();
      return;
   }
   if(sprite->yhigh >= 187) {
      fill_board(sprite);
      state = 1;
      sprite->y = 13;
      sprite->x = 77;
      col = CENTERX;
      row = CENTERY;
      shift_down();
      stacked = 1;
      return;
   }
   row--;
   do_check(sprite);
   erase_sprite(sprite);
   sprite->y+=11;
   behind_sprite(sprite);
   draw_sprite(sprite);
}

void load_blocks(unsigned char far *block[], pcx_picture_ptr image)
{
   int i, j;
   for(i = 0; i < NUMBLOCKS; i++) {
      block[i] = (char far *) _fmalloc(125);
      if(block[i] == NULL) quit_program("Insufficient memory");
   }
   for(i = 0; i < 11; i++) {
      j = (i << 8) + (i << 6);
      _fmemcpy(&block[0][i*11], &image->buffer[j], 11);
      _fmemcpy(&block[1][i*11], &image->buffer[j+11], 11);
      _fmemcpy(&block[2][i*11], &image->buffer[j+22], 11);
      _fmemcpy(&block[3][i*11], &image->buffer[j+33], 11);
   }
}

void save_background()
{
   _fmemcpy(downbuff, vga, 64000);
}

unsigned char get_scan_code()
{
   asm {
      mov ah,0x01
      int 0x16
      jz empty
      mov ah,0x00
      int 0x16
      mov al,ah
      xor ah,ah
      jmp done
   }
   empty: asm xor ax, ax
   done: /* none */
}

void behind_sprite(sprite_ptr sprite)
{
   unsigned int y, i, j, k, l;
   for(y = 0; y < 11; y++)
      _fmemcpy(&sprite->background[0][y*11], &vga[((y+sprite->y)<<8)+((y+sprite->y)<<6)+sprite->x], 11);
   switch(sprite->type) {
      case 0: for(y = 0; y < 11; y++) {
                 i = ((y + sprite->y) << 8) + ((y + sprite->y) << 6) + sprite->x;
                 j = y*11;
                 _fmemcpy(&sprite->background[1][j],&vga[i-11],11);
                 _fmemcpy(&sprite->background[2][j],&vga[i+11],11);
                 _fmemcpy(&sprite->background[3][j],&vga[((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x],11);
                 _fmemcpy(&sprite->background[4][j],&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],11);
              }
              break;
      case 1: for(y = 0; y < 11; y++) {
                 i = ((y + sprite->y) << 8) + ((y + sprite->y) << 6) + sprite->x;
                 j = y*11;
                 _fmemcpy(&sprite->background[1][j],&vga[i-11],11);
                 _fmemcpy(&sprite->background[2][j],&vga[i+11],11);
                 _fmemcpy(&sprite->background[3][j],&vga[i+22],11);
                 _fmemcpy(&sprite->background[4][j],&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],11);
                 _fmemcpy(&sprite->background[5][j],&vga[((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x],11);
                 _fmemcpy(&sprite->background[6][j],&vga[((y+sprite->y-22)<<8)+((y+sprite->y-22)<<6)+sprite->x],11);
              }
              break;
      case 5:
      case 2: for(y = 0; y < 11; y++) {
                 i = ((y + sprite->y)<<8)+((y+sprite->y)<<6)+sprite->x;
                 k = ((y + sprite->y + 11)<<8)+((y+sprite->y+11)<<6)+sprite->x;
                 l = ((y + sprite->y - 11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 j = y * 11;
                 _fmemcpy(&sprite->background[1][j],&vga[i-11],11);
                 _fmemcpy(&sprite->background[2][j],&vga[i+11],11);
                 _fmemcpy(&sprite->background[3][j],&vga[k],11);
                 _fmemcpy(&sprite->background[4][j],&vga[k-11],11);
                 _fmemcpy(&sprite->background[5][j],&vga[k+11],11);
                 _fmemcpy(&sprite->background[6][j],&vga[l],11);
                 _fmemcpy(&sprite->background[7][j],&vga[l-11],11);
                 _fmemcpy(&sprite->background[8][j],&vga[l+11],11);
              }
              break;
      case 3: for(y = 0; y < 11; y++) {
                 k=((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 j = y * 11;
                 _fmemcpy(&sprite->background[1][j],&vga[((y+sprite->y)<<8)+((y+sprite->y)<<6)+sprite->x+11],11);
                 _fmemcpy(&sprite->background[2][j],&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],11);
                 _fmemcpy(&sprite->background[3][j],&vga[k],11);
                 _fmemcpy(&sprite->background[4][j],&vga[k-11],11);
                 _fmemcpy(&sprite->background[5][j],&vga[k+11],11);
              }
              break;
      case 4: for(y = 0; y < 11; y++) {
                 k=((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 j=y*11;
                 _fmemcpy(&sprite->background[1][j],&vga[((y+sprite->y)<<8)+((y+sprite->y)<<6)+sprite->x-11],11);
                 _fmemcpy(&sprite->background[2][j],&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],11);
                 _fmemcpy(&sprite->background[3][j],&vga[k],11);
                 _fmemcpy(&sprite->background[4][j],&vga[k-11],11);
                 _fmemcpy(&sprite->background[5][j],&vga[k+11],11);
              }
              break;
      case 6: for(y = 0; y < 11; y++) {
                 k=((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 j = y * 11;
                 _fmemcpy(&sprite->background[1][j],&vga[((y + sprite->y)<<8)+((y+sprite->y)<<6)+sprite->x+11],11);
                 _fmemcpy(&sprite->background[2][j],&vga[k],11);
                 _fmemcpy(&sprite->background[3][j],&vga[k+11],11);
              }
              break;
   }
}

void erase_sprite(sprite_ptr sprite)
{
   unsigned int y, i, x, k, l;
   for(y = 0; y < 11; y++) {
      i = y * 11;
      x = ( ((y+sprite->y) << 8) + ((y+sprite->y)<<6)) + sprite->x;
      switch(sprite->type) {
         case 0: _fmemcpy(&vga[x], &sprite->background[0][i], 11);
                 _fmemcpy(&vga[x-11],&sprite->background[1][i],11);
                 _fmemcpy(&vga[x+11],&sprite->background[2][i],11);
                 _fmemcpy(&vga[((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x],&sprite->background[3][i],11);
                 _fmemcpy(&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],&sprite->background[4][i],11);
                 break;
         case 1: _fmemcpy(&vga[x],&sprite->background[0][i],11);
                 _fmemcpy(&vga[x-11],&sprite->background[1][i],11);
                 _fmemcpy(&vga[x+11],&sprite->background[2][i],11);
                 _fmemcpy(&vga[x+22],&sprite->background[3][i],11);
                 _fmemcpy(&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],&sprite->background[4][i],11);
                 _fmemcpy(&vga[((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x],&sprite->background[5][i],11);
                 _fmemcpy(&vga[((y+sprite->y-22)<<8)+((y+sprite->y-22)<<6)+sprite->x],&sprite->background[6][i],11);
                 break;
         case 5:
         case 2: k = ((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x;
                 l = ((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 _fmemcpy(&vga[x],&sprite->background[0][i],11);
                 _fmemcpy(&vga[x-11],&sprite->background[1][i],11);
                 _fmemcpy(&vga[x+11],&sprite->background[2][i],11);
                 _fmemcpy(&vga[k],&sprite->background[3][i],11);
                 _fmemcpy(&vga[k-11],&sprite->background[4][i],11);
                 _fmemcpy(&vga[k+11],&sprite->background[5][i],11);
                 _fmemcpy(&vga[l],&sprite->background[6][i],11);
                 _fmemcpy(&vga[l-11],&sprite->background[7][i],11);
                 _fmemcpy(&vga[l+11],&sprite->background[8][i],11);
                 break;
         case 3: k = ((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 _fmemcpy(&vga[x],&sprite->background[0][i],11);
                 _fmemcpy(&vga[x+11],&sprite->background[1][i],11);
                 _fmemcpy(&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],&sprite->background[2][i],11);
                 _fmemcpy(&vga[k],&sprite->background[3][i],11);
                 _fmemcpy(&vga[k-11],&sprite->background[4][i],11);
                 _fmemcpy(&vga[k+11],&sprite->background[5][i],11);
                 break;
         case 4: k = ((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 _fmemcpy(&vga[x],&sprite->background[0][i],11);
                 _fmemcpy(&vga[x-11],&sprite->background[1][i],11);
                 _fmemcpy(&vga[((y+sprite->y+11)<<8)+((y+sprite->y+11)<<6)+sprite->x],&sprite->background[2][i],11);
                 _fmemcpy(&vga[k],&sprite->background[3][i],11);
                 _fmemcpy(&vga[k-11],&sprite->background[4][i],11);
                 _fmemcpy(&vga[k+11],&sprite->background[5][i],11);
                 break;
         case 6: k = ((y+sprite->y-11)<<8)+((y+sprite->y-11)<<6)+sprite->x;
                 _fmemcpy(&vga[x],&sprite->background[0][i],11);
                 _fmemcpy(&vga[x+11],&sprite->background[1][i],11);
                 _fmemcpy(&vga[k],&sprite->background[2][i],11);
                 _fmemcpy(&vga[k+11],&sprite->background[3][i],11);
                 break;
      }

   }
}

void retrace()
{
   while(inp(VGA_INPUT_STATUS_1) & VGA_VSYNC_MASK) { /* Nothing */   }
   while(!(inp(VGA_INPUT_STATUS_1) & VGA_VSYNC_MASK)) { /* Nothing */  }
/*
  _DX = 0x03DA;
  l1: asm {
  in  al,dx;
  and al,0x08;
  jnz l1;
  }
  l2: asm {
  in  al,dx;
  and al,0x08;
  jz  l2;
  }
 */
}

void do_bound(sprite_ptr sprite)
{
   switch(sprite->type) {
      case 0: switch(sprite->pos) {
                 case 0: sprite->yhigh = sprite->y;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x-11;
                         break;
                 case 3: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x;
                         sprite->xlow = sprite->x-11;
                         break;
                 case 1: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x;
                         break;
                 case 2: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x-11;
                         break;
              }
              break;
      case 1: switch(sprite->pos) {
                 case 0: sprite->yhigh = sprite->y;
                         sprite->xhigh = sprite->x+22;
                         sprite->xlow = sprite->x-11;
                         break;
                 case 1: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x;
                         sprite->xlow = sprite->x;
                         break;
              }
              break;
      case 5:
      case 2: switch(sprite->pos) {
                 case 0: sprite->yhigh = sprite->y;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x-11;
                         break;
                 case 1: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x;
                         break;
                 case 2: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x-11;
                         break;
                 case 3: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x;
                         sprite->xlow = sprite->x-11;
                         break;
              }
              break;
      case 3: switch(sprite->pos) {
                 case 0: sprite->yhigh = sprite->y;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x-11;
                         break;
                 case 1: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x;
                         break;
              }
              break;
      case 4: switch(sprite->pos) {
                 case 0: sprite->yhigh = sprite->y;
                         sprite->xhigh = sprite->x+11;
                         sprite->xlow = sprite->x-11;
                         break;
                 case 1: sprite->yhigh = sprite->y+11;
                         sprite->xhigh = sprite->x;
                         sprite->xlow = sprite->x-11;
                         break;
              }
              break;
      case 6: sprite->yhigh = sprite->y;
              sprite->xhigh = sprite->x+11;
              sprite->xlow = sprite->x;
              break;
   }
}

void draw_sprite(sprite_ptr sprite)
{
   int x, j, i;
   for(i = 0; i < 11; i++)
      _fmemcpy(&vga[((i+sprite->y)<<8)+((i+sprite->y)<<6)+sprite->x], &sprite->frame[i*11], 11);
   switch(sprite->type) {
      case 0: switch(sprite->pos) {
                 case 0: for(x = 0; x < 11; x++) {
                            j = ((x + sprite->y) << 8) + ((x + sprite->y) << 6) + sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[j - 11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j + 11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x],&sprite->frame[i],11);
                        } break;
                 case 3: for(x = 0; x < 11; x++) {
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y)<<8) + ((x+sprite->y)<<6) + sprite->x - 11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x],&sprite->frame[i],11);
                         }
                         break;
                 case 1: for(x = 0; x < 11; x++) {
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                         }
                         break;
                 case 2: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                         }
                         break;
              }
              break;
      case 1: switch(sprite->pos) {
                 case 0: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x;
                            i = x*11;
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+22],&sprite->frame[i],11);
                         }
                         break;
                 case 1: for(x = 0; x < 11; x++) {
                            i = x*11;
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-22)<<8)+((x+sprite->y-22)<<6)+sprite->x],&sprite->frame[i],11);
                         }
                         break;
              }
              break;
      case 2: switch(sprite->pos) {
                 case 0: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x-11],&sprite->frame[i],11);
                         }
                         break;
                 case 1: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[j],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                         }
                         break;
                 case 2: for(x = 0; x < 11; x++) {
                            j=((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x+11],&sprite->frame[i],11);
                         }
                         break;
                 case 3: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[j],&sprite->frame[i],11);
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                         }
                         break;

              }
              break;
      case 3: switch(sprite->pos) {
                 case 0: for(x = 0; x < 11; x++) {
                            i=x*11;
                            j=((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x;
                            _fmemcpy(&vga[((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j],&sprite->frame[i],11);
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                         }
                         break;
                 case 1: for(x = 0; x < 11; x++) {
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                         }
                         break;
              }
              break;
      case 4: switch(sprite->pos) {
                 case 0: for(x = 0; x < 11; x++) {
                            i = x * 11;
                            j=((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x;
                            _fmemcpy(&vga[((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                          }
                          break;
                 case 1: for(x = 0; x < 11; x++) {
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                         }
                         break;
              }
              break;
      case 5: switch(sprite->pos) {
                 case 0: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x+11],&sprite->frame[i],11);
                         }
                         break;
                 case 1: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[j],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                         }
                         break;
                 case 2: for(x = 0; x < 11; x++) {
                            j=((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                            _fmemcpy(&vga[j+11],&sprite->frame[i],11);
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x-11],&sprite->frame[i],11);
                         }
                         break;
                 case 3: for(x = 0; x < 11; x++) {
                            j = ((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x;
                            i = x * 11;
                            _fmemcpy(&vga[((x+sprite->y+11)<<8)+((x+sprite->y+11)<<6)+sprite->x],&sprite->frame[i],11);
                            _fmemcpy(&vga[j],&sprite->frame[i],11);
                            _fmemcpy(&vga[j-11],&sprite->frame[i],11);
                         }
                         break;
              }
              break;
      case 6: for(x = 0; x < 11; x++) {
                 i = x * 11;
                 j = ((x+sprite->y-11)<<8)+((x+sprite->y-11)<<6)+sprite->x;
                 _fmemcpy(&vga[((x+sprite->y)<<8)+((x+sprite->y)<<6)+sprite->x+11],&sprite->frame[i],11);
                 _fmemcpy(&vga[j],&sprite->frame[i],11);
                 _fmemcpy(&vga[j+11],&sprite->frame[i],11);
              }
              break;
   }
}

void quit_program(char *format, ...)
{
   va_list arglist;
   char buffer[2000];
   va_start(arglist, format);
   vsprintf(buffer, format, arglist);
   va_end(arglist);
   _dos_setvect(TIMER_KEEPER_INT, old_isr);
   setmode(0x03);
   printf("%s\n", buffer);
   printf("MinTris Version 0.01 (c) 1996 By Min S. Kwon\n");
   printf("Email: times9@clark.net\n");
   printf("Background images by: Highland Graphics\n");
   printf("Highland Graphics: http://www.itsnet.com/home/highland/highland.html\n");
   exit(0);
}

void sprite_init(sprite_ptr sprite, int x, int y, int type)
{
   unsigned int index;
   sprite->x = x;
   sprite->y = y;
   sprite->type = type;
   sprite->pos = 0;
   for(index = 0; index < 10; index++) {
      sprite->background[index] = (char far *) _fmalloc(125);
      if(sprite->background[index] == NULL) quit_program("Insufficient memory");
   }
}

void pcx_delete(pcx_picture_ptr image)
{
   _ffree(image->buffer);
}

void pcx_show_buffer(pcx_picture_ptr image)
{
   _fmemcpy((char far *)vga, (char far *)image->buffer, 64000);
}

void pcx_init(pcx_picture_ptr image)
{
   if((image->buffer = (char far *) _fmalloc(64000)) == NULL) {
      setmode(0x03);
      puts("Insufficient memory.");
      _ffree(&image);
      exit(0);
   }
}

void setmode(int mode)
{
   union REGS r;
   r.h.al = mode;
   r.h.ah = 0;
   int86(0x10, &r, &r);
}

void pcx_load(char *fname, pcx_picture_ptr image, short int enable)
{
   FILE *fp;
   int num_bytes, index;
   long count;
   unsigned char data;
   char far *temp_buffer;
   fp = fopen(fname, "rb");
   temp_buffer = (char far *) image;
   for(index = 0; index < 128; index++) {
      temp_buffer[index] = getc(fp);
   }
   count = 0;
   while(count <= 64000) {
      data = getc(fp);
      if(data >= 192 && data <= 255) {
         num_bytes = data - 192;
         data = getc(fp);
         while(num_bytes-- > 0) {
            image->buffer[count++] = data;
         }
      }
      else {
         image->buffer[count++] = data;
      }
   }
   fseek(fp, -768L, SEEK_END);
   for(index = 0; index < 256; index++) {
      image->palette[index].red = (getc(fp) >> 2);
      image->palette[index].green = (getc(fp) >> 2);
      image->palette[index].blue = (getc(fp) >> 2);
   }
   fclose(fp);
   if(enable)
      for(index = 0; index < 256; index++)
         set_palette_register(index, (rgb_color_ptr) &image->palette[index]);
}

void set_palette_register(int index, rgb_color_ptr color)
{
   outp(PALETTE_MASK, 0xff);
   outp(PALETTE_REGISTER, index);
   outp(PALETTE_DATA, color->red);
   outp(PALETTE_DATA, color->green);
   outp(PALETTE_DATA, color->blue);
}

