
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <mem.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#include "types.h"
#include "iffsubs.h"

#define MAX_PIXEL_WIDTH         640
#define PAD_COLOR               15

void maybe_force_extension(char *dst, char *src, char *ext)
{
    char *s = strrchr(src, '.');
    if (s == 0)
	sprintf(dst, "%s.%s", src, ext);
    else
	strcpy(dst, src);
}

main(int argc, char *argv[])
{
    char *image, *palette, *mem, c;
	char *dst_mem, *dst_image;
    struct BitMapHeader bmhd;
    int h, w, i, lpad, rpad;

    if (argc != 3)
    {
	printf("use: %s input.lbm output.lbm\n"
	       "This program centers the image horizontally and writes a new one.\n"
			   "The input and output can be the same file for in-place centering.\n"
           ,argv[0]);
	exit(1);
    }

    load_lbm(argv[1], &image, &palette, &bmhd);
	if(bmhd.Width > MAX_PIXEL_WIDTH)
	{
		printf("%s : Too wide to center, max = %d\n", argv[1], MAX_PIXEL_WIDTH);
		exit(1);
	}
	dst_image = malloc(MAX_PIXEL_WIDTH * bmhd.Height);
	assert(dst_image != 0);
	dst_mem = dst_image;
	lpad = (MAX_PIXEL_WIDTH - bmhd.Width) / 2;
	rpad = (MAX_PIXEL_WIDTH - bmhd.Width + 1) / 2;
    mem = image;
	for (h = 0; h != bmhd.Height; h++)
    {
#if 1   // extend edge colors to sides of page.
        memset(dst_mem, mem[0], lpad);
        dst_mem += lpad;

        memcpy(dst_mem, mem, bmhd.Width);
        dst_mem += bmhd.Width;

        memset(dst_mem, mem[bmhd.Width - 1], rpad);
        dst_mem += rpad;

#else   // old way: fill in with PAD_COLOR
		memset(dst_mem, PAD_COLOR, lpad);
		dst_mem += lpad;

		memcpy(dst_mem, mem, bmhd.Width);
		dst_mem += bmhd.Width;

		memset(dst_mem, PAD_COLOR, rpad);
		dst_mem += rpad;
#endif
		mem += bmhd.Width;
	}
    bmhd.Width = MAX_PIXEL_WIDTH;
    save_lbm(argv[2], dst_image, palette, bmhd);
    free(image);
	free(dst_image);
    free(palette);
    return 0;
}
