/*
*   DPaint support routines.  This set of routines contains functions
*   to allow encoding and decoding of DPaint ILBM and PBM data.
*/

/*
<WIP>: the DecodeILBM function is broken, I don't know why.

*/

#include    <sys/types.h>
#include    <sys/stat.h>
#include	<stdlib.h>
#include    <stdio.h>
#include    <io.h>
#include    <fcntl.h>
#include	<string.h>
#include	<assert.h>
#include	<stdarg.h>

#include    "types.h"
#include    "iffsubs.h"

#define	FLIP(a)	flip_bytes((void *)&a, sizeof(a))

/*
	Simplified loader for IFF files.
*/
int load_lbm(char *name, char **dst, char **palette, struct BitMapHeader * bmhd)
{
    FILE *fin;
    int bm_type, i;
    unsigned num_bytes;
    char *tmp_p;

    if ((fin = fopen(name, "rb")) == NULL)
    {
        perror(name);
        exit(5);
    }

	tmp_p = malloc(256 * 3);
    assert(tmp_p != NULL);
    *palette = tmp_p;
    if ((bm_type = GetFormType(fin)) >= 0 &&
        GetBMHD(bmhd, fin) == 0 &&
        GetColorMap(fin, *palette, 256) == 0 &&
        PointToBody(fin) == 0
        )
    {
        num_bytes = bmhd->Width * bmhd->Height;
        tmp_p = malloc(num_bytes);
        assert(tmp_p != NULL);
        *dst = tmp_p;
        memset(tmp_p, 0, num_bytes);
        if(Decode(bm_type, bmhd, tmp_p, bmhd->Height, fin) != 0)
		{
			fprintf(stderr, "Error decoding LBM.\n");
			exit(1);
		}
        fclose(fin);
        return (0);
    }
	fprintf(stderr, "Invalid : Form, Palette, or Body.\n");
    exit(1);
    return -1;
}

/*
	Simplified way to save an image.
*/
int save_lbm(char *name, char *image, char *palette, struct BitMapHeader bmhd)
{
    int fout;

    if ((fout = open(name, O_CREAT | O_TRUNC | O_BINARY | O_RDWR,
                     S_IREAD | S_IWRITE
                     )) == -1)
    {
		perror(name);
        exit(5);
    }
    PBMEncode(image, palette, bmhd, fout);
	close(fout);
    return 0;
}

/*
*   Reads the BitMapHeader from a dpaint file.  This routine must be called
*   prior to using PointToBody.
*
*   Returns:    0 for no error, non-zero for an error.
*/
int GetBMHD( struct BitMapHeader *bmhd, FILE *fp )
{
    ubyte4 size;

    if( FindType( "BMHD", fp ) == 0 )
    {
        fread( &size, 4, 1, fp );           /* verify size of BMHD. */
		FLIP( size );
		assert(size == sizeof( struct BitMapHeader ) );

        if( fread( bmhd, sizeof( struct BitMapHeader ), 1, fp ) == 1 )
        {
			FLIP( bmhd->Width );
			FLIP( bmhd->Height );
			FLIP( bmhd->X );
			FLIP( bmhd->Y );
			FLIP( bmhd->TransparentColor );
			FLIP( bmhd->PageWidth );
			FLIP( bmhd->PageHeight );
            return( 0 );
        }

        return( -2 );
    }

    return( -3 );
}

/*
*   Points to the bytes after the BODY and size in a dpaint file.  This routine
*   must be called prior to using DecodeILBM or DecodePBM.
*
*   Returns:    0 for no error, non-zero for an error.
*/
int PointToBody( FILE *fp )
{
    ubyte4 size;

    if( FindType( "BODY", fp ) == 0 )
    {
        fread( &size, 4, 1, fp );               /* discard the size. */
        return( 0 );
    }

    return( -1 );
}

int Decode(int type, struct BitMapHeader *bmhd, ubyte1 *dst, int lines, FILE *fp)
{
	if(type == TypePBM) return DecodePBM(bmhd, dst, lines, fp);
	else if(type == TypeILBM) return DecodeILBM(bmhd, dst, lines, fp);
	else return -1;
}

int DecodeILBM( struct BitMapHeader *bmhd, ubyte1 *dst, int lines, FILE *fp )
{
	ubyte2 i, j, plane;
	ubyte1 *scan, *dst_scan, *t, *s;
	ubyte2 width = bmhd->Width, widthInBytes = (width + 7) / 8;

	if(bmhd->Planes != 8)
	{
		return(-3);
	}

	if((scan = (ubyte1 *)malloc(widthInBytes * bmhd->Planes)) == NULL)
	{
		return(-2);
	}

	if((dst_scan = (ubyte1 *)malloc(widthInBytes * 8)) == NULL)
		return -2;

	while(lines--)
	{
		for(t = scan, plane = 0; plane != bmhd->Planes; ++plane, t += widthInBytes)
		{
			if( bmhd->Compress == 1 )
			{
				DPRLDecode( (sbyte1 (*)(void *)) fgetc, fp, t, widthInBytes );
			}
			else
			{
				for(s = t, i = widthInBytes; i--; )
				{
					*s++ = fgetc( fp );
				}
			}
		}

		for(i = 0, t = scan, s = dst_scan; i < width; i += 8, ++t, s += 8)
		{
			for(j = 0; j != 8; ++j)
			{
				ubyte1 mask = 0x80 >> j;

				s[j] =
				(((t[widthInBytes * 0] & mask) != 0) << 0) |
				(((t[widthInBytes * 1] & mask) != 0) << 1) |
				(((t[widthInBytes * 2] & mask) != 0) << 2) |
				(((t[widthInBytes * 3] & mask) != 0) << 3) |
				(((t[widthInBytes * 4] & mask) != 0) << 4) |
				(((t[widthInBytes * 5] & mask) != 0) << 5) |
				(((t[widthInBytes * 6] & mask) != 0) << 6) |
				(((t[widthInBytes * 7] & mask) != 0) << 7);
			}
		}
		memcpy(dst, dst_scan, width);
		dst += width;
	}
	free(dst_scan);
	free(scan);
	return ( ferror( fp ) );
}

int DecodePBM( struct BitMapHeader *bmhd, ubyte1 *dst, int lines, FILE *fp )
{
	ubyte2 count, i;
    ubyte1 *scan, *t;

    if((scan = (ubyte1 *)malloc(bmhd->Width + 2)) == NULL)
    {
		return(-2);
    }

    if( bmhd->Planes == 8 )     /* verify that this routine supports this PBM. */
    {
        count = (bmhd->Width + 1) & 0xfffe;
        while(lines--)
        {
            if( bmhd->Compress == 1 )
            {
				DPRLDecode( (sbyte1 (*)(void *)) fgetc, fp, scan, count );
            }
			else
            {
                for(t = scan, i = count; i--; )
                {
                    *t++ = fgetc( fp );
                }
            }
            memcpy(dst, scan, bmhd->Width);
            dst += bmhd->Width;
        }
        free(scan);
        return ( ferror( fp ) );
    }

    free(scan);
    return( -1 );
}

/*
*   Reads the color palette from a dpaint file.
*
*   Returns:    0 for no error, non-zero for an error.
*/
int GetColorMap( FILE *fp, ubyte1 *dst, int max_colors )
{
    ubyte4 size;

    if( FindType( "CMAP", fp ) == 0 )
    {
        fread( &size, 4, 1, fp );
		FLIP( size );

        max_colors = ( max_colors * 3 > size ) ? size / 3 : max_colors;

        if( fread( dst, 3, max_colors, fp ) == max_colors )
		{
            return( 0 );
        }
        else
        {
            return( -1 );
        }
    }

    return( -2 );
}

int GetFormType( FILE *fp )
{
    char id[4];

    fseek( fp, 0l, SEEK_SET );              /* verify "FORM". */
    fread( id, 4, 1, fp);
    if( strncmp( id, "FORM", 4 ) == 0 )
    {
        fread( id, 4, 1, fp);
        if( fread( id, 4, 1, fp) == 1 )
        {
            if( !strncmp( id, "PBM ", 4) )  return( TypePBM );
			if( !strncmp( id, "ILBM", 4) )  return( TypeILBM );
            return( -1 );
        }

        return( -2 );
    }

    return( -3);
}

/*
*   FindType searches through a file looking for an item that matches type.
*   If it finds type then the file pointer points to the 4 bytes immediately
*   following.
*
*   returns: 0 for no error, non-zero for an error.
*/
int FindType( char *type, FILE *fp )
{
    char  id[4];
    ubyte4 form_size, seek, size;

    fseek( fp, 0l, SEEK_SET );              /* verify "FORM". */
    fread( id, 4, 1, fp);
	if( strncmp( id, "FORM", 4 ) == 0 )
    {
        fread( &form_size, 4, 1, fp );      /* get form's size. */
		FLIP( form_size );

        seek = 12;                          /* point to first data item. */
        do
        {
            fseek( fp, seek, SEEK_SET );    /* read type of item. */
            fread( id, 4, 1, fp );
            if( strncmp (id, type, 4 ) == 0 )   /* does it match the desired one. */
            {
				return( 0 );
            }
            else
            {
                fread( &size, 4, 1, fp );       /* advance to next item. */
				FLIP( size );
                size = ( size + 1 ) & -2L;
                seek += size + 8l;              /* +8 for type and size. */
            }
        }   while( seek < form_size + 12 );

        return( -1 );
	}

    return( -2 );
}


void DPRLDecode( sbyte1 (*src)( void * ), void *src_arg, ubyte1 *dst, ubyte2 count )
{
	register sbyte1 c, d;

    while( count != 0 )
    {
		if( ( c = (*src)( src_arg ) ) >= 0)     /* copy c + 1 bytes. */
        {
            for(c++; c; --c, --count)
            {
                *dst++ = (*src)( src_arg );
            }
        }
        else if( c != -128 )                /* run of 1 - c bytes. */
        {
            d = (*src)( src_arg );
            for( c = 1 - c; c; --c, --count)
                *dst++ = d;
		}
    }
}

#if	1
ubyte2 DPRLEncode(char *dst, char *src, ubyte2 count, ubyte2 buf_size)
{
	char *dst_save;
	sbyte2 compress_count, i;
	ubyte2 start_size;
	ubyte1 run_buf[128 + 2], *rp;

	dst_save = dst;
	while(count)    {
		compress_count = count > 128 ? 128 : count;
		rp = run_buf;
		memcpy(rp, src, compress_count);
		memset(rp + compress_count, 0, 2);		// add on some 0's.

		if(rp[0] == rp[1])	// see if consecutive run.
		{
			for(i = 0; i != compress_count && rp[0] == rp[1]; ++rp, ++i)
				;
			if(i != compress_count)
				++i;
            *dst++ = 1 - i;
			*dst++ = *rp;
		}
		else	// non run data.
		{
			for(i = 0; i != compress_count &&
					   (rp[0] != rp[1] || rp[1] != rp[2]); ++i, ++rp)
				;
			*dst++ = i - 1;
			memmove(dst, src, i);
			dst += i;
		}
		src += i;
		count -= i;
    }
    return(dst - dst_save);
}
#else
ubyte2 DPRLEncode(char *dst, char *src, ubyte2 count, ubyte2 buf_size)
{
	char *s, *t;
	sbyte2 compress_count, i;
	ubyte2 start_size;

	start_size = buf_size;
	while(count)    {
		compress_count = count > 128 ? 128 : count;
		if(compress_count == 1 || src[0] != src[1])     {
			for(s = src, i = 1; i != compress_count && s[0] != s[1]; ++s, ++i)
				;
			if(i != compress_count) {
				--i;
			}

			if(buf_size >= i + 1)   {
				buf_size -= i + 1;
				*dst++ = i - 1;
				memmove(dst, src, i);
				src += i;
				dst += i;
			}
			else    {
				printf("compress buffer overflow.\n");
				exit(5);
			}
		}
		else    {
			for(i = 1; i != compress_count && src[0] == src[1]; ++src, ++i)
				;

            if(buf_size >= 2)   {
                buf_size -= 2;
                *dst++ = 1 - i;
                *dst++ = *src++;
            }
            else    {
                printf("compress buffer overflow.\n");
                exit(5);
            }
        }
		count -= i;
    }
    return(start_size - buf_size);
}
#endif

void flip_bytes(void *v, int count)
{
	ubyte1 *u, t;
	int i;

	u = (ubyte1 *)v;
	for(i = 0; i != (count >> 1); ++i)
	{
		t = u[i];
		u[i] = u[count - i - 1];
		u[count - i - 1] = t;
	}
}

int PBMEncode(char *src, char *color_map, struct BitMapHeader bmhd, int outFile)
{
	ubyte1 *scan_buf, *comp_buf;
	int i, j, k, n, p, odden;
	long size, body_offset;

	odden = bmhd.Width & 1;		// is data odd width?

/*
*   write out a bitmap header.
*/
	write(outFile, "FORM1234PBM BMHD", 16);
    write_longs(outFile, 1, (long)sizeof(struct BitMapHeader));
	write_words(outFile, 4, bmhd.Width, bmhd.Height, 0, 0);
    write_bytes(outFile, 4, 8, 0, 1, 0);
	write_words(outFile, 4, 0, 0x101, bmhd.Width, bmhd.Height);    /* 0x101 is aspect ratio 1:1 */

/*
*	write optional color map.
*/
	if(color_map)
	{
		write(outFile, "CMAP\0\0\3\0", 8);
		write(outFile, color_map, 0x300);
	}

/*
*   compress each scan line and write it out.
*/
	scan_buf = malloc(bmhd.Width + odden + 1);
	comp_buf = malloc(bmhd.Width * 2);
	assert(scan_buf != NULL && comp_buf != NULL);
    write(outFile, "BODY1234", 8);
    body_offset = lseek(outFile, 0l, SEEK_CUR);

	for(i = bmhd.Height; i != 0; --i)   {
		memcpy(scan_buf, src, bmhd.Width);
		scan_buf[bmhd.Width] = 0xff;
		src += bmhd.Width;
		n = DPRLEncode(comp_buf, scan_buf, bmhd.Width + odden, 400);
		assert(n < bmhd.Width * 2);
        if(write(outFile, comp_buf, n) != n)    {
			printf("error writing : \n");
			exit(1);
            return(-1);
        }
    }
	size = lseek(outFile, 0l, SEEK_CUR);    /* word align picture. */
    if(size & 1)    {
        write_bytes(outFile, 1, 0);
    }

/*
*   go back and fill in uninitialized sizes.
*/
    lseek(outFile, 4l, SEEK_SET);
    write_longs(outFile, 1, (size + 1 & 0xFFFFFFFE) - 8);
    lseek(outFile, body_offset - 4, SEEK_SET);
    write_longs(outFile, 1, size - body_offset);
	free(scan_buf);
	free(comp_buf);
    return(0);
}

write_longs(int f, int cnt, ...)
{
	va_list ap;
    int res;

	va_start(ap, cnt);
	for(; cnt--; )
	{
		long l;

		l = va_arg(ap, long);
		FLIP( l);
		res = write(f, &l, 4) != 4;
	}
	va_end(ap);
	return(res);
}

write_words(int f, int cnt, ...)
{
	va_list ap;
	int res;

	va_start(ap, cnt);
	for(; cnt--; )
	{
		ubyte2 l;

		l = va_arg(ap, ubyte2);
		FLIP( l);
		res = write(f, &l, 2) != 2;
	}
	va_end(ap);
	return(res);
}

write_bytes(int f, int cnt, ...)
{
	va_list ap;
	int res;

	va_start(ap, cnt);
	for(; cnt--; )
	{
		ubyte1 l;

		l = va_arg(ap, ubyte1);
		res = write(f, &l, 1) != 1;
	}
	va_end(ap);
	return(res);
}

