#ifndef	_IFFSUBS_H
#define _IFFSUBS_H

#ifndef	_TYPES_H
#include "types.h"
#endif

#define TypePBM     0
#define TypeILBM    1

struct BitMapHeader {
    ubyte2 Width, Height;            /* size in pixels. */
    sbyte2  X, Y;                     /* unknown, possibly hot spot for a brush. */
    ubyte1 Planes;                   /* number of planes or bits per pixel. */
    ubyte1 Masking;                  /* mask plane present. */
    ubyte1 Compress;                 /* 0 for no compression, 1 for RLE. */
    ubyte1 pad;
    ubyte2 TransparentColor;         /* unknown. */
    ubyte1 XAspect, YAspect;         /* aspect ratio. */
    sbyte2  PageWidth, PageHeight;    /* unknown. */
};

int load_lbm(char *name, char **dst, char **palette, struct BitMapHeader * bmhd);
int save_lbm(char *name, char *image, char *palette, struct BitMapHeader bmhd);

int GetBMHD( struct BitMapHeader *bmhd, FILE *fp );
int PointToBody( FILE *fp );
int Decode(int type, struct BitMapHeader *bmhd, ubyte1 *dst, int lines, FILE *fp);
int DecodeILBM( struct BitMapHeader *bmhd, ubyte1 *dst, int lines, FILE *fp );
int DecodePBM( struct BitMapHeader *bmhd, ubyte1 *dst, int lines, FILE *fp );
int GetColorMap( FILE *fp, ubyte1 *dst, int max_colors );
int GetFormType( FILE *fp );
int FindType( char *type, FILE *fp );
void DPRLDecode( sbyte1 (*src)( void * ), void *src_arg, ubyte1 *dst, ubyte2 count );
ubyte2 DPRLEncode(char *dst, char *src, ubyte2 count, ubyte2 buf_size);
int PBMEncode(char *src, char *color_map, struct BitMapHeader bmhd, int file);
void flip_bytes(void *v, int count);
write_bytes(int f, int cnt, ...);
write_words(int f, int cnt, ...);
write_longs(int f, int cnt, ...);

#endif


