'===========================================================================
' Subject: PICK A NUMBER                      Date: 04-11-96 (00:00)       
'  Author: Steven Hanov                       Code: QB, QBasic, PDS        
'  Origin: hanov@wchat.on.ca                Packet: GAMES.ABC
'===========================================================================
'****************************************************************************
'*                          IDENTIFICATION                                  *
'*                                                                          *
'*                NAME:       Steven Hanov                                  *
'*                PROGRAM:    a:\picknum.bas                                *            *
'*                SCHOOL:     Cardinal Newman C. S. S.                      *
'*                TEACHER:    Miss Gotovac                                  *
'*                COMPUTER:   IBM/MS-DOS                                    *
'*                LANGUAGE:   QBASIC                                        *
'*                PLANET:     Earth (Sol-III)                               *
'*                PERIOD:     LATE 20th CENTURY (Gregorian Calender)        *
'*                CLASS:      DPT 3A1 Period 2                              *
'*                DATE:       April 11, 1996                                *
'*                                                                          *
'****************************************************************************

'****************************************************************************
'*                       PROGRAM ANALYSIS                                   *
'*                                                                          *
'* This program will allow a user to entertain him or herself in a mindless *
'* and simple guessing game involving the extropolation of an unknown       *
'* numeric variable between 1 and 20 using no data other than that of an    *
'* approximate "high or lower" after each attempt.                          *
'****************************************************************************
DECLARE SUB PalDef (c!, r!, g!, b!)

'****************************************************************************
'*                       VARIABLE DICTIONARY                                *
'****************************************************************************

'A$ - a temperary variable used in various operations.
'num - the random number the computer has picked.
'y - used in for/next loops to fill background colour
'c- used in fill-background loop to determine gradient fill colour
'n - the number the user has picked.
'guess - the number of guesses the user takes

'****************************************************************************
'*                              MAIN                                        *
'****************************************************************************

SCREEN 13              '320x200, 1 page, 256 colours
RANDOMIZE TIMER
CLS
num = INT(RND * 20) + 1        'picks random number
FOR y = 1 TO 200
   c = INT((y / 200) * 50)       'Picks gradient value, from 1 to 50
   LINE (0, y)-(320, y), c      'Draws a horizontal line of colour c
   CALL PalDef(c, c, 0, 0)      'Redefines palette do make gradient fill
NEXT
CALL PalDef(0, 63, 0, 0)        'Makes default background colour RED
CALL PalDef(51, 63, 50, 0)      'Makes colour #51 yellow
DO
   LINE (20, 20)-(200, 160), 0, BF   'Draws red box
   LOCATE 4, 4
   PRINT "Guess which number"
   LOCATE 5, 4: PRINT "the computer has"
   LOCATE 6, 4: PRINT "picked. The arrow on "
   LOCATE 7, 4: PRINT "the side will tell"
   LOCATE 8, 4: PRINT "you whether to guess"
   LOCATE 9, 4: PRINT "higher or lower."
      DO
         LOCATE 12, 4: INPUT "> ", a$: n = VAL(a$)   'Screens out letters
         IF n > 20 OR n < 1 THEN
            LOCATE 14, 4: PRINT "The number must be"
            LOCATE 15, 4: PRINT "between 1 and 20."
         END IF
      LOOP UNTIL n <= 20 AND n >= 1     'Loops until number is acceptable
   LINE (230, 20)-(280, 170), 51, BF    'Yellow box cleared
   LINE (250, 40)-(260, 140), 1, BF     'draws base of arrow
   LOCATE 21, 31: PRINT n               'print guessed number in yellow box
   IF n > num THEN
      LINE (240, 140)-(270, 140), 1
      LINE -(255, 150), 1              'Draws down arrow
      LINE -(240, 140), 1
      PAINT (242, 141), 1
   ELSEIF n < num THEN
      LINE (240, 40)-(270, 40), 1
      LINE -(255, 30), 1             'Draws up arrow
      LINE -(240, 40), 1
      PAINT (242, 39), 1
   END IF
   guess = guess + 1               'increment guesses
LOOP UNTIL n = num
LINE (230, 20)-(280, 160), 51, BF       'Clears yellow box
FOR y = 1 TO 200
   c = INT((y / 200) * 50)         'Redraws gradient fill background,
   LINE (0, y)-(320, y), c         'but in yellow colour motif
   CALL PalDef(c, c, c, 0)
NEXT
CALL PalDef(0, 63, 63, 0)          'Redefines background colour to be yellow
LINE (50, 50)-(270, 150), 0, BF
s$ = "y"
IF guess > 1 THEN s$ = "ies"      'Makes "try" grammatorically correct
LOCATE 9, 8: PRINT "You correctly guessed that"
LOCATE 10, 8: PRINT "the number was"; num
LOCATE 12, 8: PRINT "It took you"; guess; "tr"; s$; "."

WHILE INKEY$ = "": WEND
END
'****************************************************************************
'*                           SUBROUTINES                                    *
'****************************************************************************
'PalDef(c,r,g,b) redefines colour #c to have the red, green and blue values
'                 R,G, and B respectively             

SUB PalDef (c, r, g, b)
   OUT &H3C8, c
   OUT &H3C9, r
   OUT &H3C9, g
   OUT &H3C9, b
END SUB
