DECLARE SUB shuffle (block() AS ANY, array() AS INTEGER, tim&)
DECLARE SUB shuffleTalk ()
DECLARE SUB winner (block() AS ANY, array() AS INTEGER, x%, y%)
DECLARE FUNCTION checkWin% (block() AS ANY)
DECLARE SUB ind ()
DECLARE SUB pause ()
DECLARE SUB logo ()
DECLARE SUB moveTile (index%, array() AS INTEGER, block() AS ANY, direction$)
DECLARE SUB fillArray (array() AS INTEGER, filNm() AS STRING, count%)
DECLARE FUNCTION miceReset% ()
DECLARE SUB interrupt (intnum%)
DECLARE SUB micePressed (buttonPress%, numTimes%, xMouse%, yMouse%)
DECLARE SUB fillblock (block() AS ANY, x%, y%)
DECLARE SUB drawScreen (block() AS ANY, array() AS INTEGER)
DECLARE SUB miceShow ()
DECLARE SUB drawLines (x%, y%)
DECLARE FUNCTION getClick% (xMouse%, yMouse%, x%, y%)
DECLARE SUB miceHide ()
DECLARE SUB fillFilNm (filNm() AS STRING)
DECLARE SUB adjustBlock (block() AS ANY, index%, direction$)

TYPE regtype
    ax AS INTEGER
    bX AS INTEGER
    cx AS INTEGER
    dx AS INTEGER
    bp AS INTEGER
    si AS INTEGER
    di AS INTEGER
    flags AS INTEGER
    ds AS INTEGER
    es AS INTEGER
END TYPE

DIM SHARED regs AS regtype
REDIM SHARED intrpt(1 TO 50) AS INTEGER

DEF SEG = VARSEG(intrpt(1))
address = VARPTR(intrpt(1))

FOR I% = 0 TO 99
    READ a%
    POKE address + I%, a%
NEXT I%

TYPE frame
  col AS INTEGER
  row AS INTEGER
  occupant AS INTEGER
  up AS INTEGER
  down AS INTEGER
  left AS INTEGER
  right AS INTEGER
  pad AS STRING * 2
END TYPE

DIM block(1 TO 25) AS frame

DIM filNm(1 TO 25) AS STRING

DIM array(1 TO 25 * 1033) AS INTEGER

x% = ((640 - (5 * 64)) / 2) - 2
y% = ((480 - (5 * 64)) / 2) - 2

CALL fillblock(block(), x%, y%)

CALL fillFilNm(filNm())

SCREEN 12

IF miceReset% = 0 THEN
    BEEP
    PRINT "A MicroSoft compatible mouse required for this program."
    END
END IF

CALL logo

FOR count% = 1 TO 25
  CALL fillArray(array(), filNm(), count%)
NEXT count%

CALL pause

CALL drawScreen(block(), array())

CALL drawLines(x%, y%)

CALL miceShow

CALL shuffleTalk

RANDOMIZE TIMER

CALL shuffle(block(), array(), tim&)

CALL drawLines(x%, y%)

DO
  IF INT(TIMER - tim&) <> tim1& THEN
    tim1& = INT(TIMER - tim&)
    LOCATE 2, 75: PRINT "     ";
    LOCATE 2, 75: PRINT tim1&;
    IF tim1& > 9999 THEN CALL ind
  END IF
  in$ = INKEY$
  SELECT CASE LEN(in$)
    CASE 0
      CALL micePressed(0, numTimes%, xMouse%, yMouse%)
       
        IF numTimes% THEN
         
          index% = getClick(xMouse%, yMouse%, x%, y%)
         
          IF index% THEN
            IF block(index%).up = 25 THEN
              CALL moveTile(index%, array(), block(), "up")
              mv% = 1
            ELSEIF block(index%).down = 25 THEN
              CALL moveTile(index%, array(), block(), "down")
              mv% = 1
            ELSEIF block(index%).left = 25 THEN
              CALL moveTile(index%, array(), block(), "left")
              mv% = 1
            ELSEIF block(index%).right = 25 THEN
              CALL moveTile(index%, array(), block(), "right")
              mv% = 1
            END IF
           
            IF mv% THEN
              mov% = mov% + 1
              LOCATE 3, 75: PRINT "     ";
              LOCATE 3, 75: PRINT mov%;
              mv% = 0
            END IF
          END IF

          CALL drawLines(x%, y%)
         
          IF checkWin%(block()) THEN
            CALL winner(block(), array(), x%, y%)
            tim& = TIMER
            tim1& = 0
            mov% = 0
          END IF
       
        END IF
   
    CASE 1
      IF in$ = CHR$(27) THEN CALL ind
 
  END SELECT

LOOP


DATA 85
DATA 139,236
DATA 86
DATA 87
DATA 30
DATA 139,118,6
DATA 139,4
DATA 139,92,2
DATA 139,76,4
DATA 139,84,6
DATA 139,108,8
DATA 139,124,12
DATA 142,68,18
DATA 255,116,10
DATA 131,124,18,255
DATA 117,2
DATA 30
DATA 7

DATA 131,124,16,255
DATA 116,3
DATA 142,92,16

DATA 94
DATA 205,33
DATA 85
DATA 139,236
DATA 30
DATA 86
DATA 142,94,2
DATA 139,118,14
DATA 137,4
DATA 137,92,2
DATA 137,76,4
DATA 137,84,6
DATA 143,68,10
DATA 143,68,16
DATA 143,68,8
DATA 137,124,12
DATA 140,68,18
DATA 156
DATA 143,68,14
DATA 95
DATA 95
DATA 94
DATA 93
DATA 202,2,0

SUB adjustBlock (block() AS frame, index%, direction$)

occup% = block(index%).occupant
blank% = 25

SELECT CASE direction$
  CASE "up"
    new% = index% - 5
  CASE "down"
    new% = index% + 5
  CASE "left"
    new% = index% - 1
  CASE "right"
    new% = index% + 1
END SELECT

block(new%).occupant = occup%
block(index%).occupant = blank%

IF index% - 1 MOD 5 <> 0 THEN
  block(index% - 1).right = blank%
END IF

IF index% + 1 MOD 5 <> 1 AND index% + 1 < 26 THEN
  block(index% + 1).left = blank%
END IF

IF index% + 5 < 26 THEN
  block(index% + 5).up = blank%
END IF

IF index% - 5 > 0 THEN
  block(index% - 5).down = blank%
END IF

IF new% - 1 MOD 5 <> 0 THEN
  block(new% - 1).right = occup%
END IF

IF new% + 1 MOD 5 <> 1 AND new% + 1 < 26 THEN
  block(new% + 1).left = occup%
END IF

IF new% + 5 < 26 THEN
  block(new% + 5).up = occup%
END IF

IF new% - 5 > 0 THEN
  block(new% - 5).down = occup%
END IF

END SUB

FUNCTION checkWin% (block() AS frame)

FOR count% = 1 TO 25
  IF block(count%).occupant <> count% THEN
    checkWin% = 0
    EXIT FUNCTION
  END IF
NEXT count%

checkWin% = -1

END FUNCTION

SUB drawLines (x%, y%)

CALL miceHide

FOR count% = y% TO y% + (4 * 64) STEP 64
  FOR cnt% = x% TO x% + (4 * 64) STEP 64
    LINE (cnt%, count%)-(cnt% + 64, count% + 64), 0, B
  NEXT cnt%
NEXT count%

CALL miceShow

END SUB

SUB drawScreen (block() AS frame, array() AS INTEGER)

LINE (0, 0)-(639, 479), 2, BF

FOR count% = 1 TO 25
  PUT (block(count%).col, block(count%).row), array(1 + (count% - 1) * 1033), PSET
NEXT count%

END SUB

SUB fillArray (array() AS INTEGER, filNm() AS STRING, count%)

DEF SEG = VARSEG(array(1 + (count% - 1) * 1033))
offset% = VARPTR(array(1 + (count% - 1) * 1033))
BLOAD filNm(count%), offset%

DEF SEG

END SUB

SUB fillblock (block() AS frame, x%, y%)

FOR count% = 1 TO 5
  FOR cnt% = 1 TO 5
   
    index% = index% + 1
   
    block(index%).occupant = index%
    block(index%).col = x% + 1 + (64 * (cnt% - 1))
    block(index%).row = y% + 1 + (64 * (count% - 1))
   
    IF index% > 5 THEN
      block(index%).up = index% - 5
    ELSE
      block(index%).up = wall
    END IF

    IF index% < 21 THEN
      block(index%).down = index% + 5
    ELSE
      block(index%).down = wall
    END IF

    IF index% MOD 5 <> 1 THEN
      block(index%).left = index% - 1
    ELSE
      block(index%).left = wall
    END IF

    IF index% MOD 5 <> 0 THEN
      block(index%).right = index% + 1
    ELSE
      block(index%).right = wall
    END IF

  NEXT cnt%
NEXT count%

END SUB

SUB fillFilNm (filNm() AS STRING)

OPEN "number.fil" FOR INPUT AS #1
  FOR count% = 1 TO 25
    INPUT #1, filNm(count%)
  NEXT count%
CLOSE #1

END SUB

FUNCTION getClick% (xMouse%, yMouse%, x%, y%)

sz% = 64

SELECT CASE xMouse%
  CASE x% TO x% + (1 * sz%) - 1
    ex% = 1
  CASE x% + (1 * sz%) TO x% + (2 * sz%) - 1
    ex% = 2
  CASE x% + (2 * sz%) TO x% + (3 * sz%) - 1
    ex% = 3
  CASE x% + (3 * sz%) TO x% + (4 * sz%) - 1
    ex% = 4
  CASE x% + (4 * sz%) TO x% + (5 * sz%) - 1
    ex% = 5
END SELECT

SELECT CASE yMouse%
  CASE y% TO y% + (1 * sz%) - 1
    wye% = 10
  CASE y% + (1 * sz%) TO y% + (2 * sz%) - 1
    wye% = 20
  CASE y% + (2 * sz%) TO y% + (3 * sz%) - 1
    wye% = 30
  CASE y% + (3 * sz%) TO y% + (4 * sz%) - 1
    wye% = 40
  CASE y% + (4 * sz%) TO y% + (5 * sz%) - 1
    wye% = 50
END SELECT

SELECT CASE ex% + wye%
  CASE 11
    getClick% = 1
  CASE 12
    getClick% = 2
  CASE 13
    getClick% = 3
  CASE 14
    getClick% = 4
  CASE 15
    getClick% = 5
  CASE 21
    getClick% = 6
  CASE 22
    getClick% = 7
  CASE 23
    getClick% = 8
  CASE 24
    getClick% = 9
  CASE 25
    getClick% = 10
  CASE 31
    getClick% = 11
  CASE 32
    getClick% = 12
  CASE 33
    getClick% = 13
  CASE 34
    getClick% = 14
  CASE 35
    getClick% = 15
  CASE 41
    getClick% = 16
  CASE 42
    getClick% = 17
  CASE 43
    getClick% = 18
  CASE 44
    getClick% = 19
  CASE 45
    getClick% = 20
  CASE 51
    getClick% = 21
  CASE 52
    getClick% = 22
  CASE 53
    getClick% = 23
  CASE 54
    getClick% = 24
  CASE 55
    getClick% = 25
  CASE ELSE
    getClick% = 0
END SELECT

END FUNCTION

SUB ind

SCREEN 0
COLOR 7, 0
WIDTH 80
CLS
SYSTEM

END SUB

SUB interrupt (intnum%)

    DEF SEG = VARSEG(intrpt(1))
    address = VARPTR(intrpt(1))
    POKE address + 51, intnum%

    CALL absolute(regs, address)

END SUB

SUB logo

REDIM bigJim(1 TO 1033) AS INTEGER
REDIM litsoft(1 TO 1033) AS INTEGER

DEF SEG = VARSEG(bigJim(1))
offset% = VARPTR(bigJim(1))
BLOAD "bigjim.jcg", offset%

DEF SEG = VARSEG(litsoft(1))
offset% = VARPTR(litsoft(1))
BLOAD "litsoft.jcg", offset%

x% = (640 - 64) / 2
y1% = (480 - 128) / 2
y2% = y1% + 64

PUT (x%, y1%), bigJim(1), PSET
PUT (x%, y2%), litsoft(1), PSET

END SUB

SUB miceHide
   
regs.ax = 2
regs.bX = 0
regs.cx = 0
regs.dx = 0
  
CALL interrupt(&H33)


END SUB

SUB micePressed (buttonPress%, numTimes%, xMouse%, yMouse%)

    regs.ax = 5
    regs.bX = buttonPress%
    regs.cx = 0
    regs.dx = 0

    CALL interrupt(&H33)
   
    buttonPress% = regs.ax
    numTimes% = regs.bX
    xMouse% = regs.cx
    yMouse% = regs.dx

END SUB

SUB miceRelease (buttonRelease%, numTimes%, xMouse%, yMouse%)

    regs.ax = 6
    regs.bX = buttonRelease%
    regs.cx = 0
    regs.dx = 0

    CALL interrupt(&H33)

    buttonRelease% = regs.ax
    numTimes% = regs.bX
    xMouse% = regs.cx
    yMouse% = regs.dx

END SUB

FUNCTION miceReset%
   
regs.ax = 0
regs.bX = 0
regs.cx = 0
regs.dx = 0
  
CALL interrupt(&H33)

miceReset% = regs.ax

END FUNCTION

SUB miceShow
   
regs.ax = 1
regs.bX = 0
regs.cx = 0
regs.dx = 0
   
CALL interrupt(&H33)

END SUB

SUB moveTile (index%, array() AS INTEGER, block() AS frame, direction$)

CALL miceHide
PUT (block(index%).col, block(index%).row), array(24 * 1033 + 1), PSET
SELECT CASE direction$
  CASE "up"
    PUT (block(index% - 5).col, block(index% - 5).row), array((block(index%).occupant - 1) * 1033 + 1), PSET
  CASE "down"
    PUT (block(index% + 5).col, block(index% + 5).row), array((block(index%).occupant - 1) * 1033 + 1), PSET
  CASE "right"
    PUT (block(index% + 1).col, block(index% + 1).row), array((block(index%).occupant - 1) * 1033 + 1), PSET
  CASE "left"
    PUT (block(index% - 1).col, block(index% - 1).row), array((block(index%).occupant - 1) * 1033 + 1), PSET
END SELECT

CALL adjustBlock(block(), index%, direction$)

CALL miceShow
END SUB

SUB pause

tim& = TIMER

DO
  in$ = INKEY$
  SELECT CASE LEN(in$)
    CASE 0
      CALL micePressed(buttonPress%, numTimes%, xMouse%, yMouse%)
      IF numTimes% THEN EXIT DO
    CASE 1
      EXIT DO
    CASE 2
      EXIT DO
  END SELECT
  IF tim& + 5 < TIMER THEN EXIT DO
LOOP

END SUB

SUB shuffle (block() AS frame, array() AS INTEGER, tim&)

DO
  DO
    cnt% = cnt% + 1
    IF block(cnt%).occupant = 25 THEN
      blank% = cnt%
      EXIT DO
    END IF
  LOOP
 
  SELECT CASE blank%
    CASE 1, 5, 21, 25
      REDIM pick(1) AS STRING
    CASE 2, 3, 4, 6, 11, 16, 10, 15, 20, 22, 23, 24
      REDIM pick(2) AS STRING
    CASE 7, 8, 9, 12, 13, 14, 17, 18, 19
    REDIM pick(3) AS STRING
  END SELECT

  SELECT CASE blank%
    CASE 1
      pick(0) = "right"
      pick(1) = "down"
    CASE 5
      pick(0) = "left"
      pick(1) = "down"
    CASE 21
      pick(0) = "right"
      pick(1) = "up"
    CASE 25
      pick(0) = "left"
      pick(1) = "up"
    CASE 2, 3, 4
      pick(0) = "left"
      pick(1) = "right"
      pick(2) = "down"
    CASE 22, 23, 24
      pick(0) = "left"
      pick(1) = "right"
      pick(2) = "up"
    CASE 6, 11, 16
      pick(0) = "right"
      pick(1) = "up"
      pick(2) = "down"
    CASE 10, 15, 20
      pick(0) = "left"
      pick(1) = "up"
      pick(2) = "down"
    CASE 7, 8, 9, 12, 13, 14, 17, 18, 19
      pick(0) = "left"
      pick(1) = "right"
      pick(2) = "up"
      pick(3) = "down"
  END SELECT
  
  directPick% = RND * UBOUND(pick)
  SELECT CASE pick(directPick%)
    CASE "up"
      index% = blank% - 5
      direction$ = "down"
    CASE "down"
      index% = blank% + 5
        direction$ = "up"
    CASE "left"
      index% = blank% - 1
      direction$ = "right"
    CASE "right"
      index% = blank% + 1
        direction$ = "left"
  END SELECT
 
  IF oldBlank% <> index% THEN
    oldBlank% = blank%
    c% = c% + 1
    IF c% > 120 THEN EXIT DO
    CALL moveTile(index%, array(), block(), direction$)
  END IF
 
  cnt% = 0

LOOP

x1% = 636 * 8
x2% = 639
y1% = 0
y2% = 6 * 8

LINE (x1%, y1%)-(x2%, y2%), 0, BF

LOCATE 2, 67: PRINT "Seconds: "
LOCATE 3, 67: PRINT "  Moves: "

tim& = TIMER

END SUB

SUB shuffleTalk

talk1$ = "Press any key to shuffle tiles and begin"

LOCATE 3, (80 - LEN(talk1$)) / 2: PRINT talk1$

DO
  in$ = INKEY$
  SELECT CASE LEN(in$)
    CASE 0
      CALL micePressed(buttonPress%, numTimes%, xMouse%, yMouse%)
      IF numTimes% THEN EXIT DO
    CASE 1
      EXIT DO
    CASE 2
      EXIT DO
  END SELECT
LOOP

LINE (0, 0)-(639, 48), 2, BF
                    
END SUB

SUB winner (block() AS frame, array() AS INTEGER, x%, y%)

talk1$ = "Press <Esc> to quit, any other key to play again"

LOCATE 3, (80 - LEN(talk1$)) / 2: PRINT talk1$

DO
  in$ = INKEY$
  SELECT CASE LEN(in$)
    CASE 0
      CALL micePressed(buttonPress%, numTimes%, xMouse%, yMouse%)
      IF numTimes% THEN EXIT DO
    CASE 1
      IF in$ = CHR$(27) THEN CALL ind
      EXIT DO
    CASE 2
      EXIT DO
  END SELECT
LOOP

LINE (0, 0)-(639, 48), 2, BF

CALL miceHide

CALL shuffle(block(), array(), tim&)

CALL miceShow

CALL drawLines(x%, y%)

END SUB

