;
;                                                                        
;  AIL.INC                                                               
;                                                                        
;  General purpose macros and equates for AIL development                
;                                                                        
;  Version 1.00 of  1-Nov-92: Initial version                            
;          1.01 of 16-Apr-93: DPMI/INT21 switches added                  
;          2.00 of 12-Apr-94: AIL 3.0 version, derived from 386.MAC      
;                                                                        
;   Author: John Miles                                                   
;                                                                        
;  80386 ASM source compatible with Microsoft Assembler v6.0 or later    
;                                                                        
;
;                                                                        
;  Copyright (C) 1991-1995 Miles Design, Inc.                            
;                                                                        
;  Miles Design, Inc.                                                    
;  8301 Elander Drive                                                    
;  Austin, TX 78750                                                      
;                                                                        
;  (512) 345-2642 / FAX (512) 338-9630 / BBS (512) 454-9990              
;                                                                        
;

                ;
                ;Format modes
                ;

DIG_F_MONO_8             equ 0
DIG_F_MONO_16            equ 1
DIG_F_STEREO_8           equ 2
DIG_F_STEREO_16          equ 3

DIG_PCM_SIGN             equ 0001h
DIG_PCM_ORDER            equ 0002h
DIG_PCM_POLARITY         equ 0004h
DIG_PCM_SPLIT            equ 0008h
DIG_BUFFER_SERVICE       equ 0010h
DIG_DUAL_DMA             equ 0020h
DIG_RECORDING_SUPPORTED  equ 8000h

                ;
                ;Non-specific MIDI/XMIDI controllers
                ;
                         
CHAN_LOCK                equ 110                
CHAN_PROTECT             equ 111
VOICE_PROTECT            equ 112
TIMBRE_PROTECT           equ 113
PATCH_BANK_SEL           equ 114
INDIRECT_C_PFX           equ 115
FOR_LOOP                 equ 116
NEXT_LOOP                equ 117
CLEAR_BEAT_BAR           equ 118
CALLBACK_TRIG            equ 119
SEQ_INDEX                equ 120

MODULATION               equ 1
PART_VOLUME              equ 7
PANPOT                   equ 10
EXPRESSION               equ 11
SUSTAIN                  equ 64
RPN_LSB                  equ 100
RPN_MSB                  equ 101
RESET_ALL_CTRLS          equ 121
ALL_NOTES_OFF            equ 123

                ;
                ;Preference equates
                ;

DIG_SERVICE_RATE         equ 0  * 4
DIG_HARDWARE_SAMPLE_RATE equ 1  * 4
DIG_DMA_RESERVE          equ 2  * 4
DIG_LATENCY              equ 3  * 4
DIG_MIXER_CHANNELS       equ 4  * 4
DIG_DEFAULT_VOLUME       equ 5  * 4
DIG_RESAMPLING_TOLERANCE equ 6  * 4
DIG_USE_STEREO           equ 7  * 4
DIG_USE_16_BITS          equ 8  * 4
DIG_ALLOW_16_BIT_DMA     equ 9  * 4
MDI_SERVICE_RATE         equ 10 * 4
MDI_SEQUENCES            equ 11 * 4
MDI_DEFAULT_VOLUME       equ 12 * 4
MDI_QUANT_ADVANCE        equ 13 * 4
MDI_ALLOW_LOOP_BRANCHING equ 14 * 4
MDI_DEFAULT_BEND_RANGE   equ 15 * 4
AIL_SCAN_FOR_HARDWARE    equ 16 * 4
AIL_ALLOW_VDM_EXECUTION  equ 17 * 4

                ;
                ;SAMPLE.status flag values
                ;

SMP_FREE                 equ 0001h
SMP_DONE                 equ 0002h
SMP_PLAYING              equ 0004h

                ;
                ;AIL_DRIVER structure
                ;

AIL_DRIVER      STRUC
dseg            dd ?
dsel            dd ?
dbuf            dd ?
vhdr            dd ?
dtype           dd ?
initialized     dd ?
PM_ISR          dd ?
server          dd ?
destructor      dd ?
descriptor      dd ?
AIL_DRIVER      ENDS

                ;
                ;VDI_HDR structure
                ;

VDI_HDR         STRUC
drvr_ID         db 8 dup (?)
driver_version  dd ?
common_configs  dd ?
num_configs     dw ?
env_name        dd ?
IO_ADDR         dw ?                            ;IO_PARMS structure for
IRQ             dw ?                            ;driver -- explicit variables
DMA_8           dw ?                            ;used for MASM/TASM 
DMA_16          dw ?                            ;compatibility
IO_reserved     dd 4 dup (?)
service_rate    dw ?
busy            dw ?
driver_num      dw ?
this_ISR        dw ?
previous_ISR    dd ?
scratch         db 128 dup (?)
VDI_HDR         ENDS

                ;
                ;VDI_CALL structure
                ;

VDI_CALL        STRUC
VDI_AX          dw ?
VDI_BX          dw ?
VDI_CX          dw ?
VDI_DX          dw ?
VDI_SI          dw ?
VDI_DI          dw ?
VDI_CALL        ENDS
                
                ;
                ;IO_PARMS structure
                ;

IO_PARMS        STRUC
IP_IO_ADDR      dw ?
IP_IRQ          dw ?
IP_DMA_8        dw ?
IP_DMA_16       dw ?
IP_reserved     dw ?
                dw ?
                dw ?
                dw ?
IO_PARMS        ENDS

                ;
                ;MODE structure
                ;

MODE            STRUC
min_phys_rate   dw ?
nom_phys_rate   dw ?
max_phys_rate   dw ?

min_half_size   dw ?
max_half_size   dw ?

mode_flags      dd ?
MODE            ENDS

                ;
                ;DIG_DDT structure
                ;

DIG_DDT         STRUC

format_support  db 16 dup (?)
format_data     MODE 16 dup (<>)

DIG_DDT         ENDS

                ;
                ;DIG_DST structure
                ;

DIG_DST         STRUC

DMA_buffer_A    dd ?
DMA_buffer_B    dd ?

active_buffer   dw ?

DIG_DST         ENDS

                ;
                ;MDI_DDT structure
                ;

MDI_DDT         STRUC
MDI_DDT         ENDS

                ;
                ;MDI_DST structure
                ;

MDI_DST         STRUC
MDI_DST         ENDS

                ;
                ;DIG_DRIVER structure
                ;

DIG_DRIVER      STRUC

drvr            dd ?

DDT             dd ?
DST             dd ?

timer           dd ?

half_buff_size  dd ?
DMA_rate        dd ?
hw_format       dd ?
hw_mode_flags   dd ?

DMA_seg         dd ?
DMA_sel         dd ?
DMA_buf         dd ?

DMA             dd 2 dup (?)

buffer_flag_ptr dd ?
last_buffer     dd ?

chans_per_samp  dd ?
bytes_per_chan  dd ?
chans_per_buff  dd ?
samps_per_buff  dd ?

build_size      dd ?
build_buffer    dd ?

playing         dd ?
quiet           dd ?

samples         dd ?
n_samples       dd ?

n_active_samps  dd ?

system_data     dd 8 dup (?)

DIG_DRIVER      ENDS

                ;
                ;SAMPLE structure
                ;

SAMPLE          STRUC
driver          dd ?

status          dd ?

start           dd 2 dup (?)
len             dd 2 dup (?)
pos             dd 2 dup (?)
done            dd 2 dup (?)

current_buffer  dd ?
last_buffer     dd ?

loop_count      dd ?

format          dd ?
flags           dd ?

playback_rate   dd ?

volume          dd ?
pan             dd ?

vol_scale       dd 2*256 dup (?)

SOB             dd ?
EOB             dd ?
EOS             dd ?

user_data       dd 8 dup (?)
system_data     dd 8 dup (?)

SAMPLE          ENDS

                ;
                ;Real-mode interrupt call structures
                ;

                IFDEF DPMI

RMI             STRUC                   ;DPMI real-mode interrupt structure
int_DI          dw ?          
                dw ?
int_SI          dw ?
                dw ?
int_BP          dw ?
                dw ?
                dd ?
int_BX          dw ?
                dw ?
int_DX          dw ?
                dw ?
int_CX          dw ?
                dw ?
int_AX          dw ?
                dw ?
int_flags       dw ?
int_ES          dw ?
int_DS          dw ?
                dw ?
                dw ?
                dw ?
                dw ?
                dw ?
                dw ?
RMI             ENDS

                ELSEIFDEF INT21

RMI             STRUC                   ;Flashtek X32 real-mode int structure
interrupt_num   dw ?
selector_ds     dw ?
selector_es     dw ?
selector_fs     dw ?
selector_gs     dw ?
register_eax    dd ?
register_edx    dd ?
RMI             ENDS

                ENDIF

                ;
                ;Protected-mode descriptor structure
                ;

DT_ENTRY        STRUC
limit_0_15      dw ?
base_0_15       dw ?
base_16_23      db ?
priv            db ?
flgs            db ?
base_24_31      db ?
DT_ENTRY        ENDS

                ;
                ;String copy/write macros
                ;

REP_MOVSB       MACRO
                push ecx
                and ecx,3
                rep movsb
                pop ecx
                shr ecx,2
                rep movsd
                ENDM

REP_STOSB       MACRO
                push ecx
                and ecx,3
                rep stosb
                pop ecx
                shr ecx,2
                rep stosd
                ENDM

                ;
                ;Protected-mode POPF
                ;

POP_F           MACRO                   
                LOCAL restore

                push ebp
                mov ebp,esp
                test BYTE PTR [ebp+5],00000010b
                cli
                jz restore
                sti
restore:        pop ebp
                popfd

                ENDM

                ;
                ;Set DX:EBX = interrupt vector #EAX
                ;Also return ECX = real-mode interrupt vector
                ;

GET_VECT        MACRO                   

                IFDEF DPMI

                push eax
                mov ebx,eax
                mov eax,200h
                int 31h
                shl ecx,16
                mov cx,dx
                pop eax
                push ecx

                mov ah,35h              ;(Rational DOS/4GW)
                push es
                int 21h
                mov dx,es
                pop es

                pop ecx

                ELSEIFDEF INT21

                push es                 ;(Flashtek X32)
                mov cl,al               
                push ecx
                mov eax,2502h
                int 21h
                pop ecx
                push ebx
                push es
                mov eax,2503h
                int 21h
                mov ecx,ebx
                pop edx
                pop ebx
                pop es

                ENDIF

                ENDM

                ;
                ;Set reflected interrupt vector #EAX = BX:EDX
                ;

SET_VECT        MACRO

                IFDEF DPMI

                mov ah,25h              ;(Rational DOS/4GW)
                push ds
                mov ds,bx
                int 21h
                pop ds

                ELSEIFDEF INT21

                mov cl,al               ;(Flashtek X32)
                push ds
                mov ds,bx
                mov eax,2506h
                int 21h
                pop ds

                ENDIF

                ENDM

                ;
                ;Set real-mode interrupt vector #EAX CS:IP = EBX
                ;

SET_REAL_VECT   MACRO

                IFDEF DPMI

                mov ecx,ebx
                shr ecx,16
                mov edx,ebx
                and edx,0ffffh
                mov ebx,eax
                mov eax,201h
                int 31h
        
                ELSEIFDEF INT21
                
                mov cl,al
                mov eax,2505h
                int 21h

                ENDIF

                ENDM

                ;
                ;Set protected-mode interrupt vector #EAX = BX:EDX
                ;

SET_PROT_VECT   MACRO

                IFDEF DPMI

                mov ah,25h              ;(Rational DOS/4GW)
                push ds
                mov ds,bx
                int 21h
                pop ds

                ELSEIFDEF INT21

                mov cl,al               ;(Flashtek X32)
                push ds
                mov ds,ebx
                mov eax,2504h
                int 21h
                pop ds

                ENDIF

                ENDM

                ;
                ;Set EAX = contents of BIOS data area at real-mode segment
                ;40h, offset BX
                ;

GET_BIOS_DATA   MACRO

                IFDEF DPMI

                push ds
                and ebx,0ffffh          ;(Rational DOS/4GW)
                mov eax,40h             
                mov ds,ax               
                mov eax,ds:[ebx]  
                pop ds

                ELSEIFDEF INT21

                IFDEF PHARLAP
        
                push ds                 ;(Phar Lap 386|DOS Extender)
                and ebx,0ffffh
                mov eax,34h
                mov ds,ax
                mov eax,ds:[400h][ebx]
                pop ds

                ELSE

                push ds                 ;(Flashtek X32)
                push ebx
                mov eax,3501h
                int 21h
                mov ds,bx
                mov ecx,400h
                mov eax,3503h
                int 21h
                mov bx,ds
                mov ecx,-1
                mov eax,3505h
                int 21h
                pop ebx
                and ebx,0ffffh
                mov eax,ds:[ebx]
                push eax
                mov bx,ds
                mov eax,3502h
                int 21h
                pop eax
                pop ds

                ENDIF
                ENDIF

                ENDM

                ;
                ;Prototypes
                ;

TIMER_TYPE      TYPEDEF DWORD

VMM_lock_range  PROTO C,P1:NEAR PTR,P2:NEAR PTR

AIL_lock        PROTO C
AIL_unlock      PROTO C

AIL_set_timer_period PROTO C,Timer:TIMER_TYPE,uS:DWORD
AIL_release_timer_handle PROTO C,TImer:TIMER_TYPE

AIL_start_timer PROTO C,Timer:TIMER_TYPE
AIL_stop_timer  PROTO C,Timer:TIMER_TYPE
