#include "chuck.h"
#include "shock.h"
#include "e_global.h"
#include "frames.h"
#include "walldraw.h"


#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"



//#define IGNORE_COLLISION_DETECTION


//take_this_out
#ifdef PC_VERSION
extern uint collisionRange;
extern	char ignoreHits;
extern 	FILE *targetBuildings;
#endif
//////////////

#ifndef PC_VERSION
ushort	cheat_flag=FALSE;
#endif

/* Macros and constants for the line of sight map */

#define 	DEAD_DUCK															0xfe

#define 	MAX_POS_ENEMIES												48

#define 	CORRIGATED_FENCE_TEXTURE							2

#define 	BULLET_DAMAGE													0x4
#define		PLAYER_BULLET_DAMAGE									0x10

#define 	DETECT_SHIFT													23
#define 	WALL_COLLISION_DETECT_RANGE						0x280
#define 	MAX_WALL_COLLISIONS										2

#define 	SHELL_TANK_COLLISION_SCAN_RANGE				0x2000000
#define 	SHELL_BOAT_COLLISION_SCAN_RANGE				0x4000000
#define 	SHELL_TANK_COLLISION_DETECT_RANGE			0x1000000
#define 	SHELL_GUNEMPL_COLLISION_DETECT_RANGE	0x700000
#define 	GUNEMPLACEMENT_HIT_HEIGHT							-0x70


#define 	SHELL_WALL_COLLISION_SCAN_RANGE			0x200
#define   BULLET_WALL_COLLISION_SCAN_RANGE		0X200
#define 	SHELL_WALL_COLLISION_DETECT_RANGE		0x100
#define 	BULLET_WALL_COLLISION_DETECT_RANGE	0x100

enum 			{ destroy_a_tank, destroy_a_wall, crush_a_fence };

#define 	LEFT_BOUNDARY			0x0001
#define 	RIGHT_BOUNDARY		0x0010
#define 	BOTTOM_BOUNDARY   0x0100
#define 	TOP_BOUNDARY   		0x1000

#define 	TOP_AND_BOTTOM		0x1100


#define 	WALL_TYPE_MASK			7
#define 	WALL_HEIGHT_MASK		0XF
#define 	WALL_HEIGHT_SHIFT		9
#define 	WALL_TEXTURE_MASK		0X3F
#define 	WALL_TEXTURE_SHIFT  3
#define 	WALL_DETECT_MASK		3


ushort	 	wall_z_index[256];

enum		{ IGNOREABLE_WALL=0, CRUSHABLE_WALL, ALLIGNABLE_WALL, SEMI_DETECTABLE_WALL };

/* shell detection variables */

static	uint				rTankMinX, rTankMaxX, rTankMinZ, rTankMaxZ;
static	uint 				tankxmin, tankxmax, tankzmin, tankzmax;
static	int					ohit, nhit;
static	SHELL_DATA  *dshell;
static	TANK				*dtank;

void				*posEnemyList[MAX_POS_ENEMIES+4];
uchar				posEnemyTypeList[MAX_POS_ENEMIES+4];


/* General collision detection variables */

static	int			indsz, indez; 													/* Indexing start and end values */
static	POINT_DATA	*cwallmid;



/* Wall detection variables */

static	int	sizex=0x100;
static	int	sizez=0x100;

static	POINT 	relp[2], rotp[2];
static	int			dcosang, dsinang;

static	int			mapx=0x8000, mapz=0x8000;
static	int			lineangle;

extern	int			moveDirection;


int			startz, endz;
int			startx, endx;
int			cosang;
int			sinang;
int	    cWallType;
int	    cDetectType;
int	    cWallTexture;
int	    cWallHeight;
int			cDestroyable;


int		detect_against_wall(WALL_DATA *, TANK *);						/* For normal solid buildings */
int		simple_detect_against_wall(WALL_DATA *);						/* For detecting against crushable objects */

int		shell_2_wall_detect(WALL_DATA *);
void	shell_detection(SHELL_DATA *startShell);


void	damage_tank(TANK *damagedTank, int	damageVal);

void	destroy_group(WALL_DATA *grpWall);
void	destroy_texture(WALL_DATA *detwall);
void	crush_texture(WALL_DATA *cwall);
void	check_destroyed_building(int indx);
void	remove_los_line(WALL_DATA *remvWall);
void	shunt_tank(TANK *, SHELL_DATA *, int recoil);

int	objectDetectSizes[] =
												{ 	0,				/* Shell */
													 	0x100,    /* Player tank */
														0x100, 		/* Enemy tank */
														0x120, 		/* Battle tank */
														0xf0, 		/* afv */
														0xf0,			/* apc */
														0, 				/* dummy - gunboat */
														0x80,			/* gun emplacement */
														0xf0, 		/* allied truck */
														0xf0, 		/* enemy truck */
														0x10,			/* hostage */
														0x10,			/* hostage */
														0x120,		/* enemy helicopter */
														0x130, 		/* enemy gunship */
														0x100,		/* network tank */
														0x120, 		/* player helicopter */
														0x140}; 	/* player plane */

/*-----------------16/10/95 15:30-------------------
 The fragment types for each texture
--------------------------------------------------*/

uchar	solidfragList[] =
{
	BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS,
	BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS,
	WOODEN_BULDING_FRAGMENTS, CORRIGATED_FRAGMENT, METAL_FRAGMENTS, METAL_FRAGMENTS,
	FUEL_CONTAINER_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS,
	BUILDING_FRAGMENTS, WOODEN_BULDING_FRAGMENTS, FUEL_CONTAINER_FRAGMENTS, BUILDING_FRAGMENTS,
	BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, WOODEN_BULDING_FRAGMENTS,
	WOODEN_BULDING_FRAGMENTS, WOODEN_BULDING_FRAGMENTS, WOODEN_BULDING_FRAGMENTS, WOODEN_BULDING_FRAGMENTS,
	WOODEN_BULDING_FRAGMENTS, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, BUILDING_FRAGMENTS,
	BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, BUILDING_FRAGMENTS, CORRIGATED_FRAGMENT
};


uchar	raggedfragList[] =
{
	BUILDING_FRAGMENTS, 0, 0, 0
};


uchar	transymfragList[] =
{
 0, 0, 0, 0,
 WIRE_MESH_FRAGMENT, 0, METAL_FRAGMENTS, WOODEN_BULDING_FRAGMENTS,
 METAL_FRAGMENTS, METAL_FRAGMENTS, METAL_FRAGMENTS, METAL_FRAGMENTS,
 METAL_FRAGMENTS, METAL_FRAGMENTS, 0, FUEL_CONTAINER_FRAGMENTS,
 0, 0, 0, 0,
 0, 0, 0, 0,
 0, 0, 0
};


uchar	tranasymfraglist[] =
{
 0, 0, 0, 0,
 0, 0, 0, 0,
 FUEL_CONTAINER_FRAGMENTS, 0, 0, 0,
 0, 0, 0, 0,
 0, 0
};


uchar	*fragLists[4] =
{
 	solidfragList,
	raggedfragList,
	transymfragList,
	tranasymfraglist
};

ushort	*wallHitPoints[5];

/*****************************************************************/
/*****************************************************************/
/*****************************************************************/


enum OBJECT_TYPES { PLAYER_OBJECT, TANK_OBJECTS, AIRBOURNE_OBJECTS, GUNEMPLACMENT_OBJECTS, WATER_OBJECTS };



/*****************************************************************/
/*****************************************************************/
/*****************************************************************/






/*****************************************************************/
/** Collision routines */
/*****************************************************************/

#define GUN_EMPL_SQR_DET_VAL	0x8000			/* Squared radius value of gun emplacement */

int	check_4_object_collision(TANK *coltank)
{
	int	relx, relz;
	int	inPosRange = FALSE;
	TANK	*tank2=NULL;
	ushort	*collGunempls;
	ushort	*collObjs;					                /* Pointer to the list of walls that the tank might hit */
	ATTACKING_TANK_DATA *cattackData;
	GUN_EMPLACEMENT *cgunempl;
	void		**lastEnem;
	uchar		*lastEnemType;

	cattackData = coltank->collData;

	if ( cattackData==NULL )										/* TANK HASN'T GOT ATTACK DATA SLOT - RETURN WITH FALSE */
	{
		return (FALSE);
	}

	collObjs = coltank->collData->objs;
	collGunempls = coltank->collData->gunempls;
	cattackData->numObjs = 0;
	cattackData->numGunempls = 0;

	lastEnemType = posEnemyTypeList;
	lastEnem = posEnemyList;

	while ( *lastEnemType!=0xff )
	{
		switch ( *lastEnemType )
		{
			case TANK_TAG:
				tank2 = *((TANK**)lastEnem);
				if ( coltank==tank2 )
				{
					break;
				}

  			relx = (int)(((uint)(coltank->x+0x8000)>>16) - ((uint)(tank2->x+0x8000)>>16));	/* Round up values */
  			relz = (int)(((uint)(coltank->z+0x8000)>>16) - ((uint)(tank2->z+0x8000)>>16));

  			if ( (abs(relx)) > 0x300 || (abs(relz)) > 0x300 )
  			{
					lastEnem++;
					lastEnemType++;
  				continue;
  			}

  			inPosRange = TRUE;

  			if ( cattackData->numObjs < MAX_DETECT_OBJECTS )
  			{
  				cattackData->numObjs++;
					if ( tank2==&pl )
					{
						*collObjs++ = -1;	/* note that its the player tank */
					}
					else
  					*collObjs++ = (tank2-enemyTanks);				/* Record id of possible collision tank for next pass */
  			}

  			relx *= relx;
  			relz *= relz;

  			if ( (relx+relz) < (coltank->sqrObjDetval + tank2->sqrObjDetval) )
  			{
  				return (TRUE);
  			}
				break;


			case GUN_EMPL_TAG:
				cgunempl = *((GUN_EMPLACEMENT **)lastEnem);

  			relx = (int)(((uint)(coltank->x+0x8000)>>16) - ((uint)(cgunempl->x+0x8000)>>16));	/* Round up values */
  			relz = (int)(((uint)(coltank->z+0x8000)>>16) - ((uint)(cgunempl->z+0x8000)>>16));

  			if ( (abs(relx)) > 0x300 || (abs(relz)) > 0x300 )
  			{
					lastEnem++;
					lastEnemType++;
  				continue;
  			}

  			inPosRange = TRUE;

  			if ( cattackData->numGunempls < MAX_DETECT_GUNEMPLS )
  			{
  				cattackData->numGunempls++;
  				*collGunempls++ = (cgunempl-gunempls);				/* Record id of possible collision gun emplacement for next pass */
  			}

  			relx *= relx;
  			relz *= relz;

  			if ( (relx+relz) < (coltank->sqrObjDetval + GUN_EMPL_SQR_DET_VAL) )
  			{
  				return (TRUE);
  			}

				break;
		}

		lastEnem++;
		lastEnemType++;

	}

	if(inPosRange==FALSE) coltank->possObjCollisions = currentIgnoreValue;		/* Tank isn't in range of anything - ignore it from subsequent detections */
	return (FALSE);

}


/*****************************************************************/

int	second_check_4_object_collision(TANK *coltank)
{
	int	i;
	int	relx, relz;
	TANK	*tank2;
	ushort	*collObjs;					                /* Pointer to the list of walls that the tank might hit */
	ATTACKING_TANK_DATA *cattackData;
	ushort	*collGunempls;
	GUN_EMPLACEMENT *cgunempl;

	if ( coltank->possObjCollisions==currentIgnoreValue ) /* This tank is known to not be in the vicinity of any other tanks */
	{
		return (FALSE);
	}

	cattackData = coltank->collData;

	if ( cattackData==NULL ) 										/* NO ATTACK DATA TO CHECK AGAINST YET */
	{
		return (FALSE);
	}

	collObjs = coltank->collData->objs;

	/** Scan through list of possible collision tanks **/

	for ( i=0; i<cattackData->numObjs; i++, collObjs++  )
	{
		if ( *collObjs==0xffff )
		{
			tank2 = &pl;
		}
		else
			tank2 = enemyTanks + *collObjs;

		relx = (int)(((uint)(coltank->x+0x8000)>>16) - ((uint)(tank2->x+0x8000)>>16));	/* Round up values */
		relz = (int)(((uint)(coltank->z+0x8000)>>16) - ((uint)(tank2->z+0x8000)>>16));

		relx *= relx;
		relz *= relz;


		if ( (relx+relz) < (coltank->sqrObjDetval + tank2->sqrObjDetval) )
		{
			return (TRUE);
		}
	}



	/** Test for collisions against gun emplacements */

	collGunempls = coltank->collData->gunempls;

	for ( i=0; i<cattackData->numGunempls; i++, collGunempls++  )
	{
		cgunempl = gunempls + *collGunempls;

		relx = (int)(((uint)(coltank->x+0x8000)>>16) - ((uint)(cgunempl->x+0x8000)>>16));	/* Round up values */
		relz = (int)(((uint)(coltank->z+0x8000)>>16) - ((uint)(cgunempl->z+0x8000)>>16));

		relx *= relx;
		relz *= relz;


		if ( (relx+relz) < (coltank->sqrObjDetval + GUN_EMPL_SQR_DET_VAL) )
		{
			return (TRUE);
		}
	}

	return (FALSE);
}

/*****************************************************************/

void	shell_detect(void)
{
	#ifdef PC_VERSION
	#ifndef FLOPPY_VERSION
	SEND_DESTRUCTION= 1;   /*DO transmit destruction info*/
	#endif
	#endif
	shell_detection(playerShells);

	#ifdef PC_VERSION
	#ifndef FLOPPY_VERSION
	SEND_DESTRUCTION= 0;
	#endif
	#endif
	shell_detection(enemyShells);

	#ifdef PC_VERSION
	#ifndef FLOPPY_VERSION
	SEND_DESTRUCTION= 1;
	#endif
	#endif
}


/*****************************************************************/



#define GUNBOAT_DETECTION_RADIUS	0x20000
#define	GUNBOAT_SHELL_SCAN_RANGE	0xe000000

#define TRANSPARENT_SYMETRICAL_TEXTURE	2
#define PESKY_BRIDGE_TEXTURE_1					12
#define PESKY_BRIDGE_TEXTURE_2					13

#define PESKY_FUCKED_BRIDGE_TEXTURE_1		25
#define PESKY_FUCKED_BRIDGE_TEXTURE_2		26

void	shell_detection(SHELL_DATA *startShell)
{
	int	relx, relz;												/* Relative distance of tank */
	int	wallsfound;
	int	hitwall;
	int	hitobj;
	int	n;
	WALL_DATA		*detwall;									/* The current wall to test against */
	GUN_EMPLACEMENT	*cgunempl;
	GUN_BOAT	*dboat;
	POSITION	gunemplPos;
	int	maxshells;
	int	detAgainstPlayer;
	int	detectionSize;
	int	i;
	uint	tx,tz,cx,cz,lx,lz,bitSet=FALSE;
	void		**lastEnem;
	uchar		*lastEnemType;

#ifdef PC_VERSION
	/*Are shell termination explosions sent?*/
#ifndef FLOPPY_VERSION
	EXPLOSION_TRANSMITTER= 0;
#endif
#endif

	if ( startShell==playerShells )
	{
#ifdef PC_VERSION
#ifndef FLOPPY_VERSION
		if (nDef.flags&TRANSMIT_EXPLOSIONS)
		 EXPLOSION_TRANSMITTER=1;
#endif
#endif

		maxshells = MAX_PLAYER_SHELLS;
		detAgainstPlayer = FALSE;
	}
	else
	{
		maxshells = MAX_ENEMY_SHELLS;
		detAgainstPlayer = TRUE;
	}

	shell_det(startShell,maxshells); 			/* Detect against floor objects first */

	hitobj = hitwall = 0;


	for ( i=0, dshell=startShell; i<maxshells; i++, dshell++)
	{
		if ( dshell->fired==FALSE ) 				/* Skip shell if it hasn't been fired */
			continue;

		hitobj = hitwall = 0;

		detectionSize = (objectDetectSizes[pl.def])<<16;

		/* Detect against player if an enemy shell */

		if ( detAgainstPlayer )
		{
			if ( dshell->ownerType == PLAYER_TANK ) 	/** Don't need to detect player shells against the player */
			{
				continue;
			}

			relx = pl.x - dshell->x;
			relz = pl.z - dshell->z;

			if ( (abs(relx)<=SHELL_TANK_COLLISION_SCAN_RANGE) && (abs(relz)<=SHELL_TANK_COLLISION_SCAN_RANGE) )
			{
				tankxmin = ( tankxmax = pl.x+detectionSize ) - (detectionSize<<1);
				tankzmin = ( tankzmax = pl.z+detectionSize ) - (detectionSize<<1);

				ohit = nhit = 0;

				if (dshell->ox < tankxmin) ohit |= 	LEFT_BOUNDARY;
				if (dshell->ox > tankxmax) ohit |= 	RIGHT_BOUNDARY;
				if (dshell->oz < tankzmin) ohit |= 	BOTTOM_BOUNDARY;
				if (dshell->oz > tankzmax) ohit |= 	TOP_BOUNDARY;

				if (dshell->x < tankxmin) nhit |= 	LEFT_BOUNDARY;
				if (dshell->x > tankxmax) nhit |= 	RIGHT_BOUNDARY;
				if (dshell->z < tankzmin) nhit |= 	BOTTOM_BOUNDARY;
				if (dshell->z > tankzmax) nhit |= 	TOP_BOUNDARY;

				if ( (ohit & nhit)==0  )
				{
					dshell->fired = 0;
					/* damage player tank */
					trigger_explosion(SHELL_HIT_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(pl.x));
					damage_tank(&pl, dshell->damage);
					shunt_tank(&pl, dshell, FALSE);
					continue;
				}

			}

		}



		/* Scan through the list of possible enemies */

		lastEnemType = posEnemyTypeList;
		lastEnem = posEnemyList;


		while ( *lastEnemType!=0xff )
		{
			switch ( *lastEnemType )
			{
				case DEAD_DUCK:
					dshell->fired = 0;
					hitobj=TRUE;
					break;

				case TANK_TAG:
					dtank = *((TANK**)lastEnem);

					if ( detAgainstPlayer && (dshell->ownerType ==  dtank->def) && (dshell->owner==(dtank-enemyTanks)) )
					{
						// Don't detect against the tank that fired the shell
						break;
					}

					if ( !dtank->def && (dshell->owner!=(dtank-enemyTanks))) 				// Hit an already exploding tank (possibly convoy truck - ouch!!!)
					{
						dshell->fired = 0;
						hitobj=TRUE;
						*lastEnemType=DEAD_DUCK;
						break;
					}

					detectionSize = (objectDetectSizes[dtank->def])<<16;

					relx = dtank->x - dshell->x;
					relz = dtank->z - dshell->z;

					/* Check if tank is in range for possible collision */
					if ( (abs(relx)<=SHELL_TANK_COLLISION_SCAN_RANGE) && (abs(relz)<=SHELL_TANK_COLLISION_SCAN_RANGE) )
					{
						tankxmin = ( tankxmax = dtank->x+detectionSize ) - (detectionSize<<1);
						tankzmin = ( tankzmax = dtank->z+detectionSize ) - (detectionSize<<1);

						ohit = nhit = 0;

						if (dshell->ox < tankxmin) ohit |= 	LEFT_BOUNDARY;
						if (dshell->ox > tankxmax) ohit |= 	RIGHT_BOUNDARY;
						if (dshell->oz < tankzmin) ohit |= 	BOTTOM_BOUNDARY;
						if (dshell->oz > tankzmax) ohit |= 	TOP_BOUNDARY;

						if (dshell->x < tankxmin) nhit |= 	LEFT_BOUNDARY;
						if (dshell->x > tankxmax) nhit |= 	RIGHT_BOUNDARY;
						if (dshell->z < tankzmin) nhit |= 	BOTTOM_BOUNDARY;
						if (dshell->z > tankzmax) nhit |= 	TOP_BOUNDARY;

						if ( (ohit & nhit)==0  )
						{
							dshell->fired = 0;
							shunt_tank(dtank, dshell, FALSE);
							damage_tank(dtank, dshell->damage);
							trigger_explosion(SHELL_HIT_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(dtank->x));
							hitobj=TRUE;

							if ( !detAgainstPlayer )
							{
								numShotsHit++;
							}
							break;
						}
					}
					break;

				case GUN_EMPL_TAG:
					cgunempl = *((GUN_EMPLACEMENT **)lastEnem);

  				relx = cgunempl->x - dshell->x;
  				relz = cgunempl->z - dshell->z;

  				/* Check if tank is in range for possible collision */
  				if ( (abs(relx)<=SHELL_TANK_COLLISION_SCAN_RANGE) && (abs(relz)<=SHELL_TANK_COLLISION_SCAN_RANGE) )
  				{
  					tankxmin = ( tankxmax = cgunempl->x+SHELL_GUNEMPL_COLLISION_DETECT_RANGE ) - 2*SHELL_GUNEMPL_COLLISION_DETECT_RANGE;
  					tankzmin = ( tankzmax = cgunempl->z+SHELL_GUNEMPL_COLLISION_DETECT_RANGE ) - 2*SHELL_GUNEMPL_COLLISION_DETECT_RANGE;

  					ohit = nhit = 0;

  					if (dshell->ox < tankxmin) ohit |= 	LEFT_BOUNDARY;
  					if (dshell->ox > tankxmax) ohit |= 	RIGHT_BOUNDARY;
  					if (dshell->oz < tankzmin) ohit |= 	BOTTOM_BOUNDARY;
  					if (dshell->oz > tankzmax) ohit |= 	TOP_BOUNDARY;

  					if (dshell->x < tankxmin) nhit |= 	LEFT_BOUNDARY;
  					if (dshell->x > tankxmax) nhit |= 	RIGHT_BOUNDARY;
  					if (dshell->z < tankzmin) nhit |= 	BOTTOM_BOUNDARY;
  					if (dshell->z > tankzmax) nhit |= 	TOP_BOUNDARY;

  					if ( (ohit & nhit)==0  )
  					{
  						dshell->fired = cgunempl->exist = FALSE;
							gunemplPos.x = cgunempl->x;
							gunemplPos.z = cgunempl->z;
							gunemplPos.y = 0;
  						trigger_explosion(GUN_EMPLACEMENT_EXPLOSION, (POSITION*)&(dshell->x), &gunemplPos);

							enemy_destroyed_sound(E_GUNEMPL, cgunempl->x, cgunempl->z);
							numObjectiveEnemies--;
							game_data.ngrdtarg_dest++;
							hitobj=TRUE;
  						break;
  					}
  				}
					break;

				case GUNBOAT_TAG:
					dboat = *((GUN_BOAT**)lastEnem);
					relx = dboat->x - dshell->x;
					relz = dboat->z - dshell->z;

					if ( (abs(relx)<GUNBOAT_SHELL_SCAN_RANGE) && (abs(relz)<GUNBOAT_SHELL_SCAN_RANGE) )
					{
						relx>>=16;
						relz>>=16;

						relx *= relx;
						relz *= relz;

						/** Check central gunboat radius **/

						if ( (relx+relz) < GUNBOAT_DETECTION_RADIUS )
						{
							dshell->fired = 0;
							damage_gunboat(dboat, dshell->damage);
							trigger_explosion(SHELL_HIT_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(dshell->x));
							hitobj = TRUE;
							if ( !detAgainstPlayer )
							{
								numShotsHit++;
							}
							break;
						}

						cosang = (int)sintab[dboat->angle+512];
						sinang = (int)sintab[dboat->angle];

						/** Check bow radius **/

						relx = dboat->x + (0x500*sinang);
						relz = dboat->z	+ (0x500*cosang);

						relx -= dshell->x;
						relz -= dshell->z;

						relx >>=16 ;
						relz >>=16 ;

						relx *= relx;
						relz *= relz;

						if ( (relx+relz) < GUNBOAT_DETECTION_RADIUS )
						{
							dshell->fired = 0;
							damage_gunboat(dboat, dshell->damage);
							trigger_explosion(SHELL_HIT_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(dshell->x));
							hitobj = TRUE;
							if ( !detAgainstPlayer )
							{
								numShotsHit++;
							}
							break;
						}

						/** Check stern radius **/

						relx = dboat->x - (0x400*sinang);
						relz = dboat->z	- (0x400*cosang);

						relx -= dshell->x;
						relz -= dshell->z;

						relx >>=16 ;
						relz >>=16 ;

						relx *= relx;
						relz *= relz;

						if ( (relx+relz) < GUNBOAT_DETECTION_RADIUS )
						{
							dshell->fired = 0;
							damage_gunboat(dboat, dshell->damage);
							trigger_explosion(SHELL_HIT_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(dshell->x));
							hitobj = TRUE;
							if ( !detAgainstPlayer )
							{
								numShotsHit++;
							}
							break;
						}
					}
					break;
			}

			if ( hitobj )
			{
				break;
			}

			lastEnem++;
			lastEnemType++;


		}




		/*-----------------18/10/95 14:13-------------------
		 Early out for shell detection against walls
		--------------------------------------------------*/

		tx = (((uint)dshell->x) >>24)&0xff;
		tz = (((uint)dshell->z) >>24)&0xff;

		cx = (tx>1) ? tx-2 : 0;
		cz = (tz>1) ? tz-2 : 0;


		lx = (tx<254) ? tx+2 : 255;
		lz = (tz<254) ? tz+2 : 255;

		tx = cx;

		bitSet=FALSE;

		for ( ; cz<=lz; cz++ )
		{
			for ( cx=tx; cx<=lx; cx++ )
			{
				if ( test_qdt_bit(cx,cz) )
				{
					bitSet=TRUE;
					break;
				}
			}

			if ( bitSet )
			{
				break;
			}
		}

		if ( !bitSet )
		{
			continue;
		}


		/* Now scan through the walls */

		mapx = ((((uint)dshell->x) >>16) + (((uint)dshell->ox) >>16) ) >>1;
		mapz = ((((uint)dshell->z) >>16) + (((uint)dshell->oz) >>16) ) >>1;

		/* Determine range of collision detection */

		startz = ( (int)(mapz - SHELL_WALL_COLLISION_SCAN_RANGE) <0) ? 0 : (mapz - SHELL_WALL_COLLISION_SCAN_RANGE);

		startx = ( (int)(mapx - SHELL_WALL_COLLISION_SCAN_RANGE) <0) ? 0 : (mapx - SHELL_WALL_COLLISION_SCAN_RANGE);

		endz = ( (int)(mapz + SHELL_WALL_COLLISION_SCAN_RANGE) > 0xffff ) ? 0xffff : (mapz + SHELL_WALL_COLLISION_SCAN_RANGE);

		endx = ( (int)(mapx + SHELL_WALL_COLLISION_SCAN_RANGE) > 0xffff ) ? 0xffff : (mapx + SHELL_WALL_COLLISION_SCAN_RANGE);

		/* Index into wall list using z range */

		indsz = startz >> 8;
		indez = endz >> 8;

		wallsfound = FALSE;

		while ( TRUE )
		{
			if ( wall_z_index[indsz] != NO_POINTS ) 	/* Find first wall in z range */
			{
				cwallmid = wallMids + (n = wall_z_index[indsz]);
				detwall = wallSfcs + wall_z_index[indsz];
				wallsfound = TRUE;
				break;
			}
			indsz++;
			if ( indsz>indez ) 												/* No walls to test against */
			{
				break;
			}
		}


		if ( wallsfound ) 													/* Scan through walls in range */
		{
			hitwall = FALSE;
			for ( ; n<numSfcs; n++, cwallmid++, detwall++ )
			{
				if ( cwallmid->z > endz )								/* Reached end of detection range */
				break;

				if ( ((uint)cwallmid->x) >=startx && ((uint)cwallmid->x)<=endx )
				{
					/* Wall in scanning range */
					if ( detwall->wallType == TOTALLED_TEXTURE)
					{
						continue;					/* An ignoreable wall */
					}

					cWallType = detwall->wallType & WALL_TYPE_MASK;
					cWallHeight = (detwall->wallType>>WALL_HEIGHT_SHIFT) & WALL_HEIGHT_MASK;
					cWallTexture = (detwall->wallType >> WALL_TEXTURE_SHIFT) & WALL_TEXTURE_MASK;
					cDetectType = (cDestroyable = wdetect_info[cWallType].detectType[cWallTexture]) & WALL_DETECT_MASK;
					cDestroyable&=4;


					if ( !cDetectType )
					{
						continue;					/* An ignoreable wall */
					}

					if ( cWallHeight < 1 )
					{
						continue;					/* Too short to hit with a shell */
					}

					/** ultra frig - shells ignore these destroyed textures */
					if ( (cWallType==TRANSPARENT_SYMETRICAL_TEXTURE) && (cWallTexture==PESKY_FUCKED_BRIDGE_TEXTURE_1 || cWallTexture==PESKY_FUCKED_BRIDGE_TEXTURE_2))
					{
						continue;
					}


					if ( shell_2_wall_detect(detwall) )
					{
						short	tempDamage;

						hitwall=TRUE;

						tempDamage = wallHitList[n] & HITVALUE_MASK;
						tempDamage -= dshell->damage;

						//wallHitList[n] -= dshell->damage;	// damage the wall

						if ( tempDamage > 0 )
						{
							dshell->fired = FALSE;
							trigger_fx_sprite(AIRBURST_ANIM, dshell->x, dshell->y, dshell->z, FALSE, TRANSPARENT_SPRITE, MEDIUM_SPRITE, TRUE);
							shell_explosion_sound(dshell->x, dshell->z);

							wallHitList[n] &= (~HITVALUE_MASK);
							wallHitList[n] |= tempDamage;
							continue;
						}


						if ( cDetectType==CRUSHABLE_WALL )
						{
							/* alter direction a wee bit */
							crush_texture(detwall);
						}
						else
						{
							if ( cDestroyable )			/** ultra frig **/
							{
								if ( (cWallType==TRANSPARENT_SYMETRICAL_TEXTURE) && (cWallTexture==PESKY_BRIDGE_TEXTURE_1 || cWallTexture==PESKY_BRIDGE_TEXTURE_2))
								{
									crush_texture(detwall);
									trigger_fragments(6,(POSITION*)&(dshell->x), METAL_FRAGMENTS);
									shell_explosion_sound(dshell->x, dshell->z);
								}
								else
									destroy_group(detwall);
							}
							else
								shell_explosion_sound(dshell->x, dshell->z);


							/* Explode shell */
							dshell->fired = FALSE;

							/*Mark shell as exploding, for remote tanks*/
							#ifdef PC_VERSION
							#ifndef FLOPPY_VERSION
							if (EXPLOSION_TRANSMITTER)
								SHELL_EXPLODE_REMOTE (i, AIR_EXPLOSION);
							#endif
							#endif

							trigger_explosion(AIR_EXPLOSION, (POSITION*)&(dshell->x), NULL);

							hitobj = TRUE;
							break;
						}
					}
				}
			}
		}

		if ( hitobj ) /* already hit a wall don't need to scan for anything else */
		{
			continue;
		}

#ifdef PC_VERSION
#ifndef FLOPPY_VERSION
		/*SHELL has gone from fired... to not!*/
		if ((dshell->fired==_FALSE) && (startShell==playerShells))
		{
			/*This holds the slot AFTER the most recently vacated one*/
			SHELLSLOT_SEARCH= i+1;
			if (SHELLSLOT_SEARCH==maxshells)
				SHELLSLOT_SEARCH= 0;
		}
#endif
#endif


	} /*i loop*/
}


/***************************************************************/



#define BULLET_SCAN_RANGE							0X2000000
#define BULLET_2_GUNBOAT_SCAN_RANGE   0xf000000



void	bullet_detection(struct	bullets	*bullets, int maxbullets)
{
	struct	bullets	*bull_ptr;
	GUN_EMPLACEMENT *cgunempl;
	GUN_BOAT	*dboat;
	POSITION	gunemplPos;
	WALL_DATA		*detwall;												/* The current wall to test against */
	int	bulletHit=0;
	int	wallsfound;
	int	n;
	int	relx, relz;
	int	j;
	int	bulletDamageVal;
	uint	tx,tz,cx,cz,lx,lz,bitSet=FALSE;
	void		**lastEnem;
	uchar		*lastEnemType;



	if ( bullets == pl_bullets )
	{
		bulletDamageVal = PLAYER_BULLET_DAMAGE;
	}
	else
		bulletDamageVal = BULLET_DAMAGE;


	for (j=0, bull_ptr = bullets; j<maxbullets; j++, bull_ptr++)
	{
		if ( bull_ptr->on )
		{
			bulletHit=FALSE;

			/** Check if you need to test against the player tank **/

			if ( bullets!=pl_bullets ) /* Don't detect against the player tank if the bullet was fired by the player */
			{
				rTankMinX = ( rTankMaxX = pl.x+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);
				rTankMinZ = ( rTankMaxZ = pl.z+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);

				tankxmin = ( tankxmax = pl.x+0x1000000 ) - 0x2000000;
				tankzmin = ( tankzmax = pl.z+0x1000000 ) - 0x2000000;

				if ( bull_ptr->x >= rTankMinX &&
						 bull_ptr->x <= rTankMaxX &&
						 bull_ptr->z >= rTankMinZ &&
						 bull_ptr->z <= rTankMaxZ )
				{
					ohit = nhit = 0;

					if (bull_ptr->oldx < tankxmin)     	ohit |= 0x0001;
					else if (bull_ptr->oldx > tankxmax)	ohit |= 0x0010;
					if (bull_ptr->oldz < tankzmin)     	ohit |= 0x0100;
					else if (bull_ptr->oldz > tankzmax)	ohit |= 0x1000;

					if (bull_ptr->x < tankxmin)      	nhit |= 0x0001;
					else if (bull_ptr->x > tankxmax) 	nhit |= 0x0010;
					if (bull_ptr->z < tankzmin)      	nhit |= 0x0100;
					else if (bull_ptr->z > tankzmax) 	nhit |= 0x1000;

					if (!(ohit & nhit))
					{
						if ((bull_ptr->y >> 16) > -0x120)
						{
							bull_ptr->on = 0;
							damage_tank(&pl, bulletDamageVal);

							continue;
						}
					}
				}
			}


			lastEnemType = posEnemyTypeList;
			lastEnem = posEnemyList;

			while ( *lastEnemType!=0xff )
			{
				switch ( *lastEnemType )
				{
					case DEAD_DUCK:
						bull_ptr->on = FALSE;
						bulletHit = TRUE;
						break;

					case TANK_TAG:
						dtank = *((TANK**)lastEnem);

						if ( !dtank->def && ( bull_ptr->owner!=( dtank-enemyTanks )) ) 				// Hit an already exploding tank (possibly convoy truck - ouch!!!)
						{
							bull_ptr->on = FALSE;
							bulletHit = TRUE;
							*lastEnemType=DEAD_DUCK;		// Make the tag no longer valid.
							break;
						}


						if ( (bull_ptr->ownerType == ENEMY_APC) && ( bull_ptr->owner==( dtank-enemyTanks )))
						{
							break; /* Don't detect the bullet against apc that fired the bullet */
						}

						rTankMinX = ( rTankMaxX = dtank->x+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);
						rTankMinZ = ( rTankMaxZ = dtank->z+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);

						tankxmin = ( tankxmax = dtank->x+0x1000000 ) - 0x2000000;
						tankzmin = ( tankzmax = dtank->z+0x1000000 ) - 0x2000000;

  					if (
  						 bull_ptr->x >= rTankMinX &&
  						 bull_ptr->x <= rTankMaxX &&
  						 bull_ptr->z >= rTankMinZ &&
  						 bull_ptr->z <= rTankMaxZ )
    				{
    					ohit = nhit = 0;

    					if (bull_ptr->oldx < tankxmin)     	ohit |= 0x0001;
    					else if (bull_ptr->oldx > tankxmax)	ohit |= 0x0010;
    					if (bull_ptr->oldz < tankzmin)     	ohit |= 0x0100;
    					else if (bull_ptr->oldz > tankzmax)	ohit |= 0x1000;

    					if (bull_ptr->x < tankxmin)      	nhit |= 0x0001;
    					else if (bull_ptr->x > tankxmax) 	nhit |= 0x0010;
    					if (bull_ptr->z < tankzmin)      	nhit |= 0x0100;
    					else if (bull_ptr->z > tankzmax) 	nhit |= 0x1000;

    					if (!(ohit & nhit))
    					{
    						if (abs((bull_ptr->y >> 16) - (dtank->y - 112)) < 128) // was '64' instead of '128'
    						{
    							bull_ptr->on = 0;
  								damage_tank(dtank, bulletDamageVal);
  								bulletHit = TRUE;

  								if ( j&3 )
  								{
  									trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
  								}
    						}
    					}
    				}
						break;


					case GUN_EMPL_TAG:
						cgunempl = *((GUN_EMPLACEMENT **)lastEnem);

						if ( (bull_ptr->ownerType == E_GUNEMPL) && (bull_ptr->owner==(cgunempl-gunempls)))
						{
							break; /* Don't detect the bullet against gun emplacement thst fired the bullet */
						}

  					rTankMinX = ( rTankMaxX = cgunempl->x+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);
  					rTankMinZ = ( rTankMaxZ = cgunempl->z+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);

  					tankxmin = ( tankxmax = cgunempl->x+0x800000 ) - 0x1000000;
  					tankzmin = ( tankzmax = cgunempl->z+0x800000 ) - 0x1000000;

  					if (
  						 bull_ptr->x >= rTankMinX &&
  						 bull_ptr->x <= rTankMaxX &&
  						 bull_ptr->z >= rTankMinZ &&
  						 bull_ptr->z <= rTankMaxZ )
    				{
    					ohit = nhit = 0;

    					if (bull_ptr->oldx < tankxmin)     	ohit |= 0x0001;
    					else if (bull_ptr->oldx > tankxmax)	ohit |= 0x0010;
    					if (bull_ptr->oldz < tankzmin)     	ohit |= 0x0100;
    					else if (bull_ptr->oldz > tankzmax)	ohit |= 0x1000;

    					if (bull_ptr->x < tankxmin)      	nhit |= 0x0001;
    					else if (bull_ptr->x > tankxmax) 	nhit |= 0x0010;
    					if (bull_ptr->z < tankzmin)      	nhit |= 0x0100;
    					else if (bull_ptr->z > tankzmax) 	nhit |= 0x1000;

    					if (!(ohit & nhit))
    					{
    						if ( (bull_ptr->y >> 16) > -120)
    						{
    							bull_ptr->on = 0;

  								if ( bull_ptr->ownerType!=E_GUNEMPL )
  								{
  									cgunempl->armour-=bulletDamageVal;
  								}

  								if ( cgunempl->armour <0 )
  								{
  									cgunempl->exist = FALSE;
  									gunemplPos.x = cgunempl->x;
  									gunemplPos.z = cgunempl->z;
  									gunemplPos.y = 0;
  									trigger_explosion(GUN_EMPLACEMENT_EXPLOSION, &gunemplPos, &gunemplPos);

  									enemy_destroyed_sound(E_GUNEMPL, cgunempl->x, cgunempl->z);

										game_data.ngrdtarg_dest++;
  									numObjectiveEnemies--;
  								}
  								else
  									enemy_hit_sound(cgunempl->x, cgunempl->z, bulletDamageVal);

  								bulletHit = TRUE;

  								if ( j&3 )
  								{
  									trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
  								}
    						}
    					}
  					}
						break;




					case GUNBOAT_TAG:
						dboat = *((GUN_BOAT**)lastEnem);

						if ( (bull_ptr->ownerType == GUNBOAT_TAG) && (bull_ptr->owner==(dboat-gunboats)))
						{
							break; /* Don't detect the bullet against gun emplacement thst fired the bullet */
						}


  					relx = dboat->x - bull_ptr->x;
    				relz = dboat->z - bull_ptr->z;

    				if ( (abs(relx)<GUNBOAT_SHELL_SCAN_RANGE) && (abs(relz)<GUNBOAT_SHELL_SCAN_RANGE) )
    				{
    					relx>>=16;
    					relz>>=16;

    					relx *= relx;
    					relz *= relz;

    					/** Check central gunboat radius **/

    					if ( (relx+relz) < GUNBOAT_DETECTION_RADIUS )
    					{
  							bull_ptr->on = FALSE;
  							bulletHit = TRUE;
								damage_gunboat(dboat, bulletDamageVal);

  							if ( j&3 )
  							{
  								trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
  							}
    						break;
    					}

    					cosang = (int)sintab[dboat->angle+512];
    					sinang = (int)sintab[dboat->angle];

    					/** Check bow radius **/

    					relx = dboat->x + (0x500*sinang);
    					relz = dboat->z	+ (0x500*cosang);

    					relx -= bull_ptr->x;
    					relz -= bull_ptr->z;

    					relx >>=16 ;
    					relz >>=16 ;

    					relx *= relx;
    					relz *= relz;

    					if ( (relx+relz) < GUNBOAT_DETECTION_RADIUS )
    					{
    						bull_ptr->on = FALSE;
    						bulletHit = TRUE;
								damage_gunboat(dboat, bulletDamageVal);

  							if ( j&3 )
  							{
  								trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
  							}
    						break;
    					}

    					/** Check stern radius **/

    					relx = dboat->x - (0x400*sinang);
    					relz = dboat->z	- (0x400*cosang);

    					relx -= bull_ptr->x;
    					relz -= bull_ptr->z;

    					relx >>=16 ;
    					relz >>=16 ;

    					relx *= relx;
    					relz *= relz;

    					if ( (relx+relz) < GUNBOAT_DETECTION_RADIUS )
    					{
    						bull_ptr->on = FALSE;
    						bulletHit = TRUE;
								damage_gunboat(dboat, bulletDamageVal);

  							if ( j&3 )
  							{
  								trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
  							}
    					}
    				}

						break;


					case HELI_TAG:
						dtank = *((TANK**)lastEnem);

						rTankMinX = ( rTankMaxX = dtank->x+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);
  					rTankMinZ = ( rTankMaxZ = dtank->z+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);

  					tankxmin = ( tankxmax = dtank->x+0x1000000 ) - 0x2000000;
  					tankzmin = ( tankzmax = dtank->z+0x1000000 ) - 0x2000000;

  					if (
  						 bull_ptr->x >= rTankMinX &&
  						 bull_ptr->x <= rTankMaxX &&
  						 bull_ptr->z >= rTankMinZ &&
  						 bull_ptr->z <= rTankMaxZ )
    				{
    					ohit = nhit = 0;

    					if (bull_ptr->oldx < tankxmin)     	ohit |= 0x0001;
    					else if (bull_ptr->oldx > tankxmax)	ohit |= 0x0010;
    					if (bull_ptr->oldz < tankzmin)     	ohit |= 0x0100;
    					else if (bull_ptr->oldz > tankzmax)	ohit |= 0x1000;

    					if (bull_ptr->x < tankxmin)      	nhit |= 0x0001;
    					else if (bull_ptr->x > tankxmax) 	nhit |= 0x0010;
    					if (bull_ptr->z < tankzmin)      	nhit |= 0x0100;
    					else if (bull_ptr->z > tankzmax) 	nhit |= 0x1000;

    					if (!(ohit & nhit))
    					{
    						if (abs((bull_ptr->y >> 16) - (dtank->y - 112)) < 64)
    						{
    							bull_ptr->on = 0;
  								damage_tank(dtank, bulletDamageVal);
  								bulletHit = TRUE;
    						}
    					}
    				}
						break;
				}



				if ( bulletHit )
				{
					break;
				}

				lastEnem++;
				lastEnemType++;

			}

			if ( bulletHit )
			{
				continue;
			}

			/*-----------------18/10/95 14:13-------------------
			 Early out for bullet detection against walls
			--------------------------------------------------*/

  		tx = (((uint)bull_ptr->x) >>24)&0xff;
  		tz = (((uint)bull_ptr->z) >>24)&0xff;

  		cx = (tx>1) ? tx-2 : 0;
  		cz = (tz>1) ? tz-2 : 0;


  		lx = (tx<254) ? tx+2 : 255;
  		lz = (tz<254) ? tz+2 : 255;

  		tx = cx;

  		bitSet=FALSE;

  		for ( ; cz<=lz; cz++ )
  		{
  			for ( cx=tx; cx<=lx; cx++ )
  			{
  				if ( test_qdt_bit(cx,cz) )
  				{
  					bitSet=TRUE;
  					break;
  				}
  			}

  			if ( bitSet )
  			{
  				break;
  			}
  		}

  		if ( !bitSet )
  		{
  			continue;
  		}


			/** Detect against walls **/

  		mapx = ((((uint)bull_ptr->x) >>16) + (((uint)bull_ptr->oldx) >>16) ) >>1;
  		mapz = ((((uint)bull_ptr->z) >>16) + (((uint)bull_ptr->oldz) >>16) ) >>1;

  		/* Determine range of collision detection */

  		startz = ( (int)(mapz - BULLET_WALL_COLLISION_SCAN_RANGE) <0) ? 0 : (mapz - BULLET_WALL_COLLISION_SCAN_RANGE);

  		startx = ( (int)(mapx - BULLET_WALL_COLLISION_SCAN_RANGE) <0) ? 0 : (mapx - BULLET_WALL_COLLISION_SCAN_RANGE);

  		endz = ( (int)(mapz + BULLET_WALL_COLLISION_SCAN_RANGE) > 0xffff ) ? 0xffff : (mapz + BULLET_WALL_COLLISION_SCAN_RANGE);

  		endx = ( (int)(mapx + BULLET_WALL_COLLISION_SCAN_RANGE) > 0xffff ) ? 0xffff : (mapx + BULLET_WALL_COLLISION_SCAN_RANGE);

  		/* Index into wall list using z range */

  		indsz = startz >> 8;
  		indez = endz >> 8;

  		wallsfound = FALSE;


  		while ( TRUE )
  		{
  			if ( wall_z_index[indsz] != NO_POINTS ) 	/* Find first wall in z range */
  			{
  				cwallmid = wallMids + (n = wall_z_index[indsz]);
  				detwall = wallSfcs + wall_z_index[indsz];
  				wallsfound = TRUE;
  				break;
  			}
  			indsz++;
  			if ( indsz>indez ) 												/* No walls to test against */
  			{
  				break;
  			}
  		}


  		if ( wallsfound ) 													/* Scan through walls in range */
  		{
  			for ( ; n<numSfcs; n++, cwallmid++, detwall++ )
  			{
  				if ( cwallmid->z > endz )								/* Reached end of detection range */
  				break;

  				if ( ((uint)cwallmid->x) >=startx && ((uint)cwallmid->x)<=endx )
  				{
  					/* Wall in scanning range */
  					if ( detwall->wallType == TOTALLED_TEXTURE)
  					{
  						continue;					/* An ignoreable wall */
  					}

  					cWallType = detwall->wallType & WALL_TYPE_MASK;
  					cWallHeight = (detwall->wallType>>WALL_HEIGHT_SHIFT) & WALL_HEIGHT_MASK;
  					cWallTexture = (detwall->wallType >> WALL_TEXTURE_SHIFT) & WALL_TEXTURE_MASK;
  					cDetectType = (cDestroyable = wdetect_info[cWallType].detectType[cWallTexture]) & WALL_DETECT_MASK;
  					cDestroyable&=4;


  					if ( !cDetectType )
  					{
  						continue;					/* An ignoreable wall */
  					}

 						if ( cDetectType==CRUSHABLE_WALL && cWallTexture!=CORRIGATED_FENCE_TEXTURE )
						{
							continue;
						}

						/** ultra frig - bullets ignore these destroyed textures */
						if ( (cWallType==TRANSPARENT_SYMETRICAL_TEXTURE) && (cWallTexture==PESKY_FUCKED_BRIDGE_TEXTURE_1 || cWallTexture==PESKY_FUCKED_BRIDGE_TEXTURE_2))
						{
							continue;
						}

						/** ultra frig - bullets ignore these textures */
						if ( (cWallType==TRANSPARENT_SYMETRICAL_TEXTURE) && (cWallTexture==PESKY_BRIDGE_TEXTURE_1 || cWallTexture==PESKY_BRIDGE_TEXTURE_2))
						{
							continue;
						}

  					if ( bullet_2_wall_detect(detwall, bull_ptr) )
  					{
 							/* destroy bullet */
 							bull_ptr->on = FALSE;
							bulletHit = TRUE;

							if ( cDetectType==CRUSHABLE_WALL )			/** bullet doesn't explode crushable textures **/
							{
								trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
								break;
							}

							if ( cDestroyable )
							{
								short	tempDamage;

								tempDamage = wallHitList[n] & HITVALUE_MASK;
								tempDamage -= bulletDamageVal;

								//wallHitList[n] -= bulletDamageVal;	// damage the wall

								if ( tempDamage > 0 )						// has wall been destroyed ?
								{
									/* Trigger bullet hit fx sprite here */
									if ( j&3 )		// no
									{
										trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
									}

									wallHitList[n] &= (~HITVALUE_MASK);
									wallHitList[n] |= tempDamage;
									break;
								}

								destroy_group(detwall); // wall has been destroyed.
							}
							else
							if ( j&3 )								// trigger spark for indestructible wall
							{
								trigger_fx_sprite(BULLET_HIT_ANIM1+(rand()&3) , bull_ptr->oldx, bull_ptr->oldy>>16, bull_ptr->oldz, FALSE, 0, SMALL_SPRITE, FALSE);
							}
  						break;
  					}

  				}

  			}

  		}

		}

	}

}


/*********************************************************************/

void detect_sams(void)
{
	struct sams *csam;
	int	j;


	for ( j=0, csam = sam; j<MAX_SAMS; j++, csam++ )
	{
		if ( sam->fired )
		{
			dtank = helicopters + csam->index;

			if ( dtank->def && (dtank->def!=REGENERATE_OBJECT) && (dtank->flying))
			{
				rTankMinX = ( rTankMaxX = dtank->x+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);
				rTankMinZ = ( rTankMaxZ = dtank->z+BULLET_SCAN_RANGE ) - (2*BULLET_SCAN_RANGE);

				tankxmin = ( tankxmax = dtank->x+0x1800000 ) - 0x3000000;
				tankzmin = ( tankzmax = dtank->z+0x1800000 ) - 0x3000000;

				if (
					 csam->x >= rTankMinX &&
					 csam->x <= rTankMaxX &&
					 csam->z >= rTankMinZ &&
					 csam->z <= rTankMaxZ )
  			{

 					if (abs((csam->y) - (dtank->y)) < 0x120)
					{
						csam->fired = 0;
						damage_tank(dtank, 0x1000);
					}
  			}
			}
		}
	}
}


/*********************************************************************/
/*********************************************************************/
/*********************************************************************/

/*********************************************************************/
/** Collision detection functions **/
/*********************************************************************/



#define WALL_COLLISION_CONSTANT	0x6a

/***************************************************************/

int	detect_collision(TANK *detectTank, int heightLimit)
{
	WALL_DATA		*detwall;												/* The current wall to test against */
	int			n;
	int			checkValUsed;												/* Flag to show if the point_check_list has to be reset */
	uint		tx,tz,lx,lz,cx,cz;
	uint		bitSet=FALSE;
	int			collisionFlag=FALSE;								/* Assume you don't hit anything */
	ushort	*collWalls;					                /* Pointer to the list of walls that the tank might hit */
	ATTACKING_TANK_DATA *cattackData;
	int			hitWalls=0;

	/* Quick bit test against line of sight map for early out */

	tx = (((uint)detectTank->x) >>24)&0xff;
	tz = (((uint)detectTank->z) >>24)&0xff;

	cx = (tx>2) ? tx-3 : 0;
	cz = (tz>2) ? tz-3 : 0;

	lx = (tx<253) ? tx+3 : 255;
	lz = (tz<253) ? tz+3 : 255;

	tx = cx;

	for ( ; cz<=lz; cz++ )
	{
		for ( cx=tx; cx<=lx; cx++ )
		{
			if ( test_qdt_bit(cx,cz) )
			{
				bitSet=TRUE;
				break;
			}
		}

		if ( bitSet )
		{
			break;
		}
	}

	if ( bitSet==FALSE )
	{
		detectTank->possWallCollisions=currentIgnoreValue;		/* Nothing in immediate range - don't have to check on next pass */
		return (FALSE);
	}

	cattackData = detectTank->collData;

	if ( cattackData==NULL ) 																/* If tank has no attack detection data then return */
	{
		return (FALSE);
	}

	collWalls = detectTank->collData->walls;
	cattackData->numWalls = 0;

	mapx = ((uint)detectTank->x) >>16;
	mapz = ((uint)detectTank->z) >>16;

	/* Determine range of collision detection */

	startz = ( (int)(mapz - WALL_COLLISION_DETECT_RANGE) <0) ? 0 : (mapz - WALL_COLLISION_DETECT_RANGE);

	startx = ( (int)(mapx - WALL_COLLISION_DETECT_RANGE) <0) ? 0 : (mapx - WALL_COLLISION_DETECT_RANGE);

	endz = ( (int)(mapz + WALL_COLLISION_DETECT_RANGE) > 0xffff ) ? 0xffff : (mapz + WALL_COLLISION_DETECT_RANGE);

	endx = ( (int)(mapx + WALL_COLLISION_DETECT_RANGE) > 0xffff ) ? 0xffff : (mapx + WALL_COLLISION_DETECT_RANGE);

	/* Get the ratios for rotating points about the object */

	cosang = (int)sintab[detectTank->angle+512];
	sinang = (int)sintab[detectTank->angle];


	/* Index in to wall list using z range */

	indsz = startz >> 8;
	indez = endz >> 8;



	while ( TRUE )
	{
		if ( wall_z_index[indsz] != NO_POINTS ) 	/* Find first wall in z range */
		{
			cwallmid = wallMids + (n = wall_z_index[indsz]);
			detwall = wallSfcs + wall_z_index[indsz];
			break;
		}
		indsz++;
		if ( indsz>indez ) 												/* No walls to test against */
		{
			detectTank->possWallCollisions = currentIgnoreValue;
			return (FALSE);
		}
	}




	/* Scan walls in range for collisions */

	checkValUsed = FALSE;

	for ( ; n<numSfcs; n++, cwallmid++, detwall++ )
	{
		if ( cwallmid->z > endz )									/* Reached end of detection range */
			break;

		if ( ((uint)cwallmid->x) >=startx && ((uint)cwallmid->x)<=endx )
		{
			if ( detwall->wallType == TOTALLED_TEXTURE)
			{
				continue;					/* An ignoreable wall */
			}

			cWallType = detwall->wallType & WALL_TYPE_MASK;
			cWallTexture = (detwall->wallType >> WALL_TEXTURE_SHIFT ) & WALL_TEXTURE_MASK;
			cDetectType = wdetect_info[cWallType].detectType[cWallTexture] & WALL_DETECT_MASK;
			cWallHeight = (detwall->wallType >> WALL_HEIGHT_SHIFT ) & WALL_HEIGHT_MASK;

			if ( !cDetectType )
			{
				continue;					/* An ignoreable wall */
			}

			checkValUsed = TRUE;

			if ( heightLimit!=NULL_ID )
			{
				if ( cWallHeight < heightLimit )
				{
					continue;
				}
			}


			if ( cattackData->numWalls < MAX_DETECT_WALLS )
			{
				cattackData->numWalls++;
				*collWalls++ = n;				/* Record id of possible collision wall for next pass */
			}

			/* Deal with possible crushable textures */

			if ( cDetectType==CRUSHABLE_WALL )
			{
				sizez = sizex = objectDetectSizes[detectTank->def];

				if ( simple_detect_against_wall(detwall) )
				{
					/* Slow down the tank */

					detectTank->speed>>=1;
					crush_texture(detwall);

					if ( detectTank->def==PLAYER_TANK )
					{
						play_fence_crunch_sound();
					}

				}
				continue;
			}
			else
			{
				sizez = sizex = objectDetectSizes[detectTank->def] + WALL_COLLISION_CONSTANT;
			}

			if ( detect_against_wall(detwall, detectTank) ) 			/* Only ever need to know about one wall */
			{
				collisionFlag = TRUE;
				hitWalls++;

				if(hitWalls>=3)
					break;
			}
		}
	}

	if ( checkValUsed )
	{
		reset_point_check_list();
	}

	return (collisionFlag);
}


/***************************************************************/


int	detect_helicopter_collision(TANK *detHeli, int heightLimit)
{
	WALL_DATA		*detwall;												/* The current wall to test against */
	int			n;
	int			checkValUsed;												/* Flag to show if the point_check_list has to be reset */
	uint		tx,tz,lx,lz,cx,cz;
	uint		bitSet=FALSE;
	int			collisionFlag=FALSE;								/* Assume you don't hit anything */

	/* Quick bit test against line of sight map for early out */

	tx = (((uint)detHeli->x) >>24)&0xff;
	tz = (((uint)detHeli->z) >>24)&0xff;

	cx = (tx>1) ? tx-2 : 0;
	cz = (tz>1) ? tz-2 : 0;


	lx = (tx<254) ? tx+2 : 255;
	lz = (tz<254) ? tz+2 : 255;

	tx = cx;

	for ( ; cz<=lz; cz++ )
	{
		for ( cx=tx; cx<=lx; cx++ )
		{
			if ( test_qdt_bit(cx,cz) )
			{
				bitSet=TRUE;
				break;
			}
		}

		if ( bitSet )
		{
			break;
		}
	}


	if ( bitSet==FALSE )
	{
		return (FALSE);
	}

	mapx = ((uint)detHeli->x) >>16;
	mapz = ((uint)detHeli->z) >>16;

	/* Determine range of collision detection */

	startz = ( (int)(mapz - WALL_COLLISION_DETECT_RANGE) <0) ? 0 : (mapz - WALL_COLLISION_DETECT_RANGE);

	startx = ( (int)(mapx - WALL_COLLISION_DETECT_RANGE) <0) ? 0 : (mapx - WALL_COLLISION_DETECT_RANGE);

	endz = ( (int)(mapz + WALL_COLLISION_DETECT_RANGE) > 0xffff ) ? 0xffff : (mapz + WALL_COLLISION_DETECT_RANGE);

	endx = ( (int)(mapx + WALL_COLLISION_DETECT_RANGE) > 0xffff ) ? 0xffff : (mapx + WALL_COLLISION_DETECT_RANGE);

	/* Get the ratios for rotating points about the object */

	cosang = (int)sintab[detHeli->angle+512];
	sinang = (int)sintab[detHeli->angle];


	/* Index in to wall list using z range */

	indsz = startz >> 8;
	indez = endz >> 8;



	while ( TRUE )
	{
		if ( wall_z_index[indsz] != NO_POINTS ) 	/* Find first wall in z range */
		{
			cwallmid = wallMids + (n = wall_z_index[indsz]);
			detwall = wallSfcs + wall_z_index[indsz];
			break;
		}
		indsz++;
		if ( indsz>indez ) 												/* No walls to test against */
		{
			detHeli->possWallCollisions = currentIgnoreValue;
			return (FALSE);
		}
	}




	/* Scan walls in range for collisions */

	checkValUsed = FALSE;

	for ( ; n<numSfcs; n++, cwallmid++, detwall++ )
	{
		if ( cwallmid->z > endz )									/* Reached end of detection range */
			break;

		if ( ((uint)cwallmid->x) >=startx && ((uint)cwallmid->x)<=endx )
		{
			if ( detwall->wallType == TOTALLED_TEXTURE)
			{
				continue;					/* An ignoreable wall */
			}

			cWallType = detwall->wallType & WALL_TYPE_MASK;
			cWallTexture = (detwall->wallType >> WALL_TEXTURE_SHIFT) & WALL_TEXTURE_MASK;
			cDetectType = wdetect_info[cWallType].detectType[cWallTexture] & WALL_DETECT_MASK;
			cWallHeight = (detwall->wallType >> WALL_HEIGHT_SHIFT) & WALL_HEIGHT_MASK;

			if ( !cDetectType )
			{
				continue;					/* An ignoreable wall */
			}

			checkValUsed = TRUE;

			if ( heightLimit!=NULL_ID )
			{
				if ( cWallHeight < heightLimit )
				{
					continue;
				}
			}

			/* Deal with possible crushable textures */

			if ( cDetectType==CRUSHABLE_WALL )
			{
				sizez = sizex = objectDetectSizes[detHeli->def];

				if ( simple_detect_against_wall(detwall) )
				{
					/* Slow down the tank */

					detHeli->speed>>=1;
					crush_texture(detwall);
					play_fence_crunch_sound();
				}
				continue;
			}
			else
			{
				sizez = sizex = objectDetectSizes[detHeli->def] + WALL_COLLISION_CONSTANT;
			}

			if ( detect_against_wall(detwall, detHeli) ) 			/* Only ever need to know about one wall */
			{
				collisionFlag = TRUE;
				break;
			}
		}
	}


	if ( checkValUsed )
	{
		reset_point_check_list();
	}

	return (collisionFlag);
}




/***************************************************************/

int	second_detect_collision(TANK *detectTank, int heightLimit)
{
	WALL_DATA		*detwall;												/* The current wall to test against */
	int			n;
	int			checkValUsed;												/* Flag to show if the point_check_list has to be reset */
	int			collisionFlag=FALSE;								/* Assume you don't hit anything */
	ushort	*collWalls;					                /* Pointer to the list of walls that the tank might hit */
	ATTACKING_TANK_DATA *cattackData;


	if ( detectTank->possWallCollisions==currentIgnoreValue )	/*If tank wasn't in rang of any walls on previuos pass - it wont be know */
	{
		return (FALSE);
	}


	cattackData = detectTank->collData;

	if ( cattackData==NULL ) 										/* NO ATTACK DATA TO DETECT AGAINST */
	{
		return (FALSE);
	}

	collWalls = detectTank->collData->walls;

	mapx = ((uint)detectTank->x) >>16;
	mapz = ((uint)detectTank->z) >>16;


	/* Scan possible collide walls */

	checkValUsed = FALSE;

	for ( n=0; n<cattackData->numWalls; n++, collWalls++ )
	{
		cwallmid = wallMids + *collWalls;
		detwall = wallSfcs + *collWalls;


		if ( cwallmid->z > endz )									/* Reached end of detection range */
			break;

		if ( ((uint)cwallmid->x) >=startx && ((uint)cwallmid->x)<=endx )
		{
			if ( detwall->wallType == TOTALLED_TEXTURE)
			{
				continue;					/* An ignoreable wall */
			}

			cWallType = detwall->wallType & WALL_TYPE_MASK;
			cWallTexture = (detwall->wallType >> WALL_TEXTURE_SHIFT) & WALL_TEXTURE_MASK;
			cDetectType = wdetect_info[cWallType].detectType[cWallTexture] & WALL_DETECT_MASK;
			cWallHeight = (detwall->wallType>>WALL_HEIGHT_SHIFT) & WALL_HEIGHT_MASK;

			if ( !cDetectType )
			{
				continue;					/* An ignoreable wall */
			}

			checkValUsed = TRUE;

			if ( heightLimit!=NULL_ID )
			{
				if ( cWallHeight < heightLimit )
				{
					continue;
				}
			}


			/* Deal with possible crushable textures */

			if ( cDetectType==CRUSHABLE_WALL )
			{
				sizez = sizex = objectDetectSizes[detectTank->def];

				if ( simple_detect_against_wall(detwall) )
				{
					/* Slow down the tank */

					detectTank->speed>>=1;
					crush_texture(detwall);
					if ( detectTank->def==PLAYER_TANK )
					{
						play_fence_crunch_sound();
					}
				}
				continue;
			}
			else
			{
				sizez = sizex = objectDetectSizes[detectTank->def] + WALL_COLLISION_CONSTANT;
			}

			if ( detect_against_wall(detwall, detectTank) ) 			/* Only ever need to know about one wall */
			{
				collisionFlag = TRUE;
				break;
			}
		}
	}

	if ( checkValUsed )
	{
		reset_point_check_list();
	}

	return (collisionFlag);
}











/*****************************************************************/
/* After the initial range test walls are tested against a radius */

int	detect_against_wall(WALL_DATA *detectwall, TANK *detectTank)
{
	char	*pointCheck;  														/* Used to check if point has already been rotated */
	WORKING_POINT	*w1, *w2;
	int	tx,tz,rx,rz;
	int	clip1, clip2;
	int	d2;																					/* squared terms */
	int	signz1, signz2;



	/* Find out if the first point has already been rotated */
	pointCheck=workPointsCheck + detectwall->p1;

	w1 = workPoints + detectwall->p1;

	/* If it hasn't then rotate it */
	if ( *pointCheck != currentCheckVal)
	{
		*pointCheck = currentCheckVal;

		tx =((uint)((wallPoints + detectwall->p1)->x)) - mapx;
		tz =((uint)((wallPoints + detectwall->p1)->z)) - mapz;

		rx =((int)(tx*cosang - tz*sinang)) >>15;
		rz =((int)(tz*cosang + tx*sinang)) >>15;

		w1->x = rx;
		w1->z = rz;
	}

	/* Find out if the second point has already been rotated */
	pointCheck=workPointsCheck + detectwall->p2;

	w2 = workPoints + detectwall->p2;


	/* If it hasn't then rotate it */
	if ( *pointCheck != currentCheckVal)
	{
		*pointCheck = currentCheckVal;

		tx =((uint)((wallPoints + detectwall->p2)->x)) - mapx;
		tz =((uint)((wallPoints + detectwall->p2)->z)) - mapz;

		rx =((int)(tx*cosang - tz*sinang)) >>15;
		rz =((int)(tz*cosang + tx*sinang)) >>15;

		w2->x = rx;
		w2->z = rz;
	}



	/* Coarse clipping test for possible collisions */

	clip1=clip2=0;

	if (w1->x < -sizex) clip1 |= 	LEFT_BOUNDARY;			/* left */
	if (w1->x > sizex) clip1 	|= 	RIGHT_BOUNDARY; 		/* right */
	if (w1->z > sizez) clip1 	|= 	BOTTOM_BOUNDARY; 		/* bottom */
	if (w1->z < -sizez) clip1 |= 	TOP_BOUNDARY; 			/* top */

	if (w2->x < -sizex) clip2 |= 	LEFT_BOUNDARY;
	if (w2->x > sizex) clip2 	|= 	RIGHT_BOUNDARY;
	if (w2->z > sizez) clip2 	|= 	BOTTOM_BOUNDARY;
	if (w2->z < -sizez) clip2 |= 	TOP_BOUNDARY;



	if ((clip1 & clip2) == 0)
	{
		/* First check if either of the points are within tank radius */

		d2 = (w1->x * w1->x) + (w1->z * w1->z);

		if ( d2 <= detectTank->sqrWallDetval )
		{
			return(TRUE);
		}

		d2 = (w2->x * w2->x) + (w2->z * w2->z);

		if ( d2 <= detectTank->sqrWallDetval )
		{
			return(TRUE);
		}




		/* Check for orthogonal walls first */

		if ( (w1->x - w2->x)==0 ) /* Wall parallel to side of tank */
		{
			if ( (w1->x >= -objectDetectSizes[detectTank->def]) && (w1->x <= objectDetectSizes[detectTank->def]) )
			{
				return (TRUE);
			}
		}


		if ( (w1->z - w2->z)==0 ) /* Wall parallel to front/back of tank */
		{
			if ( (w1->z >= -objectDetectSizes[detectTank->def]) && (w1->z <= objectDetectSizes[detectTank->def]) )
			{
				return (TRUE);
			}
		}


		/* Deal with non orthogonal walls */

		relp[0].x = ((uint)((wallPoints + detectwall->p1)->x)) - mapx;
		relp[0].z = ((uint)((wallPoints + detectwall->p1)->z)) - mapz;

		relp[1].x = ((uint)((wallPoints + detectwall->p2)->x)) - mapx;
		relp[1].z = ((uint)((wallPoints + detectwall->p2)->z)) - mapz;


		lineangle = phd_atan(relp[0].x-relp[1].x, relp[0].z-relp[1].z);

  	dcosang = (int)sintab[lineangle+512];
  	dsinang = (int)sintab[lineangle];

  	rotp[0].x =((int)(relp[0].x*dcosang - relp[0].z*dsinang)) >>15;
		rotp[0].z =((int)(relp[0].z*dcosang + relp[0].x*dsinang)) >>15;

		rotp[1].z =((int)(relp[1].z*dcosang + relp[1].x*dsinang)) >>15;

		signz1 = (rotp[0].z>0) ? 1 : -1;
		signz2 = (rotp[1].z>0) ? 1 : -1;

		if ( ((signz1+signz2)==0) && (abs(rotp[0].x)<=objectDetectSizes[detectTank->def]))
		{
			/* Within collision radius */
			return (TRUE);
		}
	}

	return (FALSE);
}









/*****************************************************************/



int	simple_detect_against_wall(WALL_DATA *detectwall)
{
	int	clip1, clip2, clipval;
	char	*pointCheck;  											/* Used to check if point has already been rotated */
	WORKING_POINT	*w1, *w2, *point1;
	int	collided;
	int	dx,dz;
	int	clx,clz;
	int	tx,tz,rx,rz;


	/* Find out if the first point has already been rotated */
	pointCheck=workPointsCheck + detectwall->p1;

	w1 = workPoints + detectwall->p1;

	/* If it hasn't then rotate it */
	if ( *pointCheck != currentCheckVal)
	{
		*pointCheck = currentCheckVal;

		tx =((uint)((wallPoints + detectwall->p1)->x)) - mapx;
		tz =((uint)((wallPoints + detectwall->p1)->z)) - mapz;

		rx =((int)(tx*cosang - tz*sinang)) >>15;
		rz =((int)(tz*cosang + tx*sinang)) >>15;

		w1->x = rx;
		w1->z = rz;
	}



	/* Find out if the second point has already been rotated */
	pointCheck=workPointsCheck + detectwall->p2;

	w2 = workPoints + detectwall->p2;

	/* If it hasn't then rotate it */
	if ( *pointCheck != currentCheckVal)
	{
		*pointCheck = currentCheckVal;

		tx =((uint)((wallPoints + detectwall->p2)->x)) - mapx;
		tz =((uint)((wallPoints + detectwall->p2)->z)) - mapz;

		rx =((int)(tx*cosang - tz*sinang)) >>15;
		rz =((int)(tz*cosang + tx*sinang)) >>15;

		w2->x = rx;
		w2->z = rz;
	}

	clip1=clip2=0;

	if (w1->x < -sizex) clip1 |= 	LEFT_BOUNDARY;	/* left */
	if (w1->x > sizex) clip1 	|= 	RIGHT_BOUNDARY; /* right */
	if (w1->z > sizez) clip1 	|= 	BOTTOM_BOUNDARY; /* bottom */
	if (w1->z < -sizez) clip1 |= 	TOP_BOUNDARY; /* top */

	if (w2->x < -sizex) clip2 |= 	LEFT_BOUNDARY;
	if (w2->x > sizex) clip2 	|= 	RIGHT_BOUNDARY;
	if (w2->z > sizez) clip2 	|= 	BOTTOM_BOUNDARY;
	if (w2->z < -sizez) clip2 |= 	TOP_BOUNDARY;

	collided = ((clip1 & clip2) == 0);

	if ( collided )
	{
		dx = w2->x - w1->x;
		dz = w2->z - w1->z;



		/* Deal separately with walls which area orthoganol to tank sides */

 		if ( dx==0 || dz==0 )
 		{
 			if ( dx==0 )
 			{
 				dx=1;
 			}

 			if ( dz==0 )
 			{
 				dz=1;
 			}
 		}


		if ( (clip1 | clip2) == 0) 						/* Both points inside the tank area */
		{
			return(TRUE);
		}



		/* Deal with walls which are not orthoganol */

		/* Point one inside area ? */
		if ( w1->x>=-sizex && w1->x<=sizex && w1->z>=-sizez && w1->z<=sizez)
		{
			point1 = w2;
			clipval = clip2;
  	}
		else
		{
			point1 = w1;
			clipval = clip1;
		}

		collided = FALSE;


		if ( clipval & LEFT_BOUNDARY ) 								/* Clip against left boundary */
		{
 			clx = -sizex - point1->x;
 			clz	= (clx*dz)/dx;
			clz += point1->z;

			if ( clz>=-sizez && clz<=sizez )
			{
				collided = TRUE;
			}
		}
		else
		if ( clipval & RIGHT_BOUNDARY )								/* clip against right boundary */
		{
			clx = sizex - point1->x;
			clz	= (clx*dz)/dx;
			clz += point1->z;
			if ( clz>=-sizez && clz<=sizez )
			{
				collided = TRUE;
			}
		}
		else
		if ( clipval & BOTTOM_BOUNDARY )						 	/* Clip against bottom boundary */
		{
			clz = sizez - point1->z;
			clx = (clz*dx)/dz;
			clx += point1->x;
			if ( clx>=-sizex && clx<=sizex )
			{
				collided = TRUE;
			}
		}
		else
		if ( clipval & TOP_BOUNDARY )									/* clip against top boundary */
		{
			clz = -sizez - point1->z;
			clx = (clz*dx)/dz;
			clx += point1->x;
			if ( clx>=-sizex && clx<=sizex )
			{
				collided = TRUE;
			}
		}
	}

	return ( collided );
}


/***************************************************************/

enum { SHELL_START, SHELL_END, WALLPT1, WALLPT2 };



int	shell_2_wall_detect(WALL_DATA *detwall)
{
	int	n;
	int	dwx, dwy, dcx, iy;
	int	minwallx, minwally, maxwallx;
	int	shellxmin, shellxmax, shellzmin, shellzmax;
	POINT	pt[4], relp[4], rotp[4], rcolp, offp;
	POINT	*pta, *ptb;
	int	trajangle;

#ifdef IGNORE_COLLISION_DETECTION
return (FALSE);
#endif

	/* Calculations */

	ohit = nhit = 0;

	pt[SHELL_START].x = (uint)dshell->ox>>16;
	pt[SHELL_START].z = (uint)dshell->oz>>16;

	pt[SHELL_END].x 	= (uint)dshell->x>>16;
	pt[SHELL_END].z 	= (uint)dshell->z>>16;

	pt[WALLPT1].x 		= (uint)((wallPoints +detwall->p1)->x);
	pt[WALLPT1].z 		= (uint)((wallPoints +detwall->p1)->z);

	pt[WALLPT2].x 		= (uint)((wallPoints +detwall->p2)->x);
	pt[WALLPT2].z 		= (uint)((wallPoints +detwall->p2)->z);

	pta = pt+SHELL_START;
	ptb = pt+SHELL_END;

	shellxmin = min(pta->x, ptb->x);
	shellxmax = max(pta->x, ptb->x);

	shellzmin = min(pta->z, ptb->z);
	shellzmax = max(pta->z, ptb->z);


	/* Do trivial discard clipping test */

	pta = pt+WALLPT1;

	if ( pta->x < shellxmin ) ohit |= LEFT_BOUNDARY;
	if ( pta->x > shellxmax ) ohit |= RIGHT_BOUNDARY;
	if ( pta->z < shellzmin ) ohit |= BOTTOM_BOUNDARY;
	if ( pta->z > shellzmax ) ohit |= TOP_BOUNDARY;

	pta = pt+WALLPT2;

	if ( pta->x < shellxmin ) nhit |= LEFT_BOUNDARY;
	if ( pta->x > shellxmax ) nhit |= RIGHT_BOUNDARY;
	if ( pta->z < shellzmin ) nhit |= BOTTOM_BOUNDARY;
	if ( pta->z > shellzmax ) nhit |= TOP_BOUNDARY;



	if ( (ohit & nhit)==0 )
	{
		/* Can't trivially discard - further tests */

		/* Get start point of trajectory */

		offp = pt[SHELL_START];

		for ( n=0, pta=&(pt[0]), ptb=&(relp[0]); n<4; n++, pta++, ptb++ )
		{
			ptb->x = pta->x - offp.x;
			ptb->z = pta->z - offp.z;
		}

		trajangle = phd_atan(relp[SHELL_START].x-relp[SHELL_END].x, relp[SHELL_START].z-relp[SHELL_END].z);

		dcosang = (int)sintab[trajangle+512];
  	dsinang = (int)sintab[trajangle];

		for ( n=0, pta=&(relp[0]), ptb=&(rotp[0]); n<4; n++, pta++, ptb++ )
		{
			ptb->x = ((int)(pta->x*dcosang - pta->z*dsinang)) >>15;
			ptb->z = ((int)(pta->z*dcosang + pta->x*dsinang)) >>15;
		}

		dwx = rotp[WALLPT2].x - rotp[WALLPT1].x;
		dwy = rotp[WALLPT2].z - rotp[WALLPT1].z;

		/* Wall is orthogonal to the trajectory */

		if ( dwy==0 )
		{
			if ( rotp[WALLPT1].z <= rotp[SHELL_END].z )
			{
				return(TRUE);
			}
			return (FALSE);
		}

		/* Wall is parallel to trajectory */

		if ( dwx==0 )
		{
			if ( rotp[WALLPT1].z <= rotp[SHELL_END].z )
			{
				return(TRUE);
			}
			return (FALSE);
		}

		/* Wall is at a non-othogonal angle */

		if ( rotp[WALLPT1].x < rotp[WALLPT2].x )
		{
			minwallx = rotp[WALLPT1].x;
			maxwallx = rotp[WALLPT2].x;
			minwally = rotp[WALLPT1].z;
			dwx = maxwallx - minwallx;
			dwy = rotp[WALLPT2].z - rotp[WALLPT1].z;
		}
		else
		{
			minwallx = rotp[WALLPT2].x;
			maxwallx = rotp[WALLPT1].x;
			minwally = rotp[WALLPT2].z;
			dwx = maxwallx - minwallx;
			dwy = rotp[WALLPT1].z - rotp[WALLPT2].z;
		}

		dcx = -minwallx;


		if ( (minwallx  < 0) && (maxwallx  > 0)  )
		{
			iy = minwally + ((dwy * dcx)/dwx);

			if ( iy < 0 )
			{
				return (FALSE);
			}

			if ( iy<=rotp[SHELL_END].z )
			{
				if ( cDetectType==CRUSHABLE_WALL )
				{
					return (TRUE);
				}

				rcolp.x = 0;
				rcolp.z = iy-0x180;

				/* Set position of shell to just before the impact point - quite a bit before */

				dshell->x = ((((int)(rcolp.x*dcosang + rcolp.z*dsinang)) >>15) + offp.x) <<16;
				dshell->z = ((((int)(rcolp.z*dcosang - rcolp.x*dsinang)) >>15) + offp.z) <<16;

				return (TRUE);
			}
		}
	}
	return (FALSE);
}


/**************************************************************/


int	bullet_2_wall_detect(WALL_DATA *detwall, struct bullets *cbull)
{
	int	n;
	int	dwx, dwy, dcx, iy;
	int	minwallx, minwally, maxwallx;
	int	shellxmin, shellxmax, shellzmin, shellzmax;
	POINT	pt[4], relp[4], rotp[4], rcolp, offp;
	POINT	*pta, *ptb;
	int	trajangle;

	/* Calculations */

	ohit = nhit = 0;

	pt[SHELL_START].x = (uint)cbull->oldx>>16;
	pt[SHELL_START].z = (uint)cbull->oldz>>16;

	pt[SHELL_END].x 	= (uint)cbull->x>>16;
	pt[SHELL_END].z 	= (uint)cbull->z>>16;

	pt[WALLPT1].x 		= (uint)((wallPoints +detwall->p1)->x);
	pt[WALLPT1].z 		= (uint)((wallPoints +detwall->p1)->z);

	pt[WALLPT2].x 		= (uint)((wallPoints +detwall->p2)->x);
	pt[WALLPT2].z 		= (uint)((wallPoints +detwall->p2)->z);


	pta = pt+WALLPT1;
	ptb = pt+WALLPT2;

	shellxmin = min(pta->x, ptb->x);
	shellxmax = max(pta->x, ptb->x);

	shellzmin = min(pta->z, ptb->z);
	shellzmax = max(pta->z, ptb->z);


	/* Do trivial discard clipping test */

	pta = pt+SHELL_START;

	if ( pta->x < shellxmin ) ohit |= LEFT_BOUNDARY;
	if ( pta->x > shellxmax ) ohit |= RIGHT_BOUNDARY;
	if ( pta->z < shellzmin ) ohit |= BOTTOM_BOUNDARY;
	if ( pta->z > shellzmax ) ohit |= TOP_BOUNDARY;

	pta = pt+SHELL_END;

	if ( pta->x < shellxmin ) nhit |= LEFT_BOUNDARY;
	if ( pta->x > shellxmax ) nhit |= RIGHT_BOUNDARY;
	if ( pta->z < shellzmin ) nhit |= BOTTOM_BOUNDARY;
	if ( pta->z > shellzmax ) nhit |= TOP_BOUNDARY;



	if ( (ohit & nhit)==0 )
	{
		/* Can't trivially discard - further tests */

		/* Get start point of trajectory */

		offp = pt[SHELL_START];

		for ( n=0, pta=&(pt[0]), ptb=&(relp[0]); n<4; n++, pta++, ptb++ )
		{
			ptb->x = pta->x - offp.x;
			ptb->z = pta->z - offp.z;
		}

		trajangle = phd_atan(relp[SHELL_START].x-relp[SHELL_END].x, relp[SHELL_START].z-relp[SHELL_END].z);

		dcosang = (int)sintab[trajangle+512];
  	dsinang = (int)sintab[trajangle];

		for ( n=0, pta=&(relp[0]), ptb=&(rotp[0]); n<4; n++, pta++, ptb++ )
		{
			ptb->x = ((int)(pta->x*dcosang - pta->z*dsinang)) >>15;
			ptb->z = ((int)(pta->z*dcosang + pta->x*dsinang)) >>15;
		}

		dwx = rotp[WALLPT2].x - rotp[WALLPT1].x;
		dwy = rotp[WALLPT2].z - rotp[WALLPT1].z;

		/* Wall is orthogonal to the trajectory */

		if ( dwy==0 )
		{
			if ( rotp[WALLPT1].z <= rotp[SHELL_END].z )
			{
				return(TRUE);
			}
			return (FALSE);
		}

		/* Wall is parallel to trajectory */

		if ( dwx==0 )
		{
			if ( rotp[WALLPT1].z <= rotp[SHELL_END].z )
			{
				return(TRUE);
			}
			return (FALSE);
		}

		/* Wall is at a non-othogonal angle */

		if ( rotp[WALLPT1].x < rotp[WALLPT2].x )
		{
			minwallx = rotp[WALLPT1].x;
			maxwallx = rotp[WALLPT2].x;
			minwally = rotp[WALLPT1].z;
			dwx = maxwallx - minwallx;
			dwy = rotp[WALLPT2].z - rotp[WALLPT1].z;
		}
		else
		{
			minwallx = rotp[WALLPT2].x;
			maxwallx = rotp[WALLPT1].x;
			minwally = rotp[WALLPT2].z;
			dwx = maxwallx - minwallx;
			dwy = rotp[WALLPT1].z - rotp[WALLPT2].z;
		}

		dcx = -minwallx;

		if ( (minwallx  < 0) && (maxwallx  > 0)  )
		{
			iy = minwally + ((dwy * dcx)/dwx);

			if ( iy < 0 )
			{
				return (FALSE);
			}

			if ( iy<=rotp[SHELL_END].z )
			{
				rcolp.x = 0;
				rcolp.z = iy-0x180;

				/* Set position of shell to just before the impact point - quite a bit before */

				cbull->x = ((((int)(rcolp.x*dcosang + rcolp.z*dsinang)) >>15) + offp.x) <<16;
				cbull->z = ((((int)(rcolp.z*dcosang - rcolp.x*dsinang)) >>15) + offp.z) <<16;

				return (TRUE);
			}
		}
	}
	return (FALSE);
}




void	check_asms(void)
{
	int	n,j;
	TANK *dtank;
	ASM	*casm;
	int	relx,relz;
	int	detectionSize;
	int	hitobj;

	for ( n=0, casm=asms; n<MAX_ASMS; n++, casm++ )
	{
		if ( casm->fired )
		{
			if ( casm->y >=0 ) // hit the deck - destroy the asm
			{
				casm->fired = FALSE;
				trigger_explosion(SHELL_GROUND_EXPLOSION, (POSITION*)&(casm->x), NULL);
				asmsAlive--;		// reduce the number of asms left to control
			}

			/** check through the enemy tank list **/

			if ( casm->y >=-0x100 )
			{
				for ( j=0, dtank=enemyTanks; j<MAX_ENEMY_TANKS; j++, dtank++ )
				{
					/* Check if tank exists */
					if ( dtank->def && dtank->def!=REGENERATE_OBJECT )
					{
						detectionSize = (objectDetectSizes[dtank->def])<<16;

						relx = dtank->x - casm->x;
						relz = dtank->z - casm->z;

						/* Check if tank is in range for possible collision */
						if ( (abs(relx)<=SHELL_TANK_COLLISION_SCAN_RANGE) && (abs(relz)<=SHELL_TANK_COLLISION_SCAN_RANGE) )
						{
							tankxmin = ( tankxmax = dtank->x+detectionSize ) - (detectionSize<<1);
							tankzmin = ( tankzmax = dtank->z+detectionSize ) - (detectionSize<<1);

							ohit = nhit = 0;

							if (casm->ox < tankxmin) ohit |= 	LEFT_BOUNDARY;
							if (casm->ox > tankxmax) ohit |= 	RIGHT_BOUNDARY;
							if (casm->oz < tankzmin) ohit |= 	BOTTOM_BOUNDARY;
							if (casm->oz > tankzmax) ohit |= 	TOP_BOUNDARY;

							if (casm->x < tankxmin) nhit |= 	LEFT_BOUNDARY;
							if (casm->x > tankxmax) nhit |= 	RIGHT_BOUNDARY;
							if (casm->z < tankzmin) nhit |= 	BOTTOM_BOUNDARY;
							if (casm->z > tankzmax) nhit |= 	TOP_BOUNDARY;

							if ( (ohit & nhit)==0  )
							{
								casm->fired = 0;
								damage_tank(dtank, 0x1000);		// make sure it gets destroyed
								trigger_explosion(SHELL_HIT_EXPLOSION, (POSITION*)&(casm->x), (POSITION*)&(dtank->x));
								asmsAlive--;
								hitobj=TRUE;
								break;
							}
						}
					}
				}
			}
		}
	}
}



/*********************************************************************/
/*********************************************************************/
/*********************************************************************/

/*********************************************************************/
/** General routines/functions associated with collision detection **/
/*********************************************************************/


void	damage_tank(TANK *damagedTank, int	damageVal )
{
	int	explosionDamage=FALSE;

	#ifdef PC_VERSION
	if ( ignoreHits && damagedTank==&pl)
	{
		return ;
	}
	#else
	if ( cheat_flag && damagedTank==&pl)
	{
		return ;
	}
	#endif

	if ( damageVal<0 )
	{
		damageVal=-damageVal;
		explosionDamage=TRUE;
	}

	damagedTank->armour -= damageVal;

	if ( damagedTank->armour < 0 )
	{
  	if ( damagedTank->def == PLAYER_TANK )
  	{
			/* Destroy the player tank */
  		set_exit_game(ENDGAME_KILLED);
			objectiveAchieved=0;
  	}
  	else
  	{
			/*Destroy the enemy tank */

			if ( (damagedTank->def == E_HELICOPTER) ||  (damagedTank->def == E_GUNSHIP) )
			{
	   		trigger_explosion(HELI_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(damagedTank->x));
			}
			else
				trigger_explosion(TANK_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(damagedTank->x));

 			destroy_tank(damagedTank);
			enemy_destroyed_sound(damagedTank->def, damagedTank->x, damagedTank->z);
  	}
	}
	else
	{
  	if ( damagedTank->def == PLAYER_TANK )
  	{
			/* Update control panel */
  		draw_armour_display();


			if ( damageVal > 0x20 )										/* D TOUR ADMONITION */
			{
				if ( !start_message(DTOUR_MSG1) )
				{
					if ( !start_message(DTOUR_MSG3) )
						start_message(DTOUR_MSG4);
				}
			}

			if ( !explosionDamage )
			{
				player_hit_sound(damageVal);
			}

			if ( (damageVal>0x40) )
			{
				start_flash(VBRIGHT_FLASH);
			}
  	}
		else
			enemy_hit_sound(damagedTank->x, damagedTank->z, damageVal);

		/* Shunt tank along trajectory of shell */

		if ( (damagedTank->y > -10) && damageVal>0x20 )
		{
			damagedTank->yvel = -32;
		}
	}
}





/*****************************************************************/



void	generate_z_index(void)
{
	int	z,n;


	cwallmid = (POINT_DATA*)wallMids;

	memset(wall_z_index, 0xff, sizeof(ushort)*256);

	for ( n=0,z=0; n<numSfcs; n++, cwallmid++ )
	{
		if ( cwallmid->z > (z<<8) )
		{

			z=cwallmid->z>>8;
			if ( wall_z_index[z]==0xffff )
			{
				wall_z_index[z] = n;
			}
		}
	}
}


/*****************************************************************/



#define PYLON_TEXTURE			0x52


void	destroy_group(WALL_DATA *grpWall)
{
	int		i;
	ushort	*destroyWallList;
	ushort	numWalls2destroy;
	POINT_DATA	*groupMid;
	WALL_DATA	*wall2destroy;
	ushort	destroyIndex;
	ushort	fragType;
	ushort	numConditionalLinks;

	destroyIndex = destroyableBuildingList[(uint)(grpWall-wallSfcs)];

	if ( objectiveType == DESTROY_BUILDINGS_OBJECTIVE )
	{
		check_destroyed_building(destroyIndex);
	}

	#ifdef PC_VERSION
	if ( destroyIndex==0xffff )
	{
		setcol(RED);
		return ;
	}
	#endif

	destroyWallList = destroyableBuildingGroups + destroyIndex;

	/*-----------------16/10/95 15:21-------------------
	 Find out what types of fragments are needed
	--------------------------------------------------*/
	fragType = *( fragLists[grpWall->wallType&3] + ((grpWall->wallType>>3)&63) );

	if ( ((grpWall->wallType>>9)&0xf)>=7  )
	{
		fragType|=0x8000;											/* note that the group destroyed is a tall group (atleast 32 ft*/
		if ( (grpWall->wallType&0x1ff)==PYLON_TEXTURE )
		{
			if (!lightsTurnedOff) turn_off_lights();
			fragType|=0x7000;											/* note that the group destroyed is a tall group (atleast 32 ft*/
		}
	}


	trigger_wall_explosion(destroyWallList, fragType);

	numWalls2destroy = *destroyWallList++;

	groupMid = (POINT_DATA*)destroyWallList;

	destroyWallList+=2;

	for ( i=0; i<numWalls2destroy; i++ )
	{
		wall2destroy = wallSfcs + *destroyWallList++;
		destroy_texture( wall2destroy );
	}

	game_data.nstructs_dest++;				/* Note that another structure has been drawn */

	#ifdef PC_VERSION
	#ifndef FLOPPY_VERSION
	if (SEND_DESTRUCTION==1)
	{
		WALLDESTRUCTO_TO_OUTPUT_BUFFER(grpWall);
	}
	#endif
	#endif

	/*-----------------19/02/96 12:10-------------------
	 Make any conditional associated with structure
	 available.
	--------------------------------------------------*/

	numConditionalLinks = *destroyWallList++;

	for ( i=0; i<numConditionalLinks; i++ )
	{
		*(link_data + ((*destroyWallList++)*3))=TRUE;
	}
}



/*****************************************************************/




void	remote_destroy_group (WALL_DATA *grpWall)
{
	int		i;
	int		relx,relz;
	uint	dist;
	uint	destroyedWallIndex;
	ushort	*destroyWallList;
	ushort	numWalls2destroy;
	POINT_DATA	*groupMid, *destroyedWallMid;
	WALL_DATA	*wall2destroy;
	ushort	destroyIndex;
	ushort	pylonDestroyed=FALSE;
	ushort	fragType;
	ushort	numConditionalLinks;

	/*Is wall already destroyed? #1*/
	if (grpWall->wallType==TOTALLED_TEXTURE)
		return;

	cWallType = grpWall->wallType & 0x3;
	cWallHeight = (grpWall->wallType>>9)&0xf;
	cWallTexture = (grpWall->wallType&0x1f8) >> 3;
	cDetectType = (cDestroyable = wdetect_info[cWallType].detectType[cWallTexture])&0x3;
	cDestroyable&=4;

	/*Is wall already destroyed? #2*/
	if ( !cDestroyable )
		return;

	/*DestroyableBuildingList holds an index for each wall. The
	 	index points into the grouplist, at the group to which the
	  wall belongs.*/
	destroyIndex =
	destroyableBuildingList[destroyedWallIndex=(uint)(grpWall-wallSfcs)];

	destroyedWallMid = wallMids + destroyedWallIndex;

	/*destroyWallList is the pointer to the group to be destroyed*/
	destroyWallList = destroyableBuildingGroups + destroyIndex;



	/* Check if wall is close enough to be seen to explode */

	relx = abs((pl.x>>16) - (destroyedWallMid->x));
	relz = abs((pl.z>>16) - (destroyedWallMid->z));

	if ( relx>relz )
	{
		dist=relx+(relz>>1);
	}
	else
		dist=relz+(relx>>1);



	if ( (grpWall->wallType&0x1ff)==PYLON_TEXTURE )
	{
 		if (!lightsTurnedOff) turn_off_lights();
		pylonDestroyed=TRUE;
	}

	/*heh- this is no good if using a tank_cam!*/
	if ( dist<=0x2800)
	{
		fragType = *( fragLists[grpWall->wallType&3] + ((grpWall->wallType>>3)&63) );

		if ( ((grpWall->wallType>>9)&0xf)>=7  )
		{
			fragType|=0x8000;											/* note that the group destroyed is a tall group (atleast 32 ft*/
			if ( pylonDestroyed )
			{
	 			fragType|=0x7000;											/* note that the group destroyed is a tall group (atleast 32 ft*/
			}
		}

		trigger_wall_explosion(destroyWallList, fragType);
	}

	numWalls2destroy = *destroyWallList++;

	groupMid = (POINT_DATA*)destroyWallList;

	destroyWallList+=2;

	for ( i=0; i<numWalls2destroy; i++ )
	{
		wall2destroy = wallSfcs + *destroyWallList++;
		destroy_texture( wall2destroy );
	}

	/*-----------------19/02/96 12:10-------------------
	 Make any conditional associated with structure
	 available.
	--------------------------------------------------*/

	numConditionalLinks = *destroyWallList++;

	for ( i=0; i<numConditionalLinks; i++ )
	{
		*(link_data + ((*destroyWallList++)*3))=TRUE;
	}
}








void	check_destroyed_building(int grpindx)
{
	int n;
	ushort	*checkbuilding;
	ushort btarget;

	for ( n=0, checkbuilding=objectiveBuildings ; n<numObjectiveBuildings; n++, checkbuilding+=2 )
	{
		if ( *checkbuilding == grpindx ) /* Destroyed an objective building */
		{
			numObjectiveBuildingsLeft--;

			game_data.perc_obj++;

			btarget = *(checkbuilding+1);
			btarget*=3;

			(*(buildingTargetList + btarget))--;	// Reduce the number of buildings belonging to the relevant target

			numShotsHit++;							/* Hit a target */
			return ;
		}
	}
}



int	objective_building(int sfcindx)
{
	int n,grpIndx;
	ushort	*checkbuilding;

	if ( (grpIndx = destroyableBuildingList[sfcindx])!=-1 ) // check if part of a destroyable building
	{
		for ( n=0, checkbuilding=objectiveBuildings ; n<numObjectiveBuildings; n++, checkbuilding+=2 )
		{
			if ( *checkbuilding == grpIndx ) /* surface belongs to a objective building */
			{
				return (TRUE);
			}
		}
	}

	return (FALSE);
}


/*****************************************************************/



void	destroy_texture(WALL_DATA *detwall)
{
	int			newWallType;
	int			newWallTexture;

	cWallType = detwall->wallType & WALL_TYPE_MASK;
	cWallTexture = (detwall->wallType >> WALL_TEXTURE_SHIFT) & WALL_TEXTURE_MASK;
	cDetectType = wdetect_info[cWallType].detectType[cWallTexture] & WALL_DETECT_MASK;

	newWallType = wdetect_info[cWallType].destructInfo[cWallTexture].wallType;

	detwall->wallType&=0xfe00;									/* Get rid of the current texture/type data */


	if ( newWallType == TOTALLY_TOTALLED_WALL )
	{
		detwall->wallType = TOTALLED_TEXTURE;
		remove_los_line(detwall);									/* Remove from the los/qdt maps */
	}
	else
	{
		/* Replace with crushed/destroyed version of texture */
		detwall->wallType|= (newWallType & WALL_TYPE_MASK);
		newWallTexture = (wdetect_info[cWallType].destructInfo[cWallTexture].texture) & WALL_TEXTURE_MASK;

		detwall->wallType|= (newWallTexture<<WALL_TEXTURE_SHIFT);

		if ( newWallTexture == 21 ) /*General destroyed building texture - need to set height of destroyed wall texture */
		{
			detwall->wallType &= 0x21ff;	/* Mask out the existing height data */
			detwall->wallType |= (2<<WALL_HEIGHT_SHIFT);	/* Or in the new height */
		}

		if ( (wdetect_info[newWallType].detectType[newWallTexture] & WALL_DETECT_MASK)<2 )
		{
			/* Remove wall from qdt and los maps */
			remove_los_line(detwall);										/* Only remove from the los/qdt maps if the wall is no longer detectable */
		}
	}
}



/*****************************************************************/



void	crush_texture(WALL_DATA *detwall)
{
	int			newWallType;

	newWallType = wdetect_info[cWallType].destructInfo[cWallTexture].wallType;

	detwall->wallType&=0xfe00;									/* Get rid of the current texture/type data */

	if ( newWallType == TOTALLY_TOTALLED_WALL )
	{
		detwall->wallType = TOTALLED_TEXTURE;
	}
	else
	{
		/* Replace with crushed/destroyed version of texture */
		detwall->wallType|= (newWallType & WALL_TYPE_MASK);
		detwall->wallType|= (((wdetect_info[cWallType].destructInfo[cWallTexture].texture) & WALL_TEXTURE_MASK ) << WALL_TEXTURE_SHIFT);
	}


	#ifdef PC_VERSION
	#ifndef FLOPPY_VERSION
	if (SEND_DESTRUCTION==1)
		CRUSHDESTRUCTO_TO_OUTPUT_BUFFER (detwall);
	#endif
	#endif

}






/*****************************************************************/


#define LOS_CLIP_LEFT		0
#define LOS_CLIP_RIGHT	0XFF
#define LOS_CLIP_TOP		0
#define LOS_CLIP_BOTTOM	0XFF
#define LINE_STEP				1



void	remove_los_line(WALL_DATA *remvWall)
{
	int	n;
  int	los_xerr=0;
	int	los_yerr=0;
	int	los_start;
	int	los_finish;
	int	los_currentx;
	int	los_currenty;
	int	los_dx, los_dy;
	int	los_incx, los_incy;
	int	los_distance;
	POINT_DATA	*pt1, *pt2;
	int x1, y1, x2, y2;

	pt1 = wallPoints + remvWall->p1;
	pt2 = wallPoints + remvWall->p2;

	x1=pt1->x>>8;
	y1=pt1->z>>8;
	x2=pt2->x>>8;
	y2=pt2->z>>8;

	x1&=0xff;
	y1&=0xff;
	x2&=0xff;
	y2&=0xff;

  if(x1==x2 && y1==y2)
	{
		reset_los_bit(x1,y1);
		reset_qdt_bit(x1,y1);
	}
  else
  if(x1==x2)
 	{
 		los_start=min(y1,y2);
 		los_finish=max(y1,y2);
 		los_currentx=x1;
 		if(los_start<LOS_CLIP_TOP)los_start=LOS_CLIP_TOP;
 		if(los_finish>LOS_CLIP_BOTTOM)los_finish=LOS_CLIP_BOTTOM;
 		for(n=los_start; n<=los_finish; n++)
		{
			reset_los_bit(los_currentx, n);
			reset_qdt_bit(los_currentx, n);
		}
 		return;
	}
  else
  if(y1==y2)
 	{
  	los_start=min(x1,x2);
  	los_finish=max(x1,x2);
  	los_currenty=y1;
  	if(los_start<LOS_CLIP_LEFT)los_start=LOS_CLIP_LEFT;
 		if(los_finish>LOS_CLIP_RIGHT)los_finish=LOS_CLIP_RIGHT;
 		for(n=los_start; n<=los_finish; n++)
		{
			reset_los_bit(n, los_currenty);
			reset_qdt_bit(n, los_currenty);
		}
 		return;
 	}
  else
 	{							// All other lines using bresenhams algorithm
  	los_dx=(x2-x1);
  	los_dy=(y2-y1);

  	if(los_dx>0) los_incx=LINE_STEP;
  	else los_incx=-LINE_STEP;

  	if(los_dy>0) los_incy=LINE_STEP;
  	else los_incy=-LINE_STEP;

  	los_dx=abs(los_dx);
  	los_dy=abs(los_dy);

  	if(los_dx>los_dy) los_distance=los_dx;
  	else los_distance=los_dy;

  	los_currentx=x1;
  	los_currenty=y1;

  	for(n=0; n<=los_distance+1; n++)
 		{
			reset_los_bit(los_currentx, los_currenty);
			reset_qdt_bit(los_currentx, los_currenty);

  		los_xerr+=los_dx;
  		los_yerr+=los_dy;
  		if (los_xerr>los_distance)
 			{
  			los_xerr-=los_distance;
  			los_currentx+=los_incx;
 			}
  		if (los_yerr>los_distance)
 			{
  			los_yerr-=los_distance;
  			los_currenty+=los_incy;
 			}
 		}
 	}
}



/*************************************************************/


#define BULLET_DETECTION_RANGE				0X2600

void	get_bullet_detectable_enemies(void)
{
	int		plx, plz;
	GUN_BOAT	*dboat;
	TANK			*dtank;
	GUN_EMPLACEMENT *cgunempl;
	int				j, relx, relz;
	void		**lastEnem;
	uchar		*lastEnemType;
	uint		posEnemies=0;


	lastEnem = posEnemyList;
	lastEnemType = posEnemyTypeList;

	plx=pl.x>>16;
	plz=pl.z>>16;


	/*Check for tanks in range */

	for ( j=0, dtank=enemyTanks; j<MAX_ENEMY_TANKS; j++, dtank++ )
	{
		/* Check if tank exists */
		if ( dtank->def && dtank->def!=REGENERATE_OBJECT )
		{
			relx = abs((dtank->x>>16) - plx);
			relz = abs((dtank->z>>16) - plz);

			if ( (relx<BULLET_DETECTION_RANGE && relz<BULLET_DETECTION_RANGE) || dtank->def==ALLIED_TRUCK ) /* always check against allied trucks */
			{
				if ( posEnemies<MAX_POS_ENEMIES )
				{
					*((TANK**)lastEnem) = dtank;		/* POinter to actual structure */
					lastEnem++;
					*lastEnemType++ = TANK_TAG;			/* Type identifier */
					posEnemies++;
				}
			}
		}
	}



	/*Check for gunboats in range */

	for ( j=0, dboat=gunboats ; j<MAX_GUN_BOATS; j++,dboat++ )
	{
		if ( dboat->exist )
		{
			relx = abs((dboat->x>>16) - plx);
			relz = abs((dboat->z>>16) - plz);

			if ( relx<BULLET_DETECTION_RANGE && relz<BULLET_DETECTION_RANGE )
			{
				if ( posEnemies<MAX_POS_ENEMIES )
				{
					*((GUN_BOAT**)lastEnem) = dboat;	/* Pointer to actual structure */
					lastEnem++;
					*lastEnemType++ = GUNBOAT_TAG;		/* Type identifier */
					posEnemies++;
				}
			}
		}
	}


	/** check for gun emplacements */

	for ( j=0, cgunempl=gunempls; j<MAX_GUN_EMPLS; j++, cgunempl++)
	{
		if ( cgunempl->exist )
		{
			relx = abs((cgunempl->x>>16) - plx);
			relz = abs((cgunempl->z>>16) - plz);

			if ( relx<BULLET_DETECTION_RANGE && relz<BULLET_DETECTION_RANGE )
			{
				if ( posEnemies<MAX_POS_ENEMIES )
				{
					*((GUN_EMPLACEMENT **)lastEnem) = cgunempl;	/* Pointer to actual structure */
					lastEnem++;
					*lastEnemType++ = GUN_EMPL_TAG;		/* Type identifier */
					posEnemies++;
				}
			}
		}
	}


	/** check for the helicopters **/

	for ( j=0, dtank=helicopters; j<MAX_HELICOPTERS; j++, dtank++ )
	{
		if ( dtank->def && (dtank->def!=REGENERATE_OBJECT) && (dtank->flying))
		{
			relx = abs((dtank->x>>16) - plx);
			relz = abs((dtank->z>>16) - plz);

			if ( relx<BULLET_DETECTION_RANGE && relz<BULLET_DETECTION_RANGE )
			{
				if ( posEnemies<MAX_POS_ENEMIES )
				{
					*((TANK**)lastEnem) = dtank;		/* POinter to actual structure */
					lastEnem++;
					*lastEnemType++ = HELI_TAG;			/* Type identifier */
					posEnemies++;
				}
			}
		}
	}

	*lastEnemType=0XFF;			/* Terminate enemy list */
}



#define TANK_OBJECT_DETECTION_RANGE		0X2000

void	get_detectable_enemies(void)
{
	int		plx, plz;
	TANK			*dtank;
	GUN_EMPLACEMENT *cgunempl;
	int				j, relx, relz;
	void		**lastEnem;
	uchar		*lastEnemType;
	uint		posEnemies=0;

	lastEnem = posEnemyList;
	lastEnemType = posEnemyTypeList;

	plx=pl.x>>16;
	plz=pl.z>>16;

	/** Put player into list of possible detectable objects **/

	*((TANK**)lastEnem) = &pl;		/* POinter to actual structure */
	lastEnem++;
	*lastEnemType++ = TANK_TAG;			/* Type identifier */


	/*Check for tanks in range of player */

	for ( j=0, dtank=enemyTanks; j<MAX_ENEMY_TANKS; j++, dtank++ )
	{
		/* Check if tank exists */
		if ( dtank->def && dtank->def!=REGENERATE_OBJECT )
		{
			/** CHECK FOR CONVOY TRUCKS **/

			if ( (objectiveType==PROTECT_CONVOY_OBJECTIVE && dtank->def==ALLIED_TRUCK ) ||
					 (objectiveType==DESTROY_CONVOY_OBJECTIVE && dtank->def==ENEMY_TRUCK) )
			{
				if ( posEnemies < MAX_POS_ENEMIES )
				{
					*((TANK**)lastEnem) = dtank;		/* POinter to actual structure */
					lastEnem++;
					*lastEnemType++ = TANK_TAG;			/* Type identifier */
					posEnemies++;
					continue;												/* Skip rest if already decided to detect against tank */
				}
			}


			/** RANGE CHECK ON ALL OTHER TANKS **/

			relx = abs((dtank->x>>16) - plx);
			relz = abs((dtank->z>>16) - plz);

			if ( (relx<TANK_OBJECT_DETECTION_RANGE && relz<TANK_OBJECT_DETECTION_RANGE) )
			{
				if ( posEnemies < MAX_POS_ENEMIES )
				{
					*((TANK**)lastEnem) = dtank;		/* POinter to actual structure */
					lastEnem++;
					*lastEnemType++ = TANK_TAG;			/* Type identifier */
					posEnemies++;
					continue;												/* Skip rest if already decided to detect against tank */
				}
			}


			/** If a convoy mission then check if any tanks are in range of convoy trucks */

			if ( objectiveType==PROTECT_CONVOY_OBJECTIVE || objectiveType==DESTROY_CONVOY_OBJECTIVE )
			{
				ushort	*cmember;
    		TANK	*alliedTruck;
				CONVOY_DATA	*cConvoy;
				int		i, k;

				for ( i=0; i<numPaths; i++ )
				{
					cConvoy=convoyData+i;

					if ( cConvoy->convoyType==GUNBOAT_CONVOY) // don't need to check against gunboats
					{
						continue;
					}

         	for ( k=0, cmember=cConvoy->members; k < cConvoy->numMembers; k++ )
          {
      			alliedTruck = enemyTanks+(*cmember++);

    				relx = abs((dtank->x>>16) - (alliedTruck->x>>16));
    				relz = abs((dtank->z>>16) - (alliedTruck->z>>16));

    				if ( (relx<TANK_OBJECT_DETECTION_RANGE && relz<TANK_OBJECT_DETECTION_RANGE) )
    				{
							if ( posEnemies < MAX_POS_ENEMIES )
							{
    						*((TANK**)lastEnem) = dtank;		/* POinter to actual structure */
    						lastEnem++;
    						*lastEnemType++ = TANK_TAG;			/* Type identifier */
								posEnemies++;
							}
    				}
          }
				}
			}
		}
	}


	/** check for gun emplacements in range of player */

	for ( j=0, cgunempl=gunempls; j<MAX_GUN_EMPLS; j++, cgunempl++)
	{
		if ( cgunempl->exist )
		{
			relx = abs((cgunempl->x>>16) - plx);
			relz = abs((cgunempl->z>>16) - plz);

			if ( relx<BULLET_DETECTION_RANGE && relz<BULLET_DETECTION_RANGE )
			{
				if ( posEnemies < MAX_POS_ENEMIES )
				{
					*((GUN_EMPLACEMENT **)lastEnem) = cgunempl;	/* Pointer to actual structure */
					lastEnem++;
					*lastEnemType++ = GUN_EMPL_TAG;		/* Type identifier */
					posEnemies++;
					continue;
				}
			}



			/** if a convoy mission then check if gun emplacement is near any convoy trucks **/

			if ( objectiveType==PROTECT_CONVOY_OBJECTIVE || objectiveType==DESTROY_CONVOY_OBJECTIVE )
			{
				ushort	*cmember;
    		TANK	*alliedTruck;
				CONVOY_DATA	*cConvoy;
				int		i, k;

				for ( i=0; i<numPaths; i++ )
				{
					cConvoy=convoyData+i;
					if ( cConvoy->convoyType == TRUCK_CONVOY )
					{
         		for ( k=0, cmember=cConvoy->members; k < cConvoy->numMembers; k++ )
          	{
      				alliedTruck = enemyTanks+(*cmember++);

    					relx = abs( (cgunempl->x>>16) - (alliedTruck->x>>16));
    					relz = abs( (cgunempl->z>>16) - (alliedTruck->z>>16));

    					if ( (relx<TANK_OBJECT_DETECTION_RANGE && relz<TANK_OBJECT_DETECTION_RANGE) )
    					{
								if ( posEnemies < MAX_POS_ENEMIES )
								{
									*((GUN_EMPLACEMENT **)lastEnem) = cgunempl;	/* Pointer to actual structure */
									lastEnem++;
									*lastEnemType++ = GUN_EMPL_TAG;		/* Type identifier */
									posEnemies++;
								}
    					}
          	}
					}
				}
			}
		}
	}

	*lastEnemType=0XFF;			/* Terminate enemy list */
}





/*************************************************************/

void	shunt_tank(TANK *shuntTank, SHELL_DATA *shuntShell, int recoil)
{
	if ( recoil )
	{
		if ( shuntShell->direction==shuntTank->angle )
		{
			shuntTank->shuntDir = (shuntShell->direction+0x400)&0x7ff;
			shuntTank->shuntSpeed = shuntShell->damage<<1;
		}
	}
	else
	{
		shuntTank->shuntDir = shuntShell->direction;
		shuntTank->shuntSpeed = shuntShell->damage<<3;
		shuntTank->shuntDir += (0x80 - (rand()&0x3f));

		shuntTank->shuntDir &= 0x7ff;
	}

	if ( shuntTank->y == 0 )
	{
		shuntTank->yvel = -32;	/* jump it up a bit as well if on the ground */
	}
}


/**************************************************************
										DNETWORK FUNCTION
 **************************************************************/

#ifdef PC_VERSION
#ifndef FLOPPY_VERSION

/* This might turn out to be surplus to requirements*/
void detect_human_enemy_tankhit (void)
{
	int	relx, relz;												/* Relative distance of tank */
	int hitobj;
	int	maxshells;
	int	detAgainstPlayer;
	int	detectionSize;
	SHELL_DATA *startShell;



	startShell= playerShells;
	maxshells = MAX_PLAYER_SHELLS;
	detAgainstPlayer = TRUE;


	for ( i=0, dshell=startShell; i<maxshells; i++, dshell++)
	{
		if ( dshell->fired==FALSE ) 				/* Skip shell if it hasn't been fired */
			continue;

		hitobj = 0;

		/* Scan through the HUMAN enemy tanks*/

		for ( j=0, dtank=enemyTanks; j<MAX_PLAYERS; j++, dtank++ )
		{

			/* Check if tank exists */
			if ( (dtank->def) && (dtank->def!=REGENERATE_OBJECT) )
			{
				if ( detAgainstPlayer &&
						 (dshell->ownerType ==  dtank->def) &&
						 (dshell->owner==j) )	/*Don't need to test against the tank that fired the shell */
				{
					continue;
				}

				detectionSize = (objectDetectSizes[dtank->def])<<16;

				relx = dtank->x - dshell->x;
				relz = dtank->z - dshell->z;

				/* Check if tank is in range for possible collision */
				if ( (abs(relx)<=SHELL_TANK_COLLISION_SCAN_RANGE) && (abs(relz)<=SHELL_TANK_COLLISION_SCAN_RANGE) )
				{
					tankxmin = ( tankxmax = dtank->x+detectionSize ) - (detectionSize<<1);
					tankzmin = ( tankzmax = dtank->z+detectionSize ) - (detectionSize<<1);

					ohit = nhit = 0;

					if (dshell->ox < tankxmin) ohit |= 	LEFT_BOUNDARY;
					if (dshell->ox > tankxmax) ohit |= 	RIGHT_BOUNDARY;
					if (dshell->oz < tankzmin) ohit |= 	BOTTOM_BOUNDARY;
					if (dshell->oz > tankzmax) ohit |= 	TOP_BOUNDARY;

					if (dshell->x < tankxmin) nhit |= 	LEFT_BOUNDARY;
					if (dshell->x > tankxmax) nhit |= 	RIGHT_BOUNDARY;
					if (dshell->z < tankzmin) nhit |= 	BOTTOM_BOUNDARY;
					if (dshell->z > tankzmax) nhit |= 	TOP_BOUNDARY;

					if ( (ohit & nhit)==0  )
					{
						HIT_BITS|=(1<<j);

						dshell->fired = 0;

						SHELLSLOT_SEARCH= i+1;
						if (SHELLSLOT_SEARCH==maxshells )
							SHELLSLOT_SEARCH= 0;

						/*damage_tank(dtank, dshell->damage);*/
						trigger_explosion(SHELL_HIT_EXPLOSION, (POSITION*)&(dshell->x), (POSITION*)&(dtank->x));

						if (nDef.flags&TRANSMIT_EXPLOSIONS)
						{
							SHELL_EXPLODE_REMOTE (i,SHELL_HIT_EXPLOSION);
						}


						hitobj=TRUE;
						break;
					}
				}
			}
		}
	}
}

#endif
#endif



