/*

														COOLER

	Between level stuff.    											 04/12/95 10:25

*/

#include <dos.h>
#include <time.h>
#include <stdio.h>
#include <graph.h>
#include <string.h>
#include <stdlib.h>
#include "chuck.h"
#include "walldraw.h"
#include "frontend.h"
#include "e_global.h"


#include "shock.h"
#include "rshock.h" /*stuff used by nshock.c AND shock.c*/
#include "netextra.h"


/*Network stuff*/
//#include "\tanx\newshell\shell.h"
#include "\tanx\setnet2.h"
#include "\tanx\menu.h"
#include "\tanx\objects.h"


#ifdef MEMCHK
#include <memcheck.h>
#endif

/*-----------------04/12/95 10:26-------------------

											GLOBALS

--------------------------------------------------*/

int COOL_FRAMES=5;
char LEAVING_GAME;


/*-----------------04/12/95 10:26-------------------

											FUNCTIONS

--------------------------------------------------*/



/*Leader initiates the level change*********/
void LEADER_CHLEV_PHASE (void)
{
	int ALL_PLAYERS_GONE=0;

	if (nDef.flags&NO_CHLEV)
		return;

	/*Immediately make and send LEVEL CHANGE BROADCAST*/
	myGame.level++;
	myGame.serial++;
	MAKE_LEADER_BROADCAST();
	lbroads+=LEADER_BROADCAST();
	time(&ltime1);


	/*CANCEL ANY WORLD TRANSACTION*/

	ntanks[myID]->STATUS= CHANGE_LEVEL;

	/*Stop PLAYERS from being able to drop out*/
	FAKE_PLAYER_DROPOUT= 1;
	FAKE_PLAYER_DROPOUTS= 0;

	DONT_TRANSMIT_OBJECT_DATA= 1;
	/*Don't re-initiate world send!!*/
	DONT_DO_WORLD_SEND= 1;
	WRITE_O= 0;
	flushReceiveQueue();
	INIT_WORLD_SEND();/*CANCEL any world send*/


	while (!ALL_PLAYERS_GONE)
	{
		/*Don't send objdata*/
		communicate();

		if (FAKE_PLAYER_DROPOUTS==myGame.noPlayers-1)
			ALL_PLAYERS_GONE=1;

	}

	/*At this stage, all players have definitely stopped
		sending OBJ_DATA*/

	flushReceiveQueue();
	READ_I=0;

	FAKE_PLAYER_DROPOUT= 0;
	FAKE_PLAYER_DROPOUTS= 0;

	DONT_TRANSMIT_OBJECT_DATA= 0;
	DONT_DO_WORLD_SEND= 0;


	NRESET_LEVEL();

	/*Stops WORLD SEND being done to OLD players at start of
	  level*/
	nDef.flags&=~(SEND_WORLD);
	NINIT_LEVEL();
	nDef.flags|=SEND_WORLD;


	WRITE_O=0;

	/*CLEAN UP OBJDATA STUFF*/

	GET_COOLER();

}






/*Change level, then wait for LEADER to return to the game,
	before entering the COOLER */
/*See- the trick is, the player doesn't transmit a bean
	during this phase, an implicit signal to the LEADER that
	it has got the message about the level change*/

void PLAYER_CHLEV_PHASE (void)
{
	int LEADER_ISBACK= 0;
	int elapsedTime;

	#ifdef PC_VERSION
	SoundStopAllSamples();
	#endif

	NRESET_LEVEL();

	/*Stops player requesting WORLD at start of next level*/
	nDef.flags&=~(SEND_WORLD);
	NINIT_LEVEL();
	nDef.flags|=SEND_WORLD;

	/*CLEAN UP OBJ_DATA STUFF*/


	/*CANCEL ANY WORLD TRANSACTION*/

	ntanks[LEADER_ID]->STATUS= CHANGE_LEVEL;
	WORLDREC_STATUS= WORLDREC_COMPLETE;

	/*Increase LEADER dump tolerance, so LEADER won't be dropped
	  while it's changing levels.*/
	LEADER_DUMP_TOLERANCE= LEADER_BROADCAST_TIME*16;

	/*LEADER has already stopped sending OBJ_PAKs here, but
		other players may not have*/
	flushReceiveQueue();
	WRITE_O=0;
	IGNORE_OBJECT_DATA= 1;

	time (&ltime1);

	while (!LEADER_ISBACK)
	{

		/*Check for LEADER dropping out*/
		elapsedTime= difftime (time (&ltime2),ltime1);

		if ((elapsedTime>= (LEADER_DUMP_TOLERANCE))&&
				(!(nDef.flags&NO_LEADER_DROPOUT)))
		{
			BYE_DEAR_LEADER ();
		}

		communicate_RECEIVE();

		/*Am I the new leader?*/

		if (myID==LEADER_ID)
			LEADER_ISBACK=1;
		else
		if (ntanks[LEADER_ID]->STATUS!=CHANGE_LEVEL)
			LEADER_ISBACK= 1;

	}

	/*All players have definitely stopped sending objpaks here*/
	flushReceiveQueue();
	READ_I=0;
	IGNORE_OBJECT_DATA= 0;

	/*Reset LEADER dropout timer*/
	time (&ltime1);
	LEADER_DUMP_TOLERANCE= LEADER_BROADCAST_TIME*4;

	GET_COOLER();
}









/*COOLER initialization function*/
void GET_COOLER (void)
{

	ntanks[myID]->STATUS= COOLING;
	while (get_key());

	COOLER();
}




/*While in the COOLER, the player remains in the game, but is
	inactive as a tank*/

void COOLER (void)
{
	scr_ptr= p1screen;



	if (LEAVING_GAME)
	{
		/*Check for all players to ack scattered ctbls*/

		if (WRITE_O==0)
		{
			objectiveAchieved=TRUE; /*a bodge*/
			net_on=0;
			game_on= 0;
			set_exit_game(ENDGAME_QUIT);
		}

	}
	else
	{

		/*Create Display***************************************/
		memset (p1screen,P_GREY,320*200);

 		txt_print_colr= P_WHITE;
 		_print_string (100,100,"THIS IS THE cooler.",SINGLE_COLOURED_PRINT);
 		txt_print_colr= 0;
 		_print_string (280,180,"<Anykey>",SINGLE_COLOURED_PRINT);

		if (get_key())
 		{
			/*EXIT THE COOLER*/
			drawCockpit= 1;
			ntanks[myID]->STATUS= NORMAL_JOE;
		}
	}


	/*Artificially slow down, to mimic display*/
	for (i=0;i<COOL_FRAMES;i++)
		wait_vbl();

}


