#include "headers.h"

#include "chuck.h"
#ifdef MEMCHK
#include <memcheck.h>
#endif
/************************
* sine & cosine tables *
************************/

short sintab[]= {
	0x0000,0x0065,0x00c9,0x012e,0x0192,0x01f7,0x025b,0x02c0,
	0x0324,0x0389,0x03ed,0x0452,0x04b6,0x051b,0x057f,0x05e3,
	0x0648,0x06ac,0x0711,0x0775,0x07d9,0x083e,0x08a2,0x0906,
	0x096a,0x09cf,0x0a33,0x0a97,0x0afb,0x0b5f,0x0bc4,0x0c28,
	0x0c8c,0x0cf0,0x0d54,0x0db8,0x0e1c,0x0e80,0x0ee3,0x0f47,
	0x0fab,0x100f,0x1072,0x10d6,0x113a,0x119d,0x1201,0x1264,
	0x12c8,0x132b,0x138f,0x13f2,0x1455,0x14b9,0x151c,0x157f,
	0x15e2,0x1645,0x16a8,0x170b,0x176e,0x17d0,0x1833,0x1896,
	0x18f9,0x195b,0x19be,0x1a20,0x1a82,0x1ae5,0x1b47,0x1ba9,
	0x1c0b,0x1c6d,0x1ccf,0x1d31,0x1d93,0x1df5,0x1e57,0x1eb8,
	0x1f1a,0x1f7b,0x1fdd,0x203e,0x209f,0x2100,0x2161,0x21c2,
	0x2223,0x2284,0x22e5,0x2346,0x23a6,0x2407,0x2467,0x24c8,
	0x2528,0x2588,0x25e8,0x2648,0x26a8,0x2708,0x2767,0x27c7,
	0x2826,0x2886,0x28e5,0x2944,0x29a3,0x2a02,0x2a61,0x2ac0,
	0x2b1f,0x2b7d,0x2bdc,0x2c3a,0x2c99,0x2cf7,0x2d55,0x2db3,
	0x2e11,0x2e6e,0x2ecc,0x2f2a,0x2f87,0x2fe4,0x3041,0x309e,
	0x30fb,0x3158,0x31b5,0x3211,0x326e,0x32ca,0x3326,0x3383,
	0x33df,0x343a,0x3496,0x34f2,0x354d,0x35a8,0x3604,0x365f,
	0x36ba,0x3715,0x376f,0x37ca,0x3824,0x387e,0x38d9,0x3933,
	0x398c,0x39e6,0x3a40,0x3a99,0x3af2,0x3b4c,0x3ba5,0x3bfe,
	0x3c56,0x3caf,0x3d07,0x3d60,0x3db8,0x3e10,0x3e68,0x3ebf,
	0x3f17,0x3f6e,0x3fc5,0x401d,0x4073,0x40ca,0x4121,0x4177,
	0x41ce,0x4224,0x427a,0x42d0,0x4325,0x437b,0x43d0,0x4425,
	0x447a,0x44cf,0x4524,0x4578,0x45cd,0x4621,0x4675,0x46c9,
	0x471c,0x4770,0x47c3,0x4816,0x4869,0x48bc,0x490f,0x4961,
	0x49b4,0x4a06,0x4a58,0x4aa9,0x4afb,0x4b4c,0x4b9d,0x4bee,
	0x4c3f,0x4c90,0x4ce0,0x4d31,0x4d81,0x4dd1,0x4e20,0x4e70,
	0x4ebf,0x4f0e,0x4f5d,0x4fac,0x4ffb,0x5049,0x5097,0x50e5,
	0x5133,0x5181,0x51ce,0x521b,0x5268,0x52b5,0x5302,0x534e,
	0x539b,0x53e7,0x5432,0x547e,0x54c9,0x5515,0x5560,0x55aa,
	0x55f5,0x563f,0x568a,0x56d3,0x571d,0x5767,0x57b0,0x57f9,
	0x5842,0x588b,0x58d3,0x591c,0x5964,0x59ac,0x59f3,0x5a3b,
	0x5a82,0x5ac9,0x5b0f,0x5b56,0x5b9c,0x5be2,0x5c28,0x5c6e,
	0x5cb3,0x5cf9,0x5d3e,0x5d82,0x5dc7,0x5e0b,0x5e4f,0x5e93,
	0x5ed7,0x5f1a,0x5f5d,0x5fa0,0x5fe3,0x6025,0x6068,0x60aa,
	0x60eb,0x612d,0x616e,0x61af,0x61f0,0x6231,0x6271,0x62b1,
	0x62f1,0x6331,0x6370,0x63af,0x63ee,0x642d,0x646c,0x64aa,
	0x64e8,0x6525,0x6563,0x65a0,0x65dd,0x661a,0x6656,0x6693,
	0x66cf,0x670a,0x6746,0x6781,0x67bc,0x67f7,0x6832,0x686c,
	0x68a6,0x68e0,0x6919,0x6952,0x698b,0x69c4,0x69fd,0x6a35,
	0x6a6d,0x6aa4,0x6adc,0x6b13,0x6b4a,0x6b81,0x6bb7,0x6bed,
	0x6c23,0x6c59,0x6c8e,0x6cc3,0x6cf8,0x6d2d,0x6d61,0x6d95,
	0x6dc9,0x6dfd,0x6e30,0x6e63,0x6e96,0x6ec8,0x6efb,0x6f2c,
	0x6f5e,0x6f90,0x6fc1,0x6ff2,0x7022,0x7053,0x7083,0x70b2,
	0x70e2,0x7111,0x7140,0x716f,0x719d,0x71cb,0x71f9,0x7227,
	0x7254,0x7281,0x72ae,0x72db,0x7307,0x7333,0x735e,0x738a,
	0x73b5,0x73e0,0x740a,0x7435,0x745f,0x7488,0x74b2,0x74db,
	0x7504,0x752d,0x7555,0x757d,0x75a5,0x75cc,0x75f3,0x761a,
	0x7641,0x7667,0x768d,0x76b3,0x76d8,0x76fe,0x7722,0x7747,
	0x776b,0x778f,0x77b3,0x77d7,0x77fa,0x781d,0x783f,0x7862,
	0x7884,0x78a5,0x78c7,0x78e8,0x7909,0x7929,0x794a,0x796a,
	0x7989,0x79a9,0x79c8,0x79e6,0x7a05,0x7a23,0x7a41,0x7a5f,
	0x7a7c,0x7a99,0x7ab6,0x7ad2,0x7aee,0x7b0a,0x7b26,0x7b41,
	0x7b5c,0x7b77,0x7b91,0x7bab,0x7bc5,0x7bde,0x7bf8,0x7c10,
	0x7c29,0x7c41,0x7c59,0x7c71,0x7c88,0x7c9f,0x7cb6,0x7ccd,
	0x7ce3,0x7cf9,0x7d0e,0x7d24,0x7d39,0x7d4d,0x7d62,0x7d76,
	0x7d89,0x7d9d,0x7db0,0x7dc3,0x7dd5,0x7de8,0x7dfa,0x7e0b,
	0x7e1d,0x7e2e,0x7e3e,0x7e4f,0x7e5f,0x7e6f,0x7e7e,0x7e8d,
	0x7e9c,0x7eab,0x7eb9,0x7ec7,0x7ed5,0x7ee2,0x7eef,0x7efc,
	0x7f09,0x7f15,0x7f21,0x7f2c,0x7f37,0x7f42,0x7f4d,0x7f57,
	0x7f61,0x7f6b,0x7f74,0x7f7d,0x7f86,0x7f8f,0x7f97,0x7f9f,
	0x7fa6,0x7fad,0x7fb4,0x7fbb,0x7fc1,0x7fc7,0x7fcd,0x7fd2,
	0x7fd8,0x7fdc,0x7fe1,0x7fe5,0x7fe9,0x7fec,0x7ff0,0x7ff3,
	0x7ff5,0x7ff7,0x7ff9,0x7ffb,0x7ffd,0x7ffe,0x7ffe,0x7fff,

	0x7fff,0x7fff,0x7ffe,0x7ffe,0x7ffd,0x7ffb,0x7ff9,0x7ff7,
	0x7ff5,0x7ff3,0x7ff0,0x7fec,0x7fe9,0x7fe5,0x7fe1,0x7fdc,
	0x7fd8,0x7fd2,0x7fcd,0x7fc7,0x7fc1,0x7fbb,0x7fb4,0x7fad,
	0x7fa6,0x7f9f,0x7f97,0x7f8f,0x7f86,0x7f7d,0x7f74,0x7f6b,
	0x7f61,0x7f57,0x7f4d,0x7f42,0x7f37,0x7f2c,0x7f21,0x7f15,
	0x7f09,0x7efc,0x7eef,0x7ee2,0x7ed5,0x7ec7,0x7eb9,0x7eab,
	0x7e9c,0x7e8d,0x7e7e,0x7e6f,0x7e5f,0x7e4f,0x7e3e,0x7e2e,
	0x7e1d,0x7e0b,0x7dfa,0x7de8,0x7dd5,0x7dc3,0x7db0,0x7d9d,
	0x7d89,0x7d76,0x7d62,0x7d4d,0x7d39,0x7d24,0x7d0e,0x7cf9,
	0x7ce3,0x7ccd,0x7cb6,0x7c9f,0x7c88,0x7c71,0x7c59,0x7c41,
	0x7c29,0x7c10,0x7bf8,0x7bde,0x7bc5,0x7bab,0x7b91,0x7b77,
	0x7b5c,0x7b41,0x7b26,0x7b0a,0x7aee,0x7ad2,0x7ab6,0x7a99,
	0x7a7c,0x7a5f,0x7a41,0x7a23,0x7a05,0x79e6,0x79c8,0x79a9,
	0x7989,0x796a,0x794a,0x7929,0x7909,0x78e8,0x78c7,0x78a5,
	0x7884,0x7862,0x783f,0x781d,0x77fa,0x77d7,0x77b3,0x778f,
	0x776b,0x7747,0x7722,0x76fe,0x76d8,0x76b3,0x768d,0x7667,
	0x7641,0x761a,0x75f3,0x75cc,0x75a5,0x757d,0x7555,0x752d,
	0x7504,0x74db,0x74b2,0x7488,0x745f,0x7435,0x740a,0x73e0,
	0x73b5,0x738a,0x735e,0x7333,0x7307,0x72db,0x72ae,0x7281,
	0x7254,0x7227,0x71f9,0x71cb,0x719d,0x716f,0x7140,0x7111,
	0x70e2,0x70b2,0x7083,0x7053,0x7022,0x6ff2,0x6fc1,0x6f90,
	0x6f5e,0x6f2c,0x6efb,0x6ec8,0x6e96,0x6e63,0x6e30,0x6dfd,
	0x6dc9,0x6d95,0x6d61,0x6d2d,0x6cf8,0x6cc3,0x6c8e,0x6c59,
	0x6c23,0x6bed,0x6bb7,0x6b81,0x6b4a,0x6b13,0x6adc,0x6aa4,
	0x6a6d,0x6a35,0x69fd,0x69c4,0x698b,0x6952,0x6919,0x68e0,
	0x68a6,0x686c,0x6832,0x67f7,0x67bc,0x6781,0x6746,0x670a,
	0x66cf,0x6693,0x6656,0x661a,0x65dd,0x65a0,0x6563,0x6525,
	0x64e8,0x64aa,0x646c,0x642d,0x63ee,0x63af,0x6370,0x6331,
	0x62f1,0x62b1,0x6271,0x6231,0x61f0,0x61af,0x616e,0x612d,
	0x60eb,0x60aa,0x6068,0x6025,0x5fe3,0x5fa0,0x5f5d,0x5f1a,
	0x5ed7,0x5e93,0x5e4f,0x5e0b,0x5dc7,0x5d82,0x5d3e,0x5cf9,
	0x5cb3,0x5c6e,0x5c28,0x5be2,0x5b9c,0x5b56,0x5b0f,0x5ac9,
	0x5a82,0x5a3b,0x59f3,0x59ac,0x5964,0x591c,0x58d3,0x588b,
	0x5842,0x57f9,0x57b0,0x5767,0x571d,0x56d3,0x568a,0x563f,
	0x55f5,0x55aa,0x5560,0x5515,0x54c9,0x547e,0x5432,0x53e7,
	0x539b,0x534e,0x5302,0x52b5,0x5268,0x521b,0x51ce,0x5181,
	0x5133,0x50e5,0x5097,0x5049,0x4ffb,0x4fac,0x4f5d,0x4f0e,
	0x4ebf,0x4e70,0x4e20,0x4dd1,0x4d81,0x4d31,0x4ce0,0x4c90,
	0x4c3f,0x4bee,0x4b9d,0x4b4c,0x4afb,0x4aa9,0x4a58,0x4a06,
	0x49b4,0x4961,0x490f,0x48bc,0x4869,0x4816,0x47c3,0x4770,
	0x471c,0x46c9,0x4675,0x4621,0x45cd,0x4578,0x4524,0x44cf,
	0x447a,0x4425,0x43d0,0x437b,0x4325,0x42d0,0x427a,0x4224,
	0x41ce,0x4177,0x4121,0x40ca,0x4073,0x401d,0x3fc5,0x3f6e,
	0x3f17,0x3ebf,0x3e68,0x3e10,0x3db8,0x3d60,0x3d07,0x3caf,
	0x3c56,0x3bfe,0x3ba5,0x3b4c,0x3af2,0x3a99,0x3a40,0x39e6,
	0x398c,0x3933,0x38d9,0x387e,0x3824,0x37ca,0x376f,0x3715,
	0x36ba,0x365f,0x3604,0x35a8,0x354d,0x34f2,0x3496,0x343a,
	0x33df,0x3383,0x3326,0x32ca,0x326e,0x3211,0x31b5,0x3158,
	0x30fb,0x309e,0x3041,0x2fe4,0x2f87,0x2f2a,0x2ecc,0x2e6e,
	0x2e11,0x2db3,0x2d55,0x2cf7,0x2c99,0x2c3a,0x2bdc,0x2b7d,
	0x2b1f,0x2ac0,0x2a61,0x2a02,0x29a3,0x2944,0x28e5,0x2886,
	0x2826,0x27c7,0x2767,0x2708,0x26a8,0x2648,0x25e8,0x2588,
	0x2528,0x24c8,0x2467,0x2407,0x23a6,0x2346,0x22e5,0x2284,
	0x2223,0x21c2,0x2161,0x2100,0x209f,0x203e,0x1fdd,0x1f7b,
	0x1f1a,0x1eb8,0x1e57,0x1df5,0x1d93,0x1d31,0x1ccf,0x1c6d,
	0x1c0b,0x1ba9,0x1b47,0x1ae5,0x1a82,0x1a20,0x19be,0x195b,
	0x18f9,0x1896,0x1833,0x17d0,0x176e,0x170b,0x16a8,0x1645,
	0x15e2,0x157f,0x151c,0x14b9,0x1455,0x13f2,0x138f,0x132b,
	0x12c8,0x1264,0x1201,0x119d,0x113a,0x10d6,0x1072,0x100f,
	0x0fab,0x0f47,0x0ee3,0x0e80,0x0e1c,0x0db8,0x0d54,0x0cf0,
	0x0c8c,0x0c28,0x0bc4,0x0b5f,0x0afb,0x0a97,0x0a33,0x09cf,
	0x096a,0x0906,0x08a2,0x083e,0x07d9,0x0775,0x0711,0x06ac,
	0x0648,0x05e3,0x057f,0x051b,0x04b6,0x0452,0x03ed,0x0389,
	0x0324,0x02c0,0x025b,0x01f7,0x0192,0x012e,0x00c9,0x0065,
	0x0000,0xff9b,0xff37,0xfed2,0xfe6e,0xfe09,0xfda5,0xfd40,

	0xfcdc,0xfc77,0xfc13,0xfbae,0xfb4a,0xfae5,0xfa81,0xfa1d,
	0xf9b8,0xf954,0xf8ef,0xf88b,0xf827,0xf7c2,0xf75e,0xf6fa,
	0xf696,0xf631,0xf5cd,0xf569,0xf505,0xf4a1,0xf43c,0xf3d8,
	0xf374,0xf310,0xf2ac,0xf248,0xf1e4,0xf180,0xf11d,0xf0b9,
	0xf055,0xeff1,0xef8e,0xef2a,0xeec6,0xee63,0xedff,0xed9c,
	0xed38,0xecd5,0xec71,0xec0e,0xebab,0xeb47,0xeae4,0xea81,
	0xea1e,0xe9bb,0xe958,0xe8f5,0xe892,0xe830,0xe7cd,0xe76a,
	0xe707,0xe6a5,0xe642,0xe5e0,0xe57e,0xe51b,0xe4b9,0xe457,
	0xe3f5,0xe393,0xe331,0xe2cf,0xe26d,0xe20b,0xe1a9,0xe148,
	0xe0e6,0xe085,0xe023,0xdfc2,0xdf61,0xdf00,0xde9f,0xde3e,
	0xdddd,0xdd7c,0xdd1b,0xdcba,0xdc5a,0xdbf9,0xdb99,0xdb38,
	0xdad8,0xda78,0xda18,0xd9b8,0xd958,0xd8f8,0xd899,0xd839,
	0xd7da,0xd77a,0xd71b,0xd6bc,0xd65d,0xd5fe,0xd59f,0xd540,
	0xd4e1,0xd483,0xd424,0xd3c6,0xd367,0xd309,0xd2ab,0xd24d,
	0xd1ef,0xd192,0xd134,0xd0d6,0xd079,0xd01c,0xcfbf,0xcf62,
	0xcf05,0xcea8,0xce4b,0xcdef,0xcd92,0xcd36,0xccda,0xcc7d,
	0xcc21,0xcbc6,0xcb6a,0xcb0e,0xcab3,0xca58,0xc9fc,0xc9a1,
	0xc946,0xc8eb,0xc891,0xc836,0xc7dc,0xc782,0xc727,0xc6cd,
	0xc674,0xc61a,0xc5c0,0xc567,0xc50e,0xc4b4,0xc45b,0xc402,
	0xc3aa,0xc351,0xc2f9,0xc2a0,0xc248,0xc1f0,0xc198,0xc141,
	0xc0e9,0xc092,0xc03b,0xbfe3,0xbf8d,0xbf36,0xbedf,0xbe89,
	0xbe32,0xbddc,0xbd86,0xbd30,0xbcdb,0xbc85,0xbc30,0xbbdb,
	0xbb86,0xbb31,0xbadc,0xba88,0xba33,0xb9df,0xb98b,0xb937,
	0xb8e4,0xb890,0xb83d,0xb7ea,0xb797,0xb744,0xb6f1,0xb69f,
	0xb64c,0xb5fa,0xb5a8,0xb557,0xb505,0xb4b4,0xb463,0xb412,
	0xb3c1,0xb370,0xb320,0xb2cf,0xb27f,0xb22f,0xb1e0,0xb190,
	0xb141,0xb0f2,0xb0a3,0xb054,0xb005,0xafb7,0xaf69,0xaf1b,
	0xaecd,0xae7f,0xae32,0xade5,0xad98,0xad4b,0xacfe,0xacb2,
	0xac65,0xac19,0xabce,0xab82,0xab37,0xaaeb,0xaaa0,0xaa56,
	0xaa0b,0xa9c1,0xa976,0xa92d,0xa8e3,0xa899,0xa850,0xa807,
	0xa7be,0xa775,0xa72d,0xa6e4,0xa69c,0xa654,0xa60d,0xa5c5,
	0xa57e,0xa537,0xa4f1,0xa4aa,0xa464,0xa41e,0xa3d8,0xa392,
	0xa34d,0xa307,0xa2c2,0xa27e,0xa239,0xa1f5,0xa1b1,0xa16d,
	0xa129,0xa0e6,0xa0a3,0xa060,0xa01d,0x9fdb,0x9f98,0x9f56,
	0x9f15,0x9ed3,0x9e92,0x9e51,0x9e10,0x9dcf,0x9d8f,0x9d4f,
	0x9d0f,0x9ccf,0x9c90,0x9c51,0x9c12,0x9bd3,0x9b94,0x9b56,
	0x9b18,0x9adb,0x9a9d,0x9a60,0x9a23,0x99e6,0x99aa,0x996d,
	0x9931,0x98f6,0x98ba,0x987f,0x9844,0x9809,0x97ce,0x9794,
	0x975a,0x9720,0x96e7,0x96ae,0x9675,0x963c,0x9603,0x95cb,
	0x9593,0x955c,0x9524,0x94ed,0x94b6,0x947f,0x9449,0x9413,
	0x93dd,0x93a7,0x9372,0x933d,0x9308,0x92d3,0x929f,0x926b,
	0x9237,0x9203,0x91d0,0x919d,0x916a,0x9138,0x9105,0x90d4,
	0x90a2,0x9070,0x903f,0x900e,0x8fde,0x8fad,0x8f7d,0x8f4e,
	0x8f1e,0x8eef,0x8ec0,0x8e91,0x8e63,0x8e35,0x8e07,0x8dd9,
	0x8dac,0x8d7f,0x8d52,0x8d25,0x8cf9,0x8ccd,0x8ca2,0x8c76,
	0x8c4b,0x8c20,0x8bf6,0x8bcb,0x8ba1,0x8b78,0x8b4e,0x8b25,
	0x8afc,0x8ad3,0x8aab,0x8a83,0x8a5b,0x8a34,0x8a0d,0x89e6,
	0x89bf,0x8999,0x8973,0x894d,0x8928,0x8902,0x88de,0x88b9,
	0x8895,0x8871,0x884d,0x8829,0x8806,0x87e3,0x87c1,0x879e,
	0x877c,0x875b,0x8739,0x8718,0x86f7,0x86d7,0x86b6,0x8696,
	0x8677,0x8657,0x8638,0x861a,0x85fb,0x85dd,0x85bf,0x85a1,
	0x8584,0x8567,0x854a,0x852e,0x8512,0x84f6,0x84da,0x84bf,
	0x84a4,0x8489,0x846f,0x8455,0x843b,0x8422,0x8408,0x83f0,
	0x83d7,0x83bf,0x83a7,0x838f,0x8378,0x8361,0x834a,0x8333,
	0x831d,0x8307,0x82f2,0x82dc,0x82c7,0x82b3,0x829e,0x828a,
	0x8277,0x8263,0x8250,0x823d,0x822b,0x8218,0x8206,0x81f5,
	0x81e3,0x81d2,0x81c2,0x81b1,0x81a1,0x8191,0x8182,0x8173,
	0x8164,0x8155,0x8147,0x8139,0x812b,0x811e,0x8111,0x8104,
	0x80f7,0x80eb,0x80df,0x80d4,0x80c9,0x80be,0x80b3,0x80a9,
	0x809f,0x8095,0x808c,0x8083,0x807a,0x8071,0x8069,0x8061,
	0x805a,0x8053,0x804c,0x8045,0x803f,0x8039,0x8033,0x802e,
	0x8028,0x8024,0x801f,0x801b,0x8017,0x8014,0x8010,0x800d,
	0x800b,0x8009,0x8007,0x8005,0x8003,0x8002,0x8002,0x8001,
	0x8001,0x8001,0x8002,0x8002,0x8003,0x8005,0x8007,0x8009,
	0x800b,0x800d,0x8010,0x8014,0x8017,0x801b,0x801f,0x8024,
	0x8028,0x802e,0x8033,0x8039,0x803f,0x8045,0x804c,0x8053,
	0x805a,0x8061,0x8069,0x8071,0x807a,0x8083,0x808c,0x8095,
	0x809f,0x80a9,0x80b3,0x80be,0x80c9,0x80d4,0x80df,0x80eb,
	0x80f7,0x8104,0x8111,0x811e,0x812b,0x8139,0x8147,0x8155,
	0x8164,0x8173,0x8182,0x8191,0x81a1,0x81b1,0x81c2,0x81d2,
	0x81e3,0x81f5,0x8206,0x8218,0x822b,0x823d,0x8250,0x8263,
	0x8277,0x828a,0x829e,0x82b3,0x82c7,0x82dc,0x82f2,0x8307,
	0x831d,0x8333,0x834a,0x8361,0x8378,0x838f,0x83a7,0x83bf,
	0x83d7,0x83f0,0x8408,0x8422,0x843b,0x8455,0x846f,0x8489,
	0x84a4,0x84bf,0x84da,0x84f6,0x8512,0x852e,0x854a,0x8567,
	0x8584,0x85a1,0x85bf,0x85dd,0x85fb,0x861a,0x8638,0x8657,
	0x8677,0x8696,0x86b6,0x86d7,0x86f7,0x8718,0x8739,0x875b,
	0x877c,0x879e,0x87c1,0x87e3,0x8806,0x8829,0x884d,0x8871,
	0x8895,0x88b9,0x88de,0x8902,0x8928,0x894d,0x8973,0x8999,
	0x89bf,0x89e6,0x8a0d,0x8a34,0x8a5b,0x8a83,0x8aab,0x8ad3,
	0x8afc,0x8b25,0x8b4e,0x8b78,0x8ba1,0x8bcb,0x8bf6,0x8c20,
	0x8c4b,0x8c76,0x8ca2,0x8ccd,0x8cf9,0x8d25,0x8d52,0x8d7f,
	0x8dac,0x8dd9,0x8e07,0x8e35,0x8e63,0x8e91,0x8ec0,0x8eef,
	0x8f1e,0x8f4e,0x8f7d,0x8fad,0x8fde,0x900e,0x903f,0x9070,
	0x90a2,0x90d4,0x9105,0x9138,0x916a,0x919d,0x91d0,0x9203,
	0x9237,0x926b,0x929f,0x92d3,0x9308,0x933d,0x9372,0x93a7,
	0x93dd,0x9413,0x9449,0x947f,0x94b6,0x94ed,0x9524,0x955c,
	0x9593,0x95cb,0x9603,0x963c,0x9675,0x96ae,0x96e7,0x9720,
	0x975a,0x9794,0x97ce,0x9809,0x9844,0x987f,0x98ba,0x98f6,
	0x9931,0x996d,0x99aa,0x99e6,0x9a23,0x9a60,0x9a9d,0x9adb,
	0x9b18,0x9b56,0x9b94,0x9bd3,0x9c12,0x9c51,0x9c90,0x9ccf,
	0x9d0f,0x9d4f,0x9d8f,0x9dcf,0x9e10,0x9e51,0x9e92,0x9ed3,
	0x9f15,0x9f56,0x9f98,0x9fdb,0xa01d,0xa060,0xa0a3,0xa0e6,
	0xa129,0xa16d,0xa1b1,0xa1f5,0xa239,0xa27e,0xa2c2,0xa307,
	0xa34d,0xa392,0xa3d8,0xa41e,0xa464,0xa4aa,0xa4f1,0xa537,
	0xa57e,0xa5c5,0xa60d,0xa654,0xa69c,0xa6e4,0xa72d,0xa775,
	0xa7be,0xa807,0xa850,0xa899,0xa8e3,0xa92d,0xa976,0xa9c1,
	0xaa0b,0xaa56,0xaaa0,0xaaeb,0xab37,0xab82,0xabce,0xac19,
	0xac65,0xacb2,0xacfe,0xad4b,0xad98,0xade5,0xae32,0xae7f,
	0xaecd,0xaf1b,0xaf69,0xafb7,0xb005,0xb054,0xb0a3,0xb0f2,
	0xb141,0xb190,0xb1e0,0xb22f,0xb27f,0xb2cf,0xb320,0xb370,
	0xb3c1,0xb412,0xb463,0xb4b4,0xb505,0xb557,0xb5a8,0xb5fa,
	0xb64c,0xb69f,0xb6f1,0xb744,0xb797,0xb7ea,0xb83d,0xb890,
	0xb8e4,0xb937,0xb98b,0xb9df,0xba33,0xba88,0xbadc,0xbb31,
	0xbb86,0xbbdb,0xbc30,0xbc85,0xbcdb,0xbd30,0xbd86,0xbddc,
	0xbe32,0xbe89,0xbedf,0xbf36,0xbf8d,0xbfe3,0xc03b,0xc092,
	0xc0e9,0xc141,0xc198,0xc1f0,0xc248,0xc2a0,0xc2f9,0xc351,
	0xc3aa,0xc402,0xc45b,0xc4b4,0xc50e,0xc567,0xc5c0,0xc61a,
	0xc674,0xc6cd,0xc727,0xc782,0xc7dc,0xc836,0xc891,0xc8eb,
	0xc946,0xc9a1,0xc9fc,0xca58,0xcab3,0xcb0e,0xcb6a,0xcbc6,
	0xcc21,0xcc7d,0xccda,0xcd36,0xcd92,0xcdef,0xce4b,0xcea8,
	0xcf05,0xcf62,0xcfbf,0xd01c,0xd079,0xd0d6,0xd134,0xd192,
	0xd1ef,0xd24d,0xd2ab,0xd309,0xd367,0xd3c6,0xd424,0xd483,
	0xd4e1,0xd540,0xd59f,0xd5fe,0xd65d,0xd6bc,0xd71b,0xd77a,
	0xd7da,0xd839,0xd899,0xd8f8,0xd958,0xd9b8,0xda18,0xda78,
	0xdad8,0xdb38,0xdb99,0xdbf9,0xdc5a,0xdcba,0xdd1b,0xdd7c,
	0xdddd,0xde3e,0xde9f,0xdf00,0xdf61,0xdfc2,0xe023,0xe085,
	0xe0e6,0xe148,0xe1a9,0xe20b,0xe26d,0xe2cf,0xe331,0xe393,
	0xe3f5,0xe457,0xe4b9,0xe51b,0xe57e,0xe5e0,0xe642,0xe6a5,
	0xe707,0xe76a,0xe7cd,0xe830,0xe892,0xe8f5,0xe958,0xe9bb,
	0xea1e,0xea81,0xeae4,0xeb47,0xebab,0xec0e,0xec71,0xecd5,
	0xed38,0xed9c,0xedff,0xee63,0xeec6,0xef2a,0xef8e,0xeff1,
	0xf055,0xf0b9,0xf11d,0xf180,0xf1e4,0xf248,0xf2ac,0xf310,
	0xf374,0xf3d8,0xf43c,0xf4a1,0xf505,0xf569,0xf5cd,0xf631,
	0xf696,0xf6fa,0xf75e,0xf7c2,0xf827,0xf88b,0xf8ef,0xf954,
	0xf9b8,0xfa1d,0xfa81,0xfae5,0xfb4a,0xfbae,0xfc13,0xfc77,
	0xfcdc,0xfd40,0xfda5,0xfe09,0xfe6e,0xfed2,0xff37,0xff9b,
	0x0000,0x0065,0x00c9,0x012e,0x0192,0x01f7,0x025b,0x02c0,
	0x0324,0x0389,0x03ed,0x0452,0x04b6,0x051b,0x057f,0x05e3,
	0x0648,0x06ac,0x0711,0x0775,0x07d9,0x083e,0x08a2,0x0906,
	0x096a,0x09cf,0x0a33,0x0a97,0x0afb,0x0b5f,0x0bc4,0x0c28,
	0x0c8c,0x0cf0,0x0d54,0x0db8,0x0e1c,0x0e80,0x0ee3,0x0f47,
	0x0fab,0x100f,0x1072,0x10d6,0x113a,0x119d,0x1201,0x1264,
	0x12c8,0x132b,0x138f,0x13f2,0x1455,0x14b9,0x151c,0x157f,
	0x15e2,0x1645,0x16a8,0x170b,0x176e,0x17d0,0x1833,0x1896,
	0x18f9,0x195b,0x19be,0x1a20,0x1a82,0x1ae5,0x1b47,0x1ba9,
	0x1c0b,0x1c6d,0x1ccf,0x1d31,0x1d93,0x1df5,0x1e57,0x1eb8,
	0x1f1a,0x1f7b,0x1fdd,0x203e,0x209f,0x2100,0x2161,0x21c2,
	0x2223,0x2284,0x22e5,0x2346,0x23a6,0x2407,0x2467,0x24c8,
	0x2528,0x2588,0x25e8,0x2648,0x26a8,0x2708,0x2767,0x27c7,
	0x2826,0x2886,0x28e5,0x2944,0x29a3,0x2a02,0x2a61,0x2ac0,
	0x2b1f,0x2b7d,0x2bdc,0x2c3a,0x2c99,0x2cf7,0x2d55,0x2db3,
	0x2e11,0x2e6e,0x2ecc,0x2f2a,0x2f87,0x2fe4,0x3041,0x309e,
	0x30fb,0x3158,0x31b5,0x3211,0x326e,0x32ca,0x3326,0x3383,
	0x33df,0x343a,0x3496,0x34f2,0x354d,0x35a8,0x3604,0x365f,
	0x36ba,0x3715,0x376f,0x37ca,0x3824,0x387e,0x38d9,0x3933,
	0x398c,0x39e6,0x3a40,0x3a99,0x3af2,0x3b4c,0x3ba5,0x3bfe,
	0x3c56,0x3caf,0x3d07,0x3d60,0x3db8,0x3e10,0x3e68,0x3ebf,
	0x3f17,0x3f6e,0x3fc5,0x401d,0x4073,0x40ca,0x4121,0x4177,
	0x41ce,0x4224,0x427a,0x42d0,0x4325,0x437b,0x43d0,0x4425,
	0x447a,0x44cf,0x4524,0x4578,0x45cd,0x4621,0x4675,0x46c9,
	0x471c,0x4770,0x47c3,0x4816,0x4869,0x48bc,0x490f,0x4961,
	0x49b4,0x4a06,0x4a58,0x4aa9,0x4afb,0x4b4c,0x4b9d,0x4bee,
	0x4c3f,0x4c90,0x4ce0,0x4d31,0x4d81,0x4dd1,0x4e20,0x4e70,
	0x4ebf,0x4f0e,0x4f5d,0x4fac,0x4ffb,0x5049,0x5097,0x50e5,
	0x5133,0x5181,0x51ce,0x521b,0x5268,0x52b5,0x5302,0x534e,
	0x539b,0x53e7,0x5432,0x547e,0x54c9,0x5515,0x5560,0x55aa,
	0x55f5,0x563f,0x568a,0x56d3,0x571d,0x5767,0x57b0,0x57f9,
	0x5842,0x588b,0x58d3,0x591c,0x5964,0x59ac,0x59f3,0x5a3b,
	0x5a82,0x5ac9,0x5b0f,0x5b56,0x5b9c,0x5be2,0x5c28,0x5c6e,
	0x5cb3,0x5cf9,0x5d3e,0x5d82,0x5dc7,0x5e0b,0x5e4f,0x5e93,
	0x5ed7,0x5f1a,0x5f5d,0x5fa0,0x5fe3,0x6025,0x6068,0x60aa,
	0x60eb,0x612d,0x616e,0x61af,0x61f0,0x6231,0x6271,0x62b1,
	0x62f1,0x6331,0x6370,0x63af,0x63ee,0x642d,0x646c,0x64aa,
	0x64e8,0x6525,0x6563,0x65a0,0x65dd,0x661a,0x6656,0x6693,
	0x66cf,0x670a,0x6746,0x6781,0x67bc,0x67f7,0x6832,0x686c,
	0x68a6,0x68e0,0x6919,0x6952,0x698b,0x69c4,0x69fd,0x6a35,
	0x6a6d,0x6aa4,0x6adc,0x6b13,0x6b4a,0x6b81,0x6bb7,0x6bed,
	0x6c23,0x6c59,0x6c8e,0x6cc3,0x6cf8,0x6d2d,0x6d61,0x6d95,
	0x6dc9,0x6dfd,0x6e30,0x6e63,0x6e96,0x6ec8,0x6efb,0x6f2c,
	0x6f5e,0x6f90,0x6fc1,0x6ff2,0x7022,0x7053,0x7083,0x70b2,
	0x70e2,0x7111,0x7140,0x716f,0x719d,0x71cb,0x71f9,0x7227,
	0x7254,0x7281,0x72ae,0x72db,0x7307,0x7333,0x735e,0x738a,
	0x73b5,0x73e0,0x740a,0x7435,0x745f,0x7488,0x74b2,0x74db,
	0x7504,0x752d,0x7555,0x757d,0x75a5,0x75cc,0x75f3,0x761a,
	0x7641,0x7667,0x768d,0x76b3,0x76d8,0x76fe,0x7722,0x7747,
	0x776b,0x778f,0x77b3,0x77d7,0x77fa,0x781d,0x783f,0x7862,
	0x7884,0x78a5,0x78c7,0x78e8,0x7909,0x7929,0x794a,0x796a,
	0x7989,0x79a9,0x79c8,0x79e6,0x7a05,0x7a23,0x7a41,0x7a5f,
	0x7a7c,0x7a99,0x7ab6,0x7ad2,0x7aee,0x7b0a,0x7b26,0x7b41,
	0x7b5c,0x7b77,0x7b91,0x7bab,0x7bc5,0x7bde,0x7bf8,0x7c10,
	0x7c29,0x7c41,0x7c59,0x7c71,0x7c88,0x7c9f,0x7cb6,0x7ccd,
	0x7ce3,0x7cf9,0x7d0e,0x7d24,0x7d39,0x7d4d,0x7d62,0x7d76,
	0x7d89,0x7d9d,0x7db0,0x7dc3,0x7dd5,0x7de8,0x7dfa,0x7e0b,
	0x7e1d,0x7e2e,0x7e3e,0x7e4f,0x7e5f,0x7e6f,0x7e7e,0x7e8d,
	0x7e9c,0x7eab,0x7eb9,0x7ec7,0x7ed5,0x7ee2,0x7eef,0x7efc,
	0x7f09,0x7f15,0x7f21,0x7f2c,0x7f37,0x7f42,0x7f4d,0x7f57,
	0x7f61,0x7f6b,0x7f74,0x7f7d,0x7f86,0x7f8f,0x7f97,0x7f9f,
	0x7fa6,0x7fad,0x7fb4,0x7fbb,0x7fc1,0x7fc7,0x7fcd,0x7fd2,
	0x7fd8,0x7fdc,0x7fe1,0x7fe5,0x7fe9,0x7fec,0x7ff0,0x7ff3,
	0x7ff5,0x7ff7,0x7ff9,0x7ffb,0x7ffd,0x7ffe,0x7ffe,0x7fff };

