#include "headers.h"
#include "chuck.h"
#include "e_global.h"
#include "shokstrc.h"
#include "enemlogc.h"


ushort	enemyAccuracy[] =
{
	0,				/* */
	1, 				/* PLAYER */
	0x30,     /* ENEMY TANK */
	0x40,     /* BATTLE TANK */
	0x10,     /* AMOURED FIGHTER */
	0x10,     /* APC */
	0xa,     	/* GUN BOAT */
	0x18,     /* GUN EMPL */
	0,      	/* TRUCK */
	0,      	/* TRUCK */
	0,      	/* HOSTAGE */
	0,      	/* HOSTAGE */
	0xa,     	/* HELICOPTER */
	0xa,     	/* GUNSHIP */
	0,      	/* RADAR */
	0x1,     	/* PLYR HELI */
	0x1      	/* PLYR PLANE */
};


short	enemyShootRange[MAX_ROTATING_OBJECTS] =
{
	0,				/* */
	0x1000, 	/* PLAYER */
	0x180,    /* ENEMY TANK */
	0x240,    /* BATTLE TANK */
	0x140,    /* AMOURED FIGHTER */
	0x100,     /* APC */
	0x100,     /* GUN BOAT */
	0x100,     /* GUN EMPL */
	0,      	/* TRUCK */
	0,      	/* TRUCK */
	0,      	/* HOSTAGE */
	0,      	/* HOSTAGE */
	0x200,    /* HELICOPTER */
	0x200,    /* GUNSHIP */
	0x0,      /* RADAR */
	0x800,    /* PLYR HELI */
	0x800     /* PLYR PLANE */
};



short	enemyTargettingRange[MAX_ROTATING_OBJECTS] =
{
	0,				/* */
	0x1000, 	/* PLAYER */
	0xD0,     /* ENEMY TANK */
	0x120,    /* BATTLE TANK */
	0xB0,     /* AMOURED FIGHTER */
	0xa0,     /* APC */
	0xd0,     /* GUN BOAT */
	0xa0,     /* GUN EMPL */
	0,      	/* TRUCK */
	0,      	/* TRUCK */
	0,      	/* HOSTAGE */
	0,      	/* HOSTAGE */
	0x120,    /* HELICOPTER */
	0x140,    /* GUNSHIP */
	0x0,      /* RADAR */
	0x120,    /* PLYR HELI */
	0x300     /* PLYR PLANE */
};


short enemyTriggerRange[MAX_ROTATING_OBJECTS] =
{
	0,				/* */
	0, 				/* PLAYER */
	0x1200,   /* ENEMY TANK */
	0x1500,   /* BATTLE TANK */
	0x1500,   /* AMOURED FIGHTER */
	0x1300,   /* APC */
	0x800,    /* GUN BOAT */
	0x180,    /* GUN EMPL */
	0,      	/* TRUCK */
	0,      	/* TRUCK */
	0,      	/* HOSTAGE */
	0,      	/* HOSTAGE */
	0x800,   	/* HELICOPTER */
	0x800,   	/* GUNSHIP */
	0,      	/* RADAR */
	0,     		/* PLYR HELI */
	0      		/* PLYR PLANE */
};




void	print_tank_data(TANK *);

int		turnLeftDecision, turnRightDecision, moveForwardDecision, moveBackwardDecision, shootDecision, detectionFlag ,dontMoveHelicopter;


TANK	*etank,*targetTank;
ENEMY_TANK_CTRL	*ectrl;
uchar	*wayptChkList;
uint	numAttacking;



/***************************************************************/
/* Tank control setup functions */
/***************************************************************/

int	get_convoy_slot(void)
{
	int n;
	ATTACKING_TANK_DATA *cattack;

	for ( cattack=attackData+MAX_ATTACKING_TANKS, n=0; n<MAX_CONVOY_MEMBERS; n++, cattack++ )
	{
		if ( !cattack->slotUsed )
		{
			cattack->slotUsed = TRUE;
			cattack->numWalls = 0;
			return (n);
		}
	}
	return (-1);
}



void	init_tank_control(TANK *initTank)
{
	ENEMY_TANK_CTRL *etctrl = initTank->ectrl;

	if ( etctrl==NULL  )
	{
		return ;
	}

	etctrl->last_waypoint = etctrl->rejoin_waypoint = etctrl->target_waypoint = etctrl->next_target_waypoint = NULL_ID;

	etctrl->stillCount = etctrl->stillx = etctrl->stillz = 0;

	initTank->collData = NULL;

	switch ( initTank->def )
	{
		case ENEMY_TANK:
		case BATTLE_TANK:
		case AMOURED_FIGHTER:
		case ENEMY_APC:
    	etctrl->control_func = enemy_tank_stationary;
    	etctrl->tank_mode = ESTAT_INACTIVE;
			break;

		case E_HELICOPTER:
		case E_GUNSHIP:
			etctrl->control_func = enemy_helicopter_patroling;
			etctrl->targetTank = &pl;
			initTank->soundHandle=0XFFFFFFFF;				/* Note that the helicopter is not playing a sample */
			etctrl->tank_mode = 0;
			initTank->y=HELICOPTER_PATROLLING_ALTITUDE;
			break;

		case ALLIED_TRUCK:
			if ( etctrl->pathUsed )
			{
				initTank->collData = attackData + MAX_ATTACKING_TANKS + get_convoy_slot();
			}
		case ENEMY_TRUCK:
			if ( etctrl->pathUsed )
			{
	    	etctrl->control_func = truck_start_convoy;
		    etctrl->tank_mode = START_CONVOY;
			}
			else	/* Unless a truck is in a convoy it does nothing */
			{
				etctrl->control_func = NULL;
			}
			break;
	}


}




/***************************************************************/
/* Decision making functions */
/***************************************************************/

#define MIN_WAYPT_SLOW_DOWN_RADIUS	0x40000
#define WAYPT_TARGET_RADIUS					0x40000   // 0X90000


ushort	get_dist_2_target_waypt(void)
{
	int dx,dz;

	dx = (etank->x >> 16) - (ectrl->twayptx);
 	dz = (etank->z >> 16) - (ectrl->twayptz);

	dx *= dx;
	dz *= dz;

	if ((dx+dz) < ( MIN_WAYPT_SLOW_DOWN_RADIUS + (abs(etank->speed<<9)) /*Take grip into account here*/  )	)					/* SLOW DOWN RADIUS AROUND WAYPOINT */
	{
		if ((dx+dz) < (WAYPT_TARGET_RADIUS))						/* TARGET RADIUS AROUND WAYPOINT */
		{
			if ( ectrl->next_target_waypoint!=NULL_ID )
			{
				return (REACHED_TARGET);                  /* Only go into reached target mode if there is a new target to aim for */
			}
			else
				return (SLOW_DOWN);
		}
		else
			return (SLOW_DOWN);
	}

	return (CONTINUE_MOVEMENT);
}



/***************************************************************/

#define HELICOPTER_THREAT_DIST 0xb00
#define TANK_THREAT_DIST			 0xb00	//0x200

ushort	get_closest_waypt(ushort x, ushort z)
{
	uint		dist;										/* squared distance of waypoint from target */
	uint		minDist;										/* Closest distance so far  */
	uint		relx, relz;
	ushort	catchx, catchz;							/* catchment x and z */
	ushort	*catchment;									/* The actual catchment data */
	ushort	catchId;										/* the required catchment id */
	ushort	numWaypts;									/* Number of waypoints in the catchment */
	ushort	closestWaypt=NULL_ID;				/* Closest waypoint */
	ushort	cwayptcnt;									/* Number of waypoints checked in catchment so far */
	ushort	*waypt;											/* Pointer to current waypoint data */
	ushort	wptx, wptz;									/* current waypoint x and z */
	ushort	cwayptId;										/* current waypoint id */
	ushort	oppDir;



	if ( etank->flying )
	{
		oppDir = (pl.dir+0x400)&0x7ff;

		x += ((HELICOPTER_THREAT_DIST * ((int)sintab[oppDir+512])) >> 15);
		z += ((HELICOPTER_THREAT_DIST * ((int)sintab[oppDir])) >> 15);
	}



	/* Find catchment target is in */

	catchx = catchTable[(x>>11)];
	catchz = catchTable[(z>>11)];

	catchId = catchx + (CATCHMENTS_ACROSS*catchz);

	catchment = catch_data + *(catch_index+catchId);

	numWaypts = *catchment++; 	// Get number of waypoints in catchment

	cwayptcnt = 0;

	minDist = 0xffffffff;

	while ( cwayptcnt<numWaypts )
	{
		cwayptId = *catchment;
		waypt = waypt_data + *(waypt_index + *catchment++);

		waypt++;	/* skip over the number of links value */
		wptx = *waypt++;
		wptz = *waypt++;

		relx = abs((int)(wptx - x));
		relz = abs((int)(wptz - z));

		dist = (wptx>wptz) ? (relx+(relz>>1)) : (relz+(relx>>1));

		if ( (dist < minDist) && (wayptChkList[cwayptId]==0) )	/* If waypoint is closer and not in use then note its id */
		{
			closestWaypt = cwayptId;
			minDist = dist;
		}
		cwayptcnt++;
	}

	if ( closestWaypt!=NULL_ID && !ectrl->pathUsed)        														/* Note that the waypoint is now in use */
	{
		wayptChkList[closestWaypt] = TRUE;
		ectrl->rejoin_waypoint = closestWaypt;
	}

	return (closestWaypt);
}



/***************************************************************/


ushort	get_linked_closest_waypoint(uint	excludeId, uint excludeFlag)
{
	ushort	targetx, targetz;
	uint		dist;										/* squared distance of waypoint from target */
	uint		minDist;										/* Closest distance so far  */
	uint		relx, relz;
	ushort	*waypt;											/* Pointer to current waypoint data */
	ushort	*link;
	ushort	*lwaypt;										/* pointer to the linked waypoint */
	ushort	wptx, wptz;									/* current waypoint x and z */
	ushort	cwayptId;										/* current waypoint id */
	ushort	closestWaypt=NULL_ID;				/* Closest waypoint */
	ushort	numLinks;
	ushort	linkCnt;
	ushort	linkCondition;
	ushort	oppDir;
	ushort	twaypoint;


	if ( etank!=NULL && etank->flying )
	{
		oppDir = (pl.dir+0x400)&0x7ff;

  	targetx = targetTank->x>>16;
  	targetz = targetTank->z>>16;

		targetx += ((HELICOPTER_THREAT_DIST * ((int)sintab[oppDir+512])) >> 15);
		targetz += ((HELICOPTER_THREAT_DIST * ((int)sintab[oppDir])) >> 15);
	}
	else
	{
  	switch ( ectrl->iq )
  	{
			case SMART:
				oppDir = (pl.dir+0x400)&0x7ff;
  			targetx = targetTank->x>>16;
  			targetz = targetTank->z>>16;
				targetx += ((TANK_THREAT_DIST * ((int)sintab[oppDir+512])) >> 15);
				targetz += ((TANK_THREAT_DIST * ((int)sintab[oppDir])) >> 15);
				break;


  		case QUITE_DIM:
  			targetx = targetTank->x>>16;
  			targetz = targetTank->z>>16;
  			break;


			default:
  			targetx = targetTank->x>>16;
  			targetz = targetTank->z>>16;
				break;
  	}
	}


	if ( ectrl->target_waypoint!=NULL_ID )
	{
		twaypoint = ectrl->target_waypoint;

		ectrl->rejoin_waypoint = ectrl->target_waypoint;									/*Note the last waypoint incase tank becomes inactive and needs to rejoin mesh */

		if ( ectrl->control_func!=enemy_wait_for_space )
		{
			wayptChkList[ectrl->rejoin_waypoint] = FALSE;										/*Free up the current target waypoint for use by others */
		}
	}
	else
		twaypoint = ectrl->rejoin_waypoint;

	#ifdef PC_VERSION
	if ( twaypoint==NULL_ID )
	{
		print_tank_data(etank);
		getout("Found a fucker");
	}
	#endif

	waypt = waypt_data + *(waypt_index + twaypoint);		/* Get the best waypoint linked to the current waypoint */

	numLinks = *waypt++;	/* Get the number of links that have to be checked */
	waypt+=2;							/* Skip over the x and z values of the current waypoint */

	minDist = 0xffffffff;



	/* If current target waypoint is elligible then assume it is the best choice */

	if ( excludeFlag & USE_CURRENT_TARGET_WAYPOINT )
	{
		lwaypt = waypt_data + *(waypt_index + ectrl->target_waypoint);

		lwaypt++; /* Skip over number of links data */

		/* Get position of linked waypoint */
		wptx = *lwaypt++;
		wptz = *lwaypt;

		relx = abs(targetx - wptx);
		relz = abs(targetz - wptz);

		minDist = (relx>relz) ? (relx+(relz>>1)) : (relz+(relx>>1));

		closestWaypt = ectrl->target_waypoint;
	}


	for ( linkCnt=0; linkCnt<numLinks; linkCnt++ )
	{
		link = link_data + *waypt++;
		linkCondition = *link++;

		if ( (linkCondition == FALSE) && (!etank->flying) )
		{
			continue;
		}

		if ( *link==ectrl->target_waypoint )
		{
			link++;
		}

		cwayptId = *link;

		if ( cwayptId == excludeId)			/* This waypoint is not to be considered */
		{
			continue;
		}

		if ( wayptChkList[cwayptId] ) 	/* This waypoint is not to be considered - already being used as target */
		{
			continue;
		}

		if ( (cwayptId == ectrl->last_waypoint) && (numLinks>1) ) /*Can't go back to the previous waypoint unless it's the only one */
		{
			continue;
		}



		lwaypt = waypt_data + *(waypt_index + *link);

		lwaypt++; /* Skip over number of links data */

		/* Get position of linked waypoint */
		wptx = *lwaypt++;
		wptz = *lwaypt;

		relx = abs(targetx - wptx);
		relz = abs(targetz - wptz);

		dist = (relx>relz) ? (relx+(relz>>1)) : (relz+(relx>>1));

		if ( (dist < minDist) && (wayptChkList[cwayptId]==0) )	/* If waypoint is closer and not in use then note its id */
		{
			closestWaypt = cwayptId;
			minDist = dist;
		}

		if ( dist < minDist )
		{
			minDist = dist;
			closestWaypt = cwayptId;
		}

	}


	if ( closestWaypt!=NULL_ID )
	{
		wayptChkList[closestWaypt]=TRUE;			/* Note that waypoint is being used as a target */

		if ( ectrl->target_waypoint!=NULL_ID ) 				/* Remember the previous waypoint to prevent oscillation */
		{
			//ectrl->rejoin_waypoint=ectrl->last_waypoint=ectrl->target_waypoint;
			ectrl->last_waypoint=ectrl->target_waypoint;
		}

	}

	return (closestWaypt);
}







ushort	get_linked_closest_convoy_waypoint(void)
{
	TANK		*truckInfront;
	GUN_BOAT	*boatInfront;
	uint		dist;										/* squared distance of waypoint from target */
	uint		minDist;										/* Closest distance so far  */
	int			relx, relz;									/* relative x and z values */
	CONVOY_DATA	*cConvoy;
	ushort	targetx, targetz;
	ushort	closestWaypt=NULL_ID;				/* Closest waypoint */
	ushort	*waypt;											/* Pointer to current waypoint data */
	ushort	*lwaypt;										/* pointer to the linked waypoint */
	ushort	wptx, wptz;									/* current waypoint x and z */
	ushort	cwayptId;										/* current waypoint id */
	ushort	*link;
	ushort	numLinks;
	ushort	linkCnt;
	ushort	linkCondition;
	ushort	*cpath;

	if ( ectrl->convoyLeader )
	{
		/* Get target point for the leader */

		/* Get the path data for the convoy */
		cpath = pathData + *(pathOffsets + ectrl->pathUsed-1);

  	cConvoy = convoyData + ectrl->pathUsed-1;

  	/* Get the current point in the path */
  	cpath += (cConvoy->currentTarget*2)+1;

		/* Get the coordinates of the path point */
		targetx = *cpath++;
		targetz = *cpath;
	}
	else
	{
		/* If not the leader then use the coordinates of the member of convoy infront */
		if ( etank!=NULL )
		{
			truckInfront = get_truck_infront(etank);

			targetx = (truckInfront->x>>16);
			targetz = (truckInfront->z>>16);
		}
		else
		{
			boatInfront = get_boat_infront(mgunboat);

			targetx = (boatInfront->x>>16);
			targetz = (boatInfront->z>>16);
		}
	}

	waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);		/* Get the best waypoint linked to the current waypoint */

	numLinks = *waypt++;	/* Get the number of links that have to be checked */
	waypt+=2;							/* Skip over the x and z values of the current waypoint */

	minDist = 0xffffffff;

	for ( linkCnt=0; linkCnt<numLinks; linkCnt++ )
	{
		link = link_data + *waypt++; // *waypt++
		linkCondition = *link++;
//		link++;							// skip over the link condition - assume you have no conditional links for convoy trucks

		if ( linkCondition == FALSE )
		{
			continue;
		}

		if ( *link==ectrl->target_waypoint )
		{
			link++;
		}

		cwayptId = *link;

		if ( cwayptId==NULL_ID ) 				/* Shouldn't really need */
		{
			continue;
		}

		if ( cwayptId == ectrl->last_waypoint ) /*Can't go back to the previous waypoint */
		{
			continue;
		}

		lwaypt = waypt_data + *(waypt_index + *link);

		lwaypt++; /* Skip over number of links data */

		/* Get position of linked waypoint */
		wptx = *lwaypt++;
		wptz = *lwaypt;

		relx = abs(targetx - wptx);
		relz = abs(targetz - wptz);

		dist = (relx>relz) ? (relx+(relz>>1)) : (relz+(relx>>1));

		if ( dist < minDist )
		{
			minDist = dist;
			closestWaypt = cwayptId;
		}
	}

	if ( (closestWaypt!=NULL_ID) && (ectrl->target_waypoint!=NULL_ID) )
	{
		ectrl->last_waypoint=ectrl->target_waypoint;	/* Remember the previous waypoint to prevent oscillation */
	}

	return (closestWaypt);
}



/***************************************************************/


ushort	get_turn_dirn(int ang1, int ang2)
{
	int			dang;

	if ( ang1==ang2  )
	{
		return (NO_TURN);
	}

	dang = get_angle_difference(ang1, ang2);

	if ( dang<0 )
	{
		if ( dang<SMALL_TURN_ANGLE )
		{
			return (LARGE_RIGHT_TURN);
		}
		else
		{
			return (SMALL_RIGHT_TURN);
		}
	}
	else
	{
		if ( dang>SMALL_TURN_ANGLE )
		{
			return (LARGE_LEFT_TURN);
		}
		else
		{
			return (SMALL_LEFT_TURN);
		}
	}
}







/***************************************************************/


int	get_angle_difference(int ang1, int ang2)
{
	int	angDiff;

	angDiff = ang2 - ang1;

	if ( abs(angDiff)>0x400 )
	{
		if ( angDiff<0 )
		{
			angDiff = 0x7ff + angDiff;
		}
		else
		{
			angDiff = angDiff - 0x7ff;
		}
	}


	return (angDiff);
}


/***************************************************************/


ushort	get_shoot_decision(void)
{
	int			ang1, ang2, dang;
	int			relx, relz;
	int			angleTolerance;

	if ( (etank->def == ALLIED_TRUCK) || (etank->def ==ENEMY_TRUCK) )
	{
		return (FALSE);
	}

	relx = (etank->x>>24) - (targetTank->x>>24);
	relz = (etank->z>>24) - (targetTank->z>>24);

	relx *= relx;
	relz *= relz;

	if ( (relx+relz) > enemyShootRange[etank->def]  )
	{
		return (FALSE);
	}


	angleTolerance = enemyAccuracy[etank->def];

	ang1 = etank->dir;
	ang2 = phd_atan( etank->x - targetTank->x , etank->z - targetTank->z );

	if ( etank->def!=E_HELICOPTER && etank->def!=E_GUNSHIP )
	{
		if ( !etank->targetVisible )
		{
			return (FALSE);
		}
	}

	dang = get_angle_difference(ang1, ang2);

	if ( abs(dang)<angleTolerance )
	{
		return (TRUE);
	}


	return (FALSE);
}


/***************************************************************/


void	set_turn_decision(TANK *atank, int newTurnDirn)
{
	switch ( newTurnDirn )
	{
		case NO_TURN: /* Force angle and start moving towards point */
			atank->dir = atank->angle = ectrl->angle_2_target;
			atank->turn = 0;	/* Stop the turning momentum - FRIGG */
			break;



		case SMALL_RIGHT_TURN:
			if ( ectrl->small_turn_count>=SMALL_TURN_THRESHOLD )
			{
				/* Wait - still experiencing previous turn */
				if ( ectrl->small_turn_count>=SMALL_TURN_RESET_VALUE )
				{
					ectrl->small_turn_count=0;
				}
			}
			else
				turnRightDecision=TRUE;

			ectrl->small_turn_count++;
			break;



		case LARGE_RIGHT_TURN:
			ectrl->small_turn_count=SMALL_TURN_THRESHOLD;
			turnRightDecision=TRUE;
			break;



 		case SMALL_LEFT_TURN:
			if ( ectrl->small_turn_count>=SMALL_TURN_THRESHOLD )
			{
				/* Wait - still experiencing previous turn */
				if ( ectrl->small_turn_count>=SMALL_TURN_RESET_VALUE )
				{
					ectrl->small_turn_count=0;
				}
			}
			else
				turnLeftDecision=TRUE;

			ectrl->small_turn_count++;

			break;



		case LARGE_LEFT_TURN:
			ectrl->small_turn_count=SMALL_TURN_THRESHOLD;
			turnLeftDecision=TRUE;
			break;
	}
}


/***************************************************************/

/* Pauls line of sight test function */

int		test_line_of_sight(int x1, int y1, int x2, int y2 )
{
	int		n;
  int		los_xerr=0;
	int		los_yerr=0;
	int		los_currentx;
	int		los_currenty;
	int		los_dx, los_dy;
	int		los_incx, los_incy;

  if ( x1==x2 )							// Vertical Line Draw!!
 	{
		if ( y1<=y2 )
		{
 			for (  ;y1<=y2; y1++ )
			{
 				if ( test_los_bit( x1, y1 ) )
					return(0);
			}
		}
		else
		{
 			for (  ;y2<=y1; y2++ )
			{
 				if ( test_los_bit( x1, y2 ) )
					return(0);
			}
		}
	}
  	else if ( y1==y2 )						// Horizontal line
 	{
		if ( x1<=x2 )
		{
 			for (  ;x1<=x2; x1++ )
			{
 				if ( test_los_bit( x1, y1 ) )
					return(0);
			}
		}
		else
		{
 			for (  ;x2<=x1; x2++ )
			{
 				if ( test_los_bit( x2, y1 ) )
					return(0);
			}
		}
 	}
  	else
 	{
  		los_dx = x2-x1;           // Line Is Tilted!!
  		los_dy = y2-y1;

  		if ( los_dx>=0 )
			los_incx = 1;
  		else
		{
			los_incx = -1;
			los_dx = -los_dx;
		}
  		if ( los_dy>=0 )
			los_incy = 1;
  		else
		{
			los_incy = -1;
			los_dy = -los_dy;
		}
		los_dx++;
		los_dy++;

  		los_currentx = x1;
  		los_currenty = y1;

  		if( los_dx>=los_dy )			// MAJOR axis is X
		{
  			for( n=los_dx; n>0; n--, los_currentx+=los_incx )
 			{
 				if ( test_los_bit(los_currentx, los_currenty) )
					return(0);
  				los_yerr += los_dy;
  				if ( los_yerr>los_dx )
 				{
  					los_yerr -= los_dx;
  					los_currenty += los_incy;
					if ( test_los_bit(los_currentx,los_currenty) )
						return(0);
 				}
			}
 		}
		else             				// MAJOR axis is Y
		{
  			for( n=los_dy; n>0; n--, los_currenty+=los_incy )
 			{
 				if ( test_los_bit(los_currentx, los_currenty) )
					return(0);
  				los_xerr += los_dx;
  				if ( los_xerr>los_dy )
 				{
  					los_xerr -= los_dy;
  					los_currentx += los_incx;
					if ( test_los_bit(los_currentx,los_currenty) )
						return(0);
 				}
			}
		}
 	}
	return(1);
}



/***************************************************************/


void	clear_waypoint_check(TANK *destroyedTank)
{
	if ( destroyedTank->flying )
	{
  	if ( destroyedTank->ectrl->next_target_waypoint!=NULL_ID )
  	{
  		HeliWayptChkList[destroyedTank->ectrl->next_target_waypoint]=FALSE;
  	}

  	if ( destroyedTank->ectrl->target_waypoint!=NULL_ID )
  	{
  		HeliWayptChkList[destroyedTank->ectrl->target_waypoint]=FALSE;
  	}

		if (  destroyedTank->ectrl->last_waypoint!= NULL_ID)
		{
		 	TankWayptChkList[destroyedTank->ectrl->last_waypoint] = FALSE;
		}

		if ( destroyedTank->ectrl->rejoin_waypoint!= NULL_ID )
		{
			TankWayptChkList[destroyedTank->ectrl->rejoin_waypoint] = FALSE;
		}

		destroyedTank->ectrl->last_waypoint =
		destroyedTank->ectrl->rejoin_waypoint =
		destroyedTank->ectrl->target_waypoint =
		destroyedTank->ectrl->next_target_waypoint = NULL_ID;
		destroyedTank->ectrl->tank_mode = 0;
		return ;
	}


	if ( destroyedTank->ectrl->next_target_waypoint!=NULL_ID )
	{
		TankWayptChkList[destroyedTank->ectrl->next_target_waypoint]=FALSE;
	}

	if ( destroyedTank->ectrl->target_waypoint!=NULL_ID )
	{
		TankWayptChkList[destroyedTank->ectrl->target_waypoint]=FALSE;
	}

	if (  destroyedTank->ectrl->last_waypoint!= NULL_ID)
	{
		 TankWayptChkList[destroyedTank->ectrl->last_waypoint] = FALSE;
	}

	if ( destroyedTank->ectrl->rejoin_waypoint!= NULL_ID )
	{
		TankWayptChkList[destroyedTank->ectrl->rejoin_waypoint] = FALSE;
	}

	destroyedTank->ectrl->last_waypoint =
	destroyedTank->ectrl->rejoin_waypoint =
	destroyedTank->ectrl->target_waypoint =
	destroyedTank->ectrl->next_target_waypoint = NULL_ID;
}


/***************************************************************/

void	get_control_decisions(void)
{
	dontMoveHelicopter = turnLeftDecision = turnRightDecision = moveForwardDecision = moveBackwardDecision = shootDecision = detectionFlag = 0;

	targetTank = &pl;

	if ( ectrl->control_func!=NULL )
	{
		/*-----------------05/11/95 15:24-------------------
		 check that the enemy object has a valid target tank
		--------------------------------------------------*/

		if ( objectiveType==PROTECT_CONVOY_OBJECTIVE &&
				 ectrl->control_func!=enemy_tank_stationary &&
				 etank->def!=ALLIED_TRUCK &&
				 etank->def!=ENEMY_TRUCK )     // enemy trucks don't detect against anything (A HORRIBLE UGLY BODGE!!!)
		{
			if ( !(ectrl->targetTank->def) )	/* Current target tank for enemy no longer exists - find a new one */
			{
				int	reltx, reltz;				/* Relative distances in terms of tiles */
				int	sqrtdist;						/* squared distance in tiles */
				int	minsqrtdist;
				CONVOY_DATA	*cConvoy;
    		int j;
    		ushort	*cmember;
    		TANK	*alliedTruck;

    		/** find the closest target tank - either an allied convoy truck or the player */
      	reltx = (pl.x >> 24) - (etank->x >> 24);	/* Get relative distance in terms of floor tiles */
      	reltz = (pl.z >> 24) - (etank->z >> 24);

      	reltx *= reltx;
      	reltz *= reltz;

    		/** assume the player tank is the closest target tank */
    		ectrl->targetTank = targetTank = &pl;
      	minsqrtdist = reltx + reltz;

    		/** assume their is only one allied convoy (in convoyData[0] **/

    		for ( j=0, cConvoy=convoyData, cmember=cConvoy->members; j<cConvoy->numMembers; j++ )
    		{
					alliedTruck = enemyTanks+(*cmember++);
    			/** get distance to the possible target tank **/
    	  	reltx = (alliedTruck->x >> 24) - (etank->x >> 24);	/* Get relative distance in terms of floor tiles */
        	reltz = (alliedTruck->z >> 24) - (etank->z >> 24);

      		reltx *= reltx;
      		reltz *= reltz;

    			if ( (sqrtdist=(reltx+reltz)) < minsqrtdist )
    			{
    				ectrl->targetTank = targetTank = alliedTruck;
    				minsqrtdist = sqrtdist;
    			}
    		}
    	}
		}

		targetTank = ectrl->targetTank;

		(*ectrl->control_func)();
		if ( ectrl->control_func!=enemy_tank_stationary && ectrl->control_func!=enemy_helicopter_patroling )
		{
			shootDecision = get_shoot_decision();
		}
	}
}

