#include "headers.h"

#include "chuck.h"

#ifdef MEMCHK
#include <memcheck.h>
#endif


#define NO_EFFECT					0XFF


uchar		animations[MAX_ANIMATIONS][2] =
			{ FRAGMENT1_FRAME, FRAGMENT1_FRAME+3,
				FRAGMENT2_FRAME, FRAGMENT2_FRAME+3,
				FRAGMENT3_FRAME, FRAGMENT3_FRAME+3,
				FRAGMENT4_FRAME, FRAGMENT4_FRAME+3,
				FRAGMENT5_FRAME, FRAGMENT5_FRAME+3,
				FRAGMENT6_FRAME, FRAGMENT6_FRAME+7,
				AIRBURST_FRAME,  AIRBURST_FRAME+9,
				GROUND_EXPL_FRAME, GROUND_EXPL_FRAME+9,
				SMOKE_FRAME, 		 SMOKE_FRAME+9,
				FRAG_DISIN_FRAME1, FRAG_DISIN_FRAME1+5,
				FIRE_FRAG_EXPL_FRAME, FIRE_FRAG_EXPL_FRAME+3,
				FIRE_FRAG_BURN_FRAME, FIRE_FRAG_BURN_FRAME+3,
				FIRE_FRAG_HITTING_FLOOR, FIRE_FRAG_HITTING_FLOOR+12,
				WIRE_MESH_FRAME, WIRE_MESH_FRAME+3,
				CONCRETE_1_FRAME, CONCRETE_1_FRAME+3,
				CONCRETE_2_FRAME, CONCRETE_2_FRAME+3,
				CONCRETE_3_FRAME, CONCRETE_3_FRAME+3,
				WOODEN_PLANK_FRAME, WOODEN_PLANK_FRAME+3,
				CORRI_METAL_FRAME, CORRI_METAL_FRAME+3,
				TWIGS_1_FRAME, TWIGS_1_FRAME+3,
				TWIGS_2_FRAME, TWIGS_2_FRAME+3,
				TRAIL_SMOKE_FRAME, TRAIL_SMOKE_FRAME+5,
				WATER_EXPLOSION_FRAME, WATER_EXPLOSION_FRAME+9,
				WATER_SPLASH_FRAME, WATER_SPLASH_FRAME+7,
				BULLET_HIT_FRAME1, BULLET_HIT_FRAME1,
				BULLET_HIT_FRAME2, BULLET_HIT_FRAME2+1,
				BULLET_HIT_FRAME3, BULLET_HIT_FRAME3+1,
				BULLET_HIT_FRAME4, BULLET_HIT_FRAME4+1,
				FUEL_TANK_FRAG_FRAME, FUEL_TANK_FRAG_FRAME+3
			};



/* This is the array of delayed fx */

uchar						fxlistTypes[MAX_FX_GROUPS][MAX_DELAY_FX] =
			{ SMALL_GROUND_EXP, LARGE_TRAN_GROUND_EXP, SMALL_AIRFRAG_BURST, 	MUSHROOM_CLOUD,  		/* Tank delayed explosion fx */

				SMALL_GROUND_EXP, MUSHROOM_CLOUD,				 0,											0,									/* Building delayed explosion fx */

				LARGE_TRAN_AIR_EXP, SMALL_AIRFRAG_BURST, MUSHROOM_CLOUD, 				0,                  /* Helicopter delayed explosion fx */

				SMALL_GROUND_EXP, LARGE_WATER_EXP, 			SMALL_AIRFRAG_BURST, 	MUSHROOM_CLOUD			/* Gunboat explosion */
			};


/* This is the delay information for the delayed fx */

uchar						fxlistDelays[MAX_FX_GROUPS][MAX_DELAY_FX] =
			{
				0x4, 				0xA,  			0x00, 			0x2a,					/* Tank delayed explosion fx */

				0X4, 				0X20, 			NO_EFFECT,	NO_EFFECT,		/* Building delayed explosion fx */

				0x4, 				0x0, 				0xa, 				NO_EFFECT,		/* Helicopter delayed explosion fx */

				0x4, 				0xA,  			0x00, 			0x2a					/* Gunboat explosion */
			};


