#include "headers.h"


#include "shell.h"
#include "chuck.h"
#include "e_global.h"
#include "enemlogc.h"



ENEMY_TANK_CTRL		*gunboatCtrl=NULL;




GUN_BOAT	*mgunboat;


ushort	get_gunboat_closest_waypt(ushort x, ushort z);
ushort	get_gunboat_dist_2_target_waypt(void);
void	destroy_gunboat_convoy_member(GUN_BOAT *dboat);
void	update_boat(void);

/***************************************************************/


void	gunboat_start_convoy(void);
void	gunboat_follow_convoy(void);
void	gunboat_reached_end(void);

/***************************************************************/

ushort	get_gunboat_closest_waypt(ushort x, ushort z)
{
	uint		sqrDist;										/* squared distance of waypoint from target */
	uint		csqrDist;										/* Closest distance so far  */
	uint		relx, relz;									/* relative x and z values */
	ushort	catchx, catchz;							/* catchment x and z */
	ushort	*catchment;									/* The actual catchment data */
	ushort	catchId;										/* the required catchment id */
	ushort	numWaypts;									/* Number of waypoints in the catchment */
	ushort	closestWaypt=NULL_ID;				/* Closest waypoint */
	ushort	cwayptcnt;									/* Number of waypoints checked in catchment so far */
	ushort	*waypt;											/* Pointer to current waypoint data */
	ushort	wptx, wptz;									/* current waypoint x and z */
	ushort	cwayptId;										/* current waypoint id */


	/* Find catchment target is in */

	catchx = catchTable[(x>>11)];
	catchz = catchTable[(z>>11)];

	catchId = catchx + (CATCHMENTS_ACROSS*catchz);

	catchment = catch_data + *(catch_index+catchId);

	numWaypts = *catchment++; 					// Get number of waypoints in catchment

	cwayptcnt = 0;

	csqrDist = 0xffffffff;

	while ( cwayptcnt<numWaypts )
	{
		cwayptId = *catchment;
		waypt = waypt_data + *(waypt_index + *catchment++);

		waypt++;													/* skip over the number of links value */
		wptx = *waypt++;
		wptz = *waypt++;

		relx = abs((int)(wptx - x));
		relz = abs((int)(wptz - z));

		sqrDist = relx*relx + relz*relz;

		if ( sqrDist < csqrDist )					/* If waypoint is closer and not in use then note its id */
		{
			closestWaypt = cwayptId;
			csqrDist = sqrDist;
		}
		cwayptcnt++;
	}

	return (closestWaypt);
}









GUN_BOAT	*	get_boat_infront(GUN_BOAT *boat)
{
	uint	tankIndex;
	uint	prevIndex;
	CONVOY_DATA	*cConvoy;
	ushort	*members;
	uint	cnt;

	tankIndex = boat - gunboats;

	cConvoy = convoyData + (boat->ectrl->pathUsed)-1;

	cnt = 0;

	members = cConvoy->members;
	prevIndex = *members;

	members++;

	while ( cnt<cConvoy->numMembers )
	{
		if ( tankIndex==*members )
		{
			break;
		}

		prevIndex=*members;
		members++;


		cnt++;
	}

	return (gunboats+prevIndex);
}

/***************************************************************/

void	set_gunboat_turn_decision(GUN_BOAT *tgunboat, int newTurnDirn)
{
	switch ( newTurnDirn )
	{
		case NO_TURN: /* Force angle and start moving towards point */
			tgunboat->angle = ectrl->angle_2_target;
			break;


		case SMALL_RIGHT_TURN:

		case LARGE_RIGHT_TURN:
			turnRightDecision=TRUE;
			break;



 		case SMALL_LEFT_TURN:

		case LARGE_LEFT_TURN:
			turnLeftDecision=TRUE;
			break;
	}
}


/***************************************************************/

#define MIN_WAYPT_SLOW_DOWN_RADIUS	0x40000
#define WAYPT_TARGET_RADIUS					0x40000   // 0X90000


ushort	get_gunboat_dist_2_target_waypt(void)
{
	int dx,dz;

	dx = (mgunboat->x >> 16) - (ectrl->twayptx);
 	dz = (mgunboat->z >> 16) - (ectrl->twayptz);

	dx *= dx;
	dz *= dz;

	if ( (dx+dz) < MIN_WAYPT_SLOW_DOWN_RADIUS )
	{
		if ((dx+dz) < WAYPT_TARGET_RADIUS)						/* TARGET RADIUS AROUND WAYPOINT */
		{
			if ( ectrl->next_target_waypoint!=NULL_ID )
			{
				return (REACHED_TARGET);                  /* Only go into reached target mode if there is a new target to aim for */
			}
			else
				return (SLOW_DOWN);
		}
		else
			return (SLOW_DOWN);
	}

	return (CONTINUE_MOVEMENT);
}



/***************************************************************/

void	damage_gunboat(GUN_BOAT	*dboat, int damageVal)
{
	int				cosang,sinang;
	POSITION	gboatpos;

	dboat->armour-=damageVal;

	if ( dboat->armour < 0 )
	{
		dboat->exist = FALSE;

		gboatpos.x = dboat->x;
		gboatpos.y = 0;
		gboatpos.z = dboat->z;

		cosang = (int)sintab[dboat->angle+512];
		sinang = (int)sintab[dboat->angle];

		trigger_explosion(GUNBOAT_EXPLOSION, (POSITION*)&(gboatpos.x), (POSITION*)&(gboatpos.x));

		gboatpos.x = dboat->x + (0x500*sinang);
		gboatpos.z = dboat->z + (0x500*cosang);

		trigger_explosion(GUN_EMPLACEMENT_EXPLOSION, (POSITION*)&(gboatpos.x), (POSITION*)&(gboatpos.x));

		gboatpos.x = dboat->x - (0x400*sinang);
		gboatpos.z = dboat->z - (0x400*cosang);

		/** Start gunboat fx explosion here **/

		trigger_explosion(GUN_EMPLACEMENT_EXPLOSION, (POSITION*)&(gboatpos.x), (POSITION*)&(gboatpos.x));

		enemy_destroyed_sound(ENEMY_GUNBOAT, dboat->x, dboat->z);


		if ( dboat->ectrl != NULL )
		{
			destroy_gunboat_convoy_member(dboat);
		}

	}
	else
	{
		enemy_hit_sound(dboat->x, dboat->z, damageVal);
	}
}



/***************************************************************/


void	destroy_gunboat_convoy_member(GUN_BOAT *dboat)
{
	CONVOY_DATA	*cConvoy;
	uint	boatIndex;
	ushort	*cmember;
	ushort	memberCnt;
	ENEMY_TANK_CTRL	*boatctrl;


	boatctrl = dboat->ectrl;
	cConvoy = convoyData + (boatctrl->pathUsed)-1;

	totalConvoyMembers--;

	if ( boatctrl->convoyLeader ) /* Destroyed leader - need to get new leader */
	{
		if ( (--cConvoy->numMembers) )
		{
			/* Another member left */
			memmove(cConvoy->members, cConvoy->members+1, sizeof(short)*(MAX_CONVOY_MEMBERS-1) );
			cConvoy->members[MAX_CONVOY_MEMBERS-1] = NULL_ID;

			(gunboats+cConvoy->members[0])->ectrl->convoyLeader=TRUE;	/*Make new leader*/
		}
		else
			convoyDestroyed = TRUE;
	}
	else
	{
		/* Destroy a follower */
		boatIndex = dboat - gunboats;
		memberCnt = 0;
		cmember = cConvoy->members;

		/* Find position of boat in convoy */

		while ( memberCnt<cConvoy->numMembers )
		{
			if ( boatIndex==*cmember )
			{
				break;
			}

			cmember++;
			memberCnt++;
		}

		cConvoy->numMembers--;

		if ( cConvoy->numMembers==0 ) /* Shouldn't get to this */
		{
			convoyDestroyed = TRUE;
			return ;
		}


		if ( memberCnt==cConvoy->numMembers ) /* Member is last one in convoy */
		{
			cConvoy->members[memberCnt]=NULL_ID;
			return ;
		}

		memmove(cConvoy->members+memberCnt, cConvoy->members+memberCnt+1, MAX_CONVOY_MEMBERS-memberCnt-1);

		cConvoy->members[MAX_CONVOY_MEMBERS-1]=NULL_ID;
	}
}




void	init_gunboat(GUN_BOAT *initboat)
{
	ENEMY_TANK_CTRL *boatctrl = initboat->ectrl;

	if ( boatctrl==NULL  )
	{
		return ;
	}

	boatctrl->last_waypoint = boatctrl->rejoin_waypoint = boatctrl->target_waypoint = boatctrl->next_target_waypoint = NULL_ID;
	boatctrl->stillCount 		= boatctrl->stillx 					= boatctrl->stillz = 0;
 	boatctrl->control_func 	= gunboat_start_convoy;
	boatctrl->tank_mode 		= START_CONVOY;
}


#define GUNBOAT_SHOOT_RANGE		0x2000


void	move_gunboats(void)
{
	int	n;
	uint	relx, relz, dist;

	etank = NULL; // so that the waypoint functions arent dealing with tanks/helicopters

	for ( n=0, mgunboat=gunboats ; n<MAX_GUN_BOATS; n++, mgunboat++ )
	{
		if ( mgunboat->exist )
		{
			relx = abs((pl.x>>16) - (mgunboat->x>>16));
			relz = abs((pl.z>>16) - (mgunboat->z>>16));

			dist = (relx>relz) ? (relx+(relz>>1)) : (relz+(relx>>1));

			if ( dist<GUNBOAT_SHOOT_RANGE )
			{
				gunboat_fire_bullet(mgunboat, &pl);
			}

			if ( mgunboat->shellDelayCount )
			{
				mgunboat->shellDelayCount--;
			}


			if ( mgunboat->ectrl!=NULL )
			{
				ectrl=mgunboat->ectrl;
				moveForwardDecision = moveBackwardDecision = turnLeftDecision = turnRightDecision = FALSE;

				if ( mgunboat->ectrl->control_func!=NULL )
				{
					(*(mgunboat->ectrl->control_func))();
				}

				update_boat();
			}
		}
	}
}



#define GUNBOAT_TURN_AMOUNT  0x1

#define MAX_GUNBOAT_TURN		8


void	update_boat(void)
{
	if ( turnRightDecision )
	{
		mgunboat->angle --;
	}
	else
	if ( turnLeftDecision )
	{
		mgunboat->angle ++;
	}

	mgunboat->angle &= 0x7ff;


	if ( moveForwardDecision )
	{
		if ( mgunboat->speed < GUNBOAT_MAX_SPEED )
		{
			mgunboat->speed += 4;
		}
	}
	else
	if ( moveBackwardDecision )
	{
		if ( mgunboat->speed > 0  )
		{
			mgunboat->speed -= 4;
		}

		if ( mgunboat->speed < 0  )
			mgunboat->speed = 0;
	}
	else
	if ( mgunboat->speed > 0 )
	{
		mgunboat->speed--;
	}

	mgunboat->x += (mgunboat->speed>>5) * ((int)sintab[mgunboat->angle]);
	mgunboat->z += (mgunboat->speed>>5) * ((int)sintab[mgunboat->angle+512]);
}


/*-----------------29/11/95 15:50-------------------
 gunboat convoy code
--------------------------------------------------*/


void	gunboat_start_convoy(void)
{
	ushort	*waypt;
	ushort	newTurnDirn;

	ectrl->target_waypoint = NULL_ID;
	ectrl->stillCount=0;

	/* Try and find a valid target waypoint */
	ectrl->target_waypoint = get_gunboat_closest_waypt( (mgunboat->x>>16), (mgunboat->z>>16) );

	/* Reset next target waypoint data */
	ectrl->next_target_waypoint = NULL_ID;

	if ( ectrl->target_waypoint==NULL_ID ) 		/* Couldn't find a valid waypoint to use - stay inactive */
	{
		return ;
	}

	/* Get target waypoint coords */

	waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
	waypt++; /* skip over number links associated with waypoint */

	ectrl->twayptx = *waypt++;
	ectrl->twayptz = *waypt;


	/* Get angle to target waypoint */

	ectrl->angle_2_target = (int)(phd_atan( (int)((uint)(mgunboat->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(mgunboat->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff;

	newTurnDirn = get_turn_dirn(mgunboat->angle, ectrl->angle_2_target);

	ectrl->small_turn_count = 0;


	ectrl->control_func = gunboat_follow_convoy;
	mgunboat->angle = ectrl->angle_2_target;
	ectrl->tank_mode = FOLLOW_CONVOY_PATH;
}


void	gunboat_follow_convoy(void)
{
	GUN_BOAT		*boatInfront;
	uint		sqrtDist;
	ushort	relx,relz;
	ushort	pursueDecision;
	ushort	newTurnDirn;
	ushort	*waypt;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;

	switch ( ectrl->tank_mode )
	{
		case FOLLOW_CONVOY_PATH:

			pursueDecision = get_gunboat_dist_2_target_waypt();

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(mgunboat->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(mgunboat->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			switch ( pursueDecision )
			{
				case CONTINUE_MOVEMENT:
					break;


				case SLOW_DOWN:
					if ( ectrl->slow_decision_made )
					{
						break;
					}

    			/* Look for the next possible target waypoint */

    			ectrl->next_target_waypoint = get_linked_closest_convoy_waypoint();

					if ( ectrl->convoyLeader )
					{
						if ( ectrl->next_target_waypoint==NULL_ID )
						{
							ectrl->control_func = gunboat_reached_end;
							return ;
						}
					}

					/* Get angle from current waypoint to next waypoint */

					waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					wayptx = *waypt++;
					wayptz = *waypt;

					angle2NextWaypt = (int)(phd_atan( (int)(ectrl->twayptx - wayptx), (int)(ectrl->twayptz - wayptz) ) &0x7ff);

					angle2NextWaypt = get_angle_difference(angle2NextWaypt, mgunboat->angle);

					if ( angle2NextWaypt < SWING_AROUND_ANGLE )
					{
						ectrl->slow_decision_made = TRUE;
						break;
					}
					else
					if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
					{
						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = CONVOY_SWING_2_TARGET_POINT;

						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(mgunboat->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(mgunboat->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					else
					{
						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = CONVOY_ROTATE_2_TARGET_POINT;
						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(mgunboat->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(mgunboat->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					break;


				case REACHED_TARGET:
					/* First check if reached path checkpoint */

					/* Get new target waypoint */
					ectrl->target_waypoint = ectrl->next_target_waypoint;

					/* Reset next target waypoint data */
					ectrl->next_target_waypoint = NULL_ID;

					/* Get position of target waypoint */
					waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					ectrl->twayptx = *waypt++;
					ectrl->twayptz = *waypt;

					ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(mgunboat->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(mgunboat->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

					ectrl->slow_decision_made = FALSE;
					break;
			}



			if ( ectrl->convoyLeader )
			{
				if ( mgunboat->speed<GUNBOAT_CONVOY_SPEED )
				{
					moveForwardDecision=TRUE;
				}
				else
					moveBackwardDecision=TRUE;

			}
			else
			{
				boatInfront = get_boat_infront(mgunboat);

				relx = (mgunboat->x>>24) - (boatInfront->x>>24);
				relz = (mgunboat->z>>24) - (boatInfront->z>>24);

				relx*=relx;
				relz*=relz;

				sqrtDist = relx+relz;

				if ( sqrtDist > GUNBOAT_CONVOY_SPEEDUP_DIST ) 			/* Truck in front too far away - catchup */
				{
					moveForwardDecision = TRUE;
				}
				else if ( sqrtDist < GUNBOAT_CONVOY_STOP_DIST ) 		/* Truck in front very close - stop */
				{
					mgunboat->speed=0;
				}
				else if ( sqrtDist < GUNBOAT_CONVOY_SLOWDOWN_DIST ) /* Truck in front close - slow down */
				{
					if ( mgunboat->speed > GUNBOAT_CONVOY_SLOW_SPEED )
					{
						moveBackwardDecision = TRUE;
					}
					else
						moveForwardDecision = TRUE;
				}
				else 																				/* The Truck infront is a ROVER */
				{
  				if ( mgunboat->speed<GUNBOAT_CONVOY_SPEED )
  				{
  					moveForwardDecision=TRUE;
  				}
  				else
  					moveBackwardDecision=TRUE;
				}

			}

			/* Readjust angle of truck if need to */

			newTurnDirn = get_turn_dirn(mgunboat->angle, ectrl->angle_2_target);

			set_gunboat_turn_decision(mgunboat, newTurnDirn);
			break;


/********************/

		case CONVOY_SWING_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(mgunboat->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(mgunboat->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(mgunboat->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					mgunboat->angle = ectrl->angle_2_target;
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					return;
					break;

				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */
					turnRightDecision=TRUE;
					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */
					turnLeftDecision=TRUE;
					break;

			}
			break;

/********************/


		case CONVOY_ROTATE_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(mgunboat->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(mgunboat->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(mgunboat->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					mgunboat->angle = ectrl->angle_2_target;
					moveForwardDecision=TRUE;
					ectrl->tank_mode = FOLLOW_CONVOY_PATH;
					break;


				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */
					turnRightDecision=TRUE;
					if ( mgunboat->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( mgunboat->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						mgunboat->speed=0;
					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */
					turnLeftDecision=TRUE;
					if ( mgunboat->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( mgunboat->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						mgunboat->speed=0;
					break;

			}
			break;

	}

}




void	gunboat_reached_end(void)
{
	CONVOY_DATA *cConvoy;

	if ( mgunboat->speed>0x30 )
	{
		moveBackwardDecision=TRUE;
	}
	else
	if ( mgunboat->speed<-0x30 )
	{
		moveForwardDecision=TRUE;
	}
	else
	{
		mgunboat->speed = 0;
		mgunboat->ectrl->control_func = NULL;	/* Turn truck into a stationary truck */
		cConvoy = convoyData + (mgunboat->ectrl->pathUsed)-1;
		convoyCompleted = TRUE;
	}
}

