#include "headers.h"

#include "chuck.h"
#include "e_global.h"
#include "shokstrc.h"
#include "enemlogc.h"

/***************************************************************/

/* Enemy helicopter logic */

/***************************************************************/

#define MAX_ATTACKING_HELICOPTERS      3

uint	numAttackingHelicopters=0;



void  move_helicopters(void)
{
  int     reltx, reltz;       /* Relative distances in terms of tiles */
  int     plrx, plrz;
  int     sqrtdist;           /* squared distance in tiles */
  int     i;

  wayptChkList=HeliWayptChkList;

	targetTank=&pl;

  for ( i=0, etank=helicopters; i<MAX_HELICOPTERS; i++, etank++ )
  {
    if ( etank->def )
		{
			dontMoveHelicopter = FALSE;				/* Assume you have to move the helicopter */

			ectrl = etank->ectrl;

			if ( etank->def == REGENERATE_OBJECT )
			{
      	reltx = (targetTank->x >> 24) - (ectrl->regenx >> 8);	/* Get relative distance in terms of floor tiles */
      	reltz = (targetTank->z >> 24) - (ectrl->regenz >> 8);

      	reltx *= reltx;
      	reltz *= reltz;

      	sqrtdist = reltx + reltz;

				/* regenerate tank if player out of regeneration range */

				if ( sqrtdist>=REGENERATE_RANGE )
				{
					etank->def=ectrl->regenerateId;
					init_tank_control(etank);
					etank->x=ectrl->regenx<<16;
					etank->z=ectrl->regenz<<16;
					etank->angle = etank->dir = ectrl->regenAng;
					etank->speed = 0;
					etank->flying = FALSE;
					continue;
				}
				else
					continue;	/* ignore helicopter otherwise */
			}
			else if ( etank->flying )
			{
				if ( etank->soundHandle==0XFFFFFFFF ) 	/** Check if the helicopter is playing its sample yet */
				{
					start_helicopter_rotor_sound(etank);	/** see if you need to start the sample yet **/
				}
				else
				{
					update_helicopter_sound_rotor_sound(etank);	/** sample started - adjust as appropriate */
				}

				get_control_decisions();

				if ( ectrl->control_func == enemy_helicopter_patroling )
				{
					detectionFlag = FALSE;
				}
				else
					detectionFlag = TRUE;

				if ( !dontMoveHelicopter )
				{
					move_helicopter(etank, turnLeftDecision, turnRightDecision, moveForwardDecision, moveBackwardDecision, shootDecision, detectionFlag);
				}
				else
				if ( shootDecision )
				{
					fire_weapons(etank);
				}
			}
			else
			{
				/* Check if player has triggered a helicopter */

				plrx=pl.x>>16;
				plrz=pl.z>>16;

				if ( plrx>=ectrl->rx1 && plrx<=ectrl->rx2 &&
						 plrz>=ectrl->rz1 && plrz<=ectrl->rz2 &&
						 numAttackingHelicopters < MAX_ATTACKING_HELICOPTERS )
				{

					init_tank_control(etank);
					etank->flying = TRUE;
					etank->y = HELICOPTER_PATROLLING_ALTITUDE;
					numAttackingHelicopters++;
				}
			}
		}
	}
}

/***************************************************************/
/* Moves the helicopter towards to a waypoint near the player tank - ignores everything (above everything) */
/***************************************************************/

void	enemy_helicopter_patroling(void)
{
	int	relx, relz;
	int	newTurnDirn;
	ushort	*waypt;

	if ( etank->y > HELICOPTER_PATROLLING_ALTITUDE ) /* Just left tracking mode - need to climb to patrol height */
	{
		etank->y -= HEIGHT_CHANGE_UNIT;

		if ( etank->speed > 0x20 ) 										/* Stop moving while climbing */
		{
			moveBackwardDecision = TRUE;
		}
		else
			etank->speed = 0;
	}
	else
	{
  	relx = (targetTank->x>>24) - (etank->x>>24);
  	relz = (targetTank->z>>24) - (etank->z>>24);

  	relx *= relx;
  	relz *= relz;

  	if ( (relx+relz) < HELI_START_TRACKING_RANGE )
  	{
  		ectrl->target_waypoint = get_closest_waypt( targetTank->x>>16, targetTank->z>>16 );
  		if ( ectrl->target_waypoint!=NULL_ID )	/*Assume convoy waypoints hav been marked as unusable */
  		{
  			waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
  			waypt++; 															/* skip over number links associated with waypoint */

  			ectrl->twayptx = *waypt++;
  			ectrl->twayptz = *waypt;

  			ectrl->next_target_waypoint = NULL_ID;

  			ectrl->control_func = enemy_helicopter_start_tracking;
				ectrl->tank_mode = 0;
  			return ;
  		}
  	}


  	/* Get angle to target */

  	ectrl->angle_2_target = phd_atan( etank->x - targetTank->x, etank->z - targetTank->z) & 0x7ff;

  	newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

  	set_turn_decision(etank, newTurnDirn);

  	if ( newTurnDirn!=LARGE_LEFT_TURN && newTurnDirn!=LARGE_RIGHT_TURN )
  	{
  		moveForwardDecision = TRUE;
  	}
  	else
  	{
  		if ( etank->speed > 0x20 )
  		{
  			moveBackwardDecision = TRUE;
  		}
			else
				etank->speed = 0;
  	}
	}
}




/***************************************************************/

/* Assumes that a waypoint near the tank has been found */
/* Stop and rotate towards the waypoint selected */

void	enemy_helicopter_start_tracking(void)
{
	int	newTurnDirn;
	int	relx,relz;

	switch ( ectrl->tank_mode )
	{
		case SLOW_2_STOP:
    	/* Slow down to stop */
    	if ( etank->speed > 0x40 )
    	{
    		moveBackwardDecision = TRUE;
    		return ;
    	}
    	else
    	if ( etank->speed < -0x40 )
    	{
    		moveForwardDecision = TRUE;
    		return ;
    	}
    	else
  		{
 				etank->speed = 0;
  			if ( !detect_helicopter_collision(etank, HELICOPTER_DETECT_HEIGHT )) /*Check if helicopter can lower itself to tracking height */
  			{
  				ectrl->tank_mode = FOUND_SUITABLE_SPOT;
  			}
  			else
					ectrl->tank_mode = FIND_SUITABLE_SPOT;
  		}
			break;



		case FIND_SUITABLE_SPOT:
			dontMoveHelicopter = TRUE;

			relx = ((uint)(etank->x>>16)) - ectrl->twayptx;
			relz = ((uint)(etank->z>>16)) - ectrl->twayptz;

			if ( !(relx|relz) )
			{
				ectrl->tank_mode = FOUND_SUITABLE_SPOT;
				break;
			}

			if ( relx < -0x40 )
			{
				etank->x += (0x40<<16);
			}
			else
			if ( relx > 0x40 )
			{
				etank->x -= (0x40<<16);
			}
			else
				etank->x = ectrl->twayptx<<16;


			if ( relz < -0x40 )
			{
				etank->z += (0x40<<16);
			}
			else
			if ( relz > 0x40 )
			{
				etank->z -= (0x40<<16);
			}
			else
				etank->z = ectrl->twayptz<<16;
			break;




		case FOUND_SUITABLE_SPOT:
    	/* Start decscending to tracking height */
			switch ( etank->def )
			{
				case E_HELICOPTER:
		    	if ( etank->y < HELICOPTER_TRACKING_ALTITUDE )
    			{
    				etank->y += HEIGHT_CHANGE_UNIT;
    			}
					break;


				case E_GUNSHIP:
		    	if ( etank->y < GUNSHIP_TRACKING_ALTITUDE )
    			{
    				etank->y += HEIGHT_CHANGE_UNIT;
    			}
					break;
			}

    	/* Get angle to target */
    	ectrl->angle_2_target = phd_atan( (etank->x>>16) - ectrl->twayptx, (etank->z>>16) - ectrl->twayptz) & 0x7ff;
    	newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);
    	set_turn_decision(etank, newTurnDirn);


    	/*Facing waypoint - start tracking */

			switch ( etank->def )
			{
				case E_HELICOPTER:
        	if ( (newTurnDirn == NO_TURN) && (etank->y >= HELICOPTER_TRACKING_ALTITUDE) )
        	{
        		ectrl->control_func = enemy_helicopter_tracking;
        		ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
        	}
					break;


				case E_GUNSHIP:
        	if ( (newTurnDirn == NO_TURN) && (etank->y >= GUNSHIP_TRACKING_ALTITUDE) )
        	{
        		ectrl->control_func = enemy_helicopter_tracking;
        		ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
        	}
					break;
			}

			break;
	}



}


/***************************************************************/


void	enemy_helicopter_tracking(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	ushort	pursueDecision;
	ushort	newTurnDirn;
	ushort	*waypt;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;


	switch ( ectrl->tank_mode )
	{
		case EPURSUE_MOVE_2_POINT:

			pursueDecision = get_dist_2_target_waypt();

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			switch ( pursueDecision )
			{
				case CONTINUE_MOVEMENT:
					break;

				case SLOW_DOWN:
					if ( ectrl->slow_decision_made )
					{
						break;
					}

					/* Check if target tank is still in range */

					reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
					reltz = (targetTank->z>>24) - (etank->z>>24);

					reltx *= reltx;
					reltz *= reltz;

					sqrtdist = reltx + reltz;

					if ( sqrtdist >=enemyTriggerRange[etank->def] ) 	/* No target tanks in range */
					{
						ectrl->control_func = enemy_helicopter_patroling;
						if ( ectrl->target_waypoint!=NULL_ID )
						{
							wayptChkList[ectrl->target_waypoint] = FALSE;	/*Make target waypoint available to others */
						}
						return ;
	 				}


  				/* Check to see if you can target tank */

  				if ( sqrtdist<=enemyTargettingRange[etank->def] )
  				{
  					if ( test_line_of_sight((etank->x>>24)&0xff, (etank->z>>24)&0xff,(targetTank->x>>24)&0xff,(targetTank->z>>24)&0xff) ) /* Within targetting range and can be seen */
  					{
  						ectrl->control_func = enemy_helicopter_targetting;
							ectrl->slow_decision_made = FALSE;
							ectrl->rejoin_waypoint =  ectrl->target_waypoint;
  						return ;
  					}
  				}


    			/* Look for the next possible target waypoint */

    			ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, BASIC_EXCLUSION);

    			if ( ectrl->next_target_waypoint==NULL_ID ) 		/* Couldn't find a valid target way point */
    			{
    				/* Nowhere to go */
						ectrl->control_func = enemy_helicopter_patroling;
    				return ;
    			}


					/* Get angle from current waypoint to next waypoint */

					waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					wayptx = *waypt++;
					wayptz = *waypt;

					angle2NextWaypt = (int)(phd_atan( (int)(ectrl->twayptx - wayptx), (int)(ectrl->twayptz - wayptz) ) &0x7ff);

					angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);

					if ( angle2NextWaypt < SWING_AROUND_ANGLE )
					{
						ectrl->slow_decision_made = TRUE;
						break;
					}
					else
					if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
					{
						ectrl->rejoin_waypoint = ectrl->target_waypoint;

						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = SWING_2_TARGET_POINT;

						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					else
					{
						ectrl->rejoin_waypoint = ectrl->target_waypoint;
						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = ROTATE_2_TARGET_POINT;
						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					break;


				case REACHED_TARGET:
					/* Get new target waypoint */
					ectrl->target_waypoint = ectrl->next_target_waypoint;

					/* Reset next target waypoint data */
					ectrl->next_target_waypoint = NULL_ID;

					/* Get position of target waypoint */
					waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					ectrl->twayptx = *waypt++;
					ectrl->twayptz = *waypt;

					ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

					ectrl->slow_decision_made = FALSE;

					break;
			}

			moveForwardDecision=TRUE;

			/* Check if tank has moved */

			if ( (ectrl->stillx == (etank->x>>16)) && (ectrl->stillz == (etank->z>>16)) && (ectrl->rejoin_waypoint!=NULL_ID) && (etank->speed>0x100) )
			{
				ectrl->stillCount++;
				if ( ectrl->stillCount>=STILL_THRESHOLD )
				{
					ectrl->stillCount=0;
					clear_waypoint_check(etank);
					ectrl->control_func = enemy_helicopter_patroling;
				}
			}
			else
			{
				ectrl->stillx = etank->x>>16;
				ectrl->stillz = etank->z>>16;
				ectrl->stillCount=0;
			}

			/* Readjust angle of tank if need to */

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			set_turn_decision(etank, newTurnDirn);
			break;


/********************/
		case SWING_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					return;
					break;

				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					break;

			}
			break;

/********************/


		case ROTATE_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					break;


				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;

					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;
					break;

			}
			break;

	}

}

/***************************************************************/


void	enemy_helicopter_targetting(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	ushort	*waypt;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;
	ushort	newTurnDirn;


	reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
	reltz = (targetTank->z>>24) - (etank->z>>24);

	reltx *= reltx;
	reltz *= reltz;

	sqrtdist = reltx + reltz;



	if ( sqrtdist>enemyTargettingRange[etank->def] )	/* Target gone out of range for targetting */
	{
		if ( sqrtdist > enemyTriggerRange[etank->def] ) 	/*Target out of detection range as well */
		{
 			ectrl->control_func = enemy_helicopter_patroling;
			if ( ectrl->target_waypoint!=NULL_ID )
			{
				wayptChkList[ectrl->target_waypoint] = FALSE; 	/*Make waypoint available */
			}
 			return ;
		}

		/* Need to go back into pursue mode */

		ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, USE_CURRENT_TARGET_WAYPOINT);

		if ( ectrl->next_target_waypoint==NULL_ID )
		{
			/* nowhere to go */
			//ectrl->control_func = enemy_wait_for_space;
			ectrl->control_func = enemy_helicopter_patroling;
			ectrl->slow_decision_made = FALSE;
			return ;
		}

		ectrl->target_waypoint = ectrl->next_target_waypoint;


		ectrl->next_target_waypoint = NULL_ID;

		ectrl->control_func = enemy_helicopter_tracking;
		ectrl->small_turn_count = 0;
		ectrl->slow_decision_made = FALSE;

		/* Get angle from current position to next waypoint */

		waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
		waypt++; /* skip over number links associated with waypoint */

		ectrl->twayptx = wayptx = *waypt++;
		ectrl->twayptz = wayptz = *waypt;

		angle2NextWaypt = (int)(phd_atan( (int)((etank->x>>16) - wayptx), (int)((etank->x>>16) - wayptz) ) &0x7ff);

		angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);

		ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

		if ( angle2NextWaypt < SWING_AROUND_ANGLE )
		{
			ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
		}
		else
		if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
		{
			ectrl->tank_mode = SWING_2_TARGET_POINT;
		}
		else
		{
			ectrl->tank_mode = ROTATE_2_TARGET_POINT;
		}

		return ;
	}


	if ( etank->speed>0x20 )
	{
		moveBackwardDecision=TRUE;
	}
	else
	if ( etank->speed<0x20 )
	{
		moveForwardDecision=TRUE;
	}
	else
		etank->speed=0;


	/* Rotate towards the target tank */

	ectrl->angle_2_target = (int)((phd_atan( (int) ((uint)(etank->x>>16) - (uint)(targetTank->x>>16)) , (int) ((uint)(etank->z)>>16) - (uint)(targetTank->z>>16) ) ) &0x7ff);

	newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

	set_turn_decision(etank, newTurnDirn);
}


