#include "headers.h"

#include "chuck.h"
#include "e_global.h"
#include "shokstrc.h"
#include "enemlogc.h"

/***************************************************************/

/* Hostage logic/animation */

/***************************************************************/

#define HOSTAGE_WAVE_FRAME			0
#define HOSTAGE_RUN_FRAME       7


ushort	hostageAnimFrames[2][8] =
{
	1, 2, 3, 4, 3, 2, 0, 0,
	5, 6, 7, 8, 9, 10, 11, 12
};


ushort	hostageNumAnimFrames[2] =
{
	6, 8
};



#define HOSTAGE_FRAME_RATE	8

#define HOSTAGE_RESCUE_RANGE	0x4
#define RUN_SPEED							0x3


void	do_hostages(void)
{
	int	i;
	HOSTAGE	*chostage;
	int	relx, relz;

	for ( i=0, chostage=hostages; i<MAX_HOSTAGES; i++, chostage++ )
	{
		if ( chostage->def )
		{
			/* Do hostage logic */
			switch ( chostage->mode )
			{
				case HOSTAGE_STANDING:
					relx = (int)(((uint)pl.x>>24) - ((uint)chostage->x>>24));
					relz = (int)(((uint)pl.z>>24) - ((uint)chostage->z>>24));

					if ( (abs(relx)<=HOSTAGE_RESCUE_RANGE) && (abs(relz)<=HOSTAGE_RESCUE_RANGE) && (abs(pl.speed)<0x20) )
					{
						if ( test_line_of_sight(chostage->x>>24, chostage->z>>24, pl.x>>24, pl.z>>24 ) )
						{
  						chostage->mode = HOSTAGE_RUNNING;
  						chostage->anim = HOSTAGE_RUN_ANIM;
  						chostage->angle = phd_atan( (int)(chostage->x - pl.x) , (int)(chostage->z - pl.z) ) &0x7ff;
						}
					}
					break;

				case HOSTAGE_RUNNING:
					if ( (abs(pl.speed) > 0x20) || pl.shuntSpeed ) /*If tank starts to move then hostage goes back to standing */
					{
						chostage->mode = HOSTAGE_STANDING;
						chostage->anim = HOSTAGE_STANDING_ANIM;
						return ;
					}

					relx = (int)(((uint)pl.x>>24) - ((uint)chostage->x>>24));
					relz = (int)(((uint)pl.z>>24) - ((uint)chostage->z>>24));

					if ( (abs(relx)<2) && (abs(relz)<2) ) /* Hostage got to tank - ie rescued */
					{
						chostage->def = 0;
						numHostagesLeft--;
						numHostagesCollected++;

						/*-----------------19/10/95 11:34-------------------
						 Indicate with speech that hostage has been rescued
						--------------------------------------------------*/
						if ( !start_message(DTOUR_MSG7) )
						{
							start_message(DTOUR_MSG8);
						}

						return ;
					}

					/* Run towards tank */
					chostage->x +=  (int)(RUN_SPEED * ((int)sintab[chostage->angle]));
					chostage->z +=  (int)(RUN_SPEED * ((int)sintab[chostage->angle+512]));
					break;
			}


			/* Animate hostage */
			chostage->frmDelay++;
			if ( chostage->frmDelay >= HOSTAGE_FRAME_RATE  )
			{
				chostage->frmDelay = 0;
				chostage->animframe++;
				if ( chostage->animframe >= hostageNumAnimFrames[chostage->anim]  )
				{
					chostage->animframe = 0;
				}

				chostage->frame = hostageAnimFrames[chostage->anim][chostage->animframe];
			}
		}
	}
}

